# Stefan Achatz 2012
#
# Tries to find libgmodule-2.0 and sets following variables according to found capabilities:
#
# GMODULE2_FOUND
# GMODULE2_INCLUDE_DIRS
# GMODULE2_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GMODULE2 gmodule-2.0)

FIND_PATH(GMODULE2_INCLUDE_DIRS gmodule.h
  HINTS
    ${PKG_GMODULE2_INCLUDE_DIRS}
    ${PKG_GMODULE2_INCLUDEDIR}
  PATH_SUFFIXES glib-2.0
)

FIND_LIBRARY(GMODULE2_LIBRARIES gmodule-2.0
  HINTS ${PKG_GMODULE2_LIBRARY_DIRS}
)

IF(GMODULE2_LIBRARIES AND GMODULE2_INCLUDE_DIRS)
  SET(GMODULE2_FOUND true)
ENDIF()

IF(GMODULE2_FIND_REQUIRED AND NOT GMODULE2_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GMODULE2")
ENDIF()
