/**
 * @cond doxygenLibsbmlInternal
 *
 * @file   LayoutSBMLErrorTable.h
 * @brief  Implementation of the LayoutSBMLErrorTable class
 * @author Generated by autocreate code
 *
 * <!--------------------------------------------------------------------------
 * This file is part of libSBML.  Please visit http://sbml.org for more
 * information about SBML, and the latest version of libSBML.
 *
 * Copyright (C) 2013-2018 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *     3. University of Heidelberg, Heidelberg, Germany
 * 
 * Copyright (C) 2009-2013 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. EMBL European Bioinformatics Institute (EMBL-EBI), Hinxton, UK
 *
 * Copyright (C) 2006-2008 by the California Institute of Technology,
 *     Pasadena, CA, USA 
 *
 * Copyright (C) 2002-2005 jointly by the following organizations:
 *     1. California Institute of Technology, Pasadena, CA, USA
 *     2. Japan Science and Technology Agency, Japan
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.  A copy of the license agreement is provided
 * in the file named "LICENSE.txt" included with this software distribution
 * and also available online as http://sbml.org/software/libsbml/license.html
 * ------------------------------------------------------------------------ -->
 */


#ifndef LayoutSBMLErrorTable_H__
#define LayoutSBMLErrorTable_H__


#include <sbml/packages/layout/validator/LayoutSBMLError.h>

LIBSBML_CPP_NAMESPACE_BEGIN

static const packageErrorTableEntry layoutErrorTable[] = 
{
  //6010100
  { LayoutUnknownError,
    "Unknown error from layout",
    LIBSBML_CAT_GENERAL_CONSISTENCY,
    LIBSBML_SEV_ERROR,
    "Unknown error from layout",
    { " "
    }
  },

  // 6010101
  { LayoutNSUndeclared, 
    "The layout ns is not correctly declared",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "To conform to Version 1 of the Layout "
    "package specification for SBML Level 3, an "
    "SBML document must declare the use of the following XML Namespace: "
    "'http://www.sbml.org/sbml/level3/version1/layout/version1'",
    { "L3V1 Layout V1 Section 3.1"
    }
  },

  // 6010102
  { LayoutElementNotInNs, 
    "Element not in layout namespace",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Wherever they appear in an SBML document, "
    "elements and attributes from the Layout "
    "package must be declared either implicitly or explicitly to be in the "
    "XML namespace 'http://www.sbml.org/sbml/level3/version1/layout/version1'",
    { "L3V1 Layout V1 Section 3.1"
    }
  },

    // 6010301
  { LayoutDuplicateComponentId, 
    "Duplicate 'id' attribute value",
    LIBSBML_CAT_IDENTIFIER_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "(Extends validation rule #10301 in the SBML Level 3 Version 1 Core "
    "specification.) Within a <model> object "
    "the values of the attributes id and layout:id on every instance of the "
    "following classes of objects must be unique across the set of all id "
    "and layout:id attribute values of all such objects in a model: the "
    "model itself, plus all contained <functionDefinition>, <compartment>, "
    "<species>, <reaction>, <speciesReference>, <modifierSpeciesReference>, "
    "<event>, and <parameter> objects, plus the <boundingBox>, "
    "<compartmentGlyph>, <generalGlyph>, <graphicalObject>, <layout>, "
    "<speciesGlyph>, <speciesReferenceGlyph>, <reactionGlyph>, "
    "<referenceGlyph> and <textGlyph> "
    "objects defined by the Layout package.", 
    { "L3V1 Layout V1 Section 3.3"
    }
  },

    // 6010302
  { LayoutSIdSyntax, 
    "'id' attribute incorrect syntax",
    LIBSBML_CAT_IDENTIFIER_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:id' attribute must conform to the SBML "
    "data type SId", 
    { "L3V1 Layout V1 Section 3.3"
    }
  },

    // 6010401
  { LayoutXsiTypeAllowedLocations, 
    "'xsi:type' allowed locations",
    LIBSBML_CAT_IDENTIFIER_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'xsi:type' must be present on all <lineSegment> and "
    "<cubicBezier> objects. It is not permitted on any other elements "
    "from the SBML Level 3 Layout namespace.", 
    { "L3V1 Layout V1 Section 3.3"
    }
  },

    // 6010402
  { LayoutXsiTypeSyntax, 
    "'xsi:type' attribute incorrect syntax",
    LIBSBML_CAT_IDENTIFIER_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'xsi:type' attribute must be either 'LineSegment' or "
    "'CubicBezier' appropriate to the object where it is located. No other "
    "values are permitted.",
    { "L3V1 Layout V1 Section 3.3"
    }
  },

  // 6020101
  { LayoutAttributeRequiredMissing, 
    "Required layout:required attribute on <sbml>",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "In all SBML documents using the Layout "
    "package, the SBML object must include a value for the attribute "
    "'layout:required'.",
    { "L3V1 Core Section 4.1.2"
    }
  },

  // 6020102
  { LayoutAttributeRequiredMustBeBoolean, 
    "The layout:required attribute must be Boolean",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of attribute 'layout:required' on the SBML object must "
    "be of the data type Boolean.",
    { "L3V1 Core Section 4.1.2"
    }
  },

  // 6020103
  { LayoutRequiredFalse, 
    "The layout:required attribute must be 'false'",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of attribute 'layout:required' on the SBML object must "
    "be set to 'false'.",
    { "L3V1 Layout V1 Section 3.1"
    }
  },

  // 6020201
  { LayoutOnlyOneLOLayouts, 
    "Only one listOfLayouts on <model>",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of <listOfLayouts> element within "
    "a <model> object using Layout. No other elements from the Layout "
    "package are allowed.",
    { "L3V1 Layout V1 Section 3.5"
    }
  },

  // 6020202
  { LayoutLOLayoutsNotEmpty, 
    "ListOf elements cannot be empty",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The <listOfLayouts> within a <model> object is optional, "
    "but if present, this object must not be empty.",
    { "L3V1 Layout V1 Section 3.5"
    }
  },

  // 6020203
  { LayoutLOLayoutsAllowedElements, 
    "Allowed elements on ListOfLayouts",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted on "
    "all SBML objects, a <listOfLayouts> container object may only "
    "contain <layout> objects.",
    { "L3V1 Layout V1 Section 3.5"
    }
  },

  // 6020204
  { LayoutLOLayoutsAllowedAttributes, 
    "Allowed attributes on ListOfLayouts",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfLayouts> object may have the optional attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core. No other attributes from "
    "the SBML Level 3 Core namespace or the Layout "
    "namespace are permitted on a <listOfLayouts> object. ",
    { "L3V1 Layout V1 Section 3.5"
    }
  },

  // 6020301
  { LayoutLayoutAllowedElements, 
    "Allowed elements on Layout",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <layout> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from "
    "the SBML Level 3 Core namespace are permitted on a <layout>.",
    { "L3V1 Core Section 3.2"
    }
  },

  // 6020302
  { LayoutLayoutAllowedCoreAttributes, 
    "Allowed core attributes on Layout",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <layout> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from "
    "the SBML Level 3 Core namespace are permitted on a <layout> object. ",
    { "L3V1 Core Section 3.2"
    }
  },

  // 6020303
  { LayoutOnlyOneEachListOf, 
    "Only one each listOf on <layout>",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of each of the following kinds "
    "of objects within a <layout> object: <listOfCompartmentGlyphs>, "
    "<listOfSpeciesGlyphs>, <listOfReactionGlyphs>, "
    "<listOfTextGlyphs>, <listOfAdditionalGraphicalObjects>.",
    { "L3V1 Layout V1 Section 3.6"
    }
  },

  // 6020304
  { LayoutNoEmptyListOfs, 
    "ListOf elements cannot be empty",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The various ListOf subobjects within a <layout> object are "
    "optional, but if present, these container object must not be "
    "empty.  Specifically, if any of the following classes of objects "
    "are present on the <layout>, it must not be empty: "
    "<listOfCompartmentGlyphs>, <listOfSpeciesGlyphs>, <listOfReactionGlyphs>, "
    "<listOfTextGlyphs>, <listOfAdditionalGraphicalObjects>.",
    { "L3V1 Layout V1 Section 3.6"
    }
  },

  // 6020305
  { LayoutLayoutAllowedAttributes, 
    "<layout> must have 'id' and may have 'name'",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <layout> object must have the required attribute 'layout:id' and may "
    "have the optional attribute 'layout:name'. No other attributes from the "
    "SBML Level 3 Layout namespace are permitted on a <layout> object.",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020306
  { LayoutLayoutNameMustBeString, 
    "'name' must be string",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:name' of a <layout> must be of the data "
    "type 'string'.",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020307
  { LayoutLOCompGlyphAllowedAttributes, 
    "Attributes allowed on <listOfCompartmentGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfCompartmentGlyphs> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core.  No other attributes "
    "from the SBML Level 3 Core namespace or the Layout namespace are "
    "permitted on a <listOfCompartmentGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020308
  { LayoutLOCompGlyphAllowedElements, 
    "Elements allowed on <listOfCompartmentGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted "
    "on all SBML objects, a <listOfCompartmentGlyphs> container object "
    "may only contain <compartmentGlyph> objects. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020309
  { LayoutLOSpeciesGlyphAllowedAttributes, 
    "Attributes allowed on <listOfSpeciesGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfSpeciesGlyphs> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core.  No other attributes "
    "from the SBML Level 3 Core namespace or the Layout namespace are "
    "permitted on a <listOfSpeciesGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020310
  { LayoutLOSpeciesGlyphAllowedElements, 
    "Elements allowed on <listOfSpeciesGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted "
    "on all SBML objects, a <listOfSpeciesGlyphs> container object "
    "may only contain <compartmentGlyph> objects. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020311
  { LayoutLORnGlyphAllowedAttributes, 
    "Attributes allowed on <listOfReactionGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfReactionGlyphs> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core.  No other attributes "
    "from the SBML Level 3 Core namespace or the Layout namespace are "
    "permitted on a <listOfReactionGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020312
  { LayoutLORnGlyphAllowedElements, 
    "Elements allowed on <listOfReactionGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted "
    "on all SBML objects, a <listOfReactionGlyphs> container object "
    "may only contain <compartmentGlyph> objects. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020313
  { LayoutLOAddGOAllowedAttribut, 
    "Attributes allowed on <listOfAdditionalGraphicalObjectGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfAdditionalGraphicalObjectGlyphs> object may have the "
    "optional attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core.  No other attributes "
    "from the SBML Level 3 Core namespace or the Layout namespace are "
    "permitted on a <listOfAdditionalGraphicalObjectGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020314
  { LayoutLOAddGOAllowedElements, 
    "Elements allowed on <listOfAdditionalGraphicalObjectGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted "
    "on all SBML objects, a <listOfAdditionalGraphicalObjectGlyphs> container object "
    "may only contain <compartmentGlyph> objects. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020315
  { LayoutLayoutMustHaveDimensions, 
    "Layout must have <dimensions>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <layout> object must contain exactly one <dimensions> object.",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
 
  // 6020316
  { LayoutLOTextGlyphAllowedAttributes, 
    "Attributes allowed on <listOfTextGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfTextGlyphs> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core.  No other attributes "
    "from the SBML Level 3 Core namespace or the Layout namespace are "
    "permitted on a <listOfTextGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020317
  { LayoutLOTextGlyphAllowedElements, 
    "Elements allowed on <listOfTextGlyphs>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted "
    "on all SBML objects, a <listOfTextGlyphs> container object "
    "may only contain <compartmentGlyph> objects. ",
    { "L3V1 Layout V1 Section 3.6"
    }
  },
  
  // 6020401
  { LayoutGOAllowedCoreElements, 
    "Core elements allowed on <graphicalObject>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <graphicalObject> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <graphicalObject>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020402
  { LayoutGOAllowedCoreAttributes, 
    "Core attributes allowed on <graphicalObject>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <graphicalObject> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <graphicalObject>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020403
  { LayoutGOAllowedElements, 
    "Layout elements allowed on <graphicalObject>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of a <boundingBox> object on a "
    "<graphicalObject>.  No other elements from the Layout namespace "
    "are permitted on a <graphicalObject>. ",
    { "L3V1 Layout V1 Section 3.7"
    }
  },
  
  // 6020404
  { LayoutGOAllowedAttributes, 
    "Layout attributes allowed on <graphicalObject>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <graphicalObject> object must have the required attribute "
    "'layout:id' and may have the optional attribute 'layout:metaidRef'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <graphicalObject>. ",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020405
  { LayoutGOMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <graphicalObject> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020406
  { LayoutGOMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <graphicalObject> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020407
  { LayoutGOMustContainBoundingBox, 
    "A <graphicalObject> must contain a <boundingBox>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <graphicalObject> must contain exactly one <boundingBox> object.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  
  // 6020501
  { LayoutCGAllowedCoreElements, 
    "Core elements allowed on <compartmentGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <compartmentGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <compartmentGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020502
  { LayoutCGAllowedCoreAttributes, 
    "Core attributes allowed on <compartmentGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <compartmentGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <compartmentGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020503
  { LayoutCGAllowedElements, 
    "Layout elements allowed on <compartmentGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of a <boundingBox> object on a "
    "<compartmentGlyph>.  No other elements from the Layout namespace "
    "are permitted on a <compartmentGlyph>. ",
    { "L3V1 Layout V1 Section 3.8"
    }
  },
  
  // 6020504
  { LayoutCGAllowedAttributes, 
    "Layout attributes allowed on <compartmentGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <compartmentGlyph> object must have the required attribute "
    "'layout:id' and may have the optional attributes 'layout:metaidRef' "
    "or 'layout:compartment'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <compartmentGlyph>. ",
    { "L3V1 Layout V1 Section 3.8"
    }
  },

  // 6020505
  { LayoutCGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <compartmentGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020506
  { LayoutCGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <compartmentGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020507
  { LayoutCGCompartmentSyntax, 
    "CompartmentGlyph 'compartment' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:compartment' of a <compartmentGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.8"
    }
  },

  // 6020508
  { LayoutCGCompartmentMustRefComp, 
    "CompartmentGlyph compartment must reference existing compartment.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:compartment' attribute of a <compartmentGlyph> "
    "must be of the 'id' of an existing <compartment> in the <model>.",
    { "L3V1 Layout V1 Section 3.8"
    }
  },

  // 6020509
  { LayoutCGNoDuplicateReferences, 
    "CompartmentGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:compartment' and 'layout:metaidRef' "
    "are specified on a <compartmentGlyph> they have to reference "
    "the same <compartment> in the <model>.",
    { "L3V1 Layout V1 Section 3.8"
    }
  },

  // 6020510
  { LayoutCGOrderMustBeDouble, 
    "CompartmentGlyph order must be double.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:order' of a <compartmentGlyph> "
    "must be the data type 'double'.",
    { "L3V1 Layout V1 Section 3.8"
    }
  },

  // 6020601
  { LayoutSGAllowedCoreElements, 
    "Core elements allowed on <speciesGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <speciesGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020602
  { LayoutSGAllowedCoreAttributes, 
    "Core attributes allowed on <speciesGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <speciesGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020603
  { LayoutSGAllowedElements, 
    "Layout elements allowed on <speciesGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of a <boundingBox> object on a "
    "<speciesGlyph>.  No other elements from the Layout namespace "
    "are permitted on a <speciesGlyph>. ",
    { "L3V1 Layout V1 Section 3.9"
    }
  },
  
  // 6020604
  { LayoutSGAllowedAttributes, 
    "Layout attributes allowed on <speciesGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesGlyph> object must have the required attribute "
    "'layout:id' and may have the optional attributes 'layout:metaidRef' "
    "or 'layout:species'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <speciesGlyph>. ",
    { "L3V1 Layout V1 Section 3.9"
    }
  },

  // 6020605
  { LayoutSGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <speciesGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020606
  { LayoutSGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <speciesGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020607
  { LayoutSGSpeciesSyntax, 
    "SpeciesGlyph 'species' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:species' of a <speciesGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.9"
    }
  },

  // 6020608
  { LayoutSGSpeciesMustRefSpecies, 
    "SpeciesGlyph species must reference existing species.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:species' attribute of a <speciesGlyph> "
    "must be of the 'id' of an existing <species> in the <model>.",
    { "L3V1 Layout V1 Section 3.8"
    }
  },

  // 6020609
  { LayoutSGNoDuplicateReferences, 
    "SpeciesGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:species' and 'layout:metaidRef' "
    "are specified on a <speciesGlyph> they have to reference "
    "the same <species> in the <model>.",
    { "L3V1 Layout V1 Section 3.9"
    }
  },

  // 6020701
  { LayoutRGAllowedCoreElements, 
    "Core elements allowed on <reactionGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <reactionGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <reactionGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020702
  { LayoutRGAllowedCoreAttributes, 
    "Core attributes allowed on <reactionGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <reactionGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <reactionGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020703
  { LayoutRGAllowedElements, 
    "Layout elements allowed on <reactionGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of each of the following kinds "
    "of objects within a <reactionGlyph> object: <boundingBox>, "
    "and <curve> and there must be one instance of the "
    "<listOfSpeciesReferenceGlyphs>. No other elements from "
    "the Layout namespace are permitted on a <reactionGlyph>. ",
    { "L3V1 Layout V1 Section 3.10"
    }
  },
  
  // 6020704
  { LayoutRGAllowedAttributes, 
    "Layout attributes allowed on <reactionGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <reactionGlyph> object must have the required attribute "
    "'layout:id' and may have the optional attributes 'layout:metaidRef' "
    "or 'layout:reaction'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <reactionGlyph>. ",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020705
  { LayoutRGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <reactionGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020706
  { LayoutRGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <reactionGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020707
  { LayoutRGReactionSyntax, 
    "ReactionGlyph 'reaction' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:reaction' of a <reactionGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020708
  { LayoutRGReactionMustRefReaction, 
    "ReactionGlyph reaction must reference existing reaction.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:reaction' attribute of a <reactionGlyph> "
    "must be of the 'id' of an existing <reaction> in the <model>.",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020709
  { LayoutRGNoDuplicateReferences, 
    "ReactionGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:reaction' and 'layout:metaidRef' "
    "are specified on a <reactionGlyph> they have to reference "
    "the same <reaction> in the <model>.",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020710
  { LayoutLOSpeciesRefGlyphAllowedElements, 
    "Allowed elements on ListOfSpeciesReferenceGlyphs",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted on "
    "all SBML objects, a <listOfSpeciesReferenceGlyphs> container object "
    "may only contain <speciesReferenceGlyph> objects.",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020711
  { LayoutLOSpeciesRefGlyphAllowedAttribs, 
    "Allowed attributes on ListOfSpeciesReferenceGlyphs",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfSpeciesReferenceGlyphs> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core. No other attributes from "
    "the SBML Level 3 Core namespace or the Layout "
    "namespace are permitted on a <listOfSpeciesReferenceGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020712
  { LayoutLOSpeciesRefGlyphNotEmpty, 
    "ListOfSpeciesReferenceGlyphs not empty",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfSpeciesReferenceGlyphs> container object must not be empty. ",
    { "L3V1 Layout V1 Section 3.10"
    }
  },

  // 6020801
  { LayoutGGAllowedCoreElements, 
    "Core elements allowed on <generalGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <generalGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <generalGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020802
  { LayoutGGAllowedCoreAttributes, 
    "Core attributes allowed on <generalGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <generalGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <generalGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020803
  { LayoutGGAllowedElements, 
    "Layout elements allowed on <generalGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of each of the following kinds "
    "of objects within a <generalGlyph> object: <boundingBox>, "
    "<curve>, <listOfReferenceGlyphs> and <listOfSubGlyphs>. "
    "No other elements from "
    "the Layout namespace are permitted on a <generalGlyph>. ",
    { "L3V1 Layout V1 Section 3.11"
    }
  },
  
  // 6020804
  { LayoutGGAllowedAttributes, 
    "Layout attributes allowed on <generalGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <generalGlyph> object must have the required attribute "
    "'layout:id' and may have the optional attributes 'layout:metaidRef' "
    "or 'layout:reference'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <generalGlyph>. ",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020805
  { LayoutGGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <generalGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020806
  { LayoutGGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <generalGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020807
  { LayoutGGReferenceSyntax, 
    "GeneralGlyph 'reference' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:reference' of a <generalGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020808
  { LayoutGGReferenceMustRefObject, 
    "GeneralGlyph 'reference' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:reference' attribute of a <generalGlyph> "
    "must be of the 'id' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020809
  { LayoutGGNoDuplicateReferences, 
    "GeneralGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:reference' and 'layout:metaidRef' "
    "are specified on a <generalGlyph> they have to reference "
    "the same element in the <model>.",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020810
  { LayoutLOReferenceGlyphAllowedElements, 
    "Allowed elements on ListOfReferenceGlyphs",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted on "
    "all SBML objects, a <listOfReferenceGlyphs> container object "
    "may only contain <referenceGlyph> objects.",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020811
  { LayoutLOReferenceGlyphAllowedAttribs, 
    "Allowed attributes on ListOfReferenceGlyphs",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfReferenceGlyphs> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core. No other attributes from "
    "the SBML Level 3 Core namespace or the Layout "
    "namespace are permitted on a <listOfReferenceGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020812
  { LayoutLOSpeciesRefGlyphAllowedElements, 
    "Allowed elements on ListOfSubGlyphs",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted on "
    "all SBML objects, a <listOfSubGlyphs> container object "
    "may only contain <compartmentGlyph>, <speciesGlyph>, <reactionGlyph>, "
    "<generalGlyph>, <graphicalObject>, <textGlyph>, <speciesReferenceGlyph> "
    "and <referenceGlyph> objects.",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020813
  { LayoutLOSubGlyphAllowedAttribs, 
    "Allowed attributes on ListOfSubGlyphs",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfSubGlyphs> object may have the optional attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core. No other attributes from "
    "the SBML Level 3 Core namespace or the Layout "
    "namespace are permitted on a <listOfSubGlyphs> object. ",
    { "L3V1 Layout V1 Section 3.11"
    }
  },

  // 6020901
  { LayoutTGAllowedCoreElements, 
    "Core elements allowed on <textGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <textGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <textGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020902
  { LayoutTGAllowedCoreAttributes, 
    "Core attributes allowed on <textGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <textGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <textGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6020903
  { LayoutTGAllowedElements, 
    "Layout elements allowed on <textGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <textGlyph> must contain exactly one <boundingBox> object. "
    "No other elements from "
    "the Layout namespace are permitted on a <textGlyph>. ",
    { "L3V1 Layout V1 Section 3.12"
    }
  },
  
  // 6020904
  { LayoutTGAllowedAttributes, 
    "Layout attributes allowed on <textGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <textGlyph> object must have the required attribute "
    "'layout:id' and may have the optional attributes 'layout:metaidRef', "
    "'layout:graphicalObject', 'layout:text' and 'layout:originOfText'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <textGlyph>. ",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6020905
  { LayoutTGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <textGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020906
  { LayoutTGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <textGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6020907
  { LayoutTGOriginOfTextSyntax, 
    "TextGlyph 'originOfText' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:originOfText' of a <textGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6020908
  { LayoutTGOriginOfTextMustRefObject, 
    "TextGlyph 'originOfText' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:originOfText' attribute of a <textGlyph> "
    "must be of the 'id' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6020909
  { LayoutTGNoDuplicateReferences, 
    "TextGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:originOfText' and 'layout:metaidRef' "
    "are specified on a <textGlyph> they have to reference "
    "the same element in the <model>.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6020910
  { LayoutTGGraphicalObjectSyntax, 
    "TextGlyph 'graphicalObject' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:graphicalObject' of a <textGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6020911
  { LayoutTGGraphicalObjectMustRefObject, 
    "TextGlyph 'graphicalObject' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:graphicalObject' attribute of a <textGlyph> "
    "must be of the 'id' of an existing <graphicalObject> (or derived) "
    "element in the <layout>.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6020912
  { LayoutTGTextMustBeString, 
    "TextGlyph 'text' must be string.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:text' of a <textGlyph> "
    "must be the data type 'string'.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6021001
  { LayoutSRGAllowedCoreElements, 
    "Core elements allowed on <speciesReferenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesReferenceGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <speciesReferenceGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021002
  { LayoutSRGAllowedCoreAttributes, 
    "Core attributes allowed on <speciesReferenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesReferenceGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <speciesReferenceGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021003
  { LayoutSRGAllowedElements, 
    "Layout elements allowed on <speciesReferenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesReferenceGlyph> may have at most one instance of a "
    "<boundingBox> and <curve> object. "
    "No other elements from "
    "the Layout namespace are permitted on a <speciesReferenceGlyph>. ",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },
  
  // 6021004
  { LayoutSRGAllowedAttributes, 
    "Layout attributes allowed on <speciesReferenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <speciesReferenceGlyph> object must have the required attribute "
    "'layout:id' and may have the optional attributes 'layout:metaidRef', "
    "'layout:speciesReference' and 'layout:role'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <speciesReferenceGlyph>. ",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },

  // 6021005
  { LayoutSRGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <speciesReferenceGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6021006
  { LayoutSRGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <speciesReferenceGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6021007
  { LayoutSRGSpeciesReferenceSyntax, 
    "SpeciesReferenceGlyph 'speciesReference' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:speciesReference' of a <speciesReferenceGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },

  // 6021008
  { LayoutSRGSpeciesRefMustRefObject, 
    "SpeciesReferenceGlyph 'speciesReference' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:speciesReference' attribute of a "
    "<speciesReferenceGlyph> "
    "must be of the 'id' of an existing <speciesReference> in the <model>.",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },

  // 6021009
  { LayoutSRGNoDuplicateReferences, 
    "SpeciesReferenceGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:speciesReference' and 'layout:metaidRef' "
    "are specified on a <speciesReferenceGlyph> they have to reference "
    "the same <speciesReference> in the <model>.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6021010
  { LayoutSRGSpeciesGlyphSyntax, 
    "SpeciesReferenceGlyph 'speciesGlyph' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:speciesGlyph' of a <speciesReferenceGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },

  // 6021011
  { LayoutSRGSpeciesGlyphMustRefObject, 
    "SpeciesReferenceGlyph 'speciesGlyph' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:speciesGlyph' attribute of a "
    "<speciesReferenceGlyph> "
    "must be of the 'id' of an existing <speciesGlyph> "
    "element in the <layout>.",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },

  // 6021012
  { LayoutSRGRoleSyntax, 
    "SpeciesReferenceGlyph 'role' must be string from enumeration.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:role' of a <speciesReferenceGlyph> "
    "must be of data type 'SpeciesReferenceRole', i.e. it must have one "
    "of the following values: substrate, product, sidesubstrate, sideproduct, "
    "modifier, activator, inhibitor or undefined.",
    { "L3V1 Layout V1 Section 3.10.1"
    }
  },

  // 6021101
  { LayoutREFGAllowedCoreElements, 
    "Core elements allowed on <referenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <referenceGlyph> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <referenceGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021102
  { LayoutREFGAllowedCoreAttributes, 
    "Core attributes allowed on <referenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <referenceGlyph> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <referenceGlyph>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021103
  { LayoutREFGAllowedElements, 
    "Layout elements allowed on <referenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There may be at most one instance of a <boundingBox> and "
    "<curve> object on a <referenceGlyph>. "
    "No other elements from "
    "the Layout namespace are permitted on a <referenceGlyph>. ",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },
  
  // 6021104
  { LayoutREFGAllowedAttributes, 
    "Layout attributes allowed on <referenceGlyph>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <referenceGlyph> object must have the required attributes "
    "'layout:id' and 'layout:glyph' and may have the optional attributes "
    "'layout:metaidRef', "
    "'layout:reference' and 'layout:role'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <referenceGlyph>. ",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },

  // 6021105
  { LayoutREFGMetaIdRefMustBeIDREF, 
    "Layout 'metaidRef' must be IDREF.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:metaidRef' of a <referenceGlyph> "
    "must be of the data type 'IDREF'.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6021106
  { LayoutREFGMetaIdRefMustReferenceObject, 
    "Layout 'metaidRef' must reference existing object.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of a 'layout:metaidRef' attribute of a <referenceGlyph> "
    "must be of the 'metaid' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6021107
  { LayoutREFGReferenceSyntax, 
    "ReferenceGlyph 'reference' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:reference' of a <referenceGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },

  // 6021108
  { LayoutREFGReferenceMustRefObject, 
    "ReferenceGlyph 'reference' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:reference' attribute of a "
    "<referenceGlyph> "
    "must be of the 'id' of an existing element in the <model>.",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },

  // 6021109
  { LayoutREFGNoDuplicateReferences, 
    "ReferenceGlyph cannot reference two objects.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If both attributes 'layout:reference' and 'layout:metaidRef' "
    "are specified on a <referenceGlyph> they have to reference "
    "the same element in the <model>.",
    { "L3V1 Layout V1 Section 3.12"
    }
  },

  // 6021110
  { LayoutREFGGlyphSyntax, 
    "ReferenceGlyph 'glyph' must have SIdRef syntax.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:glyph' of a <referenceGlyph> "
    "must be the data type 'SIdRef'.",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },

  // 6021111
  { LayoutREFGGlyphMustRefObject, 
    "ReferenceGlyph 'glyph' must reference existing element.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The value of the 'layout:glyph' attribute of a "
    "<referenceGlyph> "
    "must be of the 'id' of an existing <graphicalObject> (or derived) "
    "element in the <layout>.",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },

  // 6021112
  { LayoutREFGRoleSyntax, 
    "ReferenceGlyph 'role' must be string.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attribute 'layout:role' of a <referenceGlyph> "
    "must be the data type 'string'.",
    { "L3V1 Layout V1 Section 3.11.1"
    }
  },

  // 6021201
  { LayoutPointAllowedCoreElements, 
    "Core elements allowed on <point>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <point> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <point>. It should be noted "
    "that the 'point' object may occur as a <position>, <basePoint1>, "
    "<basePoint2>, <start> or <end> element.",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021202
  { LayoutPointAllowedCoreAttributes, 
    "Core attributes allowed on <point>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <point> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <point>.  It should be noted "
    "that the 'point' object may occur as a <position>, <basePoint1>, "
    "<basePoint2>, <start> or <end> element.",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021203
  { LayoutPointAllowedAttributes, 
    "Layout attributes allowed on <point>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <point> object must have the required attributes 'layout:x' and "
    "'layout:y' and may have the optional attributes 'layout:id', "
    "and 'layout:z'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <point>.   It should be noted "
    "that the 'point' object may occur as a <position>, <basePoint1>, "
    "<basePoint2>, <start> or <end> element.",
    { "L3V1 Layout V1 Section 3.4.1"
    }
  },

  // 6021204
  { LayoutPointAttributesMustBeDouble, 
    "Layout 'x', 'y' and 'z' must be double.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attributes 'layout:x', 'layout:y' and 'layout:z' of a <point> "
    "element must be of the data type 'double'. It should be noted "
    "that the 'point' object may occur as a <position>, <basePoint1>, "
    "<basePoint2>, <start> or <end> element.",
    { "L3V1 Layout V1 Section 3.4.1"
    }
  },

  // 6021301
  { LayoutBBoxAllowedCoreElements, 
    "Core elements allowed on <boundingBox>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <boundingBox> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <boundingBox>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021302
  { LayoutBBoxAllowedCoreAttributes, 
    "Core attributes allowed on <boundingBox>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <boundingBox> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <boundingBox>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021303
  { LayoutBBoxAllowedElements, 
    "Layout elements allowed on <boundingBox>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There must be exactly one instance of a <point> and a <dimensions> "
    "object on a <boundingBox>. "
    "No other elements from "
    "the Layout namespace are permitted on a <boundingBox>. It should be noted "
    "that the 'point' object will occur as a <position> element.",
    { "L3V1 Layout V1 Section 3.4.3"
    }
  },
  
  // 6021304
  { LayoutBBoxAllowedAttributes, 
    "Layout attributes allowed on <boundingBox>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <boundingBox> object may have the optional attributes 'layout:id'. "
    "No other attributes from the Layout namespace "
    "are permitted on a <boundingBox>. ",
    { "L3V1 Layout V1 Section 3.4.3"
    }
  },

  // 6021305
  { LayoutBBoxConsistent3DDefinition, 
    "Layout consistent dimensions on a <boundingBox>",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "If the 'layout:z' attribute on a <point> element of a <boundingBox> "
    "is not specified, the attribute 'layout:depth' must not be specified. "
    "It should be noted "
    "that the 'point' object will occur as a <position> element.",
    { "L3V1 Layout V1 Section 3.7"
    }
  },

  // 6021401
  { LayoutCurveAllowedCoreElements, 
    "Core elements allowed on <curve>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <curve> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <curve>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021402
  { LayoutCurveAllowedCoreAttributes, 
    "Core attributes allowed on <curve>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <curve> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <curve>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021403
  { LayoutCurveAllowedElements, 
    "Layout elements allowed on <curve>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "There must be exactly one instance of a <listOfCurveSegments> "
    "object on a <curve>. "
    "No other elements from "
    "the Layout namespace are permitted on a <curve>. ",
    { "L3V1 Layout V1 Section 3.4.4"
    }
  },
  
  // 6021404
  { LayoutCurveAllowedAttributes, 
    "Layout attributes allowed on <curve>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "No attributes from the Layout namespace "
    "are permitted on a <curve>. ",
    { "L3V1 Layout V1 Section 3.4.4"
    }
  },

  // 6021405
  { LayoutLOCurveSegsAllowedAttributes, 
    "Allowed attributes on ListOfCurveSegments",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfCurveSegments> object may have the optional "
    "attributes 'metaid' "
    "and 'sboTerm' defined by SBML Level 3 Core. No other attributes from "
    "the SBML Level 3 Core namespace or the Layout "
    "namespace are permitted on a <listOfCurveSegments> object. ",
    { "L3V1 Layout V1 Section 3.4.4"
    }
  },

  // 6021406
  { LayoutLOCurveSegsAllowedElements, 
    "Allowed elements on ListOfCurveSegments",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "Apart from the general notes and annotation subobjects permitted on "
    "all SBML objects, a <listOfCurveSegments> container object "
    "may only contain <referenceGlyph> objects.",
    { "L3V1 Layout V1 Section 3.4.4"
    }
  },

  // 6021407
  { LayoutLOCurveSegsNotEmpty, 
    "No empty ListOfCurveSegments",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <listOfCurveSegments> container object may not be empty.",
    { "L3V1 Layout V1 Section 3.4.4"
    }
  },

  // 6021501
  { LayoutLSegAllowedCoreElements, 
    "Core elements allowed on <lineSegment>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <lineSegment> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <lineSegment>.  It should "
    "be noted that a 'lineSegment' occurs as a <curveSegment> element with "
    "type 'LineSegment' or 'CubicBezier'.",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021502
  { LayoutLSegAllowedCoreAttributes, 
    "Core attributes allowed on <lineSegment>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <lineSegment> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <lineSegment>. It should "
    "be noted that a 'lineSegment' occurs as a <curveSegment> element with "
    "type 'LineSegment' or 'CubicBezier'.",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021503
  { LayoutLSegAllowedElements, 
    "Layout elements allowed on <lineSegment>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <lineSegment> must specify two <point> elements 'start' "
    "and 'end'. "
    "No other elements from "
    "the Layout namespace are permitted on a <lineSegment>.  It should "
    "be noted that a 'lineSegment' occurs as a <curveSegment> element with "
    "type 'LineSegment' or 'CubicBezier'.",
    { "L3V1 Layout V1 Section 3.4.5"
    }
  },
  
  // 6021504
  { LayoutLSegAllowedAttributes, 
    "Layout attributes allowed on <lineSegment>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "No attributes from the Layout namespace "
    "are permitted on a <lineSegment>.  It should "
    "be noted that a 'lineSegment' occurs as a <curveSegment> element with "
    "type 'LineSegment' or 'CubicBezier'.",
    { "L3V1 Layout V1 Section 3.4.5"
    }
  },

  // 6021601
  { LayoutCBezAllowedCoreElements, 
    "Core elements allowed on <cubicBezier>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <cubicBezier> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <cubicBezier>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021602
  { LayoutCBezAllowedCoreAttributes, 
    "Core attributes allowed on <cubicBezier>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <cubicBezier> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <cubicBezier>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021603
  { LayoutCBezAllowedElements, 
    "Layout elements allowed on <cubicBezier>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <cubicBezier> must specify four <point> elements 'start' "
    "'basePoint1', 'basePoint2' and 'end'. "
    "No other elements from "
    "the Layout namespace are permitted on a <cubicBezier>. ",
    { "L3V1 Layout V1 Section 3.4.6"
    }
  },
  
  // 6021604
  { LayoutCBezAllowedAttributes, 
    "Layout attributes allowed on <cubicBezier>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "No attributes from the Layout namespace "
    "are permitted on a <cubicBezier>. ",
    { "L3V1 Layout V1 Section 3.4.6"
    }
  },

  // 6021701
  { LayoutDimsAllowedCoreElements, 
    "Core elements allowed on <dimensions>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <dimensions> object may have the optional SBML Level 3 Core "
    "subobjects for notes and annotations. No other elements from the SBML "
    "Level 3 Core namespace are permitted on a <dimensions>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021702
  { LayoutDimsAllowedCoreAttributes, 
    "Core attributes allowed on <dimensions>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <dimensions> object may have the optional SBML Level 3 Core "
    "attributes 'metaid' and 'sboTerm'. No other attributes from the SBML "
    "Level 3 Core namespace are permitted on a <dimensions>. ",
    { "L3V1 Core Section 3.2"
    }
  },
  
  // 6021703
  { LayoutDimsAllowedAttributes, 
    "Layout attributes allowed on <dimensions>.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "A <dimensions> object must have the required attributes 'layout:width' "
    "and 'layout:height' and may have the optional attributes 'layout:id', "
    "and 'layout:depth'.  "
    "No other attributes from the Layout namespace "
    "are permitted on a <dimensions>. ",
    { "L3V1 Layout V1 Section 3.4.2"
    }
  },

  // 6021704
  { LayoutDimsAttributesMustBeDouble, 
    "Layout 'width', 'height' and 'depth' must be double.",
    LIBSBML_CAT_GENERAL_CONSISTENCY, 
    LIBSBML_SEV_ERROR,
    "The attributes 'layout:width', 'layout:height' and 'layout:depth' "
    "of a <dimensions> "
    "element must be of the data type 'double'.",
    { "L3V1 Layout V1 Section 3.4.2"
    }
  }
};


LIBSBML_CPP_NAMESPACE_END

#endif  /*  LayoutSBMLErrorTable_h__  */
/** @endcond */
