"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Auckland"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Auckland", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Auckland", { abbr: true }),

	"1927" : helpers.makeTestYear("Pacific/Auckland", [
		["1927-11-05T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1927-11-05T14:30:00+00:00", "03:00:00", "NZST", -750]
	]),

	"1928" : helpers.makeTestYear("Pacific/Auckland", [
		["1928-03-03T13:29:59+00:00", "01:59:59", "NZST", -750],
		["1928-03-03T13:30:00+00:00", "01:00:00", "NZMT", -690],
		["1928-10-13T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1928-10-13T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1929" : helpers.makeTestYear("Pacific/Auckland", [
		["1929-03-16T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1929-03-16T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1929-10-12T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1929-10-12T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1930" : helpers.makeTestYear("Pacific/Auckland", [
		["1930-03-15T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1930-03-15T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1930-10-11T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1930-10-11T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1931" : helpers.makeTestYear("Pacific/Auckland", [
		["1931-03-14T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1931-03-14T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1931-10-10T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1931-10-10T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1932" : helpers.makeTestYear("Pacific/Auckland", [
		["1932-03-19T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1932-03-19T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1932-10-08T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1932-10-08T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1933" : helpers.makeTestYear("Pacific/Auckland", [
		["1933-03-18T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1933-03-18T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1933-10-07T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1933-10-07T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1934" : helpers.makeTestYear("Pacific/Auckland", [
		["1934-04-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1934-04-28T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1934-09-29T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1934-09-29T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1935" : helpers.makeTestYear("Pacific/Auckland", [
		["1935-04-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1935-04-27T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1935-09-28T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1935-09-28T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1936" : helpers.makeTestYear("Pacific/Auckland", [
		["1936-04-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1936-04-25T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1936-09-26T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1936-09-26T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1937" : helpers.makeTestYear("Pacific/Auckland", [
		["1937-04-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1937-04-24T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1937-09-25T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1937-09-25T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1938" : helpers.makeTestYear("Pacific/Auckland", [
		["1938-04-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1938-04-23T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1938-09-24T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1938-09-24T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1939" : helpers.makeTestYear("Pacific/Auckland", [
		["1939-04-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1939-04-29T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1939-09-23T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1939-09-23T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1940" : helpers.makeTestYear("Pacific/Auckland", [
		["1940-04-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1940-04-27T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1940-09-28T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1940-09-28T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1945" : helpers.makeTestYear("Pacific/Auckland", [
		["1945-12-31T11:59:59+00:00", "23:59:59", "NZST", -720],
		["1945-12-31T12:00:00+00:00", "00:00:00", "NZST", -720]
	]),

	"1974" : helpers.makeTestYear("Pacific/Auckland", [
		["1974-11-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1974-11-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1975" : helpers.makeTestYear("Pacific/Auckland", [
		["1975-02-22T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1975-02-22T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1975-10-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1975-10-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1976" : helpers.makeTestYear("Pacific/Auckland", [
		["1976-03-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1976-03-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1976-10-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1976-10-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1977" : helpers.makeTestYear("Pacific/Auckland", [
		["1977-03-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1977-03-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1977-10-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1977-10-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1978" : helpers.makeTestYear("Pacific/Auckland", [
		["1978-03-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1978-03-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1978-10-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1978-10-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1979" : helpers.makeTestYear("Pacific/Auckland", [
		["1979-03-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1979-03-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1979-10-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1979-10-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1980" : helpers.makeTestYear("Pacific/Auckland", [
		["1980-03-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1980-03-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1980-10-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1980-10-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1981" : helpers.makeTestYear("Pacific/Auckland", [
		["1981-02-28T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1981-02-28T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1981-10-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1981-10-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1982" : helpers.makeTestYear("Pacific/Auckland", [
		["1982-03-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1982-03-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1982-10-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1982-10-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1983" : helpers.makeTestYear("Pacific/Auckland", [
		["1983-03-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1983-03-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1983-10-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1983-10-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1984" : helpers.makeTestYear("Pacific/Auckland", [
		["1984-03-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1984-03-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1984-10-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1984-10-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1985" : helpers.makeTestYear("Pacific/Auckland", [
		["1985-03-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1985-03-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1985-10-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1985-10-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1986" : helpers.makeTestYear("Pacific/Auckland", [
		["1986-03-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1986-03-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1986-10-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1986-10-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1987" : helpers.makeTestYear("Pacific/Auckland", [
		["1987-02-28T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1987-02-28T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1987-10-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1987-10-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1988" : helpers.makeTestYear("Pacific/Auckland", [
		["1988-03-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1988-03-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1988-10-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1988-10-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1989" : helpers.makeTestYear("Pacific/Auckland", [
		["1989-03-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1989-03-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1989-10-07T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1989-10-07T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1990" : helpers.makeTestYear("Pacific/Auckland", [
		["1990-03-17T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1990-03-17T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1990-10-06T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1990-10-06T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1991" : helpers.makeTestYear("Pacific/Auckland", [
		["1991-03-16T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1991-03-16T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1991-10-05T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1991-10-05T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1992" : helpers.makeTestYear("Pacific/Auckland", [
		["1992-03-14T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1992-03-14T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1992-10-03T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1992-10-03T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1993" : helpers.makeTestYear("Pacific/Auckland", [
		["1993-03-20T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1993-03-20T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1993-10-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1993-10-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1994" : helpers.makeTestYear("Pacific/Auckland", [
		["1994-03-19T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1994-03-19T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1994-10-01T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1994-10-01T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1995" : helpers.makeTestYear("Pacific/Auckland", [
		["1995-03-18T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1995-03-18T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1995-09-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1995-09-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1996" : helpers.makeTestYear("Pacific/Auckland", [
		["1996-03-16T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1996-03-16T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1996-10-05T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1996-10-05T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1997" : helpers.makeTestYear("Pacific/Auckland", [
		["1997-03-15T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1997-03-15T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1997-10-04T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1997-10-04T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1998" : helpers.makeTestYear("Pacific/Auckland", [
		["1998-03-14T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1998-03-14T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1998-10-03T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1998-10-03T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1999" : helpers.makeTestYear("Pacific/Auckland", [
		["1999-03-20T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1999-03-20T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1999-10-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1999-10-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2000" : helpers.makeTestYear("Pacific/Auckland", [
		["2000-03-18T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2000-03-18T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2000-09-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2000-09-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2001" : helpers.makeTestYear("Pacific/Auckland", [
		["2001-03-17T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2001-03-17T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2001-10-06T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2001-10-06T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2002" : helpers.makeTestYear("Pacific/Auckland", [
		["2002-03-16T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2002-03-16T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2002-10-05T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2002-10-05T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2003" : helpers.makeTestYear("Pacific/Auckland", [
		["2003-03-15T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2003-03-15T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2003-10-04T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2003-10-04T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2004" : helpers.makeTestYear("Pacific/Auckland", [
		["2004-03-20T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2004-03-20T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2004-10-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2004-10-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2005" : helpers.makeTestYear("Pacific/Auckland", [
		["2005-03-19T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2005-03-19T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2005-10-01T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2005-10-01T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2006" : helpers.makeTestYear("Pacific/Auckland", [
		["2006-03-18T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2006-03-18T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2006-09-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2006-09-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2007" : helpers.makeTestYear("Pacific/Auckland", [
		["2007-03-17T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2007-03-17T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2007-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2007-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2008" : helpers.makeTestYear("Pacific/Auckland", [
		["2008-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2008-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2008-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2008-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2009" : helpers.makeTestYear("Pacific/Auckland", [
		["2009-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2009-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2009-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2009-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2010" : helpers.makeTestYear("Pacific/Auckland", [
		["2010-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2010-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2010-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2010-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2011" : helpers.makeTestYear("Pacific/Auckland", [
		["2011-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2011-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2011-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2011-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2012" : helpers.makeTestYear("Pacific/Auckland", [
		["2012-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2012-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2012-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2012-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2013" : helpers.makeTestYear("Pacific/Auckland", [
		["2013-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2013-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2013-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2013-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2014" : helpers.makeTestYear("Pacific/Auckland", [
		["2014-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2014-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2014-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2014-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2015" : helpers.makeTestYear("Pacific/Auckland", [
		["2015-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2015-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2015-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2015-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2016" : helpers.makeTestYear("Pacific/Auckland", [
		["2016-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2016-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2016-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2016-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2017" : helpers.makeTestYear("Pacific/Auckland", [
		["2017-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2017-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2017-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2017-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2018" : helpers.makeTestYear("Pacific/Auckland", [
		["2018-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2018-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2018-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2018-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2019" : helpers.makeTestYear("Pacific/Auckland", [
		["2019-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2019-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2019-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2019-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2020" : helpers.makeTestYear("Pacific/Auckland", [
		["2020-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2020-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2020-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2020-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2021" : helpers.makeTestYear("Pacific/Auckland", [
		["2021-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2021-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2021-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2021-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2022" : helpers.makeTestYear("Pacific/Auckland", [
		["2022-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2022-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2022-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2022-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2023" : helpers.makeTestYear("Pacific/Auckland", [
		["2023-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2023-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2023-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2023-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2024" : helpers.makeTestYear("Pacific/Auckland", [
		["2024-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2024-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2024-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2024-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2025" : helpers.makeTestYear("Pacific/Auckland", [
		["2025-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2025-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2025-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2025-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2026" : helpers.makeTestYear("Pacific/Auckland", [
		["2026-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2026-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2026-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2026-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2027" : helpers.makeTestYear("Pacific/Auckland", [
		["2027-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2027-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2027-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2027-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2028" : helpers.makeTestYear("Pacific/Auckland", [
		["2028-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2028-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2028-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2028-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2029" : helpers.makeTestYear("Pacific/Auckland", [
		["2029-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2029-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2029-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2029-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2030" : helpers.makeTestYear("Pacific/Auckland", [
		["2030-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2030-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2030-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2030-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2031" : helpers.makeTestYear("Pacific/Auckland", [
		["2031-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2031-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2031-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2031-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2032" : helpers.makeTestYear("Pacific/Auckland", [
		["2032-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2032-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2032-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2032-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2033" : helpers.makeTestYear("Pacific/Auckland", [
		["2033-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2033-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2033-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2033-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2034" : helpers.makeTestYear("Pacific/Auckland", [
		["2034-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2034-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2034-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2034-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2035" : helpers.makeTestYear("Pacific/Auckland", [
		["2035-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2035-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2035-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2035-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2036" : helpers.makeTestYear("Pacific/Auckland", [
		["2036-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2036-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2036-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2036-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2037" : helpers.makeTestYear("Pacific/Auckland", [
		["2037-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2037-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2037-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2037-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2038" : helpers.makeTestYear("Pacific/Auckland", [
		["2038-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2038-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2038-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2038-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2039" : helpers.makeTestYear("Pacific/Auckland", [
		["2039-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2039-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2039-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2039-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2040" : helpers.makeTestYear("Pacific/Auckland", [
		["2040-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2040-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2040-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2040-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2041" : helpers.makeTestYear("Pacific/Auckland", [
		["2041-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2041-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2041-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2041-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2042" : helpers.makeTestYear("Pacific/Auckland", [
		["2042-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2042-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2042-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2042-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2043" : helpers.makeTestYear("Pacific/Auckland", [
		["2043-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2043-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2043-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2043-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2044" : helpers.makeTestYear("Pacific/Auckland", [
		["2044-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2044-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2044-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2044-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2045" : helpers.makeTestYear("Pacific/Auckland", [
		["2045-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2045-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2045-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2045-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2046" : helpers.makeTestYear("Pacific/Auckland", [
		["2046-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2046-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2046-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2046-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2047" : helpers.makeTestYear("Pacific/Auckland", [
		["2047-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2047-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2047-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2047-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2048" : helpers.makeTestYear("Pacific/Auckland", [
		["2048-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2048-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2048-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2048-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2049" : helpers.makeTestYear("Pacific/Auckland", [
		["2049-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2049-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2049-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2049-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2050" : helpers.makeTestYear("Pacific/Auckland", [
		["2050-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2050-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2050-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2050-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2051" : helpers.makeTestYear("Pacific/Auckland", [
		["2051-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2051-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2051-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2051-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2052" : helpers.makeTestYear("Pacific/Auckland", [
		["2052-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2052-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2052-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2052-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2053" : helpers.makeTestYear("Pacific/Auckland", [
		["2053-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2053-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2053-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2053-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2054" : helpers.makeTestYear("Pacific/Auckland", [
		["2054-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2054-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2054-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2054-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2055" : helpers.makeTestYear("Pacific/Auckland", [
		["2055-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2055-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2055-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2055-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2056" : helpers.makeTestYear("Pacific/Auckland", [
		["2056-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2056-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2056-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2056-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2057" : helpers.makeTestYear("Pacific/Auckland", [
		["2057-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2057-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2057-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2057-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2058" : helpers.makeTestYear("Pacific/Auckland", [
		["2058-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2058-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2058-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2058-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2059" : helpers.makeTestYear("Pacific/Auckland", [
		["2059-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2059-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2059-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2059-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2060" : helpers.makeTestYear("Pacific/Auckland", [
		["2060-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2060-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2060-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2060-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2061" : helpers.makeTestYear("Pacific/Auckland", [
		["2061-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2061-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2061-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2061-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2062" : helpers.makeTestYear("Pacific/Auckland", [
		["2062-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2062-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2062-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2062-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2063" : helpers.makeTestYear("Pacific/Auckland", [
		["2063-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2063-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2063-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2063-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2064" : helpers.makeTestYear("Pacific/Auckland", [
		["2064-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2064-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2064-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2064-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2065" : helpers.makeTestYear("Pacific/Auckland", [
		["2065-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2065-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2065-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2065-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2066" : helpers.makeTestYear("Pacific/Auckland", [
		["2066-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2066-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2066-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2066-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2067" : helpers.makeTestYear("Pacific/Auckland", [
		["2067-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2067-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2067-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2067-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2068" : helpers.makeTestYear("Pacific/Auckland", [
		["2068-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2068-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2068-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2068-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2069" : helpers.makeTestYear("Pacific/Auckland", [
		["2069-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2069-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2069-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2069-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2070" : helpers.makeTestYear("Pacific/Auckland", [
		["2070-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2070-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2070-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2070-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2071" : helpers.makeTestYear("Pacific/Auckland", [
		["2071-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2071-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2071-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2071-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2072" : helpers.makeTestYear("Pacific/Auckland", [
		["2072-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2072-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2072-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2072-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2073" : helpers.makeTestYear("Pacific/Auckland", [
		["2073-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2073-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2073-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2073-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2074" : helpers.makeTestYear("Pacific/Auckland", [
		["2074-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2074-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2074-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2074-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2075" : helpers.makeTestYear("Pacific/Auckland", [
		["2075-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2075-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2075-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2075-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2076" : helpers.makeTestYear("Pacific/Auckland", [
		["2076-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2076-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2076-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2076-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2077" : helpers.makeTestYear("Pacific/Auckland", [
		["2077-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2077-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2077-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2077-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2078" : helpers.makeTestYear("Pacific/Auckland", [
		["2078-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2078-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2078-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2078-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2079" : helpers.makeTestYear("Pacific/Auckland", [
		["2079-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2079-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2079-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2079-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2080" : helpers.makeTestYear("Pacific/Auckland", [
		["2080-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2080-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2080-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2080-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2081" : helpers.makeTestYear("Pacific/Auckland", [
		["2081-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2081-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2081-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2081-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2082" : helpers.makeTestYear("Pacific/Auckland", [
		["2082-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2082-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2082-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2082-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2083" : helpers.makeTestYear("Pacific/Auckland", [
		["2083-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2083-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2083-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2083-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2084" : helpers.makeTestYear("Pacific/Auckland", [
		["2084-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2084-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2084-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2084-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2085" : helpers.makeTestYear("Pacific/Auckland", [
		["2085-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2085-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2085-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2085-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2086" : helpers.makeTestYear("Pacific/Auckland", [
		["2086-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2086-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2086-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2086-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2087" : helpers.makeTestYear("Pacific/Auckland", [
		["2087-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2087-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2087-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2087-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2088" : helpers.makeTestYear("Pacific/Auckland", [
		["2088-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2088-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2088-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2088-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2089" : helpers.makeTestYear("Pacific/Auckland", [
		["2089-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2089-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2089-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2089-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2090" : helpers.makeTestYear("Pacific/Auckland", [
		["2090-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2090-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2090-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2090-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2091" : helpers.makeTestYear("Pacific/Auckland", [
		["2091-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2091-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2091-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2091-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2092" : helpers.makeTestYear("Pacific/Auckland", [
		["2092-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2092-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2092-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2092-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2093" : helpers.makeTestYear("Pacific/Auckland", [
		["2093-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2093-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2093-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2093-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2094" : helpers.makeTestYear("Pacific/Auckland", [
		["2094-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2094-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2094-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2094-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2095" : helpers.makeTestYear("Pacific/Auckland", [
		["2095-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2095-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2095-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2095-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2096" : helpers.makeTestYear("Pacific/Auckland", [
		["2096-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2096-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2096-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2096-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2097" : helpers.makeTestYear("Pacific/Auckland", [
		["2097-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2097-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2097-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2097-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2098" : helpers.makeTestYear("Pacific/Auckland", [
		["2098-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2098-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2098-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2098-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2099" : helpers.makeTestYear("Pacific/Auckland", [
		["2099-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2099-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2099-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2099-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2100" : helpers.makeTestYear("Pacific/Auckland", [
		["2100-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2100-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2100-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2100-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2101" : helpers.makeTestYear("Pacific/Auckland", [
		["2101-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2101-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2101-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2101-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2102" : helpers.makeTestYear("Pacific/Auckland", [
		["2102-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2102-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2102-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2102-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2103" : helpers.makeTestYear("Pacific/Auckland", [
		["2103-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2103-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2103-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2103-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2104" : helpers.makeTestYear("Pacific/Auckland", [
		["2104-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2104-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2104-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2104-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2105" : helpers.makeTestYear("Pacific/Auckland", [
		["2105-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2105-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2105-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2105-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2106" : helpers.makeTestYear("Pacific/Auckland", [
		["2106-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2106-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2106-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2106-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2107" : helpers.makeTestYear("Pacific/Auckland", [
		["2107-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2107-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2107-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2107-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2108" : helpers.makeTestYear("Pacific/Auckland", [
		["2108-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2108-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2108-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2108-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2109" : helpers.makeTestYear("Pacific/Auckland", [
		["2109-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2109-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2109-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2109-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2110" : helpers.makeTestYear("Pacific/Auckland", [
		["2110-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2110-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2110-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2110-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2111" : helpers.makeTestYear("Pacific/Auckland", [
		["2111-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2111-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2111-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2111-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2112" : helpers.makeTestYear("Pacific/Auckland", [
		["2112-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2112-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2112-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2112-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2113" : helpers.makeTestYear("Pacific/Auckland", [
		["2113-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2113-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2113-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2113-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2114" : helpers.makeTestYear("Pacific/Auckland", [
		["2114-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2114-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2114-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2114-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2115" : helpers.makeTestYear("Pacific/Auckland", [
		["2115-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2115-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2115-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2115-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2116" : helpers.makeTestYear("Pacific/Auckland", [
		["2116-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2116-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2116-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2116-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2117" : helpers.makeTestYear("Pacific/Auckland", [
		["2117-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2117-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2117-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2117-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2118" : helpers.makeTestYear("Pacific/Auckland", [
		["2118-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2118-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2118-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2118-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2119" : helpers.makeTestYear("Pacific/Auckland", [
		["2119-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2119-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2119-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2119-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2120" : helpers.makeTestYear("Pacific/Auckland", [
		["2120-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2120-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2120-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2120-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2121" : helpers.makeTestYear("Pacific/Auckland", [
		["2121-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2121-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2121-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2121-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2122" : helpers.makeTestYear("Pacific/Auckland", [
		["2122-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2122-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2122-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2122-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2123" : helpers.makeTestYear("Pacific/Auckland", [
		["2123-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2123-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2123-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2123-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2124" : helpers.makeTestYear("Pacific/Auckland", [
		["2124-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2124-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2124-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2124-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2125" : helpers.makeTestYear("Pacific/Auckland", [
		["2125-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2125-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2125-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2125-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2126" : helpers.makeTestYear("Pacific/Auckland", [
		["2126-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2126-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2126-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2126-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2127" : helpers.makeTestYear("Pacific/Auckland", [
		["2127-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2127-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2127-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2127-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2128" : helpers.makeTestYear("Pacific/Auckland", [
		["2128-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2128-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2128-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2128-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2129" : helpers.makeTestYear("Pacific/Auckland", [
		["2129-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2129-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2129-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2129-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2130" : helpers.makeTestYear("Pacific/Auckland", [
		["2130-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2130-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2130-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2130-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2131" : helpers.makeTestYear("Pacific/Auckland", [
		["2131-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2131-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2131-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2131-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2132" : helpers.makeTestYear("Pacific/Auckland", [
		["2132-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2132-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2132-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2132-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2133" : helpers.makeTestYear("Pacific/Auckland", [
		["2133-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2133-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2133-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2133-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2134" : helpers.makeTestYear("Pacific/Auckland", [
		["2134-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2134-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2134-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2134-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2135" : helpers.makeTestYear("Pacific/Auckland", [
		["2135-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2135-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2135-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2135-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2136" : helpers.makeTestYear("Pacific/Auckland", [
		["2136-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2136-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2136-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2136-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2137" : helpers.makeTestYear("Pacific/Auckland", [
		["2137-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2137-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2137-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2137-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2138" : helpers.makeTestYear("Pacific/Auckland", [
		["2138-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2138-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2138-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2138-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2139" : helpers.makeTestYear("Pacific/Auckland", [
		["2139-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2139-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2139-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2139-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2140" : helpers.makeTestYear("Pacific/Auckland", [
		["2140-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2140-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2140-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2140-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2141" : helpers.makeTestYear("Pacific/Auckland", [
		["2141-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2141-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2141-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2141-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2142" : helpers.makeTestYear("Pacific/Auckland", [
		["2142-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2142-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2142-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2142-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2143" : helpers.makeTestYear("Pacific/Auckland", [
		["2143-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2143-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2143-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2143-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2144" : helpers.makeTestYear("Pacific/Auckland", [
		["2144-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2144-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2144-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2144-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2145" : helpers.makeTestYear("Pacific/Auckland", [
		["2145-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2145-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2145-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2145-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2146" : helpers.makeTestYear("Pacific/Auckland", [
		["2146-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2146-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2146-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2146-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2147" : helpers.makeTestYear("Pacific/Auckland", [
		["2147-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2147-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2147-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2147-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2148" : helpers.makeTestYear("Pacific/Auckland", [
		["2148-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2148-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2148-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2148-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2149" : helpers.makeTestYear("Pacific/Auckland", [
		["2149-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2149-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2149-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2149-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2150" : helpers.makeTestYear("Pacific/Auckland", [
		["2150-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2150-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2150-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2150-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2151" : helpers.makeTestYear("Pacific/Auckland", [
		["2151-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2151-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2151-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2151-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2152" : helpers.makeTestYear("Pacific/Auckland", [
		["2152-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2152-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2152-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2152-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2153" : helpers.makeTestYear("Pacific/Auckland", [
		["2153-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2153-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2153-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2153-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2154" : helpers.makeTestYear("Pacific/Auckland", [
		["2154-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2154-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2154-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2154-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2155" : helpers.makeTestYear("Pacific/Auckland", [
		["2155-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2155-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2155-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2155-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2156" : helpers.makeTestYear("Pacific/Auckland", [
		["2156-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2156-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2156-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2156-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2157" : helpers.makeTestYear("Pacific/Auckland", [
		["2157-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2157-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2157-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2157-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2158" : helpers.makeTestYear("Pacific/Auckland", [
		["2158-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2158-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2158-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2158-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2159" : helpers.makeTestYear("Pacific/Auckland", [
		["2159-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2159-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2159-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2159-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2160" : helpers.makeTestYear("Pacific/Auckland", [
		["2160-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2160-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2160-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2160-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2161" : helpers.makeTestYear("Pacific/Auckland", [
		["2161-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2161-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2161-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2161-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2162" : helpers.makeTestYear("Pacific/Auckland", [
		["2162-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2162-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2162-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2162-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2163" : helpers.makeTestYear("Pacific/Auckland", [
		["2163-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2163-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2163-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2163-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2164" : helpers.makeTestYear("Pacific/Auckland", [
		["2164-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2164-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2164-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2164-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2165" : helpers.makeTestYear("Pacific/Auckland", [
		["2165-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2165-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2165-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2165-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2166" : helpers.makeTestYear("Pacific/Auckland", [
		["2166-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2166-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2166-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2166-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2167" : helpers.makeTestYear("Pacific/Auckland", [
		["2167-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2167-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2167-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2167-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2168" : helpers.makeTestYear("Pacific/Auckland", [
		["2168-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2168-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2168-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2168-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2169" : helpers.makeTestYear("Pacific/Auckland", [
		["2169-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2169-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2169-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2169-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2170" : helpers.makeTestYear("Pacific/Auckland", [
		["2170-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2170-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2170-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2170-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2171" : helpers.makeTestYear("Pacific/Auckland", [
		["2171-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2171-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2171-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2171-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2172" : helpers.makeTestYear("Pacific/Auckland", [
		["2172-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2172-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2172-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2172-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2173" : helpers.makeTestYear("Pacific/Auckland", [
		["2173-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2173-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2173-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2173-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2174" : helpers.makeTestYear("Pacific/Auckland", [
		["2174-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2174-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2174-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2174-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2175" : helpers.makeTestYear("Pacific/Auckland", [
		["2175-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2175-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2175-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2175-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2176" : helpers.makeTestYear("Pacific/Auckland", [
		["2176-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2176-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2176-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2176-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2177" : helpers.makeTestYear("Pacific/Auckland", [
		["2177-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2177-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2177-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2177-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2178" : helpers.makeTestYear("Pacific/Auckland", [
		["2178-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2178-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2178-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2178-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2179" : helpers.makeTestYear("Pacific/Auckland", [
		["2179-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2179-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2179-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2179-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2180" : helpers.makeTestYear("Pacific/Auckland", [
		["2180-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2180-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2180-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2180-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2181" : helpers.makeTestYear("Pacific/Auckland", [
		["2181-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2181-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2181-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2181-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2182" : helpers.makeTestYear("Pacific/Auckland", [
		["2182-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2182-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2182-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2182-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2183" : helpers.makeTestYear("Pacific/Auckland", [
		["2183-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2183-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2183-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2183-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2184" : helpers.makeTestYear("Pacific/Auckland", [
		["2184-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2184-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2184-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2184-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2185" : helpers.makeTestYear("Pacific/Auckland", [
		["2185-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2185-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2185-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2185-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2186" : helpers.makeTestYear("Pacific/Auckland", [
		["2186-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2186-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2186-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2186-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2187" : helpers.makeTestYear("Pacific/Auckland", [
		["2187-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2187-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2187-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2187-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2188" : helpers.makeTestYear("Pacific/Auckland", [
		["2188-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2188-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2188-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2188-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2189" : helpers.makeTestYear("Pacific/Auckland", [
		["2189-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2189-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2189-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2189-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2190" : helpers.makeTestYear("Pacific/Auckland", [
		["2190-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2190-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2190-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2190-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2191" : helpers.makeTestYear("Pacific/Auckland", [
		["2191-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2191-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2191-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2191-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2192" : helpers.makeTestYear("Pacific/Auckland", [
		["2192-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2192-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2192-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2192-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2193" : helpers.makeTestYear("Pacific/Auckland", [
		["2193-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2193-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2193-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2193-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2194" : helpers.makeTestYear("Pacific/Auckland", [
		["2194-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2194-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2194-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2194-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2195" : helpers.makeTestYear("Pacific/Auckland", [
		["2195-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2195-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2195-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2195-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2196" : helpers.makeTestYear("Pacific/Auckland", [
		["2196-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2196-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2196-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2196-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2197" : helpers.makeTestYear("Pacific/Auckland", [
		["2197-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2197-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2197-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2197-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2198" : helpers.makeTestYear("Pacific/Auckland", [
		["2198-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2198-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2198-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2198-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2199" : helpers.makeTestYear("Pacific/Auckland", [
		["2199-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2199-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2199-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2199-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2200" : helpers.makeTestYear("Pacific/Auckland", [
		["2200-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2200-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2200-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2200-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2201" : helpers.makeTestYear("Pacific/Auckland", [
		["2201-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2201-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2201-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2201-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2202" : helpers.makeTestYear("Pacific/Auckland", [
		["2202-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2202-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2202-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2202-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2203" : helpers.makeTestYear("Pacific/Auckland", [
		["2203-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2203-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2203-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2203-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2204" : helpers.makeTestYear("Pacific/Auckland", [
		["2204-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2204-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2204-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2204-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2205" : helpers.makeTestYear("Pacific/Auckland", [
		["2205-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2205-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2205-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2205-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2206" : helpers.makeTestYear("Pacific/Auckland", [
		["2206-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2206-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2206-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2206-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2207" : helpers.makeTestYear("Pacific/Auckland", [
		["2207-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2207-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2207-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2207-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2208" : helpers.makeTestYear("Pacific/Auckland", [
		["2208-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2208-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2208-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2208-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2209" : helpers.makeTestYear("Pacific/Auckland", [
		["2209-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2209-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2209-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2209-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2210" : helpers.makeTestYear("Pacific/Auckland", [
		["2210-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2210-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2210-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2210-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2211" : helpers.makeTestYear("Pacific/Auckland", [
		["2211-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2211-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2211-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2211-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2212" : helpers.makeTestYear("Pacific/Auckland", [
		["2212-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2212-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2212-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2212-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2213" : helpers.makeTestYear("Pacific/Auckland", [
		["2213-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2213-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2213-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2213-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2214" : helpers.makeTestYear("Pacific/Auckland", [
		["2214-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2214-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2214-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2214-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2215" : helpers.makeTestYear("Pacific/Auckland", [
		["2215-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2215-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2215-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2215-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2216" : helpers.makeTestYear("Pacific/Auckland", [
		["2216-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2216-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2216-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2216-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2217" : helpers.makeTestYear("Pacific/Auckland", [
		["2217-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2217-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2217-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2217-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2218" : helpers.makeTestYear("Pacific/Auckland", [
		["2218-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2218-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2218-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2218-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2219" : helpers.makeTestYear("Pacific/Auckland", [
		["2219-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2219-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2219-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2219-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2220" : helpers.makeTestYear("Pacific/Auckland", [
		["2220-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2220-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2220-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2220-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2221" : helpers.makeTestYear("Pacific/Auckland", [
		["2221-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2221-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2221-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2221-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2222" : helpers.makeTestYear("Pacific/Auckland", [
		["2222-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2222-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2222-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2222-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2223" : helpers.makeTestYear("Pacific/Auckland", [
		["2223-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2223-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2223-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2223-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2224" : helpers.makeTestYear("Pacific/Auckland", [
		["2224-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2224-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2224-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2224-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2225" : helpers.makeTestYear("Pacific/Auckland", [
		["2225-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2225-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2225-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2225-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2226" : helpers.makeTestYear("Pacific/Auckland", [
		["2226-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2226-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2226-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2226-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2227" : helpers.makeTestYear("Pacific/Auckland", [
		["2227-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2227-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2227-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2227-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2228" : helpers.makeTestYear("Pacific/Auckland", [
		["2228-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2228-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2228-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2228-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2229" : helpers.makeTestYear("Pacific/Auckland", [
		["2229-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2229-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2229-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2229-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2230" : helpers.makeTestYear("Pacific/Auckland", [
		["2230-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2230-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2230-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2230-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2231" : helpers.makeTestYear("Pacific/Auckland", [
		["2231-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2231-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2231-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2231-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2232" : helpers.makeTestYear("Pacific/Auckland", [
		["2232-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2232-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2232-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2232-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2233" : helpers.makeTestYear("Pacific/Auckland", [
		["2233-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2233-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2233-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2233-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2234" : helpers.makeTestYear("Pacific/Auckland", [
		["2234-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2234-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2234-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2234-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2235" : helpers.makeTestYear("Pacific/Auckland", [
		["2235-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2235-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2235-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2235-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2236" : helpers.makeTestYear("Pacific/Auckland", [
		["2236-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2236-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2236-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2236-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2237" : helpers.makeTestYear("Pacific/Auckland", [
		["2237-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2237-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2237-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2237-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2238" : helpers.makeTestYear("Pacific/Auckland", [
		["2238-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2238-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2238-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2238-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2239" : helpers.makeTestYear("Pacific/Auckland", [
		["2239-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2239-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2239-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2239-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2240" : helpers.makeTestYear("Pacific/Auckland", [
		["2240-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2240-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2240-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2240-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2241" : helpers.makeTestYear("Pacific/Auckland", [
		["2241-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2241-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2241-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2241-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2242" : helpers.makeTestYear("Pacific/Auckland", [
		["2242-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2242-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2242-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2242-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2243" : helpers.makeTestYear("Pacific/Auckland", [
		["2243-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2243-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2243-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2243-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2244" : helpers.makeTestYear("Pacific/Auckland", [
		["2244-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2244-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2244-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2244-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2245" : helpers.makeTestYear("Pacific/Auckland", [
		["2245-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2245-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2245-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2245-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2246" : helpers.makeTestYear("Pacific/Auckland", [
		["2246-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2246-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2246-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2246-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2247" : helpers.makeTestYear("Pacific/Auckland", [
		["2247-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2247-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2247-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2247-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2248" : helpers.makeTestYear("Pacific/Auckland", [
		["2248-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2248-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2248-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2248-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2249" : helpers.makeTestYear("Pacific/Auckland", [
		["2249-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2249-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2249-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2249-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2250" : helpers.makeTestYear("Pacific/Auckland", [
		["2250-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2250-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2250-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2250-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2251" : helpers.makeTestYear("Pacific/Auckland", [
		["2251-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2251-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2251-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2251-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2252" : helpers.makeTestYear("Pacific/Auckland", [
		["2252-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2252-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2252-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2252-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2253" : helpers.makeTestYear("Pacific/Auckland", [
		["2253-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2253-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2253-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2253-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2254" : helpers.makeTestYear("Pacific/Auckland", [
		["2254-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2254-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2254-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2254-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2255" : helpers.makeTestYear("Pacific/Auckland", [
		["2255-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2255-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2255-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2255-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2256" : helpers.makeTestYear("Pacific/Auckland", [
		["2256-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2256-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2256-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2256-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2257" : helpers.makeTestYear("Pacific/Auckland", [
		["2257-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2257-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2257-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2257-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2258" : helpers.makeTestYear("Pacific/Auckland", [
		["2258-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2258-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2258-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2258-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2259" : helpers.makeTestYear("Pacific/Auckland", [
		["2259-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2259-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2259-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2259-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2260" : helpers.makeTestYear("Pacific/Auckland", [
		["2260-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2260-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2260-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2260-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2261" : helpers.makeTestYear("Pacific/Auckland", [
		["2261-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2261-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2261-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2261-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2262" : helpers.makeTestYear("Pacific/Auckland", [
		["2262-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2262-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2262-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2262-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2263" : helpers.makeTestYear("Pacific/Auckland", [
		["2263-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2263-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2263-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2263-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2264" : helpers.makeTestYear("Pacific/Auckland", [
		["2264-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2264-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2264-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2264-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2265" : helpers.makeTestYear("Pacific/Auckland", [
		["2265-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2265-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2265-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2265-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2266" : helpers.makeTestYear("Pacific/Auckland", [
		["2266-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2266-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2266-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2266-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2267" : helpers.makeTestYear("Pacific/Auckland", [
		["2267-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2267-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2267-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2267-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2268" : helpers.makeTestYear("Pacific/Auckland", [
		["2268-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2268-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2268-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2268-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2269" : helpers.makeTestYear("Pacific/Auckland", [
		["2269-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2269-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2269-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2269-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2270" : helpers.makeTestYear("Pacific/Auckland", [
		["2270-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2270-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2270-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2270-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2271" : helpers.makeTestYear("Pacific/Auckland", [
		["2271-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2271-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2271-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2271-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2272" : helpers.makeTestYear("Pacific/Auckland", [
		["2272-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2272-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2272-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2272-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2273" : helpers.makeTestYear("Pacific/Auckland", [
		["2273-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2273-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2273-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2273-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2274" : helpers.makeTestYear("Pacific/Auckland", [
		["2274-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2274-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2274-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2274-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2275" : helpers.makeTestYear("Pacific/Auckland", [
		["2275-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2275-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2275-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2275-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2276" : helpers.makeTestYear("Pacific/Auckland", [
		["2276-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2276-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2276-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2276-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2277" : helpers.makeTestYear("Pacific/Auckland", [
		["2277-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2277-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2277-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2277-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2278" : helpers.makeTestYear("Pacific/Auckland", [
		["2278-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2278-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2278-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2278-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2279" : helpers.makeTestYear("Pacific/Auckland", [
		["2279-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2279-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2279-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2279-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2280" : helpers.makeTestYear("Pacific/Auckland", [
		["2280-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2280-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2280-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2280-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2281" : helpers.makeTestYear("Pacific/Auckland", [
		["2281-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2281-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2281-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2281-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2282" : helpers.makeTestYear("Pacific/Auckland", [
		["2282-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2282-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2282-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2282-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2283" : helpers.makeTestYear("Pacific/Auckland", [
		["2283-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2283-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2283-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2283-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2284" : helpers.makeTestYear("Pacific/Auckland", [
		["2284-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2284-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2284-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2284-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2285" : helpers.makeTestYear("Pacific/Auckland", [
		["2285-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2285-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2285-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2285-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2286" : helpers.makeTestYear("Pacific/Auckland", [
		["2286-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2286-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2286-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2286-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2287" : helpers.makeTestYear("Pacific/Auckland", [
		["2287-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2287-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2287-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2287-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2288" : helpers.makeTestYear("Pacific/Auckland", [
		["2288-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2288-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2288-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2288-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2289" : helpers.makeTestYear("Pacific/Auckland", [
		["2289-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2289-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2289-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2289-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2290" : helpers.makeTestYear("Pacific/Auckland", [
		["2290-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2290-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2290-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2290-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2291" : helpers.makeTestYear("Pacific/Auckland", [
		["2291-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2291-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2291-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2291-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2292" : helpers.makeTestYear("Pacific/Auckland", [
		["2292-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2292-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2292-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2292-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2293" : helpers.makeTestYear("Pacific/Auckland", [
		["2293-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2293-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2293-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2293-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2294" : helpers.makeTestYear("Pacific/Auckland", [
		["2294-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2294-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2294-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2294-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2295" : helpers.makeTestYear("Pacific/Auckland", [
		["2295-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2295-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2295-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2295-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2296" : helpers.makeTestYear("Pacific/Auckland", [
		["2296-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2296-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2296-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2296-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2297" : helpers.makeTestYear("Pacific/Auckland", [
		["2297-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2297-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2297-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2297-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2298" : helpers.makeTestYear("Pacific/Auckland", [
		["2298-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2298-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2298-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2298-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2299" : helpers.makeTestYear("Pacific/Auckland", [
		["2299-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2299-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2299-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2299-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2300" : helpers.makeTestYear("Pacific/Auckland", [
		["2300-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2300-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2300-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2300-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2301" : helpers.makeTestYear("Pacific/Auckland", [
		["2301-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2301-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2301-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2301-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2302" : helpers.makeTestYear("Pacific/Auckland", [
		["2302-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2302-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2302-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2302-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2303" : helpers.makeTestYear("Pacific/Auckland", [
		["2303-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2303-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2303-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2303-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2304" : helpers.makeTestYear("Pacific/Auckland", [
		["2304-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2304-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2304-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2304-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2305" : helpers.makeTestYear("Pacific/Auckland", [
		["2305-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2305-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2305-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2305-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2306" : helpers.makeTestYear("Pacific/Auckland", [
		["2306-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2306-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2306-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2306-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2307" : helpers.makeTestYear("Pacific/Auckland", [
		["2307-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2307-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2307-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2307-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2308" : helpers.makeTestYear("Pacific/Auckland", [
		["2308-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2308-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2308-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2308-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2309" : helpers.makeTestYear("Pacific/Auckland", [
		["2309-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2309-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2309-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2309-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2310" : helpers.makeTestYear("Pacific/Auckland", [
		["2310-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2310-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2310-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2310-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2311" : helpers.makeTestYear("Pacific/Auckland", [
		["2311-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2311-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2311-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2311-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2312" : helpers.makeTestYear("Pacific/Auckland", [
		["2312-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2312-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2312-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2312-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2313" : helpers.makeTestYear("Pacific/Auckland", [
		["2313-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2313-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2313-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2313-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2314" : helpers.makeTestYear("Pacific/Auckland", [
		["2314-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2314-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2314-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2314-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2315" : helpers.makeTestYear("Pacific/Auckland", [
		["2315-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2315-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2315-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2315-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2316" : helpers.makeTestYear("Pacific/Auckland", [
		["2316-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2316-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2316-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2316-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2317" : helpers.makeTestYear("Pacific/Auckland", [
		["2317-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2317-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2317-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2317-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2318" : helpers.makeTestYear("Pacific/Auckland", [
		["2318-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2318-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2318-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2318-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2319" : helpers.makeTestYear("Pacific/Auckland", [
		["2319-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2319-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2319-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2319-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2320" : helpers.makeTestYear("Pacific/Auckland", [
		["2320-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2320-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2320-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2320-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2321" : helpers.makeTestYear("Pacific/Auckland", [
		["2321-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2321-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2321-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2321-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2322" : helpers.makeTestYear("Pacific/Auckland", [
		["2322-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2322-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2322-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2322-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2323" : helpers.makeTestYear("Pacific/Auckland", [
		["2323-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2323-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2323-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2323-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2324" : helpers.makeTestYear("Pacific/Auckland", [
		["2324-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2324-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2324-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2324-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2325" : helpers.makeTestYear("Pacific/Auckland", [
		["2325-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2325-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2325-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2325-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2326" : helpers.makeTestYear("Pacific/Auckland", [
		["2326-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2326-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2326-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2326-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2327" : helpers.makeTestYear("Pacific/Auckland", [
		["2327-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2327-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2327-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2327-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2328" : helpers.makeTestYear("Pacific/Auckland", [
		["2328-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2328-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2328-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2328-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2329" : helpers.makeTestYear("Pacific/Auckland", [
		["2329-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2329-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2329-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2329-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2330" : helpers.makeTestYear("Pacific/Auckland", [
		["2330-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2330-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2330-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2330-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2331" : helpers.makeTestYear("Pacific/Auckland", [
		["2331-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2331-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2331-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2331-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2332" : helpers.makeTestYear("Pacific/Auckland", [
		["2332-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2332-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2332-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2332-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2333" : helpers.makeTestYear("Pacific/Auckland", [
		["2333-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2333-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2333-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2333-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2334" : helpers.makeTestYear("Pacific/Auckland", [
		["2334-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2334-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2334-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2334-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2335" : helpers.makeTestYear("Pacific/Auckland", [
		["2335-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2335-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2335-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2335-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2336" : helpers.makeTestYear("Pacific/Auckland", [
		["2336-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2336-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2336-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2336-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2337" : helpers.makeTestYear("Pacific/Auckland", [
		["2337-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2337-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2337-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2337-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2338" : helpers.makeTestYear("Pacific/Auckland", [
		["2338-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2338-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2338-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2338-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2339" : helpers.makeTestYear("Pacific/Auckland", [
		["2339-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2339-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2339-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2339-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2340" : helpers.makeTestYear("Pacific/Auckland", [
		["2340-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2340-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2340-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2340-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2341" : helpers.makeTestYear("Pacific/Auckland", [
		["2341-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2341-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2341-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2341-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2342" : helpers.makeTestYear("Pacific/Auckland", [
		["2342-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2342-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2342-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2342-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2343" : helpers.makeTestYear("Pacific/Auckland", [
		["2343-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2343-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2343-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2343-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2344" : helpers.makeTestYear("Pacific/Auckland", [
		["2344-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2344-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2344-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2344-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2345" : helpers.makeTestYear("Pacific/Auckland", [
		["2345-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2345-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2345-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2345-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2346" : helpers.makeTestYear("Pacific/Auckland", [
		["2346-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2346-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2346-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2346-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2347" : helpers.makeTestYear("Pacific/Auckland", [
		["2347-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2347-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2347-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2347-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2348" : helpers.makeTestYear("Pacific/Auckland", [
		["2348-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2348-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2348-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2348-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2349" : helpers.makeTestYear("Pacific/Auckland", [
		["2349-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2349-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2349-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2349-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2350" : helpers.makeTestYear("Pacific/Auckland", [
		["2350-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2350-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2350-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2350-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2351" : helpers.makeTestYear("Pacific/Auckland", [
		["2351-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2351-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2351-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2351-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2352" : helpers.makeTestYear("Pacific/Auckland", [
		["2352-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2352-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2352-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2352-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2353" : helpers.makeTestYear("Pacific/Auckland", [
		["2353-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2353-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2353-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2353-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2354" : helpers.makeTestYear("Pacific/Auckland", [
		["2354-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2354-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2354-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2354-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2355" : helpers.makeTestYear("Pacific/Auckland", [
		["2355-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2355-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2355-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2355-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2356" : helpers.makeTestYear("Pacific/Auckland", [
		["2356-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2356-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2356-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2356-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2357" : helpers.makeTestYear("Pacific/Auckland", [
		["2357-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2357-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2357-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2357-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2358" : helpers.makeTestYear("Pacific/Auckland", [
		["2358-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2358-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2358-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2358-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2359" : helpers.makeTestYear("Pacific/Auckland", [
		["2359-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2359-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2359-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2359-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2360" : helpers.makeTestYear("Pacific/Auckland", [
		["2360-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2360-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2360-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2360-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2361" : helpers.makeTestYear("Pacific/Auckland", [
		["2361-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2361-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2361-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2361-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2362" : helpers.makeTestYear("Pacific/Auckland", [
		["2362-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2362-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2362-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2362-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2363" : helpers.makeTestYear("Pacific/Auckland", [
		["2363-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2363-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2363-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2363-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2364" : helpers.makeTestYear("Pacific/Auckland", [
		["2364-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2364-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2364-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2364-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2365" : helpers.makeTestYear("Pacific/Auckland", [
		["2365-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2365-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2365-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2365-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2366" : helpers.makeTestYear("Pacific/Auckland", [
		["2366-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2366-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2366-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2366-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2367" : helpers.makeTestYear("Pacific/Auckland", [
		["2367-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2367-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2367-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2367-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2368" : helpers.makeTestYear("Pacific/Auckland", [
		["2368-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2368-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2368-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2368-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2369" : helpers.makeTestYear("Pacific/Auckland", [
		["2369-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2369-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2369-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2369-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2370" : helpers.makeTestYear("Pacific/Auckland", [
		["2370-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2370-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2370-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2370-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2371" : helpers.makeTestYear("Pacific/Auckland", [
		["2371-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2371-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2371-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2371-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2372" : helpers.makeTestYear("Pacific/Auckland", [
		["2372-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2372-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2372-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2372-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2373" : helpers.makeTestYear("Pacific/Auckland", [
		["2373-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2373-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2373-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2373-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2374" : helpers.makeTestYear("Pacific/Auckland", [
		["2374-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2374-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2374-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2374-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2375" : helpers.makeTestYear("Pacific/Auckland", [
		["2375-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2375-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2375-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2375-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2376" : helpers.makeTestYear("Pacific/Auckland", [
		["2376-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2376-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2376-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2376-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2377" : helpers.makeTestYear("Pacific/Auckland", [
		["2377-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2377-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2377-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2377-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2378" : helpers.makeTestYear("Pacific/Auckland", [
		["2378-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2378-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2378-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2378-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2379" : helpers.makeTestYear("Pacific/Auckland", [
		["2379-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2379-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2379-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2379-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2380" : helpers.makeTestYear("Pacific/Auckland", [
		["2380-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2380-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2380-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2380-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2381" : helpers.makeTestYear("Pacific/Auckland", [
		["2381-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2381-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2381-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2381-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2382" : helpers.makeTestYear("Pacific/Auckland", [
		["2382-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2382-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2382-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2382-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2383" : helpers.makeTestYear("Pacific/Auckland", [
		["2383-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2383-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2383-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2383-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2384" : helpers.makeTestYear("Pacific/Auckland", [
		["2384-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2384-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2384-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2384-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2385" : helpers.makeTestYear("Pacific/Auckland", [
		["2385-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2385-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2385-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2385-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2386" : helpers.makeTestYear("Pacific/Auckland", [
		["2386-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2386-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2386-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2386-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2387" : helpers.makeTestYear("Pacific/Auckland", [
		["2387-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2387-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2387-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2387-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2388" : helpers.makeTestYear("Pacific/Auckland", [
		["2388-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2388-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2388-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2388-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2389" : helpers.makeTestYear("Pacific/Auckland", [
		["2389-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2389-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2389-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2389-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2390" : helpers.makeTestYear("Pacific/Auckland", [
		["2390-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2390-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2390-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2390-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2391" : helpers.makeTestYear("Pacific/Auckland", [
		["2391-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2391-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2391-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2391-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2392" : helpers.makeTestYear("Pacific/Auckland", [
		["2392-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2392-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2392-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2392-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2393" : helpers.makeTestYear("Pacific/Auckland", [
		["2393-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2393-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2393-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2393-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2394" : helpers.makeTestYear("Pacific/Auckland", [
		["2394-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2394-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2394-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2394-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2395" : helpers.makeTestYear("Pacific/Auckland", [
		["2395-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2395-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2395-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2395-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2396" : helpers.makeTestYear("Pacific/Auckland", [
		["2396-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2396-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2396-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2396-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2397" : helpers.makeTestYear("Pacific/Auckland", [
		["2397-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2397-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2397-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2397-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2398" : helpers.makeTestYear("Pacific/Auckland", [
		["2398-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2398-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2398-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2398-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2399" : helpers.makeTestYear("Pacific/Auckland", [
		["2399-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2399-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2399-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2399-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2400" : helpers.makeTestYear("Pacific/Auckland", [
		["2400-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2400-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2400-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2400-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2401" : helpers.makeTestYear("Pacific/Auckland", [
		["2401-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2401-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2401-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2401-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2402" : helpers.makeTestYear("Pacific/Auckland", [
		["2402-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2402-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2402-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2402-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2403" : helpers.makeTestYear("Pacific/Auckland", [
		["2403-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2403-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2403-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2403-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2404" : helpers.makeTestYear("Pacific/Auckland", [
		["2404-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2404-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2404-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2404-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2405" : helpers.makeTestYear("Pacific/Auckland", [
		["2405-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2405-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2405-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2405-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2406" : helpers.makeTestYear("Pacific/Auckland", [
		["2406-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2406-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2406-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2406-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2407" : helpers.makeTestYear("Pacific/Auckland", [
		["2407-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2407-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2407-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2407-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2408" : helpers.makeTestYear("Pacific/Auckland", [
		["2408-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2408-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2408-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2408-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2409" : helpers.makeTestYear("Pacific/Auckland", [
		["2409-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2409-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2409-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2409-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2410" : helpers.makeTestYear("Pacific/Auckland", [
		["2410-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2410-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2410-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2410-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2411" : helpers.makeTestYear("Pacific/Auckland", [
		["2411-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2411-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2411-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2411-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2412" : helpers.makeTestYear("Pacific/Auckland", [
		["2412-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2412-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2412-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2412-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2413" : helpers.makeTestYear("Pacific/Auckland", [
		["2413-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2413-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2413-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2413-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2414" : helpers.makeTestYear("Pacific/Auckland", [
		["2414-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2414-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2414-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2414-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2415" : helpers.makeTestYear("Pacific/Auckland", [
		["2415-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2415-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2415-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2415-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2416" : helpers.makeTestYear("Pacific/Auckland", [
		["2416-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2416-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2416-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2416-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2417" : helpers.makeTestYear("Pacific/Auckland", [
		["2417-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2417-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2417-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2417-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2418" : helpers.makeTestYear("Pacific/Auckland", [
		["2418-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2418-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2418-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2418-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2419" : helpers.makeTestYear("Pacific/Auckland", [
		["2419-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2419-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2419-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2419-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2420" : helpers.makeTestYear("Pacific/Auckland", [
		["2420-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2420-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2420-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2420-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2421" : helpers.makeTestYear("Pacific/Auckland", [
		["2421-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2421-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2421-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2421-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2422" : helpers.makeTestYear("Pacific/Auckland", [
		["2422-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2422-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2422-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2422-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2423" : helpers.makeTestYear("Pacific/Auckland", [
		["2423-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2423-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2423-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2423-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2424" : helpers.makeTestYear("Pacific/Auckland", [
		["2424-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2424-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2424-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2424-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2425" : helpers.makeTestYear("Pacific/Auckland", [
		["2425-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2425-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2425-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2425-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2426" : helpers.makeTestYear("Pacific/Auckland", [
		["2426-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2426-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2426-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2426-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2427" : helpers.makeTestYear("Pacific/Auckland", [
		["2427-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2427-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2427-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2427-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2428" : helpers.makeTestYear("Pacific/Auckland", [
		["2428-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2428-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2428-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2428-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2429" : helpers.makeTestYear("Pacific/Auckland", [
		["2429-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2429-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2429-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2429-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2430" : helpers.makeTestYear("Pacific/Auckland", [
		["2430-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2430-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2430-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2430-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2431" : helpers.makeTestYear("Pacific/Auckland", [
		["2431-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2431-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2431-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2431-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2432" : helpers.makeTestYear("Pacific/Auckland", [
		["2432-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2432-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2432-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2432-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2433" : helpers.makeTestYear("Pacific/Auckland", [
		["2433-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2433-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2433-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2433-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2434" : helpers.makeTestYear("Pacific/Auckland", [
		["2434-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2434-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2434-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2434-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2435" : helpers.makeTestYear("Pacific/Auckland", [
		["2435-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2435-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2435-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2435-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2436" : helpers.makeTestYear("Pacific/Auckland", [
		["2436-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2436-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2436-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2436-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2437" : helpers.makeTestYear("Pacific/Auckland", [
		["2437-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2437-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2437-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2437-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2438" : helpers.makeTestYear("Pacific/Auckland", [
		["2438-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2438-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2438-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2438-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2439" : helpers.makeTestYear("Pacific/Auckland", [
		["2439-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2439-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2439-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2439-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2440" : helpers.makeTestYear("Pacific/Auckland", [
		["2440-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2440-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2440-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2440-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2441" : helpers.makeTestYear("Pacific/Auckland", [
		["2441-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2441-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2441-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2441-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2442" : helpers.makeTestYear("Pacific/Auckland", [
		["2442-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2442-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2442-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2442-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2443" : helpers.makeTestYear("Pacific/Auckland", [
		["2443-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2443-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2443-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2443-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2444" : helpers.makeTestYear("Pacific/Auckland", [
		["2444-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2444-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2444-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2444-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2445" : helpers.makeTestYear("Pacific/Auckland", [
		["2445-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2445-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2445-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2445-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2446" : helpers.makeTestYear("Pacific/Auckland", [
		["2446-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2446-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2446-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2446-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2447" : helpers.makeTestYear("Pacific/Auckland", [
		["2447-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2447-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2447-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2447-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2448" : helpers.makeTestYear("Pacific/Auckland", [
		["2448-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2448-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2448-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2448-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2449" : helpers.makeTestYear("Pacific/Auckland", [
		["2449-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2449-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2449-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2449-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2450" : helpers.makeTestYear("Pacific/Auckland", [
		["2450-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2450-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2450-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2450-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2451" : helpers.makeTestYear("Pacific/Auckland", [
		["2451-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2451-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2451-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2451-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2452" : helpers.makeTestYear("Pacific/Auckland", [
		["2452-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2452-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2452-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2452-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2453" : helpers.makeTestYear("Pacific/Auckland", [
		["2453-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2453-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2453-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2453-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2454" : helpers.makeTestYear("Pacific/Auckland", [
		["2454-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2454-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2454-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2454-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2455" : helpers.makeTestYear("Pacific/Auckland", [
		["2455-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2455-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2455-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2455-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2456" : helpers.makeTestYear("Pacific/Auckland", [
		["2456-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2456-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2456-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2456-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2457" : helpers.makeTestYear("Pacific/Auckland", [
		["2457-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2457-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2457-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2457-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2458" : helpers.makeTestYear("Pacific/Auckland", [
		["2458-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2458-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2458-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2458-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2459" : helpers.makeTestYear("Pacific/Auckland", [
		["2459-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2459-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2459-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2459-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2460" : helpers.makeTestYear("Pacific/Auckland", [
		["2460-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2460-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2460-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2460-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2461" : helpers.makeTestYear("Pacific/Auckland", [
		["2461-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2461-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2461-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2461-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2462" : helpers.makeTestYear("Pacific/Auckland", [
		["2462-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2462-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2462-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2462-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2463" : helpers.makeTestYear("Pacific/Auckland", [
		["2463-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2463-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2463-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2463-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2464" : helpers.makeTestYear("Pacific/Auckland", [
		["2464-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2464-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2464-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2464-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2465" : helpers.makeTestYear("Pacific/Auckland", [
		["2465-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2465-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2465-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2465-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2466" : helpers.makeTestYear("Pacific/Auckland", [
		["2466-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2466-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2466-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2466-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2467" : helpers.makeTestYear("Pacific/Auckland", [
		["2467-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2467-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2467-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2467-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2468" : helpers.makeTestYear("Pacific/Auckland", [
		["2468-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2468-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2468-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2468-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2469" : helpers.makeTestYear("Pacific/Auckland", [
		["2469-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2469-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2469-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2469-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2470" : helpers.makeTestYear("Pacific/Auckland", [
		["2470-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2470-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2470-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2470-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2471" : helpers.makeTestYear("Pacific/Auckland", [
		["2471-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2471-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2471-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2471-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2472" : helpers.makeTestYear("Pacific/Auckland", [
		["2472-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2472-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2472-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2472-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2473" : helpers.makeTestYear("Pacific/Auckland", [
		["2473-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2473-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2473-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2473-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2474" : helpers.makeTestYear("Pacific/Auckland", [
		["2474-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2474-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2474-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2474-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2475" : helpers.makeTestYear("Pacific/Auckland", [
		["2475-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2475-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2475-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2475-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2476" : helpers.makeTestYear("Pacific/Auckland", [
		["2476-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2476-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2476-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2476-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2477" : helpers.makeTestYear("Pacific/Auckland", [
		["2477-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2477-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2477-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2477-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2478" : helpers.makeTestYear("Pacific/Auckland", [
		["2478-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2478-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2478-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2478-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2479" : helpers.makeTestYear("Pacific/Auckland", [
		["2479-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2479-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2479-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2479-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2480" : helpers.makeTestYear("Pacific/Auckland", [
		["2480-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2480-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2480-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2480-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2481" : helpers.makeTestYear("Pacific/Auckland", [
		["2481-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2481-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2481-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2481-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2482" : helpers.makeTestYear("Pacific/Auckland", [
		["2482-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2482-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2482-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2482-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2483" : helpers.makeTestYear("Pacific/Auckland", [
		["2483-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2483-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2483-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2483-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2484" : helpers.makeTestYear("Pacific/Auckland", [
		["2484-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2484-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2484-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2484-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2485" : helpers.makeTestYear("Pacific/Auckland", [
		["2485-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2485-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2485-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2485-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2486" : helpers.makeTestYear("Pacific/Auckland", [
		["2486-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2486-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2486-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2486-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2487" : helpers.makeTestYear("Pacific/Auckland", [
		["2487-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2487-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2487-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2487-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2488" : helpers.makeTestYear("Pacific/Auckland", [
		["2488-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2488-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2488-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2488-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2489" : helpers.makeTestYear("Pacific/Auckland", [
		["2489-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2489-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2489-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2489-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2490" : helpers.makeTestYear("Pacific/Auckland", [
		["2490-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2490-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2490-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2490-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2491" : helpers.makeTestYear("Pacific/Auckland", [
		["2491-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2491-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2491-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2491-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2492" : helpers.makeTestYear("Pacific/Auckland", [
		["2492-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2492-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2492-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2492-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2493" : helpers.makeTestYear("Pacific/Auckland", [
		["2493-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2493-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2493-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2493-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2494" : helpers.makeTestYear("Pacific/Auckland", [
		["2494-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2494-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2494-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2494-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2495" : helpers.makeTestYear("Pacific/Auckland", [
		["2495-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2495-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2495-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2495-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2496" : helpers.makeTestYear("Pacific/Auckland", [
		["2496-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2496-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2496-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2496-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2497" : helpers.makeTestYear("Pacific/Auckland", [
		["2497-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2497-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2497-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2497-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2498" : helpers.makeTestYear("Pacific/Auckland", [
		["2498-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2498-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2498-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2498-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2499" : helpers.makeTestYear("Pacific/Auckland", [
		["2499-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2499-04-04T14:00:00+00:00", "02:00:00", "NZST", -720]
	])
};