# Disable debuginfo since there are no binaries
%global debug_package %{nil}

%if %{?fedora}%{!?fedora:0} >= 8 || %{?rhel}%{!?rhel:0} >= 6
%global enable_doc 1
%else
%global enable_doc 0
%endif
%global site org.nordugrid
%global nagios_bindir %{_libdir}/nagios/plugins
%global arc_spooldir %{_localstatedir}/spool/arc
%global pkg_spooldir %{arc_spooldir}/nagios
%global pkg_sysconfdir %{_sysconfdir}/arc/nagios
%{!?__python2: %global __python2 %{__python}}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c 'from distutils import sysconfig; print sysconfig.get_python_lib()')}

Name:		nordugrid-arc-nagios-plugins
Version:	1.9.1
Release:	1%{?dist}
Summary:	Nagios plugins for ARC

Group:		System Environment/Daemons
License:	ASL 2.0
URL:		http://www.nordugrid.org
Source0:	http://download.nordugrid.org/packages/%{name}/releases/%{version}/src/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires:	nordugrid-arc-client >= 1.0.0
Requires:	nordugrid-arc-python >= 1.0.0
Requires:	python-argparse
Requires:	python-ldap
Requires:	python-genshi
Requires:	python-ply
Requires:	nagios-plugins
Requires:	glue-schema >= 2.0.8
%if %{?rhel}%{!?rhel:6} <= 5
Requires: python-elementtree
Requires: python-sqlite
%endif
%if %{enable_doc}
BuildRequires: python-sphinx
%endif
%if %{?fedora}%{!?fedora:0} <= 12
BuildRequires: python-devel
%endif

%description
This package provides the Nagios plugins for testing ARC CE, using the ARC-1
API.

%if %{enable_doc}
%package doc
Summary: HTML documentation for ARC 1 Nagios plugins
Group: Documentation
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch: noarch
%endif
%endif

%if %{enable_doc}
%description doc
HTML documentation for %{name}.
%endif

%package egi
Summary: EGI configuration and dependencies for the ARC Nagios plugins
Group: System Environment/Daemons
BuildArch: noarch
Requires: nordugrid-arc-plugins-globus >= 1.0.0

%description egi
EGI configuration and dependencies for the ARC Nagios plugins

%prep
%setup -q -n %{name}-%{version}

%build
%{__python2} setup.py build
%if %{enable_doc}
mkdir -p doc/_build/html doc/_static
%if %{?rhel}%{!?rhel:6} <= 5
make -C doc html SPHINXBUILD=sphinx-1.0-build
%else
make -C doc html
%endif
rm -f doc/_build/html/.buildinfo
%endif

%install
test %{buildroot} != / && rm -rf %{buildroot}
%{__python2} setup.py install --root=%{buildroot} --skip-build

install -m755 -d %{buildroot}%{_sysconfdir}/nagios/plugins
install -m755 -d %{buildroot}%{pkg_spooldir}

%clean
test %{buildroot} != / && rm -rf %{buildroot}

%files
%dir %{pkg_sysconfdir}
%dir %{pkg_sysconfdir}/20-dist.d
%config(noreplace) %{pkg_sysconfdir}/20-dist.ini
%config(noreplace) %{pkg_sysconfdir}/20-dist.d/default.jsdl
%{nagios_bindir}/check_arcce_clean
%{nagios_bindir}/check_arcce_monitor
%{nagios_bindir}/check_arcce_submit
%{nagios_bindir}/check_aris
%{nagios_bindir}/check_arcglue2
%{nagios_bindir}/check_egiis
%{nagios_bindir}/check_arcinfosys
%{nagios_bindir}/check_archostcert
%{nagios_bindir}/check_arcservice
%{nagios_bindir}/check_gridstorage
%{python2_sitelib}/arcnagios
# Not sure precisely which Fedora version the egg-info becomes relevant.
%if %{?rhel}%{!?rhel:0} >= 6 || %{?fedora}%{!?fedora:0} >= 9
%{python2_sitelib}/nordugrid_arc_nagios_plugins-*.egg-info
%endif

%dir %{arc_spooldir}
%attr(-,nagios,nagios) %{pkg_spooldir}
%doc AUTHORS README.rst LICENSE NOTICE
%doc doc/arcnagios.ini.example
%doc doc/services.cfg.example

%if %{enable_doc}
%files doc
%doc AUTHORS README.rst LICENSE NOTICE
%doc doc/_build/html
%endif

%files egi
%doc AUTHORS README.rst LICENSE NOTICE
%dir %{pkg_sysconfdir}/60-egi.d
%config(noreplace) %{pkg_sysconfdir}/60-egi.ini
# FIXME: Prevent rpmbuild from generating these compiled objects:
%config(noreplace) %{pkg_sysconfdir}/60-egi.d/arcce_igtf.py*

%changelog
* Thu Jul 06 2017 Petter Urkedal <urkedal@nbi.dk> - 1.9.1-1
- New upstream release 1.9.1.

* Thu Jun 15 2017 Petter Urkedal <urkedal@nbi.dk> - 1.9.1rc1-0.rc1
- New upstream release candidate 1.9.1rc1.

* Wed May 31 2017 Anders Waananen <waananen@nbi.dk> - 1.9.0-1
- Updated to release 1.9.0.

* Tue Apr 25 2017 Petter Urkedal <urkedal@nbi.dk> - 1.9.0-0.rc1
- Updated to release candidate 1.9.0rc1.

* Fri Sep 11 2015 Petter Urkedal <urkedal@nbi.dk> - 1.8.4-1
- Updated to release 1.8.4.

* Mon Jul 06 2015 Anders Waananen <waananen@nbi.dk> - 1.8.3-2
- Drop doc subpackage for el5 due to missing dependencies

* Thu Jul 02 2015 Petter Urkedal <urkedal@nbi.dk> - 1.8.3-1
- Updated to release 1.8.3.

* Fri Mar 27 2015 Petter Urkedal <urkedal@nbi.dk> - 1.8.2-1
- Updated to release 1.8.2.

* Thu Jan 15 2015 Petter Urkedal <urkedal@nbi.dk> - 1.8.2-0.rc2
- Updated to release candidate 1.8.2rc2.

* Fri Jan 09 2015 Petter Urkedal <urkedal@nbi.dk> - 1.8.2-0.rc1
- Updated to release candidate 1.8.2rc1.

* Fri Aug 15 2014 Anders Waananen <waananen@nbi.dk> - 1.8.1-1
- Updated to release 1.8.1.

* Fri Jun 27 2014 Petter Urkedal <urkedal@nbi.dk> - 1.8.1-0.rc1
- Updated to release candidate 1.8.1rc1.

* Wed Apr 30 2014 Petter Urkedal <urkedal@nbi.dk> - 1.8.0-1
- Updated to release 1.8.0.

* Tue Oct 22 2013 Petter Urkedal <urkedal@nbi.dk> - 1.7.1-1
- Updated to release 1.7.1.

* Fri Aug 16 2013 Petter Urkedal <urkedal@nbi.dk> - 1.7.0-1
- Updated to release 1.7.0.

* Fri Jul 05 2013 Petter Urkedal <urkedal@nbi.dk> - 1.6.1-0.rc1
- Updated to release candidate 1.6.1rc1.

* Fri Apr 19 2013 Petter Urkedal <urkedal@nbi.dk> - 1.6.0-1
- Updated to release 1.6.0.

* Sat Apr 06 2013 Petter Urkedal <urkedal@nbi.dk> - 1.6.0-0.rc1
- Updated to release candidate 1.6.0rc1.

* Mon Feb 18 2013 Petter Urkedal <urkedal@nbi.dk> - 1.5.0-1
- Updated to release 1.5.0.

* Fri Feb 01 2013 Petter Urkedal <urkedal@nbi.dk> - 1.5.0-0.rc3
- Updated to release candidate 1.5.0rc3.

* Mon Jan 28 2013 Petter Urkedal <urkedal@nbi.dk> - 1.5.0-0.rc2
- Updated to release candidate 1.5.0rc2.

* Fri Jan 11 2013 Petter Urkedal <urkedal@nbi.dk> - 1.5.0-0.rc1
- Updated to release candidate 1.5.0rc1.

* Thu Dec 20 2012 Petter Urkedal <urkedal@nbi.dk> - 1.4.0-0.rc4
- Updated to release candidate 1.4.0rc4.

* Tue Nov 27 2012 Petter Urkedal <urkedal@nbi.dk> - 1.4.0-0.rc1
- Updated to release candidate 1.4.0rc1.

* Mon Oct 29 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.11-1
- Updated to release 1.3.11.

* Wed Sep 26 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.10-1
- Updated to release 1.3.10.

* Fri Sep 07 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.9-1
- Updated to release 1.3.9.

* Mon Apr 23 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.8-1
- Updated to release 1.3.8.

* Tue Apr 03 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.7-1
- Updated to release 1.3.7.

* Mon Apr 02 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.6-1
- Updated to release 1.3.6.

* Thu Feb 02 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.5-1
- Updated to release 1.3.5.

* Thu Feb 02 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.4-1
- Updated to release 1.3.4.

* Thu Feb 02 2012 Petter Urkedal <urkedal@nbi.dk> - 1.3.3-1
- Updated to release 1.3.3.

* Wed Dec 21 2011 Petter Urkedal <urkedal@nbi.dk> - 1.3.2-1
- Updated to release 1.3.2.

* Mon Dec 19 2011 Petter Urkedal <urkedal@nbi.dk> - 1.3.1-1
- Updated to release 1.3.1.

* Thu Dec 08 2011 Petter Urkedal <urkedal@nbi.dk> - 1.3.0-1
- Updated to release 1.3.0.

* Wed Nov 23 2011 Petter Urkedal <urkedal@nbi.dk> - 1.2.0-1
- Updated to release 1.2.0.

* Mon Nov 14 2011 Petter Urkedal <urkedal@nbi.dk>
- Change README to README.rst.
- Add documentation subpackage.

* Fri Nov 04 2011 Petter Urkedal <urkedal@nbi.dk> - 1.1.0-1
- Updated to release 1.1.0.

* Thu Nov 03 2011 Petter Urkedal <urkedal@nbi.dk>
- Install default configuration file.

* Wed Oct 26 2011 Petter Urkedal <urkedal@nbi.dk> - 1.0.2-1
- Updated to release 1.0.2.

* Thu Oct 20 2011 Petter Urkedal <urkedal@nbi.dk> - 1.0.1-1
- Updated to release 1.0.1.

* Tue Oct 18 2011 Petter Urkedal <urkedal@nbi.dk>
- Add argparse and nordugrid-arc-python dependencies.
- Install README and LICENSE.

* Fri Oct 14 2011 Petter Urkedal <urkedal@nbi.dk> - 1.0-1
- Updated to release 1.0.
- Almost complete rewrite for the new probes.

* Fri Sep 30 2011 Anders Waananen <waananen@nbi.dk> - 0.9-1
- New package name and ownership

* Thu Jun 30 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.4-1
- Fix flags to stat

* Thu Nov 18 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.3-1
- Implement changes proposed by Emir

* Mon Oct 11 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.2-1
- Remove Requires (per WLCG practice)

* Thu Sep 23 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.1-1
- Initial packaging
