/* NVTV i810 backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: back_i810.h,v 1.2 2002/08/22 20:11:39 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Backend for Intel i810, i810dc100, i810e, i815, and i815e cards; 
 * direct access.
 *
 */

#ifndef _BACK_I810_H
#define _BACK_I810_H

#include "backend.h"

extern BackCardRec bi810_func;

void bi810_openCard (CardPtr card);
void bi810_closeCard (void);
void bi810_setHeads (int main, int tv, int video);
void bi810_getHeads (int *main, int *tv, int *video, int *max);
void bi810_probeChips (void);
void bi810_setChip (ChipPtr chip, Bool init);
void bi810_setSettings (TVSettings *set);
void bi810_getSettings (TVSettings *set);
void bi810_setMode (TVRegs *r);
void bi810_getMode (TVRegs *r);
void bi810_setModeSettings (TVRegs *r, TVSettings *set);
void bi810_setTestImage (TVEncoderRegs *tv, TVSettings *set);
long bi810_getStatus (int index);
TVConnect bi810_getConnection (void);
Bool bi810_findBySize (TVSystem system, int xres, int yres, char *size, 
    TVMode *mode);
Bool bi810_findByOverscan (TVSystem system, int xres, int yres, 
    double hoc, double voc, TVMode *mode);

#endif /* _BACK_I810_H */
