/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011-2016 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "solidBodyMotionFunction.H"

// * * * * * * * * * * * * * * * * Selectors * * * * * * * * * * * * * * * * //

Foam::autoPtr<Foam::solidBodyMotionFunction> Foam::solidBodyMotionFunction::New
(
    const dictionary& SBMFCoeffs,
    const Time& runTime
)
{
    const word motionType(SBMFCoeffs.get<word>("solidBodyMotionFunction"));

    Info<< "Selecting solid-body motion function " << motionType << endl;

    auto cstrIter = dictionaryConstructorTablePtr_->cfind(motionType);

    if (!cstrIter.found())
    {
        FatalErrorInFunction
            << "Unknown solidBodyMotionFunction type "
            << motionType << nl << nl
            << "Valid solidBodyMotionFunction types :" << endl
            << dictionaryConstructorTablePtr_->sortedToc()
            << exit(FatalError);
    }

    return autoPtr<solidBodyMotionFunction>(cstrIter()(SBMFCoeffs, runTime));
}


// ************************************************************************* //
