# Release Notes v0.10.0 : Quantitative Analysis with BDD

This release introduces Binary Decision Diagrams (BDD)
and incorporates BDD-based algorithms into analysis.
For quantitative analysis,
the observed performance improvement exceeds 100x.


## Major Changes

- Probability analysis with BDD (#118)
- Importance analysis with BDD (#119)
- Uncertainty analysis with BDD (#120)
- Fault tree preprocessing for BDD (#125)
- Coherent fault tree analysis with BDD/ZBDD


## Minor Changes

- Non-coherent fault tree analysis with BDD/ZBDD (experimental)

- Boolean optimization for non-coherent fault trees (experimental)

- Adjustment of invalid calculation results
  in quantitative analyses
  due to approximations (the rare-event, MCUB)
  or invalid ranges (random distributions)
  (adjustment of probability to 1 if it exceeds 1)

- Fuzz tester for SCRAM

- Documentation style guide


## Removed Features

- The Sylvester-Poincaré expansion for probability calculations
  ('--num-sums' flag and setting are removed.)


## Bug Fixes

- Incorrect formulas for importance factors (#127)
- Proper calculation of minimal cut sets with positive literals only (#123)
- Failure to calculate constant outcome (#92)
- Fault tree generator prevents K/N root gate
- Boolean optimization fails to properly clone modules
- Decomposition of common nodes is not semantics preserving
- Distributivity preprocessing steps don't register new NULL type gates
- Preprocessor doesn't handle one-arg K/N gates in transformations
- Preprocessor doesn't handle (K > N) cases for K/N gates in transformations
- Preprocessor attempts to coalesce empty (constant) gates
- Filtering step in common argument merging fails to keep arguments unique


## Since v0.9.2

- 217 commits resulted in
  128 files changed, 9185 insertions(+), 6512 deletions(-)
