/*
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jonathan@daria.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <stdlib.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

class Socket
{
  private:

    int fd;
    int slen;
    int domain;
    int type;
    bool slave;
    struct sockaddr *name;
    
  public:
    Socket(int f)
    {
    }
    
    Socket(char *typnam, char *fnam)
    {
        slave = 0;
        name = NULL;

        domain =  (strchr(fnam, ':')) ? AF_INET : AF_UNIX;
        type = strcmp (typnam,"tcp") ? SOCK_DGRAM : SOCK_STREAM;
                
        if((fd = socket(domain, type, 0)) != -1)
        {
            if(domain == AF_UNIX)
            {
                name = (struct sockaddr*) new struct sockaddr_un;
                ((struct sockaddr_un*)name)->sun_family=AF_UNIX;
                strcpy (((struct sockaddr_un*)name)->sun_path, fnam);
                slen = SUN_LEN(((struct sockaddr_un*)name));
            }
            else
            {
                char *p;
                
                if((p = strchr(fnam, ':')))
                {
                    short port;
                    char hnam[256];
                    struct hostent *h;

                    port = (short) strtol(p+1, 0, 10);

                    if(p == fnam)
                    {
                        gethostname(hnam, sizeof (hnam));
                    }
                    else
                    {
                        int n;
                        n = p-fnam;
                        strncpy(hnam, fnam, n);
                        *(hnam+n) = 0;
                    }
                    
                    if ((h = gethostbyname (hnam)) != NULL)
                    {
                        if(port == 0)
                        {
                            struct servent *s;
                            s = getservbyname(p+1, typnam);
                            if(s)
                            {
                                port = ntohs(s->s_port);
                            }
                        }

                        name = (struct sockaddr*) new struct sockaddr_in;

                        ((struct sockaddr_in*)name)->sin_family =
                            h->h_addrtype;
                        ((struct sockaddr_in*)name)->sin_port = htons(port);
                        ((struct sockaddr_in*)name)->sin_addr =
                            *((struct in_addr *) h->h_addr);
                        slen = sizeof(struct sockaddr_in);
                    }
                    else
                    {
                        close(fd);
                        fd = -1;
                    }
                }
            }
        }
    }
    
   
    int Connect()
    {
        int res = connect (fd, name, slen);
        if(res == 0) slave = 1;
        return res;
    }

    int RecvFrom(char *buf, int len, int flags, struct sockaddr *addr = 0,
                 socklen_t *fromlen = 0)
    {
        if(addr && fromlen)
        {
            *fromlen = sizeof(struct sockaddr);
        }
        return recvfrom(fd, buf, len, flags, addr, fromlen);
    }
    
    int Recv(char *buf, int len, int flags=0)
    {
        return RecvFrom (buf, len, flags);
    }
    
    int SendTo(char *buf, int len, int flags,  struct sockaddr *addr = 0,
               socklen_t tolen = 0)
    {
        if(addr)
        {
            if(domain == AF_UNIX)
            {
                tolen = SUN_LEN(((struct sockaddr_un*)name));
            }
            else
            {
                tolen = sizeof(struct sockaddr_in);
            }
        }
        else tolen = 0;
        return sendto (fd, buf, len, flags, addr, tolen);
    }

    int Send(char *buf, int len, int flags=0)
    {
        return SendTo(buf, len, flags);
    }

    void Close()
    {
        close(fd);
        fd = -1;
        if(!slave && domain == AF_UNIX)
        {
            unlink(((struct sockaddr_un*)name)->sun_path);
        }
    }

    ~Socket()
    {
        if(fd != -1)
            Close();
        delete name;
    }
    inline bool isslave(void) { return slave;}
    inline int getfd (void) { return fd; }
};
