/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "dnd.h"

enum {
  TARGET_STRING,
  TARGET_ROOTWIN,
  TARGET_URL
};

static GtkTargetEntry target_table[] = {
  { "STRING",0, TARGET_STRING },
  { "TEXT", 0, TARGET_STRING },
  { "URL", 0, TARGET_URL },
  { "application/x-rootwin-drop", 0, TARGET_ROOTWIN }
};

static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);
extern char *drag_icon_xpm[];
/*
main form constructor
*/
DndForm::DndForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
child = NULL;
}

/*
main form destructor
*/
DndForm::~DndForm()
{
}

/*
*/
DEFINE_SIGNAL_MAP(DndForm,VDKForm)
  ON_SIGNAL(button_area,dnd_dropped_signal,OnDrop),
  ON_SIGNAL(target_area1,dnd_dropped_signal,OnDrop),
  ON_SIGNAL(target_area2,dnd_dropped_signal,OnDrop),
  ON_SIGNAL(widget_area,dnd_dropped_signal,OnDrop)
END_SIGNAL_MAP

/*
main form setup
*/
void
DndForm::GUISetup(void)
{
  SetSize(207,215);
  Title = "Drag & Drop test";
  vbox2 = new VDKBox(this,v_box);
  Add(vbox2,0,1,1,0);
  hbox4 = new VDKBox(this,h_box);
  vbox2->Add(hbox4,0,1,1,0);
  hbox4->BorderWidth(0);
  button_area = new VDKBox(this,v_box);
  button_area->SetSize(86,131);
  hbox4->Add(button_area,0,1,1,0);
  button_area->BorderWidth(0);
  button1 = new VDKCustomButton(this,"button1");
  button_area->Add(button1,0,1,1,0);
  button2 = new VDKCustomButton(this,"button2");
  button_area->Add(button2,0,1,1,0);
  button3 = new VDKCustomButton(this,"button3");
  button_area->Add(button3,0,1,1,0);
  button4 = new VDKCustomButton(this,"button4");
  button_area->Add(button4,0,1,1,0);
  button6 = new VDKCustomButton(this,"button6");
  button_area->Add(button6,0,1,1,0);
  widget_area = new VDKBox(this,v_box);
  widget_area->SetSize(73,134);
  hbox4->Add(widget_area,0,1,1,0);
  widget_area->BorderWidth(0);
  char* customlist0Titles[] = { "Title#0" };
  customlist0 = new VDKCustomList(this,1,
				  customlist0Titles,(GtkSelectionMode) 0);
  customlist0->SetSize(100,100);
  widget_area->Add(customlist0,0,1,1,0);
  entry0 = new VDKEntry(this,0);
  widget_area->Add(entry0,0,1,1,0);
  separator0 = new VDKSeparator(this,h_separator);
  vbox2->Add(separator0,0,0,0,3);
  hbox5 = new VDKBox(this,h_box);
  hbox5->SetSize(205,65);
  vbox2->Add(hbox5,0,1,1,0);
  hbox5->BorderWidth(0);
  target_area1 = new VDKBox(this,v_box);
  target_area1->SetSize(65,68);
  hbox5->Add(target_area1,0,1,1,0);
  target_area1->BorderWidth(0);
  separator1 = new VDKSeparator(this,h_separator);
  separator1->SetSize(1,39);
  hbox5->Add(separator1,0,0,0,3);
  target_area2 = new VDKBox(this,v_box);
  target_area2->SetSize(62,68);
  hbox5->Add(target_area2,0,1,1,0);
  target_area2->BorderWidth(0);
}

/*
main form setup
*/
void
DndForm::Setup(void)
{
    GUISetup(); 
    // makes a drag and drop object
    dnd = new VDKDnD(this, target_table,n_targets);
    // add sources to dnd from widget area
    dnd->AddSource(customlist0);
    dnd->AddSource(entry0);
    dnd->SetIcon(entry0,new VDKRawPixmap(this,drag_icon_xpm));    
    // add sources to dnd from button area
    dnd->AddSource(button1);
    dnd->AddSource(button2);
    dnd->AddSource(button3);
    dnd->AddSource(button4);
    dnd->AddSource(button6);
    // add targets to dnd
    dnd->AddTarget(button_area);
    dnd->AddTarget(target_area1);
    dnd->AddTarget(target_area2);
    dnd->AddTarget(widget_area);
}

/*
*/
bool 
DndForm::OnDrop(VDKObject* target) 
{
VDKObject* source = dnd->DragSource;
if(!source)
    return true;
GtkWidget* gtksource = source ? source->Widget() : NULL;
VDKObjectContainer* src_container = 
    dynamic_cast<VDKObjectContainer*>(source->Parent());
VDKObjectContainer* tgt_container = dynamic_cast<VDKObjectContainer*>(target);
if( src_container && tgt_container )
    {
    src_container->RemoveObjectFromContainer(source);
    // add to target container
    tgt_container->Add(source,l_justify,true,true,0);
    // unref again or it will leak
    gtk_widget_unref(gtksource);
    // set new parent
    source->Parent(target);
    }
return true;
}


// form event response method 
void
DndForm::OnShow(VDKForm* sender)
{
child = new TrashcanForm(this,NULL);
child->Setup();
gtk_window_set_transient_for(GTK_WINDOW(child->Window()),
                    		  GTK_WINDOW(Window()));
child->Show(GTK_WIN_POS_NONE);
return ;
}

// form event response method 
void
DndForm::OnMove(VDKForm* sender)
{
    int w,h;
    if(!child)
        return;
    VDKPoint pos = Position;
    gdk_window_get_size(GTK_WIDGET(child->Window())->window, &w, &h);
    VDKPoint p(pos.x-w-10,pos.y);
    child->Position = p;
    return;
}


/*
**************
TRASHCAN CLASS
**************
*/
DEFINE_SIGNAL_MAP(TrashcanForm,VDKForm)
  ON_SIGNAL(restore,clicked_signal,OnrestoreClick),
  ON_SIGNAL(trashcan,dnd_drag_motion_signal,OnDragMotion),
  ON_SIGNAL(trashcan,dnd_drag_leave_signal,OnDragLeave),
  ON_SIGNAL(trashcan,dnd_dropped_signal,OnDropTrash)
END_SIGNAL_MAP

static bool trash_open = false;
extern char * trashcan_open_xpm[];
extern char * trashcan_closed_xpm[];

// Trashcan FORM  CLASS
/*
form constructor
*/
TrashcanForm::TrashcanForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
    dndform = dynamic_cast<DndForm*>(owner);
}

/*
form destructor
*/
TrashcanForm::~TrashcanForm()
{
}

/*
main form setup
*/
void
TrashcanForm::GUISetup(void)
{
  SetSize(106,113);
  Title = "trashcan Form";
  vbox12 = new VDKBox(this,v_box);
  Add(vbox12,0,1,1,0);
  frame1 = new VDKFrame(this,"trashcan",v_box,shadow_etched_in);
  frame1->Shadow = shadow_in;
  frame1->Align = c_justify;
  vbox12->Add(frame1,0,1,1,0);
  VBox13 = new VDKBox(this,v_box);
  frame1->Add(VBox13,l_justify,1,1,0);
  VBox13->BorderWidth(0);
  VDKEventBox* vbox1 = new VDKEventBox(this,v_box);
  VBox13->Add(vbox1,0,1,1,0);
  vbox1->BorderWidth(0);
  trashcan = new VDKPixmap(this,trashcan_closed_xpm);
  trashcan->SetSize(98,71);
  vbox1->Add(trashcan,0,1,1,0);
  separator0 = new VDKSeparator(this,h_separator);
  vbox1->Add(separator0,0,0,0,0);
  hbox10 = new VDKBox(this,h_box);
  vbox1->Add(hbox10,0,0,0,0);
  hbox10->BorderWidth(0);
  restore = new VDKCustomButton(this,(char*) NULL,
				"Restore",16,(GtkPositionType) 0);
  hbox10->Add(restore,0,1,1,0);
}
/*
form setup
*/
void
TrashcanForm::Setup(void)
{
	GUISetup(); // vdkb gui setup

}

// form event response method 
void
TrashcanForm::OnShow(VDKForm* sender)
{
    int w,h;
    VDKPoint ownerPos = dndform->Position;
    gdk_window_get_size(GTK_WIDGET(Window())->window, &w, &h);
    VDKPoint size = VDKPoint(w,h);
    VDKPoint p(ownerPos.X()- w -10,ownerPos.Y());
    Position = p;
    dndform->DnD()->AddTarget(trashcan);
    return;
}


// signal response method 
bool
TrashcanForm::OnrestoreClick(VDKObject* sender)
{
  // shows all dropped widgets
    VDKDnDIterator li(*dndform->DnD()->DnDSources());
    for(;li;li++)
        if ( !(li.current()->Object()->Visible) )
            li.current()->Object()->Visible = true;
    restore->Enabled = false;
    return true;
}
/*
*/
bool 
TrashcanForm::OnDragLeave(VDKObject* target) 
{
trashcan->SetPixmap(trashcan_closed_xpm);
trash_open = false;
return true;
}
/*
*/
bool 
TrashcanForm::OnDragMotion(VDKObject* target) 
{
if(!trash_open)
    {
    trashcan->SetPixmap(trashcan_open_xpm);
    trash_open = true;
    }
return true;
}
/*
*/
bool 
TrashcanForm::OnDropTrash(VDKObject* target)
{
// hides dropped widget
VDKObject* source = dndform->DnD()->DragSource;
if(!source)
    return true;
else
    {
    source->Visible = false;
    restore->Enabled = true;
    }
return true;
}

/* XPM */
char * trashcan_closed_xpm[] = {
"64 80 17 1",
" 	c None",
".	c #030304",
"+	c #5A5A5C",
"@	c #323231",
"#	c #888888",
"$	c #1E1E1F",
"%	c #767677",
"&	c #494949",
"*	c #9E9E9C",
"=	c #111111",
"-	c #3C3C3D",
";	c #6B6B6B",
">	c #949494",
",	c #282828",
"'	c #808080",
")	c #545454",
"!	c #AEAEAC",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                       ==......=$$...===                        ",
"                 ..$------)+++++++++++++@$$...                  ",
"             ..=@@-------&+++++++++++++++++++-....              ",
"          =.$$@@@-&&)++++)-,$$$$=@@&+++++++++++++,..$           ",
"         .$$$$@@&+++++++&$$$@@@@-&,$,-++++++++++;;;&..          ",
"        $$$$,@--&++++++&$$)++++++++-,$&++++++;%%'%%;;$@         ",
"       .-@@-@-&++++++++-@++++++++++++,-++++++;''%;;;%*-$        ",
"       +------++++++++++++++++++++++++++++++;;%%%;;##*!.        ",
"        =+----+++++++++++++++++++++++;;;;;;;;;;;;%'>>).         ",
"         .=)&+++++++++++++++++;;;;;;;;;;;;;;%''>>#>#@.          ",
"          =..=&++++++++++++;;;;;;;;;;;;;%###>>###+%==           ",
"           .&....=-+++++%;;####''''''''''##'%%%)..#.            ",
"           .+-++@....=,+%#####'%%%%%%%%%;@$-@-@*++!.            ",
"           .+-++-+++-&-@$$=$=......$,,,@;&)+!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           =+-++-+++-+++++++++!++++!++++!+++!++!+++=            ",
"            $.++-+++-+++++++++!++++!++++!+++!++!+.$             ",
"              =.++++++++++++++!++++!++++!+++!++.=               ",
"                 $..+++++++++++++++!++++++...$                  ",
"                      $$=.............=$$                       ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                "};

/* XPM */
char * trashcan_open_xpm[] = {
"64 80 17 1",
" 	c None",
".	c #030304",
"+	c #5A5A5C",
"@	c #323231",
"#	c #888888",
"$	c #1E1E1F",
"%	c #767677",
"&	c #494949",
"*	c #9E9E9C",
"=	c #111111",
"-	c #3C3C3D",
";	c #6B6B6B",
">	c #949494",
",	c #282828",
"'	c #808080",
")	c #545454",
"!	c #AEAEAC",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                      .=.==.,@                  ",
"                                   ==.,@-&&&)-=                 ",
"                                 .$@,&++;;;%>*-                 ",
"                               $,-+)+++%%;;'#+.                 ",
"                            =---+++++;%%%;%##@.                 ",
"                           @)++++++++;%%%%'#%$                  ",
"                         $&++++++++++;%%;%##@=                  ",
"                       ,-++++)+++++++;;;'#%)                    ",
"                      @+++&&--&)++++;;%'#'-.                    ",
"                    ,&++-@@,,,,-)++;;;'>'+,                     ",
"                  =-++&@$@&&&&-&+;;;%##%+@                      ",
"                =,)+)-,@@&+++++;;;;%##%&@                       ",
"               @--&&,,@&)++++++;;;;'#)@                         ",
"              ---&)-,@)+++++++;;;%''+,                          ",
"            $--&)+&$-+++++++;;;%%'';-                           ",
"           .,-&+++-$&++++++;;;%''%&=                            ",
"          $,-&)++)-@++++++;;%''%),                              ",
"         =,@&)++++&&+++++;%'''+$@&++++++                        ",
"        .$@-++++++++++++;'#';,........=$@&++++                  ",
"       =$@@&)+++++++++++'##-.................=&++               ",
"      .$$@-&)+++++++++;%#+$.....................=)+             ",
"      $$,@-)+++++++++;%;@=........................,+            ",
"     .$$@@-++++++++)-)@=............................            ",
"     $,@---)++++&)@===............................,.            ",
"    $-@---&)))-$$=..............................=)!.            ",
"     --&-&&,,$=,==...........................=&+++!.            ",
"      =,=$..=$+)+++++&@$=.............=$@&+++++!++!.            ",
"           .)-++-+++++++++++++++++++++++++++!++!++!.            ",
"           .+-++-+++++++++++++++++++++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!+++!!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           .+-++-+++-+++++++++!++++!++++!+++!++!++!.            ",
"           =+-++-+++-+++++++++!++++!++++!+++!++!+++=            ",
"            $.++-+++-+++++++++!++++!++++!+++!++!+.$             ",
"              =.++++++++++++++!++++!++++!+++!++.=               ",
"                 $..+++++++++++++++!++++++...$                  ",
"                      $$==...........==$$                       ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                "};
/* XPM */
char* drag_icon_xpm[]={
"16 14 5 1",
"a c #d9d9d9",
"c c #7f7f7f",
"# c #000000",
". c None",
"b c #ffffff",
"................",
"................",
"..####...####...",
".#abba#.#abba#..",
"#abbbba#abbbba#.",
"#bbbbbb#bbbbbb#c",
"#bbbbbb#bbbbbb#c",
"#b##bbb#b##bbb#c",
"#a##bba#a##bba#c",
".#abba#c#abba#cc",
"..####cc.####cc.",
"...cccc...cccc..",
"................",
"................"};






