/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.SupTools.Core;
import deadbeef.Tools.ToolBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabelFilename = null;
    private JTextField jTextFieldFileName = null;
    private JButton jButtonFileName = null;
    private JLabel jLabelLanguage = null;
    private JComboBox jComboBoxLanguage = null;
    private JButton jButtonCancel = null;
    private JButton jButtonSave = null;
    private JCheckBox jCheckBoxForced = null;
    private JCheckBox jCheckBoxWritePGCPal = null;
    private JFrame mainFrame;
    private String fileName;
    private int languageIdx;
    private boolean exportForced;
    private boolean writePGCPal;
    private boolean cancel;
    private volatile boolean isReady = false;
    private String extension;

    public ExportDialog(Frame owner, boolean modal) {
        super(owner, modal);
        String sTitle;
        this.initialize();
        Point p = owner.getLocation();
        this.setLocation(p.x + owner.getWidth() / 2 - this.getWidth() / 2, p.y + owner.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
        this.mainFrame = (JFrame)owner;
        this.fileName = "";
        this.languageIdx = Core.getLanguageIdx();
        this.exportForced = Core.getNumForcedFrames() > 0 && Core.getExportForced();
        this.writePGCPal = Core.getWritePGCEditPal();
        this.cancel = false;
        int i = 0;
        while (i < Core.getLanguages().length) {
            int n = Core.getOutputMode() == Core.OutputMode.XML ? 2 : 1;
            this.jComboBoxLanguage.addItem(String.valueOf(Core.getLanguages()[i][0]) + " (" + Core.getLanguages()[i][n] + ")");
            ++i;
        }
        this.jComboBoxLanguage.setSelectedIndex(this.languageIdx);
        if (Core.getOutputMode() == Core.OutputMode.BDSUP) {
            this.jComboBoxLanguage.setEnabled(false);
        }
        if (Core.getOutputMode() == Core.OutputMode.VOBSUB || Core.getOutputMode() == Core.OutputMode.SUPIFO) {
            this.jCheckBoxWritePGCPal.setEnabled(true);
            this.jCheckBoxWritePGCPal.setSelected(this.writePGCPal);
        } else {
            this.jCheckBoxWritePGCPal.setEnabled(false);
        }
        if (Core.getNumForcedFrames() > 0) {
            this.setForced(true, this.exportForced);
        } else {
            this.setForced(false, false);
        }
        if (Core.getOutputMode() == Core.OutputMode.VOBSUB) {
            this.extension = "idx";
            sTitle = "SUB/IDX (VobSub)";
        } else if (Core.getOutputMode() == Core.OutputMode.SUPIFO) {
            this.extension = "ifo";
            sTitle = "SUP/IFO (SUP DVD)";
        } else if (Core.getOutputMode() == Core.OutputMode.BDSUP) {
            this.extension = "sup";
            sTitle = "BD SUP";
        } else {
            this.extension = "xml";
            sTitle = "XML (SONY BDN)";
        }
        this.setTitle("Export " + sTitle);
        this.isReady = true;
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(350, 160));
        this.setBounds(new Rectangle(0, 0, 350, 160));
        this.setMaximumSize(new Dimension(350, 160));
        this.setMinimumSize(new Dimension(350, 160));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExportDialog.this.cancel = true;
                ExportDialog.this.dispose();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagButtonSave = new GridBagConstraints();
            gridBagButtonSave.gridx = 2;
            gridBagButtonSave.insets = new Insets(2, 4, 2, 0);
            gridBagButtonSave.gridy = 7;
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.gridx = 0;
            gridBagButtonCancel.insets = new Insets(2, 4, 2, 0);
            gridBagButtonCancel.gridy = 7;
            GridBagConstraints gridBagCheckBoxForced = new GridBagConstraints();
            gridBagCheckBoxForced.gridx = 0;
            gridBagCheckBoxForced.insets = new Insets(0, 0, 0, 0);
            gridBagCheckBoxForced.gridwidth = 2;
            gridBagCheckBoxForced.anchor = 18;
            gridBagCheckBoxForced.gridy = 3;
            GridBagConstraints gridBagComboLanguage = new GridBagConstraints();
            gridBagComboLanguage.fill = 0;
            gridBagComboLanguage.gridy = 1;
            gridBagComboLanguage.weightx = 1.0;
            gridBagComboLanguage.anchor = 17;
            gridBagComboLanguage.insets = new Insets(2, 4, 2, 4);
            gridBagComboLanguage.gridx = 1;
            GridBagConstraints gridBagLabelLanguage = new GridBagConstraints();
            gridBagLabelLanguage.gridx = 0;
            gridBagLabelLanguage.anchor = 17;
            gridBagLabelLanguage.insets = new Insets(2, 6, 2, 0);
            gridBagLabelLanguage.gridy = 1;
            this.jLabelLanguage = new JLabel();
            this.jLabelLanguage.setText("Language");
            GridBagConstraints gridBagButtonFileName = new GridBagConstraints();
            gridBagButtonFileName.gridx = 2;
            gridBagButtonFileName.anchor = 13;
            gridBagButtonFileName.insets = new Insets(2, 0, 2, 4);
            gridBagButtonFileName.gridy = 0;
            GridBagConstraints gridBagTextFileName = new GridBagConstraints();
            gridBagTextFileName.fill = 0;
            gridBagTextFileName.gridy = 0;
            gridBagTextFileName.weightx = 1.0;
            gridBagTextFileName.anchor = 17;
            gridBagTextFileName.insets = new Insets(2, 4, 2, 4);
            gridBagTextFileName.ipadx = 200;
            gridBagTextFileName.gridx = 1;
            GridBagConstraints gridBagLabelFilename = new GridBagConstraints();
            gridBagLabelFilename.gridx = 0;
            gridBagLabelFilename.anchor = 17;
            gridBagLabelFilename.insets = new Insets(2, 6, 2, 0);
            gridBagLabelFilename.gridy = 0;
            this.jLabelFilename = new JLabel();
            this.jLabelFilename.setText("Filename");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabelFilename, gridBagLabelFilename);
            this.jContentPane.add((Component)this.getJTextFieldFileName(), gridBagTextFileName);
            this.jContentPane.add((Component)this.getJButtonFileName(), gridBagButtonFileName);
            this.jContentPane.add((Component)this.jLabelLanguage, gridBagLabelLanguage);
            this.jContentPane.add((Component)this.getJComboBoxLanguage(), gridBagComboLanguage);
            this.jContentPane.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
            this.jContentPane.add((Component)this.getJButtonSave(), gridBagButtonSave);
            this.jContentPane.add((Component)this.getJCheckBoxForced(), gridBagCheckBoxForced);
            this.jContentPane.add((Component)this.getJCheckBoxWritePGCPal(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JTextField getJTextFieldFileName() {
        if (this.jTextFieldFileName == null) {
            this.jTextFieldFileName = new JTextField();
            this.jTextFieldFileName.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldFileName.setHorizontalAlignment(10);
            this.jTextFieldFileName.setToolTipText("Set file name for export");
            this.jTextFieldFileName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s;
                    if (ExportDialog.this.isReady && (s = ExportDialog.this.jTextFieldFileName.getText()) != null) {
                        ExportDialog.this.fileName = String.valueOf(ToolBox.stripExtension(s)) + "." + ExportDialog.this.extension;
                    }
                }
            });
        }
        return this.jTextFieldFileName;
    }

    private JButton getJButtonFileName() {
        if (this.jButtonFileName == null) {
            this.jButtonFileName = new JButton();
            this.jButtonFileName.setText("Browse");
            this.jButtonFileName.setMnemonic('b');
            this.jButtonFileName.setToolTipText("Open file dialog to select file name for export");
            this.jButtonFileName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExportDialog.this.isReady) {
                        String fn;
                        String[] ext = new String[]{ExportDialog.this.extension};
                        String p = ToolBox.getPathName(ExportDialog.this.fileName);
                        String fname = ToolBox.getFileName(p, fn = ToolBox.getFileName(ExportDialog.this.fileName), ext, false, ExportDialog.this.mainFrame);
                        if (fname != null) {
                            ExportDialog.this.fileName = String.valueOf(ToolBox.stripExtension(fname)) + "." + ExportDialog.this.extension;
                            ExportDialog.this.jTextFieldFileName.setText(ExportDialog.this.fileName);
                        }
                    }
                }
            });
        }
        return this.jButtonFileName;
    }

    private JComboBox getJComboBoxLanguage() {
        if (this.jComboBoxLanguage == null) {
            this.jComboBoxLanguage = new JComboBox();
            this.jComboBoxLanguage.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxLanguage.setEditable(false);
            this.jComboBoxLanguage.setToolTipText("Set language identifier");
            this.jComboBoxLanguage.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExportDialog.this.isReady) {
                        ExportDialog.this.languageIdx = ExportDialog.this.jComboBoxLanguage.getSelectedIndex();
                    }
                }
            });
        }
        return this.jComboBoxLanguage;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Cancel export and return");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDialog.this.cancel = true;
                    ExportDialog.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setText("Save");
            this.jButtonSave.setToolTipText("Start creation of export stream");
            this.jButtonSave.setMnemonic('s');
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExportDialog.this.isReady) {
                        String s = ExportDialog.this.jTextFieldFileName.getText();
                        if (s != null) {
                            ExportDialog.this.fileName = String.valueOf(ToolBox.stripExtension(s)) + "." + ExportDialog.this.extension;
                        }
                        Core.setExportForced(ExportDialog.this.exportForced);
                        Core.setLanguageIdx(ExportDialog.this.languageIdx);
                        if (Core.getOutputMode() == Core.OutputMode.VOBSUB || Core.getOutputMode() == Core.OutputMode.SUPIFO) {
                            Core.setWritePGCEditPal(ExportDialog.this.writePGCPal);
                        }
                        ExportDialog.this.cancel = false;
                        ExportDialog.this.dispose();
                    }
                }
            });
        }
        return this.jButtonSave;
    }

    public String getFileName() {
        if (this.fileName.length() == 0) {
            return null;
        }
        return this.fileName;
    }

    public void setFileName(String fn) {
        this.fileName = fn;
        this.jTextFieldFileName.setText(this.fileName);
    }

    private void setForced(boolean en, boolean set) {
        this.exportForced = set;
        this.jCheckBoxForced.setEnabled(en);
        this.jCheckBoxForced.setSelected(set);
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    private JCheckBox getJCheckBoxForced() {
        if (this.jCheckBoxForced == null) {
            this.jCheckBoxForced = new JCheckBox();
            this.jCheckBoxForced.setToolTipText("Export only subpictures marked as 'forced'");
            this.jCheckBoxForced.setText("                 Export only forced");
            this.jCheckBoxForced.setMnemonic('f');
            this.jCheckBoxForced.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExportDialog.this.isReady) {
                        ExportDialog.this.exportForced = ExportDialog.this.jCheckBoxForced.isSelected();
                    }
                }
            });
        }
        return this.jCheckBoxForced;
    }

    private JCheckBox getJCheckBoxWritePGCPal() {
        if (this.jCheckBoxWritePGCPal == null) {
            this.jCheckBoxWritePGCPal = new JCheckBox();
            this.jCheckBoxWritePGCPal.setToolTipText("Export palette in PGCEdit text format (RGB, 0..255)");
            this.jCheckBoxWritePGCPal.setText("                 Export palette in PGCEdit text format");
            this.jCheckBoxWritePGCPal.setMnemonic('p');
            this.jCheckBoxWritePGCPal.setDisplayedMnemonicIndex(24);
            this.jCheckBoxWritePGCPal.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExportDialog.this.isReady) {
                        ExportDialog.this.writePGCPal = ExportDialog.this.jCheckBoxWritePGCPal.isSelected();
                    }
                }
            });
        }
        return this.jCheckBoxWritePGCPal;
    }
}

