/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

import java.util.Vector;

class OctTreeQuantizer {
    static final int MAX_LEVEL = 5;
    private int nodes = 0;
    private final OctTreeNode root;
    private int reduceColors;
    private int maximumColors;
    private int colors = 0;
    private final Vector[] colorList;

    public OctTreeQuantizer() {
        this.setup(256);
        this.colorList = new Vector[6];
        int i = 0;
        while (i < 6) {
            this.colorList[i] = new Vector();
            ++i;
        }
        this.root = new OctTreeNode();
    }

    public void setup(int numColors) {
        this.maximumColors = numColors;
        this.reduceColors = Math.max(512, numColors * 2);
    }

    public void addPixels(int[] pixels, int offset, int count) {
        int i = 0;
        while (i < count) {
            this.insertColor(pixels[i + offset]);
            if (this.colors > this.reduceColors) {
                this.reduceTree(this.reduceColors);
            }
            ++i;
        }
    }

    public int getIndexForColor(int argb) {
        int alpha = argb >> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        OctTreeNode node = this.root;
        int level = 0;
        while (level <= 5) {
            OctTreeNode child;
            int bit = 128 >> level;
            int index = 0;
            if ((alpha & bit) != 0) {
                index += 8;
            }
            if ((red & bit) != 0) {
                index += 4;
            }
            if ((green & bit) != 0) {
                index += 2;
            }
            if ((blue & bit) != 0) {
                ++index;
            }
            if ((child = node.leaf[index]) == null) {
                return node.index;
            }
            if (child.isLeaf) {
                return child.index;
            }
            node = child;
            ++level;
        }
        return 0;
    }

    private void insertColor(int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        OctTreeNode node = this.root;
        int level = 0;
        while (level <= 5) {
            OctTreeNode child;
            int bit = 128 >> level;
            int index = 0;
            if ((alpha & bit) != 0) {
                index += 8;
            }
            if ((red & bit) != 0) {
                index += 4;
            }
            if ((green & bit) != 0) {
                index += 2;
            }
            if ((blue & bit) != 0) {
                ++index;
            }
            if ((child = node.leaf[index]) == null) {
                ++node.children;
                child = new OctTreeNode();
                child.parent = node;
                node.leaf[index] = child;
                node.isLeaf = false;
                ++this.nodes;
                this.colorList[level].addElement(child);
                if (level == 5) {
                    child.isLeaf = true;
                    child.count = 1;
                    child.totalAlpha = alpha;
                    child.totalRed = red;
                    child.totalGreen = green;
                    child.totalBlue = blue;
                    child.level = level;
                    ++this.colors;
                    return;
                }
                node = child;
            } else {
                if (child.isLeaf) {
                    ++child.count;
                    child.totalAlpha += alpha;
                    child.totalRed += red;
                    child.totalGreen += green;
                    child.totalBlue += blue;
                    return;
                }
                node = child;
            }
            ++level;
        }
    }

    private void reduceTree(int numColors) {
        int level = 4;
        while (level >= 0) {
            Vector v = this.colorList[level];
            if (v != null && v.size() > 0) {
                int j = 0;
                while (j < v.size()) {
                    OctTreeNode node = (OctTreeNode)v.elementAt(j);
                    if (node.children > 0) {
                        int i = 0;
                        while (i < node.leaf.length) {
                            OctTreeNode child = node.leaf[i];
                            if (child != null) {
                                node.count += child.count;
                                node.totalAlpha += child.totalAlpha;
                                node.totalRed += child.totalRed;
                                node.totalGreen += child.totalGreen;
                                node.totalBlue += child.totalBlue;
                                node.leaf[i] = null;
                                --node.children;
                                --this.colors;
                                --this.nodes;
                                this.colorList[level + 1].removeElement(child);
                            }
                            ++i;
                        }
                        node.isLeaf = true;
                        ++this.colors;
                        if (this.colors <= numColors) {
                            return;
                        }
                    }
                    ++j;
                }
            }
            --level;
        }
    }

    public int[] buildColorTable() {
        int[] table = new int[this.colors];
        this.buildColorTable(this.root, table, 0);
        return table;
    }

    public void buildColorTable(int[] inPixels, int[] table) {
        int count = inPixels.length;
        this.maximumColors = table.length;
        int i = 0;
        while (i < count) {
            this.insertColor(inPixels[i]);
            if (this.colors > this.reduceColors) {
                this.reduceTree(this.reduceColors);
            }
            ++i;
        }
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        this.buildColorTable(this.root, table, 0);
    }

    private int buildColorTable(OctTreeNode node, int[] table, int index) {
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        if (node.isLeaf) {
            int count = node.count;
            table[index] = node.totalAlpha / count << 24 | node.totalRed / count << 16 | node.totalGreen / count << 8 | node.totalBlue / count;
            node.index = index++;
        } else {
            int i = 0;
            while (i < node.leaf.length) {
                if (node.leaf[i] != null) {
                    node.index = index;
                    index = this.buildColorTable(node.leaf[i], table, index);
                }
                ++i;
            }
        }
        return index;
    }

    class OctTreeNode {
        int children;
        int level;
        OctTreeNode parent;
        final OctTreeNode[] leaf = new OctTreeNode[16];
        boolean isLeaf;
        int count;
        int totalAlpha;
        int totalRed;
        int totalGreen;
        int totalBlue;
        int index;

        OctTreeNode() {
        }
    }
}

