// Instruction handlers for the m68000 (indirect, partial, cpu)
//
// Generated by m68000gen.py sip m68000.lst m68000-sip.cpp

#include "emu.h"
#include "m68000.h"

void m68000_device::state_reset_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 002 rstp3
	m_icount -= 2;
	// 296 rstp4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_ftu_const();
	m_icount -= 2;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 27e rstp5
	debugger_exception_hook(0x00);
	m_ftu = 0x0000;
	m_icount -= 2;
	// 27f rstp6
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_sr |= 0x0700;
	update_interrupt();
	m_au = ext32(m_ftu);
	m_icount -= 2;
	// 2fb rstp7
	m_aob = m_au;
	set_16h(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2ff rstp8
	m_aob = m_au;
	set_16h(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 300 rstp9
	m_aob = m_au;
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	set_16l(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 11e rstpa
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_bus_error_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 003 bser1
	m_ssw = m_base_ssw | (m_sr & SR_S ? SSW_S : 0);
	m_at = m_aob;
	m_ftu = m_sr;
	m_au = m_pc;
	m_icount -= 2;
	// 3a7 bser2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3ca bser3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0a2 bser4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_ftu = m_ird;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c6 bser5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 088 bser6
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_pc = m_at;
	m_ftu = (m_ftu & ~0x1f) | m_ssw;
	m_au = m_au - 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.atl:m_at d=-1
	alu_and(m_at, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x02);
	m_da[16] = m_au;
	m_ftu = 0x0008;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 15:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 19:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_address_error_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 003 bser1
	m_ssw = m_base_ssw | (m_sr & SR_S ? SSW_S : 0);
	m_at = m_aob;
	m_ftu = m_sr;
	m_au = m_pc;
	m_icount -= 2;
	// 3a7 bser2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3ca bser3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0a2 bser4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_ftu = m_ird;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c6 bser5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 088 bser6
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_pc = m_at;
	m_ftu = (m_ftu & ~0x1f) | m_ssw;
	m_au = m_au - 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.atl:m_at d=-1
	alu_and(m_at, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x03);
	m_da[16] = m_au;
	m_ftu = 0x000c;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 15:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	[[fallthrough]]; case 19:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	[[fallthrough]]; case 20:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 21:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	[[fallthrough]]; case 22:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_double_fault_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 001 halt1
	m_icount = 0;
	}
}

void m68000_device::state_interrupt_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 1c4 itlx1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 234 itlx2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_alub = m_ftu;
	m_pc = m_au;
	m_sr = (m_sr & ~SR_I) | ((m_next_state >> 16) & SR_I);
	update_interrupt();
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_icount -= 2;
	// 235 itlx3
	m_ftu = 0xfff0 | ((m_next_state >> 23) & 0xe);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	// 0eb itlx4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 236 itlx5
	m_aob = m_at;
	m_base_ssw = SSW_CPU | SSW_R | SSW_N;
	start_interrupt_vector_lookup();
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_cpu(m_aob, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	end_interrupt_vector_lookup();
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 118 itlx6
	m_ir = m_irc;
	m_icount -= 2;
	// 292 itlx7
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_ftu_const();
	m_icount -= 2;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook((m_int_vector) >> 2);
	m_da[16] = m_au;
	m_ftu = m_int_vector;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 15:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_trace_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x09);
	m_da[16] = m_au;
	m_ftu = 0x0024;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_illegal_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x04);
	m_da[16] = m_au;
	m_ftu = 0x0010;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_priviledge_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x08);
	m_da[16] = m_au;
	m_ftu = 0x0020;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_linea_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x0a);
	m_da[16] = m_au;
	m_ftu = 0x0028;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::state_linef_ip()
{
	switch(m_inst_substate) {
	case 0:
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.aul:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x0b);
	m_da[16] = m_au;
	m_ftu = 0x002c;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=R.pch:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_ds_ip() // 0000 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_or8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_ais_ip() // 0010 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_aips_ip() // 0018 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_pais_ip() // 0020 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_das_ip() // 0028 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_dais_ip() // 0030 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_adr16_ip() // 0038 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_b_imm8_adr32_ip() // 0039 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_imm8_ccr_ip() // 003c ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.ftu:m_ftu d=R.dtl:m_dt
	alu_or8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.aluo:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_ds_ip() // 0040 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_ais_ip() // 0050 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_aips_ip() // 0058 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_pais_ip() // 0060 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_das_ip() // 0068 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_dais_ip() // 0070 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=....... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_adr16_ip() // 0078 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_w_imm16_adr32_ip() // 0079 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_i16u_sr_ip() // 007c ffff
{
	switch(m_inst_substate) {
	case 0:
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=14 c=2 m=.....  i=....... ALU.or_ a=R.ftu:m_ftu d=R.dtl:m_dt
	alu_or(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.aluo:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_ds_ip() // 0080 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=18:m_da[ry]
	alu_or(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.aluo:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_ais_ip() // 0090 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_aips_ip() // 0098 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_pais_ip() // 00a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_das_ip() // 00a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_dais_ip() // 00b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=14 c=5 m=.....  i=.l..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_adr16_ip() // 00b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::ori_l_imm32_adr32_ip() // 00b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f ALU.or_ a=23:m_dt d=R.alue:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_ds_ip() // 0100 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e7 btsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dxl:m_da[rx] d=R.dyl:m_da[ry]
	alu_eor(m_da[rx], m_da[ry]);
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=18:m_da[ry] d=R.dcro:m_dcro
	alu_and(high16(m_da[ry]), 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::movep_w_das_dd_ip() // 0108 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1d2 mpiw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 29a mpiw2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	set_8h(m_dbin, m_edb);
	// 368 mpiw3
	m_aob = m_au;
	m_ir = m_irc;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_8(m_dbin, m_edb);
	// 36a mpiw4
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_ais_ip() // 0110 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_aips_ip() // 0118 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_pais_ip() // 0120 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_das_ip() // 0128 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_dais_ip() // 0130 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_adr16_ip() // 0138 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_adr32_ip() // 0139 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_dpc_ip() // 013a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_dpci_ip() // 013b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_dd_imm_ip() // 013c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 0ab btsi1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16h(m_dt, high16(m_at));
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_dt;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_dt, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=23:m_dt d=R.dcro8:m_dcro8
	alu_and8(high16(m_dt), 1 << (m_dcr & 7));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_ds_ip() // 0140 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dxl:m_da[rx] d=R.dyl:m_da[ry]
	alu_eor(m_da[rx], m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=2 m=.....  i=....... ALU.eor a=R.dyl:m_da[ry] d=R.dcro:m_dcro
	alu_eor(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=13 c=2 m=.....  i=....... ALU.eor a=18:m_da[ry] d=R.dcro:m_dcro
	alu_eor(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::movep_l_das_dd_ip() // 0148 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1d6 mpil1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 29e mpil2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	set_8h(m_dbin, m_edb);
	// 34e mpil3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_8(m_dbin, m_edb);
	// 34f mpil4
	m_aob = m_au;
	set_16h(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_8h(m_dbin, m_edb);
	// 368 mpiw3
	m_aob = m_au;
	m_ir = m_irc;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_8(m_dbin, m_edb);
	// 36a mpiw4
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_ais_ip() // 0150 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_aips_ip() // 0158 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_pais_ip() // 0160 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_das_ip() // 0168 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_dais_ip() // 0170 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_adr16_ip() // 0178 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_dd_adr32_ip() // 0179 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_ds_ip() // 0180 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3eb bclr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dxl:m_da[rx] d=R.dyl:m_da[ry]
	alu_or(m_da[rx], m_da[ry]);
	// 06e bclr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=.l..... ALU.or_ a=R.dyl:m_da[ry] d=R.dcro:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bclr3;
	else
		goto bclr4;
bclr4:
	// 0cc bclr4
	// alu r=14 c=4 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=R.dcro:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bclr3:
	// 08c bclr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=.l..... ALU.or_ a=18:m_da[ry] d=R.dcro:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c8 bclr5
	// alu r=14 c=4 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=R.dcro:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::movep_w_dd_das_ip() // 0188 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1ca mpow1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 36d mpow2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xh(m_dbout, m_da[rx]);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=R.dxl:m_da[rx]
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 36e mpow3
	m_aob = m_au;
	set_8xl(m_dbout, m_da[rx]);
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_ais_ip() // 0190 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_aips_ip() // 0198 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_pais_ip() // 01a0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_das_ip() // 01a8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_dais_ip() // 01b0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_adr16_ip() // 01b8 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_dd_adr32_ip() // 01b9 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_ds_ip() // 01c0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dxl:m_da[rx] d=R.dyl:m_da[ry]
	alu_or(m_da[rx], m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=....... ALU.or_ a=R.dyl:m_da[ry] d=R.dcro:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=....... ALU.or_ a=18:m_da[ry] d=R.dcro:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::movep_l_dd_das_ip() // 01c8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1ce mpol1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 36b mpol2
	m_aob = m_au;
	set_8xh(m_dbout, high16(m_da[rx]));
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=16:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 36c mpol3
	m_aob = m_au;
	set_8xl(m_dbout, high16(m_da[rx]));
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=16:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 36d mpow2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xh(m_dbout, m_da[rx]);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=R.dxl:m_da[rx]
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 36e mpow3
	m_aob = m_au;
	set_8xl(m_dbout, m_da[rx]);
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_ais_ip() // 01d0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_aips_ip() // 01d8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_pais_ip() // 01e0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_das_ip() // 01e8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_dais_ip() // 01f0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_adr16_ip() // 01f8 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_dd_adr32_ip() // 01f9 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dxl:m_da[rx] d=R.dbin:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_ds_ip() // 0200 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_and8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_ais_ip() // 0210 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_aips_ip() // 0218 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_pais_ip() // 0220 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_das_ip() // 0228 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_dais_ip() // 0230 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=4 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_adr16_ip() // 0238 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_b_imm8_adr32_ip() // 0239 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_imm8_ccr_ip() // 023c ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=4 c=2 m=.....  i=b...... ALU.and_ a=R.ftu:m_ftu d=R.dtl:m_dt
	alu_and8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.aluo:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=4 c=0 m=.....  i=b...... ALU.and_ a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_ds_ip() // 0240 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_and(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_ais_ip() // 0250 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_aips_ip() // 0258 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_pais_ip() // 0260 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_das_ip() // 0268 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_dais_ip() // 0270 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=4 c=5 m=.....  i=....... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_adr16_ip() // 0278 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_w_imm16_adr32_ip() // 0279 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_i16u_sr_ip() // 027c ffff
{
	switch(m_inst_substate) {
	case 0:
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=4 c=2 m=.....  i=....... ALU.and_ a=R.ftu:m_ftu d=R.dtl:m_dt
	alu_and(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.aluo:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=4 c=0 m=.....  i=....... ALU.and_ a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_ds_ip() // 0280 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_and(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=18:m_da[ry]
	alu_and(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.aluo:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_ais_ip() // 0290 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_aips_ip() // 0298 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_pais_ip() // 02a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_das_ip() // 02a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_dais_ip() // 02b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=4 c=5 m=.....  i=.l..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_adr16_ip() // 02b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::andi_l_imm32_adr32_ip() // 02b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. ALU.and_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f ALU.and_ a=23:m_dt d=R.alue:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... ALU.and_ a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_ds_ip() // 0400 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_sub8(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_ais_ip() // 0410 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_aips_ip() // 0418 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_pais_ip() // 0420 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_das_ip() // 0428 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_dais_ip() // 0430 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=5 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_adr16_ip() // 0438 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_b_imm8_adr32_ip() // 0439 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_ds_ip() // 0440 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_ais_ip() // 0450 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_aips_ip() // 0458 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_pais_ip() // 0460 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_das_ip() // 0468 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_dais_ip() // 0470 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=5 c=5 m=.....  i=....... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_adr16_ip() // 0478 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_w_imm16_adr32_ip() // 0479 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_ds_ip() // 0480 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_xnzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=18:m_da[ry]
	alu_subc(high16(m_dt), high16(m_da[ry]));
	sr_xnzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_ais_ip() // 0490 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_aips_ip() // 0498 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_pais_ip() // 04a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_das_ip() // 04a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_dais_ip() // 04b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=5 c=5 m=.....  i=.l..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_adr16_ip() // 04b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::subi_l_imm32_adr32_ip() // 04b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_ds_ip() // 0600 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_add8(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_ais_ip() // 0610 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_aips_ip() // 0618 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_pais_ip() // 0620 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_das_ip() // 0628 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_dais_ip() // 0630 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_adr16_ip() // 0638 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_b_imm8_adr32_ip() // 0639 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_ds_ip() // 0640 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_add(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_ais_ip() // 0650 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_aips_ip() // 0658 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_pais_ip() // 0660 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_das_ip() // 0668 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_dais_ip() // 0670 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=....... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_adr16_ip() // 0678 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_w_imm16_adr32_ip() // 0679 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_ds_ip() // 0680 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_add(m_dt, m_da[ry]);
	sr_xnzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=18:m_da[ry]
	alu_addc(high16(m_dt), high16(m_da[ry]));
	sr_xnzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_ais_ip() // 0690 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_aips_ip() // 0698 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_pais_ip() // 06a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_das_ip() // 06a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_dais_ip() // 06b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=.l..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_adr16_ip() // 06b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::addi_l_imm32_adr32_ip() // 06b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. ALU.add a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f ALU.addc a=23:m_dt d=R.alue:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_ds_ip() // 0800 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3e7 btsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=18:m_da[ry] d=R.dcro:m_dcro
	alu_and(high16(m_da[ry]), 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_ais_ip() // 0810 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_aips_ip() // 0818 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_pais_ip() // 0820 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_das_ip() // 0828 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_dais_ip() // 0830 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_adr16_ip() // 0838 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_adr32_ip() // 0839 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_dpc_ip() // 083a ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::btst_imm8_dpci_ip() // 083b ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_ds_ip() // 0840 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=2 m=.....  i=....... ALU.eor a=R.dyl:m_da[ry] d=R.dcro:m_dcro
	alu_eor(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=13 c=2 m=.....  i=....... ALU.eor a=18:m_da[ry] d=R.dcro:m_dcro
	alu_eor(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_ais_ip() // 0850 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_aips_ip() // 0858 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_pais_ip() // 0860 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_das_ip() // 0868 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_dais_ip() // 0870 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_adr16_ip() // 0878 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bchg_imm8_adr32_ip() // 0879 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_ds_ip() // 0880 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3eb bclr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... ALU.or_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	// 06e bclr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=.l..... ALU.or_ a=R.dyl:m_da[ry] d=R.dcro:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bclr3;
	else
		goto bclr4;
bclr4:
	// 0cc bclr4
	// alu r=14 c=4 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=R.dcro:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bclr3:
	// 08c bclr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=.l..... ALU.or_ a=18:m_da[ry] d=R.dcro:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c8 bclr5
	// alu r=14 c=4 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=R.dcro:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_ais_ip() // 0890 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_aips_ip() // 0898 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_pais_ip() // 08a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_das_ip() // 08a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_dais_ip() // 08b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_adr16_ip() // 08b8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bclr_imm8_adr32_ip() // 08b9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... ALU.eor a=R.aluo:m_aluo d=R.dcro8:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_ds_ip() // 08c0 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=....... ALU.or_ a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=....... ALU.or_ a=R.dyl:m_da[ry] d=R.dcro:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=....... ALU.or_ a=18:m_da[ry] d=R.dcro:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. ALU.and_ a=alub d=R.dcro:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_ais_ip() // 08d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_aips_ip() // 08d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_pais_ip() // 08e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_das_ip() // 08e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_dais_ip() // 08f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_adr16_ip() // 08f8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::bset_imm8_adr32_ip() // 08f9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... ALU.or_ a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... ALU.or_ a=R.dbin:m_dbin d=R.dcro8:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. ALU.and_ a=alub d=R.dcro8:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_ds_ip() // 0a00 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_eor8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_ais_ip() // 0a10 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_aips_ip() // 0a18 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_pais_ip() // 0a20 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_das_ip() // 0a28 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_dais_ip() // 0a30 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_adr16_ip() // 0a38 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_b_imm8_adr32_ip() // 0a39 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_imm8_ccr_ip() // 0a3c ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=13 c=2 m=.....  i=b...... ALU.eor a=R.ftu:m_ftu d=R.dtl:m_dt
	alu_eor8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.aluo:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_ds_ip() // 0a40 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_ais_ip() // 0a50 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_aips_ip() // 0a58 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_pais_ip() // 0a60 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_das_ip() // 0a68 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_dais_ip() // 0a70 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=....... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_adr16_ip() // 0a78 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_w_imm16_adr32_ip() // 0a79 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_i16u_sr_ip() // 0a7c ffff
{
	switch(m_inst_substate) {
	case 0:
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=13 c=2 m=.....  i=....... ALU.eor a=R.ftu:m_ftu d=R.dtl:m_dt
	alu_eor(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.aluo:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=....... ALU.eor a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_ds_ip() // 0a80 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=18:m_da[ry]
	alu_eor(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_ais_ip() // 0a90 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_aips_ip() // 0a98 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_pais_ip() // 0aa0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 11:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_das_ip() // 0aa8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_dais_ip() // 0ab0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=13 c=5 m=.....  i=.l..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.aluo:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.rzl:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 17:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_adr16_ip() // 0ab8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 13:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::eori_l_imm32_adr32_ip() // 0ab9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dbin:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=R.dbin:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. ALU.eor a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f ALU.eor a=23:m_dt d=R.alue:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 15:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	[[fallthrough]]; case 16:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... ALU.eor a=none d=none
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 17:
	m_mmu->write_data(m_aob & ~1, m_dbout, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	[[fallthrough]]; case 18:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_ds_ip() // 0c00 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 108 rcaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_sub8(m_dt, m_da[ry]);
	sr_nzvc();
	// 23a rcaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_ais_ip() // 0c10 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_aips_ip() // 0c18 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_pais_ip() // 0c20 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_das_ip() // 0c28 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_dais_ip() // 0c30 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=6 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_adr16_ip() // 0c38 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_b_imm8_adr32_ip() // 0c39 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_ds_ip() // 0c40 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 108 rcaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_nzvc();
	// 23a rcaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_ais_ip() // 0c50 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_aips_ip() // 0c58 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_pais_ip() // 0c60 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_das_ip() // 0c68 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_dais_ip() // 0c70 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=6 c=5 m=.....  i=....... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_adr16_ip() // 0c78 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_w_imm16_adr32_ip() // 0c79 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_ds_ip() // 0c80 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	if(!m_cmpild_instr_callback.isnull()) (m_cmpild_instr_callback)(ry, (m_dt & 0xffff0000) | m_dbin);
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 104 rcal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dyl:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_nzvc();
	// 239 rcal2
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=18:m_da[ry]
	alu_subc(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 08d rcal3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_ais_ip() // 0c90 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_aips_ip() // 0c98 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_pais_ip() // 0ca0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_das_ip() // 0ca8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_dais_ip() // 0cb0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=6 c=5 m=.....  i=.l..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_adr16_ip() // 0cb8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::cmpi_l_imm32_adr32_ip() // 0cb9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. ALU.sub a=R.dtl:m_dt d=R.dbin:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f ALU.subc a=23:m_dt d=R.alue:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_dd_ip() // 1000 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 121 rrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	// 27a rrgw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[rx], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_dd_ip() // 1010 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_dd_ip() // 1018 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_dd_ip() // 1020 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_dd_ip() // 1028 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_dd_ip() // 1030 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_dd_ip() // 1038 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_dd_ip() // 1039 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_dd_ip() // 103a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_dd_ip() // 103b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_dd_ip() // 103c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 121 rrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_dt;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	// 27a rrgw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[rx], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_aid_ip() // 1080 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2fa rmrw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_aid_ip() // 1090 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_aid_ip() // 1098 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_aid_ip() // 10a0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_aid_ip() // 10a8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_aid_ip() // 10b0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_aid_ip() // 10b8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_aid_ip() // 10b9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_aid_ip() // 10ba f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_aid_ip() // 10bb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_aid_ip() // 10bc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2fa rmrw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_aipd_ip() // 10c0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2fe rmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 1:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_aipd_ip() // 10d0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_aipd_ip() // 10d8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_aipd_ip() // 10e0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_aipd_ip() // 10e8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_aipd_ip() // 10f0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_aipd_ip() // 10f8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_aipd_ip() // 10f9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_aipd_ip() // 10fa f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_aipd_ip() // 10fb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_aipd_ip() // 10fc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2fe rmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_paid_ip() // 1100 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2f8 rmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_paid_ip() // 1110 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_paid_ip() // 1118 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_paid_ip() // 1120 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_paid_ip() // 1128 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_paid_ip() // 1130 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_paid_ip() // 1138 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_paid_ip() // 1139 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_paid_ip() // 113a f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_paid_ip() // 113b f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_paid_ip() // 113c f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2f8 rmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_dad_ip() // 1140 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2da rmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_dbin) + m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_dad_ip() // 1150 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_dad_ip() // 1158 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_dad_ip() // 1160 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_dad_ip() // 1168 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_dad_ip() // 1170 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_dad_ip() // 1178 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_dad_ip() // 1179 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_dad_ip() // 117a f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_dad_ip() // 117b f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_dad_ip() // 117c f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2da rmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_dbin) + m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_daid_ip() // 1180 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 1eb rmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 109 rmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto rmxw3;
	else
		goto rmxw2;
rmxw2:
	// 128 rmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmxw3:
	// 1e8 rmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmdw2:
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_daid_ip() // 1190 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_daid_ip() // 1198 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_daid_ip() // 11a0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_daid_ip() // 11a8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_daid_ip() // 11b0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_daid_ip() // 11b8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_daid_ip() // 11b9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_daid_ip() // 11ba f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_daid_ip() // 11bb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.aluo:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_daid_ip() // 11bc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1eb rmxw0
	// alu r=2 c=5 m=.....  i=bl..... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 109 rmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto rmxw3;
	else
		goto rmxw2;
rmxw2:
	// 128 rmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmxw3:
	// 1e8 rmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmdw2:
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=bl...i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_adr16_ip() // 11c0 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 2d9 raww1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_da[ry]);
	m_au = ext32(m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 3:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_adr16_ip() // 11d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_adr16_ip() // 11d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_adr16_ip() // 11e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_adr16_ip() // 11e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_adr16_ip() // 11f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_adr16_ip() // 11f8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_adr16_ip() // 11f9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_adr16_ip() // 11fa ffff
{
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_adr16_ip() // 11fb ffff
{
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_adr16_ip() // 11fc ffff
{
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2d9 raww1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_dt);
	m_au = ext32(m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ds_adr32_ip() // 13c0 fff8
{
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 1ea ralw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2bb ralw2
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_da[ry]);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_ais_adr32_ip() // 13d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_aips_adr32_ip() // 13d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_pais_adr32_ip() // 13e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 5:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_das_adr32_ip() // 13e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dais_adr32_ip() // 13f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr16_adr32_ip() // 13f8 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_adr32_adr32_ip() // 13f9 ffff
{
	switch(m_inst_substate) {
	case 0:
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_data(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 7:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 9:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpc_adr32_ip() // 13fa ffff
{
	switch(m_inst_substate) {
	case 0:
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_dpci_adr32_ip() // 13fb ffff
{
	switch(m_inst_substate) {
	case 0:
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... ALU.ext a=R.dbin:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 13:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	[[fallthrough]]; case 14:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 11:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	[[fallthrough]]; case 12:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_b_imm8_adr32_ip() // 13fc ffff
{
	switch(m_inst_substate) {
	case 0:
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1ea ralw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 2bb ralw2
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_dt);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. ALU.and_ a=R.dtl:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	[[fallthrough]]; case 7:
	m_mmu->write_data(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	[[fallthrough]]; case 8:
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 9:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	[[fallthrough]]; case 10:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_l_ds_dd_ip() // 2000 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	switch(m_inst_substate) {
	case 0:
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. ALU.and_ a=R.dyl:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=2 c=1 m=.nz..  i=......f ALU.and_ a=18:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	sr_nz_u();
	m_da[rx] = m_at;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_l_as_dd_ip() // 2008 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. ALU.and_ a=R.ayl:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_at;
	// alu r=2 c=1 m=.nz..  i=......f ALU.and_ a=17:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_l_ais_dd_ip() // 2010 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_l_aips_dd_ip() // 2018 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	[[fallthrough]]; case 4:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f ALU.and_ a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	[[fallthrough]]; case 5:
	m_edb = m_mmu->read_program(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	[[fallthrough]]; case 6:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	m_inst_substate = 0;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
	}
}

void m68000_device::move_l_pais_dd_ip() // 2020 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	switch(m_inst_substate) {
	case 0:
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=....... ALU.and_ a=R.dbin:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 1:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	[[fallthrough]]; case 2:
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		m_inst_substate = 0;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	[[fallthrough]]; case 3:
	m_edb = m_mmu->read_data(m_aob & ~1, 0xffff);
	m_icount -= 4;
	if(m_icount <= 0) {
		