# -*- coding: utf-8 -*-

# downloadingwidgets.py
# This file is part of qarte-5
#    
# Author: Vincent Vande Vyvre <vincent.vandevyvre@oqapy.eu>
# Copyright: 2011-2022 Vincent Vande Vyvre
# Licence: GPL3
# Home page: https://launchpad.net/qarte
#
# Define the downloading widgets

from PyQt5.QtCore import (Qt, QSize)
from PyQt5.QtGui import (QIcon, QPixmap)
from PyQt5.QtWidgets import (QWidget, QVBoxLayout, QHBoxLayout, QLabel, 
                             QProgressBar, QPushButton, QSpacerItem,)


class DownloadingWidgets(QWidget):
    """Define the dowloading widgets; buttons, progressBar, labels.

    """
    def __init__(self, ui, parent=None):
        super().__init__(parent)
        self.setMaximumSize(QSize(300, 16777215))
        self.ui = ui
        self.vl_13 = QVBoxLayout(self)
        self.vl_13.setContentsMargins(2, 0, 2, 2)
        self.vl_13.setSpacing(2)
        self.hl_13 = QHBoxLayout()
        self.hl_13.setSpacing(0)
        self.dwnld_btn = QPushButton(self)
        self.dwnld_btn.setMinimumSize(QSize(50, 40))
        self.dwnld_btn.setMaximumSize(QSize(50, 40))
        self.dwnld_btn.setStyleSheet("QPushButton:hover" 
                                            "{border: 2px solid #9900FF;}")
        self.dwnld_btn.setStatusTip(_(u"Download"))
        icon4 = QIcon()
        icon4.addPixmap(QPixmap("medias/download_44x30.png"), 
                                QIcon.Normal, QIcon.Off)
        self.dwnld_btn.setIcon(icon4)
        self.dwnld_btn.setIconSize(QSize(44, 30))
        self.dwnld_btn.setFlat(True)
        self.dwnld_btn.setEnabled(False)
        self.dwnld_btn.setObjectName("dwnld_btn")
        self.hl_13.addWidget(self.dwnld_btn)
        self.progressBar = QProgressBar(self)
        self.progressBar.setProperty("value", 0)
        self.progressBar.setMinimumSize(QSize(100, 32))
        self.progressBar.setObjectName("progressBar")
        self.hl_13.addWidget(self.progressBar)
        self.cancel_btn = QPushButton(self)
        self.cancel_btn.setMinimumSize(QSize(50, 40))
        self.cancel_btn.setMaximumSize(QSize(50, 40))
        self.cancel_btn.setStyleSheet("""QPushButton:hover 
                                            {border: 2px solid #9900FF;}""")
        icon5 = QIcon()
        icon5.addPixmap(QPixmap("medias/stop_44x30.png"), 
                                QIcon.Normal, QIcon.Off)
        self.cancel_btn.setIcon(icon5)
        self.cancel_btn.setIconSize(QSize(44, 30))
        self.cancel_btn.setShortcut("Ctrl+S")
        self.cancel_btn.setFlat(True)
        self.cancel_btn.setEnabled(False)
        self.cancel_btn.setStatusTip(_(u"Cancel download"))
        self.cancel_btn.setObjectName("cancel_btn")
        self.hl_13.addWidget(self.cancel_btn)
        self.vl_13.addLayout(self.hl_13)
        self.progress_lbl = QLabel(self)
        self.progress_lbl.setAlignment(Qt.AlignCenter)
        self.progress_lbl.setText("")
        self.progress_lbl.setObjectName("progress_lbl")
        self.vl_13.addWidget(self.progress_lbl)
        self.progress_lbl2 = QLabel(self)
        self.progress_lbl2.setAlignment(Qt.AlignCenter)
        self.progress_lbl2.setText("")
        self.progress_lbl2.setObjectName("progress_lbl2")
        self.vl_13.addWidget(self.progress_lbl2)

    def clear(self, all_=False):
        self.progressBar.setValue(0)
        self.cancel_btn.setEnabled(False)
        self.progress_lbl.setText("")
        self.progress_lbl2.setText("")
        if all_:
            self.dwnld_btn.setEnabled(False)

    def on_progress(self):
        self.dwnld_btn.setEnabled(False)
        self.cancel_btn.setEnabled(True)

    def set_merging_message(self, state):
        self.clear()
        if state:
            self.progress_lbl.setText("Merging audio-video ...")
            self.progressBar.setRange(0, 0)

        else:
            self.progressBar.setRange(0, 100)



