/********************************************************************
 *
 * fmsndlib.c
 *
 * (c) Copyright 2005 Sonic Network, Inc. All Rights Reserved

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Source: C:\Sonic\Source\Gen3.3\FMSynth\GMdblib-3.fml
 ********************************************************************/


#include "eas_data.h"

/* begin region data */
/*lint -e{651} lint complains about unnecessary brackets */
static const S_FM_REGION regions[] =
{

	/* Region 0 */
	{
		0x8005, 0, 127, 0, 255, 8, 0,
		514, 239, 47, 97, 0, 184, 3,
		1, 244, 89, 114, 0, 248, 2,
		3370, 244, 49, 76, 40, 192, 2,
		-1, 227, 97, 51, 160, 212, 2
	},

	/* Region 1 */
	{
		0x8005, 0, 127, 160, 255, 8, 0,
		2514, 223, 95, 72, 0, 176, 3,
		1, 244, 73, 145, 0, 244, 2,
		3600, 245, 81, 198, 40, 192, 2,
		3, 246, 81, 163, 108, 212, 2
	},

	/* Region 2 */
	{
		0x8005, 0, 127, 160, 255, 119, 0,
		0, 216, 79, 72, 0, 216, 2,
		2, 244, 73, 145, 0, 244, 2,
		3370, 247, 33, 182, 60, 204, 2,
		1200, 246, 65, 163, 108, 204, 2
	},

	/* Region 3 */
	{
		0x8005, 0, 127, 160, 255, 1, 0,
		3369, 248, 65, 71, 40, 208, 2,
		-3, 245, 88, 113, 0, 244, 2,
		2784, 225, 65, 133, 80, 192, 2,
		3, 241, 81, 113, 80, 216, 2
	},

	/* Region 4 */
	{
		0x8002, 0, 127, 0, 255, 128, 0,
		0, 229, 155, 183, 0, 228, 2,
		-3, 243, 90, 81, 0, 244, 2,
		4800, 248, 109, 180, 36, 192, 2,
		3, 245, 90, 85, 16, 244, 2
	},

	/* Region 5 */
	{
		0x8002, 0, 127, 9, 96, 192, 0,
		1200, 229, 157, 180, 0, 216, 2,
		-3, 244, 90, 81, 0, 244, 2,
		1902, 255, 111, 182, 80, 208, 2,
		3, 246, 92, 83, 0, 244, 2
	},

	/* Region 6 */
	{
		0x8002, 0, 127, 0, 255, 154, 0,
		3102, 244, 63, 102, 228, 228, 2,
		1200, 247, 93, 97, 0, 236, 2,
		1902, 255, 63, 98, 156, 220, 2,
		1200, 244, 92, 98, 0, 236, 2
	},

	/* Region 7 */
	{
		0x8005, 0, 127, 0, 255, 202, 0,
		0, 251, 131, 19, 216, 220, 2,
		1201, 247, 62, 113, 0, 240, 2,
		0, 243, 154, 36, 240, 224, 2,
		2784, 250, 61, 36, 240, 208, 2
	},

	/* Region 8 */
	{
		0x8001, 0, 127, 0, 255, 80, 0,
		-1, 213, 191, 183, 0, 204, 2,
		1, 245, 154, 129, 0, 244, 2,
		3831, 252, 159, 100, 0, 200, 2,
		1197, 246, 91, 182, 0, 244, 2
	},

	/* Region 9 */
	{
		0x8002, 0, 127, 48, 80, 21, 0,
		2982, 255, 43, 96, 0, 196, 3,
		3, 247, 71, 130, 0, 244, 2,
		3358, 253, 40, 98, 144, 208, 2,
		-2, 246, 70, 130, 0, 236, 2
	},

	/* Region 10 */
	{
		0x8002, 0, 127, 48, 80, 26, 0,
		3096, 249, 72, 100, 0, 208, 2,
		2185, 249, 102, 130, 0, 240, 2,
		3386, 247, 66, 100, 144, 212, 2,
		-2, 247, 102, 130, 0, 240, 2
	},

	/* Region 11 */
	{
		0x8002, 0, 127, 92, 67, 21, 0,
		2982, 255, 27, 146, 0, 200, 3,
		3, 246, 68, 146, 0, 240, 2,
		3358, 250, 149, 116, 144, 208, 2,
		-3, 245, 68, 146, 0, 240, 0
	},

	/* Region 12 */
	{
		0x8002, 0, 127, 0, 67, 0, 0,
		1500, 239, 60, 151, 0, 220, 2,
		0, 247, 76, 146, 0, 240, 2,
		2398, 234, 156, 151, 0, 212, 2,
		0, 246, 105, 146, 0, 244, 2
	},

	/* Region 13 */
	{
		0x8002, 0, 127, 0, 67, 0, 0,
		2500, 255, 60, 151, 0, 220, 2,
		0, 249, 92, 146, 0, 244, 2,
		3369, 250, 156, 151, 0, 196, 2,
		0, 248, 89, 146, 0, 244, 2
	},

	/* Region 14 */
	{
		0x8005, 0, 127, 160, 255, 0, 0,
		2300, 229, 112, 49, 0, 208, 2,
		-3, 247, 67, 50, 0, 248, 2,
		1074, 255, 41, 49, 0, 196, 2,
		686, 240, 97, 18, 0, 196, 2
	},

	/* Region 15 */
	{
		0x8005, 0, 127, 160, 255, 219, 0,
		3369, 255, 65, 70, 40, 216, 2,
		1, 246, 72, 113, 0, 240, 2,
		1902, 225, 33, 129, 80, 204, 2,
		2400, 225, 97, 113, 80, 200, 2
	},

	/* Region 16 */
	{
		0x8003, 0, 127, 32, 48, 151, 0,
		1201, 215, 35, 66, 252, 208, 0,
		-9581, 254, 63, 177, 240, 240, 3,
		1902, 248, 47, 64, 112, 244, 2,
		0, 247, 35, 66, 208, 212, 2
	},

	/* Region 17 */
	{
		0x8001, 0, 127, 0, 255, 153, 0,
		1, 252, 31, 3, 244, 196, 2,
		-1, 208, 31, 4, 248, 244, 2,
		1205, 209, 31, 4, 248, 236, 2,
		1899, 250, 31, 32, 0, 240, 2
	},

	/* Region 18 */
	{
		0x8002, 0, 127, 32, 49, 201, 0,
		1, 220, 47, 3, 244, 220, 0,
		-10000, 208, 63, 1, 248, 240, 3,
		1586, 255, 47, 3, 188, 216, 2,
		-1, 202, 63, 32, 80, 232, 2
	},

	/* Region 19 */
	{
		0x8001, 0, 127, 0, 143, 29, 0,
		-1200, 223, 64, 0, 252, 216, 2,
		1200, 96, 41, 35, 248, 240, 2,
		1200, 143, 41, 64, 252, 224, 2,
		3102, 161, 41, 96, 248, 216, 2
	},

	/* Region 20 */
	{
		0x8002, 0, 127, 0, 143, 34, 0,
		-1200, 133, 79, 1, 252, 212, 2,
		1201, 112, 46, 34, 248, 232, 2,
		0, 116, 79, 65, 252, 200, 2,
		1900, 161, 46, 98, 248, 232, 2
	},

	/* Region 21 */
	{
		0x8002, 0, 127, 0, 143, 187, 0,
		1202, 80, 74, 1, 252, 216, 2,
		2402, 112, 46, 34, 248, 232, 2,
		0, 99, 78, 97, 184, 216, 2,
		1899, 81, 46, 98, 236, 232, 2
	},

	/* Region 22 */
	{
		0x8005, 0, 127, 22, 141, 34, 0,
		2787, 176, 79, 4, 252, 208, 2,
		2785, 144, 45, 34, 248, 236, 2,
		3369, 83, 77, 100, 184, 172, 2,
		1902, 102, 45, 100, 172, 212, 0
	},

	/* Region 23 */
	{
		0x8002, 0, 127, 0, 143, 135, 0,
		1900, 112, 79, 3, 252, 220, 2,
		2400, 128, 45, 34, 248, 232, 2,
		1200, 115, 77, 98, 184, 220, 2,
		1904, 97, 45, 98, 236, 232, 2
	},

	/* Region 24 */
	{
		0x8005, 0, 127, 0, 255, 157, 0,
		1200, 244, 54, 4, 20, 200, 2,
		0, 245, 92, 130, 0, 244, 2,
		3802, 247, 68, 21, 0, 196, 2,
		1, 245, 43, 114, 0, 204, 2
	},

	/* Region 25 */
	{
		0x8005, 0, 127, 0, 128, 83, 0,
		0, 244, 51, 4, 200, 204, 0,
		0, 247, 108, 129, 0, 248, 0,
		2786, 243, 31, 70, 200, 220, 0,
		1902, 246, 44, 113, 12, 188, 0
	},

	/* Region 26 */
	{
		0x8005, 0, 127, 0, 128, 61, 0,
		0, 246, 51, 97, 76, 204, 0,
		0, 244, 60, 97, 0, 240, 0,
		1786, 255, 31, 64, 0, 180, 0,
		1200, 247, 60, 97, 12, 204, 0
	},

	/* Region 27 */
	{
		0x8005, 0, 127, 0, 128, 153, 0,
		-2, 243, 53, 99, 96, 200, 0,
		0, 243, 60, 97, 0, 240, 0,
		3983, 247, 63, 100, 24, 204, 0,
		2, 242, 53, 99, 52, 212, 0
	},

	/* Region 28 */
	{
		0x8005, 0, 127, 0, 128, 205, 0,
		-2, 244, 47, 97, 20, 208, 0,
		0, 252, 75, 193, 0, 248, 0,
		0, 254, 63, 98, 132, 224, 0,
		2786, 251, 63, 98, 52, 192, 0
	},

	/* Region 29 */
	{
		0x8005, 0, 127, 0, 128, 221, 0,
		-1, 208, 191, 99, 220, 224, 0,
		1200, 243, 92, 97, 0, 244, 0,
		3984, 212, 11, 96, 168, 196, 0,
		1, 242, 127, 98, 108, 204, 0
	},

	/* Region 30 */
	{
		0x8005, 0, 127, 0, 128, 174, 0,
		-3, 212, 207, 99, 0, 228, 0,
		1902, 241, 108, 97, 0, 248, 0,
		3805, 212, 59, 98, 0, 220, 0,
		1902, 146, 107, 98, 144, 196, 0
	},

	/* Region 31 */
	{
		0x8009, 0, 127, 0, 255, 128, 0,
		1206, 239, 43, 69, 0, 216, 2,
		4, 254, 42, 66, 0, 244, 2,
		702, 88, 55, 66, 0, 204, 2,
		-4, 71, 55, 66, 0, 240, 2
	},

	/* Region 32 */
	{
		0x8005, 0, 127, 0, 255, 85, 0,
		500, 239, 95, 82, 0, 184, 3,
		0, 248, 73, 132, 0, 252, 2,
		2786, 203, 59, 130, 0, 176, 2,
		0, 216, 42, 100, 0, 208, 2
	},

	/* Region 33 */
	{
		0x8005, 0, 127, 0, 128, 73, 0,
		1, 229, 54, 131, 160, 208, 0,
		-1, 244, 62, 97, 0, 248, 0,
		3986, 227, 127, 69, 140, 184, 0,
		1201, 249, 92, 114, 0, 204, 0
	},

	/* Region 34 */
	{
		0x8005, 0, 127, 0, 128, 73, 0,
		1, 225, 54, 100, 200, 212, 0,
		-1, 244, 94, 97, 0, 248, 0,
		3986, 249, 127, 88, 112, 188, 0,
		1201, 249, 92, 85, 52, 208, 0
	},

	/* Region 35 */
	{
		0x8005, 0, 127, 0, 128, 188, 0,
		-3, 198, 92, 179, 28, 212, 0,
		0, 243, 90, 145, 0, 248, 0,
		1901, 215, 95, 69, 28, 196, 0,
		3, 84, 108, 196, 32, 208, 0
	},

	/* Region 36 */
	{
		0x8005, 0, 127, 0, 136, 6, 0,
		0, 226, 99, 36, 224, 216, 0,
		1902, 248, 78, 33, 0, 252, 0,
		3369, 239, 250, 33, 0, 204, 0,
		0, 230, 253, 33, 0, 208, 0
	},

	/* Region 37 */
	{
		0x8005, 0, 127, 0, 136, 195, 0,
		0, 245, 99, 36, 152, 208, 0,
		1200, 248, 78, 33, 0, 252, 0,
		3369, 246, 250, 33, 0, 216, 0,
		0, 246, 61, 33, 0, 180, 0
	},

	/* Region 38 */
	{
		0x8002, 0, 127, 0, 133, 221, 0,
		1, 244, 67, 35, 80, 220, 0,
		3, 246, 94, 33, 0, 244, 0,
		-1, 245, 70, 35, 80, 236, 2,
		-3, 246, 63, 33, 0, 236, 2
	},

	/* Region 39 */
	{
		0x8002, 0, 127, 0, 133, 220, 0,
		0, 114, 51, 34, 132, 208, 0,
		3, 214, 62, 33, 0, 248, 0,
		0, 85, 54, 34, 44, 224, 2,
		-3, 214, 63, 33, 0, 236, 2
	},

	/* Region 40 */
	{
		0x8005, 0, 127, 48, 142, 187, 0,
		-1, 33, 22, 33, 200, 208, 0,
		0, 81, 105, 33, 220, 240, 0,
		2786, 245, 19, 50, 208, 192, 0,
		1, 245, 21, 82, 200, 220, 0
	},

	/* Region 41 */
	{
		0x8005, 0, 127, 48, 126, 103, 0,
		-1, 193, 22, 33, 228, 212, 0,
		0, 81, 105, 33, 220, 244, 0,
		0, 245, 19, 50, 216, 228, 0,
		1200, 245, 19, 82, 200, 188, 0
	},

	/* Region 42 */
	{
		0x8005, 0, 127, 16, 126, 202, 0,
		-1, 49, 24, 41, 200, 212, 0,
		0, 81, 71, 49, 220, 244, 0,
		3371, 243, 19, 36, 232, 192, 0,
		1, 242, 24, 36, 220, 212, 0
	},

	/* Region 43 */
	{
		0x8005, 0, 127, 16, 124, 205, 0,
		0, 129, 24, 49, 208, 200, 0,
		0, 67, 102, 81, 224, 244, 0,
		3804, 246, 23, 36, 160, 196, 0,
		1200, 244, 24, 35, 208, 200, 0
	},

	/* Region 44 */
	{
		0x8005, 0, 127, 48, 144, 208, 0,
		-3, 209, 22, 33, 200, 204, 2,
		0, 81, 89, 33, 220, 240, 2,
		-5000, 208, 6, 33, 244, 188, 3,
		3, 97, 89, 33, 224, 200, 0
	},

	/* Region 45 */
	{
		0x8005, 0, 127, 0, 255, 186, 0,
		500, 223, 95, 0, 0, 192, 3,
		0, 247, 89, 100, 0, 248, 2,
		3369, 255, 59, 168, 0, 212, 2,
		0, 216, 42, 97, 0, 212, 2
	},

	/* Region 46 */
	{
		0x8002, 0, 127, 0, 255, 221, 0,
		1206, 235, 70, 69, 0, 216, 2,
		4, 248, 84, 66, 0, 244, 2,
		1902, 247, 52, 137, 80, 216, 2,
		-4, 245, 84, 131, 0, 240, 2
	},

	/* Region 47 */
	{
		0x8005, 0, 127, 0, 255, 105, 0,
		387, 231, 115, 34, 4, 216, 2,
		0, 248, 37, 65, 0, 252, 2,
		3308, 248, 117, 34, 8, 200, 2,
		1900, 213, 82, 50, 0, 192, 2
	},

	/* Region 48 */
	{
		0x8002, 0, 127, 32, 160, 221, 0,
		-7, 209, 22, 33, 200, 204, 2,
		-7, 81, 73, 33, 220, 244, 0,
		7, 209, 22, 33, 200, 208, 0,
		7, 97, 73, 33, 224, 244, 2
	},

	/* Region 49 */
	{
		0x8002, 0, 127, 64, 128, 189, 0,
		-2, 209, 54, 32, 224, 216, 2,
		-7726, 97, 105, 33, 220, 240, 3,
		1902, 209, 54, 34, 216, 208, 0,
		2, 81, 105, 33, 224, 236, 0
	},

	/* Region 50 */
	{
		0x8002, 0, 127, 80, 144, 206, 0,
		-3, 179, 38, 33, 160, 220, 2,
		-7726, 81, 69, 34, 220, 244, 3,
		3, 193, 38, 33, 240, 212, 0,
		-8000, 65, 69, 34, 224, 236, 3
	},

	/* Region 51 */
	{
		0x8005, 0, 127, 96, 128, 204, 0,
		-3, 97, 38, 33, 180, 216, 0,
		0, 81, 69, 34, 220, 240, 2,
		3369, 145, 38, 33, 240, 196, 2,
		-13190, 65, 69, 34, 240, 200, 3
	},

	/* Region 52 */
	{
		0x8002, 0, 127, 64, 128, 108, 0,
		-3, 193, 37, 35, 236, 208, 0,
		2394, 97, 90, 36, 224, 232, 2,
		3, 65, 40, 35, 236, 204, 2,
		1203, 97, 89, 33, 224, 240, 0
	},

	/* Region 53 */
	{
		0x8005, 0, 127, 128, 128, 122, 0,
		0, 193, 21, 34, 236, 188, 0,
		3, 97, 74, 36, 224, 248, 2,
		1906, 251, 24, 32, 96, 192, 3,
		1200, 97, 73, 32, 224, 184, 0
	},

	/* Region 54 */
	{
		0x8002, 0, 127, 64, 133, 135, 0,
		0, 194, 25, 35, 120, 200, 2,
		0, 97, 75, 36, 224, 240, 0,
		2906, 254, 28, 48, 0, 184, 3,
		0, 216, 75, 80, 204, 240, 2
	},

	/* Region 55 */
	{
		0x8009, 0, 127, 208, 64, 255, 0,
		475, 249, 16, 32, 252, 240, 2,
		702, 248, 71, 32, 0, 244, 2,
		1136, 232, 27, 32, 216, 248, 0,
		0, 249, 23, 48, 0, 248, 2
	},

	/* Region 56 */
	{
		0x8005, 0, 127, 0, 132, 233, 0,
		0, 195, 95, 64, 240, 208, 0,
		0, 225, 94, 64, 248, 240, 0,
		0, 254, 127, 0, 4, 196, 4,
		1902, 228, 95, 1, 248, 200, 0
	},

	/* Region 57 */
	{
		0x8005, 0, 127, 16, 140, 238, 0,
		0, 163, 90, 67, 228, 208, 0,
		0, 209, 77, 65, 248, 240, 0,
		1969, 173, 58, 65, 0, 176, 0,
		0, 210, 61, 52, 204, 220, 0
	},

	/* Region 58 */
	{
		0x8005, 0, 127, 16, 140, 222, 0,
		0, 119, 74, 67, 160, 212, 0,
		0, 146, 61, 65, 248, 244, 0,
		1900, 137, 58, 65, 100, 196, 0,
		0, 119, 61, 52, 120, 200, 0
	},

	/* Region 59 */
	{
		0x8005, 0, 127, 16, 135, 219, 0,
		0, 176, 79, 69, 240, 216, 0,
		0, 193, 79, 64, 248, 236, 0,
		0, 178, 123, 54, 92, 228, 0,
		3369, 212, 95, 38, 144, 212, 0
	},

	/* Region 60 */
	{
		0x8002, 0, 127, 0, 119, 203, 0,
		2, 65, 77, 66, 228, 204, 0,
		2, 161, 74, 64, 240, 240, 0,
		-2, 85, 60, 66, 180, 216, 2,
		-2, 162, 74, 64, 220, 240, 2
	},

	/* Region 61 */
	{
		0x8002, 0, 127, 16, 154, 237, 0,
		0, 179, 42, 64, 216, 208, 0,
		0, 209, 61, 64, 248, 244, 0,
		-1200, 226, 55, 65, 244, 220, 2,
		1902, 162, 62, 52, 204, 236, 2
	},

	/* Region 62 */
	{
		0x8002, 0, 127, 48, 119, 221, 0,
		2, 119, 79, 64, 208, 212, 0,
		2, 209, 110, 64, 248, 236, 0,
		-2, 84, 79, 64, 136, 212, 2,
		-2, 209, 110, 64, 240, 240, 2
	},

	/* Region 63 */
	{
		0x8002, 0, 127, 32, 135, 221, 0,
		2, 165, 79, 64, 152, 216, 0,
		2, 225, 110, 64, 248, 236, 0,
		-2, 132, 79, 64, 72, 224, 2,
		-2, 241, 110, 64, 252, 236, 2
	},

	/* Region 64 */
	{
		0x8005, 0, 127, 17, 127, 190, 0,
		0, 209, 60, 67, 244, 208, 0,
		1200, 145, 94, 65, 248, 244, 2,
		3369, 197, 47, 4, 128, 192, 0,
		1902, 167, 94, 6, 200, 200, 0
	},

	/* Region 65 */
	{
		0x8005, 0, 127, 17, 143, 190, 0,
		0, 209, 60, 67, 244, 216, 0,
		1902, 145, 62, 65, 248, 240, 2,
		3369, 197, 47, 4, 128, 196, 0,
		2400, 167, 94, 6, 200, 212, 2
	},

	/* Region 66 */
	{
		0x8005, 0, 127, 17, 143, 190, 0,
		0, 209, 60, 67, 244, 208, 0,
		1902, 145, 62, 65, 248, 240, 2,
		3369, 197, 47, 4, 128, 192, 0,
		1902, 167, 94, 6, 200, 216, 2
	},

	/* Region 67 */
	{
		0x8005, 0, 127, 17, 125, 190, 0,
		0, 114, 109, 67, 244, 224, 0,
		1902, 166, 93, 97, 200, 240, 0,
		2786, 165, 95, 52, 160, 200, 0,
		2400, 173, 78, 54, 240, 212, 2
	},

	/* Region 68 */
	{
		0x8002, 0, 127, 16, 140, 205, 0,
		0, 211, 55, 66, 244, 208, 0,
		1902, 193, 93, 65, 248, 240, 0,
		0, 204, 47, 4, 244, 216, 0,
		3600, 183, 95, 6, 160, 232, 0
	},

	/* Region 69 */
	{
		0x8002, 0, 127, 16, 126, 222, 0,
		0, 243, 36, 66, 172, 200, 0,
		1200, 193, 110, 67, 248, 244, 0,
		0, 215, 33, 2, 232, 212, 0,
		3369, 178, 63, 6, 184, 240, 0
	},

	/* Region 70 */
	{
		0x8002, 0, 127, 16, 140, 221, 0,
		1200, 213, 61, 66, 136, 200, 0,
		1902, 193, 93, 68, 248, 240, 0,
		0, 197, 47, 2, 228, 216, 0,
		3369, 183, 95, 2, 160, 236, 0
	},

	/* Region 71 */
	{
		0x8002, 0, 127, 16, 124, 201, 0,
		1200, 195, 55, 68, 240, 208, 0,
		0, 209, 76, 65, 248, 236, 0,
		1902, 147, 47, 19, 208, 212, 0,
		0, 183, 79, 22, 156, 228, 0
	},

	/* Region 72 */
	{
		0x8005, 0, 127, 32, 110, 234, 0,
		500, 237, 60, 68, 0, 192, 1,
		1, 161, 93, 65, 248, 240, 2,
		3365, 154, 47, 16, 48, 180, 6,
		1200, 165, 92, 52, 160, 212, 2
	},

	/* Region 73 */
	{
		0x8005, 0, 127, 32, 142, 200, 0,
		0, 193, 60, 68, 248, 200, 0,
		1, 129, 61, 65, 248, 240, 2,
		3365, 154, 47, 16, 68, 184, 6,
		1200, 169, 92, 52, 160, 204, 2
	},

	/* Region 74 */
	{
		0x8003, 0, 127, 32, 135, 36, 0,
		1199, 165, 79, 66, 152, 192, 2,
		-3, 145, 110, 64, 248, 240, 2,
		0, 199, 79, 66, 44, 236, 2,
		2986, 136, 110, 67, 100, 196, 2
	},

	/* Region 75 */
	{
		0x8005, 0, 127, 32, 190, 71, 0,
		868, 202, 140, 16, 24, 188, 2,
		0, 176, 77, 65, 248, 240, 2,
		3750, 169, 127, 16, 36, 228, 6,
		2400, 195, 60, 17, 232, 172, 2
	},

	/* Region 76 */
	{
		0x8005, 0, 127, 224, 16, 123, 0,
		275, 202, 14, 2, 44, 196, 2,
		0, 165, 89, 65, 56, 244, 2,
		0, 255, 12, 2, 64, 216, 6,
		963, 169, 14, 4, 40, 196, 2
	},

	/* Region 77 */
	{
		0x8012, 0, 127, 192, 128, 100, 0,
		1500, 202, 79, 68, 76, 204, 2,
		-2, 97, 26, 64, 248, 232, 2,
		1588, 202, 223, 69, 4, 220, 0,
		3, 188, 121, 67, 48, 252, 2
	},

	/* Region 78 */
	{
		0x8002, 0, 127, 112, 140, 205, 0,
		0, 68, 47, 66, 60, 176, 2,
		-2, 113, 94, 64, 248, 236, 0,
		5000, 121, 47, 64, 32, 168, 7,
		3, 136, 94, 64, 0, 236, 0
	},

	/* Region 79 */
	{
		0x8003, 0, 127, 32, 135, 33, 0,
		1199, 197, 79, 66, 152, 184, 2,
		0, 161, 110, 64, 248, 240, 2,
		0, 199, 79, 66, 44, 236, 2,
		2400, 255, 110, 65, 36, 208, 6
	},

	/* Region 80 */
	{
		0x8002, 0, 127, 0, 192, 170, 0,
		1199, 192, 77, 33, 200, 212, 0,
		0, 209, 107, 33, 232, 240, 0,
		1201, 80, 77, 33, 200, 212, 0,
		0, 241, 107, 33, 232, 240, 0
	},

	/* Region 81 */
	{
		0x8002, 0, 127, 0, 192, 221, 0,
		-1, 192, 45, 33, 200, 212, 0,
		-1, 209, 107, 33, 232, 244, 0,
		1, 80, 45, 33, 200, 212, 0,
		1, 241, 107, 33, 232, 244, 0
	},

	/* Region 82 */
	{
		0x8005, 0, 127, 0, 112, 255, 0,
		4750, 221, 45, 34, 48, 172, 4,
		-10000, 161, 107, 33, 200, 244, 3,
		2204, 137, 45, 37, 64, 184, 0,
		-2, 211, 107, 33, 160, 208, 0
	},

	/* Region 83 */
	{
		0x8005, 0, 127, 16, 127, 238, 0,
		2, 248, 45, 32, 204, 208, 0,
		-9500, 241, 107, 33, 200, 240, 3,
		3369, 186, 45, 38, 24, 208, 0,
		-2, 211, 107, 32, 220, 212, 0
	},

	/* Region 84 */
	{
		0x8005, 0, 127, 0, 128, 221, 0,
		-1, 192, 191, 99, 220, 216, 0,
		1200, 243, 92, 97, 0, 244, 0,
		3984, 200, 11, 96, 168, 192, 0,
		1, 194, 127, 98, 108, 200, 0
	},

	/* Region 85 */
	{
		0x8002, 0, 127, 128, 128, 111, 0,
		1, 194, 25, 35, 120, 204, 2,
		-9750, 193, 107, 36, 224, 244, 3,
		3906, 255, 28, 50, 12, 188, 3,
		-1, 216, 107, 80, 204, 240, 2
	},

	/* Region 86 */
	{
		0x8002, 0, 127, 32, 134, 222, 0,
		0, 195, 52, 33, 200, 208, 0,
		0, 177, 90, 33, 232, 240, 2,
		702, 195, 52, 33, 200, 208, 2,
		702, 177, 90, 34, 232, 240, 2
	},

	/* Region 87 */
	{
		0x8002, 0, 127, 32, 134, 205, 0,
		0, 198, 75, 36, 120, 220, 2,
		0, 225, 78, 52, 40, 244, 2,
		0, 246, 47, 32, 220, 208, 2,
		1902, 241, 124, 32, 240, 236, 2
	},

	/* Region 88 */
	{
		0x8003, 0, 127, 32, 120, 14, 0,
		3600, 244, 67, 34, 88, 208, 0,
		3, 194, 84, 33, 84, 240, 2,
		-3, 194, 84, 33, 172, 236, 2,
		902, 254, 114, 34, 0, 224, 3
	},

	/* Region 89 */
	{
		0x8002, 0, 127, 64, 169, 170, 0,
		-3, 83, 69, 34, 184, 212, 0,
		-7500, 50, 69, 33, 176, 244, 3,
		3, 81, 69, 34, 212, 212, 2,
		-8500, 66, 69, 33, 176, 244, 3
	},

	/* Region 90 */
	{
		0x8002, 0, 127, 64, 120, 221, 0,
		-2, 82, 69, 34, 244, 216, 0,
		0, 145, 102, 33, 228, 240, 0,
		2, 81, 69, 34, 244, 208, 2,
		0, 145, 102, 33, 224, 240, 2
	},

	/* Region 91 */
	{
		0x8003, 0, 127, 32, 138, 14, 0,
		2400, 148, 67, 34, 176, 200, 0,
		3, 194, 85, 33, 220, 236, 2,
		-3, 194, 69, 33, 220, 236, 2,
		1905, 254, 114, 34, 48, 224, 2
	},

	/* Region 92 */
	{
		0x8002, 0, 127, 82, 67, 71, 0,
		2982, 228, 22, 146, 88, 192, 3,
		3, 102, 84, 146, 196, 240, 2,
		3358, 50, 149, 116, 144, 208, 2,
		-3, 85, 84, 146, 120, 240, 0
	},

	/* Region 93 */
	{
		0x8005, 0, 127, 48, 126, 219, 0,
		-3, 49, 19, 33, 120, 200, 0,
		0, 81, 70, 33, 220, 240, 0,
		3804, 242, 18, 50, 200, 200, 0,
		1203, 82, 19, 82, 200, 176, 0
	},

	/* Region 94 */
	{
		0x8003, 0, 127, 32, 138, 13, 0,
		2786, 116, 67, 34, 204, 184, 0,
		1902, 114, 69, 33, 192, 232, 2,
		-3, 178, 69, 33, 188, 232, 2,
		3804, 254, 82, 34, 164, 228, 2
	},

	/* Region 95 */
	{
		0x8002, 0, 127, 48, 135, 238, 0,
		-2, 34, 85, 34, 184, 224, 0,
		1, 113, 70, 33, 228, 236, 0,
		2, 19, 85, 34, 156, 224, 2,
		-1, 129, 70, 33, 224, 236, 2
	},

	/* Region 96 */
	{
		0x8012, 0, 127, 240, 112, 221, 0,
		3369, 213, 69, 32, 0, 204, 0,
		0, 193, 70, 33, 112, 232, 2,
		0, 145, 69, 34, 244, 208, 2,
		-9000, 145, 70, 33, 224, 236, 3
	},

	/* Region 97 */
	{
		0x8002, 0, 127, 96, 122, 168, 0,
		-1, 99, 51, 33, 200, 208, 0,
		-8500, 81, 83, 33, 232, 240, 3,
		702, 99, 52, 33, 200, 208, 2,
		-9500, 65, 83, 34, 224, 240, 3
	},

	/* Region 98 */
	{
		0x8002, 0, 127, 0, 67, 0, 0,
		1500, 217, 55, 151, 20, 224, 2,
		3, 231, 70, 146, 88, 220, 2,
		2369, 115, 148, 151, 32, 196, 2,
		-3, 118, 36, 146, 64, 244, 2
	},

	/* Region 99 */
	{
		0x8002, 0, 127, 64, 169, 204, 0,
		-3, 228, 69, 34, 148, 220, 0,
		-7448, 243, 69, 33, 200, 240, 3,
		3, 81, 68, 34, 212, 212, 2,
		-8526, 65, 68, 33, 196, 240, 3
	},

	/* Region 100 */
	{
		0x8002, 0, 127, 64, 119, 187, 0,
		2786, 228, 22, 146, 176, 192, 0,
		3, 102, 68, 146, 196, 236, 2,
		3369, 178, 149, 116, 176, 208, 2,
		-3, 231, 68, 146, 120, 240, 0
	},

	/* Region 101 */
	{
		0x8002, 0, 127, 240, 144, 239, 0,
		-2, 49, 69, 34, 236, 208, 2,
		-9000, 113, 102, 33, 228, 236, 3,
		2400, 149, 69, 34, 12, 216, 1,
		0, 145, 102, 33, 224, 236, 2
	},

	/* Region 102 */
	{
		0x8012, 0, 127, 241, 176, 6, 0,
		1200, 247, 49, 64, 252, 204, 0,
		3804, 246, 101, 32, 0, 232, 2,
		1902, 247, 32, 32, 112, 188, 2,
		0, 228, 84, 32, 0, 240, 2
	},

	/* Region 103 */
	{
		0x8005, 0, 127, 64, 101, 221, 0,
		1, 194, 68, 97, 196, 200, 2,
		-10001, 247, 100, 114, 176, 240, 3,
		3370, 213, 33, 70, 52, 200, 2,
		-1, 178, 68, 49, 208, 212, 0
	},

	/* Region 104 */
	{
		0x8002, 0, 127, 0, 255, 203, 0,
		-3, 245, 82, 99, 200, 232, 2,
		2787, 244, 84, 96, 0, 236, 2,
		1198, 133, 81, 100, 196, 220, 2,
		1902, 147, 67, 80, 0, 232, 2
	},

	/* Region 105 */
	{
		0x8005, 0, 127, 0, 255, 140, 0,
		500, 255, 137, 179, 0, 200, 3,
		1902, 248, 90, 160, 0, 244, 2,
		3804, 245, 57, 35, 164, 204, 2,
		0, 245, 38, 51, 196, 208, 2
	},

	/* Region 106 */
	{
		0x8005, 0, 127, 0, 255, 72, 0,
		1000, 238, 57, 65, 0, 188, 3,
		1902, 247, 103, 112, 0, 244, 2,
		2786, 250, 36, 81, 68, 212, 2,
		0, 249, 50, 49, 172, 204, 2
	},

	/* Region 107 */
	{
		0x8005, 0, 127, 16, 119, 72, 0,
		1500, 255, 89, 65, 0, 196, 3,
		2790, 246, 39, 112, 0, 240, 0,
		1905, 246, 36, 81, 168, 208, 0,
		0, 249, 114, 49, 172, 212, 0
	},

	/* Region 108 */
	{
		0x8005, 0, 127, 0, 255, 237, 0,
		1902, 254, 89, 65, 0, 212, 2,
		0, 248, 87, 112, 0, 240, 2,
		3369, 231, 62, 81, 0, 208, 2,
		3, 245, 118, 49, 96, 196, 2
	},

	/* Region 109 */
	{
		0x8002, 0, 127, 16, 188, 205, 0,
		-2, 179, 47, 50, 244, 224, 2,
		1900, 145, 94, 49, 248, 232, 2,
		3, 210, 46, 2, 244, 208, 2,
		2789, 133, 93, 4, 180, 244, 2
	},

	/* Region 110 */
	{
		0x8005, 0, 127, 48, 135, 220, 0,
		1901, 162, 25, 35, 144, 208, 0,
		0, 113, 105, 65, 220, 240, 0,
		3369, 233, 88, 51, 120, 212, 0,
		0, 229, 24, 84, 200, 208, 0
	},

	/* Region 111 */
	{
		0x8002, 0, 127, 112, 32, 190, 0,
		0, 53, 79, 66, 152, 212, 2,
		1200, 53, 75, 64, 136, 244, 2,
		500, 149, 60, 66, 16, 208, 2,
		1902, 200, 78, 64, 0, 248, 0
	},

	/* Region 112 */
	{
		0x8005, 0, 127, 0, 144, 130, 0,
		2514, 255, 68, 53, 0, 204, 2,
		2400, 247, 133, 48, 0, 240, 2,
		4151, 243, 67, 50, 0, 212, 2,
		3369, 243, 66, 56, 0, 204, 2
	},

	/* Region 113 */
	{
		0x8005, 0, 127, 0, 255, 0, 0,
		514, 253, 79, 51, 0, 196, 3,
		1905, 252, 89, 51, 0, 244, 2,
		4349, 245, 35, 51, 0, 208, 2,
		1205, 247, 34, 51, 0, 208, 2
	},

	/* Region 114 */
	{
		0x8005, 0, 127, 0, 255, 0, 0,
		514, 221, 69, 35, 0, 204, 3,
		0, 250, 86, 115, 0, 252, 2,
		1884, 244, 116, 51, 0, 200, 2,
		1208, 210, 35, 51, 0, 208, 2
	},

	/* Region 115 */
	{
		0x8005, 0, 127, 0, 255, 16, 0,
		514, 222, 85, 163, 0, 192, 3,
		0, 254, 108, 163, 0, 252, 2,
		3800, 255, 143, 160, 0, 176, 2,
		1200, 250, 105, 163, 0, 212, 2
	},

	/* Region 116 */
	{
		0x8005, 0, 127, 0, 255, 16, 0,
		1514, 249, 101, 163, 0, 204, 3,
		-1200, 249, 87, 160, 0, 252, 2,
		0, 235, 143, 160, 0, 204, 2,
		1200, 234, 73, 163, 0, 204, 2
	},

	/* Region 117 */
	{
		0x8005, 0, 127, 0, 255, 16, 0,
		500, 239, 101, 160, 0, 204, 3,
		-1195, 248, 104, 160, 0, 252, 2,
		1898, 252, 72, 163, 0, 216, 2,
		1239, 248, 87, 163, 0, 196, 2
	},

	/* Region 118 */
	{
		0x8005, 0, 127, 0, 255, 255, 0,
		500, 255, 98, 160, 0, 196, 3,
		-1, 249, 105, 160, 0, 252, 2,
		1907, 250, 71, 160, 0, 252, 2,
		1182, 249, 87, 161, 0, 192, 2
	},

	/* Region 119 */
	{
		0x8005, 0, 127, 0, 0, 100, 0,
		600, 32, 15, 0, 252, 224, 6,
		0, 47, 111, 65, 0, 244, 2,
		1826, 16, 47, 0, 252, 216, 2,
		3551, 240, 47, 0, 252, 212, 2
	},

	/* Region 120 */
	{
		0x8014, 0, 127, 240, 128, 235, 0,
		1228, 161, 47, 17, 196, 200, 3,
		3000, 123, 75, 17, 0, 240, 2,
		7022, 72, 43, 17, 0, 216, 0,
		4000, 150, 79, 17, 48, 196, 3
	},

	/* Region 121 */
	{
		0x8005, 0, 127, 224, 16, 86, 0,
		275, 251, 6, 0, 36, 200, 2,
		0, 101, 104, 65, 56, 240, 2,
		0, 240, 6, 0, 252, 208, 6,
		1000, 195, 8, 0, 248, 200, 2
	},

	/* Region 122 */
	{
		0x8002, 0, 127, 0, 0, 185, 0,
		600, 35, 66, 17, 72, 224, 4,
		-13000, 81, 67, 17, 228, 244, 2,
		702, 97, 38, 17, 212, 196, 6,
		-14000, 81, 65, 17, 224, 244, 3
	},

	/* Region 123 */
	{
		0x8012, 0, 127, 240, 112, 237, 0,
		-6528, 153, 127, 16, 0, 252, 3,
		1200, 105, 109, 16, 0, 216, 2,
		-6022, 179, 139, 17, 0, 248, 3,
		2000, 104, 79, 17, 0, 240, 0
	},

	/* Region 124 */
	{
		0x8012, 0, 127, 240, 240, 16, 0,
		1914, 240, 64, 160, 240, 208, 2,
		1200, 240, 73, 163, 240, 244, 0,
		1900, 240, 64, 160, 240, 148, 2,
		4151, 240, 73, 163, 240, 244, 0
	},

	/* Region 125 */
	{
		0x8002, 0, 127, 240, 56, 235, 0,
		-5522, 97, 32, 17, 196, 240, 3,
		0, 84, 75, 17, 180, 248, 3,
		702, 65, 38, 17, 224, 212, 6,
		-4000, 161, 73, 17, 224, 252, 1
	},

	/* Region 126 */
	{
		0x8015, 0, 127, 240, 248, 37, 0,
		1050, 243, 0, 0, 252, 224, 7,
		2000, 49, 68, 0, 224, 236, 3,
		350, 240, 0, 0, 252, 216, 1,
		700, 240, 0, 0, 252, 212, 3
	},

	/* Region 127 */
	{
		0x8015, 0, 127, 240, 248, 37, 0,
		1050, 245, 85, 0, 0, 244, 7,
		-5000, 247, 71, 0, 0, 252, 3,
		350, 240, 0, 0, 0, 164, 0,
		700, 32, 0, 0, 0, 252, 2
	},

	/* Region 128 */
	{
		0x0005, 35, 35, 0, 255, 103, 0,
		3, 215, 68, 65, 0, 204, 2,
		-1700, 249, 95, 177, 0, 252, 2,
		5374, 236, 144, 204, 0, 176, 3,
		114, 253, 144, 179, 0, 200, 3
	},

	/* Region 129 */
	{
		0x0005, 36, 36, 0, 255, 103, 0,
		3, 219, 68, 65, 0, 204, 2,
		-1700, 251, 95, 177, 0, 252, 2,
		5374, 255, 144, 204, 0, 176, 3,
		114, 255, 144, 179, 0, 208, 3
	},

	/* Region 130 */
	{
		0x001a, 37, 37, 240, 128, 216, 0,
		2780, 255, 16, 0, 112, 200, 3,
		3800, 255, 32, 0, 0, 240, 3,
		2501, 251, 48, 0, 48, 240, 3,
		2751, 254, 48, 0, 0, 244, 3
	},

	/* Region 131 */
	{
		0x000d, 38, 38, 0, 255, 190, 0,
		-2000, 239, 48, 128, 0, 236, 3,
		-2400, 254, 92, 128, 0, 252, 2,
		3374, 255, 33, 192, 240, 244, 2,
		1000, 255, 49, 176, 240, 204, 2
	},

	/* Region 132 */
	{
		0x001a, 39, 39, 240, 128, 254, -10,
		5780, 186, 16, 0, 112, 240, 3,
		3800, 254, 32, 0, 0, 248, 3,
		5780, 234, 16, 0, 112, 240, 3,
		4829, 254, 32, 0, 0, 252, 3
	},

	/* Region 133 */
	{
		0x000d, 40, 40, 0, 255, 203, 0,
		0, 254, 74, 128, 0, 176, 3,
		-600, 252, 73, 128, 0, 252, 3,
		3368, 251, 80, 192, 0, 244, 3,
		1200, 254, 64, 176, 0, 208, 3
	},

	/* Region 134 */
	{
		0x000d, 41, 41, 208, 16, 187, -30,
		-600, 247, 128, 0, 0, 204, 1,
		-890, 248, 88, 0, 0, 252, 3,
		1068, 250, 182, 0, 0, 200, 3,
		-100, 249, 116, 0, 0, 208, 3
	},

	/* Region 135 */
	{
		0x0005, 42, 42, 160, 255, 126, 20,
		3514, 247, 23, 72, 0, 212, 3,
		400, 255, 94, 177, 0, 232, 2,
		2347, 250, 47, 0, 196, 184, 6,
		4388, 248, 26, 0, 136, 224, 2
	},

	/* Region 136 */
	{
		0x000d, 43, 43, 208, 16, 187, -20,
		-500, 247, 128, 0, 0, 204, 1,
		-690, 249, 88, 0, 0, 252, 3,
		1068, 254, 182, 0, 0, 200, 3,
		0, 249, 116, 0, 0, 208, 3
	},

	/* Region 137 */
	{
		0x0005, 44, 44, 160, 255, 126, 20,
		3514, 151, 20, 72, 0, 244, 3,
		400, 223, 92, 177, 0, 240, 2,
		2347, 134, 34, 0, 176, 208, 6,
		4388, 200, 21, 0, 100, 220, 2
	},

	/* Region 138 */
	{
		0x000d, 45, 45, 208, 16, 187, -10,
		-350, 246, 128, 0, 0, 204, 1,
		-590, 249, 88, 0, 0, 252, 3,
		2368, 254, 182, 0, 0, 196, 3,
		500, 249, 116, 0, 0, 208, 3
	},

	/* Region 139 */
	{
		0x0005, 46, 46, 160, 255, 126, 20,
		3510, 147, 51, 72, 0, 236, 3,
		400, 219, 90, 177, 0, 240, 2,
		2347, 134, 66, 0, 176, 224, 6,
		4388, 200, 84, 0, 100, 212, 2
	},

	/* Region 140 */
	{
		0x000d, 47, 47, 176, 32, 187, 10,
		0, 247, 128, 0, 0, 204, 1,
		-280, 249, 88, 0, 0, 252, 3,
		2968, 255, 182, 0, 0, 200, 3,
		700, 250, 116, 0, 0, 204, 3
	},

	/* Region 141 */
	{
		0x000d, 48, 48, 0, 255, 187, 20,
		10, 247, 128, 0, 0, 204, 3,
		-130, 249, 88, 0, 0, 252, 3,
		3068, 255, 182, 0, 0, 188, 3,
		800, 250, 116, 0, 0, 204, 3
	},

	/* Region 142 */
	{
		0x000d, 49, 49, 160, 255, 215, 20,
		3986, 18, 6, 8, 0, 252, 2,
		0, 247, 70, 1, 0, 240, 2,
		5354, 242, 48, 0, 252, 216, 2,
		3868, 193, 48, 0, 212, 208, 2
	},

	/* Region 143 */
	{
		0x000d, 50, 50, 0, 255, 201, 30,
		200, 247, 128, 0, 0, 208, 3,
		20, 249, 88, 0, 0, 252, 3,
		3368, 255, 182, 0, 0, 200, 3,
		1100, 250, 116, 0, 0, 204, 3
	},

	/* Region 144 */
	{
		0x000d, 51, 51, 160, 255, 97, -20,
		3831, 240, 39, 0, 232, 224, 3,
		1258, 246, 102, 0, 0, 232, 3,
		4323, 242, 32, 0, 0, 216, 3,
		868, 243, 64, 0, 0, 204, 3
	},

	/* Region 145 */
	{
		0x000d, 52, 52, 112, 128, 234, -20,
		725, 228, 32, 0, 0, 208, 1,
		400, 248, 86, 0, 0, 248, 3,
		2003, 53, 32, 0, 0, 236, 3,
		100, 209, 32, 0, 0, 212, 1
	},

	/* Region 146 */
	{
		0x000d, 53, 53, 160, 255, 97, -20,
		3831, 240, 39, 0, 232, 224, 3,
		1258, 246, 102, 0, 0, 232, 3,
		4323, 242, 32, 0, 0, 224, 3,
		868, 243, 64, 0, 0, 196, 3
	},

	/* Region 147 */
	{
		0x001d, 54, 54, 240, 240, 242, 10,
		-1, 245, 71, 1, 24, 236, 0,
		1200, 218, 102, 1, 0, 236, 2,
		1354, 255, 48, 0, 0, 208, 2,
		5868, 209, 48, 0, 160, 212, 0
	},

	/* Region 148 */
	{
		0x000d, 55, 55, 48, 32, 234, -10,
		725, 228, 32, 0, 0, 208, 3,
		900, 249, 86, 0, 0, 240, 3,
		2303, 69, 32, 0, 0, 236, 1,
		400, 177, 32, 0, 0, 212, 3
	},

	/* Region 149 */
	{
		0x000d, 56, 56, 0, 255, 149, 20,
		414, 254, 123, 48, 0, 204, 3,
		1986, 252, 118, 48, 0, 244, 3,
		4383, 242, 67, 48, 0, 200, 3,
		4205, 243, 81, 48, 0, 204, 3
	},

	/* Region 150 */
	{
		0x000d, 57, 57, 48, 32, 234, -20,
		526, 210, 32, 0, 0, 200, 3,
		719, 246, 86, 0, 0, 240, 3,
		1303, 48, 32, 0, 0, 236, 1,
		202, 98, 32, 0, 0, 212, 3
	},

	/* Region 151 */
	{
		0x001d, 58, 58, 240, 240, 204, -40,
		5650, 247, 16, 0, 84, 220, 1,
		3800, 248, 32, 0, 0, 248, 3,
		1780, 252, 16, 0, 0, 152, 3,
		6825, 245, 32, 0, 0, 208, 1
	},

	/* Region 152 */
	{
		0x000d, 59, 59, 144, 0, 108, -20,
		3531, 240, 103, 0, 232, 220, 3,
		1058, 246, 102, 0, 0, 232, 3,
		5331, 242, 64, 0, 0, 220, 3,
		1968, 243, 64, 0, 0, 204, 1
	},

	/* Region 153 */
	{
		0x000d, 60, 60, 192, 64, 155, 40,
		700, 214, 84, 0, 0, 208, 1,
		950, 253, 76, 0, 0, 248, 3,
		2803, 255, 127, 0, 0, 200, 3,
		750, 255, 89, 0, 0, 204, 3
	},

	/* Region 154 */
	{
		0x000d, 61, 61, 224, 48, 91, 40,
		400, 229, 68, 0, 0, 204, 1,
		700, 251, 76, 0, 0, 248, 3,
		1803, 255, 95, 0, 0, 196, 3,
		450, 255, 89, 0, 0, 208, 3
	},

	/* Region 155 */
	{
		0x000d, 62, 62, 240, 32, 191, 25,
		214, 237, 69, 0, 0, 204, 1,
		400, 252, 78, 0, 0, 248, 3,
		2830, 255, 95, 0, 0, 208, 3,
		2500, 255, 25, 0, 0, 192, 3
	},

	/* Region 156 */
	{
		0x000d, 63, 63, 240, 32, 91, 25,
		400, 229, 68, 0, 0, 188, 1,
		-100, 250, 76, 0, 0, 248, 3,
		1803, 254, 95, 0, 0, 200, 3,
		450, 238, 89, 0, 0, 200, 3
	},

	/* Region 157 */
	{
		0x000d, 64, 64, 240, 16, 91, 20,
		300, 210, 68, 0, 0, 196, 1,
		-400, 250, 76, 0, 0, 248, 3,
		1803, 254, 95, 0, 0, 200, 3,
		550, 238, 89, 0, 0, 200, 3
	},

	/* Region 158 */
	{
		0x001c, 65, 65, 240, 128, 223, 20,
		1780, 234, 16, 0, 112, 208, 3,
		800, 251, 32, 0, 0, 248, 3,
		5501, 231, 48, 0, 48, 200, 3,
		2751, 232, 48, 0, 0, 220, 3
	},

	/* Region 159 */
	{
		0x001c, 66, 66, 240, 128, 223, 20,
		1580, 234, 16, 0, 112, 208, 3,
		600, 250, 32, 0, 0, 248, 3,
		5201, 231, 48, 0, 48, 200, 3,
		2510, 232, 48, 0, 0, 220, 3
	},

	/* Region 160 */
	{
		0x000d, 67, 67, 0, 255, 0, -35,
		1514, 255, 63, 51, 0, 184, 3,
		4830, 251, 73, 51, 0, 252, 3,
		4349, 245, 67, 51, 0, 212, 3,
		5267, 246, 65, 51, 0, 200, 3
	},

	/* Region 161 */
	{
		0x000d, 68, 68, 0, 255, 0, -35,
		1514, 255, 63, 51, 0, 196, 3,
		4905, 251, 73, 51, 0, 252, 3,
		4349, 245, 67, 51, 0, 196, 3,
		5214, 246, 65, 51, 0, 208, 3
	},

	/* Region 162 */
	{
		0x000a, 69, 69, 240, 240, 243, -35,
		10000, 160, 68, 0, 0, 200, 3,
		7000, 156, 140, 0, 0, 228, 3,
		1586, 176, 16, 0, 0, 228, 7,
		8000, 140, 80, 0, 0, 236, 3
	},

	/* Region 163 */
	{
		0x001a, 70, 70, 240, 240, 227, -38,
		500, 240, 52, 0, 0, 220, 1,
		8000, 188, 124, 0, 0, 228, 3,
		1586, 240, 16, 0, 0, 224, 7,
		8000, 203, 80, 0, 0, 228, 3
	},

	/* Region 164 */
	{
		0x0004, 71, 71, 226, 240, 181, 35,
		7253, 224, 32, 48, 0, 184, 3,
		3594, 224, 79, 48, 0, 248, 1,
		220, 97, 19, 48, 156, 152, 3,
		5243, 172, 16, 48, 92, 204, 1
	},

	/* Region 165 */
	{
		0x0004, 72, 72, 240, 241, 181, 35,
		6253, 134, 32, 48, 0, 184, 3,
		3994, 176, 76, 48, 160, 248, 1,
		22, 183, 19, 48, 156, 172, 3,
		1243, 160, 16, 48, 240, 188, 3
	},

	/* Region 166 */
	{
		0x001a, 73, 73, 240, 224, 155, 30,
		-2145, 240, 70, 0, 0, 252, 3,
		600, 109, 111, 0, 0, 240, 3,
		-1800, 240, 71, 0, 0, 248, 3,
		200, 173, 111, 0, 0, 240, 3
	},

	/* Region 167 */
	{
		0x0012, 74, 74, 240, 224, 119, 30,
		-2545, 240, 70, 0, 252, 252, 3,
		0, 153, 111, 0, 0, 240, 3,
		-2400, 240, 71, 0, 252, 252, 3,
		100, 137, 111, 0, 0, 240, 3
	},

	/* Region 168 */
	{
		0x001a, 75, 75, 240, 128, 240, 20,
		3780, 255, 16, 0, 252, 188, 2,
		800, 255, 64, 0, 0, 248, 2,
		2501, 255, 48, 0, 252, 208, 0,
		751, 255, 48, 0, 0, 236, 2
	},

	/* Region 169 */
	{
		0x000d, 76, 76, 0, 255, 68, 35,
		1100, 239, 69, 0, 0, 184, 3,
		2600, 255, 76, 0, 0, 252, 3,
		5000, 255, 111, 0, 0, 204, 3,
		3400, 254, 73, 0, 0, 184, 3
	},

	/* Region 170 */
	{
		0x000d, 77, 77, 0, 255, 68, 35,
		914, 239, 69, 0, 0, 180, 3,
		1801, 254, 76, 0, 0, 252, 3,
		4800, 255, 111, 0, 0, 192, 3,
		3200, 254, 73, 0, 0, 192, 3
	},

	/* Region 171 */
	{
		0x000d, 78, 78, 240, 32, 197, -20,
		1200, 216, 86, 0, 0, 180, 1,
		1800, 189, 127, 0, 0, 244, 3,
		2700, 156, 102, 0, 0, 196, 1,
		700, 109, 104, 0, 0, 196, 1
	},

	/* Region 172 */
	{
		0x000d, 79, 79, 240, 32, 197, -20,
		1200, 216, 86, 0, 0, 196, 1,
		2200, 171, 127, 0, 0, 244, 3,
		2700, 145, 102, 0, 0, 192, 1,
		700, 106, 104, 0, 0, 192, 1
	},

	/* Region 173 */
	{
		0x000d, 80, 80, 0, 255, 0, -40,
		3514, 254, 79, 51, 0, 196, 3,
		5905, 252, 73, 51, 0, 248, 3,
		6348, 245, 35, 51, 0, 176, 3,
		2203, 244, 33, 51, 0, 216, 3
	},

	/* Region 174 */
	{
		0x800d, 81, 81, 0, 255, 0, -40,
		3514, 255, 79, 51, 0, 192, 3,
		5905, 246, 73, 51, 0, 252, 3,
		6348, 241, 35, 51, 0, 180, 3,
		2203, 242, 33, 51, 0, 212, 3
	}
};


/*----------------------------------------------------------------------------
 * Programs
 *----------------------------------------------------------------------------
*/
static const S_PROGRAM programs[] =
{
	{ 7864320, 128 } /* program 0 */
}; /* end Programs */

/*----------------------------------------------------------------------------
 * Banks
 *----------------------------------------------------------------------------
*/
static const S_BANK banks[] =
{
	{ /* bank 0 */
		30976,
		{
			0, 1, 2, 3, 4, 5, 6, 7,
			8, 9, 10, 11, 12, 13, 14, 15,
			16, 17, 18, 19, 20, 21, 22, 23,
			24, 25, 26, 27, 28, 29, 30, 31,
			32, 33, 34, 35, 36, 37, 38, 39,
			40, 41, 42, 43, 44, 45, 46, 47,
			48, 49, 50, 51, 52, 53, 54, 55,
			56, 57, 58, 59, 60, 61, 62, 63,
			64, 65, 66, 67, 68, 69, 70, 71,
			72, 73, 74, 75, 76, 77, 78, 79,
			80, 81, 82, 83, 84, 85, 86, 87,
			88, 89, 90, 91, 92, 93, 94, 95,
			96, 97, 98, 99, 100, 101, 102, 103,
			104, 105, 106, 107, 108, 109, 110, 111,
			112, 113, 114, 115, 116, 117, 118, 119,
			120, 121, 122, 123, 124, 125, 126, 127
		}
	}
}; /* end Banks */

/*----------------------------------------------------------------------------
 * S_EAS
 *----------------------------------------------------------------------------
*/
const S_EAS easlib_fm_gmdblib_3 =
{
	0x01534145,
	0x00105622,
	
	banks,
	programs,
	
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,

	regions,

	1,
	1,

	0,
	0,
	0,

	175
}; /* end S_EAS */
/* end sound library */
