# Contributing

Tvheadend welcomes all code contributions. To ensure the process of contributing runs smoothly please follow the guidelines below:

## Preparation

* Create a [GitHub account](https://github.com/signup/free)
* Fork the project repository on Github
* Discuss feature ideas with staff and users via the [Forum](https://tvheadend.org/feature-ideas) or [GitHub](https://github.com/tvheadend/tvheadend/issues)

## Make Changes

* Create a topic branch for your changes with a simple name, e.g. `new-feature-name` or `fix-issue-1234`
* Create one topic branch per feature or bugfix
* Make changes and commit them, keep the scope of each commit simple (commits can be squashed later)
* Commit message subject lines should use a `subsystem: description of change` format
* Provide additional info in the commit message body if required (detail is always good)
* GUI help changes must be made in the master `en_GB` template

## Submit Changes

* Create a pull request to our `master` development branch
* Create a `Draft` pull request if your changes are still work in progress
* Pull request titles should use a `subsystem: description of change` format
* Use repo labels to classify the pull request
* Link related forum discussion threads for information
* Link GitHub issues using the `Fixes: #1234` format so tickets auto-close on merge

## Documentation

If your changes require documentation updates please use GitBooks to author changes and submit a merge-request. The registration link is on our public documenation site: [https://docs.tvheadend.org](https://docs.tvheadend.org).

## Resources

* [Forum](https://tvheadend.org)
* [#hts IRC Channel on Libera.Chat](https://web.libera.chat/#hts)
* [GitHub General Documentation](http://help.github.com/)
* [GitHub Pull Request Documentation](http://help.github.com/send-pull-requests/)

