/* -----------------------------------------------------------------------------
The copyright in this software is being made available under the Clear BSD
License, included below. No patent rights, trademark rights and/or 
other Intellectual Property Rights other than the copyrights concerning 
the Software are granted under this license.

The Clear BSD License

Copyright (c) 2018-2023, Fraunhofer-Gesellschaft zur Förderung der angewandten Forschung e.V. & The VVdeC Authors.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted (subject to the limitations in the disclaimer below) provided that
the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

     * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived from this
     software without specific prior written permission.

NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY
THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.


------------------------------------------------------------------------------------------- */

/** \file     RomLFNST.cpp
    \brief    LFNST Tables
*/

#include "Rom.h"


#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iomanip>

namespace vvdec
{

// ====================================================================================================================
// LFNST Tables
// ====================================================================================================================

const uint8_t g_lfnstLut[ NUM_INTRA_MODE + NUM_EXT_LUMA_MODE - 1 ] =
{//0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94
   0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

const int8_t g_lfnst8x8[4][2][48][16] = {
 {  //0
  {
   { -117,  -29,  -10,  -15,  +32,  -10,   +1,   +0,  -13,   +6,  -12,   +0,   -1,   +6,   +6,   -1,  },
   {  +28,  -91,  +62,  +15,  +39,   +1,  -33,   +6,  -13,   +1,   -2,   -3,   +9,   +2,   +9,   +7,  },
   {  +18,  +47,  -11,  -10,  +92,  +50,  -11,   -6,  -37,  -14,  -26,   +0,  +13,   -3,   -2,   -2,  },
   {   +2,   +1,   -8,   -2,  -44,  -15,  -14,  +21, -101,  -36,  -12,   -4,   +5,   +2,  +35,   +9,  },
   {   +4,   +9,   -2,   +1,   +4,   +2,   +7,   -4,  +29,   +9,   -9,  -15,  +14,  +10, +110,  -11,  },
   {   +1,   +0,   -2,   +0,  -10,   -3,   -2,   +2,  -11,   -3,   +2,   +6,   -2,   -1,  -22,   +5,  },
   {   +2,   +3,   -1,   +1,   +1,   +1,   +2,   +0,   +8,   +2,   -1,   -3,   +2,   +2,  +11,   -1,  },
   {   +1,   +0,   -1,   +0,   -4,   -1,   +0,   +0,   -3,   +0,   +1,   +1,   -1,   +0,   -4,   +1,  },
   {  +32,  -54,  -95,  +10,  +26,  -28,  +29,  -20,  -12,  +10,   -3,   -7,   -8,   +8,   -2,   -7,  },
   {  -18,  +26,   +3, +112,  +12,  -15,  -12,  -24,  -15,   +9,  +30,  -15,   +3,   +3,   +0,   +2,  },
   {   -2,   -8,  +32,  -20,  -15,  +14,  +37, -104,  -20,  -18,   +4,  -28,   -4,   -1,   -3,  -22,  },
   {   +0,   +3,   +0,  -17,  +13,   +6,   -7,  +30,   +2,   -1,  +34,  -86,  -62,  -20,   +1,   +4,  },
   {   -1,   +0,   +4,   -4,   -5,   +1,   -4,   +5,  -11,   -3,   -4,  +19,   +4,   +0,  -18,  -13,  },
   {   +0,   +1,   +0,   -4,   +2,   +1,   +0,   +5,   +5,   +1,   +0,   -5,   +1,   +1,  +12,   +0,  },
   {   +0,   +0,   +2,   -1,   -2,   +1,   -1,   +1,   -2,   +0,   -1,   +4,   +1,   +0,   -3,   -1,  },
   {   +0,   +0,   +0,   -2,   +0,   +0,   +0,   +2,   +1,   +0,   +0,   -1,   +0,   +0,   +2,   +0,  },
   {  +14,  +33,  +32,  -20,  +29,  -99,   +6,   -7,  -12,  +38,  -30,   -5,  -12,   -4,   -5,   +0,  },
   {   -1,   +5,  -30,  -26,  -16,   -4,  -99,  -46,  +10,  +26,   +3,  -17,  +23,   +4,   -4,  +28,  },
   {   -3,   -9,   -4,  +31,  -22,   +9,   +3,  +10,  +26,  -13,  -92,  -41,  +16,  -16,  -22,   +0,  },
   {   +0,   -1,   +4,   +1,   +8,   +5,  +26,  -14,  +12,   -1,  +14,  +42,  -11,   +0,   +8,  +76,  },
   {   -1,   -2,   -1,   +0,   +0,   +5,   -1,   +7,   -6,   -5,  +19,   -6,  -17,   -2,  -25,   +4,  },
   {   +0,   +0,   +1,   +0,   +1,   +2,   +5,   +0,   +0,   -1,   +0,   +2,   +0,   +0,   +3,   -6,  },
   {   +0,   -1,   +0,   +0,   +0,   +2,   +0,   +1,   -1,   -1,   +3,   -1,   -1,   +1,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +1,   +1,   +2,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   -2,  },
   {   +2,   -3,   +6,   +2,  -20,  +44,  +14,   +9,  -32, +102,  -11,   -1,  -11,  +34,   -3,  -13,  },
   {   +0,   +3,   +2,  -16,   +6,  -10,  +30,  +21,   -2,   +3,  +34,  -40,  +97,  +23,  -21,   +5,  },
   {   +0,   +0,   -5,   -1,   +4,  -11,  -27,   +7,  +11,  -14,  +21,  +37,   -3,   +6,   +2,  -76,  },
   {   +0,   +0,   +0,   +6,   -3,   +1,   -2,   -6,   +3,   -1,  -33,  +13,   -3,   -7,   -3,   -4,  },
   {   +0,   +0,   +0,   +0,   +1,   -2,   +1,   -2,   +3,   -5,   +1,   -4,   +0,   -4,   +9,  +33,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   -1,   -1,   -1,   -1,   -2,   +2,   -6,   -2,   -2,   -1,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   -2,   +0,   -1,   +0,   -1,   +1,   +3,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   -1,   -1,   +0,   +0,   -1,   +1,   -2,   +0,   +0,   +0,  },
   {   +3,   +7,   +6,   +1,   +1,   -5,   -6,   +2,  +11,  -29,   -9,  -10,  -21, +108,   -7,   +9,  },
   {   +0,   +2,   -3,   -4,   -4,   +4,   +6,   +2,   -5,  +10,   -4,  +13,   -5,   -5,   +1,  +18,  },
   {   -1,   -2,   +0,   +0,   -3,   -3,   +6,   +5,   -1,  +10,  +18,   -1,  +23,  -30,   +3,   -3,  },
   {   +0,   +0,   +0,   +0,   +2,   +0,   -3,   -2,   +6,   +0,   +3,   -4,   +0,   +6,   -5,  -35,  },
   {   +1,   -1,   +2,   +0,   -4,   +8,   +1,   +0,   -4,  +10,   +2,   +4,   +2,  -27,   +3,   -4,  },
   {   +0,   +1,   +0,   -3,   +1,   -1,   +3,   +3,   +2,   -4,   +0,   -4,   -2,  +10,   +0,   -1,  },
   {   +0,   +0,   -1,   +0,   +0,   -2,   -3,   +4,   +1,   -1,   +0,   +3,   -1,   +7,   -1,   +6,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   +0,   -1,   +0,   +1,   -2,   +4,   +6,   -2,   +0,   +1,  },
   {   +1,   +2,   +2,   +0,   +1,   -2,   -1,   +0,   +3,   -7,   -1,   -2,   -3,  +11,   +0,   +1,  },
   {   +0,   +1,   -1,   -1,   -1,   +1,   +1,   +0,   -1,   +1,   -1,   +2,   -3,   -3,   +1,   +2,  },
   {   +0,   -1,   +0,   +0,   -2,   -1,   +1,   +1,   +1,   +2,   +3,   -1,   +1,   -1,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +2,   +1,   +0,   -1,   +0,   +1,   -1,   -3,  },
   {   +1,   +0,   +1,   +0,   -2,   +4,   +0,   +0,   -1,   +2,   +0,   +1,   +0,   -4,   +1,   -1,  },
   {   +0,   +0,   +0,   -2,   +0,   +0,   +1,   +1,   +0,   -1,   +0,   -1,   +0,   +1,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   -1,   +2,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +2,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   +2,   +2,   +1,   +0,   +0,  },
  },
  {
   { -108,  +55,   +2,  -24,   +9,  -21,  -10,   +2,  -11,   +9,   -7,   +0,   -2,   -1,   -5,   -1,  },
   {  +48,  +66,  +86,  -21,  +20,   -7,  -25,   +5,  -15,  +13,  +11,   +0,   -6,   +6,   -6,   -2,  },
   {   +9,  -37,  -21,  -38,  +98,  -37,   +4,  +10,  -28,  +24,  +12,   +7,   -1,  -16,   -3,   +0,  },
   {   +1,   -5,  -13,  +19,  -26,  +10,  -17,  +64,  -97,   -6,   +7,   -6,  -10,   +0,  -19,  +23,  },
   {   +1,   -6,   -4,   +0,   -3,   +2,   +8,   -9,   +6,   +7,   +2,  +23,   +0,  +24, -104,   -9,  },
   {   +1,   -1,   -2,   +4,   -5,   +2,   -2,   +4,   -1,   -2,   -1,   -3,   +1,   -3,  +18,   +0,  },
   {   +0,   -2,   -1,   -1,   +0,   -1,   +2,   -3,   +4,   +1,   +0,   +3,   +1,   +1,   -4,   -2,  },
   {   +0,   +0,   -1,   +2,   -2,   +1,   -1,   +1,   -1,   -1,   -1,   -1,   +0,   -1,   +3,   +0,  },
   {  +44,  +67,  -88,  -23,   -9,  -10,  -27,   -4,   +7,  +16,  -14,   +5,   -7,   +2,   +0,   +1,  },
   {   -6,  -30,   +5,  -89,  -26,  +69,  -17,   +8,   +3,  +39,   -1,   +1,   -2,   +6,   +6,   +1,  },
   {   -9,  -20,   +6,  +31,  +15,   -5,  -71,  +62,  +57,  +20,  -24,  +18,  -28,   +6,   +0,   +8,  },
   {   -1,   +4,   +4,  +20,  -16,   -7,  +25,   +3,  -15,  +47,  +11,  +96,  +20,  +16,  +35,   -1,  },
   {   -1,   -2,   +5,   +2,   +2,   -2,   +8,  -17,  +10,   -2,   +2,  +13,  -15,  +18,  -41,  +29,  },
   {   +0,   +0,   +1,   +3,   +0,   -2,   +2,   +1,   -2,   -2,   +0,   -9,   +4,   -7,  +20,   +1,  },
   {   -1,   -1,   +1,   +1,   +1,   +0,   +1,   -2,   +0,   -2,   +0,   -1,   -3,   +1,   -2,   +1,  },
   {   +0,   +0,   +0,   +1,   +0,   -1,   +1,   +0,   -1,   +0,   +0,   -1,   +1,   -1,   +2,   +0,  },
   {   +9,  -31,  +14,  -30,  -61,  -93,   -4,   -3,   -1,  +28,  -20,  -21,   -2,   -3,   -2,   +3,  },
   {   -9,  -19,   -5,  +26,   -3,   +2,  -66,  -75,  -27,  +23,  +48,   -7,  -32,  +11,  +10,   -6,  },
   {   -1,  +14,   +0,  +36,   -2,  +19,  +28,   +5,  +13,  +76,  +11,  -42,   -2,  -63,  -18,  +13,  },
   {   +1,   +4,   +3,   -8,   +3,   +0,  +36,  -14,   +6,   -5,  -13,  +14,  -66,   +9,  +16,  +76,  },
   {   +0,   +1,   +0,   -2,   +7,   +3,   -5,   +1,   +1,  -25,   -5,  -24,   +3,   +4,  +21,  +30,  },
   {   +0,   +1,   +0,   -2,   +1,   +0,   +3,   +4,   -1,   -3,   -2,   -3,   +7,   -5,   +3,  -11,  },
   {   +0,   +1,   +0,   +0,   +1,   +2,   +0,   +0,   +0,   -3,   +0,   +0,   +1,   +2,   -2,   -1,  },
   {   +0,   +0,   +0,   -1,   +0,   +0,   +1,   +1,   +0,   -1,   -1,   +0,   +2,   -1,   +0,   -2,  },
   {   +3,   -6,  +10,  +14,  +12,  +17,  -10,  -36,  -34,   +6, -105,  +11,  -11,  -22,   -2,  -26,  },
   {   -1,   +3,   -5,  +18,  +16,   +4,  +20,   +3,   -6,  +36,  -19,  -47,  +13,  +94,  +11,   -8,  },
   {   +1,   +5,   -2,   -7,   -6,   +0,  +33,  +18,   +0,   -7,  +17,   -7,  -70,   -4,   +6,  -69,  },
   {   +0,   -2,   +0,   -9,   -1,   +0,  -13,   -4,   +3,  -39,   +0,   +3,   +5,   -6,  -10,   +7,  },
   {   +0,   +0,   -1,   -1,   +0,   -1,   -8,   +4,   +4,   -4,   +6,   -5,  +43,   -4,   +6,   -9,  },
   {   +0,   +0,   +0,   -1,   -1,   +0,   +0,   +0,   +1,   -1,   +2,   +9,   -2,   -4,   -3,   -7,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +2,   +0,   +3,   +1,   +3,   +1,   -1,   +3,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   +0,   +2,   +0,   -2,   +0,   -1,  },
   {   +1,   -7,   +6,   +1,   +2,   +5,   +3,   +1,   -2,   +2,  -14,   +0,   +8,  +10,   -1,  -10,  },
   {   -1,   -1,   -5,   +3,   +0,   -4,   +6,  +14,   +8,   -4,   +8,   -1,  -14,  +23,   +5,  -34,  },
   {   +0,   +1,   +0,   -2,   -8,   -2,   -3,   -2,   +1,  -18,   +8,  +19,   -3,  -19,   -1,  -25,  },
   {   +0,   +0,   +1,   -1,   +1,   +0,   -7,   -8,   +5,   -3,   +2,   -1,  +43,   -5,   -6,  +13,  },
   {   +1,   -1,   +2,   +3,   +3,   +4,   -1,   -2,   -2,   -1,   +1,   +1,   -1,   +0,   -1,   -1,  },
   {   +0,   +1,   -1,   +2,   +1,   -2,   +3,   +1,   +0,   -1,   +2,   +0,   +2,   -6,   -1,   +0,  },
   {   +0,   +1,   +0,   -2,   -1,   +0,   +3,   -3,   -3,   -2,   -1,   -1,   +7,   -4,   -1,  +11,  },
   {   +0,   +0,   +0,   -1,   +1,   +1,   -1,   +0,   +1,   -2,   -2,   -6,   -1,   +6,   -1,   +5,  },
   {   +0,   -2,   +1,   +0,   +0,   +0,   +1,   +2,   +1,   +1,   +3,   -1,   +1,   +3,   -1,   +1,  },
   {   -1,   -1,   -1,   +1,   -1,   +0,   +0,   +2,   +1,   -2,   +0,   +1,   -2,   -2,   +0,   -1,  },
   {   +0,   +1,   +0,   +0,   -2,   +0,   -1,   -1,   +0,   -2,   -1,   +2,   +1,   +1,   +0,   +1,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -2,   +2,   +0,   +0,   +0,   +3,   +1,   +0,   -2,  },
   {   +0,   +0,   +1,   +1,   +1,   +2,   +0,   +0,   -1,   +0,   +0,   +1,   -1,   +0,   +0,   +0,  },
   {   +0,   +0,   +0,   +1,   +0,   -1,   +1,   +1,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +0,  },
   {   +0,   +0,   +0,   -1,   -1,   +0,   +1,   -1,   -1,   -1,   +0,   +0,   +1,   +0,   +0,   +2,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   +0,   -2,   +0,   +0,   -1,   +0,  },
  },
 },
 {  //1
  {
   { +110,  -43,  -19,  -35,   +9,   -5,  +14,   +7,  -13,  -11,   -4,   -2,   +3,   -4,   +5,   -5,  },
   {  -49,  -19,  +17, -103,   +5,   -5,  +17,  +35,  -27,  -13,  -10,   +1,   +1,   -8,   -1,   -6,  },
   {   -3,  +17,   -7,  +39,   -6,  -28,  +27,  +17, -101,   -3,  -24,  +13,   +5,   -1,  +26,  -27,  },
   {   -4,   -1,   +3,   +1,   -1,   +9,  -12,   -4,  +24,  -10,  -11,  -17,  -15,  -50, +102,  -22,  },
   {   -1,   +3,   -2,   +7,   -1,   -3,   +1,   -1,   -8,   +3,   +3,   +3,   +1,   +6,  -13,  -12,  },
   {   -1,   +0,   +1,   +0,   +0,   +2,   -3,   +0,   +6,   -1,   -2,   -5,   -2,   -4,  +12,   +0,  },
   {   +0,   +1,   -1,   +2,   -1,   -1,   +1,   +0,   -3,   +1,   +0,   +1,   +1,   +2,   -4,   -3,  },
   {   -1,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +2,   +0,   -1,   -2,   -1,   -2,   +4,   +0,  },
   {  -38,  -98,  -32,  +38,  +42,  -20,   +8,   +3,  +11,  -19,   -6,   +3,   +7,   -1,   -4,   -5,  },
   {   -1,  +46,  -59,  -13,   +4,  -78,  +19,   +8,  +43,  -19,  -37,   +0,   +4,   +5,   -2,   +8,  },
   {  +10,  +14,  +29,  +25,  +21,  +22,  -13,  +54,   +6,  -37,  -45,  -55,   -7,  -22,  -40,  -20,  },
   {   +0,   -1,   +3,   -6,  -11,  +16,   +4,  -17,  +28,   +8,  -17,  +22,  +29,  +20,   -7,  -83,  },
   {   +2,   +2,   +4,   +1,   +1,   +1,   -2,   +1,   -6,   +4,   +8,   +6,   -1,   +6,  -23,   +0,  },
   {   +0,   +0,   +0,   -1,   -3,   +3,   +1,   -2,   +3,   +2,   -2,   +1,   +2,   +1,   +3,   +0,  },
   {   +1,   +1,   +2,   +0,   +1,   +0,   -1,   +1,   -1,   +0,   +2,   +1,   -1,   +0,   -5,   +0,  },
   {   +0,   +0,   +0,   +0,   -1,   +1,   +0,   -1,   +1,   +1,   -1,   +0,   +1,   +0,   +1,   +0,  },
   {   -9,  +26,  -72,   -1,  +21,  +80,  +48,  +10,   -3,  -12,  +17,   +8,   +8,  -16,   -1,   +9,  },
   {  +13,  +26,  +43,   +7,  +70,   -6,   -1,  +14,  +14,  -30,  +14,  +74,   +3,  -15,   +5,   +7,  },
   {   +1,  -15,  +34,   +6,  -32,  +25,  +48,  -11,  +21,   +3,  -58,  +21,  +12,  +18,   +8,  +24,  },
   {   -2,   -3,   -9,   -7,  -21,   -5,  -15,  -34,  -12,   -9,  +14,  +40,  -14,  -29,  -23,  -20,  },
   {   +0,   -2,   +3,   +1,   +0,   -4,   -4,   +4,   -7,   +5,  +15,  -14,   -9,  -11,   +7,  +41,  },
   {   +0,   -1,   -2,   -1,   -4,   -1,   -2,   -4,   -2,   +0,   +0,   +0,   -1,   +2,   +2,   +3,  },
   {   +0,   -1,   +1,   +0,   -1,   -1,   -1,   +1,   -1,   +1,   +2,   -2,   -1,   -2,   +1,   +6,  },
   {   +0,   +0,   -1,   +0,   -1,   +0,   -1,   -1,   -1,   +0,   +0,   +0,   +0,   +1,   +1,   +1,  },
   {   -4,  +11,  +13,  -13,  +34,   +6,   +1,  -80,  -23,  -56,  -10,  -36,   +4,  +40,  +10,  +15,  },
   {   +2,   -7,  +36,  +14,  -26,  -24,  +60,   -7,  +10,   -9,  +34,   -8,  +29,  -45,  -11,  +20,  },
   {   -3,   -9,  -18,   +2,  -57,   +7,  -28,   -6,   -4,  -47,   -7,  +11,  -15,  -19,  -13,  +12,  },
   {   +0,   +2,  -10,   -4,  +11,   -9,  -42,   +2,  -12,   +8,  +28,  -13,  +31,  -22,   -3,  +11,  },
   {   +0,   +0,   +0,   +2,   +4,   +0,   +5,  +15,   +3,  +21,   +4,  -23,  +10,  +31,  +12,  +17,  },
   {   +0,   +0,   -2,   -1,   +2,   +0,   -6,   +0,   +0,   +1,   -1,   +1,   +4,   +2,   -3,   -9,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +3,   +1,   +4,   +1,   -3,   +1,   +4,   +2,   +1,  },
   {   +0,   +0,   -1,   +0,   +1,   +0,   -2,   +0,   +0,   +1,   +0,   +0,   +1,   +1,   +0,   -2,  },
   {   -2,   +9,   +3,   -2,   -4,   -7,  +11,  -16,   +2,  -11,  +23,  -36,  +61,  -25,   -9,  -26,  },
   {   +2,   -3,   +0,  +11,  -32,   +3,  -11,  +46,   +9,  -30,  +34,   +6,  +22,  +41,  +23,   -1,  },
   {   +0,   -1,  -12,   -6,   +5,  +13,  -51,   +1,  -10,  +10,  -31,  +16,  +55,   +0,   +4,  +18,  },
   {   +1,   +2,   +3,   -2,  +24,   -4,  +11,   +3,   +0,  +59,   +4,  -14,  +14,  +12,   +9,   -1,  },
   {   -1,   +3,   +6,   -2,   +1,   -3,   -2,   +2,   +1,   -2,  +10,   +2,  +13,   +9,  +14,  -12,  },
   {   +1,   -3,   +1,   +4,   -6,   +5,  -10,   +7,   -5,   +8,  -22,  +19,   +3,   +7,   +9,  +32,  },
   {   +0,   +0,   -3,   -3,  +12,   +1,   -2,  -24,   -4,  +41,  -30,   -4,   -9,  -42,  -14,   +3,  },
   {   +0,   +0,   +2,   +0,   +4,   -5,  +13,   +0,   +4,   +8,  +22,  -12,  -65,  +12,   -4,  -18,  },
   {   -1,   +4,   +1,   +0,   -3,   -2,   +2,   +2,   +2,   +2,   +4,   -1,   +1,   -3,   +0,   -5,  },
   {   +1,   -1,   -1,   +3,   -2,   +3,   -6,   -2,   -2,   +5,  -15,   +0,  -11,  -14,  -12,  +10,  },
   {   +0,   +0,   -2,   -2,   +4,   +1,   -4,   -5,   +2,   +6,   +9,   -7,  -21,   +2,   -7,  -25,  },
   {   +0,   +0,   +0,   +0,   -2,   -2,   +4,   +8,   +2,   -7,  +20,   -3,   -7,  +28,   +6,   -5,  },
   {   -1,   +2,   +3,   -1,   +0,   -1,   -2,   +1,   +0,   -1,   +2,   +0,   +0,   +5,   +3,   -2,  },
   {   +0,   -1,   +1,   +1,   -1,   +2,   -3,   -1,   -2,   +3,   -5,   +2,   +0,   +1,   +0,   +1,  },
   {   +0,   +0,   -1,   -1,   +0,   -1,   +2,   -2,   +1,   +5,   +9,   -2,   -1,   +6,   +6,   -8,  },
   {   +0,   +0,   +1,   +0,   +0,   -2,   +2,   +2,   +0,   -2,   +4,   -1,   +3,   +2,   +3,  +10,  },
  },
  {
   {  +80,  -72,  -50,  -33,  +10,  +18,  +21,   +1,   +9,   -7,   +6,   +1,   +4,   -3,   +2,   +2,  },
   {  -49,   -6,  +19,  -43,  +66,  +14,  +66,   -6,  +33,   -9,  +30,   -8,  +10,   -9,  +11,   -3,  },
   {   +6,  +17,  -15,  +28,  -21,  +13,   -1,  -24,  -24,  -32,  +69,  +24,   +4,  -23,  +22,   +8,  },
   {   -4,   +0,   +4,   -7,   -3,   -9,   +9,  +17,   +1,  +14,  -18,   -3,  +17,  +10,   +2,  +14,  },
   {   +1,   +3,   -1,   +4,   -3,   +2,   -4,   -5,   +4,   -3,   +5,   +7,   -9,  -10,   +9,   -5,  },
   {   -1,   +0,   +1,   -2,   +0,   -2,   +2,   +3,   +0,   +3,   -4,   -2,   +4,   +3,   -2,   +3,  },
   {   +1,   +1,   -1,   +2,   -1,   +1,   -1,   -2,   +1,   -1,   +3,   +2,   -2,   -3,   +2,   -1,  },
   {   -1,   +0,   +1,   -1,   +0,   -1,   +1,   +1,   +0,   +1,   -1,   -1,   +1,   +1,   +0,   +1,  },
   {  -72,  -23,  -58,  -38,  -53,  +34,  -21,  +24,   +6,  -23,   -3,   -6,   +5,   -5,   -6,   -2,  },
   {  +36,  +58,   -2,  +11,  -41,  +32,  +41,  +10,  +50,  -28,  -11,  -51,  +14,  -14,   -7,  -11,  },
   {   +4,  -21,  +30,   -8,   -2,  -31,  -30,  +39,  +26,   +0,  -34,   -6,  +32,  -16,  +20,   +5,  },
   {   +0,   +2,   -3,   +4,  +16,  +12,  -10,  -21,   +1,   -5,  -16,   -4,  -15,  -27,  -32,  -18,  },
   {   +1,   -3,   +4,   +1,   -1,   -5,   +0,   +5,  -10,   -1,   +9,   -5,   +9,  +13,   -3,   +8,  },
   {   +0,   +1,   -1,   +1,   +4,   +2,   -2,   -4,   +0,   +0,   -4,   +0,   -3,   -5,   -4,   -3,  },
   {   +0,   -1,   +2,   +0,   -1,   -2,   +0,   +2,   -2,   +0,   +2,   -1,   +2,   +2,   +0,   +2,  },
   {   +0,   +0,   +0,   +0,   +1,   +1,   -1,   -1,   +0,   +0,   -1,   +0,   -1,   -1,   -1,   -1,  },
   {  +26,  +55,   +6,  -55,  +36,  +40,  -35,  +33,  -27,  -36,  -16,  +38,   +7,   -1,  +13,  +12,  },
   {   +0,  -46,  +57,  +24,   -5,   +4,  -17,  +32,   +1,  -59,  +35,   -1,  +13,  -13,   -5,  -23,  },
   {  -12,   -1,  -34,  +26,  +41,   -4,   -3,  -30,  -28,  -24,  -35,   +0,  +19,  -30,  -28,  -19,  },
   {   +2,   +6,   +0,   -5,  -20,   -9,  +26,   +4,  -21,  +14,  +30,  +25,  +15,  +11,   +6,  +22,  },
   {   -2,   -2,   -2,   +2,   +3,   -3,   -6,   -3,  +16,   +4,   -9,   +6,   -8,   -5,  +18,   +2,  },
   {   +1,   +1,   +0,   -1,   -3,   -2,   +5,   -1,   -5,   +2,   +3,   +2,   +1,   +2,   -4,   +0,  },
   {   -1,   -1,   -1,   +1,   +1,   -1,   -2,   -1,   +3,   +1,   -2,   +1,   -1,   -1,   +3,   +1,  },
   {   +0,   +0,   +0,   +0,   -1,   -1,   +2,   +0,   -2,   +1,   +1,   +1,   +0,   +0,   -1,   +0,  },
   {   -7,  -22,  +34,  +15,  -30,  +27,  +56,   -4,  -23,  -23,  -57,  +47,   +3,   -5,  -26,  +23,  },
   {   -9,   +7,  -48,  +46,  +26,  -31,   +3,  +13,  +36,  -26,  -13,  +20,  +25,   -8,  +27,  +41,  },
   {   +6,  +17,   -2,  -40,  -32,  -43,  +18,  -16,   -2,  +23,   +6,  +35,  +30,  -22,  -14,   -7,  },
   {   +1,   -7,  +14,   -1,   -3,  +19,  -25,  -10,  +40,  +26,   +4,   +1,  -18,  -16,   +6,  +35,  },
   {   +0,   +2,   -4,   -1,   +7,   -2,   -1,   +0,  -17,   -3,   -5,  -27,   +1,  +10,  -20,  -10,  },
   {   +0,   -1,   +3,   +0,   -2,   +3,   -2,   -1,   +4,   +5,   +5,   +1,   -2,   +0,   +0,   +4,  },
   {   +0,   +1,   -1,   -1,   +2,   -1,   -1,   +0,   -3,   +0,   -1,   -5,   +0,   +1,   -2,   -1,  },
   {   +0,   +0,   +1,   +0,   -1,   +1,   -1,   +0,   +1,   +2,   +1,   +0,   -1,   +0,   +0,   +1,  },
   {   +3,   +9,  -10,  +17,  +15,   +7,  -15,  +24,  +43,  +10,  +28,  +37,  +11,   +0,  -76,   +5,  },
   {   +5,   +5,   +7,  -38,   -8,  -49,  -13,  -26,  -13,  -26,  +10,  -37,  +24,  -29,  -26,   +7,  },
   {   -1,  -12,  +21,   +1,   +1,  +52,  -27,  -37,   +4,  +38,   +4,   -9,  +22,  -27,   -4,  +23,  },
   {   -2,   +1,  -10,  +17,  +17,  +10,   +9,  +33,  -41,   +7,   +7,  -47,  -11,   +6,   -7,   +5,  },
   {   -2,   -3,   +6,   -3,   -1,  -11,   +9,   +5,  -19,  -12,   +0,  -28,   -3,  -27,  +12,  +69,  },
   {   -2,   -4,   +1,  +11,   -2,  +22,   -6,  -32,   -2,  +11,  -15,   +5,  +37,  -10,  +51,  -38,  },
   {   -1,   +4,  -11,  +15,   +4,   +7,  +20,  +55,  -24,  +42,   +7,   +0,  -13,  -30,   +5,   -8,  },
   {   +1,   +2,   +0,  -11,   -8,  -26,   +5,   -5,  +17,  -22,  -10,  +18,  -58,   +9,  +24,  -32,  },
   {   +1,   +4,   -1,   +3,   +2,   -1,   -3,   -7,  +11,   -5,   -1,   +8,   -5,   -3,   +7,  -15,  },
   {   +1,   +1,   -1,   -1,   +0,   -6,   +2,  +22,   -4,  +20,   +7,   +6,  +12,  -10,  -17,  -31,  },
   {   +0,   -2,   +4,  -10,   -1,   -9,   -6,  -14,   +8,  -14,   -2,   +0,  -63,   -7,  -16,  +24,  },
   {   +0,   -1,   +2,   +1,   +3,   +6,   -9,  -22,   +4,  -15,   +2,   -8,  +26,  +77,  -12,  +11,  },
   {   -1,   -1,   +3,   +0,   +0,   -2,   +3,   +1,   -3,   -1,   +1,   -4,   +9,   +9,   -5,   +2,  },
   {   -1,   -1,   +0,   +1,   +0,   +2,   -3,   -9,   -3,   -2,   -3,   -3,  -15,  -13,   +4,  +18,  },
   {   +0,   +1,   -2,   +3,   +0,   +4,   +1,   -3,   -3,   +1,   +0,   -3,  +11,  +45,   +2,  +11,  },
   {   +0,   +0,   -1,   +2,   -1,   -2,   +5,  +13,   -3,   +6,   +0,   +1,   +8,   -8,  +13,  -15,  },
  },
 },
 {  //2
  {
   { -121,   +0,  -20,  +32,   -3,   -4,   +7,   -8,  -15,   -3,   -1,   -5,   -2,   -2,   -2,   +4,  },
   {  +33,   -2,  +19, +108,   +0,  -12,   +1,  -31,  -43,   +1,   -6,  -14,   +0,  -10,   -3,   -4,  },
   {   +4,   +0,   -5,  -43,   -1,   -3,   +2,  +14, -100,   +2,   -3,  -48,   +2,   -4,  -25,  +28,  },
   {   +4,   +0,   +2,  +10,   +0,   +1,   +0,   -4,  +23,   +0,   +2,   +2,   +0,   +0,   -2, +103,  },
   {   +1,   +0,   -1,   -9,   +0,   -1,   +0,   +3,  -12,   +0,   -1,   -5,   +0,   +0,   -3,  -42,  },
   {   +2,   +0,   +1,   +3,   +0,   +0,   +0,   -1,   +6,   +0,   +0,   +1,   +0,   +0,   +0,  +24,  },
   {   +0,   +0,   +0,   -3,   +0,   +0,   +0,   +1,   -4,   +0,   +0,   -2,   +0,   +0,   -1,   -9,  },
   {   +1,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +2,   +0,   +0,   +0,   +0,   +0,   +0,   +7,  },
   {   -1, +121,  +16,   +4,  -29,  +19,   +4,   +9,   -6,   -6,   -6,  +10,   -2,   +3,   -1,   +1,  },
   {   -1,  -23,   +3,  +19,  +11, +105,   +3,  +43,  -17,   +3,  -35,  +24,   +0,  +11,   -3,   +2,  },
   {   +1,   -7,   -2,   -7,   -2,  -31,   -2,   +0,  -48,   +1,   +9,  +99,   +1,   -1,   -1,   +4,  },
   {   +0,   -3,   +0,   +1,   +1,   +7,   +0,   +1,  +10,   +0,   +0,  -17,   +0,   -1,   +4,   +0,  },
   {   +0,   -2,   +0,   -1,   +0,   -6,   +0,   -1,   -5,   +0,   +2,  +10,   +0,   +0,   -2,   +3,  },
   {   +0,   -1,   +0,   +0,   +0,   +1,   +0,   +0,   +2,   +0,   +0,   -4,   +0,   +0,   +2,   -1,  },
   {   +0,   -1,   +0,   +0,   +0,   -2,   +0,   +0,   -1,   +0,   +0,   +3,   +0,   +0,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   -1,   +0,   +0,   +1,   +0,  },
   {  +24,  +17, -120,  +11,  +12,   +9,  +22,  -13,   +1,   +0,   +1,   +4,   -1,   -6,   -7,   -1,  },
   {   -5,   +1,  +14,  -30,   +7,  +46,   -8, -105,   -5,   +3,   -6,  +14,   -1,  -40,   -8,   +0,  },
   {   -1,   -2,   +8,   +9,   -1,   -6,   +1,  +17,  +19,   -2,  +11,  +32,   +1,  -15,  -97,   -9,  },
   {   -1,   +0,   +1,   -2,   +0,   +0,   -1,   -2,   -6,   +0,   -2,   +0,   -1,   +6,  +17,  -42,  },
   {   +0,   +0,   +3,   +1,   +0,   +0,   +0,   +2,   +3,   +0,   +2,   +2,   +0,   -2,   -9,  +17,  },
   {   +0,   +0,   +1,   -1,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +0,   +0,   +1,   +3,   -9,  },
   {   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +1,   +1,   +0,   +0,   -3,   +3,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   -2,  },
   {   +5,  -27,  -18,   +0, -117,   +8,  -28,   -8,   +2,  -20,   -9,   -4,   -1,   +5,   -8,   -1,  },
   {   -1,   +4,   -2,   -8,  +12,  -29,   -9,  -25,   +7,   +8, -100,   +0,   -4,  +57,  -26,   +1,  },
   {   +0,   +2,   +3,   +2,   +9,   +9,   +4,   -3,  +15,   -2,  +17,  -39,   +2,   -6,  -61,  -14,  },
   {   +0,   +0,   +0,   +0,   +1,   -3,   +0,   +0,   -3,   +0,   -1,   +6,   +0,   +2,   -1,   +6,  },
   {   +0,   +0,   +1,   +0,   +3,   +1,   +1,   +0,   +1,   +0,   +1,   -4,   +0,   +0,   -3,   -4,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   +0,   +0,   -1,   +2,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   -1,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,  },
   {   +3,  -12,  +17,   -7,  -32,   -3, +117,   -7,   +4,  +30,  -10,   +2,   -8,   +1,   +2,   -1,  },
   {   -1,   +2,   -3,   -1,   -3,  -19,  -10,  +32,  +10,  +13,  -63,   -3,   -2,  -95,  +10,   -2,  },
   {   +0,   +1,   -1,   +2,   +3,   +3,   -8,   -5,   +5,   -3,   +1,   -4,   -1,  +18,  +24,   -4,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +2,   +0,   +1,   -6,   -7,   +4,  },
   {   +2,   -5,   +6,   -3,  +12,   -4,  +32,   -1,   +0, -116,  -17,   +2,  +30,  -10,   +5,   +0,  },
   {   -1,   +1,   -1,   -1,   -2,   -6,   +1,   +4,   +3,   +6,   +3,   -2,   +4,  -34,   +9,   +3,  },
   {   +0,   +0,   -1,   +1,   -1,   +1,   -4,   +0,   +1,  +10,   -4,   -2,   -4,   -2,  +19,   +1,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +0,   -1,   -1,  },
   {   +2,   -1,   +2,   -2,   +7,   +0,   +3,   +2,   -2,  -35,   -1,   +0, -102,   -4,   +0,   +0,  },
   {   -1,   +0,   +0,   -2,   +0,   +0,   +1,   -1,   +1,   -5,   +9,   +0,   +4,  +17,   +1,   +2,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   -1,   +0,   +2,   +4,   -1,   -1,   +8,   -2,   +4,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -2,  },
   {   +1,   -2,   +2,   +0,   +1,   +0,   -3,   +1,   -1,   -3,   +3,   +0,  -69,   +0,   -2,   +2,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   +1,   +0,   +1,   -1,   +4,   -1,   -2,   +2,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +1,   +0,   -1,   -1,   +6,   +1,   +1,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +0,  },
  },
  {
   {  +87,  -75,  +26,  -39,  +10,  -21,   -4,   +2,  -19,   +1,   +5,   +7,   +0,   -3,   +1,   -4,  },
   {  -41,   +4,  -44,  -68,  -20,  -45,   -2,  +19,  -62,   +9,  +17,  +27,   +0,   +0,   +2,  -18,  },
   {   +3,   +7,  +22,  +37,   +2,   +8,  -55,  +47,   -9,   -5,   -9,  +56,  +19,  -27,   -8,  -57,  },
   {   -4,   +0,   -6,   -7,   +0,   -2,  +28,  -23,   +3,   +0,   +0,   -2,   -4,  -80,   +6,   +8,  },
   {   +1,   +2,   +4,   +6,   +1,   +3,   -8,   +6,   +0,   -1,   -2,  +10,   +3,  +40,   -1,   -8,  },
   {   -1,   +0,   -2,   -2,   +0,   -1,   +5,   -4,   +0,   +0,   +1,   -3,   -2,  -16,   +1,   +1,  },
   {   +0,   +1,   +1,   +2,   +0,   +1,   -3,   +2,   +0,   +0,   +0,   +3,   +2,   +6,   +0,   -3,  },
   {   -1,   +0,   -1,   +0,   +0,   +0,   +2,   -1,   +0,   +0,   +0,   -1,   -1,   -4,   +0,   +0,  },
   {  -73,  -41,  +77,   -9,  +50,   -7,   -2,  -23,  -12,   +0,  +13,   -2,   -3,   +4,   +2,   -5,  },
   {  +28,  +36,  +24,  +56,   -1,  -30,  +37,  -22,  -56,  +22,  +54,   -6,  -13,   +3,   +8,  -20,  },
   {   +2,   -7,  -22,  -21,   +8,  +26,  +43,  -44,  +27,   -1,   -2,   +8,  +10,  +31,   -5,  -69,  },
   {   +1,   +3,   +2,   +1,   -5,   -8,  -19,  +17,   -7,   +2,   +7,  -28,   -4,  +61,   -1,   +7,  },
   {   +1,   -1,   -4,   -2,   +1,   +3,   +1,   -2,   +3,   +0,   -1,   +3,   +1,  -22,   +0,   -6,  },
   {   +1,   +1,   +0,   +0,   -1,   -1,   -2,   +2,   -1,   +1,   +1,   -4,   +0,   +7,   +0,   +2,  },
   {   +0,   +0,   -1,   -1,   +0,   +1,   +1,   -1,   +1,   +0,   +0,   +1,   +0,   -1,   +0,   -2,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   -1,   +0,   +0,   +0,   +0,   -1,   +0,   +1,   +0,   +1,  },
   {  +30,  +72,   +7,  -45,  +66,   -9,  -47,  -33,   +7,  -13,   +4,   -1,   -6,   -4,   +1,   +1,  },
   {   -5,  -29,  -38,   +4,  +17,  +69,  -34,   +3,   -8,  +17,  +51,   -4,  -37,   -7,  +24,   +4,  },
   {   -6,   -2,  +10,   -3,  -24,  -33,  -27,  +22,  +16,   +0,   -3,  -68,  -18,  -26,   +3,   +0,  },
   {   +1,   +0,   +0,   +6,   +4,   +5,   +5,   -2,   -6,   -2,   -6,  +35,   -5,   -6,   +5,  +33,  },
   {   -1,   -1,   +1,   -1,   -3,   -2,   +4,   -4,   +4,   +0,   -1,   -5,   +2,  -10,   -1,   -7,  },
   {   +0,   +0,   +0,   +2,   +1,   +0,   -1,   +1,   -2,   -1,   -1,   +5,   -2,   +6,   +1,   +5,  },
   {   +0,   -1,   +0,   +0,   -1,   -1,   +1,   -1,   +1,   +0,   +0,   -2,   +1,   -4,   +0,   -2,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   -1,   +1,   +0,   +1,  },
   {   -8,  -37,  -51,  +49,  +13,  -44,  -39,  -58,  -15,  -46,  -20,   +0,   +6,   +3,   -3,   +0,  },
   {   -3,   +6,  +27,  -13,  -49,  -31,   -2,  -17,  +54,  -10,   +6,  +35,   -6,   +8,  +12,   -9,  },
   {   +3,   +7,   +4,   +3,  +15,  +10,  +27,   +6,  -23,  -10,  -34,  +43,   -7,  +14,   +6,  +53,  },
   {   +0,   -2,   -3,   -3,   +1,   +7,   +4,   -6,   +2,   +4,   +9,   -4,  +25,  -18,  -10,  -22,  },
   {   +0,   +1,   +2,   -1,   +0,   -2,   -2,   +7,   -1,   -1,   -2,   -6,   -6,  +15,   +1,   +3,  },
   {   +0,   +0,   -1,   +0,   +0,   +2,   +1,   -1,   +0,   +1,   +2,   +1,   +4,   -5,   -1,   -1,  },
   {   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   -1,   -1,   -1,   +2,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +0,  },
   {   +3,  +12,  +31,  -19,  -53,  +49,  -11,  -23,  -42,  -80,  +16,  -14,  +16,   -2,   -9,   +4,  },
   {   +2,   +3,   -5,   +2,  +34,   +7,  +32,  +40,  -25,  -27,  -52,  -38,  +10,   -4,   -1,  -27,  },
   {   -1,   -4,   -8,   +0,   +6,   +2,   -8,   -2,   +4,  +20,  +28,  -12,  +55,   -1,  -25,   -2,  },
   {   +0,   +0,   +3,   +0,   -5,   -6,   -7,   +5,   +6,   -4,   +1,  -10,  -24,  +13,  +10,   -9,  },
   {   -2,   -3,  -14,   +5,  +30,  -23,  +27,  +43,  +34,  -66,  +59,   +9,  +15,   +0,  +45,   +5,  },
   {   -1,   -2,   +0,   +1,   -7,   -3,  -12,  -11,   +8,  +23,  +15,   +5,  +46,   +2,  -11,  +36,  },
   {   +0,   +1,   +5,   +1,  -11,   -2,   -6,   -8,   +2,   -2,   -8,   +7,  -52,   -4,  +18,  -13,  },
   {   +0,   +0,   -1,   +0,   +3,   +2,   +6,   -1,   -2,   -2,   -5,   +6,   +1,   -3,   +2,   +5,  },
   {   +1,   +4,   +6,   -2,  -11,   +9,  -13,  -18,  -15,  +20,  -28,   -9,  +35,   +3,  +86,   -7,  },
   {   +1,   +0,   +1,   +0,   -2,   +4,   +0,   -4,   -1,   -3,   -7,   +7,  -43,   -1,   +1,  -17,  },
   {   +0,   +0,   -3,   -1,   +5,   +0,   +4,   +5,   +0,   -2,   +2,   -4,  +10,   +2,  -13,   +1,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   -3,   +2,   -1,   +3,   +2,   -3,  +12,   +1,   -4,   +2,  },
   {   -1,   -1,   -4,   +1,   +4,   -2,   +3,   +4,   +3,  -14,  +10,   +4,  -23,   -2,  -65,   +4,  },
   {   +0,   +0,   -1,   +0,   +2,   -1,   -1,   +3,   +2,   +2,   +3,   -4,  +13,   +0,   -6,   +6,  },
   {   +0,   +0,   +1,   +0,   -1,   -1,   -2,   +0,   +0,   +3,   +0,   +0,   +5,   -2,   +7,   +4,  },
   {   +0,   +0,   +0,   +0,   -1,   +0,   +1,   -1,   +1,   -1,   -1,   +3,   -8,   -1,   +2,   -1,  },
  },
 },
 {  //3
  {
   { -115,  +15,  +29,  -36,   -6,   +4,  -20,   +4,  +12,   +5,   -3,   -1,  +10,   +4,   +2,   +3,  },
   {  +37,  +51,  -22,  -98,  +18,  +15,   -7,  +29,  +13,  +20,   -4,   -3,   -4,   +6,   +9,   -3,  },
   {   +9,  -18,  +16,  +25,   +3,  +52,  -43,   +1,  +10,  +90,  -34,   +2,   -6,  +14,  +13,  +12,  },
   {   +2,   +0,   -6,   +5,   -3,  -13,   +4,  +26,   +2,  -17,  -12,  +19,  +12,  +53,  +37,  +84,  },
   {   +2,   -3,   +3,   +4,   -1,   +5,   +0,   -5,   -1,   +4,   +2,   -2,   +5,   -4,  +19,  -12,  },
   {   +1,   +0,   -2,   +1,   +0,   -3,   +1,   +4,   +3,   -3,   -1,   +4,   +1,   +4,   +6,   +8,  },
   {   +1,   -1,   +1,   +2,   +0,   +2,   -1,   -2,   -1,   +2,   -1,   -1,   +1,   +0,   +2,   -2,  },
   {   +0,   +0,   -1,   +1,   +0,   -1,   +1,   +1,   +1,   -1,   +0,   +2,   +0,   +2,   +2,   +3,  },
   {  +10,  -95,   -4,  -59,  -50,  -17,   -7,  -17,  +17,   +6,   +5,   +9,  +11,   +0,   -9,   +6,  },
   {  -29,   +7,  -80,  +11,   -5,  -45,  +35,   -7,   -2,  +66,  +25,   +3,   -9,   -1,   -3,  +13,  },
   {   +8,  +34,  +12,  -17,  -38,  +16,   +0,  -73,  -46,   +8,  +11,  -35,  -12,  -20,   -9,  +50,  },
   {   +0,   -3,  +15,   +1,  +12,  +24,  +12,   +6,  +12,  +28,  +43,  +22,   -2,  -13,  -28,   -1,  },
   {   +1,   +5,   +0,   +1,   +0,   -2,   -4,   +6,   +7,   -7,  -10,  +11,   -7,   +3,  -20,  +45,  },
   {   +0,   -1,   +3,   +1,   +2,   +4,   +1,   +2,   +0,   +3,   +4,   +1,   +0,   +2,   -4,   +1,  },
   {   +1,   +2,   +0,   +0,   +0,   -1,   -1,   +1,   +2,   -1,   -2,   +2,   -1,   -1,   -3,   +7,  },
   {   +0,   +0,   +1,   +0,   +1,   +2,   +0,   +1,   +0,   +1,   +1,   +0,   +0,   +1,   -1,   +0,  },
   {  +23,  +23,  +45,   +6,   +3,  -87,  -51,   -5,  +16,  +29,  +23,   -7,  +33,   -3,   +1,   -2,  },
   {   -8,  -47,   +7,  -13,  +67,   -8,   -2,  +21,  -45,   +5,  +20,  -65,  -10,   +1,  +18,  +18,  },
   {   -8,   +1,  -59,   +7,   -7,  -14,  -57,   -3,   -9,  -19,  -40,  -19,   -4,   -5,   +9,  -22,  },
   {   +1,   +6,   +7,   -3,  -40,   +7,   +5,   +5,  -53,  +12,  +12,  -22,  +18,  +35,  +28,  -37,  },
   {   -1,   +0,   -2,   +0,   +3,   +8,  +15,   -1,   +6,   +9,  +21,  +11,  +18,  -16,  +24,  -13,  },
   {   +0,   +1,   +1,   +0,   -6,   +1,   +0,   -3,   +1,   -1,   -3,   +4,   -4,   -6,   +6,  +14,  },
   {   +0,   +0,   -1,   +0,   +1,   +2,   +4,   +0,   +1,   +1,   +4,   +2,   +4,   -1,   +2,   +0,  },
   {   +0,   +1,   +0,   +0,   -3,   +0,   +0,   -1,   +0,   +0,   -1,   +1,   -1,   -2,   +2,   +3,  },
   {   +3,   +8,  -15,  +14,  -12,  +23,   +7,  -11,  +70,  -10,  +25,  -75,  +28,  +46,  -20,   +1,  },
   {   +3,   +5,  +41,   -4,  -13,  -35,  +39,   +2,  +16,  +14,  -28,  -18,  -72,  +29,   -5,  -12,  },
   {   -2,  -12,   -3,  -14,  +65,   -6,   +5,  -52,   +8,   -1,  -10,   +3,   +1,  +13,  -25,   -3,  },
   {   -1,   +0,  -16,   +3,   -3,   -3,  -55,   -3,   -4,  -13,   +5,   -1,  -49,  +21,  -33,   +2,  },
   {   +0,   -1,   +2,   -1,  -10,   +1,   +1,  +27,  -37,   +7,   +8,  -10,  +15,  +37,  -36,  -15,  },
   {   +0,   +0,   -3,   +0,   +0,   +1,   -7,   -2,   +1,   +0,   +6,   +2,   +2,   -5,   +9,   -8,  },
   {   +0,   +0,   +0,   +0,   -1,   +0,   +1,   +5,   -7,   +1,   +0,   +0,   +2,   +4,   -2,   +1,  },
   {   +0,   +0,   -1,   +0,   +0,   +0,   -3,   +0,   +0,   +0,   +2,   +1,   +1,   -1,   +2,   -1,  },
   {   +4,   +3,   +1,   +2,   +9,   +2,   +1,   +0,  -12,   +0,   -4,   +2,  +56,  -10,  -13,  +19,  },
   {   +0,   -3,   +0,   +8,  -20,   +5,  -10,  +27,  +29,   -6,  +21,  -35,  -23,  -53,  +42,  +14,  },
   {   +0,   +1,   +7,   -3,   -5,  -17,  +41,   +8,   +3,  +13,  -64,  -27,  +22,  -18,   +1,   -4,  },
   {   -1,   -1,   -2,   -5,  +22,   +0,   +2,  -58,  +21,   -4,   -8,   +4,   -1,   +8,  +57,  -12,  },
   {   +1,   +2,   -3,   +2,   -2,   +3,   +4,   +2,   +4,   +0,   -5,   +1,   +4,   +9,  -22,   -4,  },
   {   +1,   +1,   +6,   +0,   +0,   -1,   -3,   -5,   +0,   -4,  +19,   +8,   -1,  +12,   -2,   +5,  },
   {   +0,   -2,   +1,   +0,   +0,   -1,   -2,  +25,   +5,   +1,  +10,  -17,  -15,  -41,  -25,  +17,  },
   {   +0,   +0,   -2,   +0,   -1,   -5,   +3,   +3,   -1,   +5,  -48,  -19,  +26,  -25,  -28,   +8,  },
   {   +2,   +1,   +0,   +0,   +2,   +0,   -1,   +0,   -3,   +0,   +3,   +3,   +6,   -2,   +5,   +2,  },
   {   +0,   -1,   +0,   +3,   -3,   +1,   -2,   +3,   +4,   -1,   -1,   +0,   +4,   +2,   +6,   -4,  },
   {   +0,   +0,   +1,   +0,   -2,   -4,   +7,   +0,   +1,   -1,  +10,   +3,  -10,  +13,  +19,   -4,  },
   {   +0,   +0,   +0,   -1,   +3,   +0,   +1,   -5,   +4,   +1,   -3,   -6,   +0,  -16,  -12,   +4,  },
   {   +0,   +1,   -1,   +1,   -1,   +1,   +1,   +0,   +2,   +0,   +0,   +0,   +0,   +4,   -5,   -2,  },
   {   +0,   +1,   +2,   +0,   +0,   +0,   -1,   -2,   +0,   -1,   +4,   +2,   +2,   +1,   -3,   +2,  },
   {   +0,   -1,   +0,   +0,   +1,   +0,   -1,   +7,   +1,   +0,   +3,   -1,   -3,   -5,   -2,   +1,  },
   {   +0,   +0,   -1,   +0,   +0,   -2,   +0,   +0,   +0,   +0,   -6,   -2,   +2,   +1,   +4,   +0,  },
  },
  {
   { +109,  -39,  +29,  +18,  -29,  -23,   -7,   +1,  +11,  -10,   -8,   -5,   +1,   +2,   +4,   -7,  },
   {  -26,  +31,   -3,  +96,  -60,   -5,   -3,  -26,  +14,  -11,  -24,   +1,  +12,   -9,   +9,   -2,  },
   {   -8,   -5,   -2,  -23,  +16,  -15,  +12,   +5,   +6,  -47,  -99,   -1,  -20,  -18,  +39,  +15,  },
   {   -3,   +2,   -2,   +2,   -2,   +5,   -3,   +0,   -3,   +3,  +11,   +0,  +21,   +8,  +18,   -6,  },
   {   -2,   -1,   +0,   -5,   +3,   -2,   +3,   +1,   +1,   -4,  -10,   +1,   -4,   -3,   +0,   +1,  },
   {   -1,   +1,   +0,   +1,   -1,   +1,   -1,   +0,   -1,   +1,   +3,   +0,   +5,   +3,   +2,   -1,  },
   {   -1,   +0,   +0,   -2,   +1,   -1,   +1,   +1,   +1,   -1,   -4,   +0,   -2,   -1,   +0,   +1,  },
   {   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +1,   +0,   +2,   +1,   +1,   -1,  },
   {  -50,  -95,   +0,  -10,  -52,   +2,  -31,  +24,  +10,   +5,   -5,  -10,   -5,   +3,   -6,  -11,  },
   {  +28,   +6,  -41,   +6,   +9,  +79,  -62,   -3,   -7,  +28,  -36,  -14,   -2,  -25,  -16,   -3,  },
   {   +2,  +18,   +9,  +10,  -17,  -13,   +8,  +43,   -9,  +11,  +19,   -6,  -75,  -62,  -22,  +22,  },
   {   +1,   +0,   +0,   -2,   +5,   -4,   +7,   -6,   +3,   -2,  -26,   +8,   +9,   -6,  -37,  -14,  },
   {   +0,   +4,   +2,   +1,   -2,   -2,   +0,   +4,   -2,   -1,   +4,   +0,   -1,   +0,   +5,   +0,  },
   {   +0,   +0,   +0,   -1,   +1,   -1,   +2,   -2,   +1,   +0,   -5,   +1,   +2,   -2,   -5,   -2,  },
   {   +0,   +1,   +1,   +1,   -1,   -1,   +0,   +1,   -1,   +0,   +1,   +0,   -1,   +0,   +1,   +1,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   +1,   -1,   +0,   +0,   -2,   +0,   +1,   -1,   -2,   -1,  },
   {  -18,  +32,  +86,  -14,  +13,   -9,  -75,   -7,  +22,  -12,   +0,  -17,   -1,   -6,   -5,  -18,  },
   {   -8,  -49,   +4,  +26,  +56,   +1,   +9,  -64,  +21,   -2,  +25,   -2,   -2,  -61,  +15,   -7,  },
   {   +6,   +5,  -33,   +2,   -2,   +5,  -45,   +9,   +1,  -38,  +41,   +7,  -16,  +14,  +63,  +30,  },
   {   +0,   +1,   +2,   -4,   -9,   -1,   +5,  +14,  -21,   +2,   +5,   -5,   -4,  -51,   +9,   -9,  },
   {   +1,   +1,   -6,   +1,   +0,   +1,   -1,   +0,   +2,   +0,   -3,   +3,   +0,   +2,  -16,   -4,  },
   {   +0,   +0,   +1,   -1,   -2,   +0,   +1,   +3,   -4,   +1,   +1,   -1,   -1,   -6,   +0,   +0,  },
   {   +1,   +0,   -2,   +0,   +0,   +0,   -1,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   -3,   -1,  },
   {   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   -2,   +0,   +0,   +0,   +0,   -2,   +0,   +0,  },
   {   +6,  +27,  -32,  -43,  -34,   -4,  +14,  -12,  +92,  +16,  +10,  -16,   -7,  -19,  +18,  -35,  },
   {   -2,   -1,  +58,   -9,  -18,  +49,  +35,   -4,   +1,  +38,   -5,  +13,   +7,   +0,  +42,  +23,  },
   {   -3,  -14,   +1,  +35,  +41,   +2,   +0,   +5,  +53,  +11,   -7,   +3,  -31,  +40,  -18,  +23,  },
   {   +0,   +2,   -7,   -2,   +0,  -14,  -23,   +3,   +0,  -16,  +12,  +31,   +0,   -7,  +27,  +10,  },
   {   +0,   -2,   +0,   +4,   +3,   +1,   +2,   -1,   -9,   -1,   +2,   -1,   +3,  -17,  +15,  -17,  },
   {   +0,   +1,   -2,   -1,   +0,   -3,   -5,   +1,   +1,   -3,   +1,   +6,   +0,   +0,   +1,   +1,  },
   {   +0,   -1,   +0,   +1,   +1,   +0,   +1,   +0,   -2,   +0,   +0,   +0,   +0,   -3,   +3,   -3,  },
   {   +0,   +0,   -1,   +0,   +0,   -1,   -2,   +0,   +0,   -2,   +0,   +2,   +0,   +0,   +1,   +0,  },
   {   -3,   +3,  -14,  +14,  +19,  -31,   +1,   +8,  -21,  +12,   -1,  -93,   +4,  +13,  +12,  -19,  },
   {   +2,   +5,   -8,  -40,  -36,  -14,   -8,  -59,  -11,   -9,   +1,  -15,  +11,   -4,  -34,  +53,  },
   {   +1,   -3,  +20,   +1,  -10,  +56,  +32,   -3,   +1,  -22,   +9,  -46,  -12,  +11,   +9,   +6,  },
   {   -1,   -2,   +0,  +10,  +13,   -1,   -1,  +26,  +40,   +7,   -3,   -3,   +4,   +9,  -24,  +48,  },
   {   +0,   +4,   -2,   +2,   +3,  +13,   +7,  +14,   -5,   -8,   -3,  +23,  -12,  +17,   +4,  -65,  },
   {   +0,   +1,   -3,   +1,   +6,  -37,  -12,   +6,   -4,  +60,  -14,  -19,  +14,   +0,  +28,  +12,  },
   {   +0,   -1,   +0,  -10,  -14,   -4,   -4,  -58,  -24,   +4,   -3,   +0,  -50,  +24,   -2,  -12,  },
   {   +0,   -1,   +4,   +1,   -1,  +20,  +10,   +6,   +5,  -36,  +12,  -47,   -1,   +5,   +4,  +11,  },
   {   -2,   +2,   -1,   +2,   +3,   -2,   +0,   -5,   -4,   -6,   +2,   +8,   -8,   +1,  -11,   -8,  },
   {   +0,   +0,   -1,   -4,   +1,   +2,   +2,  +17,   +5,  -15,   +4,   +4,  +32,  -12,   -4,  -16,  },
   {   +0,   +0,   +0,   -1,   -1,  -10,   -6,   -7,   -6,  +54,  -13,   +8,   -4,   +4,  +30,  +10,  },
   {   +0,   +0,   +0,   -1,   -3,   +0,   -1,  -18,   -5,   +7,   -2,   +3,  -54,  +28,   +2,  -21,  },
   {   +0,   +2,   -1,   +0,   +1,   +2,   +2,   +3,   +0,   +3,   -1,   +2,   +2,   +0,   +5,   -2,  },
   {   +0,   +0,   +1,   +0,   +1,   -4,   +0,   +3,   +0,   -7,   +3,   +3,   +0,   +0,  -13,  -12,  },
   {   +0,   +0,   +0,   -1,   -1,   +0,   +0,   -1,   +0,   -8,   +2,   +0,  +30,  -15,   -4,   +6,  },
   {   +0,   +0,   +0,   +0,   -1,   -1,   -2,   -5,   -3,  +14,   -4,   +0,  -15,   +8,  +18,   +2,  },
  },
 },
};
const int8_t g_lfnst4x4[4][2][16][16] = {
 {  //0
  {
   { +108,  -40,  +25,  -32,   +8,  -25,   +8,   +2,  -16,   -9,  -13,   +8,   -2,   +4,   +2,   +0,  },
   {  -44,  -97,  -31,  -39,   -9,   +5,   +9,  +34,  -27,  -10,   +1,   -7,  +13,   +9,   -2,   -2,  },
   {  -15,  +56,   -1,  -92,  +33,  +16,  +16,   -5,  -39,  -34,   +4,   -5,   -6,  +11,   +8,   +0,  },
   {   +1,  +12,   +7,  +51,   -8,   -3,   +1,   +1, -109,   +4,   -9,  -15,   -4,  +31,  -16,  -10,  },
   {  -44,  -11, +100,   -6,  -16,  -38,  +37,   -7,   +6,   -9,  -30,   +7,   -2,   +4,   +8,   -1,  },
   {  +19,  +29,  -16,  -16, -102,  +14,  +36,  +24,  +10,   -5,  -17,  -30,  +28,   +9,   +5,   -7,  },
   {   +7,  -12,  -29,  +36,  +36,  +11,  +94,  -25,  +16,  -29,   -3,  -28,  -13,  +16,  +28,   -3,  },
   {   -1,   -3,   +1,   -8,  +23,   -3,  -38,   -3,  +24,   +5,  -64,  -87,  -14,  +19,  -17,  -35,  },
   {  -11,  +18,  -54,   +3,   -4,  -97,   -7,   +8,   +3,  -33,  -35,  +31,   -3,  +12,   +6,   -1,  },
   {   +6,  +18,  +21,  +22,  +38,   +7,   +3,  +99,  +19,  -26,  +11,   +4,  +37,  +33,   -7,   -7,  },
   {   +2,  -15,  +14,  +18,  -27,  +26,  -47,  -28,  +10,  -96,  +17,   +4,  -15,  +32,  +18,   -2,  },
   {   -1,   -3,   -4,  -15,   -5,   +1,  +11,  -29,  +24,  +33,  +19,  +33,   -3,  +94,  -45,  -32,  },
   {   +0,   -1,   -7,   +4,   +5,  +55,   -6,   +6,   -4,  +14,  -86,  +61,   -2,  +12,  +40,   -6,  },
   {   -1,   -3,   +2,   +1,  +16,  -10,  -13,  -43,   -7,   +4,   +6,   -5, +107,   +0,  +36,  -33,  },
   {   -1,   +2,   +4,   -5,   -8,  -19,  -17,  +21,   -2,  +39,  +36,  -17,  -36,  +34,  +97,  -16,  },
   {   +0,   +1,   +0,   +2,   -6,   +3,  +10,  +11,   -3,  -14,  +14,  +22,  -24,  -45,   -8, -112,  },
  },
  {
   { +119,  -27,   +0,  +23,  -19,  -10,  -17,   +1,   -6,   +9,   +4,   -6,   +4,   -4,   +0,   +0,  },
   {  -30, -101,  +58,   +4,   -5,   -1,  -28,  -24,  -17,   +5,   -5,   -4,   -4,   -7,   +6,   +0,  },
   {  -22,  +31,  +22,  +66,  -89,   -1,  +12,  -23,   -2,  +35,   -5,   -9,   +7,   +0,   +0,   -1,  },
   {   -3,  +17,  -15,  -11,   +2,   +6,   -8,   +1, -111,   +0,  -10,  -39,   +8,  -24,  +30,   +5,  },
   {  -23,  -47, -102,  +22,  -26,  +23,  -32,  +17,   +7,   +6,  +15,   +1,   +4,   -7,   -6,   -1,  },
   {   -2,   +2,   +2,  +89,  +76,  +25,  +14,   -7,  -17,  +21,  +19,  +22,  -13,   +0,   +1,   -7,  },
   {   +3,  +22,  +38,   -2,  -11,  +87,  -53,  +52,   +8,   -9,   -2,   +0,  -18,  -25,  -13,   +1,  },
   {   +2,   +3,   +2,  -26,  -17,   -7,   -6,   +9,  -42,  +34,   +6, +102,   +5,   +3,  -23,  -34,  },
   {  -16,  +19,  +10,  +13,  +20,  -74,  -68,  +50,   +9,  +44,   +6,  -19,   +0,   -3,   +1,   -2,  },
   {   +3,  +30,  -13,   -8,  +13,   +4,  -67,  -92,  +18,   -3,  -12,  +19,   +0,  -30,  +20,   +3,  },
   {   +6,   -7,   -5,  -38,  +18,  +39,  +17,  -15,  +16, +102,  -13,  -32,  +21,   +8,   -2,   -6,  },
   {   +0,   -9,   +4,   -1,   -4,   -5,  +29,  +27,  +25,  +11,   +6,  +30,  +22,  -76,  +80,  +19,  },
   {   -3,   +5,  +14,   -9,   +1,   +0,   +2,  -15,   -4,   -7,  +95,  -16,  +58,  -34,  -44,   +5,  },
   {   +2,   +3,   -1,  -20,  -15,   -1,   +6,  -10,   +2,  +13,  +69,  -14,  -88,   +4,  +37,  -38,  },
   {   +1,   -5,   -9,   -2,   +3,  -20,  +25,   -6,   -1,  +11,  -29,   -8,  -54,  -80,  -68,  +11,  },
   {   +0,   -1,   +0,   +8,   +5,   -1,   +4,   +3,  +11,  -20,  -24,  -23,  +28,  -26,   +1, -115,  },
  },
 },
 {  //1
  {
   { -111,  -47,  -35,  +13,  -11,   +0,  -17,   +4,   +5,   -4,   -2,   +5,   -5,   +0,   -1,   -1,  },
   {  +39,  -27,  -23,  +93,  -27,  -35,  -46,  -10,  -20,   -1,  -10,  +13,   -7,   +4,   +2,   +0,  },
   {   +4,  +15,   +4,  -27,   +1,  +32,  -92,  -23,  +32,  +38,  +35,  +18,  -34,   -2,   +7,  -12,  },
   {   +3,   -1,   +4,   -4,   +2,   -2,  +14,   +4,   -5,  -18,  -19,  +34,  -83,  -60,  -57,  +23,  },
   {  +44,  -92,  -17,  -48,  -47,  +26,   +7,  +16,   +8,   -7,   +5,  +11,   +2,   +5,   +3,   +1,  },
   {  +11,  +43,  -72,  +13,   -4,  +60,  -10,  +58,   -3,  -42,   +8,   -4,   -1,   +9,   -7,   -4,  },
   {  -12,  +20,  +32,  -34,  -36,   -3,  -39,  -17,  -46,  -63,  -44,  +18,   -4,  +42,   +9,  +17,  },
   {   -1,   -2,   +6,   +4,  +10,  -17,  +29,  +26,   -7,   -6,  +14,  +18,  -73,  +34,  +68,  -53,  },
   {   +7,  +20,  -59,  -52,   -2,  -82,  -17,  +30,   -4,  +33,  -25,   +5,   +4,   +5,   -9,   -3,  },
   {  -16,  +39,  +18,  +11,  -85,   +1,  +27,  +21,   +2,  +34,  +25,  +58,  +20,  -14,   +6,   +4,  },
   {   -5,  -16,  +50,   +1,  +14,  -30,  -28,  +67,  -15,  -23,  +58,   -3,  +15,   +9,  -49,  -21,  },
   {   +2,   -5,   -6,  +10,  +29,   +0,  +17,   +2,  +24,  +15,  +17,  +42,  -12,  +80,  -20,  +72,  },
   {   +3,  +10,   +0,   +3,  -20,  -37,   +1,  -13, +100,  -65,   +7,   -2,   +4,   -5,   +6,   -4,  },
   {   -1,   -5,  +40,  +16,   -2,  +21,  -15,  +59,  +44,  +33,  -84,  -10,   -3,  +13,   -4,   -8,  },
   {   +4,  -13,   +0,   -3,  +57,   +3,  -13,  +13,   +0,  -20,  -16,  +85,  +44,  -38,  +36,   -3,  },
   {   +2,   +2,  -13,   +1,   +4,  +12,  +17,  -40,   +5,   +2,  -18,  +38,  +12,  +37,  -64,  -83,  },
  },
  {
   {  +88,  -58,  -51,  -27,  +19,  +29,  -12,  +19,   -6,  -13,   -1,   -8,   +1,   +4,   -1,   -3,  },
   {  -55,  -20,  +23,  -76,   -4,  +50,  -21,  +38,  +27,  -28,   +8,  -22,  +12,   +5,   -5,   -7,  },
   {   +6,  +27,  -22,  +49,  -36,  +13,  -74,  -10,  +18,  -45,  +24,  -17,  +32,  +24,  -20,  -22,  },
   {   -3,   -2,   +5,   -2,  +22,  -10,  +43,   -5,   -5,  -39,  -51,  +33,  +51,  +60,  -34,  -34,  },
   {  -66,  -27,  -63,  +40,  +52,   +1,  -13,  +28,  -37,   +0,  -15,  -18,   -8,   -5,   +4,   -5,  },
   {  +27,  +75,   +3,  +14,   +7,  +34,  +39,  +66,  -18,   -5,   -9,  -45,   +8,  -14,   +4,  -11,  },
   {   +9,  -29,  +37,   +9,  +36,  -59,  +18,   +0,  +12,  -39,  +44,  -57,   -2,  -23,  -15,  -36,  },
   {   -2,   +0,   -5,  -17,  -23,   +1,   -5,   -5,  -25,  +69,  +10,  -27,  -31,  +38,  -46,  -69,  },
   {  +11,  +47,   +1,  -56,  +28,  -51,  -58,   -4,  -44,  -23,  -28,   +0,  -22,   +9,  +18,   -1,  },
   {  +11,  -42,  +64,  +36,  -17,   +4,  -35,  +19,  -10,  +16,  -70,  -31,   +4,   +8,  +31,   -3,  },
   {  -13,  -11,  -35,  -25,  -64,  -16,  +27,  -30,  -38,  -12,  -12,  -30,  +46,  -34,  +42,  -25,  },
   {   +1,  +11,   -4,   +6,  +15,  +30,   -5,  -26,  +37,  -18,  -39,  +29,  -39,  -59,  +10,  -73,  },
   {   -2,   -9,  +29,  +14,   -5,  +52,  +19,  -40,  -66,  -50,  +24,   -2,  -49,  +24,  +10,   +5,  },
   {   -7,   -3,  -31,   +3,  -44,  -33,  +26,  +28,  +45,  -31,  -18,  -13,  -67,  +47,  +27,   +4,  },
   {   +1,  +19,  -11,   -6,  +48,  +24,   +6,  -60,  +40,  +24,   -4,  -53,  +14,  +42,  +49,   +4,  },
   {   +2,   -4,  +13,   +8,   +9,   -5,   -5,  +37,   -7,  +13,  +51,  +49,  +17,  +28,  +78,  -49,  },
  },
 },
 {  //2
  {
   { -112,  +29,  -36,  +28,  -12,  +18,   +5,  -13,   -4,  +15,   -8,   -2,   -3,   +2,   +4,   +0,  },
   {  +47,   -7,  -87,   -5,  -24,  +53,   -1,  -32,  -13,  +33,  -24,   -6,   -7,   +6,   +8,   +1,  },
   {   -2,   +1,  +69,   +2,  +15,  +69,   +2,  +18,  -10,  +63,  -27,  -24,  -16,  +10,  +21,   +4,  },
   {   +2,   -1,  -10,   -2,   -3,  -74,   +0,   -2,  +19,  +89,  +15,  +13,  -21,   -3,  +40,  +11,  },
   {  -34, -108,  -17,  -29,  +26,  +14,  -26,  +15,  +18,   +8,  +12,   -1,  +10,   -5,   -4,   -2,  },
   {  +13,  +40,  -33,  +13,  +80,  +24,   +6,  +34,  +46,  +15,  +41,   -8,  +24,  -16,  -11,   -4,  },
   {   +2,   +2,  +26,   -2,  -61,  +28,   +0,  -27,  +60,  +25,  +26,  +37,  +46,  -31,  -28,  -13,  },
   {   +0,   +0,   -2,   +0,   +9,  -30,   +1,   +7,  -48,  +40,  -29,  -22,  +75,  +12,  -57,  -34,  },
   {  +15,  -45,   +7, +103,  +15,   -6,  +45,  -25,  +16,   -4,  -17,   +3,   +8,   +7,   +5,   +3,  },
   {   -7,  +13,  +14,  -36,  +54,   -7,   -9,  -80,  +33,   -8,  -50,  +18,  +20,  +24,  +14,   +7,  },
   {   +1,   +4,  -11,   -4,  -36,  -11,   -1,  +47,  +60,  -15,  -39,  -51,  +38,  +41,  +31,  +20,  },
   {   +0,   -1,   +2,   +1,   +2,  +12,   +0,   -1,  -48,   -8,  +27,  +22,  +72,  -16,  +70,  +47,  },
   {   +8,   +8,   +6,  +48,   +0,   -5, -113,  -16,   +1,   -2,   +0,  -23,   +1,  -16,   +7,   -6,  },
   {   -3,   -5,   +8,  -16,   -4,   -7,  +28,  -50,   +0,   -6,  +35,  -95,   +2,  -41,  +18,  -19,  },
   {   -1,   +1,   -7,   -4,   +6,   -6,   +8,  +28,   +5,   -9,  -67,  +17,   +1,  -89,  +32,  -42,  },
   {   +0,   +0,   +0,   +1,   -2,   +8,   -1,   +2,   -2,   -7,  +26,  +17,   +7,  +49,  +52, -101,  },
  },
  {
   {  -99,  +58,  -15,  +46,  -14,   -3,  +17,  +15,   -6,   -2,   +7,   -5,   +4,   -2,   -3,   +1,  },
   {  +39,  +42,  +71,   +5,  -54,   +3,  +16,  +54,  -17,   -1,  +29,  -24,   +8,  -11,   -5,   +1,  },
   {   -1,  -33,  -44,   +4,  -29,  +69,   -2,   -8,  -55,   -9,  +14,  -53,  +21,  -25,  -23,   +7,  },
   {   +2,   +3,   +5,   -6,  +29,  -42,   +1,   +6,  -28,  -79,   -6,  +15,  +52,   -4,  -57,  +18,  },
   {  +65,  +33,  -58,  +71,  +25,  -11,  +38,   +6,   +9,   +7,  +12,   -3,   -1,   -4,   -2,   +1,  },
   {  -20,  -63,  -29,  -12,   -9,  -50,  +18,  +60,  +30,  +11,  +53,  -15,   -1,  -21,   -4,   +2,  },
   {   -5,  +23,  +25,  -15,  +61,  -26,  -12,  -26,   -8,  +48,  +10,  -61,   -5,  -53,  -24,  +16,  },
   {   +0,   -1,   +3,   +5,  -29,  +26,   +0,   -8,  +58,  +44,  -11,  +26,  +29,   +2,  -75,  +47,  },
   {  -15,  -55,  +62,  +52,  +27,  +24,  +62,  -30,   +4,  -13,  +14,   +6,   -7,   -5,   +1,   +2,  },
   {   -2,  +32,   -7,  -38,  +44,  +63,   +1,  +17,  +34,  -34,  +59,  +30,  -17,  -26,   +3,   +5,  },
   {   +5,   +3,   -4,  +13,  -48,  -19,  -14,  -38,  +41,  -55,  -15,  -16,  -44,  -64,   +9,  +24,  },
   {   -1,   -5,   -4,   -2,   +5,   -5,   +5,  +22,  -52,   +6,   -3,  +23,  -84,  +19,  -25,  +67,  },
   {   +0,  +21,  -19,  -63,  -27,  -18,  +89,  -43,  -16,  +12,   +5,  +13,   +8,   -8,   +6,   +3,  },
   {   +3,   -2,   +4,  +23,  -21,  -22,  -42,  -45,  -36,  +23,  +71,  +56,  +20,  -19,  +15,   +9,  },
   {   -1,   -8,   +0,   +3,  +12,  +12,   +8,  +42,  -20,  +20,  -54,  +44,  +31,  -73,  +41,  +25,  },
   {   +0,   +3,   +1,   -3,   +7,   +0,   -2,   -7,  +16,  -11,  +13,  -35,  +39,  +39,  +61,  +88,  },
  },
 },
 {  //3
  {
   { -114,  -19,  +36,  -27,  -11,  +15,  +13,  +16,   -8,   -6,   +5,   -5,   +1,   -3,   -2,   -5,  },
   {  +37,  -41,  -25,  -80,  -21,  +47,  +25,  +11,  -34,  -30,   +9,  -23,   +3,   -2,   -7,  -12,  },
   {   +3,  +19,  +18,  +44,  +37,  +10,  +79,  -26,  -26,  -42,   -6,  -23,  +23,  -21,  -33,  -18,  },
   {   +2,   -2,   -2,   -3,  -10,   -6,  -39,  +13,   +7,  -12,  +42,  +36,  +73,  -52,  -56,  -12,  },
   {  -22,  +85,  -42,  -58,  +44,  -16,  -13,  -13,  -26,   -3,  -15,   +3,   +8,   +1,   -4,   +8,  },
   {  -23,  -60,  -53,   +1,   -4,  -44,  +10,  -74,  -19,   +5,  -18,  +22,   +5,  -10,   -6,  +22,  },
   {  +14,  -11,  +35,  -29,  +47,  +42,  +31,  -20,  +29,  +57,   -9,  +36,  +34,  -17,  +21,  +38,  },
   {   +0,   +7,   +5,  +19,  -12,  +10,   -4,   -1,  -37,  -52,  +26,  +40,  +46,  +44,  +63,  +36,  },
   {  +21,  +17,  +46,  -41,  -37,  -80,  +49,   +5,   +1,   -2,  +15,  +27,  -12,  -19,  +15,   -5,  },
   {  -17,  +31,  -60,  +18,  -41,  +25,  +45,   -6,  +22,  +37,  +58,   -4,   +2,  -20,  +31,  -15,  },
   {   -5,  -34,  -25,  -12,  +58,  -40,  +12,  +29,  +46,  -12,  +14,  -16,  +35,  +30,  +32,  -51,  },
   {   +2,   +2,  +19,   -7,  +18,  +21,   -8,  -47,   -9,   +6,  +43,  +56,  -38,  +45,  -22,  -63,  },
   {   +5,  -11,   +8,  +12,  +10,  -23,   +3,  +26,  -81,  +74,  +23,  -25,  +26,  +27,  -10,   -5,  },
   {   +2,  +19,  +21,  -17,  -46,   -2,   -1,  -49,  +37,  +10,  -10,  -46,  +52,  +61,  -26,   +0,  },
   {   -4,   +2,  -33,   +7,  -16,   +3,  +43,  +54,  +14,   +6,  -37,  +56,   +2,  +49,  -52,  +15,  },
   {   -1,   -8,   -1,   -6,  +31,  -14,   +7,   +2,  +20,  -15,  +75,  -24,  -31,  +21,  -38,  +73,  },
  },
  {
   { -102,  +12,  -59,  -33,   +0,  +28,  +11,  -13,   -9,   -6,  +12,   +2,   -1,   +5,   +2,   -1,  },
   {  +22,  +93,  -24,  +23,  -38,  +38,  -35,  +23,  -20,  +24,  +17,   -9,   -9,  -12,   -6,   +1,  },
   {   +7,  -27,  +17,  -36,  -81,   +8,  +21,  +22,  -55,  -38,  +17,   +8,  +28,  -24,  +11,  -14,  },
   {   +2,   -6,   +1,  +11,  +30,   -9,  -17,  -36,  -83,  +23,   +0,  +45,  -24,  -17,  +45,  +36,  },
   {  +66,  -27,  -62,  -21,  +27,  +62,  +30,  -12,   +3,   -8,  +32,   +7,   -1,  +13,   +3,   -1,  },
   {  -25,  -64,   -2,  +50,   +5,  +32,  -18,  +64,   -2,  +40,  +27,   -8,  -10,  -34,  -10,   +2,  },
   {   -6,  +36,   -3,  +35,  +51,  -13,  +31,  +39,   +1,  -49,  +21,  +27,  +49,  -32,  +33,  -20,  },
   {   -1,   +6,   +2,  -16,  -32,   +2,  +18,  +25,  +62,   +0,   +2,  +35,  -30,  -16,  +55,  +69,  },
   {  -15,  +13,  +83,  -23,  +24,  +51,  -11,  -19,   +8,   -7,  +67,   -9,   -8,  +14,   +8,   +0,  },
   {  +14,   +5,  -12,  -78,  +36,  -32,  -36,  +23,   +2,   +9,  +11,  -31,   -7,  -67,   -5,   +0,  },
   {   +1,  -23,  -17,  +16,  -16,  +15,  -80,  -36,  +27,  -25,   -6,  -17,  +40,   -7,  +59,  -15,  },
   {   -1,   +0,   -2,  +19,  +12,   +5,  +12,   +9,  -28,  -44,  -10,  -87,   +1,   +9,   +4,  +72,  },
   {   +2,   -2,  -24,  +22,  -24,  -66,  +16,  -30,   +7,  +23,  +89,  -23,   +4,   +7,   +7,   +3,  },
   {   -2,   +6,  +14,  +15,   -8,  +28,  +49,  -58,  +15,  +39,  -22,  -22,  +33,  -74,   -4,   +4,  },
   {   +1,   +5,   +7,  -30,   +9,   +0,  +13,  +33,  -11,  +70,  -12,  -19,  +65,  +49,  +44,   +5,  },
   {   +0,   -3,   -2,   -5,   +1,   -1,  -32,   -7,   +5,   -3,  +16,  +44,  +67,   +1,  -66,  +65,  },
  },
 },
};

//--------------------------------------------------------------------------------------------------

}
