/* $Id: tstIEMAImplDataFpuOther-Amd.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Amd - r150746 on AMD Ryzen Threadripper 3990X 64-Core Processor.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_UNARY_R80_TEST_T const g_aTests_f2xm1_r80_amd[] =
{
    { 0x0000, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/0/u */
    { 0x007f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/0/c */
    { 0x0100, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/1/u */
    { 0x017f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/1/c */
    { 0x0200, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/2/u */
    { 0x027f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/2/c */
    { 0x0300, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/3/u */
    { 0x037f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/0/3/c */
    { 0x0400, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/0/u */
    { 0x047f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/0/c */
    { 0x0500, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/1/u */
    { 0x057f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/1/c */
    { 0x0600, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/2/u */
    { 0x067f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/2/c */
    { 0x0700, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/3/u */
    { 0x077f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/1/3/c */
    { 0x0800, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/0/u */
    { 0x087f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/0/c */
    { 0x0900, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/1/u */
    { 0x097f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/1/c */
    { 0x0a00, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/2/u */
    { 0x0a7f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/2/c */
    { 0x0b00, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/3/u */
    { 0x0b7f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/2/3/c */
    { 0x0c00, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/0/u */
    { 0x0c7f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/0/c */
    { 0x0d00, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/1/u */
    { 0x0d7f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/1/c */
    { 0x0e00, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/2/u */
    { 0x0e7f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/2/c */
    { 0x0f00, 0xf64e, 0xfca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/3/u */
    { 0x0f7f, 0xf64e, 0x7c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,31398) }, /* #0/3/3/c */
    { 0x0000, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/0/u */
    { 0x007f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/0/c */
    { 0x0100, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/1/u */
    { 0x017f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/1/c */
    { 0x0200, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/2/u */
    { 0x027f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/2/c */
    { 0x0300, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/3/u */
    { 0x037f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/0/3/c */
    { 0x0400, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/0/u */
    { 0x047f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/0/c */
    { 0x0500, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/1/u */
    { 0x057f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/1/c */
    { 0x0600, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/2/u */
    { 0x067f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/2/c */
    { 0x0700, 0x187c, 0xbaa0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/3/u */
    { 0x077f, 0x187c, 0x3a20, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773181,596) }, /* #1/1/3/c */
    { 0x0800, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/0/u */
    { 0x087f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/0/c */
    { 0x0900, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/1/u */
    { 0x097f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/1/c */
    { 0x0a00, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/2/u */
    { 0x0a7f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/2/c */
    { 0x0b00, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/3/u */
    { 0x0b7f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/2/3/c */
    { 0x0c00, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/0/u */
    { 0x0c7f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/0/c */
    { 0x0d00, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/1/u */
    { 0x0d7f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/1/c */
    { 0x0e00, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/2/u */
    { 0x0e7f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/2/c */
    { 0x0f00, 0x187c, 0xb8a0, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/3/u */
    { 0x0f7f, 0x187c, 0x3820, RTFLOAT80U_INIT_C(1,0xbdcdf277dec97b8b,596), RTFLOAT80U_INIT_C(1,0x838ffc2018773180,596) }, /* #1/3/3/c */
    { 0x0000, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/0/u */
    { 0x007f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/0/c */
    { 0x0100, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/1/u */
    { 0x017f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/1/c */
    { 0x0200, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/2/u */
    { 0x027f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/2/c */
    { 0x0300, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/3/u */
    { 0x037f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/3/c */
    { 0x0400, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/0/u */
    { 0x047f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/0/c */
    { 0x0500, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/1/u */
    { 0x057f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/1/c */
    { 0x0600, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/2/u */
    { 0x067f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/2/c */
    { 0x0700, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/3/u */
    { 0x077f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/3/c */
    { 0x0800, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/0/u */
    { 0x087f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/0/c */
    { 0x0900, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/1/u */
    { 0x097f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/1/c */
    { 0x0a00, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/2/u */
    { 0x0a7f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/2/c */
    { 0x0b00, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/3/u */
    { 0x0b7f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/3/c */
    { 0x0c00, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/0/u */
    { 0x0c7f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/0/c */
    { 0x0d00, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/1/u */
    { 0x0d7f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/1/c */
    { 0x0e00, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/2/u */
    { 0x0e7f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/2/c */
    { 0x0f00, 0x7328, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/3/u */
    { 0x0f7f, 0x7328, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/3/c */
    { 0x0000, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/0/u */
    { 0x007f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/0/c */
    { 0x0100, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/1/u */
    { 0x017f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/1/c */
    { 0x0200, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/2/u */
    { 0x027f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/2/c */
    { 0x0300, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/3/u */
    { 0x037f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/0/3/c */
    { 0x0400, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/0/u */
    { 0x047f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/0/c */
    { 0x0500, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/1/u */
    { 0x057f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/1/c */
    { 0x0600, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/2/u */
    { 0x067f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/2/c */
    { 0x0700, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/3/u */
    { 0x077f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/1/3/c */
    { 0x0800, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/0/u */
    { 0x087f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/0/c */
    { 0x0900, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/1/u */
    { 0x097f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/1/c */
    { 0x0a00, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/2/u */
    { 0x0a7f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/2/c */
    { 0x0b00, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/3/u */
    { 0x0b7f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/2/3/c */
    { 0x0c00, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/0/u */
    { 0x0c7f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/0/c */
    { 0x0d00, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/1/u */
    { 0x0d7f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/1/c */
    { 0x0e00, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/2/u */
    { 0x0e7f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/2/c */
    { 0x0f00, 0x2b8c, 0xb9a0, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/3/u */
    { 0x0f7f, 0x2b8c, 0x3920, RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929), RTFLOAT80U_INIT_C(1,0x96437475af2c5e8d,22929) }, /* #3/3/3/c */
    { 0x0000, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/0/0/u */
    { 0x007f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/0/c */
    { 0x0100, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/0/1/u */
    { 0x017f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/1/c */
    { 0x0200, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/0/2/u */
    { 0x027f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/2/c */
    { 0x0300, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/0/3/u */
    { 0x037f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/3/c */
    { 0x0400, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/1/0/u */
    { 0x047f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/0/c */
    { 0x0500, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/1/1/u */
    { 0x057f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/1/c */
    { 0x0600, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/1/2/u */
    { 0x067f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/2/c */
    { 0x0700, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/1/3/u */
    { 0x077f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/3/c */
    { 0x0800, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/2/0/u */
    { 0x087f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/0/c */
    { 0x0900, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/2/1/u */
    { 0x097f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/1/c */
    { 0x0a00, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/2/2/u */
    { 0x0a7f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/2/c */
    { 0x0b00, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/2/3/u */
    { 0x0b7f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/3/c */
    { 0x0c00, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/3/0/u */
    { 0x0c7f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/0/c */
    { 0x0d00, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/3/1/u */
    { 0x0d7f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/1/c */
    { 0x0e00, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/3/2/u */
    { 0x0e7f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/2/c */
    { 0x0f00, 0x1ac9, 0xb881, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372) }, /* #4/3/3/u */
    { 0x0f7f, 0x1ac9, 0x3801, RTFLOAT80U_INIT_C(0,0x6f7ffd7c52db1dc7,4372), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/3/c */
    { 0x0000, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/0/0/u */
    { 0x007f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/0/0/c */
    { 0x0100, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/0/1/u */
    { 0x017f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/0/1/c */
    { 0x0200, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/0/2/u */
    { 0x027f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/0/2/c */
    { 0x0300, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/0/3/u */
    { 0x037f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/0/3/c */
    { 0x0400, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/1/0/u */
    { 0x047f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/1/0/c */
    { 0x0500, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/1/1/u */
    { 0x057f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/1/1/c */
    { 0x0600, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/1/2/u */
    { 0x067f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/1/2/c */
    { 0x0700, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/1/3/u */
    { 0x077f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/1/3/c */
    { 0x0800, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/2/0/u */
    { 0x087f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/2/0/c */
    { 0x0900, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/2/1/u */
    { 0x097f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/2/1/c */
    { 0x0a00, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/2/2/u */
    { 0x0a7f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/2/2/c */
    { 0x0b00, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/2/3/u */
    { 0x0b7f, 0x0bb1, 0x3b32, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece3,0) }, /* #5/2/3/c */
    { 0x0c00, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/3/0/u */
    { 0x0c7f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/3/0/c */
    { 0x0d00, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/3/1/u */
    { 0x0d7f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/3/1/c */
    { 0x0e00, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/3/2/u */
    { 0x0e7f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/3/2/c */
    { 0x0f00, 0x0bb1, 0xb982, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0) }, /* #5/3/3/u */
    { 0x0f7f, 0x0bb1, 0x3932, RTFLOAT80U_INIT_C(0,0x8000e65731cf1aab,0), RTFLOAT80U_INIT_C(0,0x58b9aba4dabcece2,0) }, /* #5/3/3/c */
    { 0x0000, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/0/0/u */
    { 0x007f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/0/0/c */
    { 0x0100, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/0/1/u */
    { 0x017f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/0/1/c */
    { 0x0200, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/0/2/u */
    { 0x027f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/0/2/c */
    { 0x0300, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/0/3/u */
    { 0x037f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/0/3/c */
    { 0x0400, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/1/0/u */
    { 0x047f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/1/0/c */
    { 0x0500, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/1/1/u */
    { 0x057f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/1/1/c */
    { 0x0600, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/1/2/u */
    { 0x067f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/1/2/c */
    { 0x0700, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/1/3/u */
    { 0x077f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/1/3/c */
    { 0x0800, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/2/0/u */
    { 0x087f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/2/0/c */
    { 0x0900, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/2/1/u */
    { 0x097f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/2/1/c */
    { 0x0a00, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/2/2/u */
    { 0x0a7f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/2/2/c */
    { 0x0b00, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/2/3/u */
    { 0x0b7f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/2/3/c */
    { 0x0c00, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/3/0/u */
    { 0x0c7f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/3/0/c */
    { 0x0d00, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/3/1/u */
    { 0x0d7f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/3/1/c */
    { 0x0e00, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/3/2/u */
    { 0x0e7f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/3/2/c */
    { 0x0f00, 0xb336, 0xb981, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767) }, /* #6/3/3/u */
    { 0x0f7f, 0xb336, 0x3901, RTFLOAT80U_INIT_C(0,0x87dc4e2d743d59f2,32767), RTFLOAT80U_INIT_C(0,0xc7dc4e2d743d59f2,32767) }, /* #6/3/3/c */
    { 0x0000, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/0/0/u */
    { 0x007f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/0/0/c */
    { 0x0100, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/0/1/u */
    { 0x017f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/0/1/c */
    { 0x0200, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/0/2/u */
    { 0x027f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/0/2/c */
    { 0x0300, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/0/3/u */
    { 0x037f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/0/3/c */
    { 0x0400, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/1/0/u */
    { 0x047f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/1/0/c */
    { 0x0500, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/1/1/u */
    { 0x057f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/1/1/c */
    { 0x0600, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/1/2/u */
    { 0x067f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/1/2/c */
    { 0x0700, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/1/3/u */
    { 0x077f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/1/3/c */
    { 0x0800, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/2/0/u */
    { 0x087f, 0xe506, 0x7f32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c2,0) }, /* #7/2/0/c */
    { 0x0900, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/2/1/u */
    { 0x097f, 0xe506, 0x7f32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c2,0) }, /* #7/2/1/c */
    { 0x0a00, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/2/2/u */
    { 0x0a7f, 0xe506, 0x7f32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c2,0) }, /* #7/2/2/c */
    { 0x0b00, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/2/3/u */
    { 0x0b7f, 0xe506, 0x7f32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c2,0) }, /* #7/2/3/c */
    { 0x0c00, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/3/0/u */
    { 0x0c7f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/3/0/c */
    { 0x0d00, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/3/1/u */
    { 0x0d7f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/3/1/c */
    { 0x0e00, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/3/2/u */
    { 0x0e7f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/3/2/c */
    { 0x0f00, 0xe506, 0xfd82, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x6dc,0) }, /* #7/3/3/u */
    { 0x0f7f, 0xe506, 0x7d32, RTFLOAT80U_INIT_C(0,0x6dc,0), RTFLOAT80U_INIT_C(0,0x4c1,0) }, /* #7/3/3/c */
    { 0x0000, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/0/0/u */
    { 0x007f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/0/c */
    { 0x0100, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/0/1/u */
    { 0x017f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/1/c */
    { 0x0200, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/0/2/u */
    { 0x027f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/2/c */
    { 0x0300, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/0/3/u */
    { 0x037f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/3/c */
    { 0x0400, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/1/0/u */
    { 0x047f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/0/c */
    { 0x0500, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/1/1/u */
    { 0x057f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/1/c */
    { 0x0600, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/1/2/u */
    { 0x067f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/2/c */
    { 0x0700, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/1/3/u */
    { 0x077f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/3/c */
    { 0x0800, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/2/0/u */
    { 0x087f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/0/c */
    { 0x0900, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/2/1/u */
    { 0x097f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/1/c */
    { 0x0a00, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/2/2/u */
    { 0x0a7f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/2/c */
    { 0x0b00, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/2/3/u */
    { 0x0b7f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/3/c */
    { 0x0c00, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/3/0/u */
    { 0x0c7f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/0/c */
    { 0x0d00, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/3/1/u */
    { 0x0d7f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/1/c */
    { 0x0e00, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/3/2/u */
    { 0x0e7f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/2/c */
    { 0x0f00, 0x6680, 0xfc81, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767) }, /* #8/3/3/u */
    { 0x0f7f, 0x6680, 0x7c01, RTFLOAT80U_INIT_C(0,0x7b80a62eb4a5f522,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/3/c */
    { 0x0000, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/0/0/u */
    { 0x007f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/0/c */
    { 0x0100, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/0/1/u */
    { 0x017f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/1/c */
    { 0x0200, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/0/2/u */
    { 0x027f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/2/c */
    { 0x0300, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/0/3/u */
    { 0x037f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/3/c */
    { 0x0400, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/1/0/u */
    { 0x047f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/0/c */
    { 0x0500, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/1/1/u */
    { 0x057f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/1/c */
    { 0x0600, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/1/2/u */
    { 0x067f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/2/c */
    { 0x0700, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/1/3/u */
    { 0x077f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/3/c */
    { 0x0800, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/2/0/u */
    { 0x087f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/0/c */
    { 0x0900, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/2/1/u */
    { 0x097f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/1/c */
    { 0x0a00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/2/2/u */
    { 0x0a7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/2/c */
    { 0x0b00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/2/3/u */
    { 0x0b7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/3/c */
    { 0x0c00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/3/0/u */
    { 0x0c7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/0/c */
    { 0x0d00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/3/1/u */
    { 0x0d7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/1/c */
    { 0x0e00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/3/2/u */
    { 0x0e7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/2/c */
    { 0x0f00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051) }, /* #9/3/3/u */
    { 0x0f7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(0,0x1223c16af6b995f3,8051), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/3/c */
    { 0x0000, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/0/0/u */
    { 0x007f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/0/0/c */
    { 0x0100, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/0/1/u */
    { 0x017f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/0/1/c */
    { 0x0200, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/0/2/u */
    { 0x027f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/0/2/c */
    { 0x0300, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/0/3/u */
    { 0x037f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/0/3/c */
    { 0x0400, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/1/0/u */
    { 0x047f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/1/0/c */
    { 0x0500, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/1/1/u */
    { 0x057f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/1/1/c */
    { 0x0600, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/1/2/u */
    { 0x067f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/1/2/c */
    { 0x0700, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/1/3/u */
    { 0x077f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/1/3/c */
    { 0x0800, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/2/0/u */
    { 0x087f, 0xaabf, 0x3a32, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d034,0) }, /* #10/2/0/c */
    { 0x0900, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/2/1/u */
    { 0x097f, 0xaabf, 0x3a32, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d034,0) }, /* #10/2/1/c */
    { 0x0a00, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/2/2/u */
    { 0x0a7f, 0xaabf, 0x3a32, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d034,0) }, /* #10/2/2/c */
    { 0x0b00, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/2/3/u */
    { 0x0b7f, 0xaabf, 0x3a32, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d034,0) }, /* #10/2/3/c */
    { 0x0c00, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/3/0/u */
    { 0x0c7f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/3/0/c */
    { 0x0d00, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/3/1/u */
    { 0x0d7f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/3/1/c */
    { 0x0e00, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/3/2/u */
    { 0x0e7f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/3/2/c */
    { 0x0f00, 0xaabf, 0xb882, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x86305,0) }, /* #10/3/3/u */
    { 0x0f7f, 0xaabf, 0x3832, RTFLOAT80U_INIT_C(0,0x86305,0), RTFLOAT80U_INIT_C(0,0x5d033,0) }, /* #10/3/3/c */
    { 0x0000, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/0/u */
    { 0x007f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/0/c */
    { 0x0100, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/1/u */
    { 0x017f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/1/c */
    { 0x0200, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/2/u */
    { 0x027f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/2/c */
    { 0x0300, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/3/u */
    { 0x037f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/0/3/c */
    { 0x0400, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/0/u */
    { 0x047f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/0/c */
    { 0x0500, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/1/u */
    { 0x057f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/1/c */
    { 0x0600, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/2/u */
    { 0x067f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/2/c */
    { 0x0700, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/3/u */
    { 0x077f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/1/3/c */
    { 0x0800, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/0/u */
    { 0x087f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/0/c */
    { 0x0900, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/1/u */
    { 0x097f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/1/c */
    { 0x0a00, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/2/u */
    { 0x0a7f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/2/c */
    { 0x0b00, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/3/u */
    { 0x0b7f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/2/3/c */
    { 0x0c00, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/0/u */
    { 0x0c7f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/0/c */
    { 0x0d00, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/1/u */
    { 0x0d7f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/1/c */
    { 0x0e00, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/2/u */
    { 0x0e7f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/2/c */
    { 0x0f00, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/3/u */
    { 0x0f7f, 0xa1dc, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #11/3/3/c */
    { 0x0000, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/0/u */
    { 0x007f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/0/c */
    { 0x0100, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/1/u */
    { 0x017f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/1/c */
    { 0x0200, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/2/u */
    { 0x027f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/2/c */
    { 0x0300, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/3/u */
    { 0x037f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/0/3/c */
    { 0x0400, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/0/u */
    { 0x047f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/0/c */
    { 0x0500, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/1/u */
    { 0x057f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/1/c */
    { 0x0600, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/2/u */
    { 0x067f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/2/c */
    { 0x0700, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/3/u */
    { 0x077f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/1/3/c */
    { 0x0800, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/0/u */
    { 0x087f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/0/c */
    { 0x0900, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/1/u */
    { 0x097f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/1/c */
    { 0x0a00, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/2/u */
    { 0x0a7f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/2/c */
    { 0x0b00, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/3/u */
    { 0x0b7f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/2/3/c */
    { 0x0c00, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/0/u */
    { 0x0c7f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/0/c */
    { 0x0d00, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/1/u */
    { 0x0d7f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/1/c */
    { 0x0e00, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/2/u */
    { 0x0e7f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/2/c */
    { 0x0f00, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/3/u */
    { 0x0f7f, 0x2be6, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #12/3/3/c */
    { 0x0000, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/0/u */
    { 0x007f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/0/c */
    { 0x0100, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/1/u */
    { 0x017f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/1/c */
    { 0x0200, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/2/u */
    { 0x027f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/2/c */
    { 0x0300, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/3/u */
    { 0x037f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/0/3/c */
    { 0x0400, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/0/u */
    { 0x047f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/0/c */
    { 0x0500, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/1/u */
    { 0x057f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/1/c */
    { 0x0600, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/2/u */
    { 0x067f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/2/c */
    { 0x0700, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/3/u */
    { 0x077f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/1/3/c */
    { 0x0800, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/0/u */
    { 0x087f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/0/c */
    { 0x0900, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/1/u */
    { 0x097f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/1/c */
    { 0x0a00, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/2/u */
    { 0x0a7f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/2/c */
    { 0x0b00, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/3/u */
    { 0x0b7f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/2/3/c */
    { 0x0c00, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/0/u */
    { 0x0c7f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/0/c */
    { 0x0d00, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/1/u */
    { 0x0d7f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/1/c */
    { 0x0e00, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/2/u */
    { 0x0e7f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/2/c */
    { 0x0f00, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/3/u */
    { 0x0f7f, 0xd2ef, 0x7800, RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767), RTFLOAT80U_INIT_C(0,0xc00017904a6adec4,32767) }, /* #13/3/3/c */
    { 0x0000, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/0/0/u */
    { 0x007f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/0/0/c */
    { 0x0100, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/0/1/u */
    { 0x017f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/0/1/c */
    { 0x0200, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/0/2/u */
    { 0x027f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/0/2/c */
    { 0x0300, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/0/3/u */
    { 0x037f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/0/3/c */
    { 0x0400, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/1/0/u */
    { 0x047f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/1/0/c */
    { 0x0500, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/1/1/u */
    { 0x057f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/1/1/c */
    { 0x0600, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/1/2/u */
    { 0x067f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/1/2/c */
    { 0x0700, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/1/3/u */
    { 0x077f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/1/3/c */
    { 0x0800, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/2/0/u */
    { 0x087f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/2/0/c */
    { 0x0900, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/2/1/u */
    { 0x097f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/2/1/c */
    { 0x0a00, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/2/2/u */
    { 0x0a7f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/2/2/c */
    { 0x0b00, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/2/3/u */
    { 0x0b7f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/2/3/c */
    { 0x0c00, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/3/0/u */
    { 0x0c7f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/3/0/c */
    { 0x0d00, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/3/1/u */
    { 0x0d7f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/3/1/c */
    { 0x0e00, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/3/2/u */
    { 0x0e7f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/3/2/c */
    { 0x0f00, 0xa139, 0xb981, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599) }, /* #14/3/3/u */
    { 0x0f7f, 0xa139, 0x3901, RTFLOAT80U_INIT_C(0,0x47029e15c5a0e8,19599), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #14/3/3/c */
    { 0x0000, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/0/u */
    { 0x007f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/0/c */
    { 0x0100, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/1/u */
    { 0x017f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/1/c */
    { 0x0200, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/2/u */
    { 0x027f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/2/c */
    { 0x0300, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/3/u */
    { 0x037f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/0/3/c */
    { 0x0400, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/0/u */
    { 0x047f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/0/c */
    { 0x0500, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/1/u */
    { 0x057f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/1/c */
    { 0x0600, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/2/u */
    { 0x067f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/2/c */
    { 0x0700, 0xef0b, 0xffa0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/3/u */
    { 0x077f, 0xef0b, 0x7f20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e025,13347) }, /* #15/1/3/c */
    { 0x0800, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/0/u */
    { 0x087f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/0/c */
    { 0x0900, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/1/u */
    { 0x097f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/1/c */
    { 0x0a00, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/2/u */
    { 0x0a7f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/2/c */
    { 0x0b00, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/3/u */
    { 0x0b7f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/2/3/c */
    { 0x0c00, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/0/u */
    { 0x0c7f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/0/c */
    { 0x0d00, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/1/u */
    { 0x0d7f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/1/c */
    { 0x0e00, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/2/u */
    { 0x0e7f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/2/c */
    { 0x0f00, 0xef0b, 0xfda0, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/3/u */
    { 0x0f7f, 0xef0b, 0x7d20, RTFLOAT80U_INIT_C(1,0xbad29e3c2259e13d,13347), RTFLOAT80U_INIT_C(1,0x817ee2afd112e024,13347) }, /* #15/3/3/c */
    { 0x0000, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/0/u */
    { 0x007f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/0/c */
    { 0x0100, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/1/u */
    { 0x017f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/1/c */
    { 0x0200, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/2/u */
    { 0x027f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/2/c */
    { 0x0300, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/3/u */
    { 0x037f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/0/3/c */
    { 0x0400, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/0/u */
    { 0x047f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/0/c */
    { 0x0500, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/1/u */
    { 0x057f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/1/c */
    { 0x0600, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/2/u */
    { 0x067f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/2/c */
    { 0x0700, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/3/u */
    { 0x077f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/1/3/c */
    { 0x0800, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/0/u */
    { 0x087f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/0/c */
    { 0x0900, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/1/u */
    { 0x097f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/1/c */
    { 0x0a00, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/2/u */
    { 0x0a7f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/2/c */
    { 0x0b00, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/3/u */
    { 0x0b7f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/2/3/c */
    { 0x0c00, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/0/u */
    { 0x0c7f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/0/c */
    { 0x0d00, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/1/u */
    { 0x0d7f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/1/c */
    { 0x0e00, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/2/u */
    { 0x0e7f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/2/c */
    { 0x0f00, 0xb923, 0xb9a0, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/3/u */
    { 0x0f7f, 0xb923, 0x3920, RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597), RTFLOAT80U_INIT_C(1,0xaf975d4be8fcd73e,32597) }, /* #16/3/3/c */
    { 0x0000, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/0/0/u */
    { 0x007f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/0/c */
    { 0x0100, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/0/1/u */
    { 0x017f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/1/c */
    { 0x0200, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/0/2/u */
    { 0x027f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/2/c */
    { 0x0300, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/0/3/u */
    { 0x037f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/3/c */
    { 0x0400, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/1/0/u */
    { 0x047f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/0/c */
    { 0x0500, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/1/1/u */
    { 0x057f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/1/c */
    { 0x0600, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/1/2/u */
    { 0x067f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/2/c */
    { 0x0700, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/1/3/u */
    { 0x077f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/3/c */
    { 0x0800, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/2/0/u */
    { 0x087f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/0/c */
    { 0x0900, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/2/1/u */
    { 0x097f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/1/c */
    { 0x0a00, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/2/2/u */
    { 0x0a7f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/2/c */
    { 0x0b00, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/2/3/u */
    { 0x0b7f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/3/c */
    { 0x0c00, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/3/0/u */
    { 0x0c7f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/0/c */
    { 0x0d00, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/3/1/u */
    { 0x0d7f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/1/c */
    { 0x0e00, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/3/2/u */
    { 0x0e7f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/2/c */
    { 0x0f00, 0xefd3, 0xfd81, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405) }, /* #17/3/3/u */
    { 0x0f7f, 0xefd3, 0x7d01, RTFLOAT80U_INIT_C(0,0x1e06971ff43e2d2,31405), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/3/c */
    { 0x0000, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/0/0/u */
    { 0x007f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/0/0/c */
    { 0x0100, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/0/1/u */
    { 0x017f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/0/1/c */
    { 0x0200, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/0/2/u */
    { 0x027f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/0/2/c */
    { 0x0300, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/0/3/u */
    { 0x037f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/0/3/c */
    { 0x0400, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/1/0/u */
    { 0x047f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/1/0/c */
    { 0x0500, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/1/1/u */
    { 0x057f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/1/1/c */
    { 0x0600, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/1/2/u */
    { 0x067f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/1/2/c */
    { 0x0700, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/1/3/u */
    { 0x077f, 0xf044, 0x7a32, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa21,0) }, /* #18/1/3/c */
    { 0x0800, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/2/0/u */
    { 0x087f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/2/0/c */
    { 0x0900, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/2/1/u */
    { 0x097f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/2/1/c */
    { 0x0a00, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/2/2/u */
    { 0x0a7f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/2/2/c */
    { 0x0b00, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/2/3/u */
    { 0x0b7f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/2/3/c */
    { 0x0c00, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/3/0/u */
    { 0x0c7f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/3/0/c */
    { 0x0d00, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/3/1/u */
    { 0x0d7f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/3/1/c */
    { 0x0e00, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/3/2/u */
    { 0x0e7f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/3/2/c */
    { 0x0f00, 0xf044, 0xf882, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0) }, /* #18/3/3/u */
    { 0x0f7f, 0xf044, 0x7832, RTFLOAT80U_INIT_C(1,0x45213f2552f644ff,0), RTFLOAT80U_INIT_C(1,0x2feacbefd563aa20,0) }, /* #18/3/3/c */
    { 0x0000, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/0/u */
    { 0x007f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/0/c */
    { 0x0100, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/1/u */
    { 0x017f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/1/c */
    { 0x0200, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/2/u */
    { 0x027f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/2/c */
    { 0x0300, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/3/u */
    { 0x037f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/0/3/c */
    { 0x0400, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/0/u */
    { 0x047f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/0/c */
    { 0x0500, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/1/u */
    { 0x057f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/1/c */
    { 0x0600, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/2/u */
    { 0x067f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/2/c */
    { 0x0700, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/3/u */
    { 0x077f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/1/3/c */
    { 0x0800, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/0/u */
    { 0x087f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/0/c */
    { 0x0900, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/1/u */
    { 0x097f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/1/c */
    { 0x0a00, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/2/u */
    { 0x0a7f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/2/c */
    { 0x0b00, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/3/u */
    { 0x0b7f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/2/3/c */
    { 0x0c00, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/0/u */
    { 0x0c7f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/0/c */
    { 0x0d00, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/1/u */
    { 0x0d7f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/1/c */
    { 0x0e00, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/2/u */
    { 0x0e7f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/2/c */
    { 0x0f00, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/3/u */
    { 0x0f7f, 0x0fc1, 0x3d00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #19/3/3/c */
    { 0x0000, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/0/u */
    { 0x007f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/0/c */
    { 0x0100, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/1/u */
    { 0x017f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/1/c */
    { 0x0200, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/2/u */
    { 0x027f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/2/c */
    { 0x0300, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/3/u */
    { 0x037f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/0/3/c */
    { 0x0400, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/0/u */
    { 0x047f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/0/c */
    { 0x0500, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/1/u */
    { 0x057f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/1/c */
    { 0x0600, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/2/u */
    { 0x067f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/2/c */
    { 0x0700, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/3/u */
    { 0x077f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/1/3/c */
    { 0x0800, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/0/u */
    { 0x087f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/0/c */
    { 0x0900, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/1/u */
    { 0x097f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/1/c */
    { 0x0a00, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/2/u */
    { 0x0a7f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/2/c */
    { 0x0b00, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/3/u */
    { 0x0b7f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/2/3/c */
    { 0x0c00, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/0/u */
    { 0x0c7f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/0/c */
    { 0x0d00, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/1/u */
    { 0x0d7f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/1/c */
    { 0x0e00, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/2/u */
    { 0x0e7f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/2/c */
    { 0x0f00, 0xb26a, 0xb8a0, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/3/u */
    { 0x0f7f, 0xb26a, 0x3820, RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339), RTFLOAT80U_INIT_C(1,0xc2aae0a3a5ec6444,28339) }, /* #20/3/3/c */
    { 0x0000, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/0/u */
    { 0x007f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/0/c */
    { 0x0100, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/1/u */
    { 0x017f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/1/c */
    { 0x0200, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/2/u */
    { 0x027f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/2/c */
    { 0x0300, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/3/u */
    { 0x037f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/0/3/c */
    { 0x0400, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/0/u */
    { 0x047f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/0/c */
    { 0x0500, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/1/u */
    { 0x057f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/1/c */
    { 0x0600, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/2/u */
    { 0x067f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/2/c */
    { 0x0700, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/3/u */
    { 0x077f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/1/3/c */
    { 0x0800, 0x64e5, 0xfea0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/0/u */
    { 0x087f, 0x64e5, 0x7e20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/0/c */
    { 0x0900, 0x64e5, 0xfea0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/1/u */
    { 0x097f, 0x64e5, 0x7e20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/1/c */
    { 0x0a00, 0x64e5, 0xfea0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/2/u */
    { 0x0a7f, 0x64e5, 0x7e20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/2/c */
    { 0x0b00, 0x64e5, 0xfea0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/3/u */
    { 0x0b7f, 0x64e5, 0x7e20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308dba,5045) }, /* #21/2/3/c */
    { 0x0c00, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/0/u */
    { 0x0c7f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/0/c */
    { 0x0d00, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/1/u */
    { 0x0d7f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/1/c */
    { 0x0e00, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/2/u */
    { 0x0e7f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/2/c */
    { 0x0f00, 0x64e5, 0xfca0, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/3/u */
    { 0x0f7f, 0x64e5, 0x7c20, RTFLOAT80U_INIT_C(0,0xb131d30d4df96859,5046), RTFLOAT80U_INIT_C(0,0xf5a4d76662308db9,5045) }, /* #21/3/3/c */
    { 0x0000, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/0/0/u */
    { 0x007f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/0/c */
    { 0x0100, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/0/1/u */
    { 0x017f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/1/c */
    { 0x0200, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/0/2/u */
    { 0x027f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/2/c */
    { 0x0300, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/0/3/u */
    { 0x037f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/3/c */
    { 0x0400, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/1/0/u */
    { 0x047f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/0/c */
    { 0x0500, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/1/1/u */
    { 0x057f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/1/c */
    { 0x0600, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/1/2/u */
    { 0x067f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/2/c */
    { 0x0700, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/1/3/u */
    { 0x077f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/3/c */
    { 0x0800, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/2/0/u */
    { 0x087f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/0/c */
    { 0x0900, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/2/1/u */
    { 0x097f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/1/c */
    { 0x0a00, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/2/2/u */
    { 0x0a7f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/2/c */
    { 0x0b00, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/2/3/u */
    { 0x0b7f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/3/c */
    { 0x0c00, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/3/0/u */
    { 0x0c7f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/0/c */
    { 0x0d00, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/3/1/u */
    { 0x0d7f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/1/c */
    { 0x0e00, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/3/2/u */
    { 0x0e7f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/2/c */
    { 0x0f00, 0xc9b8, 0xf981, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0x11,16821) }, /* #22/3/3/u */
    { 0x0f7f, 0xc9b8, 0x7901, RTFLOAT80U_INIT_C(1,0x11,16821), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/3/c */
    { 0x0000, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/0/0/u */
    { 0x007f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/0/0/c */
    { 0x0100, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/0/1/u */
    { 0x017f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/0/1/c */
    { 0x0200, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/0/2/u */
    { 0x027f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/0/2/c */
    { 0x0300, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/0/3/u */
    { 0x037f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/0/3/c */
    { 0x0400, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/1/0/u */
    { 0x047f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/1/0/c */
    { 0x0500, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/1/1/u */
    { 0x057f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/1/1/c */
    { 0x0600, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/1/2/u */
    { 0x067f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/1/2/c */
    { 0x0700, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/1/3/u */
    { 0x077f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/1/3/c */
    { 0x0800, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/2/0/u */
    { 0x087f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/2/0/c */
    { 0x0900, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/2/1/u */
    { 0x097f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/2/1/c */
    { 0x0a00, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/2/2/u */
    { 0x0a7f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/2/2/c */
    { 0x0b00, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/2/3/u */
    { 0x0b7f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/2/3/c */
    { 0x0c00, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/3/0/u */
    { 0x0c7f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/3/0/c */
    { 0x0d00, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/3/1/u */
    { 0x0d7f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/3/1/c */
    { 0x0e00, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/3/2/u */
    { 0x0e7f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/3/2/c */
    { 0x0f00, 0x3191, 0xb981, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767) }, /* #23/3/3/u */
    { 0x0f7f, 0x3191, 0x3901, RTFLOAT80U_INIT_C(1,0x800000005eb05d37,32767), RTFLOAT80U_INIT_C(1,0xc00000005eb05d37,32767) }, /* #23/3/3/c */
    { 0x0000, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/0/u */
    { 0x007f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/0/c */
    { 0x0100, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/1/u */
    { 0x017f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/1/c */
    { 0x0200, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/2/u */
    { 0x027f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/2/c */
    { 0x0300, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/3/u */
    { 0x037f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/0/3/c */
    { 0x0400, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/0/u */
    { 0x047f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/0/c */
    { 0x0500, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/1/u */
    { 0x057f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/1/c */
    { 0x0600, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/2/u */
    { 0x067f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/2/c */
    { 0x0700, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/3/u */
    { 0x077f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/1/3/c */
    { 0x0800, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/0/u */
    { 0x087f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/0/c */
    { 0x0900, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/1/u */
    { 0x097f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/1/c */
    { 0x0a00, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/2/u */
    { 0x0a7f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/2/c */
    { 0x0b00, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/3/u */
    { 0x0b7f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/2/3/c */
    { 0x0c00, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/0/u */
    { 0x0c7f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/0/c */
    { 0x0d00, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/1/u */
    { 0x0d7f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/1/c */
    { 0x0e00, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/2/u */
    { 0x0e7f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/2/c */
    { 0x0f00, 0x2f33, 0xbda0, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/3/u */
    { 0x0f7f, 0x2f33, 0x3d20, RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873), RTFLOAT80U_INIT_C(1,0xe32be2142c1243f6,16873) }, /* #24/3/3/c */
    { 0x0000, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/0/u */
    { 0x007f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/0/c */
    { 0x0100, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/1/u */
    { 0x017f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/1/c */
    { 0x0200, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/2/u */
    { 0x027f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/2/c */
    { 0x0300, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/3/u */
    { 0x037f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/0/3/c */
    { 0x0400, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/0/u */
    { 0x047f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/0/c */
    { 0x0500, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/1/u */
    { 0x057f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/1/c */
    { 0x0600, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/2/u */
    { 0x067f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/2/c */
    { 0x0700, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/3/u */
    { 0x077f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/1/3/c */
    { 0x0800, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/0/u */
    { 0x087f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/0/c */
    { 0x0900, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/1/u */
    { 0x097f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/1/c */
    { 0x0a00, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/2/u */
    { 0x0a7f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/2/c */
    { 0x0b00, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/3/u */
    { 0x0b7f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/2/3/c */
    { 0x0c00, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/0/u */
    { 0x0c7f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/0/c */
    { 0x0d00, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/1/u */
    { 0x0d7f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/1/c */
    { 0x0e00, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/2/u */
    { 0x0e7f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/2/c */
    { 0x0f00, 0x6a30, 0xf8a0, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/3/u */
    { 0x0f7f, 0x6a30, 0x7820, RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694), RTFLOAT80U_INIT_C(1,0xeafc90a4058eef3d,29694) }, /* #25/3/3/c */
    { 0x0000, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/0/u */
    { 0x007f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/0/c */
    { 0x0100, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/1/u */
    { 0x017f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/1/c */
    { 0x0200, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/2/u */
    { 0x027f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/2/c */
    { 0x0300, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/3/u */
    { 0x037f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/0/3/c */
    { 0x0400, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/0/u */
    { 0x047f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/0/c */
    { 0x0500, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/1/u */
    { 0x057f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/1/c */
    { 0x0600, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/2/u */
    { 0x067f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/2/c */
    { 0x0700, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/3/u */
    { 0x077f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/1/3/c */
    { 0x0800, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/0/u */
    { 0x087f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/0/c */
    { 0x0900, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/1/u */
    { 0x097f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/1/c */
    { 0x0a00, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/2/u */
    { 0x0a7f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/2/c */
    { 0x0b00, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/3/u */
    { 0x0b7f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/2/3/c */
    { 0x0c00, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/0/u */
    { 0x0c7f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/0/c */
    { 0x0d00, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/1/u */
    { 0x0d7f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/1/c */
    { 0x0e00, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/2/u */
    { 0x0e7f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/2/c */
    { 0x0f00, 0xd3b2, 0xf9a0, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/3/u */
    { 0x0f7f, 0xd3b2, 0x7920, RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651), RTFLOAT80U_INIT_C(0,0xcd917e6a53c1a278,26651) }, /* #26/3/3/c */
    { 0x0000, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/0/u */
    { 0x007f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/0/c */
    { 0x0100, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/1/u */
    { 0x017f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/1/c */
    { 0x0200, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/2/u */
    { 0x027f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/2/c */
    { 0x0300, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/3/u */
    { 0x037f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/0/3/c */
    { 0x0400, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/0/u */
    { 0x047f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/0/c */
    { 0x0500, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/1/u */
    { 0x057f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/1/c */
    { 0x0600, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/2/u */
    { 0x067f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/2/c */
    { 0x0700, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/3/u */
    { 0x077f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/1/3/c */
    { 0x0800, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/0/u */
    { 0x087f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/0/c */
    { 0x0900, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/1/u */
    { 0x097f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/1/c */
    { 0x0a00, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/2/u */
    { 0x0a7f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/2/c */
    { 0x0b00, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/3/u */
    { 0x0b7f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/2/3/c */
    { 0x0c00, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/0/u */
    { 0x0c7f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/0/c */
    { 0x0d00, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/1/u */
    { 0x0d7f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/1/c */
    { 0x0e00, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/2/u */
    { 0x0e7f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/2/c */
    { 0x0f00, 0x5447, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/3/u */
    { 0x0f7f, 0x5447, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112), RTFLOAT80U_INIT_C(1,0xd0c5947a86c48822,24112) }, /* #27/3/3/c */
    { 0x0000, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/0/u */
    { 0x007f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/0/c */
    { 0x0100, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/1/u */
    { 0x017f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/1/c */
    { 0x0200, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/2/u */
    { 0x027f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/2/c */
    { 0x0300, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/3/u */
    { 0x037f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/0/3/c */
    { 0x0400, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/0/u */
    { 0x047f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/0/c */
    { 0x0500, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/1/u */
    { 0x057f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/1/c */
    { 0x0600, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/2/u */
    { 0x067f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/2/c */
    { 0x0700, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/3/u */
    { 0x077f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/1/3/c */
    { 0x0800, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/0/u */
    { 0x087f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/0/c */
    { 0x0900, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/1/u */
    { 0x097f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/1/c */
    { 0x0a00, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/2/u */
    { 0x0a7f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/2/c */
    { 0x0b00, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/3/u */
    { 0x0b7f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/2/3/c */
    { 0x0c00, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/0/u */
    { 0x0c7f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/0/c */
    { 0x0d00, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/1/u */
    { 0x0d7f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/1/c */
    { 0x0e00, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/2/u */
    { 0x0e7f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/2/c */
    { 0x0f00, 0xbe72, 0xbca0, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/3/u */
    { 0x0f7f, 0xbe72, 0x3c20, RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757), RTFLOAT80U_INIT_C(1,0xb15401b89dc21683,28757) }, /* #28/3/3/c */
    { 0x0000, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/0/0/u */
    { 0x007f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/0/c */
    { 0x0100, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/0/1/u */
    { 0x017f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/1/c */
    { 0x0200, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/0/2/u */
    { 0x027f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/2/c */
    { 0x0300, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/0/3/u */
    { 0x037f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/3/c */
    { 0x0400, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/1/0/u */
    { 0x047f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/0/c */
    { 0x0500, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/1/1/u */
    { 0x057f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/1/c */
    { 0x0600, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/1/2/u */
    { 0x067f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/2/c */
    { 0x0700, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/1/3/u */
    { 0x077f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/3/c */
    { 0x0800, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/2/0/u */
    { 0x087f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/0/c */
    { 0x0900, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/2/1/u */
    { 0x097f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/1/c */
    { 0x0a00, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/2/2/u */
    { 0x0a7f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/2/c */
    { 0x0b00, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/2/3/u */
    { 0x0b7f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/3/c */
    { 0x0c00, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/3/0/u */
    { 0x0c7f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/0/c */
    { 0x0d00, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/3/1/u */
    { 0x0d7f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/1/c */
    { 0x0e00, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/3/2/u */
    { 0x0e7f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/2/c */
    { 0x0f00, 0xb33b, 0xb981, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057) }, /* #29/3/3/u */
    { 0x0f7f, 0xb33b, 0x3901, RTFLOAT80U_INIT_C(1,0x8350c606863313a,6057), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/3/c */
    { 0x0000, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/0/u */
    { 0x007f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/0/c */
    { 0x0100, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/1/u */
    { 0x017f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/1/c */
    { 0x0200, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/2/u */
    { 0x027f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/2/c */
    { 0x0300, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/3/u */
    { 0x037f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/0/3/c */
    { 0x0400, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/0/u */
    { 0x047f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/0/c */
    { 0x0500, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/1/u */
    { 0x057f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/1/c */
    { 0x0600, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/2/u */
    { 0x067f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/2/c */
    { 0x0700, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/3/u */
    { 0x077f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/1/3/c */
    { 0x0800, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/0/u */
    { 0x087f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/0/c */
    { 0x0900, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/1/u */
    { 0x097f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/1/c */
    { 0x0a00, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/2/u */
    { 0x0a7f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/2/c */
    { 0x0b00, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/3/u */
    { 0x0b7f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/2/3/c */
    { 0x0c00, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/0/u */
    { 0x0c7f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/0/c */
    { 0x0d00, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/1/u */
    { 0x0d7f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/1/c */
    { 0x0e00, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/2/u */
    { 0x0e7f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/2/c */
    { 0x0f00, 0x10c6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/3/u */
    { 0x0f7f, 0x10c6, 0x3820, RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539), RTFLOAT80U_INIT_C(0,0xf00ae39c9ba12327,20539) }, /* #30/3/3/c */
    { 0x0000, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/0/u */
    { 0x007f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/0/c */
    { 0x0100, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/1/u */
    { 0x017f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/1/c */
    { 0x0200, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/2/u */
    { 0x027f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/2/c */
    { 0x0300, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/3/u */
    { 0x037f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/0/3/c */
    { 0x0400, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/0/u */
    { 0x047f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/0/c */
    { 0x0500, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/1/u */
    { 0x057f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/1/c */
    { 0x0600, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/2/u */
    { 0x067f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/2/c */
    { 0x0700, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/3/u */
    { 0x077f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/1/3/c */
    { 0x0800, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/0/u */
    { 0x087f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/0/c */
    { 0x0900, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/1/u */
    { 0x097f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/1/c */
    { 0x0a00, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/2/u */
    { 0x0a7f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/2/c */
    { 0x0b00, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/3/u */
    { 0x0b7f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/2/3/c */
    { 0x0c00, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/0/u */
    { 0x0c7f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/0/c */
    { 0x0d00, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/1/u */
    { 0x0d7f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/1/c */
    { 0x0e00, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/2/u */
    { 0x0e7f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/2/c */
    { 0x0f00, 0x973f, 0xbda0, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/3/u */
    { 0x0f7f, 0x973f, 0x3d20, RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633), RTFLOAT80U_INIT_C(1,0x8c850baeeac966ef,29633) }, /* #31/3/3/c */
    { 0x0000, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/0/0/u */
    { 0x007f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/0/c */
    { 0x0100, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/0/1/u */
    { 0x017f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/1/c */
    { 0x0200, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/0/2/u */
    { 0x027f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/2/c */
    { 0x0300, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/0/3/u */
    { 0x037f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/3/c */
    { 0x0400, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/1/0/u */
    { 0x047f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/0/c */
    { 0x0500, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/1/1/u */
    { 0x057f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/1/c */
    { 0x0600, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/1/2/u */
    { 0x067f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/2/c */
    { 0x0700, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/1/3/u */
    { 0x077f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/3/c */
    { 0x0800, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/2/0/u */
    { 0x087f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/0/c */
    { 0x0900, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/2/1/u */
    { 0x097f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/1/c */
    { 0x0a00, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/2/2/u */
    { 0x0a7f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/2/c */
    { 0x0b00, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/2/3/u */
    { 0x0b7f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/3/c */
    { 0x0c00, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/3/0/u */
    { 0x0c7f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/0/c */
    { 0x0d00, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/3/1/u */
    { 0x0d7f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/1/c */
    { 0x0e00, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/3/2/u */
    { 0x0e7f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/2/c */
    { 0x0f00, 0xf93b, 0xf981, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147) }, /* #32/3/3/u */
    { 0x0f7f, 0xf93b, 0x7901, RTFLOAT80U_INIT_C(1,0x72b87f8453fbb733,28147), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/3/c */
    { 0x0000, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/0/u */
    { 0x007f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/0/c */
    { 0x0100, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/1/u */
    { 0x017f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/1/c */
    { 0x0200, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/2/u */
    { 0x027f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/2/c */
    { 0x0300, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/3/u */
    { 0x037f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/0/3/c */
    { 0x0400, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/0/u */
    { 0x047f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/0/c */
    { 0x0500, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/1/u */
    { 0x057f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/1/c */
    { 0x0600, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/2/u */
    { 0x067f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/2/c */
    { 0x0700, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/3/u */
    { 0x077f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/1/3/c */
    { 0x0800, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/0/u */
    { 0x087f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/0/c */
    { 0x0900, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/1/u */
    { 0x097f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/1/c */
    { 0x0a00, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/2/u */
    { 0x0a7f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/2/c */
    { 0x0b00, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/3/u */
    { 0x0b7f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/2/3/c */
    { 0x0c00, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/0/u */
    { 0x0c7f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/0/c */
    { 0x0d00, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/1/u */
    { 0x0d7f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/1/c */
    { 0x0e00, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/2/u */
    { 0x0e7f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/2/c */
    { 0x0f00, 0xf7aa, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/3/u */
    { 0x0f7f, 0xf7aa, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030), RTFLOAT80U_INIT_C(0,0xbd6070955a3aafdf,26030) }, /* #33/3/3/c */
    { 0x0000, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/0/u */
    { 0x007f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/0/c */
    { 0x0100, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/1/u */
    { 0x017f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/1/c */
    { 0x0200, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/2/u */
    { 0x027f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/2/c */
    { 0x0300, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/3/u */
    { 0x037f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/0/3/c */
    { 0x0400, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/0/u */
    { 0x047f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/0/c */
    { 0x0500, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/1/u */
    { 0x057f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/1/c */
    { 0x0600, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/2/u */
    { 0x067f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/2/c */
    { 0x0700, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/3/u */
    { 0x077f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/1/3/c */
    { 0x0800, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/0/u */
    { 0x087f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/0/c */
    { 0x0900, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/1/u */
    { 0x097f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/1/c */
    { 0x0a00, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/2/u */
    { 0x0a7f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/2/c */
    { 0x0b00, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/3/u */
    { 0x0b7f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/2/3/c */
    { 0x0c00, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/0/u */
    { 0x0c7f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/0/c */
    { 0x0d00, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/1/u */
    { 0x0d7f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/1/c */
    { 0x0e00, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/2/u */
    { 0x0e7f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/2/c */
    { 0x0f00, 0x114f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/3/u */
    { 0x0f7f, 0x114f, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #34/3/3/c */
    { 0x0000, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/0/u */
    { 0x007f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/0/c */
    { 0x0100, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/1/u */
    { 0x017f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/1/c */
    { 0x0200, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/2/u */
    { 0x027f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/2/c */
    { 0x0300, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/3/u */
    { 0x037f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/0/3/c */
    { 0x0400, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/0/u */
    { 0x047f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/0/c */
    { 0x0500, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/1/u */
    { 0x057f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/1/c */
    { 0x0600, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/2/u */
    { 0x067f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/2/c */
    { 0x0700, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/3/u */
    { 0x077f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/1/3/c */
    { 0x0800, 0xaf52, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/0/u */
    { 0x087f, 0xaf52, 0x3f20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/0/c */
    { 0x0900, 0xaf52, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/1/u */
    { 0x097f, 0xaf52, 0x3f20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/1/c */
    { 0x0a00, 0xaf52, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/2/u */
    { 0x0a7f, 0xaf52, 0x3f20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/2/c */
    { 0x0b00, 0xaf52, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/3/u */
    { 0x0b7f, 0xaf52, 0x3f20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f83,4317) }, /* #35/2/3/c */
    { 0x0c00, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/0/u */
    { 0x0c7f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/0/c */
    { 0x0d00, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/1/u */
    { 0x0d7f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/1/c */
    { 0x0e00, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/2/u */
    { 0x0e7f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/2/c */
    { 0x0f00, 0xaf52, 0xbda0, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/3/u */
    { 0x0f7f, 0xaf52, 0x3d20, RTFLOAT80U_INIT_C(0,0xe3c989aecd7599e1,4317), RTFLOAT80U_INIT_C(0,0x9de3dd44c9687f82,4317) }, /* #35/3/3/c */
    { 0x0000, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/0/u */
    { 0x007f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/0/c */
    { 0x0100, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/1/u */
    { 0x017f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/1/c */
    { 0x0200, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/2/u */
    { 0x027f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/2/c */
    { 0x0300, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/3/u */
    { 0x037f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/3/c */
    { 0x0400, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/0/u */
    { 0x047f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/0/c */
    { 0x0500, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/1/u */
    { 0x057f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/1/c */
    { 0x0600, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/2/u */
    { 0x067f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/2/c */
    { 0x0700, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/3/u */
    { 0x077f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/1/3/c */
    { 0x0800, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/0/u */
    { 0x087f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/0/c */
    { 0x0900, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/1/u */
    { 0x097f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/1/c */
    { 0x0a00, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/2/u */
    { 0x0a7f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/2/c */
    { 0x0b00, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/3/u */
    { 0x0b7f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/3/c */
    { 0x0c00, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/0/u */
    { 0x0c7f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/0/c */
    { 0x0d00, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/1/u */
    { 0x0d7f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/1/c */
    { 0x0e00, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/2/u */
    { 0x0e7f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/2/c */
    { 0x0f00, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/3/u */
    { 0x0f7f, 0x5ac2, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/3/c */
    { 0x0000, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/0/u */
    { 0x007f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/0/c */
    { 0x0100, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/1/u */
    { 0x017f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/1/c */
    { 0x0200, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/2/u */
    { 0x027f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/2/c */
    { 0x0300, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/3/u */
    { 0x037f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/0/3/c */
    { 0x0400, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/0/u */
    { 0x047f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/0/c */
    { 0x0500, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/1/u */
    { 0x057f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/1/c */
    { 0x0600, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/2/u */
    { 0x067f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/2/c */
    { 0x0700, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/3/u */
    { 0x077f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/1/3/c */
    { 0x0800, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/0/u */
    { 0x087f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/0/c */
    { 0x0900, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/1/u */
    { 0x097f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/1/c */
    { 0x0a00, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/2/u */
    { 0x0a7f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/2/c */
    { 0x0b00, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/3/u */
    { 0x0b7f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/2/3/c */
    { 0x0c00, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/0/u */
    { 0x0c7f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/0/c */
    { 0x0d00, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/1/u */
    { 0x0d7f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/1/c */
    { 0x0e00, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/2/u */
    { 0x0e7f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/2/c */
    { 0x0f00, 0x6f8e, 0xfda0, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/3/u */
    { 0x0f7f, 0x6f8e, 0x7d20, RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385), RTFLOAT80U_INIT_C(0,0xbd0e25df5a168752,29385) }, /* #37/3/3/c */
    { 0x0000, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/0/0/u */
    { 0x007f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/0/c */
    { 0x0100, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/0/1/u */
    { 0x017f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/1/c */
    { 0x0200, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/0/2/u */
    { 0x027f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/2/c */
    { 0x0300, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/0/3/u */
    { 0x037f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/3/c */
    { 0x0400, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/1/0/u */
    { 0x047f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/0/c */
    { 0x0500, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/1/1/u */
    { 0x057f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/1/c */
    { 0x0600, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/1/2/u */
    { 0x067f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/2/c */
    { 0x0700, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/1/3/u */
    { 0x077f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/3/c */
    { 0x0800, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/2/0/u */
    { 0x087f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/0/c */
    { 0x0900, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/2/1/u */
    { 0x097f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/1/c */
    { 0x0a00, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/2/2/u */
    { 0x0a7f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/2/c */
    { 0x0b00, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/2/3/u */
    { 0x0b7f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/3/c */
    { 0x0c00, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/3/0/u */
    { 0x0c7f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/0/c */
    { 0x0d00, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/3/1/u */
    { 0x0d7f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/1/c */
    { 0x0e00, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/3/2/u */
    { 0x0e7f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/2/c */
    { 0x0f00, 0x4376, 0xf981, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767) }, /* #38/3/3/u */
    { 0x0f7f, 0x4376, 0x7901, RTFLOAT80U_INIT_C(1,0x53e5d986ba77df4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/3/c */
    { 0x0000, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/0/0/u */
    { 0x007f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/0/0/c */
    { 0x0100, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/0/1/u */
    { 0x017f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/0/1/c */
    { 0x0200, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/0/2/u */
    { 0x027f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/0/2/c */
    { 0x0300, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/0/3/u */
    { 0x037f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/0/3/c */
    { 0x0400, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/1/0/u */
    { 0x047f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/1/0/c */
    { 0x0500, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/1/1/u */
    { 0x057f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/1/1/c */
    { 0x0600, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/1/2/u */
    { 0x067f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/1/2/c */
    { 0x0700, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/1/3/u */
    { 0x077f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/1/3/c */
    { 0x0800, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/2/0/u */
    { 0x087f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/2/0/c */
    { 0x0900, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/2/1/u */
    { 0x097f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/2/1/c */
    { 0x0a00, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/2/2/u */
    { 0x0a7f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/2/2/c */
    { 0x0b00, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/2/3/u */
    { 0x0b7f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/2/3/c */
    { 0x0c00, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/3/0/u */
    { 0x0c7f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/3/0/c */
    { 0x0d00, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/3/1/u */
    { 0x0d7f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/3/1/c */
    { 0x0e00, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/3/2/u */
    { 0x0e7f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/3/2/c */
    { 0x0f00, 0xb4b2, 0xbc81, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113) }, /* #39/3/3/u */
    { 0x0f7f, 0xb4b2, 0x3c01, RTFLOAT80U_INIT_C(1,0x4c4d650e6e77161f,113), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #39/3/3/c */
    { 0x0000, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/0/0/u */
    { 0x007f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/0/c */
    { 0x0100, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/0/1/u */
    { 0x017f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/1/c */
    { 0x0200, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/0/2/u */
    { 0x027f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/2/c */
    { 0x0300, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/0/3/u */
    { 0x037f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/3/c */
    { 0x0400, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/1/0/u */
    { 0x047f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/0/c */
    { 0x0500, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/1/1/u */
    { 0x057f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/1/c */
    { 0x0600, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/1/2/u */
    { 0x067f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/2/c */
    { 0x0700, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/1/3/u */
    { 0x077f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/3/c */
    { 0x0800, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/2/0/u */
    { 0x087f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/0/c */
    { 0x0900, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/2/1/u */
    { 0x097f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/1/c */
    { 0x0a00, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/2/2/u */
    { 0x0a7f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/2/c */
    { 0x0b00, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/2/3/u */
    { 0x0b7f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/3/c */
    { 0x0c00, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/3/0/u */
    { 0x0c7f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/0/c */
    { 0x0d00, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/3/1/u */
    { 0x0d7f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/1/c */
    { 0x0e00, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/3/2/u */
    { 0x0e7f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/2/c */
    { 0x0f00, 0x1cf7, 0xbc81, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767) }, /* #40/3/3/u */
    { 0x0f7f, 0x1cf7, 0x3c01, RTFLOAT80U_INIT_C(1,0x6d8a75b228c6380f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/3/c */
    { 0x0000, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/0/u */
    { 0x007f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/0/c */
    { 0x0100, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/1/u */
    { 0x017f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/1/c */
    { 0x0200, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/2/u */
    { 0x027f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/2/c */
    { 0x0300, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/3/u */
    { 0x037f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/0/3/c */
    { 0x0400, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/0/u */
    { 0x047f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/0/c */
    { 0x0500, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/1/u */
    { 0x057f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/1/c */
    { 0x0600, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/2/u */
    { 0x067f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/2/c */
    { 0x0700, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/3/u */
    { 0x077f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/1/3/c */
    { 0x0800, 0xe921, 0xfba0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/0/u */
    { 0x087f, 0xe921, 0x7b20, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/0/c */
    { 0x0900, 0xe921, 0xfba0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/1/u */
    { 0x097f, 0xe921, 0x7b20, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/1/c */
    { 0x0a00, 0xe921, 0xfba0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/2/u */
    { 0x0a7f, 0xe921, 0x7b20, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/2/c */
    { 0x0b00, 0xe921, 0xfba0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/3/u */
    { 0x0b7f, 0xe921, 0x7b20, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c29a,4595) }, /* #41/2/3/c */
    { 0x0c00, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/0/u */
    { 0x0c7f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/0/c */
    { 0x0d00, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/1/u */
    { 0x0d7f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/1/c */
    { 0x0e00, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/2/u */
    { 0x0e7f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/2/c */
    { 0x0f00, 0xe921, 0xf9a0, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/3/u */
    { 0x0f7f, 0xe921, 0x7920, RTFLOAT80U_INIT_C(0,0xf7bd495b8e8dae87,4595), RTFLOAT80U_INIT_C(0,0xabb84934cc98c299,4595) }, /* #41/3/3/c */
    { 0x0000, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/0/u */
    { 0x007f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/0/c */
    { 0x0100, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/1/u */
    { 0x017f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/1/c */
    { 0x0200, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/2/u */
    { 0x027f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/2/c */
    { 0x0300, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/3/u */
    { 0x037f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/0/3/c */
    { 0x0400, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/0/u */
    { 0x047f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/0/c */
    { 0x0500, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/1/u */
    { 0x057f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/1/c */
    { 0x0600, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/2/u */
    { 0x067f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/2/c */
    { 0x0700, 0xe2f7, 0xfaa0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/3/u */
    { 0x077f, 0xe2f7, 0x7a20, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1ea,10704) }, /* #42/1/3/c */
    { 0x0800, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/0/u */
    { 0x087f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/0/c */
    { 0x0900, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/1/u */
    { 0x097f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/1/c */
    { 0x0a00, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/2/u */
    { 0x0a7f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/2/c */
    { 0x0b00, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/3/u */
    { 0x0b7f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/2/3/c */
    { 0x0c00, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/0/u */
    { 0x0c7f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/0/c */
    { 0x0d00, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/1/u */
    { 0x0d7f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/1/c */
    { 0x0e00, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/2/u */
    { 0x0e7f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/2/c */
    { 0x0f00, 0xe2f7, 0xf8a0, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/3/u */
    { 0x0f7f, 0xe2f7, 0x7820, RTFLOAT80U_INIT_C(1,0xb4af3148b1ac828d,10705), RTFLOAT80U_INIT_C(1,0xfa7b5003b785e1e9,10704) }, /* #42/3/3/c */
    { 0x0000, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/0/u */
    { 0x007f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/0/c */
    { 0x0100, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/1/u */
    { 0x017f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/1/c */
    { 0x0200, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/2/u */
    { 0x027f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/2/c */
    { 0x0300, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/3/u */
    { 0x037f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/0/3/c */
    { 0x0400, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/0/u */
    { 0x047f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/0/c */
    { 0x0500, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/1/u */
    { 0x057f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/1/c */
    { 0x0600, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/2/u */
    { 0x067f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/2/c */
    { 0x0700, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/3/u */
    { 0x077f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/1/3/c */
    { 0x0800, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/0/u */
    { 0x087f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/0/c */
    { 0x0900, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/1/u */
    { 0x097f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/1/c */
    { 0x0a00, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/2/u */
    { 0x0a7f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/2/c */
    { 0x0b00, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/3/u */
    { 0x0b7f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/2/3/c */
    { 0x0c00, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/0/u */
    { 0x0c7f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/0/c */
    { 0x0d00, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/1/u */
    { 0x0d7f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/1/c */
    { 0x0e00, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/2/u */
    { 0x0e7f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/2/c */
    { 0x0f00, 0x56dc, 0xfca0, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/3/u */
    { 0x0f7f, 0x56dc, 0x7c20, RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486), RTFLOAT80U_INIT_C(1,0xba1262ae0a23e318,19486) }, /* #43/3/3/c */
    { 0x0000, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/0/u */
    { 0x007f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/0/c */
    { 0x0100, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/1/u */
    { 0x017f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/1/c */
    { 0x0200, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/2/u */
    { 0x027f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/2/c */
    { 0x0300, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/3/u */
    { 0x037f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/0/3/c */
    { 0x0400, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/0/u */
    { 0x047f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/0/c */
    { 0x0500, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/1/u */
    { 0x057f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/1/c */
    { 0x0600, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/2/u */
    { 0x067f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/2/c */
    { 0x0700, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/3/u */
    { 0x077f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/1/3/c */
    { 0x0800, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/0/u */
    { 0x087f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/0/c */
    { 0x0900, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/1/u */
    { 0x097f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/1/c */
    { 0x0a00, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/2/u */
    { 0x0a7f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/2/c */
    { 0x0b00, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/3/u */
    { 0x0b7f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/2/3/c */
    { 0x0c00, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/0/u */
    { 0x0c7f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/0/c */
    { 0x0d00, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/1/u */
    { 0x0d7f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/1/c */
    { 0x0e00, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/2/u */
    { 0x0e7f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/2/c */
    { 0x0f00, 0xe9bd, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/3/u */
    { 0x0f7f, 0xe9bd, 0x7920, RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770), RTFLOAT80U_INIT_C(1,0xb933d3087e37acd4,28770) }, /* #44/3/3/c */
    { 0x0000, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/0/0/u */
    { 0x007f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/0/0/c */
    { 0x0100, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/0/1/u */
    { 0x017f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/0/1/c */
    { 0x0200, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/0/2/u */
    { 0x027f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/0/2/c */
    { 0x0300, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/0/3/u */
    { 0x037f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/0/3/c */
    { 0x0400, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/1/0/u */
    { 0x047f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/1/0/c */
    { 0x0500, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/1/1/u */
    { 0x057f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/1/1/c */
    { 0x0600, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/1/2/u */
    { 0x067f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/1/2/c */
    { 0x0700, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/1/3/u */
    { 0x077f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/1/3/c */
    { 0x0800, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/2/0/u */
    { 0x087f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/2/0/c */
    { 0x0900, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/2/1/u */
    { 0x097f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/2/1/c */
    { 0x0a00, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/2/2/u */
    { 0x0a7f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/2/2/c */
    { 0x0b00, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/2/3/u */
    { 0x0b7f, 0x1613, 0x3e32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd84,0) }, /* #45/2/3/c */
    { 0x0c00, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/3/0/u */
    { 0x0c7f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/3/0/c */
    { 0x0d00, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/3/1/u */
    { 0x0d7f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/3/1/c */
    { 0x0e00, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/3/2/u */
    { 0x0e7f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/3/2/c */
    { 0x0f00, 0x1613, 0xbc82, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x80000000000000fb,0) }, /* #45/3/3/u */
    { 0x0f7f, 0x1613, 0x3c32, RTFLOAT80U_INIT_C(0,0x80000000000000fb,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bd83,0) }, /* #45/3/3/c */
    { 0x0000, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/0/u */
    { 0x007f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/0/c */
    { 0x0100, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/1/u */
    { 0x017f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/1/c */
    { 0x0200, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/2/u */
    { 0x027f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/2/c */
    { 0x0300, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/3/u */
    { 0x037f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/0/3/c */
    { 0x0400, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/0/u */
    { 0x047f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/0/c */
    { 0x0500, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/1/u */
    { 0x057f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/1/c */
    { 0x0600, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/2/u */
    { 0x067f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/2/c */
    { 0x0700, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/3/u */
    { 0x077f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/1/3/c */
    { 0x0800, 0xb106, 0xbba0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/0/u */
    { 0x087f, 0xb106, 0x3b20, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/0/c */
    { 0x0900, 0xb106, 0xbba0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/1/u */
    { 0x097f, 0xb106, 0x3b20, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/1/c */
    { 0x0a00, 0xb106, 0xbba0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/2/u */
    { 0x0a7f, 0xb106, 0x3b20, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/2/c */
    { 0x0b00, 0xb106, 0xbba0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/3/u */
    { 0x0b7f, 0xb106, 0x3b20, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f6,1113) }, /* #46/2/3/c */
    { 0x0c00, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/0/u */
    { 0x0c7f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/0/c */
    { 0x0d00, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/1/u */
    { 0x0d7f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/1/c */
    { 0x0e00, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/2/u */
    { 0x0e7f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/2/c */
    { 0x0f00, 0xb106, 0xb9a0, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/3/u */
    { 0x0f7f, 0xb106, 0x3920, RTFLOAT80U_INIT_C(0,0xaa7f4dcd553d48ef,1114), RTFLOAT80U_INIT_C(0,0xec5c02e433d9e9f5,1113) }, /* #46/3/3/c */
    { 0x0000, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/0/u */
    { 0x007f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/0/c */
    { 0x0100, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/1/u */
    { 0x017f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/1/c */
    { 0x0200, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/2/u */
    { 0x027f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/2/c */
    { 0x0300, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/3/u */
    { 0x037f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/0/3/c */
    { 0x0400, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/0/u */
    { 0x047f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/0/c */
    { 0x0500, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/1/u */
    { 0x057f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/1/c */
    { 0x0600, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/2/u */
    { 0x067f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/2/c */
    { 0x0700, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/3/u */
    { 0x077f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/1/3/c */
    { 0x0800, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/0/u */
    { 0x087f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/0/c */
    { 0x0900, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/1/u */
    { 0x097f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/1/c */
    { 0x0a00, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/2/u */
    { 0x0a7f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/2/c */
    { 0x0b00, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/3/u */
    { 0x0b7f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/2/3/c */
    { 0x0c00, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/0/u */
    { 0x0c7f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/0/c */
    { 0x0d00, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/1/u */
    { 0x0d7f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/1/c */
    { 0x0e00, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/2/u */
    { 0x0e7f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/2/c */
    { 0x0f00, 0x6bae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/3/u */
    { 0x0f7f, 0x6bae, 0x7920, RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295), RTFLOAT80U_INIT_C(1,0xf1d4e72ba63d0bd9,29295) }, /* #47/3/3/c */
    { 0x0000, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/0/0/u */
    { 0x007f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/0/c */
    { 0x0100, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/0/1/u */
    { 0x017f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/1/c */
    { 0x0200, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/0/2/u */
    { 0x027f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/2/c */
    { 0x0300, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/0/3/u */
    { 0x037f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/3/c */
    { 0x0400, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/1/0/u */
    { 0x047f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/0/c */
    { 0x0500, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/1/1/u */
    { 0x057f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/1/c */
    { 0x0600, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/1/2/u */
    { 0x067f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/2/c */
    { 0x0700, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/1/3/u */
    { 0x077f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/3/c */
    { 0x0800, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/2/0/u */
    { 0x087f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/0/c */
    { 0x0900, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/2/1/u */
    { 0x097f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/1/c */
    { 0x0a00, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/2/2/u */
    { 0x0a7f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/2/c */
    { 0x0b00, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/2/3/u */
    { 0x0b7f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/3/c */
    { 0x0c00, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/3/0/u */
    { 0x0c7f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/0/c */
    { 0x0d00, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/3/1/u */
    { 0x0d7f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/1/c */
    { 0x0e00, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/3/2/u */
    { 0x0e7f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/2/c */
    { 0x0f00, 0x6252, 0xf881, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767) }, /* #48/3/3/u */
    { 0x0f7f, 0x6252, 0x7801, RTFLOAT80U_INIT_C(1,0x400000005e1da4ee,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/3/c */
    { 0x0000, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/0/0/u */
    { 0x007f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/0/0/c */
    { 0x0100, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/0/1/u */
    { 0x017f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/0/1/c */
    { 0x0200, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/0/2/u */
    { 0x027f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/0/2/c */
    { 0x0300, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/0/3/u */
    { 0x037f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/0/3/c */
    { 0x0400, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/1/0/u */
    { 0x047f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/1/0/c */
    { 0x0500, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/1/1/u */
    { 0x057f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/1/1/c */
    { 0x0600, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/1/2/u */
    { 0x067f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/1/2/c */
    { 0x0700, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/1/3/u */
    { 0x077f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/1/3/c */
    { 0x0800, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/2/0/u */
    { 0x087f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/2/0/c */
    { 0x0900, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/2/1/u */
    { 0x097f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/2/1/c */
    { 0x0a00, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/2/2/u */
    { 0x0a7f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/2/2/c */
    { 0x0b00, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/2/3/u */
    { 0x0b7f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/2/3/c */
    { 0x0c00, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/3/0/u */
    { 0x0c7f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/3/0/c */
    { 0x0d00, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/3/1/u */
    { 0x0d7f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/3/1/c */
    { 0x0e00, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/3/2/u */
    { 0x0e7f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/3/2/c */
    { 0x0f00, 0x3e08, 0xbc81, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767) }, /* #49/3/3/u */
    { 0x0f7f, 0x3e08, 0x3c01, RTFLOAT80U_INIT_C(0,0x8002ff2c3115de98,32767), RTFLOAT80U_INIT_C(0,0xc002ff2c3115de98,32767) }, /* #49/3/3/c */
    { 0x0000, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/0/0/u */
    { 0x007f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/0/c */
    { 0x0100, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/0/1/u */
    { 0x017f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/1/c */
    { 0x0200, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/0/2/u */
    { 0x027f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/2/c */
    { 0x0300, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/0/3/u */
    { 0x037f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/3/c */
    { 0x0400, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/1/0/u */
    { 0x047f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/0/c */
    { 0x0500, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/1/1/u */
    { 0x057f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/1/c */
    { 0x0600, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/1/2/u */
    { 0x067f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/2/c */
    { 0x0700, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/1/3/u */
    { 0x077f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/3/c */
    { 0x0800, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/2/0/u */
    { 0x087f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/0/c */
    { 0x0900, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/2/1/u */
    { 0x097f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/1/c */
    { 0x0a00, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/2/2/u */
    { 0x0a7f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/2/c */
    { 0x0b00, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/2/3/u */
    { 0x0b7f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/3/c */
    { 0x0c00, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/3/0/u */
    { 0x0c7f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/0/c */
    { 0x0d00, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/3/1/u */
    { 0x0d7f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/1/c */
    { 0x0e00, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/3/2/u */
    { 0x0e7f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/2/c */
    { 0x0f00, 0x243b, 0xbc81, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941) }, /* #50/3/3/u */
    { 0x0f7f, 0x243b, 0x3c01, RTFLOAT80U_INIT_C(1,0x515516926d0999df,29941), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/3/c */
    { 0x0000, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/0/u */
    { 0x007f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/0/c */
    { 0x0100, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/1/u */
    { 0x017f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/1/c */
    { 0x0200, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/2/u */
    { 0x027f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/2/c */
    { 0x0300, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/3/u */
    { 0x037f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/0/3/c */
    { 0x0400, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/0/u */
    { 0x047f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/0/c */
    { 0x0500, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/1/u */
    { 0x057f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/1/c */
    { 0x0600, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/2/u */
    { 0x067f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/2/c */
    { 0x0700, 0x64a6, 0xfea0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/3/u */
    { 0x077f, 0x64a6, 0x7e20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb74,3157) }, /* #51/1/3/c */
    { 0x0800, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/0/u */
    { 0x087f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/0/c */
    { 0x0900, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/1/u */
    { 0x097f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/1/c */
    { 0x0a00, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/2/u */
    { 0x0a7f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/2/c */
    { 0x0b00, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/3/u */
    { 0x0b7f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/2/3/c */
    { 0x0c00, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/0/u */
    { 0x0c7f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/0/c */
    { 0x0d00, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/1/u */
    { 0x0d7f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/1/c */
    { 0x0e00, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/2/u */
    { 0x0e7f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/2/c */
    { 0x0f00, 0x64a6, 0xfca0, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/3/u */
    { 0x0f7f, 0x64a6, 0x7c20, RTFLOAT80U_INIT_C(1,0xd0ecee01259e9f4e,3157), RTFLOAT80U_INIT_C(1,0x90d0eda050bbeb73,3157) }, /* #51/3/3/c */
    { 0x0000, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/0/u */
    { 0x007f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/0/c */
    { 0x0100, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/1/u */
    { 0x017f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/1/c */
    { 0x0200, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/2/u */
    { 0x027f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/2/c */
    { 0x0300, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/3/u */
    { 0x037f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/0/3/c */
    { 0x0400, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/0/u */
    { 0x047f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/0/c */
    { 0x0500, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/1/u */
    { 0x057f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/1/c */
    { 0x0600, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/2/u */
    { 0x067f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/2/c */
    { 0x0700, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/3/u */
    { 0x077f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/1/3/c */
    { 0x0800, 0x8fb4, 0xbfa0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/0/u */
    { 0x087f, 0x8fb4, 0x3f20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/0/c */
    { 0x0900, 0x8fb4, 0xbfa0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/1/u */
    { 0x097f, 0x8fb4, 0x3f20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/1/c */
    { 0x0a00, 0x8fb4, 0xbfa0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/2/u */
    { 0x0a7f, 0x8fb4, 0x3f20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/2/c */
    { 0x0b00, 0x8fb4, 0xbfa0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/3/u */
    { 0x0b7f, 0x8fb4, 0x3f20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474b,13859) }, /* #52/2/3/c */
    { 0x0c00, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/0/u */
    { 0x0c7f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/0/c */
    { 0x0d00, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/1/u */
    { 0x0d7f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/1/c */
    { 0x0e00, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/2/u */
    { 0x0e7f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/2/c */
    { 0x0f00, 0x8fb4, 0xbda0, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/3/u */
    { 0x0f7f, 0x8fb4, 0x3d20, RTFLOAT80U_INIT_C(0,0xaf8186e1d1a904e9,13860), RTFLOAT80U_INIT_C(0,0xf34d8cbd76e7474a,13859) }, /* #52/3/3/c */
    { 0x0000, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/0/u */
    { 0x007f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/0/c */
    { 0x0100, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/1/u */
    { 0x017f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/1/c */
    { 0x0200, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/2/u */
    { 0x027f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/2/c */
    { 0x0300, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/3/u */
    { 0x037f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/0/3/c */
    { 0x0400, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/0/u */
    { 0x047f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/0/c */
    { 0x0500, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/1/u */
    { 0x057f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/1/c */
    { 0x0600, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/2/u */
    { 0x067f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/2/c */
    { 0x0700, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/3/u */
    { 0x077f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/1/3/c */
    { 0x0800, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/0/u */
    { 0x087f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/0/c */
    { 0x0900, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/1/u */
    { 0x097f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/1/c */
    { 0x0a00, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/2/u */
    { 0x0a7f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/2/c */
    { 0x0b00, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/3/u */
    { 0x0b7f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/2/3/c */
    { 0x0c00, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/0/u */
    { 0x0c7f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/0/c */
    { 0x0d00, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/1/u */
    { 0x0d7f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/1/c */
    { 0x0e00, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/2/u */
    { 0x0e7f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/2/c */
    { 0x0f00, 0xa61f, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/3/u */
    { 0x0f7f, 0xa61f, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #53/3/3/c */
    { 0x0000, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/0/0/u */
    { 0x007f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/0/0/c */
    { 0x0100, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/0/1/u */
    { 0x017f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/0/1/c */
    { 0x0200, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/0/2/u */
    { 0x027f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/0/2/c */
    { 0x0300, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/0/3/u */
    { 0x037f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/0/3/c */
    { 0x0400, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/1/0/u */
    { 0x047f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/1/0/c */
    { 0x0500, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/1/1/u */
    { 0x057f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/1/1/c */
    { 0x0600, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/1/2/u */
    { 0x067f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/1/2/c */
    { 0x0700, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/1/3/u */
    { 0x077f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/1/3/c */
    { 0x0800, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/2/0/u */
    { 0x087f, 0x6abd, 0x7a32, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d8,0) }, /* #54/2/0/c */
    { 0x0900, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/2/1/u */
    { 0x097f, 0x6abd, 0x7a32, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d8,0) }, /* #54/2/1/c */
    { 0x0a00, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/2/2/u */
    { 0x0a7f, 0x6abd, 0x7a32, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d8,0) }, /* #54/2/2/c */
    { 0x0b00, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/2/3/u */
    { 0x0b7f, 0x6abd, 0x7a32, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d8,0) }, /* #54/2/3/c */
    { 0x0c00, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/3/0/u */
    { 0x0c7f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/3/0/c */
    { 0x0d00, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/3/1/u */
    { 0x0d7f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/3/1/c */
    { 0x0e00, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/3/2/u */
    { 0x0e7f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/3/2/c */
    { 0x0f00, 0x6abd, 0xf882, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0) }, /* #54/3/3/u */
    { 0x0f7f, 0x6abd, 0x7832, RTFLOAT80U_INIT_C(0,0x8678863bc91476a2,0), RTFLOAT80U_INIT_C(0,0x5d3543121d34f4d7,0) }, /* #54/3/3/c */
    { 0x0000, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/0/0/u */
    { 0x007f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/0/c */
    { 0x0100, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/0/1/u */
    { 0x017f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/1/c */
    { 0x0200, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/0/2/u */
    { 0x027f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/2/c */
    { 0x0300, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/0/3/u */
    { 0x037f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/3/c */
    { 0x0400, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/1/0/u */
    { 0x047f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/0/c */
    { 0x0500, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/1/1/u */
    { 0x057f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/1/c */
    { 0x0600, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/1/2/u */
    { 0x067f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/2/c */
    { 0x0700, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/1/3/u */
    { 0x077f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/3/c */
    { 0x0800, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/2/0/u */
    { 0x087f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/0/c */
    { 0x0900, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/2/1/u */
    { 0x097f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/1/c */
    { 0x0a00, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/2/2/u */
    { 0x0a7f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/2/c */
    { 0x0b00, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/2/3/u */
    { 0x0b7f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/3/c */
    { 0x0c00, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/3/0/u */
    { 0x0c7f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/0/c */
    { 0x0d00, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/3/1/u */
    { 0x0d7f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/1/c */
    { 0x0e00, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/3/2/u */
    { 0x0e7f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/2/c */
    { 0x0f00, 0x54ac, 0xfc81, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114) }, /* #55/3/3/u */
    { 0x0f7f, 0x54ac, 0x7c01, RTFLOAT80U_INIT_C(0,0x448f640c90b2b518,30114), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/3/c */
    { 0x0000, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/0/u */
    { 0x007f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/0/c */
    { 0x0100, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/1/u */
    { 0x017f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/1/c */
    { 0x0200, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/2/u */
    { 0x027f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/2/c */
    { 0x0300, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/3/u */
    { 0x037f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/0/3/c */
    { 0x0400, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/0/u */
    { 0x047f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/0/c */
    { 0x0500, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/1/u */
    { 0x057f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/1/c */
    { 0x0600, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/2/u */
    { 0x067f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/2/c */
    { 0x0700, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/3/u */
    { 0x077f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/1/3/c */
    { 0x0800, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/0/u */
    { 0x087f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/0/c */
    { 0x0900, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/1/u */
    { 0x097f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/1/c */
    { 0x0a00, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/2/u */
    { 0x0a7f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/2/c */
    { 0x0b00, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/3/u */
    { 0x0b7f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/2/3/c */
    { 0x0c00, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/0/u */
    { 0x0c7f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/0/c */
    { 0x0d00, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/1/u */
    { 0x0d7f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/1/c */
    { 0x0e00, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/2/u */
    { 0x0e7f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/2/c */
    { 0x0f00, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/3/u */
    { 0x0f7f, 0x3981, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #56/3/3/c */
    { 0x0000, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/0/u */
    { 0x007f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/0/c */
    { 0x0100, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/1/u */
    { 0x017f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/1/c */
    { 0x0200, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/2/u */
    { 0x027f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/2/c */
    { 0x0300, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/3/u */
    { 0x037f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/0/3/c */
    { 0x0400, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/0/u */
    { 0x047f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/0/c */
    { 0x0500, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/1/u */
    { 0x057f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/1/c */
    { 0x0600, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/2/u */
    { 0x067f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/2/c */
    { 0x0700, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/3/u */
    { 0x077f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/1/3/c */
    { 0x0800, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/0/u */
    { 0x087f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/0/c */
    { 0x0900, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/1/u */
    { 0x097f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/1/c */
    { 0x0a00, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/2/u */
    { 0x0a7f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/2/c */
    { 0x0b00, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/3/u */
    { 0x0b7f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/2/3/c */
    { 0x0c00, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/0/u */
    { 0x0c7f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/0/c */
    { 0x0d00, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/1/u */
    { 0x0d7f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/1/c */
    { 0x0e00, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/2/u */
    { 0x0e7f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/2/c */
    { 0x0f00, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/3/u */
    { 0x0f7f, 0x2772, 0x3d00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #57/3/3/c */
    { 0x0000, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/0/u */
    { 0x007f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/0/c */
    { 0x0100, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/1/u */
    { 0x017f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/1/c */
    { 0x0200, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/2/u */
    { 0x027f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/2/c */
    { 0x0300, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/3/u */
    { 0x037f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/0/3/c */
    { 0x0400, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/0/u */
    { 0x047f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/0/c */
    { 0x0500, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/1/u */
    { 0x057f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/1/c */
    { 0x0600, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/2/u */
    { 0x067f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/2/c */
    { 0x0700, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/3/u */
    { 0x077f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/1/3/c */
    { 0x0800, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/0/u */
    { 0x087f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/0/c */
    { 0x0900, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/1/u */
    { 0x097f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/1/c */
    { 0x0a00, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/2/u */
    { 0x0a7f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/2/c */
    { 0x0b00, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/3/u */
    { 0x0b7f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/2/3/c */
    { 0x0c00, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/0/u */
    { 0x0c7f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/0/c */
    { 0x0d00, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/1/u */
    { 0x0d7f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/1/c */
    { 0x0e00, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/2/u */
    { 0x0e7f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/2/c */
    { 0x0f00, 0x2efc, 0xbca0, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/3/u */
    { 0x0f7f, 0x2efc, 0x3c20, RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400), RTFLOAT80U_INIT_C(0,0xa8fc23ad71c5ad6a,18400) }, /* #58/3/3/c */
    { 0x0000, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/0/0/u */
    { 0x007f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/0/c */
    { 0x0100, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/0/1/u */
    { 0x017f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/1/c */
    { 0x0200, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/0/2/u */
    { 0x027f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/2/c */
    { 0x0300, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/0/3/u */
    { 0x037f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/3/c */
    { 0x0400, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/1/0/u */
    { 0x047f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/0/c */
    { 0x0500, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/1/1/u */
    { 0x057f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/1/c */
    { 0x0600, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/1/2/u */
    { 0x067f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/2/c */
    { 0x0700, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/1/3/u */
    { 0x077f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/3/c */
    { 0x0800, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/2/0/u */
    { 0x087f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/0/c */
    { 0x0900, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/2/1/u */
    { 0x097f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/1/c */
    { 0x0a00, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/2/2/u */
    { 0x0a7f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/2/c */
    { 0x0b00, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/2/3/u */
    { 0x0b7f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/3/c */
    { 0x0c00, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/3/0/u */
    { 0x0c7f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/0/c */
    { 0x0d00, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/3/1/u */
    { 0x0d7f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/1/c */
    { 0x0e00, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/3/2/u */
    { 0x0e7f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/2/c */
    { 0x0f00, 0x5ca2, 0xfc81, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767) }, /* #59/3/3/u */
    { 0x0f7f, 0x5ca2, 0x7c01, RTFLOAT80U_INIT_C(1,0x400019922b56adf6,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/3/c */
    { 0x0000, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/0/u */
    { 0x007f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/0/c */
    { 0x0100, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/1/u */
    { 0x017f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/1/c */
    { 0x0200, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/2/u */
    { 0x027f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/2/c */
    { 0x0300, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/3/u */
    { 0x037f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/0/3/c */
    { 0x0400, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/0/u */
    { 0x047f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/0/c */
    { 0x0500, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/1/u */
    { 0x057f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/1/c */
    { 0x0600, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/2/u */
    { 0x067f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/2/c */
    { 0x0700, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/3/u */
    { 0x077f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/1/3/c */
    { 0x0800, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/0/u */
    { 0x087f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/0/c */
    { 0x0900, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/1/u */
    { 0x097f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/1/c */
    { 0x0a00, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/2/u */
    { 0x0a7f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/2/c */
    { 0x0b00, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/3/u */
    { 0x0b7f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/2/3/c */
    { 0x0c00, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/0/u */
    { 0x0c7f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/0/c */
    { 0x0d00, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/1/u */
    { 0x0d7f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/1/c */
    { 0x0e00, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/2/u */
    { 0x0e7f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/2/c */
    { 0x0f00, 0xc02b, 0xf8a0, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/3/u */
    { 0x0f7f, 0xc02b, 0x7820, RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249), RTFLOAT80U_INIT_C(0,0xab2a2e6a0879a892,18249) }, /* #60/3/3/c */
    { 0x0000, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/0/u */
    { 0x007f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/0/c */
    { 0x0100, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/1/u */
    { 0x017f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/1/c */
    { 0x0200, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/2/u */
    { 0x027f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/2/c */
    { 0x0300, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/3/u */
    { 0x037f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/0/3/c */
    { 0x0400, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/0/u */
    { 0x047f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/0/c */
    { 0x0500, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/1/u */
    { 0x057f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/1/c */
    { 0x0600, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/2/u */
    { 0x067f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/2/c */
    { 0x0700, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/3/u */
    { 0x077f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/1/3/c */
    { 0x0800, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/0/u */
    { 0x087f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/0/c */
    { 0x0900, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/1/u */
    { 0x097f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/1/c */
    { 0x0a00, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/2/u */
    { 0x0a7f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/2/c */
    { 0x0b00, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/3/u */
    { 0x0b7f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/2/3/c */
    { 0x0c00, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/0/u */
    { 0x0c7f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/0/c */
    { 0x0d00, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/1/u */
    { 0x0d7f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/1/c */
    { 0x0e00, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/2/u */
    { 0x0e7f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/2/c */
    { 0x0f00, 0x2487, 0xbca0, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/3/u */
    { 0x0f7f, 0x2487, 0x3c20, RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334), RTFLOAT80U_INIT_C(1,0xdc6a10b8f3e28484,20334) }, /* #61/3/3/c */
    { 0x0000, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/0/0/u */
    { 0x007f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/0/0/c */
    { 0x0100, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/0/1/u */
    { 0x017f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/0/1/c */
    { 0x0200, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/0/2/u */
    { 0x027f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/0/2/c */
    { 0x0300, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/0/3/u */
    { 0x037f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/0/3/c */
    { 0x0400, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/1/0/u */
    { 0x047f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/1/0/c */
    { 0x0500, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/1/1/u */
    { 0x057f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/1/1/c */
    { 0x0600, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/1/2/u */
    { 0x067f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/1/2/c */
    { 0x0700, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/1/3/u */
    { 0x077f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/1/3/c */
    { 0x0800, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/2/0/u */
    { 0x087f, 0xede4, 0x7f32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ac,0) }, /* #62/2/0/c */
    { 0x0900, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/2/1/u */
    { 0x097f, 0xede4, 0x7f32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ac,0) }, /* #62/2/1/c */
    { 0x0a00, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/2/2/u */
    { 0x0a7f, 0xede4, 0x7f32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ac,0) }, /* #62/2/2/c */
    { 0x0b00, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/2/3/u */
    { 0x0b7f, 0xede4, 0x7f32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ac,0) }, /* #62/2/3/c */
    { 0x0c00, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/3/0/u */
    { 0x0c7f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/3/0/c */
    { 0x0d00, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/3/1/u */
    { 0x0d7f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/3/1/c */
    { 0x0e00, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/3/2/u */
    { 0x0e7f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/3/2/c */
    { 0x0f00, 0xede4, 0xfd82, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0) }, /* #62/3/3/u */
    { 0x0f7f, 0xede4, 0x7d32, RTFLOAT80U_INIT_C(0,0x1da5e6560444436a,0), RTFLOAT80U_INIT_C(0,0x148ceae8a65088ab,0) }, /* #62/3/3/c */
    { 0x0000, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/0/0/u */
    { 0x007f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/0/c */
    { 0x0100, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/0/1/u */
    { 0x017f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/1/c */
    { 0x0200, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/0/2/u */
    { 0x027f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/2/c */
    { 0x0300, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/0/3/u */
    { 0x037f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/3/c */
    { 0x0400, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/1/0/u */
    { 0x047f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/0/c */
    { 0x0500, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/1/1/u */
    { 0x057f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/1/c */
    { 0x0600, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/1/2/u */
    { 0x067f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/2/c */
    { 0x0700, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/1/3/u */
    { 0x077f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/3/c */
    { 0x0800, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/2/0/u */
    { 0x087f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/0/c */
    { 0x0900, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/2/1/u */
    { 0x097f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/1/c */
    { 0x0a00, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/2/2/u */
    { 0x0a7f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/2/c */
    { 0x0b00, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/2/3/u */
    { 0x0b7f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/3/c */
    { 0x0c00, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/3/0/u */
    { 0x0c7f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/0/c */
    { 0x0d00, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/3/1/u */
    { 0x0d7f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/1/c */
    { 0x0e00, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/3/2/u */
    { 0x0e7f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/2/c */
    { 0x0f00, 0x9118, 0xb981, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767) }, /* #63/3/3/u */
    { 0x0f7f, 0x9118, 0x3901, RTFLOAT80U_INIT_C(0,0x400013b4473b590a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/3/c */
    { 0x0000, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/0/0/u */
    { 0x007f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/0/c */
    { 0x0100, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/0/1/u */
    { 0x017f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/1/c */
    { 0x0200, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/0/2/u */
    { 0x027f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/2/c */
    { 0x0300, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/0/3/u */
    { 0x037f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/3/c */
    { 0x0400, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/1/0/u */
    { 0x047f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/0/c */
    { 0x0500, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/1/1/u */
    { 0x057f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/1/c */
    { 0x0600, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/1/2/u */
    { 0x067f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/2/c */
    { 0x0700, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/1/3/u */
    { 0x077f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/3/c */
    { 0x0800, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/2/0/u */
    { 0x087f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/0/c */
    { 0x0900, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/2/1/u */
    { 0x097f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/1/c */
    { 0x0a00, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/2/2/u */
    { 0x0a7f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/2/c */
    { 0x0b00, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/2/3/u */
    { 0x0b7f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/3/c */
    { 0x0c00, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/3/0/u */
    { 0x0c7f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/0/c */
    { 0x0d00, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/3/1/u */
    { 0x0d7f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/1/c */
    { 0x0e00, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/3/2/u */
    { 0x0e7f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/2/c */
    { 0x0f00, 0xcc99, 0xfc81, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487) }, /* #64/3/3/u */
    { 0x0f7f, 0xcc99, 0x7c01, RTFLOAT80U_INIT_C(0,0x2ccf49c071ff403,20487), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/3/c */
    { 0x0000, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/0/0/u */
    { 0x007f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/0/0/c */
    { 0x0100, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/0/1/u */
    { 0x017f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/0/1/c */
    { 0x0200, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/0/2/u */
    { 0x027f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/0/2/c */
    { 0x0300, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/0/3/u */
    { 0x037f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/0/3/c */
    { 0x0400, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/1/0/u */
    { 0x047f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/1/0/c */
    { 0x0500, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/1/1/u */
    { 0x057f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/1/1/c */
    { 0x0600, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/1/2/u */
    { 0x067f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/1/2/c */
    { 0x0700, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/1/3/u */
    { 0x077f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/1/3/c */
    { 0x0800, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/2/0/u */
    { 0x087f, 0x272d, 0x3f32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf71,0) }, /* #65/2/0/c */
    { 0x0900, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/2/1/u */
    { 0x097f, 0x272d, 0x3f32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf71,0) }, /* #65/2/1/c */
    { 0x0a00, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/2/2/u */
    { 0x0a7f, 0x272d, 0x3f32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf71,0) }, /* #65/2/2/c */
    { 0x0b00, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/2/3/u */
    { 0x0b7f, 0x272d, 0x3f32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf71,0) }, /* #65/2/3/c */
    { 0x0c00, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/3/0/u */
    { 0x0c7f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/3/0/c */
    { 0x0d00, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/3/1/u */
    { 0x0d7f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/3/1/c */
    { 0x0e00, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/3/2/u */
    { 0x0e7f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/3/2/c */
    { 0x0f00, 0x272d, 0xbd82, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0x12b45,0) }, /* #65/3/3/u */
    { 0x0f7f, 0x272d, 0x3d32, RTFLOAT80U_INIT_C(0,0x12b45,0), RTFLOAT80U_INIT_C(0,0xcf70,0) }, /* #65/3/3/c */
    { 0x0000, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/0/0/u */
    { 0x007f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/0/0/c */
    { 0x0100, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/0/1/u */
    { 0x017f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/0/1/c */
    { 0x0200, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/0/2/u */
    { 0x027f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/0/2/c */
    { 0x0300, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/0/3/u */
    { 0x037f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/0/3/c */
    { 0x0400, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/1/0/u */
    { 0x047f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/1/0/c */
    { 0x0500, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/1/1/u */
    { 0x057f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/1/1/c */
    { 0x0600, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/1/2/u */
    { 0x067f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/1/2/c */
    { 0x0700, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/1/3/u */
    { 0x077f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/1/3/c */
    { 0x0800, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/2/0/u */
    { 0x087f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/2/0/c */
    { 0x0900, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/2/1/u */
    { 0x097f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/2/1/c */
    { 0x0a00, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/2/2/u */
    { 0x0a7f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/2/2/c */
    { 0x0b00, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/2/3/u */
    { 0x0b7f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/2/3/c */
    { 0x0c00, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/3/0/u */
    { 0x0c7f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/3/0/c */
    { 0x0d00, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/3/1/u */
    { 0x0d7f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/3/1/c */
    { 0x0e00, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/3/2/u */
    { 0x0e7f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/3/2/c */
    { 0x0f00, 0xbc66, 0xbc81, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767) }, /* #66/3/3/u */
    { 0x0f7f, 0xbc66, 0x3c01, RTFLOAT80U_INIT_C(0,0x80001b4897ed2be8,32767), RTFLOAT80U_INIT_C(0,0xc0001b4897ed2be8,32767) }, /* #66/3/3/c */
    { 0x0000, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/0/0/u */
    { 0x007f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/0/0/c */
    { 0x0100, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/0/1/u */
    { 0x017f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/0/1/c */
    { 0x0200, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/0/2/u */
    { 0x027f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/0/2/c */
    { 0x0300, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/0/3/u */
    { 0x037f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/0/3/c */
    { 0x0400, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/1/0/u */
    { 0x047f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/1/0/c */
    { 0x0500, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/1/1/u */
    { 0x057f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/1/1/c */
    { 0x0600, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/1/2/u */
    { 0x067f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/1/2/c */
    { 0x0700, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/1/3/u */
    { 0x077f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/1/3/c */
    { 0x0800, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/2/0/u */
    { 0x087f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/2/0/c */
    { 0x0900, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/2/1/u */
    { 0x097f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/2/1/c */
    { 0x0a00, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/2/2/u */
    { 0x0a7f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/2/2/c */
    { 0x0b00, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/2/3/u */
    { 0x0b7f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/2/3/c */
    { 0x0c00, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/3/0/u */
    { 0x0c7f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/3/0/c */
    { 0x0d00, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/3/1/u */
    { 0x0d7f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/3/1/c */
    { 0x0e00, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/3/2/u */
    { 0x0e7f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/3/2/c */
    { 0x0f00, 0xea93, 0xf881, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211) }, /* #67/3/3/u */
    { 0x0f7f, 0xea93, 0x7801, RTFLOAT80U_INIT_C(1,0x43cb7fd2891601ba,22211), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #67/3/3/c */
    { 0x0000, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/0/u */
    { 0x007f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/0/c */
    { 0x0100, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/1/u */
    { 0x017f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/1/c */
    { 0x0200, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/2/u */
    { 0x027f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/2/c */
    { 0x0300, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/3/u */
    { 0x037f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/0/3/c */
    { 0x0400, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/0/u */
    { 0x047f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/0/c */
    { 0x0500, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/1/u */
    { 0x057f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/1/c */
    { 0x0600, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/2/u */
    { 0x067f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/2/c */
    { 0x0700, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/3/u */
    { 0x077f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/1/3/c */
    { 0x0800, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/0/u */
    { 0x087f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/0/c */
    { 0x0900, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/1/u */
    { 0x097f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/1/c */
    { 0x0a00, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/2/u */
    { 0x0a7f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/2/c */
    { 0x0b00, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/3/u */
    { 0x0b7f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/2/3/c */
    { 0x0c00, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/0/u */
    { 0x0c7f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/0/c */
    { 0x0d00, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/1/u */
    { 0x0d7f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/1/c */
    { 0x0e00, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/2/u */
    { 0x0e7f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/2/c */
    { 0x0f00, 0xca02, 0xf8a0, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/3/u */
    { 0x0f7f, 0xca02, 0x7820, RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681), RTFLOAT80U_INIT_C(1,0x8798d570090677a4,20681) }, /* #68/3/3/c */
    { 0x0000, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/0/0/u */
    { 0x007f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/0/c */
    { 0x0100, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/0/1/u */
    { 0x017f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/1/c */
    { 0x0200, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/0/2/u */
    { 0x027f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/2/c */
    { 0x0300, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/0/3/u */
    { 0x037f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/3/c */
    { 0x0400, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/1/0/u */
    { 0x047f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/0/c */
    { 0x0500, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/1/1/u */
    { 0x057f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/1/c */
    { 0x0600, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/1/2/u */
    { 0x067f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/2/c */
    { 0x0700, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/1/3/u */
    { 0x077f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/3/c */
    { 0x0800, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/2/0/u */
    { 0x087f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/0/c */
    { 0x0900, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/2/1/u */
    { 0x097f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/1/c */
    { 0x0a00, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/2/2/u */
    { 0x0a7f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/2/c */
    { 0x0b00, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/2/3/u */
    { 0x0b7f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/3/c */
    { 0x0c00, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/3/0/u */
    { 0x0c7f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/0/c */
    { 0x0d00, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/3/1/u */
    { 0x0d7f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/1/c */
    { 0x0e00, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/3/2/u */
    { 0x0e7f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/2/c */
    { 0x0f00, 0xc757, 0xfd81, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839) }, /* #69/3/3/u */
    { 0x0f7f, 0xc757, 0x7d01, RTFLOAT80U_INIT_C(0,0x257563ba1cc4736a,31839), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/3/c */
    { 0x0000, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/0/0/u */
    { 0x007f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/0/c */
    { 0x0100, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/0/1/u */
    { 0x017f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/1/c */
    { 0x0200, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/0/2/u */
    { 0x027f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/2/c */
    { 0x0300, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/0/3/u */
    { 0x037f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/3/c */
    { 0x0400, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/1/0/u */
    { 0x047f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/0/c */
    { 0x0500, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/1/1/u */
    { 0x057f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/1/c */
    { 0x0600, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/1/2/u */
    { 0x067f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/2/c */
    { 0x0700, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/1/3/u */
    { 0x077f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/3/c */
    { 0x0800, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/2/0/u */
    { 0x087f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/0/c */
    { 0x0900, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/2/1/u */
    { 0x097f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/1/c */
    { 0x0a00, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/2/2/u */
    { 0x0a7f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/2/c */
    { 0x0b00, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/2/3/u */
    { 0x0b7f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/3/c */
    { 0x0c00, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/3/0/u */
    { 0x0c7f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/0/c */
    { 0x0d00, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/3/1/u */
    { 0x0d7f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/1/c */
    { 0x0e00, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/3/2/u */
    { 0x0e7f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/2/c */
    { 0x0f00, 0x7fbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #70/3/3/u */
    { 0x0f7f, 0x7fbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/3/c */
    { 0x0000, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/0/u */
    { 0x007f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/0/c */
    { 0x0100, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/1/u */
    { 0x017f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/1/c */
    { 0x0200, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/2/u */
    { 0x027f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/2/c */
    { 0x0300, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/3/u */
    { 0x037f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/0/3/c */
    { 0x0400, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/0/u */
    { 0x047f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/0/c */
    { 0x0500, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/1/u */
    { 0x057f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/1/c */
    { 0x0600, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/2/u */
    { 0x067f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/2/c */
    { 0x0700, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/3/u */
    { 0x077f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/1/3/c */
    { 0x0800, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/0/u */
    { 0x087f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/0/c */
    { 0x0900, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/1/u */
    { 0x097f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/1/c */
    { 0x0a00, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/2/u */
    { 0x0a7f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/2/c */
    { 0x0b00, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/3/u */
    { 0x0b7f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/2/3/c */
    { 0x0c00, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/0/u */
    { 0x0c7f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/0/c */
    { 0x0d00, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/1/u */
    { 0x0d7f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/1/c */
    { 0x0e00, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/2/u */
    { 0x0e7f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/2/c */
    { 0x0f00, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/3/u */
    { 0x0f7f, 0x65f5, 0x7d00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #71/3/3/c */
    { 0x0000, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/0/0/u */
    { 0x007f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/0/0/c */
    { 0x0100, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/0/1/u */
    { 0x017f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/0/1/c */
    { 0x0200, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/0/2/u */
    { 0x027f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/0/2/c */
    { 0x0300, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/0/3/u */
    { 0x037f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/0/3/c */
    { 0x0400, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/1/0/u */
    { 0x047f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/1/0/c */
    { 0x0500, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/1/1/u */
    { 0x057f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/1/1/c */
    { 0x0600, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/1/2/u */
    { 0x067f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/1/2/c */
    { 0x0700, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/1/3/u */
    { 0x077f, 0x3bf5, 0x3b32, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487b,0) }, /* #72/1/3/c */
    { 0x0800, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/2/0/u */
    { 0x087f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/2/0/c */
    { 0x0900, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/2/1/u */
    { 0x097f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/2/1/c */
    { 0x0a00, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/2/2/u */
    { 0x0a7f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/2/2/c */
    { 0x0b00, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/2/3/u */
    { 0x0b7f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/2/3/c */
    { 0x0c00, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/3/0/u */
    { 0x0c7f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/3/0/c */
    { 0x0d00, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/3/1/u */
    { 0x0d7f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/3/1/c */
    { 0x0e00, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/3/2/u */
    { 0x0e7f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/3/2/c */
    { 0x0f00, 0x3bf5, 0xb982, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0) }, /* #72/3/3/u */
    { 0x0f7f, 0x3bf5, 0x3932, RTFLOAT80U_INIT_C(1,0x105e7f13f6fdcc09,0), RTFLOAT80U_INIT_C(1,0xb58a179baab487a,0) }, /* #72/3/3/c */
    { 0x0000, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/0/u */
    { 0x007f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/0/c */
    { 0x0100, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/1/u */
    { 0x017f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/1/c */
    { 0x0200, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/2/u */
    { 0x027f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/2/c */
    { 0x0300, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/3/u */
    { 0x037f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/0/3/c */
    { 0x0400, 0x5aa1, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/0/u */
    { 0x047f, 0x5aa1, 0x7a20, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/0/c */
    { 0x0500, 0x5aa1, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/1/u */
    { 0x057f, 0x5aa1, 0x7a20, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/1/c */
    { 0x0600, 0x5aa1, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/2/u */
    { 0x067f, 0x5aa1, 0x7a20, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/2/c */
    { 0x0700, 0x5aa1, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/3/u */
    { 0x077f, 0x5aa1, 0x7a20, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5b,11614) }, /* #73/1/3/c */
    { 0x0800, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/0/u */
    { 0x087f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/0/c */
    { 0x0900, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/1/u */
    { 0x097f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/1/c */
    { 0x0a00, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/2/u */
    { 0x0a7f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/2/c */
    { 0x0b00, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/3/u */
    { 0x0b7f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/2/3/c */
    { 0x0c00, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/0/u */
    { 0x0c7f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/0/c */
    { 0x0d00, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/1/u */
    { 0x0d7f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/1/c */
    { 0x0e00, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/2/u */
    { 0x0e7f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/2/c */
    { 0x0f00, 0x5aa1, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/3/u */
    { 0x0f7f, 0x5aa1, 0x7820, RTFLOAT80U_INIT_C(1,0xe2146e702647878d,11614), RTFLOAT80U_INIT_C(1,0x9cb4e29f69550a5a,11614) }, /* #73/3/3/c */
    { 0x0000, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/0/0/u */
    { 0x007f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/0/c */
    { 0x0100, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/0/1/u */
    { 0x017f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/1/c */
    { 0x0200, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/0/2/u */
    { 0x027f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/2/c */
    { 0x0300, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/0/3/u */
    { 0x037f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/3/c */
    { 0x0400, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/1/0/u */
    { 0x047f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/0/c */
    { 0x0500, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/1/1/u */
    { 0x057f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/1/c */
    { 0x0600, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/1/2/u */
    { 0x067f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/2/c */
    { 0x0700, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/1/3/u */
    { 0x077f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/3/c */
    { 0x0800, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/2/0/u */
    { 0x087f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/0/c */
    { 0x0900, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/2/1/u */
    { 0x097f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/1/c */
    { 0x0a00, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/2/2/u */
    { 0x0a7f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/2/c */
    { 0x0b00, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/2/3/u */
    { 0x0b7f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/3/c */
    { 0x0c00, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/3/0/u */
    { 0x0c7f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/0/c */
    { 0x0d00, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/3/1/u */
    { 0x0d7f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/1/c */
    { 0x0e00, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/3/2/u */
    { 0x0e7f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/2/c */
    { 0x0f00, 0xa3d5, 0xb981, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767) }, /* #74/3/3/u */
    { 0x0f7f, 0xa3d5, 0x3901, RTFLOAT80U_INIT_C(1,0x4000000190db020a,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/3/c */
    { 0x0000, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/0/0/u */
    { 0x007f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/0/0/c */
    { 0x0100, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/0/1/u */
    { 0x017f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/0/1/c */
    { 0x0200, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/0/2/u */
    { 0x027f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/0/2/c */
    { 0x0300, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/0/3/u */
    { 0x037f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/0/3/c */
    { 0x0400, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/1/0/u */
    { 0x047f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/1/0/c */
    { 0x0500, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/1/1/u */
    { 0x057f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/1/1/c */
    { 0x0600, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/1/2/u */
    { 0x067f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/1/2/c */
    { 0x0700, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/1/3/u */
    { 0x077f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/1/3/c */
    { 0x0800, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/2/0/u */
    { 0x087f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/2/0/c */
    { 0x0900, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/2/1/u */
    { 0x097f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/2/1/c */
    { 0x0a00, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/2/2/u */
    { 0x0a7f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/2/2/c */
    { 0x0b00, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/2/3/u */
    { 0x0b7f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/2/3/c */
    { 0x0c00, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/3/0/u */
    { 0x0c7f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/3/0/c */
    { 0x0d00, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/3/1/u */
    { 0x0d7f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/3/1/c */
    { 0x0e00, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/3/2/u */
    { 0x0e7f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/3/2/c */
    { 0x0f00, 0xa1f3, 0xb981, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451) }, /* #75/3/3/u */
    { 0x0f7f, 0xa1f3, 0x3901, RTFLOAT80U_INIT_C(1,0x2bdca627b0f13536,451), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #75/3/3/c */
    { 0x0000, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/0/0/u */
    { 0x007f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/0/c */
    { 0x0100, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/0/1/u */
    { 0x017f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/1/c */
    { 0x0200, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/0/2/u */
    { 0x027f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/2/c */
    { 0x0300, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/0/3/u */
    { 0x037f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/3/c */
    { 0x0400, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/1/0/u */
    { 0x047f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/0/c */
    { 0x0500, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/1/1/u */
    { 0x057f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/1/c */
    { 0x0600, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/1/2/u */
    { 0x067f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/2/c */
    { 0x0700, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/1/3/u */
    { 0x077f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/3/c */
    { 0x0800, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/2/0/u */
    { 0x087f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/0/c */
    { 0x0900, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/2/1/u */
    { 0x097f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/1/c */
    { 0x0a00, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/2/2/u */
    { 0x0a7f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/2/c */
    { 0x0b00, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/2/3/u */
    { 0x0b7f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/3/c */
    { 0x0c00, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/3/0/u */
    { 0x0c7f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/0/c */
    { 0x0d00, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/3/1/u */
    { 0x0d7f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/1/c */
    { 0x0e00, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/3/2/u */
    { 0x0e7f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/2/c */
    { 0x0f00, 0xee88, 0xfc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #76/3/3/u */
    { 0x0f7f, 0xee88, 0x7c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/3/c */
    { 0x0000, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/0/u */
    { 0x007f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/0/c */
    { 0x0100, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/1/u */
    { 0x017f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/1/c */
    { 0x0200, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/2/u */
    { 0x027f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/2/c */
    { 0x0300, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/3/u */
    { 0x037f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/0/3/c */
    { 0x0400, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/0/u */
    { 0x047f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/0/c */
    { 0x0500, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/1/u */
    { 0x057f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/1/c */
    { 0x0600, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/2/u */
    { 0x067f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/2/c */
    { 0x0700, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/3/u */
    { 0x077f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/1/3/c */
    { 0x0800, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/0/u */
    { 0x087f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/0/c */
    { 0x0900, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/1/u */
    { 0x097f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/1/c */
    { 0x0a00, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/2/u */
    { 0x0a7f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/2/c */
    { 0x0b00, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/3/u */
    { 0x0b7f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/2/3/c */
    { 0x0c00, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/0/u */
    { 0x0c7f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/0/c */
    { 0x0d00, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/1/u */
    { 0x0d7f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/1/c */
    { 0x0e00, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/2/u */
    { 0x0e7f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/2/c */
    { 0x0f00, 0xe2c0, 0xf8a0, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/3/u */
    { 0x0f7f, 0xe2c0, 0x7820, RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118), RTFLOAT80U_INIT_C(1,0xc81ec53775615145,17118) }, /* #77/3/3/c */
    { 0x0000, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/0/u */
    { 0x007f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/0/c */
    { 0x0100, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/1/u */
    { 0x017f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/1/c */
    { 0x0200, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/2/u */
    { 0x027f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/2/c */
    { 0x0300, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/3/u */
    { 0x037f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/0/3/c */
    { 0x0400, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/0/u */
    { 0x047f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/0/c */
    { 0x0500, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/1/u */
    { 0x057f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/1/c */
    { 0x0600, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/2/u */
    { 0x067f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/2/c */
    { 0x0700, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/3/u */
    { 0x077f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/1/3/c */
    { 0x0800, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/0/u */
    { 0x087f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/0/c */
    { 0x0900, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/1/u */
    { 0x097f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/1/c */
    { 0x0a00, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/2/u */
    { 0x0a7f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/2/c */
    { 0x0b00, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/3/u */
    { 0x0b7f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/2/3/c */
    { 0x0c00, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/0/u */
    { 0x0c7f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/0/c */
    { 0x0d00, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/1/u */
    { 0x0d7f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/1/c */
    { 0x0e00, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/2/u */
    { 0x0e7f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/2/c */
    { 0x0f00, 0x436b, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/3/u */
    { 0x0f7f, 0x436b, 0x7920, RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697), RTFLOAT80U_INIT_C(0,0xd2d27b56208dd2e0,21697) }, /* #78/3/3/c */
    { 0x0000, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/0/u */
    { 0x007f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/0/c */
    { 0x0100, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/1/u */
    { 0x017f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/1/c */
    { 0x0200, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/2/u */
    { 0x027f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/2/c */
    { 0x0300, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/3/u */
    { 0x037f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/0/3/c */
    { 0x0400, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/0/u */
    { 0x047f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/0/c */
    { 0x0500, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/1/u */
    { 0x057f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/1/c */
    { 0x0600, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/2/u */
    { 0x067f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/2/c */
    { 0x0700, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/3/u */
    { 0x077f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/1/3/c */
    { 0x0800, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/0/u */
    { 0x087f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/0/c */
    { 0x0900, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/1/u */
    { 0x097f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/1/c */
    { 0x0a00, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/2/u */
    { 0x0a7f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/2/c */
    { 0x0b00, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/3/u */
    { 0x0b7f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/2/3/c */
    { 0x0c00, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/0/u */
    { 0x0c7f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/0/c */
    { 0x0d00, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/1/u */
    { 0x0d7f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/1/c */
    { 0x0e00, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/2/u */
    { 0x0e7f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/2/c */
    { 0x0f00, 0x3dd8, 0xbda0, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/3/u */
    { 0x0f7f, 0x3dd8, 0x3d20, RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586), RTFLOAT80U_INIT_C(0,0x819aa434828a3cc1,29586) }, /* #79/3/3/c */
    { 0x0000, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/0/u */
    { 0x007f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/0/c */
    { 0x0100, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/1/u */
    { 0x017f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/1/c */
    { 0x0200, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/2/u */
    { 0x027f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/2/c */
    { 0x0300, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/3/u */
    { 0x037f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/0/3/c */
    { 0x0400, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/0/u */
    { 0x047f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/0/c */
    { 0x0500, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/1/u */
    { 0x057f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/1/c */
    { 0x0600, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/2/u */
    { 0x067f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/2/c */
    { 0x0700, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/3/u */
    { 0x077f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/1/3/c */
    { 0x0800, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/0/u */
    { 0x087f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/0/c */
    { 0x0900, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/1/u */
    { 0x097f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/1/c */
    { 0x0a00, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/2/u */
    { 0x0a7f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/2/c */
    { 0x0b00, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/3/u */
    { 0x0b7f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/2/3/c */
    { 0x0c00, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/0/u */
    { 0x0c7f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/0/c */
    { 0x0d00, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/1/u */
    { 0x0d7f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/1/c */
    { 0x0e00, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/2/u */
    { 0x0e7f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/2/c */
    { 0x0f00, 0x08a3, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/3/u */
    { 0x0f7f, 0x08a3, 0x3820, RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955), RTFLOAT80U_INIT_C(0,0x8839e7ed7cd030e4,31955) }, /* #80/3/3/c */
    { 0x0000, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/0/u */
    { 0x007f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/0/c */
    { 0x0100, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/1/u */
    { 0x017f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/1/c */
    { 0x0200, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/2/u */
    { 0x027f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/2/c */
    { 0x0300, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/3/u */
    { 0x037f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/0/3/c */
    { 0x0400, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/0/u */
    { 0x047f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/0/c */
    { 0x0500, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/1/u */
    { 0x057f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/1/c */
    { 0x0600, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/2/u */
    { 0x067f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/2/c */
    { 0x0700, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/3/u */
    { 0x077f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/1/3/c */
    { 0x0800, 0xd65f, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/0/u */
    { 0x087f, 0xd65f, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/0/c */
    { 0x0900, 0xd65f, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/1/u */
    { 0x097f, 0xd65f, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/1/c */
    { 0x0a00, 0xd65f, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/2/u */
    { 0x0a7f, 0xd65f, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/2/c */
    { 0x0b00, 0xd65f, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/3/u */
    { 0x0b7f, 0xd65f, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6e,14407) }, /* #81/2/3/c */
    { 0x0c00, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/0/u */
    { 0x0c7f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/0/c */
    { 0x0d00, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/1/u */
    { 0x0d7f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/1/c */
    { 0x0e00, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/2/u */
    { 0x0e7f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/2/c */
    { 0x0f00, 0xd65f, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/3/u */
    { 0x0f7f, 0xd65f, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a181eaa2ef12685,14408), RTFLOAT80U_INIT_C(0,0xd59eb4bd511e2e6d,14407) }, /* #81/3/3/c */
    { 0x0000, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/0/u */
    { 0x007f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/0/c */
    { 0x0100, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/1/u */
    { 0x017f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/1/c */
    { 0x0200, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/2/u */
    { 0x027f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/2/c */
    { 0x0300, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/3/u */
    { 0x037f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/0/3/c */
    { 0x0400, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/0/u */
    { 0x047f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/0/c */
    { 0x0500, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/1/u */
    { 0x057f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/1/c */
    { 0x0600, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/2/u */
    { 0x067f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/2/c */
    { 0x0700, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/3/u */
    { 0x077f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/1/3/c */
    { 0x0800, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/0/u */
    { 0x087f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/0/c */
    { 0x0900, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/1/u */
    { 0x097f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/1/c */
    { 0x0a00, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/2/u */
    { 0x0a7f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/2/c */
    { 0x0b00, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/3/u */
    { 0x0b7f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/2/3/c */
    { 0x0c00, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/0/u */
    { 0x0c7f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/0/c */
    { 0x0d00, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/1/u */
    { 0x0d7f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/1/c */
    { 0x0e00, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/2/u */
    { 0x0e7f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/2/c */
    { 0x0f00, 0xbd6b, 0xbda0, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/3/u */
    { 0x0f7f, 0xbd6b, 0x3d20, RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399), RTFLOAT80U_INIT_C(0,0xc2a76540d29c0b43,28399) }, /* #82/3/3/c */
    { 0x0000, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/0/u */
    { 0x007f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/0/c */
    { 0x0100, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/1/u */
    { 0x017f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/1/c */
    { 0x0200, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/2/u */
    { 0x027f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/2/c */
    { 0x0300, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/3/u */
    { 0x037f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/0/3/c */
    { 0x0400, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/0/u */
    { 0x047f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/0/c */
    { 0x0500, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/1/u */
    { 0x057f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/1/c */
    { 0x0600, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/2/u */
    { 0x067f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/2/c */
    { 0x0700, 0x7d19, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/3/u */
    { 0x077f, 0x7d19, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462654,11178) }, /* #83/1/3/c */
    { 0x0800, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/0/u */
    { 0x087f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/0/c */
    { 0x0900, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/1/u */
    { 0x097f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/1/c */
    { 0x0a00, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/2/u */
    { 0x0a7f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/2/c */
    { 0x0b00, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/3/u */
    { 0x0b7f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/2/3/c */
    { 0x0c00, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/0/u */
    { 0x0c7f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/0/c */
    { 0x0d00, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/1/u */
    { 0x0d7f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/1/c */
    { 0x0e00, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/2/u */
    { 0x0e7f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/2/c */
    { 0x0f00, 0x7d19, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/3/u */
    { 0x0f7f, 0x7d19, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d17c9ec4724fbee,11179), RTFLOAT80U_INIT_C(1,0xc398a8d402462653,11178) }, /* #83/3/3/c */
    { 0x0000, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/0/0/u */
    { 0x007f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/0/0/c */
    { 0x0100, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/0/1/u */
    { 0x017f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/0/1/c */
    { 0x0200, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/0/2/u */
    { 0x027f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/0/2/c */
    { 0x0300, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/0/3/u */
    { 0x037f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/0/3/c */
    { 0x0400, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/1/0/u */
    { 0x047f, 0x50a0, 0x7a32, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b7,0) }, /* #84/1/0/c */
    { 0x0500, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/1/1/u */
    { 0x057f, 0x50a0, 0x7a32, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b7,0) }, /* #84/1/1/c */
    { 0x0600, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/1/2/u */
    { 0x067f, 0x50a0, 0x7a32, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b7,0) }, /* #84/1/2/c */
    { 0x0700, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/1/3/u */
    { 0x077f, 0x50a0, 0x7a32, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b7,0) }, /* #84/1/3/c */
    { 0x0800, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/2/0/u */
    { 0x087f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/2/0/c */
    { 0x0900, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/2/1/u */
    { 0x097f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/2/1/c */
    { 0x0a00, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/2/2/u */
    { 0x0a7f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/2/2/c */
    { 0x0b00, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/2/3/u */
    { 0x0b7f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/2/3/c */
    { 0x0c00, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/3/0/u */
    { 0x0c7f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/3/0/c */
    { 0x0d00, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/3/1/u */
    { 0x0d7f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/3/1/c */
    { 0x0e00, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/3/2/u */
    { 0x0e7f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/3/2/c */
    { 0x0f00, 0x50a0, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x80000000000095dd,0) }, /* #84/3/3/u */
    { 0x0f7f, 0x50a0, 0x7832, RTFLOAT80U_INIT_C(1,0x80000000000095dd,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e824b6,0) }, /* #84/3/3/c */
    { 0x0000, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/0/u */
    { 0x007f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/0/c */
    { 0x0100, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/1/u */
    { 0x017f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/1/c */
    { 0x0200, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/2/u */
    { 0x027f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/2/c */
    { 0x0300, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/3/u */
    { 0x037f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/0/3/c */
    { 0x0400, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/0/u */
    { 0x047f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/0/c */
    { 0x0500, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/1/u */
    { 0x057f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/1/c */
    { 0x0600, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/2/u */
    { 0x067f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/2/c */
    { 0x0700, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/3/u */
    { 0x077f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/1/3/c */
    { 0x0800, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/0/u */
    { 0x087f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/0/c */
    { 0x0900, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/1/u */
    { 0x097f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/1/c */
    { 0x0a00, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/2/u */
    { 0x0a7f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/2/c */
    { 0x0b00, 0x3d3f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/3/u */
    { 0x0b7f, 0x3d3f, 0x3f20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b5,1847) }, /* #85/2/3/c */
    { 0x0c00, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/0/u */
    { 0x0c7f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/0/c */
    { 0x0d00, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/1/u */
    { 0x0d7f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/1/c */
    { 0x0e00, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/2/u */
    { 0x0e7f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/2/c */
    { 0x0f00, 0x3d3f, 0xbda0, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/3/u */
    { 0x0f7f, 0x3d3f, 0x3d20, RTFLOAT80U_INIT_C(0,0xd95654b1f1516f1e,1847), RTFLOAT80U_INIT_C(0,0x96a58d59e51e17b4,1847) }, /* #85/3/3/c */
    { 0x0000, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/0/u */
    { 0x007f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/0/c */
    { 0x0100, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/1/u */
    { 0x017f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/1/c */
    { 0x0200, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/2/u */
    { 0x027f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/2/c */
    { 0x0300, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/3/u */
    { 0x037f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/0/3/c */
    { 0x0400, 0xe68e, 0xfea0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/0/u */
    { 0x047f, 0xe68e, 0x7e20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/0/c */
    { 0x0500, 0xe68e, 0xfea0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/1/u */
    { 0x057f, 0xe68e, 0x7e20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/1/c */
    { 0x0600, 0xe68e, 0xfea0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/2/u */
    { 0x067f, 0xe68e, 0x7e20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/2/c */
    { 0x0700, 0xe68e, 0xfea0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/3/u */
    { 0x077f, 0xe68e, 0x7e20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a04340,6129) }, /* #86/1/3/c */
    { 0x0800, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/0/u */
    { 0x087f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/0/c */
    { 0x0900, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/1/u */
    { 0x097f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/1/c */
    { 0x0a00, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/2/u */
    { 0x0a7f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/2/c */
    { 0x0b00, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/3/u */
    { 0x0b7f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/2/3/c */
    { 0x0c00, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/0/u */
    { 0x0c7f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/0/c */
    { 0x0d00, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/1/u */
    { 0x0d7f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/1/c */
    { 0x0e00, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/2/u */
    { 0x0e7f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/2/c */
    { 0x0f00, 0xe68e, 0xfca0, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/3/u */
    { 0x0f7f, 0xe68e, 0x7c20, RTFLOAT80U_INIT_C(1,0x9277c8f6ad432229,6130), RTFLOAT80U_INIT_C(1,0xcb0c320130a0433f,6129) }, /* #86/3/3/c */
    { 0x0000, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/0/u */
    { 0x007f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/0/c */
    { 0x0100, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/1/u */
    { 0x017f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/1/c */
    { 0x0200, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/2/u */
    { 0x027f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/2/c */
    { 0x0300, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/3/u */
    { 0x037f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/0/3/c */
    { 0x0400, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/0/u */
    { 0x047f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/0/c */
    { 0x0500, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/1/u */
    { 0x057f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/1/c */
    { 0x0600, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/2/u */
    { 0x067f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/2/c */
    { 0x0700, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/3/u */
    { 0x077f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/1/3/c */
    { 0x0800, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/0/u */
    { 0x087f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/0/c */
    { 0x0900, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/1/u */
    { 0x097f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/1/c */
    { 0x0a00, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/2/u */
    { 0x0a7f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/2/c */
    { 0x0b00, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/3/u */
    { 0x0b7f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/2/3/c */
    { 0x0c00, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/0/u */
    { 0x0c7f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/0/c */
    { 0x0d00, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/1/u */
    { 0x0d7f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/1/c */
    { 0x0e00, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/2/u */
    { 0x0e7f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/2/c */
    { 0x0f00, 0x50eb, 0xf8a0, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/3/u */
    { 0x0f7f, 0x50eb, 0x7820, RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229), RTFLOAT80U_INIT_C(0,0x9085ad54da68b603,28229) }, /* #87/3/3/c */
    { 0x0000, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/0/u */
    { 0x007f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/0/c */
    { 0x0100, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/1/u */
    { 0x017f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/1/c */
    { 0x0200, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/2/u */
    { 0x027f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/2/c */
    { 0x0300, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/3/u */
    { 0x037f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/0/3/c */
    { 0x0400, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/0/u */
    { 0x047f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/0/c */
    { 0x0500, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/1/u */
    { 0x057f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/1/c */
    { 0x0600, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/2/u */
    { 0x067f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/2/c */
    { 0x0700, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/3/u */
    { 0x077f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/1/3/c */
    { 0x0800, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/0/u */
    { 0x087f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/0/c */
    { 0x0900, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/1/u */
    { 0x097f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/1/c */
    { 0x0a00, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/2/u */
    { 0x0a7f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/2/c */
    { 0x0b00, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/3/u */
    { 0x0b7f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/2/3/c */
    { 0x0c00, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/0/u */
    { 0x0c7f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/0/c */
    { 0x0d00, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/1/u */
    { 0x0d7f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/1/c */
    { 0x0e00, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/2/u */
    { 0x0e7f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/2/c */
    { 0x0f00, 0xe53c, 0xfda0, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/3/u */
    { 0x0f7f, 0xe53c, 0x7d20, RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160), RTFLOAT80U_INIT_C(1,0xc19f120cb8aa7f98,21160) }, /* #88/3/3/c */
    { 0x0000, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/0/0/u */
    { 0x007f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/0/0/c */
    { 0x0100, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/0/1/u */
    { 0x017f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/0/1/c */
    { 0x0200, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/0/2/u */
    { 0x027f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/0/2/c */
    { 0x0300, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/0/3/u */
    { 0x037f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/0/3/c */
    { 0x0400, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/1/0/u */
    { 0x047f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/1/0/c */
    { 0x0500, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/1/1/u */
    { 0x057f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/1/1/c */
    { 0x0600, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/1/2/u */
    { 0x067f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/1/2/c */
    { 0x0700, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/1/3/u */
    { 0x077f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/1/3/c */
    { 0x0800, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/2/0/u */
    { 0x087f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/2/0/c */
    { 0x0900, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/2/1/u */
    { 0x097f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/2/1/c */
    { 0x0a00, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/2/2/u */
    { 0x0a7f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/2/2/c */
    { 0x0b00, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/2/3/u */
    { 0x0b7f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/2/3/c */
    { 0x0c00, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/3/0/u */
    { 0x0c7f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/3/0/c */
    { 0x0d00, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/3/1/u */
    { 0x0d7f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/3/1/c */
    { 0x0e00, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/3/2/u */
    { 0x0e7f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/3/2/c */
    { 0x0f00, 0x9440, 0xbc81, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878) }, /* #89/3/3/u */
    { 0x0f7f, 0x9440, 0x3c01, RTFLOAT80U_INIT_C(0,0x3647338c6dd6e0e6,26878), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #89/3/3/c */
    { 0x0000, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/0/0/u */
    { 0x007f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/0/c */
    { 0x0100, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/0/1/u */
    { 0x017f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/1/c */
    { 0x0200, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/0/2/u */
    { 0x027f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/2/c */
    { 0x0300, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/0/3/u */
    { 0x037f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/3/c */
    { 0x0400, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/1/0/u */
    { 0x047f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/0/c */
    { 0x0500, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/1/1/u */
    { 0x057f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/1/c */
    { 0x0600, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/1/2/u */
    { 0x067f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/2/c */
    { 0x0700, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/1/3/u */
    { 0x077f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/3/c */
    { 0x0800, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/2/0/u */
    { 0x087f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/0/c */
    { 0x0900, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/2/1/u */
    { 0x097f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/1/c */
    { 0x0a00, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/2/2/u */
    { 0x0a7f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/2/c */
    { 0x0b00, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/2/3/u */
    { 0x0b7f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/3/c */
    { 0x0c00, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/3/0/u */
    { 0x0c7f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/0/c */
    { 0x0d00, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/3/1/u */
    { 0x0d7f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/1/c */
    { 0x0e00, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/3/2/u */
    { 0x0e7f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/2/c */
    { 0x0f00, 0x723c, 0xf881, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767) }, /* #90/3/3/u */
    { 0x0f7f, 0x723c, 0x7801, RTFLOAT80U_INIT_C(1,0x68b3662742d1054e,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/3/c */
    { 0x0000, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/0/u */
    { 0x007f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/0/c */
    { 0x0100, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/1/u */
    { 0x017f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/1/c */
    { 0x0200, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/2/u */
    { 0x027f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/2/c */
    { 0x0300, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/3/u */
    { 0x037f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/0/3/c */
    { 0x0400, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/0/u */
    { 0x047f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/0/c */
    { 0x0500, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/1/u */
    { 0x057f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/1/c */
    { 0x0600, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/2/u */
    { 0x067f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/2/c */
    { 0x0700, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/3/u */
    { 0x077f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/1/3/c */
    { 0x0800, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/0/u */
    { 0x087f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/0/c */
    { 0x0900, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/1/u */
    { 0x097f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/1/c */
    { 0x0a00, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/2/u */
    { 0x0a7f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/2/c */
    { 0x0b00, 0x45ec, 0xffa0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/3/u */
    { 0x0b7f, 0x45ec, 0x7f20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df6,31) }, /* #91/2/3/c */
    { 0x0c00, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/0/u */
    { 0x0c7f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/0/c */
    { 0x0d00, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/1/u */
    { 0x0d7f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/1/c */
    { 0x0e00, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/2/u */
    { 0x0e7f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/2/c */
    { 0x0f00, 0x45ec, 0xfda0, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/3/u */
    { 0x0f7f, 0x45ec, 0x7d20, RTFLOAT80U_INIT_C(0,0xc2f870caa845de19,31), RTFLOAT80U_INIT_C(0,0x8724aadf68391df5,31) }, /* #91/3/3/c */
    { 0x0000, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/0/0/u */
    { 0x007f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/0/c */
    { 0x0100, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/0/1/u */
    { 0x017f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/1/c */
    { 0x0200, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/0/2/u */
    { 0x027f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/2/c */
    { 0x0300, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/0/3/u */
    { 0x037f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/3/c */
    { 0x0400, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/1/0/u */
    { 0x047f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/0/c */
    { 0x0500, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/1/1/u */
    { 0x057f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/1/c */
    { 0x0600, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/1/2/u */
    { 0x067f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/2/c */
    { 0x0700, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/1/3/u */
    { 0x077f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/3/c */
    { 0x0800, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/2/0/u */
    { 0x087f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/0/c */
    { 0x0900, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/2/1/u */
    { 0x097f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/1/c */
    { 0x0a00, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/2/2/u */
    { 0x0a7f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/2/c */
    { 0x0b00, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/2/3/u */
    { 0x0b7f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/3/c */
    { 0x0c00, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/3/0/u */
    { 0x0c7f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/0/c */
    { 0x0d00, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/3/1/u */
    { 0x0d7f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/1/c */
    { 0x0e00, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/3/2/u */
    { 0x0e7f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/2/c */
    { 0x0f00, 0xde2e, 0xfc81, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767) }, /* #92/3/3/u */
    { 0x0f7f, 0xde2e, 0x7c01, RTFLOAT80U_INIT_C(1,0x6d8a10997d21ab9d,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/3/c */
    { 0x0000, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/0/0/u */
    { 0x007f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/0/c */
    { 0x0100, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/0/1/u */
    { 0x017f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/1/c */
    { 0x0200, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/0/2/u */
    { 0x027f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/2/c */
    { 0x0300, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/0/3/u */
    { 0x037f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/3/c */
    { 0x0400, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/1/0/u */
    { 0x047f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/0/c */
    { 0x0500, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/1/1/u */
    { 0x057f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/1/c */
    { 0x0600, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/1/2/u */
    { 0x067f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/2/c */
    { 0x0700, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/1/3/u */
    { 0x077f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/3/c */
    { 0x0800, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/2/0/u */
    { 0x087f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/0/c */
    { 0x0900, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/2/1/u */
    { 0x097f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/1/c */
    { 0x0a00, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/2/2/u */
    { 0x0a7f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/2/c */
    { 0x0b00, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/2/3/u */
    { 0x0b7f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/3/c */
    { 0x0c00, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/3/0/u */
    { 0x0c7f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/0/c */
    { 0x0d00, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/3/1/u */
    { 0x0d7f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/1/c */
    { 0x0e00, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/3/2/u */
    { 0x0e7f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/2/c */
    { 0x0f00, 0x9737, 0xbd81, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276) }, /* #93/3/3/u */
    { 0x0f7f, 0x9737, 0x3d01, RTFLOAT80U_INIT_C(0,0x2cd452157b85d5a7,6276), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/3/c */
    { 0x0000, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/0/u */
    { 0x007f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/0/c */
    { 0x0100, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/1/u */
    { 0x017f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/1/c */
    { 0x0200, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/2/u */
    { 0x027f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/2/c */
    { 0x0300, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/3/u */
    { 0x037f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/0/3/c */
    { 0x0400, 0xdc52, 0xfea0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/0/u */
    { 0x047f, 0xdc52, 0x7e20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/0/c */
    { 0x0500, 0xdc52, 0xfea0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/1/u */
    { 0x057f, 0xdc52, 0x7e20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/1/c */
    { 0x0600, 0xdc52, 0xfea0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/2/u */
    { 0x067f, 0xdc52, 0x7e20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/2/c */
    { 0x0700, 0xdc52, 0xfea0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/3/u */
    { 0x077f, 0xdc52, 0x7e20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b074,5455) }, /* #94/1/3/c */
    { 0x0800, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/0/u */
    { 0x087f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/0/c */
    { 0x0900, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/1/u */
    { 0x097f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/1/c */
    { 0x0a00, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/2/u */
    { 0x0a7f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/2/c */
    { 0x0b00, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/3/u */
    { 0x0b7f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/2/3/c */
    { 0x0c00, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/0/u */
    { 0x0c7f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/0/c */
    { 0x0d00, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/1/u */
    { 0x0d7f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/1/c */
    { 0x0e00, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/2/u */
    { 0x0e7f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/2/c */
    { 0x0f00, 0xdc52, 0xfca0, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/3/u */
    { 0x0f7f, 0xdc52, 0x7c20, RTFLOAT80U_INIT_C(1,0xe4184854ce7ec293,5455), RTFLOAT80U_INIT_C(1,0x9e1a722dd567b073,5455) }, /* #94/3/3/c */
    { 0x0000, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/0/u */
    { 0x007f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/0/c */
    { 0x0100, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/1/u */
    { 0x017f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/1/c */
    { 0x0200, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/2/u */
    { 0x027f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/2/c */
    { 0x0300, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/3/u */
    { 0x037f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/0/3/c */
    { 0x0400, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/0/u */
    { 0x047f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/0/c */
    { 0x0500, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/1/u */
    { 0x057f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/1/c */
    { 0x0600, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/2/u */
    { 0x067f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/2/c */
    { 0x0700, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/3/u */
    { 0x077f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/1/3/c */
    { 0x0800, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/0/u */
    { 0x087f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/0/c */
    { 0x0900, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/1/u */
    { 0x097f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/1/c */
    { 0x0a00, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/2/u */
    { 0x0a7f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/2/c */
    { 0x0b00, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/3/u */
    { 0x0b7f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/2/3/c */
    { 0x0c00, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/0/u */
    { 0x0c7f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/0/c */
    { 0x0d00, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/1/u */
    { 0x0d7f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/1/c */
    { 0x0e00, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/2/u */
    { 0x0e7f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/2/c */
    { 0x0f00, 0xe4d5, 0xfca0, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/3/u */
    { 0x0f7f, 0xe4d5, 0x7c20, RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374), RTFLOAT80U_INIT_C(0,0x8a6f4847ab57b21f,21374) }, /* #95/3/3/c */
    { 0x0000, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/0/u */
    { 0x007f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/0/c */
    { 0x0100, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/1/u */
    { 0x017f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/1/c */
    { 0x0200, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/2/u */
    { 0x027f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/2/c */
    { 0x0300, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/3/u */
    { 0x037f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/0/3/c */
    { 0x0400, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/0/u */
    { 0x047f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/0/c */
    { 0x0500, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/1/u */
    { 0x057f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/1/c */
    { 0x0600, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/2/u */
    { 0x067f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/2/c */
    { 0x0700, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/3/u */
    { 0x077f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/1/3/c */
    { 0x0800, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/0/u */
    { 0x087f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/0/c */
    { 0x0900, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/1/u */
    { 0x097f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/1/c */
    { 0x0a00, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/2/u */
    { 0x0a7f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/2/c */
    { 0x0b00, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/3/u */
    { 0x0b7f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/2/3/c */
    { 0x0c00, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/0/u */
    { 0x0c7f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/0/c */
    { 0x0d00, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/1/u */
    { 0x0d7f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/1/c */
    { 0x0e00, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/2/u */
    { 0x0e7f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/2/c */
    { 0x0f00, 0x41b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/3/u */
    { 0x0f7f, 0x41b8, 0x7920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383) }, /* #96/3/3/c */
};
uint32_t const g_cTests_f2xm1_r80_amd = RT_ELEMENTS(g_aTests_f2xm1_r80_amd);

FPU_UNARY_R80_TEST_T const g_aTests_fsin_r80_amd[] =
{
    { 0x0000, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/0/u */
    { 0x007f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/0/c */
    { 0x0100, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/1/u */
    { 0x017f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/1/c */
    { 0x0200, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/2/u */
    { 0x027f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/2/c */
    { 0x0300, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/3/u */
    { 0x037f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/0/3/c */
    { 0x0400, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/0/u */
    { 0x047f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/0/c */
    { 0x0500, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/1/u */
    { 0x057f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/1/c */
    { 0x0600, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/2/u */
    { 0x067f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/2/c */
    { 0x0700, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/3/u */
    { 0x077f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/1/3/c */
    { 0x0800, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/0/u */
    { 0x087f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/0/c */
    { 0x0900, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/1/u */
    { 0x097f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/1/c */
    { 0x0a00, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/2/u */
    { 0x0a7f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/2/c */
    { 0x0b00, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/3/u */
    { 0x0b7f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/2/3/c */
    { 0x0c00, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/0/u */
    { 0x0c7f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/0/c */
    { 0x0d00, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/1/u */
    { 0x0d7f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/1/c */
    { 0x0e00, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/2/u */
    { 0x0e7f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/2/c */
    { 0x0f00, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/3/u */
    { 0x0f7f, 0xa09e, 0x3c00, RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979), RTFLOAT80U_INIT_C(1,0x9702064d120ea2d2,21979) }, /* #0/3/3/c */
    { 0x0000, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/0/0/u */
    { 0x007f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/0/c */
    { 0x0100, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/0/1/u */
    { 0x017f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/1/c */
    { 0x0200, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/0/2/u */
    { 0x027f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/2/c */
    { 0x0300, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/0/3/u */
    { 0x037f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/3/c */
    { 0x0400, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/1/0/u */
    { 0x047f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/0/c */
    { 0x0500, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/1/1/u */
    { 0x057f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/1/c */
    { 0x0600, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/1/2/u */
    { 0x067f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/2/c */
    { 0x0700, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/1/3/u */
    { 0x077f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/3/c */
    { 0x0800, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/2/0/u */
    { 0x087f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/0/c */
    { 0x0900, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/2/1/u */
    { 0x097f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/1/c */
    { 0x0a00, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/2/2/u */
    { 0x0a7f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/2/c */
    { 0x0b00, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/2/3/u */
    { 0x0b7f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/3/c */
    { 0x0c00, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/3/0/u */
    { 0x0c7f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/0/c */
    { 0x0d00, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/3/1/u */
    { 0x0d7f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/1/c */
    { 0x0e00, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/3/2/u */
    { 0x0e7f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/2/c */
    { 0x0f00, 0x7889, 0xf881, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224) }, /* #1/3/3/u */
    { 0x0f7f, 0x7889, 0x7801, RTFLOAT80U_INIT_C(1,0x17cd9858b8a01cf6,26224), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/3/c */
    { 0x0000, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/0/0/u */
    { 0x007f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/0/c */
    { 0x0100, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/0/1/u */
    { 0x017f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/1/c */
    { 0x0200, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/0/2/u */
    { 0x027f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/2/c */
    { 0x0300, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/0/3/u */
    { 0x037f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/3/c */
    { 0x0400, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/1/0/u */
    { 0x047f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/0/c */
    { 0x0500, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/1/1/u */
    { 0x057f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/1/c */
    { 0x0600, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/1/2/u */
    { 0x067f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/2/c */
    { 0x0700, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/1/3/u */
    { 0x077f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/3/c */
    { 0x0800, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/2/0/u */
    { 0x087f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/0/c */
    { 0x0900, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/2/1/u */
    { 0x097f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/1/c */
    { 0x0a00, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/2/2/u */
    { 0x0a7f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/2/c */
    { 0x0b00, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/2/3/u */
    { 0x0b7f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/3/c */
    { 0x0c00, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/3/0/u */
    { 0x0c7f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/0/c */
    { 0x0d00, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/3/1/u */
    { 0x0d7f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/1/c */
    { 0x0e00, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/3/2/u */
    { 0x0e7f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/2/c */
    { 0x0f00, 0xd878, 0xf881, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816) }, /* #2/3/3/u */
    { 0x0f7f, 0xd878, 0x7801, RTFLOAT80U_INIT_C(1,0x71a3a1c985ed9834,19816), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/3/c */
    { 0x0000, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/0/u */
    { 0x007f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/0/c */
    { 0x0100, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/1/u */
    { 0x017f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/1/c */
    { 0x0200, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/2/u */
    { 0x027f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/2/c */
    { 0x0300, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/3/u */
    { 0x037f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/0/3/c */
    { 0x0400, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/0/u */
    { 0x047f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/0/c */
    { 0x0500, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/1/u */
    { 0x057f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/1/c */
    { 0x0600, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/2/u */
    { 0x067f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/2/c */
    { 0x0700, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/3/u */
    { 0x077f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/1/3/c */
    { 0x0800, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/0/u */
    { 0x087f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/0/c */
    { 0x0900, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/1/u */
    { 0x097f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/1/c */
    { 0x0a00, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/2/u */
    { 0x0a7f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/2/c */
    { 0x0b00, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/3/u */
    { 0x0b7f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/2/3/c */
    { 0x0c00, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/0/u */
    { 0x0c7f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/0/c */
    { 0x0d00, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/1/u */
    { 0x0d7f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/1/c */
    { 0x0e00, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/2/u */
    { 0x0e7f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/2/c */
    { 0x0f00, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/3/u */
    { 0x0f7f, 0x8b57, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #3/3/3/c */
    { 0x0000, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/0/0/u */
    { 0x007f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/0/0/c */
    { 0x0100, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/0/1/u */
    { 0x017f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/0/1/c */
    { 0x0200, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/0/2/u */
    { 0x027f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/0/2/c */
    { 0x0300, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/0/3/u */
    { 0x037f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/0/3/c */
    { 0x0400, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/1/0/u */
    { 0x047f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/1/0/c */
    { 0x0500, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/1/1/u */
    { 0x057f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/1/1/c */
    { 0x0600, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/1/2/u */
    { 0x067f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/1/2/c */
    { 0x0700, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/1/3/u */
    { 0x077f, 0xe593, 0x7b22, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,1) }, /* #4/1/3/c */
    { 0x0800, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/2/0/u */
    { 0x087f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/2/0/c */
    { 0x0900, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/2/1/u */
    { 0x097f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/2/1/c */
    { 0x0a00, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/2/2/u */
    { 0x0a7f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/2/2/c */
    { 0x0b00, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/2/3/u */
    { 0x0b7f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/2/3/c */
    { 0x0c00, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/3/0/u */
    { 0x0c7f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/3/0/c */
    { 0x0d00, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/3/1/u */
    { 0x0d7f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/3/1/c */
    { 0x0e00, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/3/2/u */
    { 0x0e7f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/3/2/c */
    { 0x0f00, 0xe593, 0xf982, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0) }, /* #4/3/3/u */
    { 0x0f7f, 0xe593, 0x7922, RTFLOAT80U_INIT_C(1,0x8007fa27f3ded121,0), RTFLOAT80U_INIT_C(1,0x8007fa27f3ded120,1) }, /* #4/3/3/c */
    { 0x0000, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/0/u */
    { 0x007f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/0/c */
    { 0x0100, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/1/u */
    { 0x017f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/1/c */
    { 0x0200, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/2/u */
    { 0x027f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/2/c */
    { 0x0300, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/3/u */
    { 0x037f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/0/3/c */
    { 0x0400, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/0/u */
    { 0x047f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/0/c */
    { 0x0500, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/1/u */
    { 0x057f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/1/c */
    { 0x0600, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/2/u */
    { 0x067f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/2/c */
    { 0x0700, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/3/u */
    { 0x077f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/1/3/c */
    { 0x0800, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/0/u */
    { 0x087f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/0/c */
    { 0x0900, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/1/u */
    { 0x097f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/1/c */
    { 0x0a00, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/2/u */
    { 0x0a7f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/2/c */
    { 0x0b00, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/3/u */
    { 0x0b7f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/2/3/c */
    { 0x0c00, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/0/u */
    { 0x0c7f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/0/c */
    { 0x0d00, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/1/u */
    { 0x0d7f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/1/c */
    { 0x0e00, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/2/u */
    { 0x0e7f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/2/c */
    { 0x0f00, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/3/u */
    { 0x0f7f, 0xd821, 0x7c00, RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095), RTFLOAT80U_INIT_C(0,0xdaadbb430c261ec3,23095) }, /* #5/3/3/c */
    { 0x0000, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/0/u */
    { 0x007f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/0/c */
    { 0x0100, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/1/u */
    { 0x017f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/1/c */
    { 0x0200, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/2/u */
    { 0x027f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/2/c */
    { 0x0300, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/3/u */
    { 0x037f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/0/3/c */
    { 0x0400, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/0/u */
    { 0x047f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/0/c */
    { 0x0500, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/1/u */
    { 0x057f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/1/c */
    { 0x0600, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/2/u */
    { 0x067f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/2/c */
    { 0x0700, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/3/u */
    { 0x077f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/1/3/c */
    { 0x0800, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/0/u */
    { 0x087f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/0/c */
    { 0x0900, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/1/u */
    { 0x097f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/1/c */
    { 0x0a00, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/2/u */
    { 0x0a7f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/2/c */
    { 0x0b00, 0x14e3, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/3/u */
    { 0x0b7f, 0x14e3, 0x3a20, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202) }, /* #6/2/3/c */
    { 0x0c00, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/0/u */
    { 0x0c7f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/0/c */
    { 0x0d00, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/1/u */
    { 0x0d7f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/1/c */
    { 0x0e00, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/2/u */
    { 0x0e7f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/2/c */
    { 0x0f00, 0x14e3, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/3/u */
    { 0x0f7f, 0x14e3, 0x3820, RTFLOAT80U_INIT_C(0,0xd49e367151388104,16202), RTFLOAT80U_INIT_C(0,0xd49e367151388103,16202) }, /* #6/3/3/c */
    { 0x0000, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/0/u */
    { 0x007f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/0/c */
    { 0x0100, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/1/u */
    { 0x017f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/1/c */
    { 0x0200, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/2/u */
    { 0x027f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/2/c */
    { 0x0300, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/3/u */
    { 0x037f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/0/3/c */
    { 0x0400, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/0/u */
    { 0x047f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/0/c */
    { 0x0500, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/1/u */
    { 0x057f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/1/c */
    { 0x0600, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/2/u */
    { 0x067f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/2/c */
    { 0x0700, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/3/u */
    { 0x077f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/1/3/c */
    { 0x0800, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/0/u */
    { 0x087f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/0/c */
    { 0x0900, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/1/u */
    { 0x097f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/1/c */
    { 0x0a00, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/2/u */
    { 0x0a7f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/2/c */
    { 0x0b00, 0x9fb5, 0xbba0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/3/u */
    { 0x0b7f, 0x9fb5, 0x3b20, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867) }, /* #7/2/3/c */
    { 0x0c00, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/0/u */
    { 0x0c7f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/0/c */
    { 0x0d00, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/1/u */
    { 0x0d7f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/1/c */
    { 0x0e00, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/2/u */
    { 0x0e7f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/2/c */
    { 0x0f00, 0x9fb5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/3/u */
    { 0x0f7f, 0x9fb5, 0x3920, RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6e,11867), RTFLOAT80U_INIT_C(0,0xfd2078d8cbdf7b6d,11867) }, /* #7/3/3/c */
    { 0x0000, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/0/u */
    { 0x007f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/0/c */
    { 0x0100, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/1/u */
    { 0x017f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/1/c */
    { 0x0200, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/2/u */
    { 0x027f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/2/c */
    { 0x0300, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/3/u */
    { 0x037f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/0/3/c */
    { 0x0400, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/0/u */
    { 0x047f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/0/c */
    { 0x0500, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/1/u */
    { 0x057f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/1/c */
    { 0x0600, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/2/u */
    { 0x067f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/2/c */
    { 0x0700, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/3/u */
    { 0x077f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/1/3/c */
    { 0x0800, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/0/u */
    { 0x087f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/0/c */
    { 0x0900, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/1/u */
    { 0x097f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/1/c */
    { 0x0a00, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/2/u */
    { 0x0a7f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/2/c */
    { 0x0b00, 0x8542, 0xbba0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/3/u */
    { 0x0b7f, 0x8542, 0x3b20, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662) }, /* #8/2/3/c */
    { 0x0c00, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/0/u */
    { 0x0c7f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/0/c */
    { 0x0d00, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/1/u */
    { 0x0d7f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/1/c */
    { 0x0e00, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/2/u */
    { 0x0e7f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/2/c */
    { 0x0f00, 0x8542, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/3/u */
    { 0x0f7f, 0x8542, 0x3920, RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2693,13662), RTFLOAT80U_INIT_C(0,0x8888bad2b8bc2692,13662) }, /* #8/3/3/c */
    { 0x0000, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/0/0/u */
    { 0x007f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/0/c */
    { 0x0100, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/0/1/u */
    { 0x017f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/1/c */
    { 0x0200, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/0/2/u */
    { 0x027f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/2/c */
    { 0x0300, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/0/3/u */
    { 0x037f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/3/c */
    { 0x0400, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/1/0/u */
    { 0x047f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/0/c */
    { 0x0500, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/1/1/u */
    { 0x057f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/1/c */
    { 0x0600, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/1/2/u */
    { 0x067f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/2/c */
    { 0x0700, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/1/3/u */
    { 0x077f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/3/c */
    { 0x0800, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/2/0/u */
    { 0x087f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/0/c */
    { 0x0900, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/2/1/u */
    { 0x097f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/1/c */
    { 0x0a00, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/2/2/u */
    { 0x0a7f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/2/c */
    { 0x0b00, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/2/3/u */
    { 0x0b7f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/3/c */
    { 0x0c00, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/3/0/u */
    { 0x0c7f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/0/c */
    { 0x0d00, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/3/1/u */
    { 0x0d7f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/1/c */
    { 0x0e00, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/3/2/u */
    { 0x0e7f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/2/c */
    { 0x0f00, 0x8652, 0xb881, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767) }, /* #9/3/3/u */
    { 0x0f7f, 0x8652, 0x3801, RTFLOAT80U_INIT_C(1,0x400069664bd84371,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/3/c */
    { 0x0000, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/0/0/u */
    { 0x007f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/0/c */
    { 0x0100, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/0/1/u */
    { 0x017f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/1/c */
    { 0x0200, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/0/2/u */
    { 0x027f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/2/c */
    { 0x0300, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/0/3/u */
    { 0x037f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/3/c */
    { 0x0400, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/1/0/u */
    { 0x047f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/0/c */
    { 0x0500, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/1/1/u */
    { 0x057f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/1/c */
    { 0x0600, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/1/2/u */
    { 0x067f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/2/c */
    { 0x0700, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/1/3/u */
    { 0x077f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/3/c */
    { 0x0800, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/2/0/u */
    { 0x087f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/0/c */
    { 0x0900, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/2/1/u */
    { 0x097f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/1/c */
    { 0x0a00, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/2/2/u */
    { 0x0a7f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/2/c */
    { 0x0b00, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/2/3/u */
    { 0x0b7f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/3/c */
    { 0x0c00, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/3/0/u */
    { 0x0c7f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/0/c */
    { 0x0d00, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/3/1/u */
    { 0x0d7f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/1/c */
    { 0x0e00, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/3/2/u */
    { 0x0e7f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/2/c */
    { 0x0f00, 0x2eb2, 0xb881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #10/3/3/u */
    { 0x0f7f, 0x2eb2, 0x3801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/3/c */
    { 0x0000, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/0/0/u */
    { 0x007f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/0/0/c */
    { 0x0100, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/0/1/u */
    { 0x017f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/0/1/c */
    { 0x0200, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/0/2/u */
    { 0x027f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/0/2/c */
    { 0x0300, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/0/3/u */
    { 0x037f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/0/3/c */
    { 0x0400, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/1/0/u */
    { 0x047f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/1/0/c */
    { 0x0500, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/1/1/u */
    { 0x057f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/1/1/c */
    { 0x0600, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/1/2/u */
    { 0x067f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/1/2/c */
    { 0x0700, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/1/3/u */
    { 0x077f, 0x179e, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,1) }, /* #11/1/3/c */
    { 0x0800, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/2/0/u */
    { 0x087f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/2/0/c */
    { 0x0900, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/2/1/u */
    { 0x097f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/2/1/c */
    { 0x0a00, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/2/2/u */
    { 0x0a7f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/2/2/c */
    { 0x0b00, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/2/3/u */
    { 0x0b7f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/2/3/c */
    { 0x0c00, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/3/0/u */
    { 0x0c7f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/3/0/c */
    { 0x0d00, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/3/1/u */
    { 0x0d7f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/3/1/c */
    { 0x0e00, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/3/2/u */
    { 0x0e7f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/3/2/c */
    { 0x0f00, 0x179e, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0) }, /* #11/3/3/u */
    { 0x0f7f, 0x179e, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000006f4c8b,0), RTFLOAT80U_INIT_C(1,0x80000000006f4c8a,1) }, /* #11/3/3/c */
    { 0x0000, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/0/0/u */
    { 0x007f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/0/0/c */
    { 0x0100, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/0/1/u */
    { 0x017f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/0/1/c */
    { 0x0200, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/0/2/u */
    { 0x027f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/0/2/c */
    { 0x0300, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/0/3/u */
    { 0x037f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/0/3/c */
    { 0x0400, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/1/0/u */
    { 0x047f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/1/0/c */
    { 0x0500, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/1/1/u */
    { 0x057f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/1/1/c */
    { 0x0600, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/1/2/u */
    { 0x067f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/1/2/c */
    { 0x0700, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/1/3/u */
    { 0x077f, 0x986b, 0x3a22, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,1) }, /* #12/1/3/c */
    { 0x0800, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/2/0/u */
    { 0x087f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/2/0/c */
    { 0x0900, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/2/1/u */
    { 0x097f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/2/1/c */
    { 0x0a00, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/2/2/u */
    { 0x0a7f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/2/2/c */
    { 0x0b00, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/2/3/u */
    { 0x0b7f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/2/3/c */
    { 0x0c00, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/3/0/u */
    { 0x0c7f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/3/0/c */
    { 0x0d00, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/3/1/u */
    { 0x0d7f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/3/1/c */
    { 0x0e00, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/3/2/u */
    { 0x0e7f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/3/2/c */
    { 0x0f00, 0x986b, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a37,0) }, /* #12/3/3/u */
    { 0x0f7f, 0x986b, 0x3822, RTFLOAT80U_INIT_C(1,0x8000000000000a37,0), RTFLOAT80U_INIT_C(1,0x8000000000000a36,1) }, /* #12/3/3/c */
    { 0x0000, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/0/0/u */
    { 0x007f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/0/c */
    { 0x0100, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/0/1/u */
    { 0x017f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/1/c */
    { 0x0200, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/0/2/u */
    { 0x027f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/2/c */
    { 0x0300, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/0/3/u */
    { 0x037f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/3/c */
    { 0x0400, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/1/0/u */
    { 0x047f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/0/c */
    { 0x0500, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/1/1/u */
    { 0x057f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/1/c */
    { 0x0600, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/1/2/u */
    { 0x067f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/2/c */
    { 0x0700, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/1/3/u */
    { 0x077f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/3/c */
    { 0x0800, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/2/0/u */
    { 0x087f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/0/c */
    { 0x0900, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/2/1/u */
    { 0x097f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/1/c */
    { 0x0a00, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/2/2/u */
    { 0x0a7f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/2/c */
    { 0x0b00, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/2/3/u */
    { 0x0b7f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/3/c */
    { 0x0c00, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/3/0/u */
    { 0x0c7f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/0/c */
    { 0x0d00, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/3/1/u */
    { 0x0d7f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/1/c */
    { 0x0e00, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/3/2/u */
    { 0x0e7f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/2/c */
    { 0x0f00, 0x5c4d, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #13/3/3/u */
    { 0x0f7f, 0x5c4d, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/3/c */
    { 0x0000, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/0/u */
    { 0x007f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/0/c */
    { 0x0100, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/1/u */
    { 0x017f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/1/c */
    { 0x0200, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/2/u */
    { 0x027f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/2/c */
    { 0x0300, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/3/u */
    { 0x037f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/0/3/c */
    { 0x0400, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/0/u */
    { 0x047f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/0/c */
    { 0x0500, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/1/u */
    { 0x057f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/1/c */
    { 0x0600, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/2/u */
    { 0x067f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/2/c */
    { 0x0700, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/3/u */
    { 0x077f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/1/3/c */
    { 0x0800, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/0/u */
    { 0x087f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/0/c */
    { 0x0900, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/1/u */
    { 0x097f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/1/c */
    { 0x0a00, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/2/u */
    { 0x0a7f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/2/c */
    { 0x0b00, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/3/u */
    { 0x0b7f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/2/3/c */
    { 0x0c00, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/0/u */
    { 0x0c7f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/0/c */
    { 0x0d00, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/1/u */
    { 0x0d7f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/1/c */
    { 0x0e00, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/2/u */
    { 0x0e7f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/2/c */
    { 0x0f00, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/3/u */
    { 0x0f7f, 0x3c6a, 0x3c00, RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063), RTFLOAT80U_INIT_C(1,0xddfbf1b5e76ce43b,21063) }, /* #14/3/3/c */
    { 0x0000, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/0/u */
    { 0x007f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/0/c */
    { 0x0100, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/1/u */
    { 0x017f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/1/c */
    { 0x0200, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/2/u */
    { 0x027f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/2/c */
    { 0x0300, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/3/u */
    { 0x037f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/0/3/c */
    { 0x0400, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/0/u */
    { 0x047f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/0/c */
    { 0x0500, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/1/u */
    { 0x057f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/1/c */
    { 0x0600, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/2/u */
    { 0x067f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/2/c */
    { 0x0700, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/3/u */
    { 0x077f, 0x0557, 0x3b32, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/1/3/c */
    { 0x0800, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/2/0/u */
    { 0x087f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/2/0/c */
    { 0x0900, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/2/1/u */
    { 0x097f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/2/1/c */
    { 0x0a00, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/2/2/u */
    { 0x0a7f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/2/2/c */
    { 0x0b00, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/2/3/u */
    { 0x0b7f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/2/3/c */
    { 0x0c00, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/3/0/u */
    { 0x0c7f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/3/0/c */
    { 0x0d00, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/3/1/u */
    { 0x0d7f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/3/1/c */
    { 0x0e00, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/3/2/u */
    { 0x0e7f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/3/2/c */
    { 0x0f00, 0x0557, 0xb982, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac6,0) }, /* #15/3/3/u */
    { 0x0f7f, 0x0557, 0x3932, RTFLOAT80U_INIT_C(1,0x479b3ac6,0), RTFLOAT80U_INIT_C(1,0x479b3ac5,0) }, /* #15/3/3/c */
    { 0x0000, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/0/u */
    { 0x007f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/0/c */
    { 0x0100, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/1/u */
    { 0x017f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/1/c */
    { 0x0200, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/2/u */
    { 0x027f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/2/c */
    { 0x0300, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/3/u */
    { 0x037f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/0/3/c */
    { 0x0400, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/0/u */
    { 0x047f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/0/c */
    { 0x0500, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/1/u */
    { 0x057f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/1/c */
    { 0x0600, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/2/u */
    { 0x067f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/2/c */
    { 0x0700, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/3/u */
    { 0x077f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/1/3/c */
    { 0x0800, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/0/u */
    { 0x087f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/0/c */
    { 0x0900, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/1/u */
    { 0x097f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/1/c */
    { 0x0a00, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/2/u */
    { 0x0a7f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/2/c */
    { 0x0b00, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/3/u */
    { 0x0b7f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/2/3/c */
    { 0x0c00, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/0/u */
    { 0x0c7f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/0/c */
    { 0x0d00, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/1/u */
    { 0x0d7f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/1/c */
    { 0x0e00, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/2/u */
    { 0x0e7f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/2/c */
    { 0x0f00, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/3/u */
    { 0x0f7f, 0xd556, 0x7900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #16/3/3/c */
    { 0x0000, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/0/0/u */
    { 0x007f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/0/c */
    { 0x0100, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/0/1/u */
    { 0x017f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/1/c */
    { 0x0200, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/0/2/u */
    { 0x027f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/2/c */
    { 0x0300, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/0/3/u */
    { 0x037f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/3/c */
    { 0x0400, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/1/0/u */
    { 0x047f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/0/c */
    { 0x0500, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/1/1/u */
    { 0x057f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/1/c */
    { 0x0600, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/1/2/u */
    { 0x067f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/2/c */
    { 0x0700, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/1/3/u */
    { 0x077f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/3/c */
    { 0x0800, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/2/0/u */
    { 0x087f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/0/c */
    { 0x0900, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/2/1/u */
    { 0x097f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/1/c */
    { 0x0a00, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/2/2/u */
    { 0x0a7f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/2/c */
    { 0x0b00, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/2/3/u */
    { 0x0b7f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/3/c */
    { 0x0c00, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/3/0/u */
    { 0x0c7f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/0/c */
    { 0x0d00, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/3/1/u */
    { 0x0d7f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/1/c */
    { 0x0e00, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/3/2/u */
    { 0x0e7f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/2/c */
    { 0x0f00, 0x4992, 0xf981, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430) }, /* #17/3/3/u */
    { 0x0f7f, 0x4992, 0x7901, RTFLOAT80U_INIT_C(0,0x302c580264ff39cf,9430), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/3/c */
    { 0x0000, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/0/u */
    { 0x007f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/0/c */
    { 0x0100, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/1/u */
    { 0x017f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/1/c */
    { 0x0200, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/2/u */
    { 0x027f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/2/c */
    { 0x0300, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/3/u */
    { 0x037f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/0/3/c */
    { 0x0400, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/0/u */
    { 0x047f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/0/c */
    { 0x0500, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/1/u */
    { 0x057f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/1/c */
    { 0x0600, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/2/u */
    { 0x067f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/2/c */
    { 0x0700, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/3/u */
    { 0x077f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/1/3/c */
    { 0x0800, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/0/u */
    { 0x087f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/0/c */
    { 0x0900, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/1/u */
    { 0x097f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/1/c */
    { 0x0a00, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/2/u */
    { 0x0a7f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/2/c */
    { 0x0b00, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/3/u */
    { 0x0b7f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/2/3/c */
    { 0x0c00, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/0/u */
    { 0x0c7f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/0/c */
    { 0x0d00, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/1/u */
    { 0x0d7f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/1/c */
    { 0x0e00, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/2/u */
    { 0x0e7f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/2/c */
    { 0x0f00, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/3/u */
    { 0x0f7f, 0x7702, 0x7d00, RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666), RTFLOAT80U_INIT_C(0,0x86322a9fc5933f90,20666) }, /* #18/3/3/c */
    { 0x0000, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/0/u */
    { 0x007f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/0/c */
    { 0x0100, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/1/u */
    { 0x017f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/1/c */
    { 0x0200, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/2/u */
    { 0x027f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/2/c */
    { 0x0300, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/3/u */
    { 0x037f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/0/3/c */
    { 0x0400, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/0/u */
    { 0x047f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/0/c */
    { 0x0500, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/1/u */
    { 0x057f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/1/c */
    { 0x0600, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/2/u */
    { 0x067f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/2/c */
    { 0x0700, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/3/u */
    { 0x077f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/1/3/c */
    { 0x0800, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/0/u */
    { 0x087f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/0/c */
    { 0x0900, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/1/u */
    { 0x097f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/1/c */
    { 0x0a00, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/2/u */
    { 0x0a7f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/2/c */
    { 0x0b00, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/3/u */
    { 0x0b7f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/2/3/c */
    { 0x0c00, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/0/u */
    { 0x0c7f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/0/c */
    { 0x0d00, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/1/u */
    { 0x0d7f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/1/c */
    { 0x0e00, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/2/u */
    { 0x0e7f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/2/c */
    { 0x0f00, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/3/u */
    { 0x0f7f, 0xe415, 0x7800, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #19/3/3/c */
    { 0x0000, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/0/u */
    { 0x007f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/0/c */
    { 0x0100, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/1/u */
    { 0x017f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/1/c */
    { 0x0200, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/2/u */
    { 0x027f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/2/c */
    { 0x0300, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/3/u */
    { 0x037f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/0/3/c */
    { 0x0400, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/0/u */
    { 0x047f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/0/c */
    { 0x0500, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/1/u */
    { 0x057f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/1/c */
    { 0x0600, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/2/u */
    { 0x067f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/2/c */
    { 0x0700, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/3/u */
    { 0x077f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/1/3/c */
    { 0x0800, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/0/u */
    { 0x087f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/0/c */
    { 0x0900, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/1/u */
    { 0x097f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/1/c */
    { 0x0a00, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/2/u */
    { 0x0a7f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/2/c */
    { 0x0b00, 0xc811, 0xfaa0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/3/u */
    { 0x0b7f, 0xc811, 0x7a20, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830) }, /* #20/2/3/c */
    { 0x0c00, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/0/u */
    { 0x0c7f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/0/c */
    { 0x0d00, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/1/u */
    { 0x0d7f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/1/c */
    { 0x0e00, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/2/u */
    { 0x0e7f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/2/c */
    { 0x0f00, 0xc811, 0xf8a0, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/3/u */
    { 0x0f7f, 0xc811, 0x7820, RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f07,4830), RTFLOAT80U_INIT_C(0,0xd81f6a74eaad4f06,4830) }, /* #20/3/3/c */
    { 0x0000, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/0/u */
    { 0x007f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/0/c */
    { 0x0100, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/1/u */
    { 0x017f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/1/c */
    { 0x0200, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/2/u */
    { 0x027f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/2/c */
    { 0x0300, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/3/u */
    { 0x037f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/0/3/c */
    { 0x0400, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/0/u */
    { 0x047f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/0/c */
    { 0x0500, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/1/u */
    { 0x057f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/1/c */
    { 0x0600, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/2/u */
    { 0x067f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/2/c */
    { 0x0700, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/3/u */
    { 0x077f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/1/3/c */
    { 0x0800, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/0/u */
    { 0x087f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/0/c */
    { 0x0900, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/1/u */
    { 0x097f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/1/c */
    { 0x0a00, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/2/u */
    { 0x0a7f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/2/c */
    { 0x0b00, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/3/u */
    { 0x0b7f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/2/3/c */
    { 0x0c00, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/0/u */
    { 0x0c7f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/0/c */
    { 0x0d00, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/1/u */
    { 0x0d7f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/1/c */
    { 0x0e00, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/2/u */
    { 0x0e7f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/2/c */
    { 0x0f00, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/3/u */
    { 0x0f7f, 0xf512, 0x7d00, RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319), RTFLOAT80U_INIT_C(0,0xdb358a019433e5d3,30319) }, /* #21/3/3/c */
    { 0x0000, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/0/0/u */
    { 0x007f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/0/c */
    { 0x0100, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/0/1/u */
    { 0x017f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/1/c */
    { 0x0200, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/0/2/u */
    { 0x027f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/2/c */
    { 0x0300, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/0/3/u */
    { 0x037f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/3/c */
    { 0x0400, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/1/0/u */
    { 0x047f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/0/c */
    { 0x0500, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/1/1/u */
    { 0x057f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/1/c */
    { 0x0600, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/1/2/u */
    { 0x067f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/2/c */
    { 0x0700, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/1/3/u */
    { 0x077f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/3/c */
    { 0x0800, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/2/0/u */
    { 0x087f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/0/c */
    { 0x0900, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/2/1/u */
    { 0x097f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/1/c */
    { 0x0a00, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/2/2/u */
    { 0x0a7f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/2/c */
    { 0x0b00, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/2/3/u */
    { 0x0b7f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/3/c */
    { 0x0c00, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/3/0/u */
    { 0x0c7f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/0/c */
    { 0x0d00, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/3/1/u */
    { 0x0d7f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/1/c */
    { 0x0e00, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/3/2/u */
    { 0x0e7f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/2/c */
    { 0x0f00, 0x3059, 0xb881, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118) }, /* #22/3/3/u */
    { 0x0f7f, 0x3059, 0x3801, RTFLOAT80U_INIT_C(0,0x22aba1b01acfd50,9118), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/3/c */
    { 0x0000, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/0/0/u */
    { 0x007f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/0/0/c */
    { 0x0100, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/0/1/u */
    { 0x017f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/0/1/c */
    { 0x0200, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/0/2/u */
    { 0x027f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/0/2/c */
    { 0x0300, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/0/3/u */
    { 0x037f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/0/3/c */
    { 0x0400, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/1/0/u */
    { 0x047f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/1/0/c */
    { 0x0500, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/1/1/u */
    { 0x057f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/1/1/c */
    { 0x0600, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/1/2/u */
    { 0x067f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/1/2/c */
    { 0x0700, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/1/3/u */
    { 0x077f, 0x2ad6, 0x3a22, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,1) }, /* #23/1/3/c */
    { 0x0800, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/2/0/u */
    { 0x087f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/2/0/c */
    { 0x0900, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/2/1/u */
    { 0x097f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/2/1/c */
    { 0x0a00, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/2/2/u */
    { 0x0a7f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/2/2/c */
    { 0x0b00, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/2/3/u */
    { 0x0b7f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/2/3/c */
    { 0x0c00, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/3/0/u */
    { 0x0c7f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/3/0/c */
    { 0x0d00, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/3/1/u */
    { 0x0d7f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/3/1/c */
    { 0x0e00, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/3/2/u */
    { 0x0e7f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/3/2/c */
    { 0x0f00, 0x2ad6, 0xb882, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0) }, /* #23/3/3/u */
    { 0x0f7f, 0x2ad6, 0x3822, RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f2,0), RTFLOAT80U_INIT_C(1,0x91e5ee0d3d2332f1,1) }, /* #23/3/3/c */
    { 0x0000, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/0/u */
    { 0x007f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/0/c */
    { 0x0100, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/1/u */
    { 0x017f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/1/c */
    { 0x0200, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/2/u */
    { 0x027f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/2/c */
    { 0x0300, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/3/u */
    { 0x037f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/0/3/c */
    { 0x0400, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/0/u */
    { 0x047f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/0/c */
    { 0x0500, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/1/u */
    { 0x057f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/1/c */
    { 0x0600, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/2/u */
    { 0x067f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/2/c */
    { 0x0700, 0x806c, 0xbaa0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/3/u */
    { 0x077f, 0x806c, 0x3a20, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957) }, /* #24/1/3/c */
    { 0x0800, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/0/u */
    { 0x087f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/0/c */
    { 0x0900, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/1/u */
    { 0x097f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/1/c */
    { 0x0a00, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/2/u */
    { 0x0a7f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/2/c */
    { 0x0b00, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/3/u */
    { 0x0b7f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/2/3/c */
    { 0x0c00, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/0/u */
    { 0x0c7f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/0/c */
    { 0x0d00, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/1/u */
    { 0x0d7f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/1/c */
    { 0x0e00, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/2/u */
    { 0x0e7f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/2/c */
    { 0x0f00, 0x806c, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/3/u */
    { 0x0f7f, 0x806c, 0x3820, RTFLOAT80U_INIT_C(1,0x8c924d9941f447bf,7957), RTFLOAT80U_INIT_C(1,0x8c924d9941f447be,7957) }, /* #24/3/3/c */
    { 0x0000, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/0/u */
    { 0x007f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/0/c */
    { 0x0100, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/1/u */
    { 0x017f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/1/c */
    { 0x0200, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/2/u */
    { 0x027f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/2/c */
    { 0x0300, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/3/u */
    { 0x037f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/0/3/c */
    { 0x0400, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/0/u */
    { 0x047f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/0/c */
    { 0x0500, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/1/u */
    { 0x057f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/1/c */
    { 0x0600, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/2/u */
    { 0x067f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/2/c */
    { 0x0700, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/3/u */
    { 0x077f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/1/3/c */
    { 0x0800, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/0/u */
    { 0x087f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/0/c */
    { 0x0900, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/1/u */
    { 0x097f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/1/c */
    { 0x0a00, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/2/u */
    { 0x0a7f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/2/c */
    { 0x0b00, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/3/u */
    { 0x0b7f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/2/3/c */
    { 0x0c00, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/0/u */
    { 0x0c7f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/0/c */
    { 0x0d00, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/1/u */
    { 0x0d7f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/1/c */
    { 0x0e00, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/2/u */
    { 0x0e7f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/2/c */
    { 0x0f00, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/3/u */
    { 0x0f7f, 0xdd2f, 0x7900, RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767), RTFLOAT80U_INIT_C(1,0xc6bb043eded83db4,32767) }, /* #25/3/3/c */
    { 0x0000, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/0/0/u */
    { 0x007f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/0/c */
    { 0x0100, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/0/1/u */
    { 0x017f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/1/c */
    { 0x0200, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/0/2/u */
    { 0x027f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/2/c */
    { 0x0300, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/0/3/u */
    { 0x037f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/3/c */
    { 0x0400, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/1/0/u */
    { 0x047f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/0/c */
    { 0x0500, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/1/1/u */
    { 0x057f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/1/c */
    { 0x0600, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/1/2/u */
    { 0x067f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/2/c */
    { 0x0700, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/1/3/u */
    { 0x077f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/3/c */
    { 0x0800, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/2/0/u */
    { 0x087f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/0/c */
    { 0x0900, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/2/1/u */
    { 0x097f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/1/c */
    { 0x0a00, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/2/2/u */
    { 0x0a7f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/2/c */
    { 0x0b00, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/2/3/u */
    { 0x0b7f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/3/c */
    { 0x0c00, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/3/0/u */
    { 0x0c7f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/0/c */
    { 0x0d00, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/3/1/u */
    { 0x0d7f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/1/c */
    { 0x0e00, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/3/2/u */
    { 0x0e7f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/2/c */
    { 0x0f00, 0xbc6f, 0xb881, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875) }, /* #26/3/3/u */
    { 0x0f7f, 0xbc6f, 0x3801, RTFLOAT80U_INIT_C(0,0x26a561a2e67470fa,1875), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/3/c */
    { 0x0000, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/0/0/u */
    { 0x007f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/0/c */
    { 0x0100, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/0/1/u */
    { 0x017f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/1/c */
    { 0x0200, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/0/2/u */
    { 0x027f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/2/c */
    { 0x0300, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/0/3/u */
    { 0x037f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/3/c */
    { 0x0400, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/1/0/u */
    { 0x047f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/0/c */
    { 0x0500, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/1/1/u */
    { 0x057f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/1/c */
    { 0x0600, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/1/2/u */
    { 0x067f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/2/c */
    { 0x0700, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/1/3/u */
    { 0x077f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/3/c */
    { 0x0800, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/2/0/u */
    { 0x087f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/0/c */
    { 0x0900, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/2/1/u */
    { 0x097f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/1/c */
    { 0x0a00, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/2/2/u */
    { 0x0a7f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/2/c */
    { 0x0b00, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/2/3/u */
    { 0x0b7f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/3/c */
    { 0x0c00, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/3/0/u */
    { 0x0c7f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/0/c */
    { 0x0d00, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/3/1/u */
    { 0x0d7f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/1/c */
    { 0x0e00, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/3/2/u */
    { 0x0e7f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/2/c */
    { 0x0f00, 0x2dd7, 0xb981, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254) }, /* #27/3/3/u */
    { 0x0f7f, 0x2dd7, 0x3901, RTFLOAT80U_INIT_C(0,0x5e9de71e07781c9a,29254), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/3/c */
    { 0x0000, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/0/u */
    { 0x007f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/0/c */
    { 0x0100, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/1/u */
    { 0x017f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/1/c */
    { 0x0200, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/2/u */
    { 0x027f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/2/c */
    { 0x0300, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/3/u */
    { 0x037f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/0/3/c */
    { 0x0400, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/0/u */
    { 0x047f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/0/c */
    { 0x0500, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/1/u */
    { 0x057f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/1/c */
    { 0x0600, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/2/u */
    { 0x067f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/2/c */
    { 0x0700, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/3/u */
    { 0x077f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/1/3/c */
    { 0x0800, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/0/u */
    { 0x087f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/0/c */
    { 0x0900, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/1/u */
    { 0x097f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/1/c */
    { 0x0a00, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/2/u */
    { 0x0a7f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/2/c */
    { 0x0b00, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/3/u */
    { 0x0b7f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/2/3/c */
    { 0x0c00, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/0/u */
    { 0x0c7f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/0/c */
    { 0x0d00, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/1/u */
    { 0x0d7f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/1/c */
    { 0x0e00, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/2/u */
    { 0x0e7f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/2/c */
    { 0x0f00, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/3/u */
    { 0x0f7f, 0x043b, 0x3c00, RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699), RTFLOAT80U_INIT_C(0,0x9b9449ba3173965b,24699) }, /* #28/3/3/c */
    { 0x0000, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/0/0/u */
    { 0x007f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/0/c */
    { 0x0100, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/0/1/u */
    { 0x017f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/1/c */
    { 0x0200, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/0/2/u */
    { 0x027f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/2/c */
    { 0x0300, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/0/3/u */
    { 0x037f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/0/3/c */
    { 0x0400, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/1/0/u */
    { 0x047f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/0/c */
    { 0x0500, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/1/1/u */
    { 0x057f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/1/c */
    { 0x0600, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/1/2/u */
    { 0x067f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/2/c */
    { 0x0700, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/1/3/u */
    { 0x077f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/1/3/c */
    { 0x0800, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/2/0/u */
    { 0x087f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/0/c */
    { 0x0900, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/2/1/u */
    { 0x097f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/1/c */
    { 0x0a00, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/2/2/u */
    { 0x0a7f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/2/c */
    { 0x0b00, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/2/3/u */
    { 0x0b7f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/2/3/c */
    { 0x0c00, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/3/0/u */
    { 0x0c7f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/0/c */
    { 0x0d00, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/3/1/u */
    { 0x0d7f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/1/c */
    { 0x0e00, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/3/2/u */
    { 0x0e7f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/2/c */
    { 0x0f00, 0x4868, 0xf881, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767) }, /* #29/3/3/u */
    { 0x0f7f, 0x4868, 0x7801, RTFLOAT80U_INIT_C(1,0x2b07e787954ce3ed,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #29/3/3/c */
    { 0x0000, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/0/u */
    { 0x007f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/0/c */
    { 0x0100, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/1/u */
    { 0x017f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/1/c */
    { 0x0200, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/2/u */
    { 0x027f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/2/c */
    { 0x0300, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/3/u */
    { 0x037f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/0/3/c */
    { 0x0400, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/0/u */
    { 0x047f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/0/c */
    { 0x0500, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/1/u */
    { 0x057f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/1/c */
    { 0x0600, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/2/u */
    { 0x067f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/2/c */
    { 0x0700, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/3/u */
    { 0x077f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/1/3/c */
    { 0x0800, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/0/u */
    { 0x087f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/0/c */
    { 0x0900, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/1/u */
    { 0x097f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/1/c */
    { 0x0a00, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/2/u */
    { 0x0a7f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/2/c */
    { 0x0b00, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/3/u */
    { 0x0b7f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/2/3/c */
    { 0x0c00, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/0/u */
    { 0x0c7f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/0/c */
    { 0x0d00, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/1/u */
    { 0x0d7f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/1/c */
    { 0x0e00, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/2/u */
    { 0x0e7f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/2/c */
    { 0x0f00, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/3/u */
    { 0x0f7f, 0x8bbe, 0x3900, RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767), RTFLOAT80U_INIT_C(0,0xe5c44082a661d906,32767) }, /* #30/3/3/c */
    { 0x0000, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/0/0/u */
    { 0x007f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/0/c */
    { 0x0100, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/0/1/u */
    { 0x017f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/1/c */
    { 0x0200, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/0/2/u */
    { 0x027f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/2/c */
    { 0x0300, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/0/3/u */
    { 0x037f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/3/c */
    { 0x0400, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/1/0/u */
    { 0x047f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/0/c */
    { 0x0500, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/1/1/u */
    { 0x057f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/1/c */
    { 0x0600, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/1/2/u */
    { 0x067f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/2/c */
    { 0x0700, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/1/3/u */
    { 0x077f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/3/c */
    { 0x0800, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/2/0/u */
    { 0x087f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/0/c */
    { 0x0900, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/2/1/u */
    { 0x097f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/1/c */
    { 0x0a00, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/2/2/u */
    { 0x0a7f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/2/c */
    { 0x0b00, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/2/3/u */
    { 0x0b7f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/3/c */
    { 0x0c00, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/3/0/u */
    { 0x0c7f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/0/c */
    { 0x0d00, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/3/1/u */
    { 0x0d7f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/1/c */
    { 0x0e00, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/3/2/u */
    { 0x0e7f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/2/c */
    { 0x0f00, 0x49f1, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #31/3/3/u */
    { 0x0f7f, 0x49f1, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/3/c */
    { 0x0000, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/0/u */
    { 0x007f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/0/c */
    { 0x0100, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/1/u */
    { 0x017f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/1/c */
    { 0x0200, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/2/u */
    { 0x027f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/2/c */
    { 0x0300, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/3/u */
    { 0x037f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/0/3/c */
    { 0x0400, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/0/u */
    { 0x047f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/0/c */
    { 0x0500, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/1/u */
    { 0x057f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/1/c */
    { 0x0600, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/2/u */
    { 0x067f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/2/c */
    { 0x0700, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/3/u */
    { 0x077f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/1/3/c */
    { 0x0800, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/0/u */
    { 0x087f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/0/c */
    { 0x0900, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/1/u */
    { 0x097f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/1/c */
    { 0x0a00, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/2/u */
    { 0x0a7f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/2/c */
    { 0x0b00, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/3/u */
    { 0x0b7f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/2/3/c */
    { 0x0c00, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/0/u */
    { 0x0c7f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/0/c */
    { 0x0d00, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/1/u */
    { 0x0d7f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/1/c */
    { 0x0e00, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/2/u */
    { 0x0e7f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/2/c */
    { 0x0f00, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/3/u */
    { 0x0f7f, 0xb414, 0x3c00, RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634), RTFLOAT80U_INIT_C(1,0x811bda83870694ef,28634) }, /* #32/3/3/c */
    { 0x0000, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/0/u */
    { 0x007f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/0/c */
    { 0x0100, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/1/u */
    { 0x017f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/1/c */
    { 0x0200, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/2/u */
    { 0x027f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/2/c */
    { 0x0300, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/3/u */
    { 0x037f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/0/3/c */
    { 0x0400, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/0/u */
    { 0x047f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/0/c */
    { 0x0500, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/1/u */
    { 0x057f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/1/c */
    { 0x0600, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/2/u */
    { 0x067f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/2/c */
    { 0x0700, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/3/u */
    { 0x077f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/1/3/c */
    { 0x0800, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/0/u */
    { 0x087f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/0/c */
    { 0x0900, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/1/u */
    { 0x097f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/1/c */
    { 0x0a00, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/2/u */
    { 0x0a7f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/2/c */
    { 0x0b00, 0x186d, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/3/u */
    { 0x0b7f, 0x186d, 0x3a20, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885) }, /* #33/2/3/c */
    { 0x0c00, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/0/u */
    { 0x0c7f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/0/c */
    { 0x0d00, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/1/u */
    { 0x0d7f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/1/c */
    { 0x0e00, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/2/u */
    { 0x0e7f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/2/c */
    { 0x0f00, 0x186d, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/3/u */
    { 0x0f7f, 0x186d, 0x3820, RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19d,10885), RTFLOAT80U_INIT_C(0,0x9729d8bc7b1bb19c,10885) }, /* #33/3/3/c */
    { 0x0000, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/0/u */
    { 0x007f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/0/c */
    { 0x0100, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/1/u */
    { 0x017f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/1/c */
    { 0x0200, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/2/u */
    { 0x027f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/2/c */
    { 0x0300, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/3/u */
    { 0x037f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/0/3/c */
    { 0x0400, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/0/u */
    { 0x047f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/0/c */
    { 0x0500, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/1/u */
    { 0x057f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/1/c */
    { 0x0600, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/2/u */
    { 0x067f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/2/c */
    { 0x0700, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/3/u */
    { 0x077f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/1/3/c */
    { 0x0800, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/0/u */
    { 0x087f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/0/c */
    { 0x0900, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/1/u */
    { 0x097f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/1/c */
    { 0x0a00, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/2/u */
    { 0x0a7f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/2/c */
    { 0x0b00, 0xb66f, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/3/u */
    { 0x0b7f, 0xb66f, 0x3a20, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748) }, /* #34/2/3/c */
    { 0x0c00, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/0/u */
    { 0x0c7f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/0/c */
    { 0x0d00, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/1/u */
    { 0x0d7f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/1/c */
    { 0x0e00, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/2/u */
    { 0x0e7f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/2/c */
    { 0x0f00, 0xb66f, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/3/u */
    { 0x0f7f, 0xb66f, 0x3820, RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add6,7748), RTFLOAT80U_INIT_C(0,0xe4bbcfd6a581add5,7748) }, /* #34/3/3/c */
    { 0x0000, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/0/u */
    { 0x007f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/0/c */
    { 0x0100, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/1/u */
    { 0x017f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/1/c */
    { 0x0200, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/2/u */
    { 0x027f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/2/c */
    { 0x0300, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/3/u */
    { 0x037f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/0/3/c */
    { 0x0400, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/0/u */
    { 0x047f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/0/c */
    { 0x0500, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/1/u */
    { 0x057f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/1/c */
    { 0x0600, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/2/u */
    { 0x067f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/2/c */
    { 0x0700, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/3/u */
    { 0x077f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/1/3/c */
    { 0x0800, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/0/u */
    { 0x087f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/0/c */
    { 0x0900, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/1/u */
    { 0x097f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/1/c */
    { 0x0a00, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/2/u */
    { 0x0a7f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/2/c */
    { 0x0b00, 0x8a9c, 0xbaa0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/3/u */
    { 0x0b7f, 0x8a9c, 0x3a20, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886) }, /* #35/2/3/c */
    { 0x0c00, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/0/u */
    { 0x0c7f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/0/c */
    { 0x0d00, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/1/u */
    { 0x0d7f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/1/c */
    { 0x0e00, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/2/u */
    { 0x0e7f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/2/c */
    { 0x0f00, 0x8a9c, 0xb8a0, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/3/u */
    { 0x0f7f, 0x8a9c, 0x3820, RTFLOAT80U_INIT_C(0,0xfec915a17e926b66,15886), RTFLOAT80U_INIT_C(0,0xfec915a17e926b65,15886) }, /* #35/3/3/c */
    { 0x0000, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/0/0/u */
    { 0x007f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/0/c */
    { 0x0100, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/0/1/u */
    { 0x017f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/1/c */
    { 0x0200, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/0/2/u */
    { 0x027f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/2/c */
    { 0x0300, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/0/3/u */
    { 0x037f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/3/c */
    { 0x0400, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/1/0/u */
    { 0x047f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/0/c */
    { 0x0500, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/1/1/u */
    { 0x057f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/1/c */
    { 0x0600, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/1/2/u */
    { 0x067f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/2/c */
    { 0x0700, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/1/3/u */
    { 0x077f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/3/c */
    { 0x0800, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/2/0/u */
    { 0x087f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/0/c */
    { 0x0900, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/2/1/u */
    { 0x097f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/1/c */
    { 0x0a00, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/2/2/u */
    { 0x0a7f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/2/c */
    { 0x0b00, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/2/3/u */
    { 0x0b7f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/3/c */
    { 0x0c00, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/3/0/u */
    { 0x0c7f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/0/c */
    { 0x0d00, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/3/1/u */
    { 0x0d7f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/1/c */
    { 0x0e00, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/3/2/u */
    { 0x0e7f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/2/c */
    { 0x0f00, 0xcb95, 0xf981, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(0,0x3,31795) }, /* #36/3/3/u */
    { 0x0f7f, 0xcb95, 0x7901, RTFLOAT80U_INIT_C(0,0x3,31795), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/3/c */
    { 0x0000, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/0/0/u */
    { 0x007f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/0/0/c */
    { 0x0100, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/0/1/u */
    { 0x017f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/0/1/c */
    { 0x0200, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/0/2/u */
    { 0x027f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/0/2/c */
    { 0x0300, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/0/3/u */
    { 0x037f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/0/3/c */
    { 0x0400, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/1/0/u */
    { 0x047f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/1/0/c */
    { 0x0500, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/1/1/u */
    { 0x057f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/1/1/c */
    { 0x0600, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/1/2/u */
    { 0x067f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/1/2/c */
    { 0x0700, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/1/3/u */
    { 0x077f, 0x2d06, 0x3b22, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,1) }, /* #37/1/3/c */
    { 0x0800, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/2/0/u */
    { 0x087f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/2/0/c */
    { 0x0900, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/2/1/u */
    { 0x097f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/2/1/c */
    { 0x0a00, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/2/2/u */
    { 0x0a7f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/2/2/c */
    { 0x0b00, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/2/3/u */
    { 0x0b7f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/2/3/c */
    { 0x0c00, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/3/0/u */
    { 0x0c7f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/3/0/c */
    { 0x0d00, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/3/1/u */
    { 0x0d7f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/3/1/c */
    { 0x0e00, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/3/2/u */
    { 0x0e7f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/3/2/c */
    { 0x0f00, 0x2d06, 0xb982, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0) }, /* #37/3/3/u */
    { 0x0f7f, 0x2d06, 0x3922, RTFLOAT80U_INIT_C(1,0x800000142a6e371b,0), RTFLOAT80U_INIT_C(1,0x800000142a6e371a,1) }, /* #37/3/3/c */
    { 0x0000, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/0/u */
    { 0x007f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/0/c */
    { 0x0100, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/1/u */
    { 0x017f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/1/c */
    { 0x0200, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/2/u */
    { 0x027f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/2/c */
    { 0x0300, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/3/u */
    { 0x037f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/0/3/c */
    { 0x0400, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/1/0/u */
    { 0x047f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/1/0/c */
    { 0x0500, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/1/1/u */
    { 0x057f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/1/1/c */
    { 0x0600, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/1/2/u */
    { 0x067f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/1/2/c */
    { 0x0700, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/1/3/u */
    { 0x077f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/1/3/c */
    { 0x0800, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/0/u */
    { 0x087f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/0/c */
    { 0x0900, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/1/u */
    { 0x097f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/1/c */
    { 0x0a00, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/2/u */
    { 0x0a7f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/2/c */
    { 0x0b00, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/3/u */
    { 0x0b7f, 0x18a8, 0x3a32, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/2/3/c */
    { 0x0c00, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/3/0/u */
    { 0x0c7f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/3/0/c */
    { 0x0d00, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/3/1/u */
    { 0x0d7f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/3/1/c */
    { 0x0e00, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/3/2/u */
    { 0x0e7f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/3/2/c */
    { 0x0f00, 0x18a8, 0xb882, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0) }, /* #38/3/3/u */
    { 0x0f7f, 0x18a8, 0x3832, RTFLOAT80U_INIT_C(0,0xed82e48f6e0876,0), RTFLOAT80U_INIT_C(0,0xed82e48f6e0875,0) }, /* #38/3/3/c */
    { 0x0000, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/0/0/u */
    { 0x007f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/0/0/c */
    { 0x0100, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/0/1/u */
    { 0x017f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/0/1/c */
    { 0x0200, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/0/2/u */
    { 0x027f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/0/2/c */
    { 0x0300, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/0/3/u */
    { 0x037f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/0/3/c */
    { 0x0400, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/1/0/u */
    { 0x047f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/1/0/c */
    { 0x0500, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/1/1/u */
    { 0x057f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/1/1/c */
    { 0x0600, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/1/2/u */
    { 0x067f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/1/2/c */
    { 0x0700, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/1/3/u */
    { 0x077f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/1/3/c */
    { 0x0800, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/2/0/u */
    { 0x087f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/2/0/c */
    { 0x0900, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/2/1/u */
    { 0x097f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/2/1/c */
    { 0x0a00, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/2/2/u */
    { 0x0a7f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/2/2/c */
    { 0x0b00, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/2/3/u */
    { 0x0b7f, 0xee9b, 0x7a22, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,1) }, /* #39/2/3/c */
    { 0x0c00, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/3/0/u */
    { 0x0c7f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/3/0/c */
    { 0x0d00, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/3/1/u */
    { 0x0d7f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/3/1/c */
    { 0x0e00, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/3/2/u */
    { 0x0e7f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/3/2/c */
    { 0x0f00, 0xee9b, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #39/3/3/u */
    { 0x0f7f, 0xee9b, 0x7822, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT80U_INIT_C(0,0x8000000000000002,1) }, /* #39/3/3/c */
    { 0x0000, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/0/0/u */
    { 0x007f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/0/c */
    { 0x0100, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/0/1/u */
    { 0x017f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/1/c */
    { 0x0200, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/0/2/u */
    { 0x027f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/2/c */
    { 0x0300, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/0/3/u */
    { 0x037f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/3/c */
    { 0x0400, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/1/0/u */
    { 0x047f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/0/c */
    { 0x0500, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/1/1/u */
    { 0x057f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/1/c */
    { 0x0600, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/1/2/u */
    { 0x067f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/2/c */
    { 0x0700, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/1/3/u */
    { 0x077f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/3/c */
    { 0x0800, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/2/0/u */
    { 0x087f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/0/c */
    { 0x0900, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/2/1/u */
    { 0x097f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/1/c */
    { 0x0a00, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/2/2/u */
    { 0x0a7f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/2/c */
    { 0x0b00, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/2/3/u */
    { 0x0b7f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/3/c */
    { 0x0c00, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/3/0/u */
    { 0x0c7f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/0/c */
    { 0x0d00, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/3/1/u */
    { 0x0d7f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/1/c */
    { 0x0e00, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/3/2/u */
    { 0x0e7f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/2/c */
    { 0x0f00, 0x1889, 0xb881, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176) }, /* #40/3/3/u */
    { 0x0f7f, 0x1889, 0x3801, RTFLOAT80U_INIT_C(1,0x687543b8f6b02d68,31176), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/3/c */
    { 0x0000, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/0/u */
    { 0x007f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/0/c */
    { 0x0100, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/1/u */
    { 0x017f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/1/c */
    { 0x0200, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/2/u */
    { 0x027f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/2/c */
    { 0x0300, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/3/u */
    { 0x037f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/0/3/c */
    { 0x0400, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/0/u */
    { 0x047f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/0/c */
    { 0x0500, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/1/u */
    { 0x057f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/1/c */
    { 0x0600, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/2/u */
    { 0x067f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/2/c */
    { 0x0700, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/3/u */
    { 0x077f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/1/3/c */
    { 0x0800, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/0/u */
    { 0x087f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/0/c */
    { 0x0900, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/1/u */
    { 0x097f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/1/c */
    { 0x0a00, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/2/u */
    { 0x0a7f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/2/c */
    { 0x0b00, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/3/u */
    { 0x0b7f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/2/3/c */
    { 0x0c00, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/0/u */
    { 0x0c7f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/0/c */
    { 0x0d00, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/1/u */
    { 0x0d7f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/1/c */
    { 0x0e00, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/2/u */
    { 0x0e7f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/2/c */
    { 0x0f00, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/3/u */
    { 0x0f7f, 0x1ae8, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #41/3/3/c */
    { 0x0000, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/0/u */
    { 0x007f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/0/c */
    { 0x0100, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/1/u */
    { 0x017f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/1/c */
    { 0x0200, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/2/u */
    { 0x027f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/2/c */
    { 0x0300, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/3/u */
    { 0x037f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/0/3/c */
    { 0x0400, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/0/u */
    { 0x047f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/0/c */
    { 0x0500, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/1/u */
    { 0x057f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/1/c */
    { 0x0600, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/2/u */
    { 0x067f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/2/c */
    { 0x0700, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/3/u */
    { 0x077f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/1/3/c */
    { 0x0800, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/0/u */
    { 0x087f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/0/c */
    { 0x0900, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/1/u */
    { 0x097f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/1/c */
    { 0x0a00, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/2/u */
    { 0x0a7f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/2/c */
    { 0x0b00, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/3/u */
    { 0x0b7f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/2/3/c */
    { 0x0c00, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/0/u */
    { 0x0c7f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/0/c */
    { 0x0d00, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/1/u */
    { 0x0d7f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/1/c */
    { 0x0e00, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/2/u */
    { 0x0e7f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/2/c */
    { 0x0f00, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/3/u */
    { 0x0f7f, 0x8ec1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708), RTFLOAT80U_INIT_C(0,0xbcf257ae7f297d8f,32708) }, /* #42/3/3/c */
    { 0x0000, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/0/u */
    { 0x007f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/0/c */
    { 0x0100, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/1/u */
    { 0x017f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/1/c */
    { 0x0200, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/2/u */
    { 0x027f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/2/c */
    { 0x0300, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/3/u */
    { 0x037f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/0/3/c */
    { 0x0400, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/0/u */
    { 0x047f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/0/c */
    { 0x0500, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/1/u */
    { 0x057f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/1/c */
    { 0x0600, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/2/u */
    { 0x067f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/2/c */
    { 0x0700, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/3/u */
    { 0x077f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/1/3/c */
    { 0x0800, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/0/u */
    { 0x087f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/0/c */
    { 0x0900, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/1/u */
    { 0x097f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/1/c */
    { 0x0a00, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/2/u */
    { 0x0a7f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/2/c */
    { 0x0b00, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/3/u */
    { 0x0b7f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/2/3/c */
    { 0x0c00, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/0/u */
    { 0x0c7f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/0/c */
    { 0x0d00, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/1/u */
    { 0x0d7f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/1/c */
    { 0x0e00, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/2/u */
    { 0x0e7f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/2/c */
    { 0x0f00, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/3/u */
    { 0x0f7f, 0x7d66, 0x7900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #43/3/3/c */
    { 0x0000, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/0/u */
    { 0x007f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/0/c */
    { 0x0100, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/1/u */
    { 0x017f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/1/c */
    { 0x0200, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/2/u */
    { 0x027f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/2/c */
    { 0x0300, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/3/u */
    { 0x037f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/0/3/c */
    { 0x0400, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/1/0/u */
    { 0x047f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/1/0/c */
    { 0x0500, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/1/1/u */
    { 0x057f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/1/1/c */
    { 0x0600, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/1/2/u */
    { 0x067f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/1/2/c */
    { 0x0700, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/1/3/u */
    { 0x077f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/1/3/c */
    { 0x0800, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/0/u */
    { 0x087f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/0/c */
    { 0x0900, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/1/u */
    { 0x097f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/1/c */
    { 0x0a00, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/2/u */
    { 0x0a7f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/2/c */
    { 0x0b00, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/3/u */
    { 0x0b7f, 0x4399, 0x7b32, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/2/3/c */
    { 0x0c00, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/3/0/u */
    { 0x0c7f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/3/0/c */
    { 0x0d00, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/3/1/u */
    { 0x0d7f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/3/1/c */
    { 0x0e00, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/3/2/u */
    { 0x0e7f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/3/2/c */
    { 0x0f00, 0x4399, 0xf982, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #44/3/3/u */
    { 0x0f7f, 0x4399, 0x7932, RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x6,0) }, /* #44/3/3/c */
    { 0x0000, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/0/u */
    { 0x007f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/0/c */
    { 0x0100, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/1/u */
    { 0x017f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/1/c */
    { 0x0200, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/2/u */
    { 0x027f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/2/c */
    { 0x0300, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/3/u */
    { 0x037f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/0/3/c */
    { 0x0400, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/0/u */
    { 0x047f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/0/c */
    { 0x0500, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/1/u */
    { 0x057f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/1/c */
    { 0x0600, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/2/u */
    { 0x067f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/2/c */
    { 0x0700, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/3/u */
    { 0x077f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/1/3/c */
    { 0x0800, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/0/u */
    { 0x087f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/0/c */
    { 0x0900, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/1/u */
    { 0x097f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/1/c */
    { 0x0a00, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/2/u */
    { 0x0a7f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/2/c */
    { 0x0b00, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/3/u */
    { 0x0b7f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/2/3/c */
    { 0x0c00, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/0/u */
    { 0x0c7f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/0/c */
    { 0x0d00, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/1/u */
    { 0x0d7f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/1/c */
    { 0x0e00, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/2/u */
    { 0x0e7f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/2/c */
    { 0x0f00, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/3/u */
    { 0x0f7f, 0xc7e7, 0x7900, RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767), RTFLOAT80U_INIT_C(0,0xeff5c7fbd3e31f49,32767) }, /* #45/3/3/c */
    { 0x0000, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/0/0/u */
    { 0x007f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/0/c */
    { 0x0100, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/0/1/u */
    { 0x017f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/1/c */
    { 0x0200, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/0/2/u */
    { 0x027f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/2/c */
    { 0x0300, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/0/3/u */
    { 0x037f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/3/c */
    { 0x0400, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/1/0/u */
    { 0x047f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/0/c */
    { 0x0500, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/1/1/u */
    { 0x057f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/1/c */
    { 0x0600, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/1/2/u */
    { 0x067f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/2/c */
    { 0x0700, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/1/3/u */
    { 0x077f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/3/c */
    { 0x0800, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/2/0/u */
    { 0x087f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/0/c */
    { 0x0900, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/2/1/u */
    { 0x097f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/1/c */
    { 0x0a00, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/2/2/u */
    { 0x0a7f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/2/c */
    { 0x0b00, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/2/3/u */
    { 0x0b7f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/3/c */
    { 0x0c00, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/3/0/u */
    { 0x0c7f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/0/c */
    { 0x0d00, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/3/1/u */
    { 0x0d7f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/1/c */
    { 0x0e00, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/3/2/u */
    { 0x0e7f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/2/c */
    { 0x0f00, 0x06ef, 0xb881, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167) }, /* #46/3/3/u */
    { 0x0f7f, 0x06ef, 0x3801, RTFLOAT80U_INIT_C(1,0x72b24f55195c2d8c,4167), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/3/c */
    { 0x0000, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/0/u */
    { 0x007f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/0/c */
    { 0x0100, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/1/u */
    { 0x017f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/1/c */
    { 0x0200, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/2/u */
    { 0x027f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/2/c */
    { 0x0300, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/3/u */
    { 0x037f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/0/3/c */
    { 0x0400, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/0/u */
    { 0x047f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/0/c */
    { 0x0500, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/1/u */
    { 0x057f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/1/c */
    { 0x0600, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/2/u */
    { 0x067f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/2/c */
    { 0x0700, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/3/u */
    { 0x077f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/1/3/c */
    { 0x0800, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/0/u */
    { 0x087f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/0/c */
    { 0x0900, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/1/u */
    { 0x097f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/1/c */
    { 0x0a00, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/2/u */
    { 0x0a7f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/2/c */
    { 0x0b00, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/3/u */
    { 0x0b7f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/2/3/c */
    { 0x0c00, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/0/u */
    { 0x0c7f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/0/c */
    { 0x0d00, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/1/u */
    { 0x0d7f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/1/c */
    { 0x0e00, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/2/u */
    { 0x0e7f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/2/c */
    { 0x0f00, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/3/u */
    { 0x0f7f, 0xeea3, 0x7c00, RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750), RTFLOAT80U_INIT_C(0,0xb3f7822975a25301,27750) }, /* #47/3/3/c */
    { 0x0000, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/0/0/u */
    { 0x007f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/0/c */
    { 0x0100, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/0/1/u */
    { 0x017f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/1/c */
    { 0x0200, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/0/2/u */
    { 0x027f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/2/c */
    { 0x0300, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/0/3/u */
    { 0x037f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/3/c */
    { 0x0400, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/1/0/u */
    { 0x047f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/0/c */
    { 0x0500, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/1/1/u */
    { 0x057f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/1/c */
    { 0x0600, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/1/2/u */
    { 0x067f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/2/c */
    { 0x0700, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/1/3/u */
    { 0x077f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/3/c */
    { 0x0800, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/2/0/u */
    { 0x087f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/0/c */
    { 0x0900, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/2/1/u */
    { 0x097f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/1/c */
    { 0x0a00, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/2/2/u */
    { 0x0a7f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/2/c */
    { 0x0b00, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/2/3/u */
    { 0x0b7f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/3/c */
    { 0x0c00, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/3/0/u */
    { 0x0c7f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/0/c */
    { 0x0d00, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/3/1/u */
    { 0x0d7f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/1/c */
    { 0x0e00, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/3/2/u */
    { 0x0e7f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/2/c */
    { 0x0f00, 0x7c35, 0xf881, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739) }, /* #48/3/3/u */
    { 0x0f7f, 0x7c35, 0x7801, RTFLOAT80U_INIT_C(0,0x328b86edfb441438,27739), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/3/c */
    { 0x0000, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/0/0/u */
    { 0x007f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/0/c */
    { 0x0100, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/0/1/u */
    { 0x017f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/1/c */
    { 0x0200, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/0/2/u */
    { 0x027f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/2/c */
    { 0x0300, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/0/3/u */
    { 0x037f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/3/c */
    { 0x0400, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/1/0/u */
    { 0x047f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/0/c */
    { 0x0500, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/1/1/u */
    { 0x057f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/1/c */
    { 0x0600, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/1/2/u */
    { 0x067f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/2/c */
    { 0x0700, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/1/3/u */
    { 0x077f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/3/c */
    { 0x0800, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/2/0/u */
    { 0x087f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/0/c */
    { 0x0900, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/2/1/u */
    { 0x097f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/1/c */
    { 0x0a00, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/2/2/u */
    { 0x0a7f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/2/c */
    { 0x0b00, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/2/3/u */
    { 0x0b7f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/3/c */
    { 0x0c00, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/3/0/u */
    { 0x0c7f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/0/c */
    { 0x0d00, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/3/1/u */
    { 0x0d7f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/1/c */
    { 0x0e00, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/3/2/u */
    { 0x0e7f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/2/c */
    { 0x0f00, 0xc758, 0xf981, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882) }, /* #49/3/3/u */
    { 0x0f7f, 0xc758, 0x7901, RTFLOAT80U_INIT_C(1,0x7c89e2feacb18ca9,20882), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/3/c */
    { 0x0000, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/0/u */
    { 0x007f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/0/c */
    { 0x0100, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/1/u */
    { 0x017f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/1/c */
    { 0x0200, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/2/u */
    { 0x027f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/2/c */
    { 0x0300, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/3/u */
    { 0x037f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/0/3/c */
    { 0x0400, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/0/u */
    { 0x047f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/0/c */
    { 0x0500, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/1/u */
    { 0x057f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/1/c */
    { 0x0600, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/2/u */
    { 0x067f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/2/c */
    { 0x0700, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/3/u */
    { 0x077f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/1/3/c */
    { 0x0800, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/0/u */
    { 0x087f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/0/c */
    { 0x0900, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/1/u */
    { 0x097f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/1/c */
    { 0x0a00, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/2/u */
    { 0x0a7f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/2/c */
    { 0x0b00, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/3/u */
    { 0x0b7f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/2/3/c */
    { 0x0c00, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/0/u */
    { 0x0c7f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/0/c */
    { 0x0d00, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/1/u */
    { 0x0d7f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/1/c */
    { 0x0e00, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/2/u */
    { 0x0e7f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/2/c */
    { 0x0f00, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/3/u */
    { 0x0f7f, 0x0449, 0x3c00, RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769), RTFLOAT80U_INIT_C(0,0xac3e776bfc4076e7,18769) }, /* #50/3/3/c */
    { 0x0000, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/0/u */
    { 0x007f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/0/c */
    { 0x0100, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/1/u */
    { 0x017f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/1/c */
    { 0x0200, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/2/u */
    { 0x027f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/2/c */
    { 0x0300, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/3/u */
    { 0x037f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/0/3/c */
    { 0x0400, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/0/u */
    { 0x047f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/0/c */
    { 0x0500, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/1/u */
    { 0x057f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/1/c */
    { 0x0600, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/2/u */
    { 0x067f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/2/c */
    { 0x0700, 0x5de1, 0xfba0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/3/u */
    { 0x077f, 0x5de1, 0x7b20, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645) }, /* #51/1/3/c */
    { 0x0800, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/0/u */
    { 0x087f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/0/c */
    { 0x0900, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/1/u */
    { 0x097f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/1/c */
    { 0x0a00, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/2/u */
    { 0x0a7f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/2/c */
    { 0x0b00, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/3/u */
    { 0x0b7f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/2/3/c */
    { 0x0c00, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/0/u */
    { 0x0c7f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/0/c */
    { 0x0d00, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/1/u */
    { 0x0d7f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/1/c */
    { 0x0e00, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/2/u */
    { 0x0e7f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/2/c */
    { 0x0f00, 0x5de1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/3/u */
    { 0x0f7f, 0x5de1, 0x7920, RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5be0,15645), RTFLOAT80U_INIT_C(1,0x9ab3dfa8203c5bdf,15645) }, /* #51/3/3/c */
    { 0x0000, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/0/u */
    { 0x007f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/0/c */
    { 0x0100, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/1/u */
    { 0x017f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/1/c */
    { 0x0200, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/2/u */
    { 0x027f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/2/c */
    { 0x0300, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/3/u */
    { 0x037f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/0/3/c */
    { 0x0400, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/0/u */
    { 0x047f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/0/c */
    { 0x0500, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/1/u */
    { 0x057f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/1/c */
    { 0x0600, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/2/u */
    { 0x067f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/2/c */
    { 0x0700, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/3/u */
    { 0x077f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/1/3/c */
    { 0x0800, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/0/u */
    { 0x087f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/0/c */
    { 0x0900, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/1/u */
    { 0x097f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/1/c */
    { 0x0a00, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/2/u */
    { 0x0a7f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/2/c */
    { 0x0b00, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/3/u */
    { 0x0b7f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/2/3/c */
    { 0x0c00, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/0/u */
    { 0x0c7f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/0/c */
    { 0x0d00, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/1/u */
    { 0x0d7f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/1/c */
    { 0x0e00, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/2/u */
    { 0x0e7f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/2/c */
    { 0x0f00, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/3/u */
    { 0x0f7f, 0x6a6a, 0x7c00, RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680), RTFLOAT80U_INIT_C(1,0xbac7ffa303b37506,30680) }, /* #52/3/3/c */
    { 0x0000, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/0/u */
    { 0x007f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/0/c */
    { 0x0100, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/1/u */
    { 0x017f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/1/c */
    { 0x0200, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/2/u */
    { 0x027f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/2/c */
    { 0x0300, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/3/u */
    { 0x037f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/0/3/c */
    { 0x0400, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/0/u */
    { 0x047f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/0/c */
    { 0x0500, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/1/u */
    { 0x057f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/1/c */
    { 0x0600, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/2/u */
    { 0x067f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/2/c */
    { 0x0700, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/3/u */
    { 0x077f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/1/3/c */
    { 0x0800, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/0/u */
    { 0x087f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/0/c */
    { 0x0900, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/1/u */
    { 0x097f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/1/c */
    { 0x0a00, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/2/u */
    { 0x0a7f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/2/c */
    { 0x0b00, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/3/u */
    { 0x0b7f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/2/3/c */
    { 0x0c00, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/0/u */
    { 0x0c7f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/0/c */
    { 0x0d00, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/1/u */
    { 0x0d7f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/1/c */
    { 0x0e00, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/2/u */
    { 0x0e7f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/2/c */
    { 0x0f00, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/3/u */
    { 0x0f7f, 0x4263, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #53/3/3/c */
    { 0x0000, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/0/u */
    { 0x007f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/0/c */
    { 0x0100, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/1/u */
    { 0x017f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/1/c */
    { 0x0200, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/2/u */
    { 0x027f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/2/c */
    { 0x0300, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/3/u */
    { 0x037f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/0/3/c */
    { 0x0400, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/0/u */
    { 0x047f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/0/c */
    { 0x0500, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/1/u */
    { 0x057f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/1/c */
    { 0x0600, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/2/u */
    { 0x067f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/2/c */
    { 0x0700, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/3/u */
    { 0x077f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/1/3/c */
    { 0x0800, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/0/u */
    { 0x087f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/0/c */
    { 0x0900, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/1/u */
    { 0x097f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/1/c */
    { 0x0a00, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/2/u */
    { 0x0a7f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/2/c */
    { 0x0b00, 0x3473, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/3/u */
    { 0x0b7f, 0x3473, 0x3a20, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481) }, /* #54/2/3/c */
    { 0x0c00, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/0/u */
    { 0x0c7f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/0/c */
    { 0x0d00, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/1/u */
    { 0x0d7f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/1/c */
    { 0x0e00, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/2/u */
    { 0x0e7f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/2/c */
    { 0x0f00, 0x3473, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/3/u */
    { 0x0f7f, 0x3473, 0x3820, RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0ab,14481), RTFLOAT80U_INIT_C(0,0xa30c5c9cc268a0aa,14481) }, /* #54/3/3/c */
    { 0x0000, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/0/0/u */
    { 0x007f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/0/c */
    { 0x0100, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/0/1/u */
    { 0x017f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/1/c */
    { 0x0200, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/0/2/u */
    { 0x027f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/2/c */
    { 0x0300, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/0/3/u */
    { 0x037f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/3/c */
    { 0x0400, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/1/0/u */
    { 0x047f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/0/c */
    { 0x0500, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/1/1/u */
    { 0x057f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/1/c */
    { 0x0600, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/1/2/u */
    { 0x067f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/2/c */
    { 0x0700, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/1/3/u */
    { 0x077f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/3/c */
    { 0x0800, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/2/0/u */
    { 0x087f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/0/c */
    { 0x0900, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/2/1/u */
    { 0x097f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/1/c */
    { 0x0a00, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/2/2/u */
    { 0x0a7f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/2/c */
    { 0x0b00, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/2/3/u */
    { 0x0b7f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/3/c */
    { 0x0c00, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/3/0/u */
    { 0x0c7f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/0/c */
    { 0x0d00, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/3/1/u */
    { 0x0d7f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/1/c */
    { 0x0e00, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/3/2/u */
    { 0x0e7f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/2/c */
    { 0x0f00, 0xb430, 0xb881, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323) }, /* #55/3/3/u */
    { 0x0f7f, 0xb430, 0x3801, RTFLOAT80U_INIT_C(1,0x39dd3402811b9527,3323), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/3/c */
    { 0x0000, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/0/u */
    { 0x007f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/0/c */
    { 0x0100, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/1/u */
    { 0x017f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/1/c */
    { 0x0200, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/2/u */
    { 0x027f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/2/c */
    { 0x0300, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/3/u */
    { 0x037f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/0/3/c */
    { 0x0400, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/0/u */
    { 0x047f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/0/c */
    { 0x0500, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/1/u */
    { 0x057f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/1/c */
    { 0x0600, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/2/u */
    { 0x067f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/2/c */
    { 0x0700, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/3/u */
    { 0x077f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/1/3/c */
    { 0x0800, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/0/u */
    { 0x087f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/0/c */
    { 0x0900, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/1/u */
    { 0x097f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/1/c */
    { 0x0a00, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/2/u */
    { 0x0a7f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/2/c */
    { 0x0b00, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/3/u */
    { 0x0b7f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/2/3/c */
    { 0x0c00, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/0/u */
    { 0x0c7f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/0/c */
    { 0x0d00, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/1/u */
    { 0x0d7f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/1/c */
    { 0x0e00, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/2/u */
    { 0x0e7f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/2/c */
    { 0x0f00, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/3/u */
    { 0x0f7f, 0x7850, 0x7c00, RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407), RTFLOAT80U_INIT_C(1,0x8fd1d2369db7d448,24407) }, /* #56/3/3/c */
    { 0x0000, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/0/u */
    { 0x007f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/0/c */
    { 0x0100, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/1/u */
    { 0x017f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/1/c */
    { 0x0200, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/2/u */
    { 0x027f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/2/c */
    { 0x0300, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/3/u */
    { 0x037f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/0/3/c */
    { 0x0400, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/0/u */
    { 0x047f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/0/c */
    { 0x0500, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/1/u */
    { 0x057f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/1/c */
    { 0x0600, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/2/u */
    { 0x067f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/2/c */
    { 0x0700, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/3/u */
    { 0x077f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/1/3/c */
    { 0x0800, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/0/u */
    { 0x087f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/0/c */
    { 0x0900, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/1/u */
    { 0x097f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/1/c */
    { 0x0a00, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/2/u */
    { 0x0a7f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/2/c */
    { 0x0b00, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/3/u */
    { 0x0b7f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/2/3/c */
    { 0x0c00, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/0/u */
    { 0x0c7f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/0/c */
    { 0x0d00, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/1/u */
    { 0x0d7f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/1/c */
    { 0x0e00, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/2/u */
    { 0x0e7f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/2/c */
    { 0x0f00, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/3/u */
    { 0x0f7f, 0xfd74, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #57/3/3/c */
    { 0x0000, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/0/u */
    { 0x007f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/0/c */
    { 0x0100, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/1/u */
    { 0x017f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/1/c */
    { 0x0200, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/2/u */
    { 0x027f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/2/c */
    { 0x0300, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/3/u */
    { 0x037f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/0/3/c */
    { 0x0400, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/0/u */
    { 0x047f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/0/c */
    { 0x0500, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/1/u */
    { 0x057f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/1/c */
    { 0x0600, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/2/u */
    { 0x067f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/2/c */
    { 0x0700, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/3/u */
    { 0x077f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/1/3/c */
    { 0x0800, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/0/u */
    { 0x087f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/0/c */
    { 0x0900, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/1/u */
    { 0x097f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/1/c */
    { 0x0a00, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/2/u */
    { 0x0a7f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/2/c */
    { 0x0b00, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/3/u */
    { 0x0b7f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/2/3/c */
    { 0x0c00, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/0/u */
    { 0x0c7f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/0/c */
    { 0x0d00, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/1/u */
    { 0x0d7f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/1/c */
    { 0x0e00, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/2/u */
    { 0x0e7f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/2/c */
    { 0x0f00, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/3/u */
    { 0x0f7f, 0xf1cd, 0x7d00, RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547), RTFLOAT80U_INIT_C(1,0xae4a045af44eff0a,18547) }, /* #58/3/3/c */
    { 0x0000, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/0/0/u */
    { 0x007f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/0/c */
    { 0x0100, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/0/1/u */
    { 0x017f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/1/c */
    { 0x0200, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/0/2/u */
    { 0x027f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/2/c */
    { 0x0300, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/0/3/u */
    { 0x037f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/0/3/c */
    { 0x0400, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/1/0/u */
    { 0x047f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/0/c */
    { 0x0500, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/1/1/u */
    { 0x057f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/1/c */
    { 0x0600, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/1/2/u */
    { 0x067f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/2/c */
    { 0x0700, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/1/3/u */
    { 0x077f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/1/3/c */
    { 0x0800, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/2/0/u */
    { 0x087f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/0/c */
    { 0x0900, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/2/1/u */
    { 0x097f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/1/c */
    { 0x0a00, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/2/2/u */
    { 0x0a7f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/2/c */
    { 0x0b00, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/2/3/u */
    { 0x0b7f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/2/3/c */
    { 0x0c00, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/3/0/u */
    { 0x0c7f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/0/c */
    { 0x0d00, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/3/1/u */
    { 0x0d7f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/1/c */
    { 0x0e00, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/3/2/u */
    { 0x0e7f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/2/c */
    { 0x0f00, 0xd781, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #59/3/3/u */
    { 0x0f7f, 0xd781, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #59/3/3/c */
    { 0x0000, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/0/u */
    { 0x007f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/0/c */
    { 0x0100, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/1/u */
    { 0x017f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/1/c */
    { 0x0200, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/2/u */
    { 0x027f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/2/c */
    { 0x0300, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/3/u */
    { 0x037f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/0/3/c */
    { 0x0400, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/0/u */
    { 0x047f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/0/c */
    { 0x0500, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/1/u */
    { 0x057f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/1/c */
    { 0x0600, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/2/u */
    { 0x067f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/2/c */
    { 0x0700, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/3/u */
    { 0x077f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/1/3/c */
    { 0x0800, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/0/u */
    { 0x087f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/0/c */
    { 0x0900, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/1/u */
    { 0x097f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/1/c */
    { 0x0a00, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/2/u */
    { 0x0a7f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/2/c */
    { 0x0b00, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/3/u */
    { 0x0b7f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/2/3/c */
    { 0x0c00, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/0/u */
    { 0x0c7f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/0/c */
    { 0x0d00, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/1/u */
    { 0x0d7f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/1/c */
    { 0x0e00, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/2/u */
    { 0x0e7f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/2/c */
    { 0x0f00, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/3/u */
    { 0x0f7f, 0x8fc7, 0x3900, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #60/3/3/c */
    { 0x0000, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/0/0/u */
    { 0x007f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/0/0/c */
    { 0x0100, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/0/1/u */
    { 0x017f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/0/1/c */
    { 0x0200, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/0/2/u */
    { 0x027f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/0/2/c */
    { 0x0300, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/0/3/u */
    { 0x037f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/0/3/c */
    { 0x0400, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/1/0/u */
    { 0x047f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/1/0/c */
    { 0x0500, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/1/1/u */
    { 0x057f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/1/1/c */
    { 0x0600, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/1/2/u */
    { 0x067f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/1/2/c */
    { 0x0700, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/1/3/u */
    { 0x077f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/1/3/c */
    { 0x0800, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/2/0/u */
    { 0x087f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/2/0/c */
    { 0x0900, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/2/1/u */
    { 0x097f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/2/1/c */
    { 0x0a00, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/2/2/u */
    { 0x0a7f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/2/2/c */
    { 0x0b00, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/2/3/u */
    { 0x0b7f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/2/3/c */
    { 0x0c00, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/3/0/u */
    { 0x0c7f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/3/0/c */
    { 0x0d00, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/3/1/u */
    { 0x0d7f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/3/1/c */
    { 0x0e00, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/3/2/u */
    { 0x0e7f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/3/2/c */
    { 0x0f00, 0xe1ed, 0xf981, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767) }, /* #61/3/3/u */
    { 0x0f7f, 0xe1ed, 0x7901, RTFLOAT80U_INIT_C(0,0xbbb09ed226f85d3a,32767), RTFLOAT80U_INIT_C(0,0xfbb09ed226f85d3a,32767) }, /* #61/3/3/c */
    { 0x0000, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/0/u */
    { 0x007f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/0/c */
    { 0x0100, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/1/u */
    { 0x017f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/1/c */
    { 0x0200, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/2/u */
    { 0x027f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/2/c */
    { 0x0300, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/3/u */
    { 0x037f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/0/3/c */
    { 0x0400, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/0/u */
    { 0x047f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/0/c */
    { 0x0500, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/1/u */
    { 0x057f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/1/c */
    { 0x0600, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/2/u */
    { 0x067f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/2/c */
    { 0x0700, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/3/u */
    { 0x077f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/1/3/c */
    { 0x0800, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/0/u */
    { 0x087f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/0/c */
    { 0x0900, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/1/u */
    { 0x097f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/1/c */
    { 0x0a00, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/2/u */
    { 0x0a7f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/2/c */
    { 0x0b00, 0xbf45, 0xbba0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/3/u */
    { 0x0b7f, 0xbf45, 0x3b20, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104) }, /* #62/2/3/c */
    { 0x0c00, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/0/u */
    { 0x0c7f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/0/c */
    { 0x0d00, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/1/u */
    { 0x0d7f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/1/c */
    { 0x0e00, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/2/u */
    { 0x0e7f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/2/c */
    { 0x0f00, 0xbf45, 0xb9a0, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/3/u */
    { 0x0f7f, 0xbf45, 0x3920, RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f5,9104), RTFLOAT80U_INIT_C(0,0x953c2a7fc150a3f4,9104) }, /* #62/3/3/c */
    { 0x0000, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/0/0/u */
    { 0x007f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/0/c */
    { 0x0100, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/0/1/u */
    { 0x017f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/1/c */
    { 0x0200, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/0/2/u */
    { 0x027f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/2/c */
    { 0x0300, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/0/3/u */
    { 0x037f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/3/c */
    { 0x0400, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/1/0/u */
    { 0x047f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/0/c */
    { 0x0500, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/1/1/u */
    { 0x057f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/1/c */
    { 0x0600, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/1/2/u */
    { 0x067f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/2/c */
    { 0x0700, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/1/3/u */
    { 0x077f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/3/c */
    { 0x0800, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/2/0/u */
    { 0x087f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/0/c */
    { 0x0900, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/2/1/u */
    { 0x097f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/1/c */
    { 0x0a00, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/2/2/u */
    { 0x0a7f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/2/c */
    { 0x0b00, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/2/3/u */
    { 0x0b7f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/3/c */
    { 0x0c00, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/3/0/u */
    { 0x0c7f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/0/c */
    { 0x0d00, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/3/1/u */
    { 0x0d7f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/1/c */
    { 0x0e00, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/3/2/u */
    { 0x0e7f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/2/c */
    { 0x0f00, 0xeba9, 0xf981, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150) }, /* #63/3/3/u */
    { 0x0f7f, 0xeba9, 0x7901, RTFLOAT80U_INIT_C(1,0x48d5130516a66f4c,21150), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/3/c */
    { 0x0000, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/0/0/u */
    { 0x007f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/0/c */
    { 0x0100, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/0/1/u */
    { 0x017f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/1/c */
    { 0x0200, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/0/2/u */
    { 0x027f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/2/c */
    { 0x0300, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/0/3/u */
    { 0x037f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/0/3/c */
    { 0x0400, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/1/0/u */
    { 0x047f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/0/c */
    { 0x0500, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/1/1/u */
    { 0x057f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/1/c */
    { 0x0600, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/1/2/u */
    { 0x067f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/2/c */
    { 0x0700, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/1/3/u */
    { 0x077f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/1/3/c */
    { 0x0800, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/2/0/u */
    { 0x087f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/0/c */
    { 0x0900, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/2/1/u */
    { 0x097f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/1/c */
    { 0x0a00, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/2/2/u */
    { 0x0a7f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/2/c */
    { 0x0b00, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/2/3/u */
    { 0x0b7f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/2/3/c */
    { 0x0c00, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/3/0/u */
    { 0x0c7f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/0/c */
    { 0x0d00, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/3/1/u */
    { 0x0d7f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/1/c */
    { 0x0e00, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/3/2/u */
    { 0x0e7f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/2/c */
    { 0x0f00, 0x37a3, 0xb981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #64/3/3/u */
    { 0x0f7f, 0x37a3, 0x3901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #64/3/3/c */
    { 0x0000, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/0/0/u */
    { 0x007f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/0/0/c */
    { 0x0100, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/0/1/u */
    { 0x017f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/0/1/c */
    { 0x0200, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/0/2/u */
    { 0x027f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/0/2/c */
    { 0x0300, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/0/3/u */
    { 0x037f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/0/3/c */
    { 0x0400, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/1/0/u */
    { 0x047f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/1/0/c */
    { 0x0500, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/1/1/u */
    { 0x057f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/1/1/c */
    { 0x0600, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/1/2/u */
    { 0x067f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/1/2/c */
    { 0x0700, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/1/3/u */
    { 0x077f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/1/3/c */
    { 0x0800, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/2/0/u */
    { 0x087f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/2/0/c */
    { 0x0900, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/2/1/u */
    { 0x097f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/2/1/c */
    { 0x0a00, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/2/2/u */
    { 0x0a7f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/2/2/c */
    { 0x0b00, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/2/3/u */
    { 0x0b7f, 0xa60c, 0x3a22, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,1) }, /* #65/2/3/c */
    { 0x0c00, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/3/0/u */
    { 0x0c7f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/3/0/c */
    { 0x0d00, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/3/1/u */
    { 0x0d7f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/3/1/c */
    { 0x0e00, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/3/2/u */
    { 0x0e7f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/3/2/c */
    { 0x0f00, 0xa60c, 0xb882, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115d,0) }, /* #65/3/3/u */
    { 0x0f7f, 0xa60c, 0x3822, RTFLOAT80U_INIT_C(0,0x800000000000115d,0), RTFLOAT80U_INIT_C(0,0x800000000000115c,1) }, /* #65/3/3/c */
    { 0x0000, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/0/u */
    { 0x007f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/0/c */
    { 0x0100, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/1/u */
    { 0x017f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/1/c */
    { 0x0200, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/2/u */
    { 0x027f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/2/c */
    { 0x0300, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/3/u */
    { 0x037f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/0/3/c */
    { 0x0400, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/0/u */
    { 0x047f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/0/c */
    { 0x0500, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/1/u */
    { 0x057f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/1/c */
    { 0x0600, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/2/u */
    { 0x067f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/2/c */
    { 0x0700, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/3/u */
    { 0x077f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/1/3/c */
    { 0x0800, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/0/u */
    { 0x087f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/0/c */
    { 0x0900, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/1/u */
    { 0x097f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/1/c */
    { 0x0a00, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/2/u */
    { 0x0a7f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/2/c */
    { 0x0b00, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/3/u */
    { 0x0b7f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/2/3/c */
    { 0x0c00, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/0/u */
    { 0x0c7f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/0/c */
    { 0x0d00, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/1/u */
    { 0x0d7f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/1/c */
    { 0x0e00, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/2/u */
    { 0x0e7f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/2/c */
    { 0x0f00, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/3/u */
    { 0x0f7f, 0xc946, 0x7d00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27180) }, /* #66/3/3/c */
    { 0x0000, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/0/0/u */
    { 0x007f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/0/0/c */
    { 0x0100, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/0/1/u */
    { 0x017f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/0/1/c */
    { 0x0200, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/0/2/u */
    { 0x027f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/0/2/c */
    { 0x0300, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/0/3/u */
    { 0x037f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/0/3/c */
    { 0x0400, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/1/0/u */
    { 0x047f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/1/0/c */
    { 0x0500, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/1/1/u */
    { 0x057f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/1/1/c */
    { 0x0600, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/1/2/u */
    { 0x067f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/1/2/c */
    { 0x0700, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/1/3/u */
    { 0x077f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/1/3/c */
    { 0x0800, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/2/0/u */
    { 0x087f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/2/0/c */
    { 0x0900, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/2/1/u */
    { 0x097f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/2/1/c */
    { 0x0a00, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/2/2/u */
    { 0x0a7f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/2/2/c */
    { 0x0b00, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/2/3/u */
    { 0x0b7f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/2/3/c */
    { 0x0c00, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/3/0/u */
    { 0x0c7f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/3/0/c */
    { 0x0d00, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/3/1/u */
    { 0x0d7f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/3/1/c */
    { 0x0e00, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/3/2/u */
    { 0x0e7f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/3/2/c */
    { 0x0f00, 0x5652, 0xf881, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767) }, /* #67/3/3/u */
    { 0x0f7f, 0x5652, 0x7801, RTFLOAT80U_INIT_C(0,0x800000001f215beb,32767), RTFLOAT80U_INIT_C(0,0xc00000001f215beb,32767) }, /* #67/3/3/c */
    { 0x0000, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/0/u */
    { 0x007f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/0/c */
    { 0x0100, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/1/u */
    { 0x017f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/1/c */
    { 0x0200, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/2/u */
    { 0x027f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/2/c */
    { 0x0300, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/3/u */
    { 0x037f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/0/3/c */
    { 0x0400, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/0/u */
    { 0x047f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/0/c */
    { 0x0500, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/1/u */
    { 0x057f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/1/c */
    { 0x0600, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/2/u */
    { 0x067f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/2/c */
    { 0x0700, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/3/u */
    { 0x077f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/1/3/c */
    { 0x0800, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/0/u */
    { 0x087f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/0/c */
    { 0x0900, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/1/u */
    { 0x097f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/1/c */
    { 0x0a00, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/2/u */
    { 0x0a7f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/2/c */
    { 0x0b00, 0xabdc, 0xbba0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/3/u */
    { 0x0b7f, 0xabdc, 0x3b20, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407) }, /* #68/2/3/c */
    { 0x0c00, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/0/u */
    { 0x0c7f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/0/c */
    { 0x0d00, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/1/u */
    { 0x0d7f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/1/c */
    { 0x0e00, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/2/u */
    { 0x0e7f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/2/c */
    { 0x0f00, 0xabdc, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/3/u */
    { 0x0f7f, 0xabdc, 0x3920, RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dd,6407), RTFLOAT80U_INIT_C(0,0xd7329a0e2aac51dc,6407) }, /* #68/3/3/c */
    { 0x0000, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/0/0/u */
    { 0x007f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/0/c */
    { 0x0100, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/0/1/u */
    { 0x017f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/1/c */
    { 0x0200, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/0/2/u */
    { 0x027f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/2/c */
    { 0x0300, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/0/3/u */
    { 0x037f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/3/c */
    { 0x0400, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/1/0/u */
    { 0x047f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/0/c */
    { 0x0500, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/1/1/u */
    { 0x057f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/1/c */
    { 0x0600, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/1/2/u */
    { 0x067f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/2/c */
    { 0x0700, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/1/3/u */
    { 0x077f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/3/c */
    { 0x0800, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/2/0/u */
    { 0x087f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/0/c */
    { 0x0900, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/2/1/u */
    { 0x097f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/1/c */
    { 0x0a00, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/2/2/u */
    { 0x0a7f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/2/c */
    { 0x0b00, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/2/3/u */
    { 0x0b7f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/3/c */
    { 0x0c00, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/3/0/u */
    { 0x0c7f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/0/c */
    { 0x0d00, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/3/1/u */
    { 0x0d7f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/1/c */
    { 0x0e00, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/3/2/u */
    { 0x0e7f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/2/c */
    { 0x0f00, 0x530c, 0xf981, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421) }, /* #69/3/3/u */
    { 0x0f7f, 0x530c, 0x7901, RTFLOAT80U_INIT_C(0,0x202096a834dc2194,8421), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/3/c */
    { 0x0000, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/0/u */
    { 0x007f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/0/c */
    { 0x0100, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/1/u */
    { 0x017f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/1/c */
    { 0x0200, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/2/u */
    { 0x027f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/2/c */
    { 0x0300, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/3/u */
    { 0x037f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/0/3/c */
    { 0x0400, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/0/u */
    { 0x047f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/0/c */
    { 0x0500, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/1/u */
    { 0x057f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/1/c */
    { 0x0600, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/2/u */
    { 0x067f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/2/c */
    { 0x0700, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/3/u */
    { 0x077f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/1/3/c */
    { 0x0800, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/0/u */
    { 0x087f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/0/c */
    { 0x0900, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/1/u */
    { 0x097f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/1/c */
    { 0x0a00, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/2/u */
    { 0x0a7f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/2/c */
    { 0x0b00, 0x6994, 0xfba0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/3/u */
    { 0x0b7f, 0x6994, 0x7b20, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348) }, /* #70/2/3/c */
    { 0x0c00, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/0/u */
    { 0x0c7f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/0/c */
    { 0x0d00, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/1/u */
    { 0x0d7f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/1/c */
    { 0x0e00, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/2/u */
    { 0x0e7f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/2/c */
    { 0x0f00, 0x6994, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/3/u */
    { 0x0f7f, 0x6994, 0x7920, RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa3,348), RTFLOAT80U_INIT_C(0,0x96bd0a09459d3fa2,348) }, /* #70/3/3/c */
    { 0x0000, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/0/u */
    { 0x007f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/0/c */
    { 0x0100, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/1/u */
    { 0x017f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/1/c */
    { 0x0200, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/2/u */
    { 0x027f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/2/c */
    { 0x0300, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/3/u */
    { 0x037f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/0/3/c */
    { 0x0400, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/1/0/u */
    { 0x047f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/1/0/c */
    { 0x0500, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/1/1/u */
    { 0x057f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/1/1/c */
    { 0x0600, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/1/2/u */
    { 0x067f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/1/2/c */
    { 0x0700, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/1/3/u */
    { 0x077f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/1/3/c */
    { 0x0800, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/0/u */
    { 0x087f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/0/c */
    { 0x0900, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/1/u */
    { 0x097f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/1/c */
    { 0x0a00, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/2/u */
    { 0x0a7f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/2/c */
    { 0x0b00, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/3/u */
    { 0x0b7f, 0x0d28, 0x3b32, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/2/3/c */
    { 0x0c00, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/3/0/u */
    { 0x0c7f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/3/0/c */
    { 0x0d00, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/3/1/u */
    { 0x0d7f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/3/1/c */
    { 0x0e00, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/3/2/u */
    { 0x0e7f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/3/2/c */
    { 0x0f00, 0x0d28, 0xb982, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x496,0) }, /* #71/3/3/u */
    { 0x0f7f, 0x0d28, 0x3932, RTFLOAT80U_INIT_C(0,0x496,0), RTFLOAT80U_INIT_C(0,0x495,0) }, /* #71/3/3/c */
    { 0x0000, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/0/u */
    { 0x007f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/0/c */
    { 0x0100, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/1/u */
    { 0x017f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/1/c */
    { 0x0200, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/2/u */
    { 0x027f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/2/c */
    { 0x0300, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/3/u */
    { 0x037f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/0/3/c */
    { 0x0400, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/0/u */
    { 0x047f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/0/c */
    { 0x0500, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/1/u */
    { 0x057f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/1/c */
    { 0x0600, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/2/u */
    { 0x067f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/2/c */
    { 0x0700, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/3/u */
    { 0x077f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/1/3/c */
    { 0x0800, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/0/u */
    { 0x087f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/0/c */
    { 0x0900, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/1/u */
    { 0x097f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/1/c */
    { 0x0a00, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/2/u */
    { 0x0a7f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/2/c */
    { 0x0b00, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/3/u */
    { 0x0b7f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/2/3/c */
    { 0x0c00, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/0/u */
    { 0x0c7f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/0/c */
    { 0x0d00, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/1/u */
    { 0x0d7f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/1/c */
    { 0x0e00, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/2/u */
    { 0x0e7f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/2/c */
    { 0x0f00, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/3/u */
    { 0x0f7f, 0xbaf7, 0x3800, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #72/3/3/c */
    { 0x0000, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/0/u */
    { 0x007f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/0/c */
    { 0x0100, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/1/u */
    { 0x017f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/1/c */
    { 0x0200, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/2/u */
    { 0x027f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/2/c */
    { 0x0300, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/3/u */
    { 0x037f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/0/3/c */
    { 0x0400, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/0/u */
    { 0x047f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/0/c */
    { 0x0500, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/1/u */
    { 0x057f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/1/c */
    { 0x0600, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/2/u */
    { 0x067f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/2/c */
    { 0x0700, 0xfe3c, 0xfaa0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/3/u */
    { 0x077f, 0xfe3c, 0x7a20, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810) }, /* #73/1/3/c */
    { 0x0800, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/0/u */
    { 0x087f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/0/c */
    { 0x0900, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/1/u */
    { 0x097f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/1/c */
    { 0x0a00, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/2/u */
    { 0x0a7f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/2/c */
    { 0x0b00, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/3/u */
    { 0x0b7f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/2/3/c */
    { 0x0c00, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/0/u */
    { 0x0c7f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/0/c */
    { 0x0d00, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/1/u */
    { 0x0d7f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/1/c */
    { 0x0e00, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/2/u */
    { 0x0e7f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/2/c */
    { 0x0f00, 0xfe3c, 0xf8a0, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/3/u */
    { 0x0f7f, 0xfe3c, 0x7820, RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdcb,4810), RTFLOAT80U_INIT_C(1,0xa3a0e3dc3196cdca,4810) }, /* #73/3/3/c */
    { 0x0000, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/0/0/u */
    { 0x007f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/0/c */
    { 0x0100, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/0/1/u */
    { 0x017f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/1/c */
    { 0x0200, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/0/2/u */
    { 0x027f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/2/c */
    { 0x0300, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/0/3/u */
    { 0x037f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/3/c */
    { 0x0400, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/1/0/u */
    { 0x047f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/0/c */
    { 0x0500, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/1/1/u */
    { 0x057f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/1/c */
    { 0x0600, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/1/2/u */
    { 0x067f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/2/c */
    { 0x0700, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/1/3/u */
    { 0x077f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/3/c */
    { 0x0800, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/2/0/u */
    { 0x087f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/0/c */
    { 0x0900, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/2/1/u */
    { 0x097f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/1/c */
    { 0x0a00, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/2/2/u */
    { 0x0a7f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/2/c */
    { 0x0b00, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/2/3/u */
    { 0x0b7f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/3/c */
    { 0x0c00, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/3/0/u */
    { 0x0c7f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/0/c */
    { 0x0d00, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/3/1/u */
    { 0x0d7f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/1/c */
    { 0x0e00, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/3/2/u */
    { 0x0e7f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/2/c */
    { 0x0f00, 0x3459, 0xb881, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665) }, /* #74/3/3/u */
    { 0x0f7f, 0x3459, 0x3801, RTFLOAT80U_INIT_C(0,0x6b07628faad4970,24665), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/3/c */
    { 0x0000, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/0/u */
    { 0x007f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/0/c */
    { 0x0100, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/1/u */
    { 0x017f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/1/c */
    { 0x0200, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/2/u */
    { 0x027f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/2/c */
    { 0x0300, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/3/u */
    { 0x037f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/0/3/c */
    { 0x0400, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/0/u */
    { 0x047f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/0/c */
    { 0x0500, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/1/u */
    { 0x057f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/1/c */
    { 0x0600, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/2/u */
    { 0x067f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/2/c */
    { 0x0700, 0xef95, 0xfba0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/3/u */
    { 0x077f, 0xef95, 0x7b20, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363) }, /* #75/1/3/c */
    { 0x0800, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/0/u */
    { 0x087f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/0/c */
    { 0x0900, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/1/u */
    { 0x097f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/1/c */
    { 0x0a00, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/2/u */
    { 0x0a7f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/2/c */
    { 0x0b00, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/3/u */
    { 0x0b7f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/2/3/c */
    { 0x0c00, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/0/u */
    { 0x0c7f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/0/c */
    { 0x0d00, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/1/u */
    { 0x0d7f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/1/c */
    { 0x0e00, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/2/u */
    { 0x0e7f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/2/c */
    { 0x0f00, 0xef95, 0xf9a0, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/3/u */
    { 0x0f7f, 0xef95, 0x7920, RTFLOAT80U_INIT_C(1,0x88893911ad63cbfa,12363), RTFLOAT80U_INIT_C(1,0x88893911ad63cbf9,12363) }, /* #75/3/3/c */
    { 0x0000, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/0/0/u */
    { 0x007f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/0/c */
    { 0x0100, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/0/1/u */
    { 0x017f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/1/c */
    { 0x0200, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/0/2/u */
    { 0x027f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/2/c */
    { 0x0300, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/0/3/u */
    { 0x037f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/3/c */
    { 0x0400, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/1/0/u */
    { 0x047f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/0/c */
    { 0x0500, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/1/1/u */
    { 0x057f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/1/c */
    { 0x0600, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/1/2/u */
    { 0x067f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/2/c */
    { 0x0700, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/1/3/u */
    { 0x077f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/3/c */
    { 0x0800, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/2/0/u */
    { 0x087f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/0/c */
    { 0x0900, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/2/1/u */
    { 0x097f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/1/c */
    { 0x0a00, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/2/2/u */
    { 0x0a7f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/2/c */
    { 0x0b00, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/2/3/u */
    { 0x0b7f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/3/c */
    { 0x0c00, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/3/0/u */
    { 0x0c7f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/0/c */
    { 0x0d00, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/3/1/u */
    { 0x0d7f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/1/c */
    { 0x0e00, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/3/2/u */
    { 0x0e7f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/2/c */
    { 0x0f00, 0xf36c, 0xf981, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579) }, /* #76/3/3/u */
    { 0x0f7f, 0xf36c, 0x7901, RTFLOAT80U_INIT_C(0,0x4814f62d84603479,10579), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/3/c */
    { 0x0000, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/0/0/u */
    { 0x007f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/0/c */
    { 0x0100, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/0/1/u */
    { 0x017f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/1/c */
    { 0x0200, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/0/2/u */
    { 0x027f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/2/c */
    { 0x0300, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/0/3/u */
    { 0x037f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/3/c */
    { 0x0400, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/1/0/u */
    { 0x047f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/0/c */
    { 0x0500, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/1/1/u */
    { 0x057f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/1/c */
    { 0x0600, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/1/2/u */
    { 0x067f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/2/c */
    { 0x0700, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/1/3/u */
    { 0x077f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/3/c */
    { 0x0800, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/2/0/u */
    { 0x087f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/0/c */
    { 0x0900, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/2/1/u */
    { 0x097f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/1/c */
    { 0x0a00, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/2/2/u */
    { 0x0a7f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/2/c */
    { 0x0b00, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/2/3/u */
    { 0x0b7f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/3/c */
    { 0x0c00, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/3/0/u */
    { 0x0c7f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/0/c */
    { 0x0d00, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/3/1/u */
    { 0x0d7f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/1/c */
    { 0x0e00, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/3/2/u */
    { 0x0e7f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/2/c */
    { 0x0f00, 0xa27e, 0xb881, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628) }, /* #77/3/3/u */
    { 0x0f7f, 0xa27e, 0x3801, RTFLOAT80U_INIT_C(1,0x1ab645cc43,18628), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/3/c */
    { 0x0000, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/0/u */
    { 0x007f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/0/c */
    { 0x0100, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/1/u */
    { 0x017f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/1/c */
    { 0x0200, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/2/u */
    { 0x027f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/2/c */
    { 0x0300, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/3/u */
    { 0x037f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/0/3/c */
    { 0x0400, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/0/u */
    { 0x047f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/0/c */
    { 0x0500, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/1/u */
    { 0x057f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/1/c */
    { 0x0600, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/2/u */
    { 0x067f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/2/c */
    { 0x0700, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/3/u */
    { 0x077f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/1/3/c */
    { 0x0800, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/0/u */
    { 0x087f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/0/c */
    { 0x0900, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/1/u */
    { 0x097f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/1/c */
    { 0x0a00, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/2/u */
    { 0x0a7f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/2/c */
    { 0x0b00, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/3/u */
    { 0x0b7f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/2/3/c */
    { 0x0c00, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/0/u */
    { 0x0c7f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/0/c */
    { 0x0d00, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/1/u */
    { 0x0d7f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/1/c */
    { 0x0e00, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/2/u */
    { 0x0e7f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/2/c */
    { 0x0f00, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/3/u */
    { 0x0f7f, 0xd4a9, 0x7c00, RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414), RTFLOAT80U_INIT_C(1,0xb104902615e50e28,18414) }, /* #78/3/3/c */
    { 0x0000, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/0/u */
    { 0x007f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/0/c */
    { 0x0100, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/1/u */
    { 0x017f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/1/c */
    { 0x0200, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/2/u */
    { 0x027f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/2/c */
    { 0x0300, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/3/u */
    { 0x037f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/0/3/c */
    { 0x0400, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/0/u */
    { 0x047f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/0/c */
    { 0x0500, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/1/u */
    { 0x057f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/1/c */
    { 0x0600, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/2/u */
    { 0x067f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/2/c */
    { 0x0700, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/3/u */
    { 0x077f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/1/3/c */
    { 0x0800, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/0/u */
    { 0x087f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/0/c */
    { 0x0900, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/1/u */
    { 0x097f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/1/c */
    { 0x0a00, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/2/u */
    { 0x0a7f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/2/c */
    { 0x0b00, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/3/u */
    { 0x0b7f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/2/3/c */
    { 0x0c00, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/0/u */
    { 0x0c7f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/0/c */
    { 0x0d00, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/1/u */
    { 0x0d7f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/1/c */
    { 0x0e00, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/2/u */
    { 0x0e7f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/2/c */
    { 0x0f00, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/3/u */
    { 0x0f7f, 0x00f0, 0x3800, RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767), RTFLOAT80U_INIT_C(0,0xc000003e1326ee17,32767) }, /* #79/3/3/c */
    { 0x0000, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/0/u */
    { 0x007f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/0/c */
    { 0x0100, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/1/u */
    { 0x017f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/1/c */
    { 0x0200, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/2/u */
    { 0x027f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/2/c */
    { 0x0300, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/3/u */
    { 0x037f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/0/3/c */
    { 0x0400, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/0/u */
    { 0x047f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/0/c */
    { 0x0500, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/1/u */
    { 0x057f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/1/c */
    { 0x0600, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/2/u */
    { 0x067f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/2/c */
    { 0x0700, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/3/u */
    { 0x077f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/1/3/c */
    { 0x0800, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/0/u */
    { 0x087f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/0/c */
    { 0x0900, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/1/u */
    { 0x097f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/1/c */
    { 0x0a00, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/2/u */
    { 0x0a7f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/2/c */
    { 0x0b00, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/3/u */
    { 0x0b7f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/2/3/c */
    { 0x0c00, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/0/u */
    { 0x0c7f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/0/c */
    { 0x0d00, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/1/u */
    { 0x0d7f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/1/c */
    { 0x0e00, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/2/u */
    { 0x0e7f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/2/c */
    { 0x0f00, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/3/u */
    { 0x0f7f, 0x1e78, 0x3c00, RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794), RTFLOAT80U_INIT_C(1,0xd02ab2780c5c8cf7,27794) }, /* #80/3/3/c */
    { 0x0000, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/0/0/u */
    { 0x007f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/0/0/c */
    { 0x0100, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/0/1/u */
    { 0x017f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/0/1/c */
    { 0x0200, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/0/2/u */
    { 0x027f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/0/2/c */
    { 0x0300, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/0/3/u */
    { 0x037f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/0/3/c */
    { 0x0400, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/1/0/u */
    { 0x047f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/1/0/c */
    { 0x0500, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/1/1/u */
    { 0x057f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/1/1/c */
    { 0x0600, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/1/2/u */
    { 0x067f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/1/2/c */
    { 0x0700, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/1/3/u */
    { 0x077f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/1/3/c */
    { 0x0800, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/2/0/u */
    { 0x087f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/2/0/c */
    { 0x0900, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/2/1/u */
    { 0x097f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/2/1/c */
    { 0x0a00, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/2/2/u */
    { 0x0a7f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/2/2/c */
    { 0x0b00, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/2/3/u */
    { 0x0b7f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/2/3/c */
    { 0x0c00, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/3/0/u */
    { 0x0c7f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/3/0/c */
    { 0x0d00, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/3/1/u */
    { 0x0d7f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/3/1/c */
    { 0x0e00, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/3/2/u */
    { 0x0e7f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/3/2/c */
    { 0x0f00, 0xf743, 0xf981, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867) }, /* #81/3/3/u */
    { 0x0f7f, 0xf743, 0x7901, RTFLOAT80U_INIT_C(1,0x4fafd26c4cd75f45,22867), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #81/3/3/c */
    { 0x0000, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/0/0/u */
    { 0x007f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/0/c */
    { 0x0100, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/0/1/u */
    { 0x017f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/1/c */
    { 0x0200, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/0/2/u */
    { 0x027f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/2/c */
    { 0x0300, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/0/3/u */
    { 0x037f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/3/c */
    { 0x0400, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/1/0/u */
    { 0x047f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/0/c */
    { 0x0500, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/1/1/u */
    { 0x057f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/1/c */
    { 0x0600, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/1/2/u */
    { 0x067f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/2/c */
    { 0x0700, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/1/3/u */
    { 0x077f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/3/c */
    { 0x0800, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/2/0/u */
    { 0x087f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/0/c */
    { 0x0900, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/2/1/u */
    { 0x097f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/1/c */
    { 0x0a00, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/2/2/u */
    { 0x0a7f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/2/c */
    { 0x0b00, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/2/3/u */
    { 0x0b7f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/3/c */
    { 0x0c00, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/3/0/u */
    { 0x0c7f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/0/c */
    { 0x0d00, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/3/1/u */
    { 0x0d7f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/1/c */
    { 0x0e00, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/3/2/u */
    { 0x0e7f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/2/c */
    { 0x0f00, 0x6fe5, 0xf981, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279) }, /* #82/3/3/u */
    { 0x0f7f, 0x6fe5, 0x7901, RTFLOAT80U_INIT_C(0,0x4a8716d987d46a2e,19279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/3/c */
    { 0x0000, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/0/0/u */
    { 0x007f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/0/c */
    { 0x0100, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/0/1/u */
    { 0x017f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/1/c */
    { 0x0200, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/0/2/u */
    { 0x027f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/2/c */
    { 0x0300, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/0/3/u */
    { 0x037f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/3/c */
    { 0x0400, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/1/0/u */
    { 0x047f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/0/c */
    { 0x0500, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/1/1/u */
    { 0x057f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/1/c */
    { 0x0600, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/1/2/u */
    { 0x067f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/2/c */
    { 0x0700, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/1/3/u */
    { 0x077f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/3/c */
    { 0x0800, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/2/0/u */
    { 0x087f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/0/c */
    { 0x0900, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/2/1/u */
    { 0x097f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/1/c */
    { 0x0a00, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/2/2/u */
    { 0x0a7f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/2/c */
    { 0x0b00, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/2/3/u */
    { 0x0b7f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/3/c */
    { 0x0c00, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/3/0/u */
    { 0x0c7f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/0/c */
    { 0x0d00, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/3/1/u */
    { 0x0d7f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/1/c */
    { 0x0e00, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/3/2/u */
    { 0x0e7f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/2/c */
    { 0x0f00, 0x47a8, 0xf981, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432) }, /* #83/3/3/u */
    { 0x0f7f, 0x47a8, 0x7901, RTFLOAT80U_INIT_C(0,0x5c66369c18662e3f,27432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/3/c */
    { 0x0000, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/0/0/u */
    { 0x007f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/0/c */
    { 0x0100, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/0/1/u */
    { 0x017f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/1/c */
    { 0x0200, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/0/2/u */
    { 0x027f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/2/c */
    { 0x0300, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/0/3/u */
    { 0x037f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/3/c */
    { 0x0400, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/1/0/u */
    { 0x047f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/0/c */
    { 0x0500, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/1/1/u */
    { 0x057f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/1/c */
    { 0x0600, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/1/2/u */
    { 0x067f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/2/c */
    { 0x0700, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/1/3/u */
    { 0x077f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/3/c */
    { 0x0800, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/2/0/u */
    { 0x087f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/0/c */
    { 0x0900, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/2/1/u */
    { 0x097f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/1/c */
    { 0x0a00, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/2/2/u */
    { 0x0a7f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/2/c */
    { 0x0b00, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/2/3/u */
    { 0x0b7f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/3/c */
    { 0x0c00, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/3/0/u */
    { 0x0c7f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/0/c */
    { 0x0d00, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/3/1/u */
    { 0x0d7f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/1/c */
    { 0x0e00, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/3/2/u */
    { 0x0e7f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/2/c */
    { 0x0f00, 0x7d40, 0xf981, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(0,0x198f,26954) }, /* #84/3/3/u */
    { 0x0f7f, 0x7d40, 0x7901, RTFLOAT80U_INIT_C(0,0x198f,26954), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/3/c */
    { 0x0000, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/0/0/u */
    { 0x007f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/0/c */
    { 0x0100, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/0/1/u */
    { 0x017f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/1/c */
    { 0x0200, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/0/2/u */
    { 0x027f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/2/c */
    { 0x0300, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/0/3/u */
    { 0x037f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/3/c */
    { 0x0400, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/1/0/u */
    { 0x047f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/0/c */
    { 0x0500, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/1/1/u */
    { 0x057f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/1/c */
    { 0x0600, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/1/2/u */
    { 0x067f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/2/c */
    { 0x0700, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/1/3/u */
    { 0x077f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/3/c */
    { 0x0800, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/2/0/u */
    { 0x087f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/0/c */
    { 0x0900, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/2/1/u */
    { 0x097f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/1/c */
    { 0x0a00, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/2/2/u */
    { 0x0a7f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/2/c */
    { 0x0b00, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/2/3/u */
    { 0x0b7f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/3/c */
    { 0x0c00, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/3/0/u */
    { 0x0c7f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/0/c */
    { 0x0d00, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/3/1/u */
    { 0x0d7f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/1/c */
    { 0x0e00, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/3/2/u */
    { 0x0e7f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/2/c */
    { 0x0f00, 0x26c1, 0xb881, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772) }, /* #85/3/3/u */
    { 0x0f7f, 0x26c1, 0x3801, RTFLOAT80U_INIT_C(0,0x3330aa30fe4b1486,28772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/3/c */
    { 0x0000, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/0/0/u */
    { 0x007f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/0/0/c */
    { 0x0100, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/0/1/u */
    { 0x017f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/0/1/c */
    { 0x0200, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/0/2/u */
    { 0x027f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/0/2/c */
    { 0x0300, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/0/3/u */
    { 0x037f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/0/3/c */
    { 0x0400, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/1/0/u */
    { 0x047f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/1/0/c */
    { 0x0500, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/1/1/u */
    { 0x057f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/1/1/c */
    { 0x0600, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/1/2/u */
    { 0x067f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/1/2/c */
    { 0x0700, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/1/3/u */
    { 0x077f, 0xc8e2, 0x7a22, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,1) }, /* #86/1/3/c */
    { 0x0800, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/2/0/u */
    { 0x087f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/2/0/c */
    { 0x0900, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/2/1/u */
    { 0x097f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/2/1/c */
    { 0x0a00, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/2/2/u */
    { 0x0a7f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/2/2/c */
    { 0x0b00, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/2/3/u */
    { 0x0b7f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/2/3/c */
    { 0x0c00, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/3/0/u */
    { 0x0c7f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/3/0/c */
    { 0x0d00, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/3/1/u */
    { 0x0d7f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/3/1/c */
    { 0x0e00, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/3/2/u */
    { 0x0e7f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/3/2/c */
    { 0x0f00, 0xc8e2, 0xf882, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a9,0) }, /* #86/3/3/u */
    { 0x0f7f, 0xc8e2, 0x7822, RTFLOAT80U_INIT_C(1,0x80000000000000a9,0), RTFLOAT80U_INIT_C(1,0x80000000000000a8,1) }, /* #86/3/3/c */
    { 0x0000, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/0/0/u */
    { 0x007f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/0/c */
    { 0x0100, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/0/1/u */
    { 0x017f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/1/c */
    { 0x0200, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/0/2/u */
    { 0x027f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/2/c */
    { 0x0300, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/0/3/u */
    { 0x037f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/3/c */
    { 0x0400, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/1/0/u */
    { 0x047f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/0/c */
    { 0x0500, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/1/1/u */
    { 0x057f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/1/c */
    { 0x0600, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/1/2/u */
    { 0x067f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/2/c */
    { 0x0700, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/1/3/u */
    { 0x077f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/3/c */
    { 0x0800, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/2/0/u */
    { 0x087f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/0/c */
    { 0x0900, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/2/1/u */
    { 0x097f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/1/c */
    { 0x0a00, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/2/2/u */
    { 0x0a7f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/2/c */
    { 0x0b00, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/2/3/u */
    { 0x0b7f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/3/c */
    { 0x0c00, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/3/0/u */
    { 0x0c7f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/0/c */
    { 0x0d00, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/3/1/u */
    { 0x0d7f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/1/c */
    { 0x0e00, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/3/2/u */
    { 0x0e7f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/2/c */
    { 0x0f00, 0xaa14, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #87/3/3/u */
    { 0x0f7f, 0xaa14, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/3/c */
    { 0x0000, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/0/0/u */
    { 0x007f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/0/c */
    { 0x0100, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/0/1/u */
    { 0x017f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/1/c */
    { 0x0200, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/0/2/u */
    { 0x027f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/2/c */
    { 0x0300, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/0/3/u */
    { 0x037f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/3/c */
    { 0x0400, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/1/0/u */
    { 0x047f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/0/c */
    { 0x0500, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/1/1/u */
    { 0x057f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/1/c */
    { 0x0600, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/1/2/u */
    { 0x067f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/2/c */
    { 0x0700, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/1/3/u */
    { 0x077f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/3/c */
    { 0x0800, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/2/0/u */
    { 0x087f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/0/c */
    { 0x0900, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/2/1/u */
    { 0x097f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/1/c */
    { 0x0a00, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/2/2/u */
    { 0x0a7f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/2/c */
    { 0x0b00, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/2/3/u */
    { 0x0b7f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/3/c */
    { 0x0c00, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/3/0/u */
    { 0x0c7f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/0/c */
    { 0x0d00, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/3/1/u */
    { 0x0d7f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/1/c */
    { 0x0e00, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/3/2/u */
    { 0x0e7f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/2/c */
    { 0x0f00, 0x5fd3, 0xf981, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764) }, /* #88/3/3/u */
    { 0x0f7f, 0x5fd3, 0x7901, RTFLOAT80U_INIT_C(0,0x49947f8de81346e9,1764), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/3/c */
    { 0x0000, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/0/u */
    { 0x007f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/0/c */
    { 0x0100, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/1/u */
    { 0x017f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/1/c */
    { 0x0200, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/2/u */
    { 0x027f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/2/c */
    { 0x0300, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/3/u */
    { 0x037f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/0/3/c */
    { 0x0400, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/1/0/u */
    { 0x047f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/1/0/c */
    { 0x0500, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/1/1/u */
    { 0x057f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/1/1/c */
    { 0x0600, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/1/2/u */
    { 0x067f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/1/2/c */
    { 0x0700, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/1/3/u */
    { 0x077f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/1/3/c */
    { 0x0800, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/0/u */
    { 0x087f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/0/c */
    { 0x0900, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/1/u */
    { 0x097f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/1/c */
    { 0x0a00, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/2/u */
    { 0x0a7f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/2/c */
    { 0x0b00, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/3/u */
    { 0x0b7f, 0xe693, 0x7a32, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/2/3/c */
    { 0x0c00, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/3/0/u */
    { 0x0c7f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/3/0/c */
    { 0x0d00, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/3/1/u */
    { 0x0d7f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/3/1/c */
    { 0x0e00, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/3/2/u */
    { 0x0e7f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/3/2/c */
    { 0x0f00, 0xe693, 0xf882, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0) }, /* #89/3/3/u */
    { 0x0f7f, 0xe693, 0x7832, RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf1,0), RTFLOAT80U_INIT_C(0,0x5c08b76467ae2cf0,0) }, /* #89/3/3/c */
    { 0x0000, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/0/u */
    { 0x007f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/0/c */
    { 0x0100, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/1/u */
    { 0x017f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/1/c */
    { 0x0200, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/2/u */
    { 0x027f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/2/c */
    { 0x0300, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/3/u */
    { 0x037f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/0/3/c */
    { 0x0400, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/0/u */
    { 0x047f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/0/c */
    { 0x0500, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/1/u */
    { 0x057f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/1/c */
    { 0x0600, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/2/u */
    { 0x067f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/2/c */
    { 0x0700, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/3/u */
    { 0x077f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/1/3/c */
    { 0x0800, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/0/u */
    { 0x087f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/0/c */
    { 0x0900, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/1/u */
    { 0x097f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/1/c */
    { 0x0a00, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/2/u */
    { 0x0a7f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/2/c */
    { 0x0b00, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/3/u */
    { 0x0b7f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/2/3/c */
    { 0x0c00, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/0/u */
    { 0x0c7f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/0/c */
    { 0x0d00, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/1/u */
    { 0x0d7f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/1/c */
    { 0x0e00, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/2/u */
    { 0x0e7f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/2/c */
    { 0x0f00, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/3/u */
    { 0x0f7f, 0xd8cb, 0x7800, RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767), RTFLOAT80U_INIT_C(0,0xc000172e4e024958,32767) }, /* #90/3/3/c */
    { 0x0000, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/0/u */
    { 0x007f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/0/c */
    { 0x0100, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/1/u */
    { 0x017f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/1/c */
    { 0x0200, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/2/u */
    { 0x027f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/2/c */
    { 0x0300, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/3/u */
    { 0x037f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/0/3/c */
    { 0x0400, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/0/u */
    { 0x047f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/0/c */
    { 0x0500, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/1/u */
    { 0x057f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/1/c */
    { 0x0600, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/2/u */
    { 0x067f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/2/c */
    { 0x0700, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/3/u */
    { 0x077f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/1/3/c */
    { 0x0800, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/0/u */
    { 0x087f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/0/c */
    { 0x0900, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/1/u */
    { 0x097f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/1/c */
    { 0x0a00, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/2/u */
    { 0x0a7f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/2/c */
    { 0x0b00, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/3/u */
    { 0x0b7f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/2/3/c */
    { 0x0c00, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/0/u */
    { 0x0c7f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/0/c */
    { 0x0d00, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/1/u */
    { 0x0d7f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/1/c */
    { 0x0e00, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/2/u */
    { 0x0e7f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/2/c */
    { 0x0f00, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/3/u */
    { 0x0f7f, 0x809d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119), RTFLOAT80U_INIT_C(1,0xc577763aa61e2696,32119) }, /* #91/3/3/c */
    { 0x0000, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/0/0/u */
    { 0x007f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/0/c */
    { 0x0100, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/0/1/u */
    { 0x017f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/1/c */
    { 0x0200, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/0/2/u */
    { 0x027f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/2/c */
    { 0x0300, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/0/3/u */
    { 0x037f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/3/c */
    { 0x0400, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/1/0/u */
    { 0x047f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/0/c */
    { 0x0500, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/1/1/u */
    { 0x057f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/1/c */
    { 0x0600, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/1/2/u */
    { 0x067f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/2/c */
    { 0x0700, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/1/3/u */
    { 0x077f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/3/c */
    { 0x0800, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/2/0/u */
    { 0x087f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/0/c */
    { 0x0900, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/2/1/u */
    { 0x097f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/1/c */
    { 0x0a00, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/2/2/u */
    { 0x0a7f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/2/c */
    { 0x0b00, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/2/3/u */
    { 0x0b7f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/3/c */
    { 0x0c00, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/3/0/u */
    { 0x0c7f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/0/c */
    { 0x0d00, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/3/1/u */
    { 0x0d7f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/1/c */
    { 0x0e00, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/3/2/u */
    { 0x0e7f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/2/c */
    { 0x0f00, 0x8ac1, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #92/3/3/u */
    { 0x0f7f, 0x8ac1, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/3/c */
    { 0x0000, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/0/0/u */
    { 0x007f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/0/0/c */
    { 0x0100, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/0/1/u */
    { 0x017f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/0/1/c */
    { 0x0200, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/0/2/u */
    { 0x027f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/0/2/c */
    { 0x0300, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/0/3/u */
    { 0x037f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/0/3/c */
    { 0x0400, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/1/0/u */
    { 0x047f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/1/0/c */
    { 0x0500, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/1/1/u */
    { 0x057f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/1/1/c */
    { 0x0600, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/1/2/u */
    { 0x067f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/1/2/c */
    { 0x0700, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/1/3/u */
    { 0x077f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/1/3/c */
    { 0x0800, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/2/0/u */
    { 0x087f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/2/0/c */
    { 0x0900, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/2/1/u */
    { 0x097f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/2/1/c */
    { 0x0a00, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/2/2/u */
    { 0x0a7f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/2/2/c */
    { 0x0b00, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/2/3/u */
    { 0x0b7f, 0x274b, 0x3b22, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,1) }, /* #93/2/3/c */
    { 0x0c00, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/3/0/u */
    { 0x0c7f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/3/0/c */
    { 0x0d00, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/3/1/u */
    { 0x0d7f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/3/1/c */
    { 0x0e00, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/3/2/u */
    { 0x0e7f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/3/2/c */
    { 0x0f00, 0x274b, 0xb982, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0) }, /* #93/3/3/u */
    { 0x0f7f, 0x274b, 0x3922, RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10b,0), RTFLOAT80U_INIT_C(0,0xac8cdeb00ac0a10a,1) }, /* #93/3/3/c */
    { 0x0000, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/0/0/u */
    { 0x007f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/0/0/c */
    { 0x0100, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/0/1/u */
    { 0x017f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/0/1/c */
    { 0x0200, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/0/2/u */
    { 0x027f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/0/2/c */
    { 0x0300, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/0/3/u */
    { 0x037f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/0/3/c */
    { 0x0400, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/1/0/u */
    { 0x047f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/1/0/c */
    { 0x0500, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/1/1/u */
    { 0x057f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/1/1/c */
    { 0x0600, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/1/2/u */
    { 0x067f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/1/2/c */
    { 0x0700, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/1/3/u */
    { 0x077f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/1/3/c */
    { 0x0800, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/2/0/u */
    { 0x087f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/2/0/c */
    { 0x0900, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/2/1/u */
    { 0x097f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/2/1/c */
    { 0x0a00, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/2/2/u */
    { 0x0a7f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/2/2/c */
    { 0x0b00, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/2/3/u */
    { 0x0b7f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/2/3/c */
    { 0x0c00, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/3/0/u */
    { 0x0c7f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/3/0/c */
    { 0x0d00, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/3/1/u */
    { 0x0d7f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/3/1/c */
    { 0x0e00, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/3/2/u */
    { 0x0e7f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/3/2/c */
    { 0x0f00, 0xca1b, 0xf881, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908) }, /* #94/3/3/u */
    { 0x0f7f, 0xca1b, 0x7801, RTFLOAT80U_INIT_C(1,0x13947a5aac3de53a,21908), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #94/3/3/c */
    { 0x0000, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/0/u */
    { 0x007f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/0/c */
    { 0x0100, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/1/u */
    { 0x017f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/1/c */
    { 0x0200, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/2/u */
    { 0x027f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/2/c */
    { 0x0300, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/3/u */
    { 0x037f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/0/3/c */
    { 0x0400, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/0/u */
    { 0x047f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/0/c */
    { 0x0500, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/1/u */
    { 0x057f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/1/c */
    { 0x0600, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/2/u */
    { 0x067f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/2/c */
    { 0x0700, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/3/u */
    { 0x077f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/1/3/c */
    { 0x0800, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/0/u */
    { 0x087f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/0/c */
    { 0x0900, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/1/u */
    { 0x097f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/1/c */
    { 0x0a00, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/2/u */
    { 0x0a7f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/2/c */
    { 0x0b00, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/3/u */
    { 0x0b7f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/2/3/c */
    { 0x0c00, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/0/u */
    { 0x0c7f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/0/c */
    { 0x0d00, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/1/u */
    { 0x0d7f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/1/c */
    { 0x0e00, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/2/u */
    { 0x0e7f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/2/c */
    { 0x0f00, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/3/u */
    { 0x0f7f, 0x57dd, 0x7900, RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767), RTFLOAT80U_INIT_C(1,0xc4992ee5d49dcf5e,32767) }, /* #95/3/3/c */
    { 0x0000, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/0/u */
    { 0x007f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/0/c */
    { 0x0100, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/1/u */
    { 0x017f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/1/c */
    { 0x0200, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/2/u */
    { 0x027f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/2/c */
    { 0x0300, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/3/u */
    { 0x037f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/0/3/c */
    { 0x0400, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/0/u */
    { 0x047f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/0/c */
    { 0x0500, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/1/u */
    { 0x057f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/1/c */
    { 0x0600, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/2/u */
    { 0x067f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/2/c */
    { 0x0700, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/3/u */
    { 0x077f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/1/3/c */
    { 0x0800, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/0/u */
    { 0x087f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/0/c */
    { 0x0900, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/1/u */
    { 0x097f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/1/c */
    { 0x0a00, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/2/u */
    { 0x0a7f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/2/c */
    { 0x0b00, 0x6634, 0xfaa0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/3/u */
    { 0x0b7f, 0x6634, 0x7a20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e9,16382) }, /* #96/2/3/c */
    { 0x0c00, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/0/u */
    { 0x0c7f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/0/c */
    { 0x0d00, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/1/u */
    { 0x0d7f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/1/c */
    { 0x0e00, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/2/u */
    { 0x0e7f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/2/c */
    { 0x0f00, 0x6634, 0xf8a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/3/u */
    { 0x0f7f, 0x6634, 0x7820, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT80U_INIT_C(0,0xe8c7c58af27bf8e8,16382) }, /* #96/3/3/c */
};
uint32_t const g_cTests_fsin_r80_amd = RT_ELEMENTS(g_aTests_fsin_r80_amd);

FPU_UNARY_R80_TEST_T const g_aTests_fcos_r80_amd[] =
{
    { 0x0000, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/0/0/u */
    { 0x007f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/0/0/c */
    { 0x0100, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/0/1/u */
    { 0x017f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/0/1/c */
    { 0x0200, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/0/2/u */
    { 0x027f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/0/2/c */
    { 0x0300, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/0/3/u */
    { 0x037f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/0/3/c */
    { 0x0400, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/1/0/u */
    { 0x047f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/1/0/c */
    { 0x0500, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/1/1/u */
    { 0x057f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/1/1/c */
    { 0x0600, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/1/2/u */
    { 0x067f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/1/2/c */
    { 0x0700, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/1/3/u */
    { 0x077f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/1/3/c */
    { 0x0800, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/2/0/u */
    { 0x087f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/2/0/c */
    { 0x0900, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/2/1/u */
    { 0x097f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/2/1/c */
    { 0x0a00, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/2/2/u */
    { 0x0a7f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/2/2/c */
    { 0x0b00, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/2/3/u */
    { 0x0b7f, 0xb0c7, 0x3a22, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #0/2/3/c */
    { 0x0c00, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/3/0/u */
    { 0x0c7f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/3/0/c */
    { 0x0d00, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/3/1/u */
    { 0x0d7f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/3/1/c */
    { 0x0e00, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/3/2/u */
    { 0x0e7f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/3/2/c */
    { 0x0f00, 0xb0c7, 0xb882, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(1,0x569aba21a1,0) }, /* #0/3/3/u */
    { 0x0f7f, 0xb0c7, 0x3822, RTFLOAT80U_INIT_C(1,0x569aba21a1,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #0/3/3/c */
    { 0x0000, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/0/0/u */
    { 0x007f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/0/c */
    { 0x0100, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/0/1/u */
    { 0x017f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/1/c */
    { 0x0200, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/0/2/u */
    { 0x027f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/2/c */
    { 0x0300, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/0/3/u */
    { 0x037f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/3/c */
    { 0x0400, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/1/0/u */
    { 0x047f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/0/c */
    { 0x0500, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/1/1/u */
    { 0x057f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/1/c */
    { 0x0600, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/1/2/u */
    { 0x067f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/2/c */
    { 0x0700, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/1/3/u */
    { 0x077f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/3/c */
    { 0x0800, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/2/0/u */
    { 0x087f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/0/c */
    { 0x0900, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/2/1/u */
    { 0x097f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/1/c */
    { 0x0a00, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/2/2/u */
    { 0x0a7f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/2/c */
    { 0x0b00, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/2/3/u */
    { 0x0b7f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/3/c */
    { 0x0c00, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/3/0/u */
    { 0x0c7f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/0/c */
    { 0x0d00, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/3/1/u */
    { 0x0d7f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/1/c */
    { 0x0e00, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/3/2/u */
    { 0x0e7f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/2/c */
    { 0x0f00, 0xa0af, 0xb881, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767) }, /* #1/3/3/u */
    { 0x0f7f, 0xa0af, 0x3801, RTFLOAT80U_INIT_C(1,0x771dffc62814f20,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/3/c */
    { 0x0000, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/0/0/u */
    { 0x007f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/0/c */
    { 0x0100, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/0/1/u */
    { 0x017f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/1/c */
    { 0x0200, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/0/2/u */
    { 0x027f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/2/c */
    { 0x0300, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/0/3/u */
    { 0x037f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/3/c */
    { 0x0400, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/1/0/u */
    { 0x047f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/0/c */
    { 0x0500, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/1/1/u */
    { 0x057f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/1/c */
    { 0x0600, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/1/2/u */
    { 0x067f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/2/c */
    { 0x0700, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/1/3/u */
    { 0x077f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/3/c */
    { 0x0800, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/2/0/u */
    { 0x087f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/0/c */
    { 0x0900, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/2/1/u */
    { 0x097f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/1/c */
    { 0x0a00, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/2/2/u */
    { 0x0a7f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/2/c */
    { 0x0b00, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/2/3/u */
    { 0x0b7f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/3/c */
    { 0x0c00, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/3/0/u */
    { 0x0c7f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/0/c */
    { 0x0d00, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/3/1/u */
    { 0x0d7f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/1/c */
    { 0x0e00, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/3/2/u */
    { 0x0e7f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/2/c */
    { 0x0f00, 0xf0a3, 0xf881, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373) }, /* #2/3/3/u */
    { 0x0f7f, 0xf0a3, 0x7801, RTFLOAT80U_INIT_C(0,0xda837275bf75fa4,2373), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/3/c */
    { 0x0000, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/0/u */
    { 0x007f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/0/c */
    { 0x0100, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/1/u */
    { 0x017f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/1/c */
    { 0x0200, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/2/u */
    { 0x027f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/2/c */
    { 0x0300, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/3/u */
    { 0x037f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/0/3/c */
    { 0x0400, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/0/u */
    { 0x047f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/0/c */
    { 0x0500, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/1/u */
    { 0x057f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/1/c */
    { 0x0600, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/2/u */
    { 0x067f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/2/c */
    { 0x0700, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/3/u */
    { 0x077f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/1/3/c */
    { 0x0800, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/0/u */
    { 0x087f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/0/c */
    { 0x0900, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/1/u */
    { 0x097f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/1/c */
    { 0x0a00, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/2/u */
    { 0x0a7f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/2/c */
    { 0x0b00, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/3/u */
    { 0x0b7f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/2/3/c */
    { 0x0c00, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/0/u */
    { 0x0c7f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/0/c */
    { 0x0d00, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/1/u */
    { 0x0d7f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/1/c */
    { 0x0e00, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/2/u */
    { 0x0e7f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/2/c */
    { 0x0f00, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/3/u */
    { 0x0f7f, 0x1824, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #3/3/3/c */
    { 0x0000, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/0/u */
    { 0x007f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/0/c */
    { 0x0100, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/1/u */
    { 0x017f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/1/c */
    { 0x0200, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/2/u */
    { 0x027f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/2/c */
    { 0x0300, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/3/u */
    { 0x037f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/0/3/c */
    { 0x0400, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/0/u */
    { 0x047f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/0/c */
    { 0x0500, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/1/u */
    { 0x057f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/1/c */
    { 0x0600, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/2/u */
    { 0x067f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/2/c */
    { 0x0700, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/3/u */
    { 0x077f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/1/3/c */
    { 0x0800, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/0/u */
    { 0x087f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/0/c */
    { 0x0900, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/1/u */
    { 0x097f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/1/c */
    { 0x0a00, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/2/u */
    { 0x0a7f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/2/c */
    { 0x0b00, 0x3aa1, 0xbaa0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/3/u */
    { 0x0b7f, 0x3aa1, 0x3a20, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #4/2/3/c */
    { 0x0c00, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/0/u */
    { 0x0c7f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/0/c */
    { 0x0d00, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/1/u */
    { 0x0d7f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/1/c */
    { 0x0e00, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/2/u */
    { 0x0e7f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/2/c */
    { 0x0f00, 0x3aa1, 0xb8a0, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/3/u */
    { 0x0f7f, 0x3aa1, 0x3820, RTFLOAT80U_INIT_C(1,0xe3018ff38ec201c2,11385), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #4/3/3/c */
    { 0x0000, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/0/u */
    { 0x007f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/0/c */
    { 0x0100, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/1/u */
    { 0x017f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/1/c */
    { 0x0200, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/2/u */
    { 0x027f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/2/c */
    { 0x0300, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/3/u */
    { 0x037f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/0/3/c */
    { 0x0400, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/0/u */
    { 0x047f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/0/c */
    { 0x0500, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/1/u */
    { 0x057f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/1/c */
    { 0x0600, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/2/u */
    { 0x067f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/2/c */
    { 0x0700, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/3/u */
    { 0x077f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/1/3/c */
    { 0x0800, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/0/u */
    { 0x087f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/0/c */
    { 0x0900, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/1/u */
    { 0x097f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/1/c */
    { 0x0a00, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/2/u */
    { 0x0a7f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/2/c */
    { 0x0b00, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/3/u */
    { 0x0b7f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/2/3/c */
    { 0x0c00, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/0/u */
    { 0x0c7f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/0/c */
    { 0x0d00, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/1/u */
    { 0x0d7f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/1/c */
    { 0x0e00, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/2/u */
    { 0x0e7f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/2/c */
    { 0x0f00, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/3/u */
    { 0x0f7f, 0x6718, 0x7d00, RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247), RTFLOAT80U_INIT_C(1,0xa9299b3d90db3ba8,22247) }, /* #5/3/3/c */
    { 0x0000, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/0/0/u */
    { 0x007f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/0/0/c */
    { 0x0100, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/0/1/u */
    { 0x017f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/0/1/c */
    { 0x0200, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/0/2/u */
    { 0x027f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/0/2/c */
    { 0x0300, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/0/3/u */
    { 0x037f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/0/3/c */
    { 0x0400, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/1/0/u */
    { 0x047f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/1/0/c */
    { 0x0500, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/1/1/u */
    { 0x057f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/1/1/c */
    { 0x0600, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/1/2/u */
    { 0x067f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/1/2/c */
    { 0x0700, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/1/3/u */
    { 0x077f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/1/3/c */
    { 0x0800, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/2/0/u */
    { 0x087f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/2/0/c */
    { 0x0900, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/2/1/u */
    { 0x097f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/2/1/c */
    { 0x0a00, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/2/2/u */
    { 0x0a7f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/2/2/c */
    { 0x0b00, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/2/3/u */
    { 0x0b7f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/2/3/c */
    { 0x0c00, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/3/0/u */
    { 0x0c7f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/3/0/c */
    { 0x0d00, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/3/1/u */
    { 0x0d7f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/3/1/c */
    { 0x0e00, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/3/2/u */
    { 0x0e7f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/3/2/c */
    { 0x0f00, 0x125c, 0xb881, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662) }, /* #6/3/3/u */
    { 0x0f7f, 0x125c, 0x3801, RTFLOAT80U_INIT_C(1,0x2f2487eb65b48763,3662), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #6/3/3/c */
    { 0x0000, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/0/0/u */
    { 0x007f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/0/0/c */
    { 0x0100, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/0/1/u */
    { 0x017f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/0/1/c */
    { 0x0200, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/0/2/u */
    { 0x027f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/0/2/c */
    { 0x0300, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/0/3/u */
    { 0x037f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/0/3/c */
    { 0x0400, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/1/0/u */
    { 0x047f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/1/0/c */
    { 0x0500, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/1/1/u */
    { 0x057f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/1/1/c */
    { 0x0600, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/1/2/u */
    { 0x067f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/1/2/c */
    { 0x0700, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/1/3/u */
    { 0x077f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/1/3/c */
    { 0x0800, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/2/0/u */
    { 0x087f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/2/0/c */
    { 0x0900, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/2/1/u */
    { 0x097f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/2/1/c */
    { 0x0a00, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/2/2/u */
    { 0x0a7f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/2/2/c */
    { 0x0b00, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/2/3/u */
    { 0x0b7f, 0xee96, 0x7a22, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #7/2/3/c */
    { 0x0c00, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/3/0/u */
    { 0x0c7f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/3/0/c */
    { 0x0d00, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/3/1/u */
    { 0x0d7f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/3/1/c */
    { 0x0e00, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/3/2/u */
    { 0x0e7f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/3/2/c */
    { 0x0f00, 0xee96, 0xf882, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0) }, /* #7/3/3/u */
    { 0x0f7f, 0xee96, 0x7822, RTFLOAT80U_INIT_C(1,0x6c203f0138e795de,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #7/3/3/c */
    { 0x0000, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/0/u */
    { 0x007f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/0/c */
    { 0x0100, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/1/u */
    { 0x017f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/1/c */
    { 0x0200, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/2/u */
    { 0x027f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/2/c */
    { 0x0300, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/3/u */
    { 0x037f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/0/3/c */
    { 0x0400, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/0/u */
    { 0x047f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/0/c */
    { 0x0500, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/1/u */
    { 0x057f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/1/c */
    { 0x0600, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/2/u */
    { 0x067f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/2/c */
    { 0x0700, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/3/u */
    { 0x077f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/1/3/c */
    { 0x0800, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/0/u */
    { 0x087f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/0/c */
    { 0x0900, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/1/u */
    { 0x097f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/1/c */
    { 0x0a00, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/2/u */
    { 0x0a7f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/2/c */
    { 0x0b00, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/3/u */
    { 0x0b7f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/2/3/c */
    { 0x0c00, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/0/u */
    { 0x0c7f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/0/c */
    { 0x0d00, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/1/u */
    { 0x0d7f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/1/c */
    { 0x0e00, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/2/u */
    { 0x0e7f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/2/c */
    { 0x0f00, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/3/u */
    { 0x0f7f, 0x7ed3, 0x7c00, RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576), RTFLOAT80U_INIT_C(1,0x9c8aeae34235d657,27576) }, /* #8/3/3/c */
    { 0x0000, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/0/u */
    { 0x007f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/0/c */
    { 0x0100, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/1/u */
    { 0x017f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/1/c */
    { 0x0200, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/2/u */
    { 0x027f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/2/c */
    { 0x0300, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/3/u */
    { 0x037f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/0/3/c */
    { 0x0400, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/0/u */
    { 0x047f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/0/c */
    { 0x0500, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/1/u */
    { 0x057f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/1/c */
    { 0x0600, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/2/u */
    { 0x067f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/2/c */
    { 0x0700, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/3/u */
    { 0x077f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/1/3/c */
    { 0x0800, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/0/u */
    { 0x087f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/0/c */
    { 0x0900, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/1/u */
    { 0x097f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/1/c */
    { 0x0a00, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/2/u */
    { 0x0a7f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/2/c */
    { 0x0b00, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/3/u */
    { 0x0b7f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/2/3/c */
    { 0x0c00, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/0/u */
    { 0x0c7f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/0/c */
    { 0x0d00, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/1/u */
    { 0x0d7f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/1/c */
    { 0x0e00, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/2/u */
    { 0x0e7f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/2/c */
    { 0x0f00, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/3/u */
    { 0x0f7f, 0x769a, 0x7c00, RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877), RTFLOAT80U_INIT_C(0,0x8d46d9d2dd1b6f28,28877) }, /* #9/3/3/c */
    { 0x0000, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/0/u */
    { 0x007f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/0/c */
    { 0x0100, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/1/u */
    { 0x017f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/1/c */
    { 0x0200, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/2/u */
    { 0x027f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/2/c */
    { 0x0300, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/3/u */
    { 0x037f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/0/3/c */
    { 0x0400, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/0/u */
    { 0x047f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/0/c */
    { 0x0500, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/1/u */
    { 0x057f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/1/c */
    { 0x0600, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/2/u */
    { 0x067f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/2/c */
    { 0x0700, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/3/u */
    { 0x077f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/1/3/c */
    { 0x0800, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/0/u */
    { 0x087f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/0/c */
    { 0x0900, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/1/u */
    { 0x097f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/1/c */
    { 0x0a00, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/2/u */
    { 0x0a7f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/2/c */
    { 0x0b00, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/3/u */
    { 0x0b7f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/2/3/c */
    { 0x0c00, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/0/u */
    { 0x0c7f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/0/c */
    { 0x0d00, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/1/u */
    { 0x0d7f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/1/c */
    { 0x0e00, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/2/u */
    { 0x0e7f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/2/c */
    { 0x0f00, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/3/u */
    { 0x0f7f, 0xade4, 0x3900, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #10/3/3/c */
    { 0x0000, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/0/0/u */
    { 0x007f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/0/0/c */
    { 0x0100, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/0/1/u */
    { 0x017f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/0/1/c */
    { 0x0200, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/0/2/u */
    { 0x027f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/0/2/c */
    { 0x0300, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/0/3/u */
    { 0x037f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/0/3/c */
    { 0x0400, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/1/0/u */
    { 0x047f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/1/0/c */
    { 0x0500, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/1/1/u */
    { 0x057f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/1/1/c */
    { 0x0600, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/1/2/u */
    { 0x067f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/1/2/c */
    { 0x0700, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/1/3/u */
    { 0x077f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/1/3/c */
    { 0x0800, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/2/0/u */
    { 0x087f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/2/0/c */
    { 0x0900, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/2/1/u */
    { 0x097f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/2/1/c */
    { 0x0a00, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/2/2/u */
    { 0x0a7f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/2/2/c */
    { 0x0b00, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/2/3/u */
    { 0x0b7f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/2/3/c */
    { 0x0c00, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/3/0/u */
    { 0x0c7f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/3/0/c */
    { 0x0d00, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/3/1/u */
    { 0x0d7f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/3/1/c */
    { 0x0e00, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/3/2/u */
    { 0x0e7f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/3/2/c */
    { 0x0f00, 0xe676, 0xf881, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767) }, /* #11/3/3/u */
    { 0x0f7f, 0xe676, 0x7801, RTFLOAT80U_INIT_C(0,0x1c0c3d7b,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #11/3/3/c */
    { 0x0000, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/0/0/u */
    { 0x007f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/0/c */
    { 0x0100, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/0/1/u */
    { 0x017f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/1/c */
    { 0x0200, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/0/2/u */
    { 0x027f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/2/c */
    { 0x0300, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/0/3/u */
    { 0x037f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/3/c */
    { 0x0400, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/1/0/u */
    { 0x047f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/0/c */
    { 0x0500, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/1/1/u */
    { 0x057f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/1/c */
    { 0x0600, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/1/2/u */
    { 0x067f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/2/c */
    { 0x0700, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/1/3/u */
    { 0x077f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/3/c */
    { 0x0800, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/2/0/u */
    { 0x087f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/0/c */
    { 0x0900, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/2/1/u */
    { 0x097f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/1/c */
    { 0x0a00, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/2/2/u */
    { 0x0a7f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/2/c */
    { 0x0b00, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/2/3/u */
    { 0x0b7f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/3/c */
    { 0x0c00, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/3/0/u */
    { 0x0c7f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/0/c */
    { 0x0d00, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/3/1/u */
    { 0x0d7f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/1/c */
    { 0x0e00, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/3/2/u */
    { 0x0e7f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/2/c */
    { 0x0f00, 0xf9e1, 0xf981, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432) }, /* #12/3/3/u */
    { 0x0f7f, 0xf9e1, 0x7901, RTFLOAT80U_INIT_C(0,0x49d4f32ee11676da,30432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/3/c */
    { 0x0000, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/0/0/u */
    { 0x007f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/0/0/c */
    { 0x0100, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/0/1/u */
    { 0x017f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/0/1/c */
    { 0x0200, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/0/2/u */
    { 0x027f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/0/2/c */
    { 0x0300, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/0/3/u */
    { 0x037f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/0/3/c */
    { 0x0400, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/1/0/u */
    { 0x047f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/1/0/c */
    { 0x0500, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/1/1/u */
    { 0x057f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/1/1/c */
    { 0x0600, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/1/2/u */
    { 0x067f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/1/2/c */
    { 0x0700, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/1/3/u */
    { 0x077f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/1/3/c */
    { 0x0800, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/2/0/u */
    { 0x087f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/2/0/c */
    { 0x0900, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/2/1/u */
    { 0x097f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/2/1/c */
    { 0x0a00, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/2/2/u */
    { 0x0a7f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/2/2/c */
    { 0x0b00, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/2/3/u */
    { 0x0b7f, 0x723d, 0x7a22, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #13/2/3/c */
    { 0x0c00, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/3/0/u */
    { 0x0c7f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/3/0/c */
    { 0x0d00, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/3/1/u */
    { 0x0d7f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/3/1/c */
    { 0x0e00, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/3/2/u */
    { 0x0e7f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/3/2/c */
    { 0x0f00, 0x723d, 0xf882, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(1,0x50b1b14f6,0) }, /* #13/3/3/u */
    { 0x0f7f, 0x723d, 0x7822, RTFLOAT80U_INIT_C(1,0x50b1b14f6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #13/3/3/c */
    { 0x0000, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/0/u */
    { 0x007f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/0/c */
    { 0x0100, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/1/u */
    { 0x017f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/1/c */
    { 0x0200, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/2/u */
    { 0x027f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/2/c */
    { 0x0300, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/3/u */
    { 0x037f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/0/3/c */
    { 0x0400, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/0/u */
    { 0x047f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/0/c */
    { 0x0500, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/1/u */
    { 0x057f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/1/c */
    { 0x0600, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/2/u */
    { 0x067f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/2/c */
    { 0x0700, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/3/u */
    { 0x077f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/1/3/c */
    { 0x0800, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/0/u */
    { 0x087f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/0/c */
    { 0x0900, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/1/u */
    { 0x097f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/1/c */
    { 0x0a00, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/2/u */
    { 0x0a7f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/2/c */
    { 0x0b00, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/3/u */
    { 0x0b7f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/2/3/c */
    { 0x0c00, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/0/u */
    { 0x0c7f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/0/c */
    { 0x0d00, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/1/u */
    { 0x0d7f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/1/c */
    { 0x0e00, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/2/u */
    { 0x0e7f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/2/c */
    { 0x0f00, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/3/u */
    { 0x0f7f, 0x29fc, 0x3d00, RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885), RTFLOAT80U_INIT_C(0,0xb954fcc2d7184106,16885) }, /* #14/3/3/c */
    { 0x0000, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/0/u */
    { 0x007f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/0/c */
    { 0x0100, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/1/u */
    { 0x017f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/1/c */
    { 0x0200, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/2/u */
    { 0x027f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/2/c */
    { 0x0300, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/3/u */
    { 0x037f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/0/3/c */
    { 0x0400, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/0/u */
    { 0x047f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/0/c */
    { 0x0500, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/1/u */
    { 0x057f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/1/c */
    { 0x0600, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/2/u */
    { 0x067f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/2/c */
    { 0x0700, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/3/u */
    { 0x077f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/1/3/c */
    { 0x0800, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/0/u */
    { 0x087f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/0/c */
    { 0x0900, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/1/u */
    { 0x097f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/1/c */
    { 0x0a00, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/2/u */
    { 0x0a7f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/2/c */
    { 0x0b00, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/3/u */
    { 0x0b7f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/2/3/c */
    { 0x0c00, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/0/u */
    { 0x0c7f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/0/c */
    { 0x0d00, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/1/u */
    { 0x0d7f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/1/c */
    { 0x0e00, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/2/u */
    { 0x0e7f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/2/c */
    { 0x0f00, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/3/u */
    { 0x0f7f, 0x8827, 0x3c00, RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742), RTFLOAT80U_INIT_C(0,0x9abc54d425847385,22742) }, /* #15/3/3/c */
    { 0x0000, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/0/0/u */
    { 0x007f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/0/0/c */
    { 0x0100, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/0/1/u */
    { 0x017f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/0/1/c */
    { 0x0200, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/0/2/u */
    { 0x027f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/0/2/c */
    { 0x0300, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/0/3/u */
    { 0x037f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/0/3/c */
    { 0x0400, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/1/0/u */
    { 0x047f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/1/0/c */
    { 0x0500, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/1/1/u */
    { 0x057f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/1/1/c */
    { 0x0600, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/1/2/u */
    { 0x067f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/1/2/c */
    { 0x0700, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/1/3/u */
    { 0x077f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/1/3/c */
    { 0x0800, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/2/0/u */
    { 0x087f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/2/0/c */
    { 0x0900, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/2/1/u */
    { 0x097f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/2/1/c */
    { 0x0a00, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/2/2/u */
    { 0x0a7f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/2/2/c */
    { 0x0b00, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/2/3/u */
    { 0x0b7f, 0x5ae3, 0x7a22, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #16/2/3/c */
    { 0x0c00, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/3/0/u */
    { 0x0c7f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/3/0/c */
    { 0x0d00, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/3/1/u */
    { 0x0d7f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/3/1/c */
    { 0x0e00, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/3/2/u */
    { 0x0e7f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/3/2/c */
    { 0x0f00, 0x5ae3, 0xf882, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0) }, /* #16/3/3/u */
    { 0x0f7f, 0x5ae3, 0x7822, RTFLOAT80U_INIT_C(1,0x434dc19b131eae6,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #16/3/3/c */
    { 0x0000, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/0/u */
    { 0x007f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/0/c */
    { 0x0100, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/1/u */
    { 0x017f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/1/c */
    { 0x0200, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/2/u */
    { 0x027f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/2/c */
    { 0x0300, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/3/u */
    { 0x037f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/0/3/c */
    { 0x0400, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/0/u */
    { 0x047f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/0/c */
    { 0x0500, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/1/u */
    { 0x057f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/1/c */
    { 0x0600, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/2/u */
    { 0x067f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/2/c */
    { 0x0700, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/3/u */
    { 0x077f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/1/3/c */
    { 0x0800, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/0/u */
    { 0x087f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/0/c */
    { 0x0900, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/1/u */
    { 0x097f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/1/c */
    { 0x0a00, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/2/u */
    { 0x0a7f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/2/c */
    { 0x0b00, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/3/u */
    { 0x0b7f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/2/3/c */
    { 0x0c00, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/0/u */
    { 0x0c7f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/0/c */
    { 0x0d00, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/1/u */
    { 0x0d7f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/1/c */
    { 0x0e00, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/2/u */
    { 0x0e7f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/2/c */
    { 0x0f00, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/3/u */
    { 0x0f7f, 0x8133, 0x3d00, RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604), RTFLOAT80U_INIT_C(0,0x815f3c2bf23b0758,19604) }, /* #17/3/3/c */
    { 0x0000, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/0/u */
    { 0x007f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/0/c */
    { 0x0100, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/1/u */
    { 0x017f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/1/c */
    { 0x0200, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/2/u */
    { 0x027f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/2/c */
    { 0x0300, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/3/u */
    { 0x037f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/0/3/c */
    { 0x0400, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/0/u */
    { 0x047f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/0/c */
    { 0x0500, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/1/u */
    { 0x057f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/1/c */
    { 0x0600, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/2/u */
    { 0x067f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/2/c */
    { 0x0700, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/3/u */
    { 0x077f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/1/3/c */
    { 0x0800, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/0/u */
    { 0x087f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/0/c */
    { 0x0900, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/1/u */
    { 0x097f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/1/c */
    { 0x0a00, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/2/u */
    { 0x0a7f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/2/c */
    { 0x0b00, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/3/u */
    { 0x0b7f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/2/3/c */
    { 0x0c00, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/0/u */
    { 0x0c7f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/0/c */
    { 0x0d00, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/1/u */
    { 0x0d7f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/1/c */
    { 0x0e00, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/2/u */
    { 0x0e7f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/2/c */
    { 0x0f00, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/3/u */
    { 0x0f7f, 0x1316, 0x3d00, RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590), RTFLOAT80U_INIT_C(1,0x96f5f4f4d96e46fa,27590) }, /* #18/3/3/c */
    { 0x0000, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/0/0/u */
    { 0x007f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/0/0/c */
    { 0x0100, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/0/1/u */
    { 0x017f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/0/1/c */
    { 0x0200, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/0/2/u */
    { 0x027f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/0/2/c */
    { 0x0300, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/0/3/u */
    { 0x037f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/0/3/c */
    { 0x0400, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/1/0/u */
    { 0x047f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/1/0/c */
    { 0x0500, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/1/1/u */
    { 0x057f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/1/1/c */
    { 0x0600, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/1/2/u */
    { 0x067f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/1/2/c */
    { 0x0700, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/1/3/u */
    { 0x077f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/1/3/c */
    { 0x0800, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/2/0/u */
    { 0x087f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/2/0/c */
    { 0x0900, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/2/1/u */
    { 0x097f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/2/1/c */
    { 0x0a00, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/2/2/u */
    { 0x0a7f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/2/2/c */
    { 0x0b00, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/2/3/u */
    { 0x0b7f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/2/3/c */
    { 0x0c00, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/3/0/u */
    { 0x0c7f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/3/0/c */
    { 0x0d00, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/3/1/u */
    { 0x0d7f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/3/1/c */
    { 0x0e00, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/3/2/u */
    { 0x0e7f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/3/2/c */
    { 0x0f00, 0x952d, 0xb981, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506) }, /* #19/3/3/u */
    { 0x0f7f, 0x952d, 0x3901, RTFLOAT80U_INIT_C(0,0x63819c5fdc0940dd,21506), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #19/3/3/c */
    { 0x0000, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/0/u */
    { 0x007f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/0/c */
    { 0x0100, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/1/u */
    { 0x017f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/1/c */
    { 0x0200, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/2/u */
    { 0x027f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/2/c */
    { 0x0300, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/3/u */
    { 0x037f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/0/3/c */
    { 0x0400, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/0/u */
    { 0x047f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/0/c */
    { 0x0500, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/1/u */
    { 0x057f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/1/c */
    { 0x0600, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/2/u */
    { 0x067f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/2/c */
    { 0x0700, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/3/u */
    { 0x077f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/1/3/c */
    { 0x0800, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/0/u */
    { 0x087f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/0/c */
    { 0x0900, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/1/u */
    { 0x097f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/1/c */
    { 0x0a00, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/2/u */
    { 0x0a7f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/2/c */
    { 0x0b00, 0x855c, 0xbba0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/3/u */
    { 0x0b7f, 0x855c, 0x3b20, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #20/2/3/c */
    { 0x0c00, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/0/u */
    { 0x0c7f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/0/c */
    { 0x0d00, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/1/u */
    { 0x0d7f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/1/c */
    { 0x0e00, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/2/u */
    { 0x0e7f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/2/c */
    { 0x0f00, 0x855c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/3/u */
    { 0x0f7f, 0x855c, 0x3920, RTFLOAT80U_INIT_C(0,0xc06ebe94cdcbd297,1944), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #20/3/3/c */
    { 0x0000, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/0/0/u */
    { 0x007f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/0/c */
    { 0x0100, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/0/1/u */
    { 0x017f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/1/c */
    { 0x0200, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/0/2/u */
    { 0x027f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/2/c */
    { 0x0300, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/0/3/u */
    { 0x037f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/3/c */
    { 0x0400, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/1/0/u */
    { 0x047f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/0/c */
    { 0x0500, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/1/1/u */
    { 0x057f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/1/c */
    { 0x0600, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/1/2/u */
    { 0x067f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/2/c */
    { 0x0700, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/1/3/u */
    { 0x077f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/3/c */
    { 0x0800, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/2/0/u */
    { 0x087f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/0/c */
    { 0x0900, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/2/1/u */
    { 0x097f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/1/c */
    { 0x0a00, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/2/2/u */
    { 0x0a7f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/2/c */
    { 0x0b00, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/2/3/u */
    { 0x0b7f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/3/c */
    { 0x0c00, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/3/0/u */
    { 0x0c7f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/0/c */
    { 0x0d00, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/3/1/u */
    { 0x0d7f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/1/c */
    { 0x0e00, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/3/2/u */
    { 0x0e7f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/2/c */
    { 0x0f00, 0x27c0, 0xb981, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097) }, /* #21/3/3/u */
    { 0x0f7f, 0x27c0, 0x3901, RTFLOAT80U_INIT_C(1,0x5a6298a28f206f2b,25097), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/3/c */
    { 0x0000, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/0/0/u */
    { 0x007f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/0/c */
    { 0x0100, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/0/1/u */
    { 0x017f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/1/c */
    { 0x0200, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/0/2/u */
    { 0x027f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/2/c */
    { 0x0300, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/0/3/u */
    { 0x037f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/3/c */
    { 0x0400, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/1/0/u */
    { 0x047f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/0/c */
    { 0x0500, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/1/1/u */
    { 0x057f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/1/c */
    { 0x0600, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/1/2/u */
    { 0x067f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/2/c */
    { 0x0700, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/1/3/u */
    { 0x077f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/3/c */
    { 0x0800, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/2/0/u */
    { 0x087f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/0/c */
    { 0x0900, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/2/1/u */
    { 0x097f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/1/c */
    { 0x0a00, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/2/2/u */
    { 0x0a7f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/2/c */
    { 0x0b00, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/2/3/u */
    { 0x0b7f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/3/c */
    { 0x0c00, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/3/0/u */
    { 0x0c7f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/0/c */
    { 0x0d00, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/3/1/u */
    { 0x0d7f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/1/c */
    { 0x0e00, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/3/2/u */
    { 0x0e7f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/2/c */
    { 0x0f00, 0xebfe, 0xf981, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431) }, /* #22/3/3/u */
    { 0x0f7f, 0xebfe, 0x7901, RTFLOAT80U_INIT_C(0,0x32979b0f9056ccad,12431), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/3/c */
    { 0x0000, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/0/0/u */
    { 0x007f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/0/c */
    { 0x0100, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/0/1/u */
    { 0x017f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/1/c */
    { 0x0200, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/0/2/u */
    { 0x027f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/2/c */
    { 0x0300, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/0/3/u */
    { 0x037f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/3/c */
    { 0x0400, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/1/0/u */
    { 0x047f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/0/c */
    { 0x0500, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/1/1/u */
    { 0x057f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/1/c */
    { 0x0600, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/1/2/u */
    { 0x067f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/2/c */
    { 0x0700, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/1/3/u */
    { 0x077f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/3/c */
    { 0x0800, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/2/0/u */
    { 0x087f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/0/c */
    { 0x0900, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/2/1/u */
    { 0x097f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/1/c */
    { 0x0a00, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/2/2/u */
    { 0x0a7f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/2/c */
    { 0x0b00, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/2/3/u */
    { 0x0b7f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/3/c */
    { 0x0c00, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/3/0/u */
    { 0x0c7f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/0/c */
    { 0x0d00, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/3/1/u */
    { 0x0d7f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/1/c */
    { 0x0e00, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/3/2/u */
    { 0x0e7f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/2/c */
    { 0x0f00, 0xa7c4, 0xb981, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290) }, /* #23/3/3/u */
    { 0x0f7f, 0xa7c4, 0x3901, RTFLOAT80U_INIT_C(0,0x7fed369b77c08350,15290), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/3/c */
    { 0x0000, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/0/u */
    { 0x007f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/0/c */
    { 0x0100, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/1/u */
    { 0x017f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/1/c */
    { 0x0200, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/2/u */
    { 0x027f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/2/c */
    { 0x0300, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/3/u */
    { 0x037f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/0/3/c */
    { 0x0400, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/0/u */
    { 0x047f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/0/c */
    { 0x0500, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/1/u */
    { 0x057f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/1/c */
    { 0x0600, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/2/u */
    { 0x067f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/2/c */
    { 0x0700, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/3/u */
    { 0x077f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/1/3/c */
    { 0x0800, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/0/u */
    { 0x087f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/0/c */
    { 0x0900, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/1/u */
    { 0x097f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/1/c */
    { 0x0a00, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/2/u */
    { 0x0a7f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/2/c */
    { 0x0b00, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/3/u */
    { 0x0b7f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/2/3/c */
    { 0x0c00, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/0/u */
    { 0x0c7f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/0/c */
    { 0x0d00, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/1/u */
    { 0x0d7f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/1/c */
    { 0x0e00, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/2/u */
    { 0x0e7f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/2/c */
    { 0x0f00, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/3/u */
    { 0x0f7f, 0xd836, 0x7c00, RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099), RTFLOAT80U_INIT_C(1,0xbd7bb95e6c513cee,27099) }, /* #24/3/3/c */
    { 0x0000, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/0/u */
    { 0x007f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/0/c */
    { 0x0100, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/1/u */
    { 0x017f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/1/c */
    { 0x0200, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/2/u */
    { 0x027f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/2/c */
    { 0x0300, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/3/u */
    { 0x037f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/0/3/c */
    { 0x0400, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/0/u */
    { 0x047f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/0/c */
    { 0x0500, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/1/u */
    { 0x057f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/1/c */
    { 0x0600, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/2/u */
    { 0x067f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/2/c */
    { 0x0700, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/3/u */
    { 0x077f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/1/3/c */
    { 0x0800, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/0/u */
    { 0x087f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/0/c */
    { 0x0900, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/1/u */
    { 0x097f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/1/c */
    { 0x0a00, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/2/u */
    { 0x0a7f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/2/c */
    { 0x0b00, 0x0832, 0xbaa0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/3/u */
    { 0x0b7f, 0x0832, 0x3a20, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #25/2/3/c */
    { 0x0c00, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/0/u */
    { 0x0c7f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/0/c */
    { 0x0d00, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/1/u */
    { 0x0d7f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/1/c */
    { 0x0e00, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/2/u */
    { 0x0e7f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/2/c */
    { 0x0f00, 0x0832, 0xb8a0, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/3/u */
    { 0x0f7f, 0x0832, 0x3820, RTFLOAT80U_INIT_C(0,0x922d38e0be15efb8,882), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #25/3/3/c */
    { 0x0000, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/0/0/u */
    { 0x007f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/0/c */
    { 0x0100, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/0/1/u */
    { 0x017f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/1/c */
    { 0x0200, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/0/2/u */
    { 0x027f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/2/c */
    { 0x0300, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/0/3/u */
    { 0x037f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/3/c */
    { 0x0400, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/1/0/u */
    { 0x047f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/0/c */
    { 0x0500, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/1/1/u */
    { 0x057f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/1/c */
    { 0x0600, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/1/2/u */
    { 0x067f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/2/c */
    { 0x0700, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/1/3/u */
    { 0x077f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/3/c */
    { 0x0800, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/2/0/u */
    { 0x087f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/0/c */
    { 0x0900, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/2/1/u */
    { 0x097f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/1/c */
    { 0x0a00, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/2/2/u */
    { 0x0a7f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/2/c */
    { 0x0b00, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/2/3/u */
    { 0x0b7f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/3/c */
    { 0x0c00, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/3/0/u */
    { 0x0c7f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/0/c */
    { 0x0d00, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/3/1/u */
    { 0x0d7f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/1/c */
    { 0x0e00, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/3/2/u */
    { 0x0e7f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/2/c */
    { 0x0f00, 0xf0cd, 0xf881, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767) }, /* #26/3/3/u */
    { 0x0f7f, 0xf0cd, 0x7801, RTFLOAT80U_INIT_C(0,0x40000000000077f0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/3/c */
    { 0x0000, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/0/0/u */
    { 0x007f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/0/c */
    { 0x0100, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/0/1/u */
    { 0x017f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/1/c */
    { 0x0200, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/0/2/u */
    { 0x027f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/2/c */
    { 0x0300, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/0/3/u */
    { 0x037f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/0/3/c */
    { 0x0400, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/1/0/u */
    { 0x047f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/0/c */
    { 0x0500, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/1/1/u */
    { 0x057f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/1/c */
    { 0x0600, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/1/2/u */
    { 0x067f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/2/c */
    { 0x0700, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/1/3/u */
    { 0x077f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/1/3/c */
    { 0x0800, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/2/0/u */
    { 0x087f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/0/c */
    { 0x0900, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/2/1/u */
    { 0x097f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/1/c */
    { 0x0a00, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/2/2/u */
    { 0x0a7f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/2/c */
    { 0x0b00, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/2/3/u */
    { 0x0b7f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/2/3/c */
    { 0x0c00, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/3/0/u */
    { 0x0c7f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/0/c */
    { 0x0d00, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/3/1/u */
    { 0x0d7f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/1/c */
    { 0x0e00, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/3/2/u */
    { 0x0e7f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/2/c */
    { 0x0f00, 0xb62b, 0xb881, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767) }, /* #27/3/3/u */
    { 0x0f7f, 0xb62b, 0x3801, RTFLOAT80U_INIT_C(1,0x784958132ed74a36,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #27/3/3/c */
    { 0x0000, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/0/0/u */
    { 0x007f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/0/0/c */
    { 0x0100, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/0/1/u */
    { 0x017f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/0/1/c */
    { 0x0200, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/0/2/u */
    { 0x027f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/0/2/c */
    { 0x0300, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/0/3/u */
    { 0x037f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/0/3/c */
    { 0x0400, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/1/0/u */
    { 0x047f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/1/0/c */
    { 0x0500, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/1/1/u */
    { 0x057f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/1/1/c */
    { 0x0600, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/1/2/u */
    { 0x067f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/1/2/c */
    { 0x0700, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/1/3/u */
    { 0x077f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/1/3/c */
    { 0x0800, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/2/0/u */
    { 0x087f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/2/0/c */
    { 0x0900, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/2/1/u */
    { 0x097f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/2/1/c */
    { 0x0a00, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/2/2/u */
    { 0x0a7f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/2/2/c */
    { 0x0b00, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/2/3/u */
    { 0x0b7f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/2/3/c */
    { 0x0c00, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/3/0/u */
    { 0x0c7f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/3/0/c */
    { 0x0d00, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/3/1/u */
    { 0x0d7f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/3/1/c */
    { 0x0e00, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/3/2/u */
    { 0x0e7f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/3/2/c */
    { 0x0f00, 0x1b9d, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #28/3/3/u */
    { 0x0f7f, 0x1b9d, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #28/3/3/c */
    { 0x0000, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/0/u */
    { 0x007f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/0/c */
    { 0x0100, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/1/u */
    { 0x017f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/1/c */
    { 0x0200, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/2/u */
    { 0x027f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/2/c */
    { 0x0300, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/3/u */
    { 0x037f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/0/3/c */
    { 0x0400, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/0/u */
    { 0x047f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/0/c */
    { 0x0500, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/1/u */
    { 0x057f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/1/c */
    { 0x0600, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/2/u */
    { 0x067f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/2/c */
    { 0x0700, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/3/u */
    { 0x077f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/1/3/c */
    { 0x0800, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/0/u */
    { 0x087f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/0/c */
    { 0x0900, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/1/u */
    { 0x097f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/1/c */
    { 0x0a00, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/2/u */
    { 0x0a7f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/2/c */
    { 0x0b00, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/3/u */
    { 0x0b7f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/2/3/c */
    { 0x0c00, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/0/u */
    { 0x0c7f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/0/c */
    { 0x0d00, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/1/u */
    { 0x0d7f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/1/c */
    { 0x0e00, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/2/u */
    { 0x0e7f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/2/c */
    { 0x0f00, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/3/u */
    { 0x0f7f, 0xbfc8, 0x3900, RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767), RTFLOAT80U_INIT_C(1,0xeead43789a9ae300,32767) }, /* #29/3/3/c */
    { 0x0000, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/0/u */
    { 0x007f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/0/c */
    { 0x0100, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/1/u */
    { 0x017f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/1/c */
    { 0x0200, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/2/u */
    { 0x027f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/2/c */
    { 0x0300, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/3/u */
    { 0x037f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/0/3/c */
    { 0x0400, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/0/u */
    { 0x047f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/0/c */
    { 0x0500, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/1/u */
    { 0x057f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/1/c */
    { 0x0600, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/2/u */
    { 0x067f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/2/c */
    { 0x0700, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/3/u */
    { 0x077f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/1/3/c */
    { 0x0800, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/0/u */
    { 0x087f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/0/c */
    { 0x0900, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/1/u */
    { 0x097f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/1/c */
    { 0x0a00, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/2/u */
    { 0x0a7f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/2/c */
    { 0x0b00, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/3/u */
    { 0x0b7f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/2/3/c */
    { 0x0c00, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/0/u */
    { 0x0c7f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/0/c */
    { 0x0d00, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/1/u */
    { 0x0d7f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/1/c */
    { 0x0e00, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/2/u */
    { 0x0e7f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/2/c */
    { 0x0f00, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/3/u */
    { 0x0f7f, 0x1188, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #30/3/3/c */
    { 0x0000, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/0/0/u */
    { 0x007f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/0/c */
    { 0x0100, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/0/1/u */
    { 0x017f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/1/c */
    { 0x0200, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/0/2/u */
    { 0x027f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/2/c */
    { 0x0300, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/0/3/u */
    { 0x037f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/3/c */
    { 0x0400, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/1/0/u */
    { 0x047f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/0/c */
    { 0x0500, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/1/1/u */
    { 0x057f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/1/c */
    { 0x0600, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/1/2/u */
    { 0x067f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/2/c */
    { 0x0700, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/1/3/u */
    { 0x077f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/3/c */
    { 0x0800, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/2/0/u */
    { 0x087f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/0/c */
    { 0x0900, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/2/1/u */
    { 0x097f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/1/c */
    { 0x0a00, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/2/2/u */
    { 0x0a7f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/2/c */
    { 0x0b00, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/2/3/u */
    { 0x0b7f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/3/c */
    { 0x0c00, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/3/0/u */
    { 0x0c7f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/0/c */
    { 0x0d00, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/3/1/u */
    { 0x0d7f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/1/c */
    { 0x0e00, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/3/2/u */
    { 0x0e7f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/2/c */
    { 0x0f00, 0xa1fd, 0xb981, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #31/3/3/u */
    { 0x0f7f, 0xa1fd, 0x3901, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/3/c */
    { 0x0000, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/0/0/u */
    { 0x007f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/0/c */
    { 0x0100, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/0/1/u */
    { 0x017f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/1/c */
    { 0x0200, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/0/2/u */
    { 0x027f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/2/c */
    { 0x0300, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/0/3/u */
    { 0x037f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/3/c */
    { 0x0400, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/1/0/u */
    { 0x047f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/0/c */
    { 0x0500, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/1/1/u */
    { 0x057f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/1/c */
    { 0x0600, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/1/2/u */
    { 0x067f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/2/c */
    { 0x0700, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/1/3/u */
    { 0x077f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/3/c */
    { 0x0800, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/2/0/u */
    { 0x087f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/0/c */
    { 0x0900, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/2/1/u */
    { 0x097f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/1/c */
    { 0x0a00, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/2/2/u */
    { 0x0a7f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/2/c */
    { 0x0b00, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/2/3/u */
    { 0x0b7f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/3/c */
    { 0x0c00, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/3/0/u */
    { 0x0c7f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/0/c */
    { 0x0d00, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/3/1/u */
    { 0x0d7f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/1/c */
    { 0x0e00, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/3/2/u */
    { 0x0e7f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/2/c */
    { 0x0f00, 0xcd7c, 0xf981, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #32/3/3/u */
    { 0x0f7f, 0xcd7c, 0x7901, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/3/c */
    { 0x0000, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/0/0/u */
    { 0x007f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/0/0/c */
    { 0x0100, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/0/1/u */
    { 0x017f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/0/1/c */
    { 0x0200, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/0/2/u */
    { 0x027f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/0/2/c */
    { 0x0300, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/0/3/u */
    { 0x037f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/0/3/c */
    { 0x0400, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/1/0/u */
    { 0x047f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/1/0/c */
    { 0x0500, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/1/1/u */
    { 0x057f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/1/1/c */
    { 0x0600, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/1/2/u */
    { 0x067f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/1/2/c */
    { 0x0700, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/1/3/u */
    { 0x077f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/1/3/c */
    { 0x0800, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/2/0/u */
    { 0x087f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/2/0/c */
    { 0x0900, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/2/1/u */
    { 0x097f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/2/1/c */
    { 0x0a00, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/2/2/u */
    { 0x0a7f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/2/2/c */
    { 0x0b00, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/2/3/u */
    { 0x0b7f, 0x3e51, 0x3a22, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #33/2/3/c */
    { 0x0c00, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/3/0/u */
    { 0x0c7f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/3/0/c */
    { 0x0d00, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/3/1/u */
    { 0x0d7f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/3/1/c */
    { 0x0e00, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/3/2/u */
    { 0x0e7f, 0x3e51, 0x3822, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16382) }, /* #33/3/2/c */
    { 0x0f00, 0x3e51, 0xb882, RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0), RTFLOAT80U_INIT_C(1,0x64d6994bfe7,0) }, /* #33/3/3/u */
    { 0x0f7f, 0x3e5