/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.preferences.WizardPrefPage;

public abstract class ActiveWizard
extends BaseWizard {
    private List<WizardPrefPage> prefPages = new ArrayList<WizardPrefPage>();

    protected WizardPrefPage addPreferencePage(IPreferencePage prefPage, String title, String description) {
        WizardPrefPage wizardPage = this.createPreferencePage(prefPage, title, description);
        this.addPage((IWizardPage)wizardPage);
        return wizardPage;
    }

    protected WizardPrefPage createPreferencePage(IPreferencePage prefPage, String title, String description) {
        WizardPrefPage wizardPage = new WizardPrefPage(prefPage, title, description);
        this.prefPages.add(wizardPage);
        if (prefPage instanceof IWorkbenchPropertyPage) {
            ((IWorkbenchPropertyPage)prefPage).setElement(this.getActiveElement());
        }
        return wizardPage;
    }

    protected IAdaptable getActiveElement() {
        return null;
    }

    public boolean performCancel() {
        for (WizardPrefPage prefPage : this.prefPages) {
            prefPage.performCancel();
        }
        return true;
    }

    protected void savePrefPageSettings() {
        this.savePrefPageSettings(this.prefPages.toArray(new WizardPrefPage[0]));
    }

    private void savePrefPageSettings(WizardPrefPage[] pages) {
        WizardPrefPage[] wizardPrefPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            WizardPrefPage prefPage = wizardPrefPageArray[n2];
            this.savePageSettings(prefPage);
            WizardPrefPage[] subPages = prefPage.getDialogPages(false, true);
            if (subPages != null) {
                this.savePrefPageSettings(subPages);
            }
            ++n2;
        }
    }

    private void savePageSettings(WizardPrefPage prefPage) {
        if (ActiveWizard.isPageActive((IDialogPage)prefPage)) {
            prefPage.performFinish();
        }
    }

    protected void createPreferencePages(IPreferenceNode[] preferenceNodes) {
        this.createPreferencePages(null, preferenceNodes);
    }

    private void createPreferencePages(WizardPrefPage parent, IPreferenceNode[] preferenceNodes) {
        Arrays.sort(preferenceNodes, Comparator.comparing(IPreferenceNode::getLabelText));
        IPreferenceNode[] iPreferenceNodeArray = preferenceNodes;
        int n = preferenceNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode node = iPreferenceNodeArray[n2];
            if (!this.isNodeHasParent(node, preferenceNodes)) {
                node.createPage();
                IPreferencePage preferencePage = node.getPage();
                if (preferencePage != null) {
                    preferencePage.setContainer((IPreferencePageContainer)this.getContainer());
                    WizardPrefPage wizardPrefPage = parent == null ? this.addPreferencePage(preferencePage, preferencePage.getTitle(), preferencePage.getDescription()) : parent.addSubPage(preferencePage, preferencePage.getTitle(), preferencePage.getDescription());
                    IPreferenceNode[] subNodes = node.getSubNodes();
                    if (subNodes != null) {
                        this.createPreferencePages(wizardPrefPage, subNodes);
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isNodeHasParent(IPreferenceNode node, IPreferenceNode[] allNodes) {
        IPreferenceNode[] iPreferenceNodeArray = allNodes;
        int n = allNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode n3 = iPreferenceNodeArray[n2];
            IPreferenceNode[] iPreferenceNodeArray2 = n3.getSubNodes();
            int n4 = iPreferenceNodeArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                IPreferenceNode subNode = iPreferenceNodeArray2[n5];
                if (node.getId().equals(subNode.getId())) {
                    return true;
                }
                ++n5;
            }
            ++n2;
        }
        return false;
    }
}

