/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model;

import java.util.Arrays;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;

public class HiveSQLDialect
extends GenericSQLDialect {
    private static final String[][] DEFAULT_QUOTE_STRINGS = new String[][]{{"`", "`"}};
    private static final String[] RESERVED_KEYWORDS = new String[]{"CONF", "EXCHANGE", "EXTENDED", "DATABASE", "IMPORT", "MACRO", "LESS", "PERCENT", "REDUCE", "TRUNCATE", "SHOW", "SYNC", "VIEWS"};
    private static final String[] NON_RESERVED_KEYWORDS = new String[]{"DEFAULT", "AFTER", "CASCADE", "DATA", "DEFINED", "INDEX", "ISOLATION", "KEY", "LEVEL", "LIMIT", "OPTION", "RENAME", "RESTRICT", "SCHEMA", "TRANSACTION", "VIEW"};
    private static final String[] HIVE_EXTRA_FUNCTIONS = new String[]{"ARRAY_CONTAINS", "COALESCE", "CURRENT_DATABASE", "DATE_ADD", "DATE_FORMAT", "DATEDIFF", "DAY", "DAYOFWEEK", "HOUR", "MINUTE", "MONTH", "RLIKE", "SECOND", "SIZE", "SUBSTRING_INDEX", "TO_DATE", "TRUNC", "VERSION", "YEAR", "WEEKOFYEAR"};
    private static final String[] HIVE_STRING_FUNCTIONS = new String[]{"ASCII", "CONCAT", "GET_JSON_OBJECT", "ENCODE", "LENGTH", "LPAD", "LTRIM", "REGEXP", "REGEXP_EXTRACT", "REGEXP_REPLACE", "REPLACE", "SUBSTR", "SUBSTRING", "QUOTE"};

    public HiveSQLDialect() {
        super("HiveQL", "hive");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        String[] stringArray = NON_RESERVED_KEYWORDS;
        int n = NON_RESERVED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.removeSQLKeyword(keyword);
            ++n2;
        }
        this.addSQLKeywords(Arrays.asList(RESERVED_KEYWORDS));
        this.addFunctions(Arrays.asList(HIVE_EXTRA_FUNCTIONS));
        this.addFunctions(Arrays.asList(HIVE_STRING_FUNCTIONS));
    }

    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_QUOTE_STRINGS;
    }

    public boolean supportsAlterTableConstraint() {
        return false;
    }
}

