%define name    dxreminders
%define version 1.20.0

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%if %is_fedora
%define distr %(cat /etc/fedora-release)
%endif
%if %is_suse
%define distr %(head -1 /etc/SuSE-release)
%endif
%if %is_mandrake
%define distr %(cat /etc/mandrake-release)
%endif

Name: %{name}
Version: %{version}
Summary: dxreminders is simple program for reminders.
Release: 1
License: GPL
Group: Accessories
%if %is_mandrake
BuildRequires: libwxgtk3.0-devel
%endif
%if %is_fedora
BuildRequires: wxGTK3-devel
%endif
%if %is_suse
BuildRequires: wxWidgets-devel >= 3
%endif
Source: %{name}-%{version}.tar.gz
Packager: David Vachulka <arch_dvx@users.sourceforge.net>
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildRequires: cmake gettext

%description
dxreminders is simple program for reminders. dxreminders is desktop independent and is written with the wxWidgets toolkit.

%global debug_package %{nil}

%prep
%setup -q

%build
mkdir build
pushd build
%if %is_fedora
cmake \
    -DCMAKE_INSTALL_PREFIX=%{_prefix} \
    -DDX_WX_CONFIG=wx-config-3.0 \
    ..
%else
cmake \
    -DCMAKE_INSTALL_PREFIX=%{_prefix} \
    ..
%endif
make
popd #build

%install
pushd build
%make_install
popd #build

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc COPYING
%{_bindir}/%{name}
%{_datadir}/icons/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/locale/*
