/***************************************************************
 * Name:      calendarday.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef CALENDARDAY_H
#define	CALENDARDAY_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

class Calendarday {
public:
    Calendarday();
    Calendarday(wxDateTime::wxDateTime_t day, wxUint8 daytype, const wxString &tooltip, const wxString &ids);
    virtual ~Calendarday();

    bool isValid() const { return m_day < 32; }
    wxDateTime::wxDateTime_t day() const;
    void setDay(const wxDateTime::wxDateTime_t &day);
    wxUint8 daytype() const;
    void setDaytype(const wxUint8 &daytype);
    wxString tooltip() const;
    void setTooltip(const wxString &tooltip);
    wxString ids() const;
    void setIds(const wxString &ids);
private:
    wxDateTime::wxDateTime_t m_day;
    wxUint8 m_daytype;
    wxString m_tooltip;
    wxString m_ids;
};

#endif	/* CALENDARDAY_H */

