/***************************************************************
 * Name:      event.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2013
 * License:   GPL3
 **************************************************************/

#ifndef EVENT_H
#define	EVENT_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

//Recurrence type
enum {
    R_ONCE = 0,
    R_DAILY,
    R_WEEKLY,
    R_2WEEKLY,
    R_MONTHLY,
    R_OWN,
    R_MONTHLYATDAY,
    R_MONTHLYBUSINESS,
    R_MONTHLYPLUSBUSINESSDAY,
    R_QUARTERLYPLUSBUSINESSDAY,
    R_MONTHLYGIVENBUSINESSDAY,
    R_QUARTERLYGIVENBUSINESSDAY,
    R_YEARLY,
    R_QUARTERLYBUSINESS,
    R_QUARTERLY,
    R_ONCENOTDELETE,
    R_HOURLY,
    R_MINUTES,
    R_WEEKLYBUSINESS,
    R_WEEKLYPLUSBUSINESSDAY,
    R_WEEKLYGIVENBUSINESSDAY,
    R_2WEEKLYBUSINESS,
    R_2WEEKLYPLUSBUSINESSDAY,
    R_2WEEKLYGIVENBUSINESSDAY,
    R_NONE,
    R_DAILYBUSINESS
};

class Event {
public:
    Event();
    Event(wxInt64 id, const wxString &event, const wxString &descr, const wxDateTime &date, wxInt64 reminder, bool reminded, int day, int month, bool hidden,
          int recurrence, int minutes, int hours, int days, int months, int monthlyday, int monthlyweek, wxInt64 actualreminder, const wxDateTime &until, bool always,
          int color);
    virtual ~Event();

    wxString event() const { return m_event; }
    void setEvent(const wxString &event);
    wxString descr() const { return m_descr; }
    void setDescr(const wxString &descr);
    wxDateTime date() const { return m_date; }
    wxDateTime realEventDate();
    void setDate(wxDateTime date);
    bool reminded() const { return m_reminded; }
    void setReminded(bool reminded);
    bool isValid() const { return m_id != -1; }
    int day() const;
    void setDay(int day);
    bool hidden() const;
    void setHidden(bool hidden);
    int month() const;
    void setMonth(int month);
    int recurrence() const;
    void setRecurrence(int recurrence);
    int minutes() const;
    void setMinutes(int minutes);
    int hours() const;
    void setHours(int hours);
    int days() const;
    void setDays(int days);
    int months() const;
    void setMonths(int months);
    int monthlyday() const;
    void setMonthlyday(int monthlyday);
    int monthlyweek() const;
    void setMonthlyweek(int monthlyweek);
    wxString tipText(bool withrecurrence=false);
    wxString tipTextRecurrent();
    wxString reminderText() const;
    wxString recurrenceText() const;
    wxInt64 id() const;
    wxInt64 reminder() const;
    void setReminder(const wxInt64 &reminder);
    wxInt64 actualreminder() const;
    void setActualreminder(const wxInt64 &actualreminder);
    wxDateTime until() const;
    void setUntil(const wxDateTime &until);
    bool always() const;
    void setAlways(bool newAlways);
    int color() const;
    void setColor(int newColor);

private:
    wxInt64 m_id;
    wxString m_event, m_descr;
    wxDateTime m_date;
    wxInt64 m_reminder;
    bool m_reminded;
    int m_day;
    int m_month;
    bool m_hidden;
    int m_recurrence;
    int m_minutes;
    int m_hours;
    int m_days;
    int m_months;
    int m_monthlyday;
    int m_monthlyweek;
    wxInt64 m_actualreminder;
    wxDateTime m_until;
    bool m_always;
    int m_color;

    void checkWeeklyGivenBusinessDay();
    void checkWeeklyPlusBusinessDay();
    void checkWeeklyBusinessDay();
};

class EventView {
public:
    EventView();
    EventView(const wxInt64 id, const wxString &name, const wxDateTime &date, const wxString &reminder, const wxString &recurrence, int highlight, int recurrencetype, bool always);

    bool isValid() const { return m_id != -1; }
    wxString name() const;
    void setName(const wxString &name);
    wxString reminder() const;
    void setReminder(const wxString &reminder);
    wxString recurrence() const;
    void setRecurrence(const wxString &recurrence);
    wxDateTime date() const;
    void setDate(const wxDateTime &date);
    wxInt64 id() const;
    void setId(const wxInt64 &id);
    int highlight() const;
    void setHighlight(int highlight);
    int recurrencetype() const;
    void setRecurrencetype(int recurrencetype);
    bool always() const;
    void setAlways(bool newAlways);

private:
    wxInt64 m_id;
    wxString m_name, m_reminder, m_recurrence;
    wxDateTime m_date;
    int m_highlight;
    int m_recurrencetype;
    bool m_always;
};

#endif	/* EVENT_H */

