/***************************************************************
 * Name:      filter.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2018
 * License:   GPL3
 **************************************************************/

#ifndef FILTER_H
#define FILTER_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/dynarray.h>

class Reminder
{
public:
    Reminder() : m_reminder(0) {}
    explicit Reminder(wxInt64 reminder);
    Reminder(wxInt64 days, wxInt64 hours, wxInt64 mins);
    Reminder(const wxString &text);

    wxString towxString() const;
    void fromwxString(const wxString &text);
    wxInt64 days() const;
    wxInt64 hours() const;
    wxInt64 mins() const;
    wxInt64 reminder() const;
    void setReminder(const wxInt64 &reminder);
private:
    wxInt64 m_reminder;
};

enum FilterType {
    FT_DATUM,
    FT_TEXT,
    FT_INTEGER,
    FT_REMINDER,
    FT_TIME
};

enum FilterAction {
    FA_LESS = 0,
    FA_LESSEQUAL,
    FA_EQUAL,
    FA_GREATEREQUAL,
    FA_GREATER,
    FA_CONTAINS
};

class Filter
{
public:
    Filter(const FilterAction &action, bool active, const wxDateTime &datum);
    Filter(const FilterAction &action, bool active, const wxString &text);
    Filter(const FilterAction &action, bool active, int value);
    Filter(const FilterAction &action, bool active, Reminder value);
    Filter(const FilterAction &action, bool active, const wxDateSpan &datespan, const wxTimeSpan &timespan);

    bool matchFilter(const wxDateTime &datum);
    bool matchFilter(const wxString &text);
    bool matchFilter(int value);
    bool matchFilter(const Reminder &reminder);
    FilterType type() const;
    void setType(const FilterType &type);
    FilterAction action() const;
    void setAction(const FilterAction &action);
    wxDateTime datum() const;
    void setDatum(const wxDateTime &datum);
    wxString text() const;
    void setText(const wxString &text);
    int intvalue() const;
    void setIntvalue(int intvalue);
    bool active() const;
    void setActive(bool active);
    Reminder reminder() const;
    void setReminder(const Reminder &reminder);
    wxDateSpan datespan() const;
    void setDatespan(const wxDateSpan &datespan);
    wxTimeSpan timespan() const;
    void setTimespan(const wxTimeSpan &timespan);

private:
    FilterType m_type;
    FilterAction m_action;
    bool m_active;
    wxDateTime m_datum;
    wxString m_text;
    int m_intvalue;
    Reminder m_reminder;
    wxDateSpan m_datespan;
    wxTimeSpan m_timespan;
};

WX_DECLARE_OBJARRAY(Filter, dxFilterArray);

#endif /* FILTER_H */
