/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.keychain;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.freedesktop.secret.simple.SimpleCollection;

public class SecretServiceKeychainAccess
implements KeychainAccessProvider {
    private final String LABEL_FOR_SECRET_IN_KEYRING = "Cryptomator";

    public String displayName() {
        return "Gnome Keyring";
    }

    public boolean isSupported() {
        return SimpleCollection.isAvailable();
    }

    public boolean isLocked() {
        boolean bl;
        SimpleCollection keyring = new SimpleCollection();
        try {
            bl = keyring.isLocked();
        }
        catch (Throwable throwable) {
            try {
                try {
                    keyring.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        keyring.close();
        return bl;
    }

    public void storePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list == null || list.isEmpty()) {
                keyring.createItem("Cryptomator", passphrase, this.createAttributes(key));
            } else {
                this.changePassphrase(key, passphrase);
            }
        }
        catch (IOException | AccessControlException e) {
            throw new KeychainAccessException("Storing password failed.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] loadPassphrase(String key) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list != null && !list.isEmpty()) {
                char[] cArray = keyring.getSecret((String)list.get(0));
                return cArray;
            }
            char[] cArray = null;
            return cArray;
        }
        catch (IOException | AccessControlException e) {
            throw new KeychainAccessException("Loading password failed.", (Throwable)e);
        }
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list != null && !list.isEmpty()) {
                keyring.deleteItem((String)list.get(0));
            }
        }
        catch (IOException | AccessControlException e) {
            throw new KeychainAccessException("Deleting password failed.", (Throwable)e);
        }
    }

    public void changePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list != null && !list.isEmpty()) {
                keyring.updateItem((String)list.get(0), "Cryptomator", passphrase, this.createAttributes(key));
            }
        }
        catch (IOException | AccessControlException e) {
            throw new KeychainAccessException("Changing password failed.", (Throwable)e);
        }
    }

    private Map<String, String> createAttributes(String key) {
        return Map.of("Vault", key);
    }
}

