/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.controls;

import java.io.UncheckedIOException;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.cryptomator.ui.common.FontLoader;
import org.cryptomator.ui.controls.FontAwesome5Icon;

public class FontAwesome5IconView
extends Text {
    private static final FontAwesome5Icon DEFAULT_GLYPH = FontAwesome5Icon.ANCHOR;
    private static final double DEFAULT_GLYPH_SIZE = 12.0;
    private static final String FONT_PATH = "/css/fontawesome5-free-solid.otf";
    private static final Font FONT;
    protected final ObjectProperty<FontAwesome5Icon> glyph = new SimpleObjectProperty((Object)this, "glyph", (Object)DEFAULT_GLYPH);
    protected final DoubleProperty glyphSize = new SimpleDoubleProperty((Object)this, "glyphSize", 12.0);

    public FontAwesome5IconView() {
        this.getStyleClass().addAll((Object[])new String[]{"glyph-icon"});
        this.glyphProperty().addListener(this::glyphChanged);
        this.glyphSizeProperty().addListener(this::glyphSizeChanged);
        this.setFont(FONT);
        this.setGlyph(DEFAULT_GLYPH);
        this.setGlyphSize(12.0);
    }

    private void glyphChanged(ObservableValue<? extends FontAwesome5Icon> observable, FontAwesome5Icon oldValue, FontAwesome5Icon newValue) {
        this.setText(newValue == null ? null : newValue.unicode());
    }

    private void glyphSizeChanged(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.setFont(new Font(FONT.getFamily(), newValue.doubleValue()));
    }

    public ObjectProperty<FontAwesome5Icon> glyphProperty() {
        return this.glyph;
    }

    public FontAwesome5Icon getGlyph() {
        return (FontAwesome5Icon)((Object)this.glyph.get());
    }

    public void setGlyph(FontAwesome5Icon glyph) {
        this.glyph.set((Object)(glyph == null ? DEFAULT_GLYPH : glyph));
    }

    public DoubleProperty glyphSizeProperty() {
        return this.glyphSize;
    }

    public double getGlyphSize() {
        return this.glyphSize.get();
    }

    public void setGlyphSize(double glyphSize) {
        this.glyphSize.set(glyphSize);
    }

    static {
        try {
            FONT = FontLoader.load(FONT_PATH);
        }
        catch (FontLoader.FontLoaderException e) {
            throw new UncheckedIOException(e);
        }
    }
}

