/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.controls;

import com.google.common.base.Strings;
import java.nio.CharBuffer;
import java.text.Normalizer;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;

public class SecurePasswordField
extends TextField {
    private static final char WIPE_CHAR = ' ';
    private static final int INITIAL_BUFFER_SIZE = 50;
    private static final int GROW_BUFFER_SIZE = 50;
    private static final String DEFAULT_PLACEHOLDER = "\u25cf";
    private static final String STYLE_CLASS = "secure-password-field";
    private static final KeyCodeCombination SHORTCUT_BACKSPACE = new KeyCodeCombination(KeyCode.BACK_SPACE, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    private final String placeholderChar;
    private final BooleanProperty capsLocked = new SimpleBooleanProperty();
    private final BooleanProperty containingNonPrintableChars = new SimpleBooleanProperty();
    private final BooleanProperty revealPassword = new SimpleBooleanProperty();
    private char[] content = new char[50];
    private int length = 0;

    public SecurePasswordField() {
        this(DEFAULT_PLACEHOLDER);
    }

    public SecurePasswordField(@NamedArg(value="placeholderChar") String placeholderChar) {
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.placeholderChar = placeholderChar;
        this.setAccessibleRole(AccessibleRole.PASSWORD_FIELD);
        this.addEventHandler(DragEvent.DRAG_OVER, this::handleDragOver);
        this.addEventHandler(DragEvent.DRAG_DROPPED, this::handleDragDropped);
        this.addEventHandler(KeyEvent.ANY, this::handleKeyEvent);
        this.revealPasswordProperty().addListener(this::revealPasswordChanged);
        this.focusedProperty().addListener(this::focusedChanged);
    }

    public void cut() {
    }

    public void copy() {
    }

    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        return switch (attribute) {
            case AccessibleAttribute.TEXT -> null;
            default -> super.queryAccessibleAttribute(attribute, parameters);
        };
    }

    private void handleDragOver(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        if (dragboard.hasString() && dragboard.getString() != null) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        }
        event.consume();
    }

    private void handleDragDropped(DragEvent event) {
        Dragboard dragboard = event.getDragboard();
        if (dragboard.hasString() && dragboard.getString() != null) {
            this.insertText(this.getCaretPosition(), dragboard.getString());
        }
        event.consume();
    }

    private void handleKeyEvent(KeyEvent e) {
        if (e.getCode() == KeyCode.CAPS) {
            this.updateCapsLocked();
        } else if (SHORTCUT_BACKSPACE.match(e)) {
            this.wipe();
        }
    }

    private void revealPasswordChanged(Observable observable) {
        IndexRange selection = this.getSelection();
        if (this.isRevealPassword()) {
            super.setText(this.getCharacters().toString());
        } else {
            String placeholderText = Strings.repeat((String)this.placeholderChar, (int)this.length);
            super.setText(placeholderText);
        }
        this.selectRange(selection.getStart(), selection.getEnd());
    }

    private void focusedChanged(Observable observable) {
        this.updateCapsLocked();
    }

    private void updateCapsLocked() {
        this.capsLocked.set(Platform.isKeyLocked((KeyCode)KeyCode.CAPS).orElse(false).booleanValue());
    }

    private void updateContainingNonPrintableChars() {
        this.containingNonPrintableChars.set(this.containsNonPrintableCharacters());
    }

    boolean containsNonPrintableCharacters() {
        for (int i = 0; i < this.length; ++i) {
            if (!Character.isISOControl(this.content[i])) continue;
            return true;
        }
        return false;
    }

    public void replaceText(int start, int end, String text) {
        String normalizedText = Normalizer.normalize(text, Normalizer.Form.NFC);
        int removed = end - start;
        int added = normalizedText.length();
        int delta = added - removed;
        int oldLength = this.length;
        this.length += delta;
        this.growContentIfNeeded();
        if (delta != 0 && start < oldLength) {
            System.arraycopy(this.content, end, this.content, end + delta, oldLength - end);
        }
        normalizedText.getChars(0, normalizedText.length(), this.content, start);
        this.updateContainingNonPrintableChars();
        if (this.isRevealPassword()) {
            super.replaceText(start, end, text);
        } else {
            String placeholderString = Strings.repeat((String)this.placeholderChar, (int)normalizedText.length());
            super.replaceText(start, end, placeholderString);
        }
    }

    private void growContentIfNeeded() {
        if (this.length > this.content.length) {
            char[] newContent = new char[this.length + 50];
            System.arraycopy(this.content, 0, newContent, 0, this.content.length);
            this.wipe(this.content);
            this.content = newContent;
        }
    }

    public CharSequence getCharacters() {
        return CharBuffer.wrap(this.content, 0, this.length);
    }

    public void setPassword(CharSequence password) {
        char[] buf = new char[password.length()];
        for (int i = 0; i < password.length(); ++i) {
            buf[i] = password.charAt(i);
        }
        this.setPassword(buf);
        Arrays.fill(buf, ' ');
    }

    public void setPassword(char[] password) {
        this.wipe();
        this.content = Arrays.copyOf(password, password.length);
        this.length = password.length;
        String placeholderString = Strings.repeat((String)this.placeholderChar, (int)password.length);
        this.setText(placeholderString);
    }

    public void wipe() {
        this.wipe(this.content);
        this.length = 0;
        this.setText(null);
    }

    private void wipe(char[] buffer) {
        Arrays.fill(buffer, ' ');
    }

    public ReadOnlyBooleanProperty capsLockedProperty() {
        return this.capsLocked;
    }

    public boolean isCapsLocked() {
        return this.capsLocked.get();
    }

    public ReadOnlyBooleanProperty containingNonPrintableCharsProperty() {
        return this.containingNonPrintableChars;
    }

    public boolean isContainingNonPrintableChars() {
        return this.containingNonPrintableChars.get();
    }

    public BooleanProperty revealPasswordProperty() {
        return this.revealPassword;
    }

    public boolean isRevealPassword() {
        return this.revealPassword.get();
    }

    public void setRevealPassword(boolean revealPassword) {
        this.revealPassword.set(revealPassword);
    }
}

