/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.mount.AbstractMount;
import org.cryptomator.frontend.fuse.mount.AbstractMounter;
import org.cryptomator.frontend.fuse.mount.EnvironmentVariables;
import org.cryptomator.frontend.fuse.mount.FuseMountException;
import org.cryptomator.frontend.fuse.mount.Mount;
import org.cryptomator.frontend.fuse.mount.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LinuxMounter
extends AbstractMounter {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxMounter.class);
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);

    LinuxMounter() {
    }

    @Override
    public String[] defaultMountFlags() {
        try {
            return new String[]{"-ouid=" + Files.getAttribute(USER_HOME, "unix:uid", new LinkOption[0]), "-ogid=" + Files.getAttribute(USER_HOME, "unix:gid", new LinkOption[0]), "-oauto_unmount"};
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isApplicable() {
        return IS_LINUX;
    }

    @Override
    protected Mount createMountObject(FuseNioAdapter fuseNioAdapter, EnvironmentVariables envVars) {
        return new LinuxMount(fuseNioAdapter, envVars);
    }

    private static class LinuxMount
    extends AbstractMount {
        private LinuxMount(FuseNioAdapter fuseAdapter, EnvironmentVariables envVars) {
            super(fuseAdapter, envVars.getMountPoint());
        }

        @Override
        public void unmountInternal() throws FuseMountException {
            if (!this.fuseAdapter.isMounted()) {
                return;
            }
            ProcessBuilder command = new ProcessBuilder("fusermount", "-u", "--", this.mountPoint.getFileName().toString());
            command.directory(this.mountPoint.getParent().toFile());
            Process proc = ProcessUtil.startAndWaitFor(command, 5L, TimeUnit.SECONDS);
            this.assertUmountSucceeded(proc);
            this.fuseAdapter.setUnmounted();
        }

        @Override
        public void unmountForcedInternal() throws FuseMountException {
            if (!this.fuseAdapter.isMounted()) {
                return;
            }
            ProcessBuilder command = new ProcessBuilder("fusermount", "-u", "-z", "--", this.mountPoint.getFileName().toString());
            command.directory(this.mountPoint.getParent().toFile());
            Process proc = ProcessUtil.startAndWaitFor(command, 5L, TimeUnit.SECONDS);
            this.assertUmountSucceeded(proc);
            this.fuseAdapter.setUnmounted();
        }

        private void assertUmountSucceeded(Process proc) throws FuseMountException {
            if (proc.exitValue() == 0) {
                return;
            }
            try {
                String stderr = ProcessUtil.toString(proc.getErrorStream(), StandardCharsets.US_ASCII).toLowerCase();
                if (stderr.contains("not mounted") || stderr.contains("no such file or directory")) {
                    LOG.info("Already unmounted");
                    return;
                }
                throw new FuseMountException("Unmount failed. STDERR: " + stderr);
            }
            catch (IOException e) {
                throw new FuseMountException(e);
            }
        }
    }
}

