/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cryptomator.frontend.webdav.WebDavServerModule;

@Singleton
class DefaultServlet
extends HttpServlet {
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final int TARPIT_DELAY_MS = 5000;
    private final Collection<String> contextPaths;

    @Inject
    public DefaultServlet(@WebDavServerModule.ContextPaths Collection<String> contextPaths) {
        this.contextPaths = contextPaths;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isRequestedResourcePathPartOfValidContextPath(req.getRequestURI())) {
            try {
                Thread.sleep(5000L);
                resp.addHeader("X-Tarpit-Delayed", "5000ms");
                resp.sendError(404);
            }
            catch (InterruptedException e) {
                resp.sendError(500, "Thread interrupted.");
                Thread.currentThread().interrupt();
            }
            return;
        }
        switch (req.getMethod()) {
            case "PROPFIND": {
                this.doPropfind(req, resp);
                break;
            }
            default: {
                super.service(req, resp);
            }
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1, 2");
        resp.addHeader("MS-Author-Via", "DAV");
        resp.addHeader("Allow", "OPTIONS, PROPFIND, GET, HEAD");
        resp.setStatus(204);
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.getWriter().write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<D:multistatus xmlns:D=\"DAV:\">\n<D:response>\n  <D:href>" + req.getRequestURI() + "</D:href>\n  <D:propstat>\n    <D:prop>\n      <D:iscollection>1</D:iscollection>\n      <D:resourcetype><D:collection/></D:resourcetype>\n    </D:prop>\n  </D:propstat>\n</D:response>\n</D:multistatus>");
        resp.getWriter().flush();
    }

    private boolean isRequestedResourcePathPartOfValidContextPath(String requestedResourcePath) {
        return this.contextPaths.stream().filter(cp -> this.isParentOrSamePath((String)cp, requestedResourcePath)).findAny().isPresent();
    }

    private boolean isParentOrSamePath(String path, String potentialParent) {
        String[] parentPathComponents;
        String[] pathComponents = (String[])Iterables.toArray((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)path), String.class);
        if (pathComponents.length < (parentPathComponents = (String[])Iterables.toArray((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)potentialParent), String.class)).length) {
            return false;
        }
        assert (pathComponents.length >= parentPathComponents.length);
        for (int i = 0; i < parentPathComponents.length; ++i) {
            if (pathComponents[i].equals(parentPathComponents[i])) continue;
            return false;
        }
        return true;
    }
}

