// Copyright (C) 2019  Joseph Artsimovich <joseph.artsimovich@gmail.com>, 4lex4 <4lex49@zoho.com>
// Use of this source code is governed by the GNU GPLv3 license that can be found in the LICENSE file.

#ifndef SCANTAILOR_CORE_FILTERRESULT_H_
#define SCANTAILOR_CORE_FILTERRESULT_H_

#include <memory>

class AbstractFilter;
class FilterUiInterface;

class FilterResult {
 public:
  virtual ~FilterResult() = default;

  virtual void updateUI(FilterUiInterface* ui) = 0;

  /**
   * \brief Return the filter that generated this result.
   * \note Returning a null smart pointer indicates that the result
   *       was generated by a task that doesn't belong to a filter.
   *       That would be LoadFileTask.
   */

  virtual std::shared_ptr<AbstractFilter> filter() = 0;
};


using FilterResultPtr = std::shared_ptr<FilterResult>;

#endif
