/* twofish_asm_3way.S
 *
 * Copyright  2011-2013 Jussi Kivilinna <jussi.kivilinna@iki.fi>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
 
 /* Adapted tp VeraCrypt */

.text

.align 8
.global twofish_enc_blk
.global _twofish_enc_blk

twofish_enc_blk:
_twofish_enc_blk:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif

 pushq %rbp
 pushq %rbx

 pushq %rsi;
 movq %rdx, %rsi;

 movq 4*(0)(%rsi), %rax; xorq 4096 +4*0(%rdi), %rax;; movq 4*(2)(%rsi), %rbx; xorq 4096 +4*2(%rdi), %rbx;;;

 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(0*2)+1)(%rdi), %esi; addl 4128 +4*(2*(0*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(1*2)+1)(%rdi), %esi; addl 4128 +4*(2*(1*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(2*2)+1)(%rdi), %esi; addl 4128 +4*(2*(2*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(3*2)+1)(%rdi), %esi; addl 4128 +4*(2*(3*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(4*2)+1)(%rdi), %esi; addl 4128 +4*(2*(4*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(5*2)+1)(%rdi), %esi; addl 4128 +4*(2*(5*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(6*2)+1)(%rdi), %esi; addl 4128 +4*(2*(6*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(7*2)+1)(%rdi), %esi; addl 4128 +4*(2*(7*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax;;;

 popq %rsi;

 xorq 4096 +4*4(%rdi), %rbx; movq %rbx, 4*(0)(%rsi);; xorq 4096 +4*6(%rdi), %rax; movq %rax, 4*(2)(%rsi);;;

 popq %rbx
 popq %rbp
.ifdef WINABI
popq %rdi
popq %rsi
.endif
 ret;

.global twofish_dec_blk
.global _twofish_dec_blk

twofish_dec_blk:
_twofish_dec_blk:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif


 pushq %rbp
 pushq %rbx
 pushq %r12
 pushq %r13

 pushq %rsi;
 movq %rdx, %rsi;

 movq 4*(0)(%rsi), %rbx; xorq 4096 +4*4(%rdi), %rbx;; movq 4*(2)(%rsi), %rax; xorq 4096 +4*6(%rdi), %rax;; rorq $32, %rbx; rorq $32, %rax;;

 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((7*2))+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((6*2))+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((5*2))+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((4*2))+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((3*2))+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((2*2))+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((1*2))+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((0*2))+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx;;;

 popq %rsi;

 rorq $32, %rax; rorq $32, %rbx; xorq 4096 +4*0(%rdi), %rax; movq %rax, 4*(0)(%rsi);; xorq 4096 +4*2(%rdi), %rbx; movq %rbx, 4*(2)(%rsi);;;

 popq %r13
 popq %r12
 popq %rbx
 popq %rbp

.ifdef WINABI
popq %rdi
popq %rsi
.endif

 ret;

.global twofish_enc_blk2
.global _twofish_enc_blk2

twofish_enc_blk2:
_twofish_enc_blk2:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif


 pushq %rbp
 pushq %rbx

 pushq %rsi;
 movq %rdx, %rsi;

 movq 4*(0)(%rsi), %rax; xorq 4096 +4*0(%rdi), %rax; movq 4*(4+(0))(%rsi), %rcx; xorq 4096 +4*0(%rdi), %rcx;; movq 4*(2)(%rsi), %rbx; xorq 4096 +4*2(%rdi), %rbx; movq 4*(4+(2))(%rsi), %rdx; xorq 4096 +4*2(%rdi), %rdx;;;

 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(0*2)+1)(%rdi), %esi; addl 4128 +4*(2*(0*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(0*2)+1)(%rdi), %esi; addl 4128 +4*(2*(0*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(1*2)+1)(%rdi), %esi; addl 4128 +4*(2*(1*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(1*2)+1)(%rdi), %esi; addl 4128 +4*(2*(1*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(2*2)+1)(%rdi), %esi; addl 4128 +4*(2*(2*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(2*2)+1)(%rdi), %esi; addl 4128 +4*(2*(2*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(3*2)+1)(%rdi), %esi; addl 4128 +4*(2*(3*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(3*2)+1)(%rdi), %esi; addl 4128 +4*(2*(3*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(4*2)+1)(%rdi), %esi; addl 4128 +4*(2*(4*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(4*2)+1)(%rdi), %esi; addl 4128 +4*(2*(4*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(5*2)+1)(%rdi), %esi; addl 4128 +4*(2*(5*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(5*2)+1)(%rdi), %esi; addl 4128 +4*(2*(5*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(6*2)+1)(%rdi), %esi; addl 4128 +4*(2*(6*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(6*2)+1)(%rdi), %esi; addl 4128 +4*(2*(6*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;
 movzbl %al, %r8d; movzbl %ah, %esi; rorq $(32), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(48), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(32), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(48), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*(7*2)+1)(%rdi), %esi; addl 4128 +4*(2*(7*2))(%rdi), %r8d; xorl %ebx, %r8d; shrq $32, %rbx; roll $1, %ebx; xorl %esi, %ebx; shlq $32, %rbx; rorl $1, %r8d; orq %r8, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*(7*2)+1)(%rdi), %esi; addl 4128 +4*(2*(7*2))(%rdi), %r9d; xorl %edx, %r9d; shrq $32, %rdx; roll $1, %edx; xorl %esi, %edx; shlq $32, %rdx; rorl $1, %r9d; orq %r9, %rdx;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(32), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(48), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(32), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(48), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)+1))(%rdi), %r8d; xorl %eax, %r8d; shrq $32, %rax; roll $1, %eax; xorl %esi, %eax; shlq $32, %rax; rorl $1, %r8d; orq %r8, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)+1))(%rdi), %r9d; xorl %ecx, %r9d; shrq $32, %rcx; roll $1, %ecx; xorl %esi, %ecx; shlq $32, %rcx; rorl $1, %r9d; orq %r9, %rcx;;;

 popq %rsi;

 xorq 4096 +4*4(%rdi), %rbx; movq %rbx, 4*(0)(%rsi); xorq 4096 +4*4(%rdi), %rdx; movq %rdx, 4*(4+(0))(%rsi);; xorq 4096 +4*6(%rdi), %rax; movq %rax, 4*(2)(%rsi); xorq 4096 +4*6(%rdi), %rcx; movq %rcx, 4*(4+(2))(%rsi);;;

 popq %rbx
 popq %rbp
.ifdef WINABI
popq %rdi
popq %rsi
.endif
 ret;

.global twofish_dec_blk2
.global _twofish_dec_blk2

twofish_dec_blk2:
_twofish_dec_blk2:


.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif

 pushq %rbp
 pushq %rbx
 pushq %r12
 pushq %r13

 pushq %rsi;
 movq %rdx, %rsi;

 movq 4*(0)(%rsi), %rbx; xorq 4096 +4*4(%rdi), %rbx; movq 4*(4+(0))(%rsi), %rdx; xorq 4096 +4*4(%rdi), %rdx;; movq 4*(2)(%rsi), %rax; xorq 4096 +4*6(%rdi), %rax; movq 4*(4+(2))(%rsi), %rcx; xorq 4096 +4*6(%rdi), %rcx;; rorq $32, %rbx; rorq $32, %rdx; rorq $32, %rax; rorq $32, %rcx;;

 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((7*2))+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((7*2))+1)(%rdi), %esi; addl 4128 +4*(2*((7*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((6*2))+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((6*2))+1)(%rdi), %esi; addl 4128 +4*(2*((6*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((5*2))+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((5*2))+1)(%rdi), %esi; addl 4128 +4*(2*((5*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((4*2))+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((4*2))+1)(%rdi), %esi; addl 4128 +4*(2*((4*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((3*2))+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((3*2))+1)(%rdi), %esi; addl 4128 +4*(2*((3*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((2*2))+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((2*2))+1)(%rdi), %esi; addl 4128 +4*(2*((2*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((1*2))+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((1*2))+1)(%rdi), %esi; addl 4128 +4*(2*((1*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;
 movzbl %bl, %r10d; movzbl %bh, %esi; rorq $(32), %rbx; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %bl, %r8d; movzbl %bh, %esi; rorq $(48), %rbx; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %dl, %r11d; movzbl %dh, %esi; rorq $(32), %rdx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %dl, %r9d; movzbl %dh, %esi; rorq $(48), %rdx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(32), %rbx; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $(16), %rbx; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(32), %rdx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $(16), %rdx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)+1))(%rdi), %r8d; xorl %eax, %esi; shrq $32, %rax; roll $1, %eax; xorl %r8d, %eax; shlq $32, %rax; rorl $1, %esi; orq %rsi, %rax; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)+1))(%rdi), %r9d; xorl %ecx, %esi; shrq $32, %rcx; roll $1, %ecx; xorl %r9d, %ecx; shlq $32, %rcx; rorl $1, %esi; orq %rsi, %rcx;; movzbl %al, %r10d; movzbl %ah, %esi; rorq $(32), %rax; movl 1024(%rdi, %r10, 4), %r10d; xorl 2048(%rdi, %rsi, 4), %r10d;; movzbl %al, %r8d; movzbl %ah, %esi; rorq $(48), %rax; movl 0(%rdi, %r8, 4), %r8d; xorl 1024(%rdi, %rsi, 4), %r8d;; movzbl %cl, %r11d; movzbl %ch, %esi; rorq $(32), %rcx; movl 1024(%rdi, %r11, 4), %r11d; xorl 2048(%rdi, %rsi, 4), %r11d;; movzbl %cl, %r9d; movzbl %ch, %esi; rorq $(48), %rcx; movl 0(%rdi, %r9, 4), %r9d; xorl 1024(%rdi, %rsi, 4), %r9d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(32), %rax; xorl 3072(%rdi, %rbp, 4), %r10d; xorl 0(%rdi, %rsi, 4), %r10d;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $(16), %rax; xorl 2048(%rdi, %rbp, 4), %r8d; xorl 3072(%rdi, %rsi, 4), %r8d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(32), %rcx; xorl 3072(%rdi, %rbp, 4), %r11d; xorl 0(%rdi, %rsi, 4), %r11d;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $(16), %rcx; xorl 2048(%rdi, %rbp, 4), %r9d; xorl 3072(%rdi, %rsi, 4), %r9d;;; leal (%r8d, %r10d, 2), %esi; addl %r10d, %r8d; addl 4128 +4*(2*((0*2))+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)))(%rdi), %r8d; xorl %ebx, %esi; shrq $32, %rbx; roll $1, %ebx; xorl %r8d, %ebx; shlq $32, %rbx; rorl $1, %esi; orq %rsi, %rbx; leal (%r9d, %r11d, 2), %esi; addl %r11d, %r9d; addl 4128 +4*(2*((0*2))+1)(%rdi), %esi; addl 4128 +4*(2*((0*2)))(%rdi), %r9d; xorl %edx, %esi; shrq $32, %rdx; roll $1, %edx; xorl %r9d, %edx; shlq $32, %rdx; rorl $1, %esi; orq %rsi, %rdx;;;

 popq %rsi;

 rorq $32, %rax; rorq $32, %rcx; rorq $32, %rbx; rorq $32, %rdx; xorq 4096 +4*0(%rdi), %rax; movq %rax, 4*(0)(%rsi); xorq 4096 +4*0(%rdi), %rcx; movq %rcx, 4*(4+(0))(%rsi);; xorq 4096 +4*2(%rdi), %rbx; movq %rbx, 4*(2)(%rsi); xorq 4096 +4*2(%rdi), %rdx; movq %rdx, 4*(4+(2))(%rsi);;;

 popq %r13
 popq %r12
 popq %rbx
 popq %rbp

.ifdef WINABI
popq %rdi
popq %rsi
.endif
 ret;

.global twofish_enc_blk3
.global _twofish_enc_blk3

twofish_enc_blk3:
_twofish_enc_blk3:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif




 pushq %r15;
 pushq %r14;
 pushq %r13;
 pushq %r12;
 pushq %rbp;
 pushq %rbx;

 pushq %rsi;

 movq 4*(0)(%rdx), %rax; xorq 4096 +4*0(%rdi), %rax; movq 4*(4+(0))(%rdx), %rbx; xorq 4096 +4*0(%rdi), %rbx; movq 4*(8+(0))(%rdx), %rcx; xorq 4096 +4*0(%rdi), %rcx;; movq 4*(2)(%rdx), %r8; xorq 4096 +4*2(%rdi), %r8; movq 4*(4+(2))(%rdx), %r9; xorq 4096 +4*2(%rdi), %r9; movq 4*(8+(2))(%rdx), %r10; xorq 4096 +4*2(%rdi), %r10;;;

 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(0*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(0*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(0*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(0*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(0*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(0*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((0*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((0*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((0*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(1*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(1*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(1*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(1*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(1*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(1*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((1*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((1*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((1*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(2*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(2*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(2*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(2*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(2*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(2*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((2*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((2*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((2*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(3*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(3*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(3*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(3*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(3*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(3*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((3*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((3*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((3*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(4*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(4*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(4*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(4*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(4*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(4*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((4*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((4*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((4*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(5*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(5*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(5*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(5*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(5*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(5*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((5*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((5*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((5*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(6*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(6*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(6*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(6*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(6*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(6*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((6*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((6*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((6*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;
 movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*(7*2))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*(7*2)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*(7*2))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*(7*2)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*(7*2))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*(7*2)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(32), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(48), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(32), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(48), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(32), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(48), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((7*2)+1))(%rdi), %ebp; xorl %eax, %ebp; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %r13d; shrq $32, %rax; roll $1, %eax; xorl %r13d, %eax; shlq $32, %rax; rorl $1, %ebp; orq %rbp, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((7*2)+1))(%rdi), %r11d; xorl %ebx, %r11d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r14d, %ebx; shlq $32, %rbx; rorl $1, %r11d; orq %r11, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((7*2)+1))(%rdi), %r12d; xorl %ecx, %r12d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r15d, %ecx; shlq $32, %rcx; rorl $1, %r12d; orq %r12, %rcx;;;;

 popq %rdx;

 xorq 4096 +4*6(%rdi), %rax; movq %rax, 4*(2)(%rdx); xorq 4096 +4*6(%rdi), %rbx; movq %rbx, 4*(4+(2))(%rdx); xorq 4096 +4*6(%rdi), %rcx; movq %rcx, 4*(8+(2))(%rdx);; xorq 4096 +4*4(%rdi), %r8; movq %r8, 4*(0)(%rdx); xorq 4096 +4*4(%rdi), %r9; movq %r9, 4*(4+(0))(%rdx); xorq 4096 +4*4(%rdi), %r10; movq %r10, 4*(8+(0))(%rdx);;;

 popq %rbx;
 popq %rbp;
 popq %r12;
 popq %r13;
 popq %r14;
 popq %r15;
.ifdef WINABI
popq %rdi
popq %rsi
.endif
 ret;

.global twofish_dec_blk3
.global _twofish_dec_blk3

twofish_dec_blk3:
_twofish_dec_blk3:


.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif


 pushq %r15;
 pushq %r14;
 pushq %r13;
 pushq %r12;
 pushq %rbp;
 pushq %rbx;

 pushq %rsi;

 movq 4*(0)(%rdx), %rax; xorq 4096 +4*4(%rdi), %rax; movq 4*(4+(0))(%rdx), %rbx; xorq 4096 +4*4(%rdi), %rbx; movq 4*(8+(0))(%rdx), %rcx; xorq 4096 +4*4(%rdi), %rcx;; rorq $32, %rax; rorq $32, %rbx; rorq $32, %rcx; movq 4*(2)(%rdx), %r8; xorq 4096 +4*6(%rdi), %r8; movq 4*(4+(2))(%rdx), %r9; xorq 4096 +4*6(%rdi), %r9; movq 4*(8+(2))(%rdx), %r10; xorq 4096 +4*6(%rdi), %r10;; rorq $32, %r8; rorq $32, %r9; rorq $32, %r10;;

 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((7*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((7*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((7*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((7*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((7*2)))(%rdi), %ebp; addl 4128 +4*(2*((7*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((7*2)))(%rdi), %r11d; addl 4128 +4*(2*((7*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((7*2)))(%rdi), %r12d; addl 4128 +4*(2*((7*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((6*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((6*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((6*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((6*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((6*2)))(%rdi), %ebp; addl 4128 +4*(2*((6*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((6*2)))(%rdi), %r11d; addl 4128 +4*(2*((6*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((6*2)))(%rdi), %r12d; addl 4128 +4*(2*((6*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((5*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((5*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((5*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((5*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((5*2)))(%rdi), %ebp; addl 4128 +4*(2*((5*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((5*2)))(%rdi), %r11d; addl 4128 +4*(2*((5*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((5*2)))(%rdi), %r12d; addl 4128 +4*(2*((5*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((4*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((4*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((4*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((4*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((4*2)))(%rdi), %ebp; addl 4128 +4*(2*((4*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((4*2)))(%rdi), %r11d; addl 4128 +4*(2*((4*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((4*2)))(%rdi), %r12d; addl 4128 +4*(2*((4*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((3*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((3*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((3*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((3*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((3*2)))(%rdi), %ebp; addl 4128 +4*(2*((3*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((3*2)))(%rdi), %r11d; addl 4128 +4*(2*((3*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((3*2)))(%rdi), %r12d; addl 4128 +4*(2*((3*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((2*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((2*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((2*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((2*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((2*2)))(%rdi), %ebp; addl 4128 +4*(2*((2*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((2*2)))(%rdi), %r11d; addl 4128 +4*(2*((2*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((2*2)))(%rdi), %r12d; addl 4128 +4*(2*((2*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((1*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((1*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((1*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((1*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((1*2)))(%rdi), %ebp; addl 4128 +4*(2*((1*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((1*2)))(%rdi), %r11d; addl 4128 +4*(2*((1*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((1*2)))(%rdi), %r12d; addl 4128 +4*(2*((1*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;
 movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((0*2)+1))(%rdi), %ebp; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((0*2)+1))(%rdi), %r11d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((0*2)+1))(%rdi), %r12d; addl 4128 +4*(2*((0*2)+1)+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;; movzbl %al, %r13d; movzbl %ah, %edx; rorq $(32), %rax; movl 1024(%rdi, %r13, 4), %r13d; xorl 2048(%rdi, %rdx, 4), %r13d;; movzbl %al, %ebp; movzbl %ah, %edx; rorq $(48), %rax; movl 0(%rdi, %rbp, 4), %ebp; xorl 1024(%rdi, %rdx, 4), %ebp;; movzbl %bl, %r14d; movzbl %bh, %edx; rorq $(32), %rbx; movl 1024(%rdi, %r14, 4), %r14d; xorl 2048(%rdi, %rdx, 4), %r14d;; movzbl %bl, %r11d; movzbl %bh, %edx; rorq $(48), %rbx; movl 0(%rdi, %r11, 4), %r11d; xorl 1024(%rdi, %rdx, 4), %r11d;; movzbl %cl, %r15d; movzbl %ch, %edx; rorq $(32), %rcx; movl 1024(%rdi, %r15, 4), %r15d; xorl 2048(%rdi, %rdx, 4), %r15d;; movzbl %cl, %r12d; movzbl %ch, %edx; rorq $(48), %rcx; movl 0(%rdi, %r12, 4), %r12d; xorl 1024(%rdi, %rdx, 4), %r12d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(32), %rax; xorl 3072(%rdi, %rsi, 4), %r13d; xorl 0(%rdi, %rdx, 4), %r13d;; movzbl %al, %esi; movzbl %ah, %edx; rorq $(16), %rax; xorl 2048(%rdi, %rsi, 4), %ebp; xorl 3072(%rdi, %rdx, 4), %ebp;; xchgq %r8, %rax; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(32), %rbx; xorl 3072(%rdi, %rsi, 4), %r14d; xorl 0(%rdi, %rdx, 4), %r14d;; movzbl %bl, %esi; movzbl %bh, %edx; rorq $(16), %rbx; xorl 2048(%rdi, %rsi, 4), %r11d; xorl 3072(%rdi, %rdx, 4), %r11d;; xchgq %r9, %rbx; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(32), %rcx; xorl 3072(%rdi, %rsi, 4), %r15d; xorl 0(%rdi, %rdx, 4), %r15d;; movzbl %cl, %esi; movzbl %ch, %edx; rorq $(16), %rcx; xorl 2048(%rdi, %rsi, 4), %r12d; xorl 3072(%rdi, %rdx, 4), %r12d;; xchgq %r10, %rcx;; addl %r13d, %ebp; addl %ebp, %r13d; addl 4128 +4*(2*((0*2)))(%rdi), %ebp; addl 4128 +4*(2*((0*2))+1)(%rdi), %r13d; xorl %eax, %r13d; shrq $32, %rax; roll $1, %eax; xorl %ebp, %eax; shlq $32, %rax; rorl $1, %r13d; orq %r13, %rax;; addl %r14d, %r11d; addl %r11d, %r14d; addl 4128 +4*(2*((0*2)))(%rdi), %r11d; addl 4128 +4*(2*((0*2))+1)(%rdi), %r14d; xorl %ebx, %r14d; shrq $32, %rbx; roll $1, %ebx; xorl %r11d, %ebx; shlq $32, %rbx; rorl $1, %r14d; orq %r14, %rbx;; addl %r15d, %r12d; addl %r12d, %r15d; addl 4128 +4*(2*((0*2)))(%rdi), %r12d; addl 4128 +4*(2*((0*2))+1)(%rdi), %r15d; xorl %ecx, %r15d; shrq $32, %rcx; roll $1, %ecx; xorl %r12d, %ecx; shlq $32, %rcx; rorl $1, %r15d; orq %r15, %rcx;;;;

 popq %rdx;

 rorq $32, %r8; rorq $32, %r9; rorq $32, %r10; xorq 4096 +4*0(%rdi), %r8; movq %r8, 4*(0)(%rdx); xorq 4096 +4*0(%rdi), %r9; movq %r9, 4*(4+(0))(%rdx); xorq 4096 +4*0(%rdi), %r10; movq %r10, 4*(8+(0))(%rdx);; rorq $32, %rax; rorq $32, %rbx; rorq $32, %rcx; xorq 4096 +4*2(%rdi), %rax; movq %rax, 4*(2)(%rdx); xorq 4096 +4*2(%rdi), %rbx; movq %rbx, 4*(4+(2))(%rdx); xorq 4096 +4*2(%rdi), %rcx; movq %rcx, 4*(8+(2))(%rdx);;;

 popq %rbx;
 popq %rbp;
 popq %r12;
 popq %r13;
 popq %r14;
 popq %r15;

 .ifdef WINABI
 popq %rdi
 popq %rsi
 .endif
 ret;

 .ifndef __YASM__
#if defined(__linux__) && defined(__ELF__)
.section .note.GNU-stack,"",%progbits
#endif
 .endif

