/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import [Ljava.lang.Class;;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.KeyValuePair;
import sleep.bridges.Semaphore;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.engine.ObjectUtilities;
import sleep.engine.ProxyInterface;
import sleep.engine.atoms.Iterate;
import sleep.engine.types.OrderedHashContainer;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.interfaces.Variable;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;
import sleep.runtime.WatchScalar;
import sleep.taint.TaintUtils;

public class BasicUtilities
implements Function,
Loadable,
Predicate {
    static /* synthetic */ Class class$java$lang$Object;

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        array array2 = new array();
        hash hash2 = new hash();
        hashtable.put("&array", array2);
        hashtable.put("&hash", hash2);
        hashtable.put("&ohash", hash2);
        hashtable.put("&ohasha", hash2);
        hashtable.put("&@", array2);
        hashtable.put("&%", hash2);
        hashtable.put("&concat", this);
        hashtable.put("&keys", this);
        hashtable.put("&size", this);
        hashtable.put("&push", this);
        hashtable.put("&pop", this);
        hashtable.put("&add", this);
        hashtable.put("&flatten", this);
        hashtable.put("&clear", this);
        hashtable.put("&splice", this);
        hashtable.put("&subarray", this);
        hashtable.put("&sublist", this);
        hashtable.put("&copy", new copy());
        hashtable.put("&setRemovalPolicy", this);
        hashtable.put("&setMissPolicy", this);
        hashtable.put("&untaint", TaintUtils.Sanitizer(this));
        hashtable.put("&taint", TaintUtils.Tainter(this));
        map map2 = new map();
        hashtable.put("&map", map2);
        hashtable.put("&filter", map2);
        f_cast f_cast2 = new f_cast();
        hashtable.put("&cast", f_cast2);
        hashtable.put("&casti", f_cast2);
        hashtable.put("&putAll", this);
        hashtable.put("&addAll", this);
        hashtable.put("&removeAll", this);
        hashtable.put("&retainAll", this);
        hashtable.put("&pushl", this);
        hashtable.put("&popl", this);
        hashtable.put("&search", this);
        hashtable.put("&reduce", this);
        hashtable.put("&values", this);
        hashtable.put("&remove", this);
        hashtable.put("-istrue", this);
        hashtable.put("-isarray", this);
        hashtable.put("-ishash", this);
        hashtable.put("-isfunction", this);
        hashtable.put("-istainted", this);
        hashtable.put("isa", this);
        hashtable.put("in", this);
        hashtable.put("=~", this);
        hashtable.put("&setField", this);
        hashtable.put("&typeOf", this);
        hashtable.put("&newInstance", this);
        hashtable.put("&scalar", this);
        hashtable.put("&exit", this);
        SetScope setScope = new SetScope();
        hashtable.put("&local", setScope);
        hashtable.put("&this", setScope);
        hashtable.put("&global", setScope);
        hashtable.put("&watch", this);
        hashtable.put("&debug", this);
        hashtable.put("&warn", this);
        hashtable.put("&profile", this);
        hashtable.put("&getStackTrace", this);
        hashtable.put("&reverse", new reverse());
        hashtable.put("&removeAt", new removeAt());
        hashtable.put("&shift", new shift());
        hashtable.put("&systemProperties", new systemProperties());
        hashtable.put("&use", TaintUtils.Sensitive(new f_use()));
        hashtable.put("&include", TaintUtils.Sensitive((Function)hashtable.get("&use")));
        hashtable.put("&checkError", this);
        hashtable.put("&lambda", new lambda());
        hashtable.put("&compile_closure", TaintUtils.Sensitive((Function)hashtable.get("&lambda")));
        hashtable.put("&let", hashtable.get("&lambda"));
        function function2 = new function();
        hashtable.put("&function", TaintUtils.Sensitive(function2));
        hashtable.put("function", hashtable.get("&function"));
        hashtable.put("&setf", function2);
        hashtable.put("&eval", TaintUtils.Sensitive(new eval()));
        hashtable.put("&expr", TaintUtils.Sensitive((Function)hashtable.get("&eval")));
        SyncPrimitives syncPrimitives = new SyncPrimitives();
        hashtable.put("&semaphore", syncPrimitives);
        hashtable.put("&acquire", syncPrimitives);
        hashtable.put("&release", syncPrimitives);
        hashtable.put("&invoke", this);
        hashtable.put("&inline", this);
        hashtable.put("=>", new HashKeyValueOp());
    }

    public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("isa")) {
            Class clazz = BridgeUtilities.getClass(stack, null);
            Object object = BridgeUtilities.getObject(stack);
            return clazz != null && clazz.isInstance(object);
        }
        if (string.equals("=~")) {
            Scalar scalar = BridgeUtilities.getScalar(stack);
            Scalar scalar2 = BridgeUtilities.getScalar(stack);
            return scalar2.sameAs(scalar);
        }
        if (string.equals("in")) {
            Scalar scalar = BridgeUtilities.getScalar(stack);
            if (scalar.getHash() != null) {
                String string2 = BridgeUtilities.getString(stack, "");
                return scalar.getHash().getData().containsKey(string2) && !SleepUtils.isEmptyScalar((Scalar)scalar.getHash().getData().get(string2));
            }
            Iterator iterator = SleepUtils.getIterator(scalar, scriptInstance);
            Scalar scalar3 = BridgeUtilities.getScalar(stack);
            while (iterator.hasNext()) {
                Scalar scalar4 = (Scalar)iterator.next();
                if (!scalar3.sameAs(scalar4)) continue;
                return true;
            }
            return false;
        }
        Scalar scalar = (Scalar)stack.pop();
        if (string.equals("-istrue")) {
            return SleepUtils.isTrueScalar(scalar);
        }
        if (string.equals("-isfunction")) {
            return SleepUtils.isFunctionScalar(scalar);
        }
        if (string.equals("-istainted")) {
            return TaintUtils.isTainted(scalar);
        }
        if (string.equals("-isarray")) {
            return scalar.getArray() != null;
        }
        if (string.equals("-ishash")) {
            return scalar.getHash() != null;
        }
        return false;
    }

    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        block102: {
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            block107: {
                block106: {
                    block105: {
                        block104: {
                            block103: {
                                int n;
                                block101: {
                                    if (stack.isEmpty() && string.equals("&remove")) {
                                        Stack stack2 = (Stack)scriptInstance.getScriptEnvironment().getContextMetadata("iterators");
                                        if (stack2 == null || stack2.isEmpty()) {
                                            throw new RuntimeException("&remove: no active foreach loop to remove element from");
                                        }
                                        Iterate.IteratorData iteratorData = (Iterate.IteratorData)stack2.peek();
                                        iteratorData.iterator.remove();
                                        --iteratorData.count;
                                        return iteratorData.source;
                                    }
                                    if (string.equals("&watch")) {
                                        object3 = BridgeUtilities.getString(stack, "");
                                        object2 = ((String)object3).split(" ");
                                        for (n = 0; n < ((String[])object2).length; ++n) {
                                            serializable = scriptInstance.getScriptVariables().getScalarLevel(object2[n], scriptInstance);
                                            if (serializable == null) {
                                                throw new IllegalArgumentException(object2[n] + " must already exist in a scope prior to watching");
                                            }
                                            object = new WatchScalar(object2[n], scriptInstance.getScriptEnvironment());
                                            ((Scalar)object).setValue(serializable.getScalar(object2[n]));
                                            scriptInstance.getScriptVariables().setScalarLevel((String)object2[n], (Scalar)object, (Variable)serializable);
                                        }
                                    } else {
                                        if (string.equals("&scalar")) {
                                            return ObjectUtilities.BuildScalar(true, BridgeUtilities.getObject(stack));
                                        }
                                        if (string.equals("&untaint") || string.equals("&taint")) {
                                            return !stack.isEmpty() ? (Scalar)stack.pop() : SleepUtils.getEmptyScalar();
                                        }
                                        if (string.equals("&newInstance")) {
                                            Scalar scalar = BridgeUtilities.getScalar(stack);
                                            if (scalar.getArray() != null) {
                                                Class[] classArray = (Class[])ObjectUtilities.buildArgument(Class;.class, scalar, scriptInstance);
                                                SleepClosure sleepClosure = (SleepClosure)BridgeUtilities.getObject(stack);
                                                return SleepUtils.getScalar(ProxyInterface.BuildInterface(classArray, (Function)sleepClosure, scriptInstance));
                                            }
                                            Class clazz = (Class)scalar.objectValue();
                                            SleepClosure sleepClosure = (SleepClosure)BridgeUtilities.getObject(stack);
                                            return SleepUtils.getScalar(SleepUtils.newInstance(clazz, sleepClosure, scriptInstance));
                                        }
                                        if (string.equals("&typeOf")) {
                                            Scalar scalar = BridgeUtilities.getScalar(stack);
                                            if (scalar.getArray() != null) {
                                                return SleepUtils.getScalar(scalar.getArray().getClass());
                                            }
                                            if (scalar.getHash() != null) {
                                                return SleepUtils.getScalar(scalar.getHash().getClass());
                                            }
                                            return SleepUtils.getScalar(scalar.getActualValue().getType());
                                        }
                                        if (string.equals("&inline")) {
                                            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                                            sleepClosure.getRunnableCode().evaluate(scriptInstance.getScriptEnvironment());
                                            return SleepUtils.getEmptyScalar();
                                        }
                                        if (string.equals("&invoke")) {
                                            Object object4;
                                            Serializable serializable2;
                                            Map map2 = BridgeUtilities.extractNamedParameters(stack);
                                            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
                                            Stack stack3 = new Stack();
                                            Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
                                            while (iterator.hasNext()) {
                                                stack3.add(0, iterator.next());
                                            }
                                            String string2 = BridgeUtilities.getString(stack, null);
                                            if (map2.containsKey("parameters")) {
                                                serializable2 = (Scalar)map2.get("parameters");
                                                object4 = ((Scalar)serializable2).getHash().keys().scalarIterator();
                                                while (object4.hasNext()) {
                                                    Scalar scalar = (Scalar)object4.next();
                                                    KeyValuePair keyValuePair = new KeyValuePair(scalar, ((Scalar)serializable2).getHash().getAt(scalar));
                                                    stack3.add(0, SleepUtils.getScalar(keyValuePair));
                                                }
                                            }
                                            if (map2.containsKey("message")) {
                                                string2 = map2.get("message").toString();
                                            }
                                            serializable2 = sleepClosure.getVariables();
                                            if (map2.containsKey("$this")) {
                                                object4 = (SleepClosure)((Scalar)map2.get("$this")).objectValue();
                                                sleepClosure.setVariables(((SleepClosure)object4).getVariables());
                                            }
                                            object4 = sleepClosure.callClosure(string2, scriptInstance, stack3);
                                            sleepClosure.setVariables((Variable)serializable2);
                                            return object4;
                                        }
                                        if (string.equals("&checkError")) {
                                            Scalar scalar = BridgeUtilities.getScalar(stack);
                                            scalar.setValue(scriptInstance.getScriptEnvironment().checkError());
                                            return scalar;
                                        }
                                        if (string.equals("&profile")) {
                                            return SleepUtils.getArrayWrapper(scriptInstance.getProfilerStatistics());
                                        }
                                        if (string.equals("&getStackTrace")) {
                                            return SleepUtils.getArrayWrapper(scriptInstance.getStackTrace());
                                        }
                                        if (string.equals("&warn")) {
                                            scriptInstance.fireWarning(BridgeUtilities.getString(stack, "warning requested"), BridgeUtilities.getInt(stack, -1));
                                            return SleepUtils.getEmptyScalar();
                                        }
                                        if (string.equals("&debug")) {
                                            if (!stack.isEmpty()) {
                                                int n2 = BridgeUtilities.getInt(stack, 0);
                                                scriptInstance.setDebugFlags(n2);
                                            }
                                            return SleepUtils.getScalar(scriptInstance.getDebugFlags());
                                        }
                                        if (string.equals("&flatten")) {
                                            return BridgeUtilities.flattenIterator(BridgeUtilities.getIterator(stack, scriptInstance), null);
                                        }
                                        if (string.equals("&pushl") || string.equals("&popl")) {
                                            ScriptVariables scriptVariables = scriptInstance.getScriptVariables();
                                            if (string.equals("&pushl")) {
                                                scriptVariables.pushLocalLevel();
                                            } else if (string.equals("&popl")) {
                                                if (scriptVariables.haveMoreLocals()) {
                                                    scriptVariables.popLocalLevel();
                                                } else {
                                                    throw new RuntimeException("&popl: no more local frames exist");
                                                }
                                            }
                                            if (!stack.isEmpty()) {
                                                BridgeUtilities.initLocalScope(scriptVariables, scriptVariables.getLocalVariables(), stack);
                                            }
                                            return SleepUtils.getEmptyScalar();
                                        }
                                        if (string.equals("&concat")) {
                                            Scalar scalar = SleepUtils.getArrayScalar();
                                            while (!stack.isEmpty()) {
                                                Scalar scalar2 = (Scalar)stack.pop();
                                                if (scalar2.getArray() != null) {
                                                    Iterator iterator = scalar2.getArray().scalarIterator();
                                                    while (iterator.hasNext()) {
                                                        scalar.getArray().push(SleepUtils.getScalar((Scalar)iterator.next()));
                                                    }
                                                    continue;
                                                }
                                                scalar.getArray().push(SleepUtils.getScalar(scalar2));
                                            }
                                            return scalar;
                                        }
                                    }
                                    serializable = BridgeUtilities.getScalar(stack);
                                    if (string.equals("&push") && BridgeUtilities.expectArray(string, (Scalar)serializable)) {
                                        object3 = null;
                                        while (!stack.isEmpty()) {
                                            object3 = (Scalar)stack.pop();
                                            ((Scalar)serializable).getArray().push(SleepUtils.getScalar((Scalar)object3));
                                        }
                                        return object3 == null ? SleepUtils.getEmptyScalar() : object3;
                                    }
                                    if ((string.equals("&retainAll") || string.equals("&removeAll")) && BridgeUtilities.expectArray(string, (Scalar)serializable)) {
                                        object3 = ((Scalar)serializable).getArray();
                                        object2 = BridgeUtilities.getArray(stack);
                                        object = new HashSet();
                                        Iterator iterator = object2.scalarIterator();
                                        while (iterator.hasNext()) {
                                            Scalar scalar = (Scalar)iterator.next();
                                            ((HashSet)object).add(scalar.identity());
                                        }
                                        iterator = object3.scalarIterator();
                                        while (iterator.hasNext()) {
                                            Scalar scalar = (Scalar)iterator.next();
                                            if (!((HashSet)object).contains(scalar.identity())) {
                                                if (!string.equals("&retainAll")) continue;
                                                iterator.remove();
                                                continue;
                                            }
                                            if (!string.equals("&removeAll")) continue;
                                            iterator.remove();
                                        }
                                        return SleepUtils.getArrayScalar((ScalarArray)object3);
                                    }
                                    if (string.equals("&addAll") && BridgeUtilities.expectArray(string, (Scalar)serializable)) {
                                        Scalar scalar;
                                        object3 = ((Scalar)serializable).getArray();
                                        object2 = BridgeUtilities.getArray(stack);
                                        HashSet<Object> hashSet = new HashSet<Object>();
                                        object = object3.scalarIterator();
                                        while (object.hasNext()) {
                                            scalar = (Scalar)object.next();
                                            hashSet.add(scalar.identity());
                                        }
                                        object = object2.scalarIterator();
                                        while (object.hasNext()) {
                                            scalar = (Scalar)object.next();
                                            if (hashSet.contains(scalar.identity())) continue;
                                            object3.push(SleepUtils.getScalar(scalar));
                                        }
                                        return SleepUtils.getArrayScalar((ScalarArray)object3);
                                    }
                                    if (string.equals("&add") && ((Scalar)serializable).getArray() != null) {
                                        object3 = BridgeUtilities.getScalar(stack);
                                        int n3 = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), ((Scalar)serializable).getArray().size() + 1);
                                        ((Scalar)serializable).getArray().add(SleepUtils.getScalar((Scalar)object3), n3);
                                        return serializable;
                                    }
                                    if (string.equals("&add") && ((Scalar)serializable).getHash() != null) {
                                        while (!stack.isEmpty()) {
                                            object3 = BridgeUtilities.getKeyValuePair(stack);
                                            object2 = ((Scalar)serializable).getHash().getAt(((KeyValuePair)object3).getKey());
                                            ((Scalar)object2).setValue(((KeyValuePair)object3).getValue());
                                        }
                                        return serializable;
                                    }
                                    if (string.equals("&splice") && BridgeUtilities.expectArray(string, (Scalar)serializable)) {
                                        object3 = BridgeUtilities.getArray(stack);
                                        int n4 = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), ((Scalar)serializable).getArray().size());
                                        n = BridgeUtilities.getInt(stack, object3.size()) + n4;
                                        int n5 = n4;
                                        Iterator iterator = ((Scalar)serializable).getArray().scalarIterator();
                                        for (int i = 0; i < n4 && iterator.hasNext(); ++i) {
                                            iterator.next();
                                        }
                                        while (n5 < n) {
                                            if (iterator.hasNext()) {
                                                iterator.next();
                                                iterator.remove();
                                            }
                                            ++n5;
                                        }
                                        ListIterator listIterator = (ListIterator)((Scalar)serializable).getArray().scalarIterator();
                                        for (int i = 0; i < n4 && listIterator.hasNext(); ++i) {
                                            listIterator.next();
                                        }
                                        Iterator iterator2 = object3.scalarIterator();
                                        while (iterator2.hasNext()) {
                                            Scalar scalar = (Scalar)iterator2.next();
                                            listIterator.add(scalar);
                                        }
                                        return serializable;
                                    }
                                    if (string.equals("&pop") && BridgeUtilities.expectArray(string, (Scalar)serializable)) {
                                        return ((Scalar)serializable).getArray().pop();
                                    }
                                    if (string.equals("&size") && ((Scalar)serializable).getArray() != null) {
                                        return SleepUtils.getScalar(((Scalar)serializable).getArray().size());
                                    }
                                    if (string.equals("&size") && ((Scalar)serializable).getHash() != null) {
                                        return SleepUtils.getScalar(((Scalar)serializable).getHash().keys().size());
                                    }
                                    if (!string.equals("&clear")) break block101;
                                    if (((Scalar)serializable).getArray() != null) {
                                        object3 = ((Scalar)serializable).getArray().scalarIterator();
                                        while (object3.hasNext()) {
                                            object3.next();
                                            object3.remove();
                                        }
                                    } else if (((Scalar)serializable).getHash() != null) {
                                        ((Scalar)serializable).setValue(SleepUtils.getHashScalar());
                                    } else {
                                        ((Scalar)serializable).setValue(SleepUtils.getEmptyScalar());
                                    }
                                    break block102;
                                }
                                if (!string.equals("&search") || !BridgeUtilities.expectArray(string, (Scalar)serializable)) break block103;
                                object3 = BridgeUtilities.getFunction(stack, scriptInstance);
                                int n6 = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), ((Scalar)serializable).getArray().size());
                                n = 0;
                                object = new Stack<Object>();
                                Iterator iterator = ((Scalar)serializable).getArray().scalarIterator();
                                while (iterator.hasNext()) {
                                    Scalar scalar = (Scalar)iterator.next();
                                    if (n6 > 0) {
                                        --n6;
                                        ++n;
                                        continue;
                                    }
                                    ((Stack)object).push(SleepUtils.getScalar(n));
                                    ((Stack)object).push(scalar);
                                    Scalar scalar3 = ((SleepClosure)object3).callClosure("eval", scriptInstance, (Stack)object);
                                    if (!SleepUtils.isEmptyScalar(scalar3)) {
                                        return scalar3;
                                    }
                                    ((Vector)object).clear();
                                    ++n;
                                }
                                break block102;
                            }
                            if (string.equals("&reduce") && SleepUtils.isFunctionScalar((Scalar)serializable)) {
                                object3 = SleepUtils.getFunctionFromScalar((Scalar)serializable, scriptInstance);
                                object2 = new Stack();
                                Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
                                object = iterator.hasNext() ? (Scalar)iterator.next() : SleepUtils.getEmptyScalar();
                                Scalar scalar = iterator.hasNext() ? (Scalar)iterator.next() : SleepUtils.getEmptyScalar();
                                Object var10_52 = null;
                                ((Stack)object2).push(object);
                                ((Stack)object2).push(scalar);
                                object = ((SleepClosure)object3).callClosure("eval", scriptInstance, (Stack)object2);
                                ((Vector)object2).clear();
                                while (iterator.hasNext()) {
                                    scalar = (Scalar)iterator.next();
                                    ((Stack)object2).push(scalar);
                                    ((Stack)object2).push(object);
                                    object = ((SleepClosure)object3).callClosure("eval", scriptInstance, (Stack)object2);
                                    ((Vector)object2).clear();
                                }
                                return object;
                            }
                            if ((string.equals("&subarray") || string.equals("&sublist")) && BridgeUtilities.expectArray(string, (Scalar)serializable)) {
                                return BasicUtilities.sublist((Scalar)serializable, BridgeUtilities.getInt(stack, 0), BridgeUtilities.getInt(stack, ((Scalar)serializable).getArray().size()));
                            }
                            if (string.equals("&remove")) {
                                while (!stack.isEmpty()) {
                                    object3 = (Scalar)stack.pop();
                                    if (((Scalar)serializable).getArray() != null) {
                                        ((Scalar)serializable).getArray().remove((Scalar)object3);
                                        continue;
                                    }
                                    if (((Scalar)serializable).getHash() == null) continue;
                                    ((Scalar)serializable).getHash().remove((Scalar)object3);
                                }
                                return serializable;
                            }
                            if (!string.equals("&keys")) break block104;
                            if (((Scalar)serializable).getHash() != null) {
                                object3 = SleepUtils.getEmptyScalar();
                                ((Scalar)object3).setValue(((Scalar)serializable).getHash().keys());
                                return object3;
                            }
                            break block102;
                        }
                        if (!string.equals("&setRemovalPolicy") && !string.equals("&setMissPolicy")) break block105;
                        if (((Scalar)serializable).getHash() == null || !(((Scalar)serializable).getHash() instanceof OrderedHashContainer)) {
                            throw new IllegalArgumentException(string + ": expected an ordered hash, received: " + SleepUtils.describe((Scalar)serializable));
                        }
                        object3 = BridgeUtilities.getFunction(stack, scriptInstance);
                        object2 = (OrderedHashContainer)((Scalar)serializable).getHash();
                        if (string.equals("&setMissPolicy")) {
                            ((OrderedHashContainer)object2).setMissPolicy((SleepClosure)object3);
                        } else {
                            ((OrderedHashContainer)object2).setRemovalPolicy((SleepClosure)object3);
                        }
                        break block102;
                    }
                    if (string.equals("&putAll")) {
                        if (((Scalar)serializable).getHash() != null) {
                            object3 = BridgeUtilities.getIterator(stack, scriptInstance);
                            Object object5 = object2 = stack.isEmpty() ? object3 : BridgeUtilities.getIterator(stack, scriptInstance);
                            while (object3.hasNext()) {
                                Scalar scalar = ((Scalar)serializable).getHash().getAt((Scalar)object3.next());
                                if (object2.hasNext()) {
                                    scalar.setValue((Scalar)object2.next());
                                    continue;
                                }
                                scalar.setValue(SleepUtils.getEmptyScalar());
                            }
                        } else if (((Scalar)serializable).getArray() != null) {
                            object3 = BridgeUtilities.getIterator(stack, scriptInstance);
                            while (object3.hasNext()) {
                                object2 = (Scalar)object3.next();
                                ((Scalar)serializable).getArray().push(SleepUtils.getScalar((Scalar)object2));
                            }
                        }
                        return serializable;
                    }
                    if (!string.equals("&values")) break block106;
                    if (((Scalar)serializable).getHash() != null) {
                        object3 = SleepUtils.getArrayScalar();
                        if (stack.isEmpty()) {
                            object2 = ((Scalar)serializable).getHash().getData().values().iterator();
                            while (object2.hasNext()) {
                                Scalar scalar = (Scalar)object2.next();
                                if (SleepUtils.isEmptyScalar(scalar)) continue;
                                ((Scalar)object3).getArray().push(SleepUtils.getScalar(scalar));
                            }
                        } else {
                            object2 = BridgeUtilities.getIterator(stack, scriptInstance);
                            while (object2.hasNext()) {
                                Scalar scalar = (Scalar)object2.next();
                                ((Scalar)object3).getArray().push(SleepUtils.getScalar(((Scalar)serializable).getHash().getAt(scalar)));
                            }
                        }
                        return object3;
                    }
                    break block102;
                }
                if (!string.equals("&exit")) break block107;
                scriptInstance.getScriptEnvironment().flagReturn(null, 16);
                if (!SleepUtils.isEmptyScalar((Scalar)serializable)) {
                    throw new RuntimeException(((Scalar)serializable).toString());
                }
                break block102;
            }
            if (!string.equals("&setField")) break block102;
            object3 = null;
            object2 = null;
            Object object6 = null;
            if (((Scalar)serializable).objectValue() == null) {
                throw new IllegalArgumentException("&setField: can not set field on a null object");
            }
            if (((Scalar)serializable).objectValue() instanceof Class) {
                object2 = (Class)((Scalar)serializable).objectValue();
                object6 = null;
            } else {
                object6 = ((Scalar)serializable).objectValue();
                object2 = object6.getClass();
            }
            while (!stack.isEmpty()) {
                object = BridgeUtilities.getKeyValuePair(stack);
                String string3 = ((KeyValuePair)object).getKey().toString();
                Scalar scalar = ((KeyValuePair)object).getValue();
                try {
                    try {
                        object3 = ((Class)object2).getDeclaredField(string3);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        object3 = ((Class)object2).getField(string3);
                    }
                    if (ObjectUtilities.isArgMatch(((Field)object3).getType(), scalar) != 0) {
                        ((Field)object3).setAccessible(true);
                        ((Field)object3).set(object6, ObjectUtilities.buildArgument(((Field)object3).getType(), scalar, scriptInstance));
                        continue;
                    }
                    throw new RuntimeException("unable to convert " + SleepUtils.describe(scalar) + " to a " + ((Field)object3).getType());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException("no field named " + string3 + " in " + object2);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException("cannot set " + string3 + " in " + object2 + ": " + exception.getMessage());
                }
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    private static Scalar sublist(Scalar scalar, int n, int n2) {
        int n3 = scalar.getArray().size();
        int n4 = BridgeUtilities.normalize(n, n3);
        int n5 = n2 < 0 ? n2 + n3 : n2;
        int n6 = n5 = n5 <= n3 ? n5 : n3;
        if (n4 > n5) {
            throw new IllegalArgumentException("illegal subarray(" + SleepUtils.describe(scalar) + ", " + n + " -> " + n4 + ", " + n2 + " -> " + n5 + ")");
        }
        return SleepUtils.getArrayScalar(scalar.getArray().sublist(n4, n5));
    }

    static {
        ParserConfig.addKeyword("isa");
        ParserConfig.addKeyword("in");
        ParserConfig.addKeyword("=~");
    }

    private static class eval
    implements Function {
        private eval() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = stack.pop().toString();
            try {
                if (string.equals("&eval")) {
                    Scalar scalar = SleepUtils.getScalar(scriptInstance.getScriptEnvironment().evaluateStatement(string2));
                    return scalar;
                }
                Scalar scalar = SleepUtils.getScalar(scriptInstance.getScriptEnvironment().evaluateExpression(string2));
                return scalar;
            }
            catch (YourCodeSucksException yourCodeSucksException) {
                scriptInstance.getScriptEnvironment().flagError(yourCodeSucksException);
                return SleepUtils.getEmptyScalar();
            }
        }
    }

    private static class systemProperties
    implements Function {
        private systemProperties() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            return SleepUtils.getHashWrapper(System.getProperties());
        }
    }

    private static class SetScope
    implements Function {
        private Pattern splitter = Pattern.compile("\\s+");

        private SetScope() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Variable variable = null;
            if (string.equals("&local")) {
                variable = scriptInstance.getScriptVariables().getLocalVariables();
            } else if (string.equals("&this")) {
                variable = scriptInstance.getScriptVariables().getClosureVariables();
            } else if (string.equals("&global")) {
                variable = scriptInstance.getScriptVariables().getGlobalVariables();
            }
            String string2 = stack.pop().toString();
            if (variable == null) {
                return SleepUtils.getEmptyScalar();
            }
            String[] stringArray = this.splitter.split(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (variable.scalarExists(stringArray[i])) continue;
                if (stringArray[i].charAt(0) == '$') {
                    scriptInstance.getScriptVariables().setScalarLevel(stringArray[i], SleepUtils.getEmptyScalar(), variable);
                    continue;
                }
                if (stringArray[i].charAt(0) == '@') {
                    scriptInstance.getScriptVariables().setScalarLevel(stringArray[i], SleepUtils.getArrayScalar(), variable);
                    continue;
                }
                if (stringArray[i].charAt(0) == '%') {
                    scriptInstance.getScriptVariables().setScalarLevel(stringArray[i], SleepUtils.getHashScalar(), variable);
                    continue;
                }
                throw new IllegalArgumentException(string + ": malformed variable name '" + stringArray[i] + "' from '" + string2 + "'");
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class reverse
    implements Function {
        private reverse() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = SleepUtils.getArrayScalar();
            Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
            while (iterator.hasNext()) {
                scalar.getArray().add(SleepUtils.getScalar((Scalar)iterator.next()), 0);
            }
            return scalar;
        }
    }

    private static class shift
    implements Function {
        private shift() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            ScalarArray scalarArray = BridgeUtilities.getArray(stack);
            return scalarArray.remove(0);
        }
    }

    private static class removeAt
    implements Function {
        private removeAt() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            block3: {
                Scalar scalar;
                block2: {
                    scalar = (Scalar)stack.pop();
                    if (scalar.getArray() == null) break block2;
                    while (!stack.isEmpty()) {
                        scalar.getArray().remove(BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), scalar.getArray().size()));
                    }
                    break block3;
                }
                if (scalar.getHash() == null) break block3;
                while (!stack.isEmpty()) {
                    Scalar scalar2 = scalar.getHash().getAt((Scalar)stack.pop());
                    scalar2.setValue(SleepUtils.getEmptyScalar());
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class copy
    implements Function {
        private copy() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = BridgeUtilities.getScalar(stack);
            if (scalar.getArray() != null || SleepUtils.isFunctionScalar(scalar)) {
                Iterator iterator;
                Scalar scalar2 = SleepUtils.getArrayScalar();
                Iterator iterator2 = iterator = scalar.getArray() == null ? SleepUtils.getFunctionFromScalar(scalar, scriptInstance).scalarIterator() : scalar.getArray().scalarIterator();
                while (iterator.hasNext()) {
                    scalar2.getArray().push(SleepUtils.getScalar((Scalar)iterator.next()));
                }
                return scalar2;
            }
            if (scalar.getHash() != null) {
                Scalar scalar3 = SleepUtils.getHashScalar();
                Iterator iterator = scalar.getHash().keys().scalarIterator();
                while (iterator.hasNext()) {
                    Scalar scalar4 = (Scalar)iterator.next();
                    Scalar scalar5 = scalar3.getHash().getAt(scalar4);
                    scalar5.setValue(scalar.getHash().getAt(scalar4));
                }
                return scalar3;
            }
            return SleepUtils.getScalar(scalar);
        }
    }

    private static class map
    implements Function {
        private map() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            SleepClosure sleepClosure = BridgeUtilities.getFunction(stack, scriptInstance);
            Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
            Scalar scalar = SleepUtils.getArrayScalar();
            Stack stack2 = new Stack();
            while (iterator.hasNext()) {
                stack2.push(iterator.next());
                Scalar scalar2 = sleepClosure.callClosure("eval", scriptInstance, stack2);
                if (!SleepUtils.isEmptyScalar(scalar2) || string.equals("&map")) {
                    scalar.getArray().push(SleepUtils.getScalar(scalar2));
                }
                stack2.clear();
            }
            return scalar;
        }
    }

    private static class lambda
    implements Function {
        private lambda() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Object object;
            SleepClosure sleepClosure;
            SleepClosure sleepClosure2;
            if (string.equals("&lambda")) {
                sleepClosure2 = BridgeUtilities.getFunction(stack, scriptInstance);
                sleepClosure = new SleepClosure(scriptInstance, sleepClosure2.getRunnableCode());
            } else if (string.equals("&compile_closure")) {
                object = stack.pop().toString();
                try {
                    sleepClosure = sleepClosure2 = new SleepClosure(scriptInstance, SleepUtils.ParseCode((String)object));
                }
                catch (YourCodeSucksException yourCodeSucksException) {
                    scriptInstance.getScriptEnvironment().flagError(yourCodeSucksException);
                    return SleepUtils.getEmptyScalar();
                }
            } else {
                sleepClosure = sleepClosure2 = BridgeUtilities.getFunction(stack, scriptInstance);
            }
            object = sleepClosure.getVariables();
            while (!stack.isEmpty()) {
                KeyValuePair keyValuePair = BridgeUtilities.getKeyValuePair(stack);
                if (keyValuePair.getKey().toString().equals("$this")) {
                    SleepClosure sleepClosure3 = (SleepClosure)keyValuePair.getValue().objectValue();
                    sleepClosure.setVariables(sleepClosure3.getVariables());
                    object = sleepClosure3.getVariables();
                    continue;
                }
                object.putScalar(keyValuePair.getKey().toString(), SleepUtils.getScalar(keyValuePair.getValue()));
            }
            return SleepUtils.getScalar(sleepClosure);
        }
    }

    private static class hash
    implements Function {
        private hash() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = null;
            scalar = string.equals("&ohash") ? SleepUtils.getOrderedHashScalar() : (string.equals("&ohasha") ? SleepUtils.getAccessOrderedHashScalar() : SleepUtils.getHashScalar());
            while (!stack.isEmpty()) {
                KeyValuePair keyValuePair = BridgeUtilities.getKeyValuePair(stack);
                Scalar scalar2 = scalar.getHash().getAt(keyValuePair.getKey());
                scalar2.setValue(keyValuePair.getValue());
            }
            return scalar;
        }
    }

    private static class function
    implements Function {
        private function() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (string.equals("&function") || string.equals("function")) {
                String string2 = BridgeUtilities.getString(stack, "");
                if (string2.length() == 0 || string2.charAt(0) != '&') {
                    throw new IllegalArgumentException(string + ": requested function name must begin with '&'");
                }
                return SleepUtils.getScalar(scriptInstance.getScriptEnvironment().getFunction(string2));
            }
            if (string.equals("&setf")) {
                String string3 = BridgeUtilities.getString(stack, "&eh");
                Object object = BridgeUtilities.getObject(stack);
                if (string3.charAt(0) == '&' && (object == null || object instanceof Function)) {
                    if (object == null) {
                        scriptInstance.getScriptEnvironment().getEnvironment().remove(string3);
                    } else {
                        scriptInstance.getScriptEnvironment().getEnvironment().put(string3, object);
                    }
                } else {
                    if (string3.charAt(0) != '&') {
                        throw new IllegalArgumentException("&setf: invalid function name '" + string3 + "'");
                    }
                    if (object != null) {
                        throw new IllegalArgumentException("&setf: can not set function " + string3 + " to a " + object.getClass());
                    }
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class f_cast
    implements Function {
        private f_cast() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar;
            Scalar scalar2 = BridgeUtilities.getScalar(stack);
            Scalar scalar3 = BridgeUtilities.getScalar(stack);
            if (string.equals("&casti")) {
                Class clazz = ObjectUtilities.convertScalarDescriptionToClass(scalar3);
                if (clazz != null) {
                    Object object = ObjectUtilities.buildArgument(clazz, scalar2, scriptInstance);
                    return SleepUtils.getScalar(object);
                }
                throw new RuntimeException("&casti: '" + scalar3 + "' is an invalid primitive cast identifier");
            }
            if (scalar2.getArray() == null) {
                if (scalar3.toString().charAt(0) == 'c') {
                    return SleepUtils.getScalar(scalar2.toString().toCharArray());
                }
                if (scalar3.toString().charAt(0) == 'b') {
                    return SleepUtils.getScalar((Object)BridgeUtilities.toByteArrayNoConversion(scalar2.toString()));
                }
                return SleepUtils.getEmptyScalar();
            }
            if (stack.size() == 0) {
                stack.push(SleepUtils.getScalar(scalar2.getArray().size()));
            }
            int[] nArray = new int[stack.size()];
            int n = 1;
            int n2 = 0;
            while (!stack.isEmpty()) {
                nArray[n2] = BridgeUtilities.getInt(stack, 0);
                n *= nArray[n2];
                ++n2;
            }
            Class clazz = ObjectUtilities.convertScalarDescriptionToClass(scalar3);
            if (clazz == null) {
                clazz = ObjectUtilities.getArrayType(scalar2, class$java$lang$Object == null ? (class$java$lang$Object = BasicUtilities.class$("java.lang.Object")) : class$java$lang$Object);
            }
            if (n != (scalar = BridgeUtilities.flattenArray(scalar2, null)).getArray().size()) {
                throw new RuntimeException("&cast: specified dimensions " + n + " is not equal to total array elements " + scalar.getArray().size());
            }
            Object object = Array.newInstance(clazz, nArray);
            int[] nArray2 = new int[nArray.length];
            if (scalar.getArray().size() == 0) {
                return SleepUtils.getScalar(object);
            }
            int n3 = 0;
            while (true) {
                Object object2 = object;
                for (int i = 0; i < nArray2.length - 1; ++i) {
                    object2 = Array.get(object2, nArray2[i]);
                }
                Object object3 = ObjectUtilities.buildArgument(clazz, scalar.getArray().getAt(n3), scriptInstance);
                Array.set(object2, nArray2[nArray2.length - 1], object3);
                int n4 = nArray2.length - 1;
                nArray2[n4] = nArray2[n4] + 1;
                int n5 = nArray2.length - 1;
                while (nArray2[n5] >= nArray[n5]) {
                    if (n5 == 0) {
                        return SleepUtils.getScalar(object);
                    }
                    nArray2[n5] = 0;
                    int n6 = n5 - 1;
                    nArray2[n6] = nArray2[n6] + 1;
                    --n5;
                }
                ++n3;
            }
        }
    }

    private static class array
    implements Function {
        private array() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = SleepUtils.getArrayScalar();
            while (!stack.isEmpty()) {
                scalar.getArray().push(SleepUtils.getScalar(BridgeUtilities.getScalar(stack)));
            }
            return scalar;
        }
    }

    private static class f_use
    implements Function {
        private HashMap bridges = new HashMap();

        private f_use() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            block18: {
                Object object;
                Object object2;
                File file = null;
                String string2 = "";
                Class<?> clazz = null;
                if (stack.size() == 2) {
                    file = ParserConfig.findJarFile(stack.pop().toString());
                    string2 = BridgeUtilities.getString(stack, "");
                } else {
                    object2 = (Scalar)stack.pop();
                    if (((Scalar)object2).objectValue() instanceof Class && string.equals("&use")) {
                        clazz = (Class<?>)((Scalar)object2).objectValue();
                    } else {
                        object = ParserConfig.findJarFile(((Scalar)object2).toString());
                        file = ((File)object).getParentFile();
                        string2 = ((File)object).getName();
                    }
                }
                if (file != null && !file.exists()) {
                    throw new IllegalArgumentException(string + ": could not locate source '" + file + "'");
                }
                try {
                    InputStream inputStream;
                    if (string.equals("&use")) {
                        if (clazz == null) {
                            if (file != null) {
                                object2 = new URLClassLoader(new URL[]{file.toURL()});
                                clazz = Class.forName(string2, true, (ClassLoader)object2);
                            } else {
                                clazz = Class.forName(string2);
                            }
                        }
                        if (this.bridges.get(clazz) == null) {
                            object2 = (Loadable)clazz.newInstance();
                            this.bridges.put(clazz, object2);
                        } else {
                            object2 = (Loadable)this.bridges.get(clazz);
                        }
                        object2.scriptLoaded(scriptInstance);
                        break block18;
                    }
                    object = (ScriptLoader)scriptInstance.getScriptEnvironment().getEnvironment().get("(isloaded)");
                    Scalar scalar = scriptInstance.getScriptVariables().getScalar("$__INCLUDE__");
                    if (scalar == null) {
                        scalar = SleepUtils.getEmptyScalar();
                        scriptInstance.getScriptVariables().getGlobalVariables().putScalar("$__INCLUDE__", scalar);
                    }
                    if (file != null) {
                        File file2 = file.isDirectory() ? new File(file, string2) : file;
                        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURL()});
                        ((ScriptLoader)object).touch(string2, file2.lastModified());
                        scriptInstance.associateFile(file2);
                        inputStream = uRLClassLoader.getResourceAsStream(string2);
                        scalar.setValue(SleepUtils.getScalar(file2));
                    } else {
                        File file3 = BridgeUtilities.toSleepFile(string2, scriptInstance);
                        ((ScriptLoader)object).touch(string2, file3.lastModified());
                        scriptInstance.associateFile(file3);
                        inputStream = new FileInputStream(file3);
                        scalar.setValue(SleepUtils.getScalar(file3));
                    }
                    if (inputStream != null) {
                        object2 = ((ScriptLoader)object).compileScript(string2, inputStream);
                        SleepUtils.runCode((Block)object2, scriptInstance.getScriptEnvironment());
                        break block18;
                    }
                    throw new IOException("unable to locate " + string2 + " from: " + file);
                }
                catch (YourCodeSucksException yourCodeSucksException) {
                    scriptInstance.getScriptEnvironment().flagError(yourCodeSucksException);
                }
                catch (Exception exception) {
                    scriptInstance.getScriptEnvironment().flagError(exception);
                }
            }
            return SleepUtils.getEmptyScalar();
        }
    }

    private static class HashKeyValueOp
    implements Operator {
        private HashKeyValueOp() {
        }

        public Scalar operate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = (Scalar)stack.pop();
            Scalar scalar2 = (Scalar)stack.pop();
            return SleepUtils.getScalar(new KeyValuePair(scalar, scalar2));
        }
    }

    private static class SyncPrimitives
    implements Function {
        private SyncPrimitives() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            if (string.equals("&semaphore")) {
                int n = BridgeUtilities.getInt(stack, 1);
                return SleepUtils.getScalar(new Semaphore(n));
            }
            if (string.equals("&acquire")) {
                Semaphore semaphore = (Semaphore)BridgeUtilities.getObject(stack);
                semaphore.P();
            } else if (string.equals("&release")) {
                Semaphore semaphore = (Semaphore)BridgeUtilities.getObject(stack);
                semaphore.V();
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

