/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.text.StringCharacterIterator;
import java.util.regex.PatternSyntaxException;

public class Transliteration {
    public static final int OPTION_DELETE = 1;
    public static final int OPTION_COMPLEMENT = 2;
    public static final int OPTION_SQUEEZE = 4;
    private static String AvailableOptions = "dDsSwW.\\-";
    private int options = 0;
    private Element pattern = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Element element = this.pattern;
        while (element != null) {
            if (element.isSpecial) {
                switch (element.item) {
                    case '.': {
                        stringBuffer.append("[:ANY:]");
                        break;
                    }
                    case 'd': {
                        stringBuffer.append("[:digit:]");
                        break;
                    }
                    case 'D': {
                        stringBuffer.append("[:non-digit:]");
                        break;
                    }
                    case 's': {
                        stringBuffer.append("[:whitespace:]");
                        break;
                    }
                    case 'S': {
                        stringBuffer.append("[:non-whitespace:]");
                        break;
                    }
                    case 'w': {
                        stringBuffer.append("[:word character:]");
                        break;
                    }
                    case 'W': {
                        stringBuffer.append("[:non-word character:]");
                        break;
                    }
                    default: {
                        stringBuffer.append(element.item);
                        break;
                    }
                }
            } else {
                stringBuffer.append(element.item);
            }
            stringBuffer2.append(element.replacement);
            element = element.next;
        }
        return "tr/" + stringBuffer + "/" + stringBuffer2 + "/";
    }

    private static String getRange(char c, char c2) {
        StringBuffer stringBuffer;
        block3: {
            block2: {
                stringBuffer = new StringBuffer();
                if (c >= c2) break block2;
                for (char c3 = c; c3 < c2; c3 = (char)(c3 + '\u0001')) {
                    stringBuffer.append(c3);
                }
                break block3;
            }
            if (c <= c2) break block3;
            for (char c4 = c; c4 > c2; c4 = (char)(c4 - '\u0001')) {
                stringBuffer.append(c4);
            }
        }
        return stringBuffer.toString();
    }

    private static String expandRanges(String string) throws PatternSyntaxException {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (stringBuffer.charAt(i) != '-') continue;
            if (i <= 0 || i >= stringBuffer.length() - 1) {
                throw new PatternSyntaxException("Dangling range operator '-'", string, string.length() - 1);
            }
            String string2 = Transliteration.getRange(stringBuffer.charAt(i - 1), stringBuffer.charAt(i + 1));
            stringBuffer.replace(i - 1, i + 1, string2);
            i += string2.length() - 2;
        }
        return stringBuffer.toString();
    }

    private Element buildPattern(String string, String string2) {
        Element element = null;
        Element element2 = null;
        string = Transliteration.expandRanges(string);
        string2 = Transliteration.expandRanges(string2);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringCharacterIterator stringCharacterIterator2 = new StringCharacterIterator(string2);
        while (stringCharacterIterator.current() != '\uffff') {
            element2 = element2 == null ? (element = new Element()) : (element2.next = new Element());
            if (stringCharacterIterator.current() == '\\') {
                element2.item = stringCharacterIterator.next();
                element2.replacement = stringCharacterIterator2.current();
                if (stringCharacterIterator.current() == '\uffff') {
                    throw new PatternSyntaxException("attempting to escape end of pattern string", string, stringCharacterIterator.getEndIndex() - 1);
                }
                if (AvailableOptions.indexOf(element2.item) == -1) {
                    throw new PatternSyntaxException("unrecognized escaped meta-character '" + element2.item + "'", string, stringCharacterIterator.getIndex());
                }
                element2.isSpecial = stringCharacterIterator.current() != '\\' && stringCharacterIterator.current() != '.' && stringCharacterIterator.current() != '-';
            } else {
                element2.item = stringCharacterIterator.current();
                element2.replacement = stringCharacterIterator2.current();
                element2.isSpecial = stringCharacterIterator.current() == '.';
            }
            stringCharacterIterator.next();
            stringCharacterIterator2.next();
            if (stringCharacterIterator2.current() != '\uffff' || (this.options & 1) == 1) continue;
            stringCharacterIterator2.last();
        }
        return element;
    }

    public static Transliteration compile(String string, String string2) throws PatternSyntaxException {
        return Transliteration.compile(string, string2, 0);
    }

    public static Transliteration compile(String string, String string2, int n) throws PatternSyntaxException {
        Transliteration transliteration = new Transliteration();
        transliteration.options = n;
        transliteration.pattern = transliteration.buildPattern(string, string2);
        return transliteration;
    }

    private boolean isMatch(char c, Element element) {
        boolean bl = false;
        if (element.isSpecial) {
            switch (element.item) {
                case '.': {
                    bl = true;
                    break;
                }
                case 'd': {
                    bl = Character.isDigit(c);
                    break;
                }
                case 'D': {
                    bl = !Character.isDigit(c);
                    break;
                }
                case 's': {
                    bl = Character.isWhitespace(c);
                    break;
                }
                case 'S': {
                    bl = !Character.isWhitespace(c);
                    break;
                }
                case 'w': {
                    bl = Character.isLetter(c);
                    break;
                }
                case 'W': {
                    bl = !Character.isLetter(c);
                }
            }
        } else {
            boolean bl2 = bl = element.item == c;
        }
        if ((this.options & 2) == 2) {
            bl = !bl;
        }
        return bl;
    }

    public String translate(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = null;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            element = this.pattern;
            bl = false;
            while (element != null) {
                if (this.isMatch(c, element)) {
                    if (element.replacement != '\uffff') {
                        stringBuffer.append(element.replacement);
                    }
                    while ((this.options & 4) == 4 && i + 1 < string.length() && string.charAt(i + 1) == c) {
                        ++i;
                    }
                    bl = true;
                    break;
                }
                element = element.next;
            }
            if (bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static class Element {
        public char item = (char)120;
        public char replacement = (char)120;
        public boolean isSpecial = false;
        public boolean isWildcard = false;
        public Element next = null;

        private Element() {
        }
    }
}

