/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.util.Hashtable;
import sleep.parser.Parser;

public class Checkers {
    protected static Hashtable keywords = new Hashtable();

    public static void addKeyword(String string) {
        keywords.put(string, Boolean.TRUE);
    }

    public static boolean isIfStatement(String string, String string2, String string3) {
        return string.toString().equals("if") && Checkers.isExpression(string2.toString()) && Checkers.isBlock(string3.toString());
    }

    public static boolean isElseStatement(String string, String string2) {
        return string.equals("else") && Checkers.isBlock(string2);
    }

    public static boolean isElseIfStatement(String string, String string2, String string3, String string4) {
        return string.equals("else") && Checkers.isIfStatement(string2, string3, string4);
    }

    public static final boolean isIncrementHack(String string) {
        return Checkers.isScalar(string) && string.length() > 3 && string.substring(string.length() - 2, string.length()).equals("++");
    }

    public static final boolean isDecrementHack(String string) {
        return Checkers.isScalar(string) && string.length() > 3 && string.substring(string.length() - 2, string.length()).equals("--");
    }

    public static final boolean isObjectNew(String string, String string2) {
        return string.equals("new");
    }

    public static final boolean isClosureCall(String string, String string2) {
        return string2.equals("EOT");
    }

    public static final boolean isImportStatement(String string, String string2) {
        return string.equals("import");
    }

    public static final boolean isClassLiteral(String string) {
        return string.length() >= 2 && string.charAt(0) == '^';
    }

    public static final boolean isClassPiece(String string) {
        if (string.length() >= 1 && !Checkers.isVariable(string) && Character.isJavaIdentifierStart(string.charAt(0))) {
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i)) || string.charAt(i) == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isClassIdentifier(Parser parser, String string) {
        return Checkers.isClassPiece(string) && parser.findImportedClass(string) != null;
    }

    public static final boolean isBindFilter(String string, String string2, String string3, String string4) {
        return Checkers.isBlock(string4);
    }

    public static final boolean isBindPredicate(String string, String string2, String string3) {
        return Checkers.isExpression(string2) && Checkers.isBlock(string3);
    }

    public static final boolean isBind(String string, String string2, String string3) {
        return !string2.equals("=") && Checkers.isBlock(string3);
    }

    public static boolean isHash(String string) {
        return string.charAt(0) == '%';
    }

    public static boolean isArray(String string) {
        return string.charAt(0) == '@';
    }

    public static boolean isFunctionReferenceToken(String string) {
        return string.charAt(0) == '&' && string.length() > 1 && !string.equals("&&");
    }

    public static final boolean isVariableReference(String string) {
        return string.length() >= 3 && string.charAt(0) == '\\' && !string.equals("\\$null") && Checkers.isVariable(string.substring(1));
    }

    public static final boolean isVariable(String string) {
        return Checkers.isScalar(string) || Checkers.isHash(string) || Checkers.isArray(string);
    }

    public static final boolean isScalar(String string) {
        return string.charAt(0) == '$';
    }

    public static boolean isIndex(String string) {
        return string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']';
    }

    public static boolean isExpression(String string) {
        return string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')';
    }

    public static boolean isBlock(String string) {
        return string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}';
    }

    public static boolean isFunctionCall(String string, String string2) {
        return (Checkers.isFunction(string) || string.equals("@") || string.equals("%")) && Checkers.isExpression(string2);
    }

    public static boolean isFunction(String string) {
        return (Character.isJavaIdentifierStart(string.charAt(0)) || string.charAt(0) == '&') && string.charAt(0) != '$' && keywords.get(string) == null;
    }

    public static boolean isDataLiteral(String string) {
        return string.length() > 2 && (string.substring(0, 2).equals("@(") || string.substring(0, 2).equals("%("));
    }

    public static boolean isFunctionCall(String string) {
        return (Checkers.isFunction(string) || Checkers.isDataLiteral(string)) && string.indexOf(40) > -1 && string.indexOf(41) > -1;
    }

    public static boolean isIndexableItem(String string, String string2) {
        return Checkers.isIndex(string2) && (Checkers.isFunctionCall(string) || Checkers.isExpression(string) || Checkers.isVariable(string) || Checkers.isIndex(string) || Checkers.isFunctionReferenceToken(string) || Checkers.isBacktick(string));
    }

    public static boolean isIndexableItem(String string) {
        int n;
        if (string.charAt(string.length() - 1) == ']' && (n = string.lastIndexOf(91)) > 0) {
            return Checkers.isIndexableItem(string.substring(0, n), string.substring(n, string.length()));
        }
        return false;
    }

    public static boolean isHashIndex(String string) {
        return Checkers.isHash(string) && string.indexOf(91) > -1 && string.indexOf(93) > -1;
    }

    public static boolean isArrayIndex(String string) {
        return Checkers.isArray(string) && string.indexOf(91) > -1 && string.indexOf(93) > -1;
    }

    public static boolean isOperator(String string, String string2, String string3) {
        return true;
    }

    public static final boolean isSpecialWhile(String string, String string2, String string3, String string4) {
        return Checkers.isWhile(string, string3, string4) && Checkers.isVariable(string2);
    }

    public static final boolean isWhile(String string, String string2, String string3) {
        return string.equals("while") && Checkers.isExpression(string2) && Checkers.isBlock(string3);
    }

    public static final boolean isFor(String string, String string2, String string3) {
        return string.equals("for") && Checkers.isExpression(string2) && Checkers.isBlock(string3);
    }

    public static final boolean isTryCatch(String string, String string2, String string3, String string4, String string5) {
        return string.equals("try") && string3.equals("catch") && Checkers.isBlock(string2) && Checkers.isBlock(string5) && Checkers.isScalar(string4);
    }

    public static final boolean isForeach(String string, String string2, String string3, String string4) {
        return string.equals("foreach") && Checkers.isVariable(string2) && Checkers.isExpression(string3) && Checkers.isBlock(string4);
    }

    public static final boolean isSpecialForeach(String string, String string2, String string3, String string4, String string5, String string6) {
        return string.equals("foreach") && Checkers.isVariable(string2) && string3.equals("=>") && Checkers.isVariable(string4) && Checkers.isExpression(string5) && Checkers.isBlock(string6);
    }

    public static final boolean isAssert(String string) {
        return string.equals("assert");
    }

    public static final boolean isReturn(String string) {
        return string.equals("return") || string.equals("done") || string.equals("halt") || string.equals("break") || string.equals("yield") || string.equals("continue") || string.equals("throw") || string.equals("callcc");
    }

    public static final boolean isString(String string) {
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    public static final boolean isBacktick(String string) {
        return string.charAt(0) == '`' && string.charAt(string.length() - 1) == '`';
    }

    public static final boolean isLiteral(String string) {
        return string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    public static final boolean isNumber(String string) {
        try {
            if (string.endsWith("L")) {
                string = string.substring(0, string.length() - 1);
                Long.decode(string);
            } else {
                Integer.decode(string);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static final boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static final boolean isBoolean(String string) {
        return string.equals("true") || string.equals("false");
    }

    public static final boolean isBiPredicate(String string, String string2, String string3) {
        return true;
    }

    public static final boolean isUniPredicate(String string, String string2) {
        return string.charAt(0) == '-' || string.length() > 1 && string.charAt(0) == '!' && string.charAt(1) == '-';
    }

    public static final boolean isAndPredicate(String string, String string2, String string3) {
        return string2.equals("&&");
    }

    public static final boolean isOrPredicate(String string, String string2, String string3) {
        return string2.equals("||");
    }

    public static final boolean isComment(String string) {
        return string.charAt(0) == '#' && string.charAt(string.length() - 1) == '\n';
    }

    public static final boolean isEndOfVar(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '$' || c == '\\';
    }

    static {
        keywords.put("if", Boolean.TRUE);
        keywords.put("for", Boolean.TRUE);
        keywords.put("while", Boolean.TRUE);
        keywords.put("foreach", Boolean.TRUE);
        keywords.put("&&", Boolean.TRUE);
        keywords.put("||", Boolean.TRUE);
        keywords.put("EOT", Boolean.TRUE);
        keywords.put("EOL", Boolean.TRUE);
        keywords.put("return", Boolean.TRUE);
        keywords.put("halt", Boolean.TRUE);
        keywords.put("done", Boolean.TRUE);
        keywords.put("break", Boolean.TRUE);
        keywords.put("continue", Boolean.TRUE);
        keywords.put("yield", Boolean.TRUE);
        keywords.put("throw", Boolean.TRUE);
        keywords.put("try", Boolean.TRUE);
        keywords.put("catch", Boolean.TRUE);
        keywords.put("assert", Boolean.TRUE);
    }
}

