/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import sleep.engine.Block;
import sleep.engine.GeneratedSteps;
import sleep.error.SyntaxError;
import sleep.error.YourCodeSucksException;
import sleep.parser.CodeGenerator;
import sleep.parser.ImportManager;
import sleep.parser.LexicalAnalyzer;
import sleep.parser.Statement;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;
import sleep.parser.TokenParser;

public class Parser {
    private static final boolean DEBUG_ITER = false;
    private static final boolean DEBUG_LEX = false;
    private static final boolean DEBUG_COMMENTS = false;
    private static final boolean DEBUG_TPARSER = false;
    protected String code;
    protected String name;
    protected LinkedList comments = new LinkedList();
    protected LinkedList errors = new LinkedList();
    protected LinkedList warnings = new LinkedList();
    protected TokenList tokens = new TokenList();
    protected LinkedList statements = new LinkedList();
    protected Block executeMe;
    public char EndOfTerm = (char)59;
    protected ImportManager imports;
    protected GeneratedSteps factory = null;

    public ImportManager getImportManager() {
        return this.imports;
    }

    public void setCodeFactory(GeneratedSteps generatedSteps) {
        this.factory = generatedSteps;
    }

    public void importPackage(String string, String string2) {
        this.imports.importPackage(string, string2);
    }

    public Class findImportedClass(String string) {
        return this.imports.findImportedClass(string);
    }

    public void setEndOfTerm(char c) {
        this.EndOfTerm = c;
    }

    public Parser(String string) {
        this("unknown", string);
    }

    public Parser(String string, String string2) {
        this(string, string2, null);
    }

    public Parser(String string, String string2, ImportManager importManager) {
        if (importManager == null) {
            importManager = new ImportManager();
        }
        this.imports = importManager;
        this.importPackage("java.lang.*", null);
        this.importPackage("java.util.*", null);
        this.importPackage("sleep.runtime.*", null);
        this.code = string2;
        this.name = string;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public LinkedList getStatements() {
        return this.statements;
    }

    public String getName() {
        return this.name;
    }

    public void parse() throws YourCodeSucksException {
        this.parse(new StringIterator(this.code));
    }

    public void parse(StringIterator stringIterator) throws YourCodeSucksException {
        TokenList tokenList = LexicalAnalyzer.GroupBlockTokens(this, stringIterator);
        if (this.hasErrors()) {
            this.errors.addAll(this.warnings);
            throw new YourCodeSucksException(this.errors);
        }
        LinkedList linkedList = TokenParser.ParseBlocks(this, tokenList);
        if (this.hasErrors()) {
            this.errors.addAll(this.warnings);
            throw new YourCodeSucksException(this.errors);
        }
        CodeGenerator codeGenerator = new CodeGenerator(this, this.factory);
        codeGenerator.parseBlock(linkedList);
        if (this.hasErrors()) {
            this.errors.addAll(this.warnings);
            throw new YourCodeSucksException(this.errors);
        }
        this.executeMe = codeGenerator.getRunnableBlock();
    }

    public void reportError(String string, Token token) {
        this.errors.add(new SyntaxError(string, token.toString(), token.getHint()));
    }

    public void reportErrorWithMarker(String string, Token token) {
        this.errors.add(new SyntaxError(string, token.toString(), token.getHint(), token.getMarker()));
    }

    public void reportError(SyntaxError syntaxError) {
        this.errors.add(syntaxError);
    }

    public Block getRunnableBlock() {
        return this.executeMe;
    }

    public void reportWarning(String string, Token token) {
        this.warnings.add(new SyntaxError(string, token.toString(), token.getHint()));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public void addComment(String string) {
        this.comments.add(string);
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            File file = new File(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            Parser parser = new Parser(stringBuffer.toString());
            parser.parse();
            System.out.println(parser.getRunnableBlock());
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            LinkedList linkedList = yourCodeSucksException.getErrors();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                SyntaxError syntaxError = (SyntaxError)iterator.next();
                System.out.println("Error: " + syntaxError.getDescription() + " at line " + syntaxError.getLineNumber());
                System.out.println("       " + syntaxError.getCodeSnippet());
                if (syntaxError.getMarker() == null) continue;
                System.out.println("       " + syntaxError.getMarker());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

