EXPECTED = {'PKIX1Explicit88': {'extensibility-implied': False,
                     'imports': {},
                     'object-classes': {},
                     'object-sets': {},
                     'tags': 'EXPLICIT',
                     'types': {'AdministrationDomainName': {'members': [{'name': 'numeric',
                                                                         'size': [(0,
                                                                                   'ub-domain-name-length')],
                                                                         'type': 'NumericString'},
                                                                        {'name': 'printable',
                                                                         'size': [(0,
                                                                                   'ub-domain-name-length')],
                                                                         'type': 'PrintableString'}],
                                                            'tag': {'class': 'APPLICATION',
                                                                    'number': 2},
                                                            'type': 'CHOICE'},
                               'AlgorithmIdentifier': {'members': [{'name': 'algorithm',
                                                                    'type': 'OBJECT '
                                                                            'IDENTIFIER'},
                                                                   {'choices': {},
                                                                    'name': 'parameters',
                                                                    'optional': True,
                                                                    'type': 'ANY '
                                                                            'DEFINED '
                                                                            'BY',
                                                                    'value': 'algorithm'}],
                                                       'type': 'SEQUENCE'},
                               'Attribute': {'members': [{'name': 'type',
                                                          'type': 'AttributeType'},
                                                         {'element': {'type': 'AttributeValue'},
                                                          'name': 'values',
                                                          'type': 'SET OF'}],
                                             'type': 'SEQUENCE'},
                               'AttributeType': {'type': 'OBJECT IDENTIFIER'},
                               'AttributeTypeAndValue': {'members': [{'name': 'type',
                                                                      'type': 'AttributeType'},
                                                                     {'name': 'value',
                                                                      'type': 'AttributeValue'}],
                                                         'type': 'SEQUENCE'},
                               'AttributeValue': {'choices': {},
                                                  'type': 'ANY DEFINED BY',
                                                  'value': 'type'},
                               'BuiltInDomainDefinedAttribute': {'members': [{'name': 'type',
                                                                              'size': [(1,
                                                                                        'ub-domain-defined-attribute-type-length')],
                                                                              'type': 'PrintableString'},
                                                                             {'name': 'value',
                                                                              'size': [(1,
                                                                                        'ub-domain-defined-attribute-value-length')],
                                                                              'type': 'PrintableString'}],
                                                                 'type': 'SEQUENCE'},
                               'BuiltInDomainDefinedAttributes': {'element': {'type': 'BuiltInDomainDefinedAttribute'},
                                                                  'size': [(1,
                                                                            'ub-domain-defined-attributes')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                               'BuiltInStandardAttributes': {'members': [{'name': 'country-name',
                                                                          'optional': True,
                                                                          'type': 'CountryName'},
                                                                         {'name': 'administration-domain-name',
                                                                          'optional': True,
                                                                          'type': 'AdministrationDomainName'},
                                                                         {'name': 'network-address',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 0},
                                                                          'type': 'NetworkAddress'},
                                                                         {'name': 'terminal-identifier',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 1},
                                                                          'type': 'TerminalIdentifier'},
                                                                         {'name': 'private-domain-name',
                                                                          'optional': True,
                                                                          'tag': {'number': 2},
                                                                          'type': 'PrivateDomainName'},
                                                                         {'name': 'organization-name',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 3},
                                                                          'type': 'OrganizationName'},
                                                                         {'name': 'numeric-user-identifier',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 4},
                                                                          'type': 'NumericUserIdentifier'},
                                                                         {'name': 'personal-name',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 5},
                                                                          'type': 'PersonalName'},
                                                                         {'name': 'organizational-unit-names',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 6},
                                                                          'type': 'OrganizationalUnitNames'}],
                                                             'type': 'SEQUENCE'},
                               'Certificate': {'members': [{'name': 'tbsCertificate',
                                                            'type': 'TBSCertificate'},
                                                           {'name': 'signatureAlgorithm',
                                                            'type': 'AlgorithmIdentifier'},
                                                           {'name': 'signature',
                                                            'type': 'BIT '
                                                                    'STRING'}],
                                               'type': 'SEQUENCE'},
                               'CertificateList': {'members': [{'name': 'tbsCertList',
                                                                'type': 'TBSCertList'},
                                                               {'name': 'signatureAlgorithm',
                                                                'type': 'AlgorithmIdentifier'},
                                                               {'name': 'signature',
                                                                'type': 'BIT '
                                                                        'STRING'}],
                                                   'type': 'SEQUENCE'},
                               'CertificateSerialNumber': {'type': 'INTEGER'},
                               'CommonName': {'size': [(1,
                                                        'ub-common-name-length')],
                                              'type': 'PrintableString'},
                               'CountryName': {'members': [{'name': 'x121-dcc-code',
                                                            'size': ['ub-country-name-numeric-length'],
                                                            'type': 'NumericString'},
                                                           {'name': 'iso-3166-alpha2-code',
                                                            'size': ['ub-country-name-alpha-length'],
                                                            'type': 'PrintableString'}],
                                               'tag': {'class': 'APPLICATION',
                                                       'number': 1},
                                               'type': 'CHOICE'},
                               'DirectoryString': {'members': [{'name': 'teletexString',
                                                                'size': [(1,
                                                                          'MAX')],
                                                                'type': 'TeletexString'},
                                                               {'name': 'printableString',
                                                                'size': [(1,
                                                                          'MAX')],
                                                                'type': 'PrintableString'},
                                                               {'name': 'universalString',
                                                                'size': [(1,
                                                                          'MAX')],
                                                                'type': 'UniversalString'},
                                                               {'name': 'utf8String',
                                                                'size': [(1,
                                                                          'MAX')],
                                                                'type': 'UTF8String'},
                                                               {'name': 'bmpString',
                                                                'size': [(1,
                                                                          'MAX')],
                                                                'type': 'BMPString'}],
                                                   'type': 'CHOICE'},
                               'DistinguishedName': {'type': 'RDNSequence'},
                               'DomainComponent': {'type': 'IA5String'},
                               'EmailAddress': {'size': [(1,
                                                          'ub-emailaddress-length')],
                                                'type': 'IA5String'},
                               'ExtendedNetworkAddress': {'members': [{'members': [{'name': 'number',
                                                                                    'size': [(1,
                                                                                              'ub-e163-4-number-length')],
                                                                                    'tag': {'kind': 'IMPLICIT',
                                                                                            'number': 0},
                                                                                    'type': 'NumericString'},
                                                                                   {'name': 'sub-address',
                                                                                    'optional': True,
                                                                                    'size': [(1,
                                                                                              'ub-e163-4-sub-address-length')],
                                                                                    'tag': {'kind': 'IMPLICIT',
                                                                                            'number': 1},
                                                                                    'type': 'NumericString'}],
                                                                       'name': 'e163-4-address',
                                                                       'type': 'SEQUENCE'},
                                                                      {'name': 'psap-address',
                                                                       'tag': {'kind': 'IMPLICIT',
                                                                               'number': 0},
                                                                       'type': 'PresentationAddress'}],
                                                          'type': 'CHOICE'},
                               'Extension': {'members': [{'name': 'extnID',
                                                          'type': 'OBJECT '
                                                                  'IDENTIFIER'},
                                                         {'default': False,
                                                          'name': 'critical',
                                                          'type': 'BOOLEAN'},
                                                         {'name': 'extnValue',
                                                          'type': 'OCTET '
                                                                  'STRING'}],
                                             'type': 'SEQUENCE'},
                               'ExtensionAttribute': {'members': [{'name': 'extension-attribute-type',
                                                                   'restricted-to': [(0,
                                                                                      'ub-extension-attributes')],
                                                                   'tag': {'kind': 'IMPLICIT',
                                                                           'number': 0},
                                                                   'type': 'INTEGER'},
                                                                  {'choices': {},
                                                                   'name': 'extension-attribute-value',
                                                                   'tag': {'number': 1},
                                                                   'type': 'ANY '
                                                                           'DEFINED '
                                                                           'BY',
                                                                   'value': 'extension-attribute-type'}],
                                                      'type': 'SEQUENCE'},
                               'ExtensionAttributes': {'element': {'type': 'ExtensionAttribute'},
                                                       'size': [(1,
                                                                 'ub-extension-attributes')],
                                                       'type': 'SET OF'},
                               'ExtensionORAddressComponents': {'type': 'PDSParameter'},
                               'ExtensionPhysicalDeliveryAddressComponents': {'type': 'PDSParameter'},
                               'Extensions': {'element': {'type': 'Extension'},
                                              'size': [(1, 'MAX')],
                                              'type': 'SEQUENCE OF'},
                               'LocalPostalAttributes': {'type': 'PDSParameter'},
                               'Name': {'members': [{'name': 'rdnSequence',
                                                     'type': 'RDNSequence'}],
                                        'type': 'CHOICE'},
                               'NetworkAddress': {'type': 'X121Address'},
                               'NumericUserIdentifier': {'size': [(1,
                                                                   'ub-numeric-user-id-length')],
                                                         'type': 'NumericString'},
                               'ORAddress': {'members': [{'name': 'built-in-standard-attributes',
                                                          'type': 'BuiltInStandardAttributes'},
                                                         {'name': 'built-in-domain-defined-attributes',
                                                          'optional': True,
                                                          'type': 'BuiltInDomainDefinedAttributes'},
                                                         {'name': 'extension-attributes',
                                                          'optional': True,
                                                          'type': 'ExtensionAttributes'}],
                                             'type': 'SEQUENCE'},
                               'OrganizationName': {'size': [(1,
                                                              'ub-organization-name-length')],
                                                    'type': 'PrintableString'},
                               'OrganizationalUnitName': {'size': [(1,
                                                                    'ub-organizational-unit-name-length')],
                                                          'type': 'PrintableString'},
                               'OrganizationalUnitNames': {'element': {'type': 'OrganizationalUnitName'},
                                                           'size': [(1,
                                                                     'ub-organizational-units')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                               'PDSName': {'size': [(1, 'ub-pds-name-length')],
                                           'type': 'PrintableString'},
                               'PDSParameter': {'members': [{'name': 'printable-string',
                                                             'optional': True,
                                                             'size': [(1,
                                                                       'ub-pds-parameter-length')],
                                                             'type': 'PrintableString'},
                                                            {'name': 'teletex-string',
                                                             'optional': True,
                                                             'size': [(1,
                                                                       'ub-pds-parameter-length')],
                                                             'type': 'TeletexString'}],
                                                'type': 'SET'},
                               'PersonalName': {'members': [{'name': 'surname',
                                                             'size': [(1,
                                                                       'ub-surname-length')],
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 0},
                                                             'type': 'PrintableString'},
                                                            {'name': 'given-name',
                                                             'optional': True,
                                                             'size': [(1,
                                                                       'ub-given-name-length')],
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 1},
                                                             'type': 'PrintableString'},
                                                            {'name': 'initials',
                                                             'optional': True,
                                                             'size': [(1,
                                                                       'ub-initials-length')],
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 2},
                                                             'type': 'PrintableString'},
                                                            {'name': 'generation-qualifier',
                                                             'optional': True,
                                                             'size': [(1,
                                                                       'ub-generation-qualifier-length')],
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 3},
                                                             'type': 'PrintableString'}],
                                                'type': 'SET'},
                               'PhysicalDeliveryCountryName': {'members': [{'name': 'x121-dcc-code',
                                                                            'size': ['ub-country-name-numeric-length'],
                                                                            'type': 'NumericString'},
                                                                           {'name': 'iso-3166-alpha2-code',
                                                                            'size': ['ub-country-name-alpha-length'],
                                                                            'type': 'PrintableString'}],
                                                               'type': 'CHOICE'},
                               'PhysicalDeliveryOfficeName': {'type': 'PDSParameter'},
                               'PhysicalDeliveryOfficeNumber': {'type': 'PDSParameter'},
                               'PhysicalDeliveryOrganizationName': {'type': 'PDSParameter'},
                               'PhysicalDeliveryPersonalName': {'type': 'PDSParameter'},
                               'PostOfficeBoxAddress': {'type': 'PDSParameter'},
                               'PostalCode': {'members': [{'name': 'numeric-code',
                                                           'size': [(1,
                                                                     'ub-postal-code-length')],
                                                           'type': 'NumericString'},
                                                          {'name': 'printable-code',
                                                           'size': [(1,
                                                                     'ub-postal-code-length')],
                                                           'type': 'PrintableString'}],
                                              'type': 'CHOICE'},
                               'PosteRestanteAddress': {'type': 'PDSParameter'},
                               'PresentationAddress': {'members': [{'name': 'pSelector',
                                                                    'optional': True,
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 0},
                                                                    'type': 'OCTET '
                                                                            'STRING'},
                                                                   {'name': 'sSelector',
                                                                    'optional': True,
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 1},
                                                                    'type': 'OCTET '
                                                                            'STRING'},
                                                                   {'name': 'tSelector',
                                                                    'optional': True,
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 2},
                                                                    'type': 'OCTET '
                                                                            'STRING'},
                                                                   {'element': {'type': 'OCTET '
                                                                                        'STRING'},
                                                                    'name': 'nAddresses',
                                                                    'size': [(1,
                                                                              'MAX')],
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 3},
                                                                    'type': 'SET '
                                                                            'OF'}],
                                                       'type': 'SEQUENCE'},
                               'PrivateDomainName': {'members': [{'name': 'numeric',
                                                                  'size': [(1,
                                                                            'ub-domain-name-length')],
                                                                  'type': 'NumericString'},
                                                                 {'name': 'printable',
                                                                  'size': [(1,
                                                                            'ub-domain-name-length')],
                                                                  'type': 'PrintableString'}],
                                                     'type': 'CHOICE'},
                               'RDNSequence': {'element': {'type': 'RelativeDistinguishedName'},
                                               'type': 'SEQUENCE OF'},
                               'RelativeDistinguishedName': {'element': {'type': 'AttributeTypeAndValue'},
                                                             'size': [(1,
                                                                       'MAX')],
                                                             'type': 'SET OF'},
                               'StreetAddress': {'type': 'PDSParameter'},
                               'SubjectPublicKeyInfo': {'members': [{'name': 'algorithm',
                                                                     'type': 'AlgorithmIdentifier'},
                                                                    {'name': 'subjectPublicKey',
                                                                     'type': 'BIT '
                                                                             'STRING'}],
                                                        'type': 'SEQUENCE'},
                               'TBSCertList': {'members': [{'name': 'version',
                                                            'optional': True,
                                                            'type': 'Version'},
                                                           {'name': 'signature',
                                                            'type': 'AlgorithmIdentifier'},
                                                           {'name': 'issuer',
                                                            'type': 'Name'},
                                                           {'name': 'thisUpdate',
                                                            'type': 'Time'},
                                                           {'name': 'nextUpdate',
                                                            'optional': True,
                                                            'type': 'Time'},
                                                           {'element': {'members': [{'name': 'userCertificate',
                                                                                     'type': 'CertificateSerialNumber'},
                                                                                    {'name': 'revocationDate',
                                                                                     'type': 'Time'},
                                                                                    {'name': 'crlEntryExtensions',
                                                                                     'optional': True,
                                                                                     'type': 'Extensions'}],
                                                                        'type': 'SEQUENCE'},
                                                            'name': 'revokedCertificates',
                                                            'optional': True,
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                                                           {'name': 'crlExtensions',
                                                            'optional': True,
                                                            'tag': {'number': 0},
                                                            'type': 'Extensions'}],
                                               'type': 'SEQUENCE'},
                               'TBSCertificate': {'members': [{'default': 'v1',
                                                               'name': 'version',
                                                               'tag': {'number': 0},
                                                               'type': 'Version'},
                                                              {'name': 'serialNumber',
                                                               'type': 'CertificateSerialNumber'},
                                                              {'name': 'signature',
                                                               'type': 'AlgorithmIdentifier'},
                                                              {'name': 'issuer',
                                                               'type': 'Name'},
                                                              {'name': 'validity',
                                                               'type': 'Validity'},
                                                              {'name': 'subject',
                                                               'type': 'Name'},
                                                              {'name': 'subjectPublicKeyInfo',
                                                               'type': 'SubjectPublicKeyInfo'},
                                                              {'name': 'issuerUniqueID',
                                                               'optional': True,
                                                               'tag': {'kind': 'IMPLICIT',
                                                                       'number': 1},
                                                               'type': 'UniqueIdentifier'},
                                                              {'name': 'subjectUniqueID',
                                                               'optional': True,
                                                               'tag': {'kind': 'IMPLICIT',
                                                                       'number': 2},
                                                               'type': 'UniqueIdentifier'},
                                                              {'name': 'extensions',
                                                               'optional': True,
                                                               'tag': {'number': 3},
                                                               'type': 'Extensions'}],
                                                  'type': 'SEQUENCE'},
                               'TeletexCommonName': {'size': [(1,
                                                               'ub-common-name-length')],
                                                     'type': 'TeletexString'},
                               'TeletexDomainDefinedAttribute': {'members': [{'name': 'type',
                                                                              'size': [(1,
                                                                                        'ub-domain-defined-attribute-type-length')],
                                                                              'type': 'TeletexString'},
                                                                             {'name': 'value',
                                                                              'size': [(1,
                                                                                        'ub-domain-defined-attribute-value-length')],
                                                                              'type': 'TeletexString'}],
                                                                 'type': 'SEQUENCE'},
                               'TeletexDomainDefinedAttributes': {'element': {'type': 'TeletexDomainDefinedAttribute'},
                                                                  'size': [(1,
                                                                            'ub-domain-defined-attributes')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                               'TeletexOrganizationName': {'size': [(1,
                                                                     'ub-organization-name-length')],
                                                           'type': 'TeletexString'},
                               'TeletexOrganizationalUnitName': {'size': [(1,
                                                                           'ub-organizational-unit-name-length')],
                                                                 'type': 'TeletexString'},
                               'TeletexOrganizationalUnitNames': {'element': {'type': 'TeletexOrganizationalUnitName'},
                                                                  'size': [(1,
                                                                            'ub-organizational-units')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                               'TeletexPersonalName': {'members': [{'name': 'surname',
                                                                    'size': [(1,
                                                                              'ub-surname-length')],
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 0},
                                                                    'type': 'TeletexString'},
                                                                   {'name': 'given-name',
                                                                    'optional': True,
                                                                    'size': [(1,
                                                                              'ub-given-name-length')],
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 1},
                                                                    'type': 'TeletexString'},
                                                                   {'name': 'initials',
                                                                    'optional': True,
                                                                    'size': [(1,
                                                                              'ub-initials-length')],
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 2},
                                                                    'type': 'TeletexString'},
                                                                   {'name': 'generation-qualifier',
                                                                    'optional': True,
                                                                    'size': [(1,
                                                                              'ub-generation-qualifier-length')],
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 3},
                                                                    'type': 'TeletexString'}],
                                                       'type': 'SET'},
                               'TerminalIdentifier': {'size': [(1,
                                                                'ub-terminal-id-length')],
                                                      'type': 'PrintableString'},
                               'TerminalType': {'named-numbers': {'g3-facsimile': 5,
                                                                  'g4-facsimile': 6,
                                                                  'ia5-terminal': 7,
                                                                  'teletex': 4,
                                                                  'telex': 3,
                                                                  'videotex': 8},
                                                'restricted-to': [(0,
                                                                   'ub-integer-options')],
                                                'type': 'INTEGER'},
                               'Time': {'members': [{'name': 'utcTime',
                                                     'type': 'UTCTime'},
                                                    {'name': 'generalTime',
                                                     'type': 'GeneralizedTime'}],
                                        'type': 'CHOICE'},
                               'UnformattedPostalAddress': {'members': [{'element': {'size': [(1,
                                                                                               'ub-pds-parameter-length')],
                                                                                     'type': 'PrintableString'},
                                                                         'name': 'printable-address',
                                                                         'optional': True,
                                                                         'size': [(1,
                                                                                   'ub-pds-physical-address-lines')],
                                                                         'type': 'SEQUENCE '
                                                                                 'OF'},
                                                                        {'name': 'teletex-string',
                                                                         'optional': True,
                                                                         'size': [(1,
                                                                                   'ub-unformatted-address-length')],
                                                                         'type': 'TeletexString'}],
                                                            'type': 'SET'},
                               'UniqueIdentifier': {'type': 'BIT STRING'},
                               'UniquePostalName': {'type': 'PDSParameter'},
                               'Validity': {'members': [{'name': 'notBefore',
                                                         'type': 'Time'},
                                                        {'name': 'notAfter',
                                                         'type': 'Time'}],
                                            'type': 'SEQUENCE'},
                               'Version': {'named-numbers': {'v1': 0,
                                                             'v2': 1,
                                                             'v3': 2},
                                           'type': 'INTEGER'},
                               'X121Address': {'size': [(1,
                                                         'ub-x121-address-length')],
                                               'type': 'NumericString'},
                               'X520CommonName': {'members': [{'name': 'teletexString',
                                                               'size': [(1,
                                                                         'ub-common-name')],
                                                               'type': 'TeletexString'},
                                                              {'name': 'printableString',
                                                               'size': [(1,
                                                                         'ub-common-name')],
                                                               'type': 'PrintableString'},
                                                              {'name': 'universalString',
                                                               'size': [(1,
                                                                         'ub-common-name')],
                                                               'type': 'UniversalString'},
                                                              {'name': 'utf8String',
                                                               'size': [(1,
                                                                         'ub-common-name')],
                                                               'type': 'UTF8String'},
                                                              {'name': 'bmpString',
                                                               'size': [(1,
                                                                         'ub-common-name')],
                                                               'type': 'BMPString'}],
                                                  'type': 'CHOICE'},
                               'X520LocalityName': {'members': [{'name': 'teletexString',
                                                                 'size': [(1,
                                                                           'ub-locality-name')],
                                                                 'type': 'TeletexString'},
                                                                {'name': 'printableString',
                                                                 'size': [(1,
                                                                           'ub-locality-name')],
                                                                 'type': 'PrintableString'},
                                                                {'name': 'universalString',
                                                                 'size': [(1,
                                                                           'ub-locality-name')],
                                                                 'type': 'UniversalString'},
                                                                {'name': 'utf8String',
                                                                 'size': [(1,
                                                                           'ub-locality-name')],
                                                                 'type': 'UTF8String'},
                                                                {'name': 'bmpString',
                                                                 'size': [(1,
                                                                           'ub-locality-name')],
                                                                 'type': 'BMPString'}],
                                                    'type': 'CHOICE'},
                               'X520OrganizationName': {'members': [{'name': 'teletexString',
                                                                     'size': [(1,
                                                                               'ub-organization-name')],
                                                                     'type': 'TeletexString'},
                                                                    {'name': 'printableString',
                                                                     'size': [(1,
                                                                               'ub-organization-name')],
                                                                     'type': 'PrintableString'},
                                                                    {'name': 'universalString',
                                                                     'size': [(1,
                                                                               'ub-organization-name')],
                                                                     'type': 'UniversalString'},
                                                                    {'name': 'utf8String',
                                                                     'size': [(1,
                                                                               'ub-organization-name')],
                                                                     'type': 'UTF8String'},
                                                                    {'name': 'bmpString',
                                                                     'size': [(1,
                                                                               'ub-organization-name')],
                                                                     'type': 'BMPString'}],
                                                        'type': 'CHOICE'},
                               'X520OrganizationalUnitName': {'members': [{'name': 'teletexString',
                                                                           'size': [(1,
                                                                                     'ub-organizational-unit-name')],
                                                                           'type': 'TeletexString'},
                                                                          {'name': 'printableString',
                                                                           'size': [(1,
                                                                                     'ub-organizational-unit-name')],
                                                                           'type': 'PrintableString'},
                                                                          {'name': 'universalString',
                                                                           'size': [(1,
                                                                                     'ub-organizational-unit-name')],
                                                                           'type': 'UniversalString'},
                                                                          {'name': 'utf8String',
                                                                           'size': [(1,
                                                                                     'ub-organizational-unit-name')],
                                                                           'type': 'UTF8String'},
                                                                          {'name': 'bmpString',
                                                                           'size': [(1,
                                                                                     'ub-organizational-unit-name')],
                                                                           'type': 'BMPString'}],
                                                              'type': 'CHOICE'},
                               'X520Pseudonym': {'members': [{'name': 'teletexString',
                                                              'size': [(1,
                                                                        'ub-pseudonym')],
                                                              'type': 'TeletexString'},
                                                             {'name': 'printableString',
                                                              'size': [(1,
                                                                        'ub-pseudonym')],
                                                              'type': 'PrintableString'},
                                                             {'name': 'universalString',
                                                              'size': [(1,
                                                                        'ub-pseudonym')],
                                                              'type': 'UniversalString'},
                                                             {'name': 'utf8String',
                                                              'size': [(1,
                                                                        'ub-pseudonym')],
                                                              'type': 'UTF8String'},
                                                             {'name': 'bmpString',
                                                              'size': [(1,
                                                                        'ub-pseudonym')],
                                                              'type': 'BMPString'}],
                                                 'type': 'CHOICE'},
                               'X520SerialNumber': {'size': [(1,
                                                              'ub-serial-number')],
                                                    'type': 'PrintableString'},
                               'X520StateOrProvinceName': {'members': [{'name': 'teletexString',
                                                                        'size': [(1,
                                                                                  'ub-state-name')],
                                                                        'type': 'TeletexString'},
                                                                       {'name': 'printableString',
                                                                        'size': [(1,
                                                                                  'ub-state-name')],
                                                                        'type': 'PrintableString'},
                                                                       {'name': 'universalString',
                                                                        'size': [(1,
                                                                                  'ub-state-name')],
                                                                        'type': 'UniversalString'},
                                                                       {'name': 'utf8String',
                                                                        'size': [(1,
                                                                                  'ub-state-name')],
                                                                        'type': 'UTF8String'},
                                                                       {'name': 'bmpString',
                                                                        'size': [(1,
                                                                                  'ub-state-name')],
                                                                        'type': 'BMPString'}],
                                                           'type': 'CHOICE'},
                               'X520Title': {'members': [{'name': 'teletexString',
                                                          'size': [(1,
                                                                    'ub-title')],
                                                          'type': 'TeletexString'},
                                                         {'name': 'printableString',
                                                          'size': [(1,
                                                                    'ub-title')],
                                                          'type': 'PrintableString'},
                                                         {'name': 'universalString',
                                                          'size': [(1,
                                                                    'ub-title')],
                                                          'type': 'UniversalString'},
                                                         {'name': 'utf8String',
                                                          'size': [(1,
                                                                    'ub-title')],
                                                          'type': 'UTF8String'},
                                                         {'name': 'bmpString',
                                                          'size': [(1,
                                                                    'ub-title')],
                                                          'type': 'BMPString'}],
                                             'type': 'CHOICE'},
                               'X520countryName': {'size': [2],
                                                   'type': 'PrintableString'},
                               'X520dnQualifier': {'type': 'PrintableString'},
                               'X520name': {'members': [{'name': 'teletexString',
                                                         'size': [(1,
                                                                   'ub-name')],
                                                         'type': 'TeletexString'},
                                                        {'name': 'printableString',
                                                         'size': [(1,
                                                                   'ub-name')],
                                                         'type': 'PrintableString'},
                                                        {'name': 'universalString',
                                                         'size': [(1,
                                                                   'ub-name')],
                                                         'type': 'UniversalString'},
                                                        {'name': 'utf8String',
                                                         'size': [(1,
                                                                   'ub-name')],
                                                         'type': 'UTF8String'},
                                                        {'name': 'bmpString',
                                                         'size': [(1,
                                                                   'ub-name')],
                                                         'type': 'BMPString'}],
                                            'type': 'CHOICE'}},
                     'values': {'common-name': {'type': 'INTEGER', 'value': 1},
                                'extended-network-address': {'type': 'INTEGER',
                                                             'value': 22},
                                'extension-OR-address-components': {'type': 'INTEGER',
                                                                    'value': 12},
                                'extension-physical-delivery-address-components': {'type': 'INTEGER',
                                                                                   'value': 15},
                                'id-ad': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 48]},
                                'id-ad-caIssuers': {'type': 'OBJECT IDENTIFIER',
                                                    'value': ['id-ad', 2]},
                                'id-ad-caRepository': {'type': 'OBJECT '
                                                               'IDENTIFIER',
                                                       'value': ['id-ad', 5]},
                                'id-ad-ocsp': {'type': 'OBJECT IDENTIFIER',
                                               'value': ['id-ad', 1]},
                                'id-ad-timeStamping': {'type': 'OBJECT '
                                                               'IDENTIFIER',
                                                       'value': ['id-ad', 3]},
                                'id-at': {'type': 'OBJECT IDENTIFIER',
                                          'value': [('joint-iso-ccitt', 2),
                                                    ('ds', 5),
                                                    4]},
                                'id-at-commonName': {'type': 'AttributeType',
                                                     'value': None},
                                'id-at-countryName': {'type': 'AttributeType',
                                                      'value': None},
                                'id-at-dnQualifier': {'type': 'AttributeType',
                                                      'value': None},
                                'id-at-generationQualifier': {'type': 'AttributeType',
                                                              'value': None},
                                'id-at-givenName': {'type': 'AttributeType',
                                                    'value': None},
                                'id-at-initials': {'type': 'AttributeType',
                                                   'value': None},
                                'id-at-localityName': {'type': 'AttributeType',
                                                       'value': None},
                                'id-at-name': {'type': 'AttributeType',
                                               'value': None},
                                'id-at-organizationName': {'type': 'AttributeType',
                                                           'value': None},
                                'id-at-organizationalUnitName': {'type': 'AttributeType',
                                                                 'value': None},
                                'id-at-pseudonym': {'type': 'AttributeType',
                                                    'value': None},
                                'id-at-serialNumber': {'type': 'AttributeType',
                                                       'value': None},
                                'id-at-stateOrProvinceName': {'type': 'AttributeType',
                                                              'value': None},
                                'id-at-surname': {'type': 'AttributeType',
                                                  'value': None},
                                'id-at-title': {'type': 'AttributeType',
                                                'value': None},
                                'id-domainComponent': {'type': 'AttributeType',
                                                       'value': None},
                                'id-emailAddress': {'type': 'AttributeType',
                                                    'value': None},
                                'id-kp': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 3]},
                                'id-pe': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 1]},
                                'id-pkix': {'type': 'OBJECT IDENTIFIER',
                                            'value': [('iso', 1),
                                                      ('identified-organization',
                                                       3),
                                                      ('dod', 6),
                                                      ('internet', 1),
                                                      ('security', 5),
                                                      ('mechanisms', 5),
                                                      ('pkix', 7)]},
                                'id-qt': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 2]},
                                'id-qt-cps': {'type': 'OBJECT IDENTIFIER',
                                              'value': ['id-qt', 1]},
                                'id-qt-unotice': {'type': 'OBJECT IDENTIFIER',
                                                  'value': ['id-qt', 2]},
                                'local-postal-attributes': {'type': 'INTEGER',
                                                            'value': 21},
                                'pds-name': {'type': 'INTEGER', 'value': 7},
                                'physical-delivery-country-name': {'type': 'INTEGER',
                                                                   'value': 8},
                                'physical-delivery-office-name': {'type': 'INTEGER',
                                                                  'value': 10},
                                'physical-delivery-office-number': {'type': 'INTEGER',
                                                                    'value': 11},
                                'physical-delivery-organization-name': {'type': 'INTEGER',
                                                                        'value': 14},
                                'physical-delivery-personal-name': {'type': 'INTEGER',
                                                                    'value': 13},
                                'pkcs-9': {'type': 'OBJECT IDENTIFIER',
                                           'value': [('iso', 1),
                                                     ('member-body', 2),
                                                     ('us', 840),
                                                     ('rsadsi', 113549),
                                                     ('pkcs', 1),
                                                     9]},
                                'post-office-box-address': {'type': 'INTEGER',
                                                            'value': 18},
                                'postal-code': {'type': 'INTEGER', 'value': 9},
                                'poste-restante-address': {'type': 'INTEGER',
                                                           'value': 19},
                                'street-address': {'type': 'INTEGER',
                                                   'value': 17},
                                'teletex-common-name': {'type': 'INTEGER',
                                                        'value': 2},
                                'teletex-domain-defined-attributes': {'type': 'INTEGER',
                                                                      'value': 6},
                                'teletex-organization-name': {'type': 'INTEGER',
                                                              'value': 3},
                                'teletex-organizational-unit-names': {'type': 'INTEGER',
                                                                      'value': 5},
                                'teletex-personal-name': {'type': 'INTEGER',
                                                          'value': 4},
                                'terminal-type': {'type': 'INTEGER',
                                                  'value': 23},
                                'ub-common-name': {'type': 'INTEGER',
                                                   'value': 64},
                                'ub-common-name-length': {'type': 'INTEGER',
                                                          'value': 64},
                                'ub-country-name-alpha-length': {'type': 'INTEGER',
                                                                 'value': 2},
                                'ub-country-name-numeric-length': {'type': 'INTEGER',
                                                                   'value': 3},
                                'ub-domain-defined-attribute-type-length': {'type': 'INTEGER',
                                                                            'value': 8},
                                'ub-domain-defined-attribute-value-length': {'type': 'INTEGER',
                                                                             'value': 128},
                                'ub-domain-defined-attributes': {'type': 'INTEGER',
                                                                 'value': 4},
                                'ub-domain-name-length': {'type': 'INTEGER',
                                                          'value': 16},
                                'ub-e163-4-number-length': {'type': 'INTEGER',
                                                            'value': 15},
                                'ub-e163-4-sub-address-length': {'type': 'INTEGER',
                                                                 'value': 40},
                                'ub-emailaddress-length': {'type': 'INTEGER',
                                                           'value': 255},
                                'ub-extension-attributes': {'type': 'INTEGER',
                                                            'value': 256},
                                'ub-generation-qualifier-length': {'type': 'INTEGER',
                                                                   'value': 3},
                                'ub-given-name-length': {'type': 'INTEGER',
                                                         'value': 16},
                                'ub-initials-length': {'type': 'INTEGER',
                                                       'value': 5},
                                'ub-integer-options': {'type': 'INTEGER',
                                                       'value': 256},
                                'ub-locality-name': {'type': 'INTEGER',
                                                     'value': 128},
                                'ub-match': {'type': 'INTEGER', 'value': 128},
                                'ub-name': {'type': 'INTEGER', 'value': 32768},
                                'ub-numeric-user-id-length': {'type': 'INTEGER',
                                                              'value': 32},
                                'ub-organization-name': {'type': 'INTEGER',
                                                         'value': 64},
                                'ub-organization-name-length': {'type': 'INTEGER',
                                                                'value': 64},
                                'ub-organizational-unit-name': {'type': 'INTEGER',
                                                                'value': 64},
                                'ub-organizational-unit-name-length': {'type': 'INTEGER',
                                                                       'value': 32},
                                'ub-organizational-units': {'type': 'INTEGER',
                                                            'value': 4},
                                'ub-pds-name-length': {'type': 'INTEGER',
                                                       'value': 16},
                                'ub-pds-parameter-length': {'type': 'INTEGER',
                                                            'value': 30},
                                'ub-pds-physical-address-lines': {'type': 'INTEGER',
                                                                  'value': 6},
                                'ub-postal-code-length': {'type': 'INTEGER',
                                                          'value': 16},
                                'ub-pseudonym': {'type': 'INTEGER',
                                                 'value': 128},
                                'ub-serial-number': {'type': 'INTEGER',
                                                     'value': 64},
                                'ub-state-name': {'type': 'INTEGER',
                                                  'value': 128},
                                'ub-surname-length': {'type': 'INTEGER',
                                                      'value': 40},
                                'ub-terminal-id-length': {'type': 'INTEGER',
                                                          'value': 24},
                                'ub-title': {'type': 'INTEGER', 'value': 64},
                                'ub-unformatted-address-length': {'type': 'INTEGER',
                                                                  'value': 180},
                                'ub-x121-address-length': {'type': 'INTEGER',
                                                           'value': 16},
                                'unformatted-postal-address': {'type': 'INTEGER',
                                                               'value': 16},
                                'unique-postal-name': {'type': 'INTEGER',
                                                       'value': 20}}},
 'PKIX1Implicit88': {'extensibility-implied': False,
                     'imports': {'PKIX1Explicit88': ['Attribute',
                                                     'BMPString',
                                                     'CertificateSerialNumber',
                                                     'DirectoryString',
                                                     'Name',
                                                     'ORAddress',
                                                     'RelativeDistinguishedName',
                                                     'UTF8String',
                                                     'id-kp',
                                                     'id-pe',
                                                     'id-qt-cps',
                                                     'id-qt-unotice']},
                     'object-classes': {},
                     'object-sets': {},
                     'tags': 'IMPLICIT',
                     'types': {'AccessDescription': {'members': [{'name': 'accessMethod',
                                                                  'type': 'OBJECT '
                                                                          'IDENTIFIER'},
                                                                 {'name': 'accessLocation',
                                                                  'type': 'GeneralName'}],
                                                     'type': 'SEQUENCE'},
                               'AnotherName': {'members': [{'name': 'type-id',
                                                            'type': 'OBJECT '
                                                                    'IDENTIFIER'},
                                                           {'choices': {},
                                                            'name': 'value',
                                                            'tag': {'kind': 'EXPLICIT',
                                                                    'number': 0},
                                                            'type': 'ANY '
                                                                    'DEFINED '
                                                                    'BY',
                                                            'value': 'type-id'}],
                                               'type': 'SEQUENCE'},
                               'AuthorityInfoAccessSyntax': {'element': {'type': 'AccessDescription'},
                                                             'size': [(1,
                                                                       'MAX')],
                                                             'type': 'SEQUENCE '
                                                                     'OF'},
                               'AuthorityKeyIdentifier': {'members': [{'name': 'keyIdentifier',
                                                                       'optional': True,
                                                                       'tag': {'number': 0},
                                                                       'type': 'KeyIdentifier'},
                                                                      {'name': 'authorityCertIssuer',
                                                                       'optional': True,
                                                                       'tag': {'number': 1},
                                                                       'type': 'GeneralNames'},
                                                                      {'name': 'authorityCertSerialNumber',
                                                                       'optional': True,
                                                                       'tag': {'number': 2},
                                                                       'type': 'CertificateSerialNumber'}],
                                                          'type': 'SEQUENCE'},
                               'BaseCRLNumber': {'type': 'CRLNumber'},
                               'BaseDistance': {'restricted-to': [(0, 'MAX')],
                                                'type': 'INTEGER'},
                               'BasicConstraints': {'members': [{'default': False,
                                                                 'name': 'cA',
                                                                 'type': 'BOOLEAN'},
                                                                {'name': 'pathLenConstraint',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    'MAX')],
                                                                 'type': 'INTEGER'}],
                                                    'type': 'SEQUENCE'},
                               'CPSuri': {'type': 'IA5String'},
                               'CRLDistributionPoints': {'element': {'type': 'DistributionPoint'},
                                                         'size': [(1, 'MAX')],
                                                         'type': 'SEQUENCE OF'},
                               'CRLNumber': {'restricted-to': [(0, 'MAX')],
                                             'type': 'INTEGER'},
                               'CRLReason': {'type': 'ENUMERATED',
                                             'values': [('unspecified', 0),
                                                        ('keyCompromise', 1),
                                                        ('cACompromise', 2),
                                                        ('affiliationChanged',
                                                         3),
                                                        ('superseded', 4),
                                                        ('cessationOfOperation',
                                                         5),
                                                        ('certificateHold', 6),
                                                        ('removeFromCRL', 8),
                                                        ('privilegeWithdrawn',
                                                         9),
                                                        ('aACompromise', 10)]},
                               'CertPolicyId': {'type': 'OBJECT IDENTIFIER'},
                               'CertificateIssuer': {'type': 'GeneralNames'},
                               'CertificatePolicies': {'element': {'type': 'PolicyInformation'},
                                                       'size': [(1, 'MAX')],
                                                       'type': 'SEQUENCE OF'},
                               'DisplayText': {'members': [{'name': 'ia5String',
                                                            'size': [(1, 200)],
                                                            'type': 'IA5String'},
                                                           {'name': 'visibleString',
                                                            'size': [(1, 200)],
                                                            'type': 'VisibleString'},
                                                           {'name': 'bmpString',
                                                            'size': [(1, 200)],
                                                            'type': 'BMPString'},
                                                           {'name': 'utf8String',
                                                            'size': [(1, 200)],
                                                            'type': 'UTF8String'}],
                                               'type': 'CHOICE'},
                               'DistributionPoint': {'members': [{'name': 'distributionPoint',
                                                                  'optional': True,
                                                                  'tag': {'number': 0},
                                                                  'type': 'DistributionPointName'},
                                                                 {'name': 'reasons',
                                                                  'optional': True,
                                                                  'tag': {'number': 1},
                                                                  'type': 'ReasonFlags'},
                                                                 {'name': 'cRLIssuer',
                                                                  'optional': True,
                                                                  'tag': {'number': 2},
                                                                  'type': 'GeneralNames'}],
                                                     'type': 'SEQUENCE'},
                               'DistributionPointName': {'members': [{'name': 'fullName',
                                                                      'tag': {'number': 0},
                                                                      'type': 'GeneralNames'},
                                                                     {'name': 'nameRelativeToCRLIssuer',
                                                                      'tag': {'number': 1},
                                                                      'type': 'RelativeDistinguishedName'}],
                                                         'type': 'CHOICE'},
                               'EDIPartyName': {'members': [{'name': 'nameAssigner',
                                                             'optional': True,
                                                             'tag': {'number': 0},
                                                             'type': 'DirectoryString'},
                                                            {'name': 'partyName',
                                                             'tag': {'number': 1},
                                                             'type': 'DirectoryString'}],
                                                'type': 'SEQUENCE'},
                               'ExtKeyUsageSyntax': {'element': {'type': 'KeyPurposeId'},
                                                     'size': [(1, 'MAX')],
                                                     'type': 'SEQUENCE OF'},
                               'FreshestCRL': {'type': 'CRLDistributionPoints'},
                               'GeneralName': {'members': [{'name': 'otherName',
                                                            'tag': {'number': 0},
                                                            'type': 'AnotherName'},
                                                           {'name': 'rfc822Name',
                                                            'tag': {'number': 1},
                                                            'type': 'IA5String'},
                                                           {'name': 'dNSName',
                                                            'tag': {'number': 2},
                                                            'type': 'IA5String'},
                                                           {'name': 'x400Address',
                                                            'tag': {'number': 3},
                                                            'type': 'ORAddress'},
                                                           {'name': 'directoryName',
                                                            'tag': {'number': 4},
                                                            'type': 'Name'},
                                                           {'name': 'ediPartyName',
                                                            'tag': {'number': 5},
                                                            'type': 'EDIPartyName'},
                                                           {'name': 'uniformResourceIdentifier',
                                                            'tag': {'number': 6},
                                                            'type': 'IA5String'},
                                                           {'name': 'iPAddress',
                                                            'tag': {'number': 7},
                                                            'type': 'OCTET '
                                                                    'STRING'},
                                                           {'name': 'registeredID',
                                                            'tag': {'number': 8},
                                                            'type': 'OBJECT '
                                                                    'IDENTIFIER'}],
                                               'type': 'CHOICE'},
                               'GeneralNames': {'element': {'type': 'GeneralName'},
                                                'size': [(1, 'MAX')],
                                                'type': 'SEQUENCE OF'},
                               'GeneralSubtree': {'members': [{'name': 'base',
                                                               'type': 'GeneralName'},
                                                              {'default': 0,
                                                               'name': 'minimum',
                                                               'tag': {'number': 0},
                                                               'type': 'BaseDistance'},
                                                              {'name': 'maximum',
                                                               'optional': True,
                                                               'tag': {'number': 1},
                                                               'type': 'BaseDistance'}],
                                                  'type': 'SEQUENCE'},
                               'GeneralSubtrees': {'element': {'type': 'GeneralSubtree'},
                                                   'size': [(1, 'MAX')],
                                                   'type': 'SEQUENCE OF'},
                               'HoldInstructionCode': {'type': 'OBJECT '
                                                               'IDENTIFIER'},
                               'InhibitAnyPolicy': {'type': 'SkipCerts'},
                               'InvalidityDate': {'type': 'GeneralizedTime'},
                               'IssuerAltName': {'type': 'GeneralNames'},
                               'IssuingDistributionPoint': {'members': [{'name': 'distributionPoint',
                                                                         'optional': True,
                                                                         'tag': {'number': 0},
                                                                         'type': 'DistributionPointName'},
                                                                        {'default': False,
                                                                         'name': 'onlyContainsUserCerts',
                                                                         'tag': {'number': 1},
                                                                         'type': 'BOOLEAN'},
                                                                        {'default': False,
                                                                         'name': 'onlyContainsCACerts',
                                                                         'tag': {'number': 2},
                                                                         'type': 'BOOLEAN'},
                                                                        {'name': 'onlySomeReasons',
                                                                         'optional': True,
                                                                         'tag': {'number': 3},
                                                                         'type': 'ReasonFlags'},
                                                                        {'default': False,
                                                                         'name': 'indirectCRL',
                                                                         'tag': {'number': 4},
                                                                         'type': 'BOOLEAN'},
                                                                        {'default': False,
                                                                         'name': 'onlyContainsAttributeCerts',
                                                                         'tag': {'number': 5},
                                                                         'type': 'BOOLEAN'}],
                                                            'type': 'SEQUENCE'},
                               'KeyIdentifier': {'type': 'OCTET STRING'},
                               'KeyPurposeId': {'type': 'OBJECT IDENTIFIER'},
                               'KeyUsage': {'named-bits': [('digitalSignature',
                                                            '0'),
                                                           ('nonRepudiation',
                                                            '1'),
                                                           ('keyEncipherment',
                                                            '2'),
                                                           ('dataEncipherment',
                                                            '3'),
                                                           ('keyAgreement',
                                                            '4'),
                                                           ('keyCertSign', '5'),
                                                           ('cRLSign', '6'),
                                                           ('encipherOnly',
                                                            '7'),
                                                           ('decipherOnly',
                                                            '8')],
                                            'type': 'BIT STRING'},
                               'NameConstraints': {'members': [{'name': 'permittedSubtrees',
                                                                'optional': True,
                                                                'tag': {'number': 0},
                                                                'type': 'GeneralSubtrees'},
                                                               {'name': 'excludedSubtrees',
                                                                'optional': True,
                                                                'tag': {'number': 1},
                                                                'type': 'GeneralSubtrees'}],
                                                   'type': 'SEQUENCE'},
                               'NoticeReference': {'members': [{'name': 'organization',
                                                                'type': 'DisplayText'},
                                                               {'element': {'type': 'INTEGER'},
                                                                'name': 'noticeNumbers',
                                                                'type': 'SEQUENCE '
                                                                        'OF'}],
                                                   'type': 'SEQUENCE'},
                               'PolicyConstraints': {'members': [{'name': 'requireExplicitPolicy',
                                                                  'optional': True,
                                                                  'tag': {'number': 0},
                                                                  'type': 'SkipCerts'},
                                                                 {'name': 'inhibitPolicyMapping',
                                                                  'optional': True,
                                                                  'tag': {'number': 1},
                                                                  'type': 'SkipCerts'}],
                                                     'type': 'SEQUENCE'},
                               'PolicyInformation': {'members': [{'name': 'policyIdentifier',
                                                                  'type': 'CertPolicyId'},
                                                                 {'element': {'type': 'PolicyQualifierInfo'},
                                                                  'name': 'policyQualifiers',
                                                                  'optional': True,
                                                                  'size': [(1,
                                                                            'MAX')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'}],
                                                     'type': 'SEQUENCE'},
                               'PolicyMappings': {'element': {'members': [{'name': 'issuerDomainPolicy',
                                                                           'type': 'CertPolicyId'},
                                                                          {'name': 'subjectDomainPolicy',
                                                                           'type': 'CertPolicyId'}],
                                                              'type': 'SEQUENCE'},
                                                  'size': [(1, 'MAX')],
                                                  'type': 'SEQUENCE OF'},
                               'PolicyQualifierId': {'type': 'OBJECT '
                                                             'IDENTIFIER'},
                               'PolicyQualifierInfo': {'members': [{'name': 'policyQualifierId',
                                                                    'type': 'PolicyQualifierId'},
                                                                   {'choices': {},
                                                                    'name': 'qualifier',
                                                                    'type': 'ANY '
                                                                            'DEFINED '
                                                                            'BY',
                                                                    'value': 'policyQualifierId'}],
                                                       'type': 'SEQUENCE'},
                               'PrivateKeyUsagePeriod': {'members': [{'name': 'notBefore',
                                                                      'optional': True,
                                                                      'tag': {'number': 0},
                                                                      'type': 'GeneralizedTime'},
                                                                     {'name': 'notAfter',
                                                                      'optional': True,
                                                                      'tag': {'number': 1},
                                                                      'type': 'GeneralizedTime'}],
                                                         'type': 'SEQUENCE'},
                               'ReasonFlags': {'named-bits': [('unused', '0'),
                                                              ('keyCompromise',
                                                               '1'),
                                                              ('cACompromise',
                                                               '2'),
                                                              ('affiliationChanged',
                                                               '3'),
                                                              ('superseded',
                                                               '4'),
                                                              ('cessationOfOperation',
                                                               '5'),
                                                              ('certificateHold',
                                                               '6'),
                                                              ('privilegeWithdrawn',
                                                               '7'),
                                                              ('aACompromise',
                                                               '8')],
                                               'type': 'BIT STRING'},
                               'SkipCerts': {'restricted-to': [(0, 'MAX')],
                                             'type': 'INTEGER'},
                               'SubjectAltName': {'type': 'GeneralNames'},
                               'SubjectDirectoryAttributes': {'element': {'type': 'Attribute'},
                                                              'size': [(1,
                                                                        'MAX')],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                               'SubjectInfoAccessSyntax': {'element': {'type': 'AccessDescription'},
                                                           'size': [(1, 'MAX')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                               'SubjectKeyIdentifier': {'type': 'KeyIdentifier'},
                               'UserNotice': {'members': [{'name': 'noticeRef',
                                                           'optional': True,
                                                           'type': 'NoticeReference'},
                                                          {'name': 'explicitText',
                                                           'optional': True,
                                                           'type': 'DisplayText'}],
                                              'type': 'SEQUENCE'}},
                     'values': {'anyExtendedKeyUsage': {'type': 'OBJECT '
                                                                'IDENTIFIER',
                                                        'value': ['id-ce-extKeyUsage',
                                                                  0]},
                                'anyPolicy': {'type': 'OBJECT IDENTIFIER',
                                              'value': ['id-ce-certificatePolicies',
                                                        0]},
                                'holdInstruction': {'type': 'OBJECT IDENTIFIER',
                                                    'value': [('joint-iso-itu-t',
                                                               2),
                                                              ('member-body',
                                                               2),
                                                              ('us', 840),
                                                              ('x9cm', 10040),
                                                              2]},
                                'id-ce': {'type': 'OBJECT IDENTIFIER',
                                          'value': [('joint-iso-ccitt', 2),
                                                    ('ds', 5),
                                                    29]},
                                'id-ce-authorityKeyIdentifier': {'type': 'OBJECT '
                                                                         'IDENTIFIER',
                                                                 'value': ['id-ce',
                                                                           35]},
                                'id-ce-basicConstraints': {'type': 'OBJECT '
                                                                   'IDENTIFIER',
                                                           'value': ['id-ce',
                                                                     19]},
                                'id-ce-cRLDistributionPoints': {'type': 'OBJECT '
                                                                        'IDENTIFIER',
                                                                'value': ['id-ce',
                                                                          31]},
                                'id-ce-cRLNumber': {'type': 'OBJECT IDENTIFIER',
                                                    'value': ['id-ce', 20]},
                                'id-ce-cRLReasons': {'type': 'OBJECT '
                                                             'IDENTIFIER',
                                                     'value': ['id-ce', 21]},
                                'id-ce-certificateIssuer': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-ce',
                                                                      29]},
                                'id-ce-certificatePolicies': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['id-ce',
                                                                        32]},
                                'id-ce-deltaCRLIndicator': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-ce',
                                                                      27]},
                                'id-ce-extKeyUsage': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-ce', 37]},
                                'id-ce-freshestCRL': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-ce', 46]},
                                'id-ce-holdInstructionCode': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['id-ce',
                                                                        23]},
                                'id-ce-inhibitAnyPolicy': {'type': 'OBJECT '
                                                                   'IDENTIFIER',
                                                           'value': ['id-ce',
                                                                     54]},
                                'id-ce-invalidityDate': {'type': 'OBJECT '
                                                                 'IDENTIFIER',
                                                         'value': ['id-ce',
                                                                   24]},
                                'id-ce-issuerAltName': {'type': 'OBJECT '
                                                                'IDENTIFIER',
                                                        'value': ['id-ce', 18]},
                                'id-ce-issuingDistributionPoint': {'type': 'OBJECT '
                                                                           'IDENTIFIER',
                                                                   'value': ['id-ce',
                                                                             28]},
                                'id-ce-keyUsage': {'type': 'OBJECT IDENTIFIER',
                                                   'value': ['id-ce', 15]},
                                'id-ce-nameConstraints': {'type': 'OBJECT '
                                                                  'IDENTIFIER',
                                                          'value': ['id-ce',
                                                                    30]},
                                'id-ce-policyConstraints': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-ce',
                                                                      36]},
                                'id-ce-policyMappings': {'type': 'OBJECT '
                                                                 'IDENTIFIER',
                                                         'value': ['id-ce',
                                                                   33]},
                                'id-ce-privateKeyUsagePeriod': {'type': 'OBJECT '
                                                                        'IDENTIFIER',
                                                                'value': ['id-ce',
                                                                          16]},
                                'id-ce-subjectAltName': {'type': 'OBJECT '
                                                                 'IDENTIFIER',
                                                         'value': ['id-ce',
                                                                   17]},
                                'id-ce-subjectDirectoryAttributes': {'type': 'OBJECT '
                                                                             'IDENTIFIER',
                                                                     'value': ['id-ce',
                                                                               9]},
                                'id-ce-subjectKeyIdentifier': {'type': 'OBJECT '
                                                                       'IDENTIFIER',
                                                               'value': ['id-ce',
                                                                         14]},
                                'id-holdinstruction-callissuer': {'type': 'OBJECT '
                                                                          'IDENTIFIER',
                                                                  'value': ['holdInstruction',
                                                                            2]},
                                'id-holdinstruction-none': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['holdInstruction',
                                                                      1]},
                                'id-holdinstruction-reject': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['holdInstruction',
                                                                        3]},
                                'id-kp-OCSPSigning': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-kp', 9]},
                                'id-kp-clientAuth': {'type': 'OBJECT '
                                                             'IDENTIFIER',
                                                     'value': ['id-kp', 2]},
                                'id-kp-codeSigning': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-kp', 3]},
                                'id-kp-emailProtection': {'type': 'OBJECT '
                                                                  'IDENTIFIER',
                                                          'value': ['id-kp',
                                                                    4]},
                                'id-kp-serverAuth': {'type': 'OBJECT '
                                                             'IDENTIFIER',
                                                     'value': ['id-kp', 1]},
                                'id-kp-timeStamping': {'type': 'OBJECT '
                                                               'IDENTIFIER',
                                                       'value': ['id-kp', 8]},
                                'id-pe-authorityInfoAccess': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['id-pe',
                                                                        1]},
                                'id-pe-subjectInfoAccess': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-pe',
                                                                      11]}}}}