# Contributing

Welcome to Emacs AutoThemer. You can contribute to the project in the following ways:

- **Bug reports:** One liner reports are difficult to understand and review.
	- Follow the bug reporting issue template and provide clear, concise descriptions and steps to reproduce the bug.
	- Ensure that you have searched the existing issues to avoid duplicates.
	- Maintainers may close unclear issues that lack enough information to reproduce a bug. [Report a bug here](https://github.com/jasonm23/autothemer/issues/new/choose).
    - Maintainers WILL close issues if they cannot be reliably and repeatedly reproduced, without loading your config.

- **Feature suggestions:** If you feel there is a nice enhancement or feature that can benefit many users, please open a feature request issue.
	- Ensure that you have searched the existing issues to avoid duplicates.
	- What makes sense for the project, what suits its scope and goals, and its future direction are at the discretion of the maintainers who put in the time, effort, and energy in building and maintaining the project for free. Please be respectful of this and keep discussions friendly and fruitful.
	- It is the responsibility of the requester to clearly explain and justify why a change is warranted. It is not the responsibility of the maintainers to coax this information out of a requester. So, please post well researched, well thought out, and detailed feature requests saving everyone time.
	- Maintainers may close unclear feature requests that lack enough information. [Suggest a feature here](https://github.com/jasonm23/autothemer/issues/new/choose).

- **Pull requests**
  This is a tricky one for many reasons. A PR, be it a new feature or a small enhancement, has to make sense to the project's overall scope, goals, and technical aspects. The quality, style, and conventions of the code have to conform to that of the project's. Performance, usability, stability and other kinds of impacts of a PR should be well understood.

  This makes reviewing PRs a difficult and time consuming task. The bigger a PR, the more difficult it is to understand. Reviewing a PR in detail, engaging in back and forth discussions to improve it, and deciding that it is meaningful and safe to merge can often require more time and effort than what has gone into creating a PR. Thus, ultimately, whether a PR gets accepted or not, for whatever reason, is at the discretion of the maintainers. Please be respectful of the fact that maintainers have a much deeper understanding of the overall project. So, nitpicking on micro aspects may not be meaningful.

  To keep the process smooth **send small PRs:** Whenever possible, send small PRs with well defined scopes. The smaller the PR, the easier it is to review and test. Bundling multiple features into a single PR is highly discouraged.

- **Be respectful**
  Remember, most FOSS projects are fruits of love and labour of maintainers who share them with the world for free with no expectations of any returns. Free as in freedom, and free as in beer too. Really, *some people just want to watch the world turn*.

### So:

- Please be respectful and refrain from using aggressive or snarky language. It wastes time, energy, cognitive bandwidth, and goodwill.
- Please refrain from demanding. How badly you want a feature has no bearing on whether it warrants a maintainer's time or attention. It is entirely up to the maintainers, if, how, and when they want to implement something.
- Please do not nitpick and generate unnecessary discussions that waste time.
- Please make sure you have searched the docs and issues before asking support questions.
- **Please remember, FOSS project maintainers owe you nothing** (unless you have an explicit agreement with them, of course) including their time in responding to your messages or providing free customer support. If you want to be heard, please be respectful and establish goodwill.
- If these are unacceptable to you 
   - You don't have to use the project 
   - You can always fork the project and change it to your liking while adhering to the terms of the license. That is the beauty of FOSS, afterall.

Thank you
