//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _spin2root_3.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root3(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[3] = {1.220402317558884e+00,3.808880721467068e+00,8.470716960974048e+00};
  constexpr double aw[3] = {3.653189471750080e-01,2.831245503433029e-01,1.622669657125762e-02};
  constexpr double x[1152] = {  4.693839072042786e-01, -2.050039192295692e-02,  4.697150842322769e-04, -1.599188764002832e-06, -3.231861806253078e-07,
  1.145401827378199e-08, -3.489143347512334e-11, -1.179542257162968e-11,  4.254072037419837e-13,  1.419247830897813e-15, -5.312272886113228e-16,  1.344736589887053e-17,
  1.191937532264912e+00, -2.865147901868704e-02, -2.323864872618429e-04,  1.506306245567615e-05,  3.280526421680721e-07, -1.301662096307454e-08, -5.249342693265764e-10,
  1.155980896451996e-11,  8.146456630329071e-13, -7.124494756311483e-15, -1.123754662005814e-15, -1.418466546214892e-18,  1.820452542596928e+00, -1.011284755213548e-02,
 -3.862257023283525e-04, -1.083435100360147e-05, -1.877088318422541e-07,  1.305989815240396e-09,  2.561763696269638e-10,  1.111179327113756e-11,  2.450667019542817e-13,
 -1.178432705487816e-15, -3.183352454811136e-16, -1.303137997115165e-17,  3.946741726115370e-01, -1.689067120626311e-02,  4.266698739803609e-04, -5.068240866298918e-06,
 -1.215201753627078e-07,  8.121757838339276e-09, -1.892459580188447e-10, -2.824505472942408e-13,  2.380220240963682e-13, -8.239027261239920e-15, -1.324008294399070e-18,
  7.534199515512832e-18,  1.074853409516341e+00, -2.972180407085449e-02, -3.052924593035839e-05,  1.770182483221550e-05, -1.890118915890470e-08, -1.931275647187870e-08,
  6.857099068213828e-11,  2.593337456828843e-11, -8.581329189896238e-14, -3.425177880488250e-14,  1.215781915301989e-16,  4.384820392251688e-17,  1.772932112946562e+00,
 -1.376901851788198e-02, -5.319897997300255e-04, -1.317456276320901e-05, -7.091217914095967e-08,  1.191539705112137e-08,  6.457401665649188e-10,  1.450933859256519e-11,
 -1.908786575146112e-13, -2.779299093592171e-14, -9.999807321119362e-16, -9.198551767306303e-18,  3.335206567192007e-01, -1.374286185740122e-02,  3.587684939328808e-04,
 -5.950472228667198e-06, -1.819008999282920e-09,  4.083881535575776e-09, -1.323198478364026e-10,  3.047808729897548e-12, -6.275322969066807e-15, -4.482019575836663e-15,
  1.332761913930641e-16, -8.479778983599410e-20,  9.567792465968303e-01, -2.914911078188068e-02,  1.682526203477101e-04,  1.462650336224116e-05, -3.359246651127077e-07,
 -1.028575433226839e-08,  5.967264497033942e-10,  7.579856290191235e-12, -8.642600148302088e-13, -2.761641679998885e-15,  1.031871262664090e-15, -9.866537414851791e-18,
  1.708347193247829e+00, -1.865243616316383e-02, -6.859842000062392e-04, -1.144951193633244e-05,  3.467804682557290e-07,  3.039861873639218e-08,  7.621560321517123e-10,
 -1.489642927421818e-11, -1.809327851268800e-12, -5.166476334682080e-14,  6.894374950850886e-16,  1.097192588836623e-16,  2.838435099584344e-01, -1.115360800973021e-02,
  2.893994911073611e-04, -5.471648658256940e-06,  5.439536558371206e-08,  1.796301119018653e-09, -6.695785376774747e-11,  1.248309150785347e-12, -7.792747457324151e-14,
  2.683685834234400e-16,  1.011040927083461e-16, -6.865221457394702e-19,  8.438433896026496e-01, -2.720283436270551e-02,  3.073182750154925e-04,  8.401413818282277e-06,
 -3.968462034149624e-07,  3.615783124639716e-09,  4.552482635508176e-10, -1.521500781570548e-11, -4.179683682091571e-13,  2.108712921989752e-14,  1.199835912945896e-16,
 -1.668518521413134e-17,  1.622092251550189e+00, -2.454414610546086e-02, -7.675160071598209e-04, -3.208887547326142e-07,  1.064361888348885e-06,  3.589366592494494e-08,
 -6.408418852527410e-10, -8.556287440068632e-11, -1.706694847876707e-12,  9.877779514765464e-14,  6.450459753781020e-15,  3.718754883971184e-17,  2.434674463461908e-01,
 -9.084052950660372e-03,  2.298854382974131e-04, -4.394036887142050e-06,  7.576103858095346e-08,  3.622654142286182e-10, -6.026695843600384e-11, -3.770230482634636e-13,
 -4.509329544155466e-15,  3.409904615514709e-15,  3.455808509296983e-17, -3.653071636148093e-18,  7.404463961703543e-01, -2.444040758033487e-02,  3.739059962525775e-04,
  3.061091728287119e-06, -2.545808884471031e-07,  8.625975852202049e-09, -4.329769584634503e-11, -1.649609169324440e-11,  3.168621899038057e-13,  1.782765711993786e-14,
 -2.141479878572524e-16, -8.484124408440601e-18,  1.512079593508824e+00, -3.036533795481974e-02, -6.505720532021497e-04,  2.074949403578463e-05,  1.422574628933662e-06,
 -9.466253673276996e-09, -2.948221221672189e-09, -4.168788075449323e-11,  5.123187752875277e-12,  1.931065239980603e-13, -6.439737322743166e-15, -5.367665969831028e-16,
  2.105046126490757e-01, -7.435250030740776e-03,  1.844072879727348e-04, -3.204897239901021e-06,  6.808813869184953e-08, -1.113894937517648e-09, -5.481426437463709e-11,
  1.296323209658923e-12,  9.039763403357106e-14,  2.477108024002902e-16, -1.940566355088465e-16, -3.201158698534722e-18,  6.488181472052895e-01, -2.135940042105245e-02,
  3.913451420741573e-04,  1.818781586945188e-07, -1.217265151242413e-07,  3.697202271486930e-09, -2.850158217668663e-10,  1.081441099954518e-12,  6.495278040246843e-13,
 -4.633459246333821e-15, -9.459146954567546e-16, -9.501700122585191e-18,  1.382281339646323e+00, -3.422677154209063e-02, -2.838652252982212e-04,  3.814473107221633e-05,
  5.444074154398318e-07, -7.204304862092963e-08, -1.350996690942166e-09,  1.479895154718565e-10,  3.545325288565686e-12, -3.060711692165200e-13, -9.260221438498388e-15,
  6.242624295928429e-16,  1.834939871907664e-01, -6.097380480760669e-03,  1.515652828438808e-04, -2.347405299621823e-06,  3.711768621721461e-08, -1.713760871518527e-09,
  1.249050267294614e-11,  2.855459971864662e-12, -2.866540543464469e-14, -5.301671491121327e-15,  3.085045976293679e-17,  1.087491947251364e-17,  5.696137644749314e-01,
 -1.824960567761333e-02,  3.831985391973183e-04, -1.497838099907887e-06, -1.031933878440708e-07, -8.416717424812711e-10, -3.892260884365197e-11,  1.245625463649674e-11,
 -8.724666092139320e-14, -2.755765685193389e-14,  3.138714375370059e-16,  5.259483275541133e-17,  1.243790732827472e+00, -3.463218414355666e-02,  1.769718980946409e-04,
  3.506272897602646e-05, -8.663946948659573e-07, -5.312737867667937e-08,  2.574571198010938e-09,  7.574550895300880e-11, -6.579248599598689e-12, -7.828451235386493e-14,
  1.535309855597265e-14, -1.892108628275553e-17,  1.613622063132612e-01, -4.989816495406636e-03,  1.259467412716984e-04, -1.988124667162383e-06,  1.113061416936998e-08,
 -7.055547144718601e-10,  5.725919980501930e-11, -1.127705915508115e-13, -1.111152657411888e-13,  1.848663735169389e-15,  1.907995628568266e-16, -5.977061519053664e-18,
  5.025916026113447e-01, -1.528506160678107e-02,  3.548859385230304e-04, -3.231557368033692e-06, -1.060106850596201e-07,  1.358363511611899e-09,  1.601595377121961e-10,
 -3.359393051133585e-13, -4.730273620237360e-13,  9.855738835057538e-15,  8.496210728930111e-16, -3.471178046613601e-17,  1.110348925609429e+00, -3.182615432504218e-02,
  4.913067956699462e-04,  1.635531378614944e-05, -1.259241080736928e-06,  1.148261709853222e-08,  2.048006412270240e-09, -8.475348888436348e-11, -1.629633461069694e-12,
  2.193766977902138e-13, -2.897181726931811e-15, -3.682412194206546e-16,  1.432704252218120e-01, -4.075263065145556e-03,  1.029161791639835e-04, -1.855376944489534e-06,
  8.832376092843382e-09,  3.275347843356933e-10,  2.113976436175287e-11, -1.774170699192782e-12,  1.308439896411957e-14,  2.958424269048572e-15, -1.044051847168341e-16,
 -2.638486848633309e-18,  4.468475111629631e-01, -1.262662318548298e-02,  3.074330140006984e-04, -4.529666399126348e-06, -4.802816249614301e-08,  3.858296988139582e-09,
  1.952709056874302e-11, -6.578756380670761e-12,  8.737180982476496e-14,  1.162255935350481e-14, -5.211805051182772e-16, -7.307098233001020e-18,  9.917044801732166e-01,
 -2.742250265871570e-02,  5.806323552932599e-04, -1.164763823264036e-07, -7.344579812313784e-07,  3.223737695633273e-08, -1.422517720308109e-10, -5.077737067710104e-11,
  2.338824876653523e-12, -2.657562363422944e-15, -4.130181443416212e-15,  1.679089814303749e-16,  1.284792027124760e-01, -3.337989315817448e-03,  8.176306988691475e-05,
 -1.649168746604775e-06,  1.698247637090551e-08,  3.536498726787200e-10, -1.278600448887271e-11, -4.986704772314927e-13,  4.346793171808488e-14, -7.877554273627517e-16,
 -4.296121071997224e-17,  2.856808644673222e-18,  4.009048529809028e-01, -1.039189171760144e-02,  2.509457458057448e-04, -4.708748254693030e-06,  2.164982634752023e-08,
  2.675401627571575e-09, -9.086745616114993e-11, -9.388028604118882e-13,  1.680425080430092e-13, -4.205958182348455e-15, -1.335497995339319e-16,  1.230538366089540e-17,
  8.910745624503414e-01, -2.293682416337971e-02,  5.284281081652404e-04, -7.236132550813169e-06, -1.987178029544550e-07,  1.933409189532074e-08, -6.787509007278406e-10,
  4.018595856691501e-12,  8.529472853466965e-13, -4.642005305680639e-14,  8.357487266380614e-16,  3.332487455190833e-17,  1.163171945686553e-01, -2.758009884671942e-03,
  6.377571453518645e-05, -1.339866390460184e-06,  2.053116840032764e-08,  3.656957480582795e-12, -1.269149726889899e-11,  3.084290448355898e-13,  7.524779381202522e-15,
 -7.795587186760316e-16,  2.234442114667044e-17,  1.574395859386036e-19,  3.630072492251074e-01, -8.601166942101592e-03,  1.978986866573876e-04, -4.052759051162876e-06,
  5.370414881277700e-08,  6.316756696925616e-10, -6.707236209825699e-11,  1.793945227191940e-12,  1.278876735506072e-14, -2.898676148604100e-15,  1.027072987554406e-16,
 -2.728319956459426e-19,  8.071877922604203e-01, -1.908679300187645e-02,  4.326112158866712e-04, -8.130697360227664e-06,  4.452930258748160e-08,  6.200754038171312e-09,
 -3.819060004638014e-10,  1.209472614424509e-11, -1.221936167533323e-13, -9.720649862964915e-15,  6.408097081134026e-16, -1.870687573134501e-17,  1.062115114757571e-01,
 -2.306619644344747e-03,  4.962571287912966e-05, -1.024178499548546e-06,  1.831065342877540e-08, -1.899745073805731e-10, -3.710749805503065e-12,  2.637579920339905e-13,
 -5.976040122447397e-15, -6.156741772706955e-17,  1.004200089845985e-17, -3.765023991324178e-19,  3.314822265596030e-01, -7.197425753938744e-03,  1.546012748739395e-04,
 -3.162948005431605e-06,  5.423573216993697e-08, -3.991848833437618e-10, -2.166137827325523e-11,  1.230307873724490e-12, -3.064970191784369e-14, -4.600810890632796e-20,
  3.472905308378140e-17, -1.548069120383846e-18,  7.371705635322759e-01, -1.599734567585362e-02,  3.420863591431436e-04, -6.819623705324226e-06,  1.011857382254183e-07,
  4.734479731227411e-10, -1.238830278089963e-10,  6.088188396635409e-12, -1.824117980007578e-13,  2.591583790845650e-15,  7.137321909708450e-17, -6.356815117951905e-18,
  9.770783101182230e-02, -1.954103346788049e-03,  3.895824792350577e-05, -7.643253584473595e-07,  1.410618974054110e-08, -2.120062555661881e-10,  1.053631523125487e-12,
  8.723954800134593e-14, -4.176536510720204e-15,  9.512641391098398e-17, -6.039686129949053e-20, -9.343995038743473e-20,  3.049456168013880e-01, -6.098424941109330e-03,
  1.215249182267563e-04, -2.377502633178951e-06,  4.329651535001217e-08, -6.097450478950341e-10,  3.217669062607388e-13,  4.099514317261269e-13, -1.819174821138463e-14,
  4.463249989858488e-16, -3.028291346447978e-18, -2.918345812028350e-19,  6.781750515977722e-01, -1.356056037353869e-02,  2.698863330065397e-04, -5.239139763155802e-06,
  9.172504557396861e-08, -1.018215335908902e-09, -1.952725853126142e-11,  1.910844470197254e-12, -8.118704334906587e-14,  2.337810210293853e-15, -4.016073488864667e-17,
 -2.116815933509991e-19,  9.046166789932519e-02, -1.675598263436877e-03,  3.100676525664492e-05, -5.705754114493495e-07,  1.025163600655221e-08, -1.695042017334859e-10,
  2.104863577016384e-12,  2.782383911234029e-15, -1.361792220746269e-15,  5.420096957984513e-17, -1.253205040758041e-18,  9.995863220393110e-21,  2.823310515319425e-01,
 -5.229477961120998e-03,  9.675848579555568e-05, -1.779000350340972e-06,  3.182720453902269e-08, -5.164653907456413e-10,  5.807540889683171e-12,  4.698940608712722e-14,
 -5.861028908747824e-15,  2.255648852536788e-16, -5.511146518036287e-18,  6.472572843084423e-20,  6.278858785804807e-01, -1.162964033818639e-02,  2.151066991712003e-04,
 -3.946120245085158e-06,  6.978055939509695e-08, -1.071626208009980e-09,  8.080769262695102e-12,  3.583740384124043e-13, -2.431816789667909e-14,  9.274292177550639e-16,
 -2.575476570116770e-17,  4.895657527716715e-19,  8.421563857792061e-02, -1.452383288020419e-03,  2.504093859252619e-05, -4.309673627627582e-07,  7.354059378351410e-09,
 -1.214921167233846e-10,  1.803648147763947e-12, -1.808164836264459e-14, -1.644926640594269e-16,  1.682236328522717e-17, -5.967493420775312e-19,  1.389257571856004e-20,
  2.628373212678206e-01, -4.532879954123831e-03,  7.815004335057052e-05, -1.344678111712393e-06,  2.291553508834156e-08, -3.763553630582218e-10,  5.450685936602355e-12,
 -4.697270340926038e-14, -9.394765625672449e-16,  6.891973909783780e-17, -2.402169152579982e-18,  5.823096820076775e-20,  5.845338680987894e-01, -1.008076892233218e-02,
  1.737852997437487e-04, -2.988391319381006e-06,  5.075396344623141e-08, -8.204851335568866e-10,  1.104973192170570e-11, -4.580441035101057e-14, -4.836046978027026e-15,
  2.644217024615362e-16, -9.241590935840029e-18,  2.473831774268273e-19,  7.877660559121470e-02, -1.270912173579204e-03,  2.050227043827024e-05, -3.305662677485455e-07,
  5.314871194987919e-09, -8.445317339735392e-11,  1.288032530910097e-12, -1.722161018843495e-14,  1.352635405626614e-16,  2.607429693765221e-18, -1.748233174520971e-19,
  5.698534592777124e-21,  2.458621072241928e-01, -3.966519396864807e-03,  6.398711019098499e-05, -1.031623268609809e-06,  1.658017567690761e-08, -2.629787207854622e-10,
  3.980797670676057e-12, -5.159429908461792e-14,  3.205391409907404e-16,  1.229092413483953e-17, -6.934553475640930e-19,  2.235970240449773e-20,  5.467821988780951e-01,
 -8.821280871414493e-03,  1.423003917992623e-04, -2.293856043878666e-06,  3.683146203858698e-08, -5.814675462169171e-10,  8.627737580539246e-12, -1.020410611609156e-13,
  9.628763878181914e-17,  5.342460599795135e-17, -2.511965028149822e-18,  8.146412650202406e-20,  7.399775465300155e-02, -1.121433778152590e-03,  1.699497925764095e-05,
 -2.575156711455091e-07,  3.898630753845161e-09, -5.878896009545158e-11,  8.732704602927746e-13, -1.234739538802877e-14,  1.493243286231844e-16, -8.849952120917298e-19,
 -2.953276193396053e-20,  1.576190781288516e-21,  2.309472994356996e-01, -3.499998967292612e-03,  5.304129315387316e-05, -8.036927331242335e-07,  1.216613673171361e-08,
 -1.833584839537488e-10,  2.717314802306446e-12, -3.807404034774968e-14,  4.434933127131918e-16, -1.802137129467928e-18, -1.281319826556369e-19,  6.108815291768579e-21,
  5.136126129195061e-01, -7.783780141826496e-03,  1.179600135873911e-04, -1.787284920525607e-06,  2.704863008737374e-08, -4.071105332664503e-10,  5.997745057911907e-12,
 -8.205484832562797e-14,  8.556524972940892e-16,  1.700782545288228e-18, -5.055688110867775e-19,  2.116671679704651e-20,  6.976575593182865e-02, -9.968567752389190e-04,
  1.424364900023594e-05, -2.035133355350286e-07,  2.907077468853174e-09, -4.147410792765649e-11,  5.886437920524654e-13, -8.204398839627307e-15,  1.080233853946195e-16,
 -1.188532534802606e-18,  5.081722750219097e-21,  2.736583949829656e-22,  2.177392148957867e-01, -3.111194053705639e-03,  4.445446768270600e-05, -6.351631657070838e-07,
  9.072710209154398e-09, -1.294168819758876e-10,  1.835524053609456e-12, -2.551127594087504e-14,  3.324013169249035e-16, -3.501400647003475e-18,  7.779446089937494e-21,
  1.133564598510377e-21,  4.842386492874163e-01, -6.919104130042954e-03,  9.886390353313590e-05, -1.412549307274573e-06,  2.017562045477993e-08, -2.876873814861728e-10,
  4.073253024672861e-12, -5.621574630793669e-14,  7.127560104162072e-16, -6.600863891884316e-18, -2.987231509837331e-20,  4.198613791168509e-21,  6.599179924618020e-02,
 -8.919439128628760e-04,  1.205548436504752e-05, -1.629399291278224e-07,  2.202119725667484e-09, -2.975043353368685e-11,  4.012567334084224e-13, -5.377791410322399e-15,
  7.058222410187848e-17, -8.694339658383141e-19,  8.768252410235011e-21, -2.585500017042366e-23,  2.059606805496988e-01, -2.783760653135645e-03,  3.762521325914354e-05,
 -5.085356783271719e-07,  6.872770221170711e-09, -9.284665449918203e-11,  1.252006956830940e-12, -1.676542220881514e-14,  2.193324001062207e-16, -2.670594220348708e-18,
  2.565229032074849e-20, -1.947858890354712e-23,  4.580439128318756e-01, -6.190912754498666e-03,  8.367614630647293e-05, -1.130949479992202e-06,  1.528433717363561e-08,
 -2.064614054369347e-10,  2.782713534884939e-12, -3.718535137983583e-14,  4.826010663329326e-16, -5.702619321896825e-18,  4.742401233270980e-20,  3.079826120172864e-22,
  6.260531789713018e-02, -8.027642359296319e-04,  1.029353873660965e-05, -1.319897961115134e-07,  1.692420714744516e-09, -2.169856605540142e-11,  2.780571164096132e-13,
 -3.555781076983674e-15,  4.513706613328788e-17, -5.597938035838087e-19,  6.482348154559112e-21, -6.047969595377424e-23,  1.953914581766571e-01, -2.505430524225533e-03,
  3.212617664841165e-05, -4.119406095818266e-07,  5.282042075143308e-09, -6.772046488506242e-11,  8.677576684114196e-13, -1.109403123875352e-14,  1.406870840887546e-16,
 -1.738605451163342e-18,  1.988405802657282e-20, -1.760338600381616e-22,  4.345386111276453e-01, -5.571923703617445e-03,  7.144664184617320e-05, -9.161301583122370e-07,
  1.174688647529909e-08, -1.506018024794757e-10,  1.929530683747315e-12, -2.465374013172616e-14,  3.118954394509731e-16, -3.820877160306646e-18,  4.232893851643537e-20,
 -3.210006047958877e-22,  5.954953553011499e-02, -7.263218808480587e-04,  8.858901120511071e-06, -1.080513852708842e-07,  1.317889203239397e-09, -1.607367955770115e-11,
  1.960145700565937e-13, -2.388810009570536e-15,  2.904068868062293e-17, -3.501413447595225e-19,  4.117116743804315e-21, -4.503684330127615e-23,  1.858543486749330e-01,
 -2.266853617909786e-03,  2.764866721577119e-05, -3.372288071101974e-07,  4.113135891933520e-09, -5.016586619440297e-11,  6.117512896259669e-13, -7.454819073867923e-15,
  9.060095169379796e-17, -1.091156867695101e-18,  1.278160844995928e-20, -1.380221474386211e-22,  4.133286649521161e-01, -5.041343319226318e-03,  6.148893841694390e-05,
 -7.499760865878658e-07,  9.147352752518826e-09, -1.115650275526733e-10,  1.360441387170576e-12, -1.657563717214033e-14,  2.013086529915532e-16, -2.418088349271580e-18,
  2.806482108882894e-20, -2.932878031714327e-22,  5.677825433993711e-02, -6.603015495888405e-04,  7.678963303706841e-06, -8.930233467332104e-08,  1.038538422508029e-09,
 -1.207755961666076e-11,  1.404489050699947e-13, -1.632958110770235e-15,  1.897118363238402e-17, -2.197866810094173e-19,  2.523576773201508e-21, -2.822091438765709e-23,
  1.772051685269073e-01, -2.060803889243055e-03,  2.396607646716350e-05, -2.787129559012395e-07,  3.241282427151237e-09, -3.769408628748486e-11,  4.383396337373630e-13,
 -5.096347427546409e-15,  5.920265283644372e-17, -6.856491693535151e-19,  7.863199333729379e-21, -8.758792502674450e-23,  3.940934191372119e-01, -4.583101370881102e-03,
  5.329908308584068e-05, -6.198404939049100e-07,  7.208411611838736e-09, -8.382919711700601e-11,  9.748305028122783e-13, -1.133334966497593e-14,  1.316300045072255e-16,
 -1.523267987801519e-18,  1.742025349559229e-20, -1.922153915365309e-22,  5.425350058270404e-02, -6.028911132532455e-04,  6.699617346163412e-06, -7.444938289000586e-08,
  8.273172832273965e-10, -9.193530307055332e-12,  1.021616524368518e-13, -1.135194460058164e-15,  1.261104976347175e-17, -1.399726757880934e-19,  1.548837573163937e-21,
 -1.697530656041249e-23,  1.693254015240298e-01, -1.881625678151264e-03,  2.090953366735131e-05, -2.323568338995551e-07,  2.582060634694130e-09, -2.869304156562103e-11,
  3.188465914834512e-13, -3.542924877314678e-15,  3.935796549400139e-17, -4.367993584392777e-19,  4.831541512365201e-21, -5.288811244083799e-23,  3.765693009310494e-01,
 -4.184620026557629e-03,  4.650151957216569e-05, -5.167473356093325e-07,  5.742344110182276e-09, -6.381153961756609e-11,  7.090935122301125e-13, -7.879139136435156e-15,
  8.752381372398096e-17, -9.711319926104916e-19,  1.073286905992746e-20, -1.171462931096002e-22,  5.194377214871878e-02, -5.526558737309705e-04,  5.879983335630161e-06,
 -6.256009473983705e-08,  6.656082180221010e-10, -7.081736527914410e-12,  7.534590880932495e-14, -8.016287661663410e-16,  8.528207589189481e-18, -9.070334966464712e-20,
  9.637326893104999e-22, -1.020534747262683e-23,  1.621167294513751e-01, -1.724841286164219e-03,  1.835145250600497e-05, -1.952503164349498e-07,  2.077366014072884e-09,
 -2.210212838988785e-11,  2.351548341726385e-13, -2.501882891955750e-15,  2.661636311796750e-17, -2.830755022471028e-19,  3.007381219980836e-21, -3.183408786511829e-23,
  3.605376566616001e-01, -3.835941161219090e-03,  4.081250408134766e-05, -4.342247201765967e-07,  4.619934474257057e-09, -4.915377297661772e-11,  5.229696191616853e-13,
 -5.564015177075425e-15,  5.919212703869739e-17, -6.294925440156535e-19,  6.686058264601833e-21, -7.071171308815498e-23,  4.982271598214868e-02, -5.084480078286799e-04,
  5.188785306946741e-06, -5.295230291565794e-08,  5.403858865947813e-10, -5.514715333142788e-12,  5.627842166755795e-14, -5.743267899536997e-16,  5.860952272428557e-18,
 -5.980568780748251e-20,  6.100741584815227e-22, -6.216023123291244e-24,  1.554969043119485e-01, -1.586868352364458e-03,  1.619422057708857e-05, -1.652643581652695e-07,
  1.686546603530957e-09, -1.721144940425862e-11,  1.756451781123422e-13, -1.792475642184909e-15,  1.829202007747010e-17, -1.866520333462467e-19,  1.903967061342669e-21,
 -1.939720804016598e-23,  3.458155718320382e-01, -3.529097824313287e-03,  3.601495267025612e-05, -3.675377896708788e-07,  3.750776129548238e-09, -3.827720646092042e-11,
  3.906240451449966e-13, -3.986352590778960e-15,  4.068015199600459e-17, -4.150939671233902e-19,  4.233924672636625e-21, -4.312309429855055e-23,  4.786811716666511e-02,
 -4.693403822085494e-04,  4.601818651036118e-06, -4.512020634537694e-08,  4.423974887784344e-10, -4.337647129691842e-12,  4.253003252515676e-14, -4.170007102187144e-16,
  4.088610366901610e-18, -4.008712015002717e-20,  3.930013866308497e-22, -3.851193461537317e-24,  1.493965932592883e-01, -1.464813289748429e-03,  1.436229519676655e-05,
 -1.408203521264052e-07,  1.380724406744029e-09, -1.353781475296698e-11,  1.327364070416781e-13, -1.301460841669942e-15,  1.276056373079652e-17, -1.251117622846114e-19,
  1.226545503458620e-21, -1.201905667085282e-23,  3.322488544471299e-01, -3.257654855978700e-03,  3.194086305611805e-05, -3.131758205081795e-07,  3.070646339693939e-09,
 -3.010726903462791e-11,  2.951976141942818e-13, -2.894368490301525e-15,  2.837868023449759e-17, -2.782393876911332e-19,  2.727696014890967e-21, -2.672701231569783e-23,
  4.606111721962528e-02, -4.345775223821609e-04,  4.100152891616484e-06, -3.868413083489498e-08,  3.649771160077641e-10, -3.443486816073800e-12,  3.248861499709327e-14,
 -3.065235652717310e-16,  2.891984651852253e-18, -2.728509282432524e-20,  2.574206968523277e-22, -2.428167894255513e-24,  1.437569388904414e-01, -1.356318259289487e-03,
  1.279659426997820e-05, -1.207333336255614e-07,  1.139095100756531e-09, -1.074713670624312e-11,  1.013971025628629e-13, -9.566613060368244e-16,  9.025895089379165e-18,
 -8.515683591413531e-20,  8.034087458015193e-22, -7.578229266332736e-24,  3.197066092549991e-01, -3.016368566936066e-03,  2.845884028723476e-05, -2.685035241785680e-07,
  2.533277593846583e-09, -2.390097242829626e-11,  2.255009315929155e-13, -2.127555939580545e-15,  2.007303161632608e-17, -1.893833235689548e-19,  1.786720495676138e-21,
 -1.685306450568917e-23,  4.438560316280251e-02, -4.035388363719278e-04,  3.668838110929814e-06, -3.335583064342808e-08,  3.032598888629684e-10, -2.757135958404375e-12,
  2.506694392062406e-14, -2.279001295387120e-16,  2.071989809989886e-18, -1.883779024871242e-20,  1.712652043321004e-22, -1.556895997316575e-24,  1.385276525331813e-01,
 -1.259446390838344e-03,  1.145045904112636e-05, -1.041036865124293e-07,  9.464753775506898e-10, -8.605032821157532e-12,  7.823403644061671e-14, -7.112772512893271e-16,
  6.466688656494943e-18, -5.879281301547859e-20,  5.345190212759724e-22, -4.859062976964286e-24,  3.080769973349987e-01, -2.800931476846752e-03,  2.546511815503654e-05,
 -2.315202096168348e-07,  2.104903151323079e-09, -1.913706487186648e-11,  1.739876953266781e-13, -1.581836938242323e-15,  1.438151783725409e-17, -1.307515653872413e-19,
  1.188735601065235e-21, -1.080618108466742e-23,  4.282772536545900e-02, -3.757107133956497e-04,  3.295961645305950e-06, -2.891416927966424e-08,  2.536525830944484e-10,
 -2.225193892746405e-12,  1.952074680394470e-14, -1.712477964278562e-16,  1.502289116998453e-18, -1.317898218353794e-20,  1.156137190054312e-22, -1.014144529602299e-24,
  1.336655094322305e-01, -1.172594703002342e-03,  1.028671003723729e-05, -9.024124287704123e-08,  7.916507694198654e-10, -6.944839416911941e-12,  6.092433215696572e-14,
 -5.344650861227538e-16,  4.688650567939366e-18, -4.113165685472054e-20,  3.608308324658225e-22, -3.165146608229553e-24,  2.972638894842380e-01, -2.607778653473944e-03,
  2.287701179350255e-05, -2.006909857558661e-07,  1.760582724966113e-09, -1.544489663500469e-11,  1.354919755512337e-13, -1.188617547153911e-15,  1.042727096426740e-17,
 -9.147427341149567e-20,  8.024653093983669e-22, -7.039078918343490e-24,  4.137551356354668e-02, -3.506651314864860e-04,  2.971951858714065e-06, -2.518784178246933e-08,
  2.134716185914272e-10, -1.809211457467753e-12,  1.533340177979838e-14, -1.299534161475870e-16,  1.101379217373889e-18, -9.334391441295120e-21,  7.911064374857202e-23,
 -6.704272462349288e-25,  1.291331503435860e-01, -1.094427337438375e-03,  9.275474142352267e-06, -7.861135922169295e-08,  6.662458116757758e-10, -5.646556502095373e-12,
  4.785561088473959e-14, -4.055851535392084e-16,  3.437409124603461e-18, -2.913267436045697e-20,  2.469046378883243e-22, -2.092405778916634e-24,  2.871842010369143e-01,
 -2.433939229848645e-03,  2.062808522615971e-05, -1.748268382707202e-07,  1.481689795463768e-09, -1.255759511278637e-11,  1.064279415447414e-13, -9.019964889655372e-16,
  7.644586904910591e-18, -6.478927864974487e-20,  5.491007089670903e-22, -4.653379893948751e-24,  4.001856849528641e-02, -3.280430947032107e-04,  2.689058505306963e-06,
 -2.204294424031474e-08,  1.806920116547145e-10, -1.481181584435116e-12,  1.214164846458170e-14, -9.952839603658213e-17,  8.158613390227991e-19, -6.687837183403820e-21,
  5.482201213499255e-23, -4.493604151663129e-25,  1.248981191278763e-01, -1.023823866317075e-03,  8.392562806868443e-06, -6.879612088024163e-08,  5.639405217546213e-10,
 -4.622773900682320e-12,  3.789413548133183e-14, -3.106285389913009e-16,  2.546306639949767e-18, -2.087276769323600e-20,  1.710997266174617e-22, -1.402455654343808e-24,
  2.777657515310056e-01, -2.276921443242695e-03,  1.866454460322357e-05, -1.529983505928796e-07,  1.254169109492858e-09, -1.028076544022740e-11,  8.427423162142711e-14,
 -6.908188063530389e-16,  5.662829688264102e-18, -4.641975412995523e-20,  3.805152824641240e-22, -3.118974949520256e-24,  3.874781233032627e-02, -3.075416927870888e-04,
  2.440960846925616e-06, -1.937392553909320e-08,  1.537710001645477e-10, -1.220481643941605e-12,  9.686972456286777e-15, -7.688557695291247e-17,  6.102414313798600e-19,
 -4.843491030539571e-21,  3.844282494586146e-23, -3.051017263374038e-25,  1.209320838387237e-01, -9.598389054579710e-04,  7.618248980637743e-06, -6.046610238547833e-08,
  4.799199326489230e-10, -3.809128299437819e-12,  3.023308142506033e-14, -2.399602062357474e-16,  1.904566051556495e-18, -1.511655569423866e-20,  1.199802166404153e-22,
 -9.522237476716402e-25,  2.689455324565930e-01, -2.134622817260070e-03,  1.694251817587912e-05, -1.344729007012283e-07,  1.067312475942498e-09, -8.471267559184192e-12,
  6.723651758527864e-14, -5.336567715086343e-16,  4.235638008558256e-18, -3.361829208047673e-20,  2.668286368319663e-22, -2.117687116172438e-24  };
  constexpr double w[1152] = {  3.012101073384943e-02, -6.052359451558529e-03,  7.426687986104492e-04, -6.978764236365288e-05,  5.457720545869924e-06,
 -3.704720502602437e-07,  2.237673528850591e-08, -1.222180501446204e-09,  6.103622807883709e-11, -2.809204053675357e-12,  1.198494696121926e-13, -4.754262962969435e-15,
  1.051655390915495e-01, -3.127841303320419e-02,  5.300540667484792e-03, -6.469781088625642e-04,  6.255626507569962e-05, -5.042780913136892e-06,  3.498541454967330e-07,
 -2.134589088326856e-08,  1.163486968574590e-09, -5.733213381454270e-11,  2.578005147784063e-12, -1.064399287984013e-13,  9.110161720547162e-02, -3.446896442601898e-02,
  7.057016646296766e-03, -9.970999262261821e-04,  1.080014782691811e-04, -9.508564572609320e-06,  7.062837452303955e-07, -4.541828306432846e-08,  2.576889535946070e-09,
 -1.308809622166577e-10,  6.019522052687203e-12, -2.527010720415326e-13,  1.402739356581208e-02, -2.394842191280807e-03,  2.548522672466765e-04, -2.116201765641728e-05,
  1.485229502717652e-06, -9.167918266279583e-08,  5.093983142217457e-09, -2.585810559951969e-10,  1.211594113308010e-11, -5.278539937885406e-13,  2.149516901634645e-14,
 -8.203237802180827e-16,  3.239626112906834e-02, -8.383808565599242e-03,  1.276732256343425e-03, -1.431248392944335e-04,  1.291353395474711e-05, -9.833172629112907e-07,
  6.506753229421657e-08, -3.816373139804222e-09,  2.012576151365414e-10, -9.646468547854019e-12,  4.238353043715040e-13, -1.716558033726904e-14,  1.832633623184340e-02,
 -6.585804632650431e-03,  1.294445638884949e-03, -1.770774394950140e-04,  1.868585573004770e-05, -1.610108617877259e-06,  1.174596944401560e-07, -7.438356303330563e-09,
  4.164774945614861e-10, -2.090934752882693e-11,  9.518310138714901e-13, -3.959049087783670e-14,  7.346478036776285e-03, -1.073669561793101e-03,  9.927518796069994e-05,
 -7.275891652831086e-06,  4.567196829158214e-07, -2.550057502103365e-08,  1.295095324142833e-09, -6.064336125912372e-11,  2.642768384424256e-12, -1.079481559753549e-13,
  4.153163372977957e-15, -1.508653854807744e-16,  1.192385076767068e-02, -2.609471890352623e-03,  3.499362252709181e-04, -3.542583014712275e-05,  2.939248976547613e-06,
 -2.087086779004446e-07,  1.302310893146265e-08, -7.269430891374829e-10,  3.676456678009932e-11, -1.700797629514983e-12,  7.251596035538197e-14, -2.863317791016952e-15,
  4.112103856304562e-03, -1.365738399681641e-03,  2.533064989707322e-04, -3.314063661978156e-05,  3.376151901608159e-06, -2.827583353305876e-07,  2.015017747680004e-08,
 -1.251280530621782e-09,  6.890384503333232e-11, -3.410205974758820e-12,  1.533189807769356e-13, -6.307795953920071e-15,  4.222515956052269e-03, -5.345710972086000e-04,
  4.320444212567476e-05, -2.801893990280550e-06,  1.574752219493486e-07, -7.938684587579499e-09,  3.672746092001323e-10, -1.580727348074103e-11,  6.373373910906900e-13,
 -2.424259018221938e-14,  8.748963270030371e-16, -2.999361162021695e-17,  5.209274721071749e-03, -9.445218437446850e-04,  1.098444671020094e-04, -9.905257655356554e-06,
  7.460198390213850e-07, -4.881397066940843e-08,  2.840508897811000e-09, -1.493411268083434e-10,  7.175609608257998e-12, -3.177088324435517e-13,  1.304562160704776e-14,
 -4.988065181294583e-16,  1.073051149901990e-03, -3.157555479717788e-04,  5.396895760178224e-05, -6.640783741932349e-06,  6.450428755647827e-07, -5.201708529290952e-08,
  3.594734581195303e-09, -2.176345443258493e-10,  1.173260186668203e-11, -5.703019032381932e-13,  2.524662607463474e-14, -1.024889261380860e-15,  2.610294148784040e-03,
 -2.901569797906074e-04,  2.068124600100986e-05, -1.190954577935159e-06,  6.019552545643091e-08, -2.747094774508887e-09,  1.154526174709272e-10, -4.560760227232566e-12,
  1.701836015587771e-13, -5.993845708155230e-15,  2.017769273241751e-16, -6.522417291502485e-18,  2.648064664591370e-03, -3.939773388548048e-04,  3.938225067550610e-05,
 -3.136951739970820e-06,  2.123596459867086e-07, -1.268005391487757e-08,  6.818526490965653e-10, -3.344725013748774e-11,  1.512516698320031e-12, -6.355643939295951e-14,
  2.493614326561500e-15, -9.162794876930901e-17,  3.410071817442049e-04, -8.378145680963552e-05,  1.281386533377431e-05, -1.452476887046325e-06,  1.323580832572487e-07,
 -1.015144055819222e-08,  6.738449230249311e-10, -3.947127939949059e-11,  2.070539557577174e-12, -9.836854552404178e-14,  4.270549800583909e-15, -1.704943262489297e-16,
  1.708677578684575e-03, -1.688751679910998e-04,  1.074652258481490e-05, -5.512573100828776e-07,  2.511843875605026e-08, -1.048272730717175e-09,  4.008213087788339e-11,
 -1.437822218579603e-12,  4.998360842116640e-14, -1.651091790552458e-15,  5.050846275760967e-17, -1.521540558299839e-18,  1.525732899604635e-03, -1.864863788825972e-04,
  1.595562039473996e-05, -1.120482241736818e-06,  6.783517996526724e-08, -3.665769184342937e-09,  1.809578858582369e-10, -8.235129687331437e-12,  3.474391825693994e-13,
 -1.372560793685551e-14,  5.115950187603875e-16, -1.795160812194859e-17,  1.364278210735376e-04, -2.614461297831134e-05,  3.461847330753314e-06, -3.540244986186527e-07,
  2.969526995037440e-08, -2.132529832466275e-09,  1.344113905771636e-10, -7.545803844952835e-12,  3.819817565858718e-13, -1.762617819017852e-14,  7.469374046627519e-16,
 -2.918972067037013e-17,  1.171128625713006e-03, -1.038417571723241e-04,  5.989379096277012e-06, -2.758432374062217e-07,  1.125486033111085e-08, -4.322870988910622e-10,
  1.545974540958327e-11, -4.990816187489844e-13,  1.535530024698515e-14, -4.967333719745089e-16,  1.535653320526311e-17, -3.705545433871734e-19,  9.701693638311566e-04,
 -9.852648743838680e-05,  7.196724882953833e-06, -4.461813197629987e-07,  2.424122350360245e-08, -1.179518733271787e-09,  5.292026593049747e-11, -2.229990389557798e-12,
  8.794742593063814e-14, -3.229523946978127e-15,  1.123194401156893e-16, -3.778532751552700e-18,  6.855751883990447e-05, -9.745343916800680e-06,  1.075051540991937e-06,
 -9.770545264762070e-08,  7.429637024353736e-09, -4.898989514144790e-10,  2.887650989740112e-11, -1.540445890020638e-12,  7.460035078391508e-14, -3.305527327442656e-15,
  1.357848439038772e-16, -5.194616719915665e-18,  8.342234627591688e-04, -6.665213384606087e-05,  3.528753575099844e-06, -1.486997468527779e-07,  5.417582234612105e-09,
 -1.863909247595636e-10,  6.363669663027520e-12, -2.018922079380207e-13,  5.365425547533365e-15, -1.301183543035226e-16,  4.338007254708686e-18, -1.667724540209581e-19,
  6.647053313031575e-04, -5.720646457249031e-05,  3.568036199208877e-06, -1.946693482020204e-07,  9.573349631400644e-09, -4.236130233826939e-10,  1.710737231139057e-11,
 -6.536513922109717e-13,  2.421622307238688e-14, -8.518697178050757e-16,  2.738331338802275e-17, -8.171184601255330e-19,  4.146078079972052e-05, -4.371000471031772e-06,
  3.836172354918932e-07, -3.048407141380732e-08,  2.103517353372381e-09, -1.259249181660016e-10,  6.763847629977511e-12, -3.368200108152181e-13,  1.562937245399407e-14,
 -6.652787666080364e-16,  2.586426798583876e-17, -9.425602169647641e-19,  6.145384019052646e-04, -4.432379993957270e-05,  2.163793361176682e-06, -8.516184132257820e-08,
  2.844430805566202e-09, -8.552851318152490e-11,  2.580508029848562e-12, -8.302172583408516e-14,  2.490193203507891e-15, -5.381502660455751e-17,  6.181690174013223e-19,
 -1.573396734252473e-20,  4.811516938694910e-04, -3.592687267414785e-05,  1.929847739498554e-06, -9.191351656957262e-08,  4.079532268736659e-09, -1.673015479975242e-10,
  6.225722580631955e-12, -2.121104628711033e-13,  6.963376855712015e-15, -2.326340159773440e-16,  7.693505719373136e-18, -2.258209761944636e-19,  2.841000490527081e-05,
 -2.339840371515403e-06,  1.583903637425940e-07, -1.057185814537365e-08,  6.633701642862122e-10, -3.683106731945921e-11,  1.796583611837185e-12, -7.994260269630732e-14,
  3.414140210605775e-15, -1.419903574039416e-16,  5.520038696676831e-18, -1.902711909625062e-19,  4.663359083816026e-04, -3.043901842080286e-05,  1.367551386638102e-06,
 -5.062027238497189e-08,  1.604401559430744e-09, -4.412056011169048e-11,  1.111428575013849e-12, -2.995915545914801e-14,  9.638838018331628e-16, -3.034777024564943e-17,
  6.388812175513501e-19, -5.779515837441905e-22,  3.626236752263678e-04, -2.400033586408654e-05,  1.129791640559554e-06, -4.693876000445492e-08,  1.850301079426928e-09,
 -6.999649046816998e-11,  2.477347201129338e-12, -7.947887593941283e-14,  2.301435165519776e-15, -6.384747777305177e-17,  1.912003722666251e-18, -6.319369467894300e-20,
  2.097779094377536e-05, -1.443540764411532e-06,  7.684009900243719e-08, -4.095337402869204e-09,  2.248436641263354e-10, -1.175831555202890e-11,  5.478309936041936e-13,
 -2.235979574419317e-14,  8.266439490974651e-16, -2.988853056355351e-17,  1.125478126461862e-18, -4.247045121631479e-20,  3.631515799937166e-04, -2.155083145702776e-05,
  8.890526209914857e-07, -3.079358263131445e-08,  9.351372637075239e-10, -2.486699530822307e-11,  5.735970705439723e-13, -1.199569152186771e-14,  2.840125688262797e-16,
 -9.503086204792496e-18,  3.424210426444099e-19, -8.872543373286788e-21,  2.817243815246657e-04, -1.680041744150801e-05,  7.066644672234653e-07, -2.593274688458419e-08,
  9.002376068527551e-10, -3.062798292154572e-11,  1.017935600785752e-12, -3.194567064891741e-14,  9.061526522032020e-16, -2.258233544373148e-17,  5.111343525165676e-19,
 -1.260401611503843e-20,  1.618937511504407e-05, -9.783450570784262e-07,  4.335966610113007e-08, -1.834158213539693e-09,  8.256882264858915e-11, -3.889602073684328e-12,
  1.759655148151542e-13, -7.128992078743575e-15,  2.509626981838137e-16, -7.768120395376498e-18,  2.283154548962924e-19, -7.340067785381332e-21,  2.891475489020088e-04,
 -1.569558697334401e-05,  5.950386817260916e-07, -1.916111792112816e-08,  5.525082229885286e-10, -1.434323337048555e-11,  3.283577974540014e-13, -6.415551592929640e-15,
  1.078521377317960e-16, -2.068508768453609e-18,  7.312158712835220e-20, -3.167750143490890e-21,  2.241520398320458e-04, -1.218623964677395e-05,  4.652720066025209e-07,
 -1.535561958676296e-08,  4.737185948522224e-10, -1.428650226988502e-11,  4.303681527896017e-13, -1.283546420499451e-14,  3.651112292826231e-16, -9.405821400406028e-18,
  2.079909145267696e-19, -3.808057264990025e-21,  1.285579958780986e-05, -7.017505399372823e-07,  2.730021212350219e-08, -9.602673943140242e-10,  3.462241701588390e-11,
 -1.361980900518880e-12,  5.651692390858882e-14, -2.271722378280404e-15,  8.245487722415484e-17, -2.594095319757173e-18,  6.952884301171062e-20, -1.629505045348331e-21,
  2.346161596798038e-04, -1.172402611634660e-05,  4.099149073525111e-07, -1.224251171590777e-08,  3.316784297283347e-10, -8.282241334451991e-12,  1.886606517257730e-13,
 -3.790402290243475e-15,  6.323453904545691e-17, -8.097632832010827e-19,  9.790478751306684e-21, -3.758303527388741e-22,  1.818416375847461e-04, -9.090873824995265e-06,
  3.185859250965640e-07, -9.602705065834270e-09,  2.678470423410201e-10, -7.212864010544643e-12,  1.934157586195771e-13, -5.246733437468741e-15,  1.425264592146782e-16,
 -3.736163924009033e-18,  8.952596756258256e-20, -1.832115465209595e-21,  1.042368035803962e-05, -5.217046943159288e-07,  1.839231912761817e-08, -5.677310005267348e-10,
  1.702952009199760e-11, -5.407880822303397e-13,  1.895456355930427e-14, -7.049359194719166e-16,  2.564559577665945e-17, -8.525620942615154e-19,  2.474367885384842e-20,
 -6.043580003260625e-22,  1.934608432584345e-04, -8.953285132777602e-06,  2.900871183457913e-07, -8.047095796986356e-09,  2.037909842197534e-10, -4.824079943153819e-12,
  1.068945880742781e-13, -2.177004449020714e-15,  3.901816113742806e-17, -5.620172391720744e-19,  5.096891525261099e-21, -1.192682595062791e-24,  1.499359110754967e-04,
 -6.939801995384855e-06,  2.250060836316002e-07, -6.261050308886868e-09,  1.603247507703850e-10, -3.921466023728172e-12,  9.426428986785518e-14, -2.282108787648497e-15,
  5.639837340255802e-17, -1.409803710788825e-18,  3.443970172906929e-20, -7.801909224921339e-22,  8.593615182596147e-06, -3.978742385210480e-07,  1.292252990957973e-08,
 -3.624158286323964e-10,  9.544195477128524e-12, -2.526528808653016e-13,  7.196288565519132e-15, -2.275106349307011e-16,  7.672378953416431e-18, -2.557565477808537e-19,
  7.899088928987613e-21, -2.158772546709874e-22,  1.617471322880403e-04, -6.969938001328000e-06,  2.103025208837901e-07, -5.437314646867758e-09,  1.286815919791234e-10,
 -2.866285791640030e-12,  6.065636503520377e-14, -1.213049406547404e-15,  2.241191943397234e-17, -3.637010214476305e-19,  4.599096540318528e-21, -2.715033433031773e-23,
  1.253555567553448e-04, -5.401932223805853e-06,  1.630229863166290e-07, -4.218943830943082e-09,  1.002279004212304e-10, -2.260813172745517e-12,  4.956497439067318e-14,
 -1.079380286709826e-15,  2.384653425719722e-17, -5.413551531101666e-19,  1.253940945353129e-20, -2.872888711091802e-22,  7.184559481898137e-06, -3.096260510068857e-07,
  9.348511859593448e-09, -2.425066972748605e-10,  5.816193127534694e-12, -1.353607771117719e-13,  3.224264703032855e-15, -8.330808307652322e-17,  2.395568643202607e-18,
 -7.384719975261393e-20,  2.273941590227540e-21, -6.575734270177649e-23,  1.368632382768142e-04, -5.517402331411413e-06,  1.557442839253935e-07, -3.768152181672678e-09,
  8.353411943918408e-11, -1.747969562840978e-12,  3.500101036779914e-14, -6.725352135661971e-16,  1.229303505159316e-17, -2.084913984991120e-19,  3.105588815609188e-21,
 -3.524532461828132e-23,  1.060699861763111e-04, -4.276057594037335e-06,  1.207099793891660e-07, -2.921320061073055e-09,  6.483930703660785e-11, -1.362770410606289e-12,
  2.766502494572322e-14, -5.515834259421391e-16,  1.099740810922338e-17, -2.234864859747712e-19,  4.689012222867932e-21, -1.010745151072734e-22,  6.079193366422573e-06,
 -2.450781030937994e-07,  6.919217326752751e-09, -1.675643895320455e-10,  3.730104603640114e-12, -7.925361425665479e-14,  1.663571108558038e-15, -3.609719133206959e-17,
  8.525995944645462e-19, -2.243386751918888e-20,  6.358161467630964e-22, -1.817137368166874e-23,  1.170280704050187e-04, -4.431987292481012e-06,  1.175241708220815e-07,
 -2.671323862847811e-09,  5.565285048613529e-11, -1.095616118020834e-12,  2.070302103725387e-14, -3.781589498032461e-16,  6.673027635604089e-18, -1.125872405497259e-19,
  1.770076389630022e-21, -2.449968481028441e-23,  9.069752901325870e-05, -3.434825323653513e-06,  9.108333021744417e-08, -2.070478854269092e-09,  4.315059327756595e-11,
 -8.507008654988401e-13,  1.615348124485825e-14, -2.993471903842042e-16,  5.484590426134177e-18, -1.009151196661495e-19,  1.898013798525851e-21, -3.696168771430741e-23,
  5.198142981516267e-06, -1.968607479297181e-07,  5.220430916458333e-09, -1.186902724276812e-10,  2.475721290102640e-12, -4.897650626426529e-14,  9.410480419244429e-16,
 -1.805212743331347e-17,  3.598718548693998e-19, -7.814322512242104e-21,  1.890016059070136e-22, -4.942531553604039e-24,  1.009968635035512e-04, -3.606386099682513e-06,
  9.016641368762283e-08, -1.932389600636901e-09,  3.796202429090641e-11, -7.049802183197094e-13,  1.258100882436460e-14, -2.177070942222863e-16,  3.666043433154782e-18,
 -5.993184755682010e-20,  9.407790892965827e-22, -1.382104535957273e-23,  7.827322633780255e-05, -2.794973752941140e-06,  6.987979846684117e-08, -1.497648742839562e-09,
  2.942442722183615e-11, -5.466673024962312e-13,  9.771404263516641e-15, -1.699656593738379e-16,  2.904614352977484e-18, -4.929149303062576e-20,  8.422506217677125e-22,
 -1.472905266436492e-23,  4.486068055574707e-06, -1.601882775424896e-07,  4.005047802681641e-09, -8.583917903008634e-11,  1.686883877030942e-12, -3.137214192381722e-14,
  5.629117676652426e-16, -9.913676115505711e-18,  1.754155073744469e-19, -3.233113203322441e-21,  6.482841906006668e-23, -1.445640201636710e-24,  8.788040752686336e-05,
 -2.968458206595600e-06,  7.020480819981193e-08, -1.423245682356275e-09,  2.644901206548374e-11, -4.646899287894125e-13,  7.848827248084233e-15, -1.287023476666719e-16,
  2.060067835652634e-18, -3.223981371884218e-20,  4.916883297185300e-22, -7.226518577592261e-24,  6.810788557674432e-05, -2.300574544012294e-06,  5.440922465075389e-08,
 -1.103030814787992e-09,  2.049881603986860e-11, -3.601938524548515e-13,  6.086848567699334e-15, -9.998248266709867e-17,  1.608919387906634e-18, -2.555213067451390e-20,
  4.041446258009389e-22, -6.444266978582370e-24,  3.903462312476061e-06, -1.318526864856068e-07,  3.118357537241643e-09, -6.321873203144158e-11,  1.174934043660298e-12,
 -2.065122268512526e-14,  3.493861649864116e-16, -5.762507237042530e-18,  9.391015919203354e-20, -1.543387485723362e-21,  2.643219803827396e-23, -4.910015406190387e-25,
  7.703098708390397e-05, -2.468586818523360e-06,  5.538837058260115e-08, -1.065280747972220e-09,  1.878143163555052e-11, -3.130635428347660e-13,  5.017427621588373e-15,
 -7.810064402488111e-17,  1.188129804001675e-18, -1.772552440290484e-20,  2.594614507173051e-22, -3.711944640634025e-24,  5.969951403230054e-05, -1.913170810032968e-06,
  4.292635361029397e-08, -8.256005763959952e-10,  1.455584933285731e-11, -2.426364351096812e-13,  3.889263998183631e-15, -6.057260518055165e-17,  9.231394901458950e-19,
 -1.384608273554529e-20,  2.056040519327254e-22, -3.045715391152284e-24,  3.421553876769185e-06, -1.096494227559783e-07,  2.460235929618513e-09, -4.731772628000878e-11,
  8.342536376399739e-13, -1.390753187870486e-14,  2.230006852782316e-16, -3.477463310006375e-18,  5.322144341484831e-20, -8.083538894431186e-22,  1.240707342740474e-23,
 -1.981979694675702e-25,  6.796852648307058e-05, -2.071941530963067e-06,  4.422073006633885e-08, -8.089984119450220e-10,  1.356715032765515e-11, -2.151160050950376e-13,
  3.279584755879524e-15, -4.856805225884199e-17,  7.032431299016888e-19, -9.997643793063868e-21,  1.398560160621102e-22, -1.924453316869483e-24,  5.267604829249400e-05,
 -1.605768113246178e-06,  3.427135355196951e-08, -6.269792002816929e-10,  1.051465013800696e-11, -1.667180997871089e-13,  2.541829428135202e-15, -3.764855490925866e-17,
  5.454463600188575e-19, -7.768498879662502e-21,  1.092454165835615e-22, -1.524041646756177e-24,  3.019018491031955e-06, -9.203127077626545e-08,  1.964191737015534e-09,
 -3.593403712891926e-11,  6.026280252518476e-13, -9.555334323414321e-15,  1.456965536541152e-16, -2.158795749564201e-18,  3.131770024783597e-20, -4.479378515889766e-22,
  6.376626113689156e-24, -9.179415106057311e-26,  6.033161926011252e-05, -1.753618664432241e-06,  3.568591015141088e-08, -6.224865166944465e-10,  9.953637661575260e-12,
 -1.504796004256409e-13,  2.187460958805540e-15, -3.088925756588579e-17,  4.265404332295789e-19, -5.785426129008830e-21,  7.730238767985208e-23, -1.018772951170168e-24,
  4.675739571550701e-05, -1.359065824700202e-06,  2.765681174052533e-08, -4.824311152088158e-10,  7.714137247738464e-12, -1.166229792240586e-13,  1.695319282753373e-15,
 -2.394079632396790e-17,  3.306485657217908e-19, -4.487427034459651e-21,  6.006761822927577e-23, -7.956484952647122e-25,  2.679803188763166e-06, -7.789203997902060e-08,
  1.585092849212415e-09, -2.764954320471133e-11,  4.421202350142578e-13, -6.684044191306836e-15,  9.716663701626398e-17, -1.372300404276801e-18,  1.896043980029761e-20,
 -2.576705282157209e-22,  3.463526173559154e-24, -4.641541865107444e-26,  5.384435251455765e-05, -1.495514898616918e-06,  2.908080278743206e-08, -4.847211888553039e-10,
  7.406205251987903e-12, -1.069900498446878e-13,  1.486137938223617e-15, -2.005325079691967e-17,  2.646157695410696e-19, -3.430297147909599e-21,  4.382372619303280e-23,
 -5.528189414049434e-25,  4.172972196556327e-05, -1.159033733509870e-06,  2.253781056328761e-08, -3.756620665894538e-10,  5.739857653770531e-12, -8.291803557280036e-14,
  1.151770486226125e-15, -1.554164743591577e-17,  2.050924994473619e-19, -2.659158525356362e-21,  3.399208153317279e-23, -4.295490757993811e-25,  2.391652491922076e-06,
 -6.642761531197348e-08,  1.291707887113335e-09, -2.153029313590337e-11,  3.289681167741111e-13, -4.752282065404593e-15,  6.601183780209531e-17, -8.907688830725655e-19,
  1.175618961567706e-20, -1.524888578204120e-22,  1.951883580054294e-24, -2.476457563090308e-26,  4.829339131117776e-05, -1.284271522486795e-06,  2.391032508893590e-08,
 -3.815774322562772e-10,  5.582098065969133e-12, -7.720686989321735e-14,  1.026792581127806e-15, -1.326541674431304e-17,  1.675985302697158e-19, -2.080293553253512e-21,
  2.545082741103571e-23, -3.075748053692500e-25,  3.742769107731426e-05, -9.953187485758827e-07,  1.853065682470004e-08, -2.957249825186363e-10,  4.326162260916554e-12,
 -5.983583339425603e-14,  7.957715763135530e-16, -1.028082655647306e-17,  1.298922971598602e-19, -1.612355682199083e-21,  1.972957182924453e-23, -2.385706541140827e-25,
  2.145090511368008e-06, -5.704463037993638e-08,  1.062046175133725e-09, -1.694886432970558e-11,  2.479450328302637e-13, -3.429367863553303e-15,  4.560808238100851e-17,
 -5.892296238080400e-19,  7.444805216489712e-21, -9.242343702265139e-23,  1.131403083032446e-24, -1.369880677421183e-26,  4.351186958368338e-05, -1.109895548880194e-06,
  1.982033733711925e-08, -3.033942304127250e-10,  4.257166984415915e-12, -5.647776847544745e-14,  7.204479630400463e-16, -8.927696996994032e-18,  1.081904774268876e-19,
 -1.288100689159497e-21,  1.511657171591343e-23, -1.752637177070530e-25,  3.372198076706747e-05, -8.601762395201507e-07,  1.536088981969410e-08, -2.351324939003968e-10,
  3.299332005001806e-12, -4.377063792072941e-14,  5.583519515950688e-16, -6.919030231453136e-18,  8.384872218476428e-20, -9.983061178065889e-22,  1.171631147863467e-23,
 -1.358652256615826e-25,  1.932705408364891e-06, -4.929921767552856e-08,  8.803775508060549e-10, -1.347613138189189e-11,  1.890943751165159e-13, -2.508623546613092e-15,
  3.200079849717347e-17, -3.965507720966723e-19,  4.805665908407967e-21, -5.721833087896537e-23,  6.716063941242561e-25, -7.791260995869363e-27,  3.936788360077565e-05,
 -9.648179615575456e-07,  1.655384604378192e-08, -2.434550012430611e-10,  3.282125226710391e-12, -4.183452633725255e-14,  5.127228938076114e-16, -6.104390828806972e-18,
  7.107471707860369e-20, -8.130193324886279e-22,  9.167173273332245e-24, -1.021242340908754e-25,  3.051036478843843e-05, -7.477401696292009e-07,  1.282933790842866e-08,
 -1.886792029210569e-10,  2.543668312847037e-12, -3.242202913941094e-14,  3.973635826874021e-16, -4.730943643370551e-18,  5.508343376366333e-20, -6.300985990137623e-22,
  7.104767490375955e-24, -7.915292422718184e-26,  1.748638297527090e-06, -4.285517745468391e-08,  7.352869018371737e-10, -1.081375731018831e-11,  1.457850756408378e-13,
 -1.858201407079361e-15,  2.277407216979899e-17, -2.711443751410365e-19,  3.157001182055527e-21, -3.611321218602628e-23,  4.072136644974514e-25, -4.537239599164821e-27,
  3.575615235186368e-05, -8.432398107672784e-07,  1.392187663940635e-08, -1.970197442603400e-10,  2.555865479301497e-12, -3.134796141658498e-14,  3.696993224434229e-16,
 -4.235451688973546e-18,  4.745304387222703e-20, -5.223261992020394e-22,  5.667221309318599e-24, -6.075292850652437e-26,  2.771124967624099e-05, -6.535163152671954e-07,
  1.078954457182467e-08, -1.526915779630460e-10,  1.980812302041391e-12, -2.429487318967050e-14,  2.865193726671044e-16, -3.282502693877085e-18,  3.677642764021017e-20,
 -4.048067492064095e-22,  4.392158332602662e-24, -4.708492932373180e-26,  1.588212818568703e-06, -3.745493260599586e-08,  6.183803760489621e-10, -8.751201200064028e-12,
  1.135261501222368e-13, -1.392410288802453e-15,  1.642126415366589e-17, -1.881298604811745e-19,  2.107766082537801e-21, -2.320072881640424e-23,  2.517305628348686e-25,
 -2.698701820524623e-27,  3.259189198090733e-05, -7.406712551499171e-07,  1.178377155221200e-08, -1.606969250137044e-10,  2.008846463934259e-12, -2.374262980674770e-14,
  2.698229211223590e-16, -2.978794410006427e-18,  3.215995829710595e-20, -3.411174382397805e-22,  3.566510367653453e-24, -3.684317033386791e-26,  2.525892739286634e-05,
 -5.740250202956986e-07,  9.132499280064887e-09, -1.245411577694622e-10,  1.556869021536985e-12, -1.840069189525060e-14,  2.091145121044015e-16, -2.308584995222153e-18,
  2.492417784845622e-20, -2.643683172496469e-22,  2.764072823108214e-24, -2.855386614936745e-26,  1.447663051552697e-06, -3.289905385228735e-08,  5.234102608738844e-10,
 -7.137818233459482e-12,  8.922871995934671e-14, -1.054597504713940e-15,  1.198496474386623e-17, -1.323117663649392e-19,  1.428477801953549e-21, -1.515173335368378e-23,
  1.584176175084837e-25, -1.636526693398619e-27,  2.980626087309503e-05, -6.536020645215457e-07,  1.003365456229399e-08, -1.320287554321653e-10,  1.592551665840429e-12,
 -1.816189978806321e-14,  1.991575952521659e-16, -2.121505151335822e-18,  2.210062395132994e-20, -2.261926490533971e-22,  2.281937196211474e-24, -2.274607328366008e-26,
  2.310004524092620e-05, -5.065458335848882e-07,  7.776147276831176e-09, -1.023231406507057e-10,  1.234237856483002e-12, -1.407558997702068e-14,  1.543484264075150e-16,
 -1.644180239272647e-18,  1.712812701829190e-20, -1.753007834145090e-22,  1.768516798642855e-24, -1.762838241392588e-26,  1.323931197249847e-06, -2.903162417759324e-08,
  4.456737580742224e-10, -5.864438649164756e-12,  7.073778367163088e-14, -8.067132552737575e-16,  8.846160042744674e-18, -9.423278200822750e-20,  9.816631232372531e-22,
 -1.004700278750702e-23,  1.013589576922942e-25, -1.010337651021903e-27,  2.734293405571444e-05, -5.792630478035986e-07,  8.590996922893828e-09, -1.092129807281087e-10,
  1.272683154493882e-12, -1.402196681424421e-14,  1.485475006029805e-16, -1.528738953452396e-18,  1.538560261138490e-20, -1.521280097386197e-22,  1.482706277880898e-24,
 -1.427846570081520e-26,  2.119095100173424e-05, -4.489326141119046e-07,  6.658078261760227e-09, -8.464076747021514e-11,  9.863376882931140e-13, -1.086711510578523e-14,
  1.151252751681806e-16, -1.184782591898379e-18,  1.192394173022880e-20, -1.179001954123522e-22,  1.149107082188883e-24, -1.106590804973736e-26,  1.214515419254822e-06,
 -2.572964195899763e-08,  3.815939506844990e-10, -4.851010093023538e-12,  5.652989952791127e-14, -6.228261703852415e-16,  6.598166446599431e-18, -6.790335782459860e-20,
  6.833960030214044e-22, -6.757205544970001e-24,  6.585870351523477e-26, -6.342201402181762e-28,  2.515549974082888e-05, -5.154512489751256e-07,  7.393954213726568e-09,
 -9.091347269126354e-11,  1.024695488980941e-12, -1.091952833405860e-14,  1.118872597850512e-16, -1.113701795959012e-18,  1.084102557626035e-20, -1.036776853075094e-22,
  9.773530704806763e-25, -9.103338594778282e-27,  1.949567523901614e-05, -3.994780566912792e-07,  5.730362408543379e-09, -7.045853021012975e-11,  7.941456412269465e-13,
 -8.462705188051313e-15,  8.671335106356262e-17, -8.631261057938013e-19,  8.401865050140217e-21, -8.035087806636386e-23,  7.574549785275778e-25, -7.055147132129264e-27,
  1.117354203906741e-06, -2.289525653972796e-08,  3.284238400874320e-10, -4.038184569972232e-12,  4.551481084194636e-14, -4.850224012468446e-16,  4.969795924620900e-18,
 -4.946828316060254e-20,  4.815354758284694e-22, -4.605144024551166e-24,  4.341196378260011e-26, -4.043512209166619e-28,  2.320546132187465e-05, -4.604004444750196e-07,
  6.394601668318217e-09, -7.612950724535500e-11,  8.308208748694270e-13, -8.572433901081377e-15,  8.504886616196325e-17, -8.196801057615583e-19,  7.725621031797430e-21,
 -7.153784658660526e-23,  6.529645139992389e-25, -5.888824478634971e-27,  1.798438283333072e-05, -3.568133266227812e-07,  4.955857712739481e-09, -5.900086122927776e-11,
  6.438915595050348e-13, -6.643691799621453e-15,  6.591342216340151e-17, -6.352573913061618e-19,  5.987406342115542e-21, -5.544229454135271e-23,  5.060517307405589e-25,
 -4.563877236694875e-27,  1.030737613195100e-06, -2.045001599708807e-08,  2.840347093088202e-10, -3.381512028714921e-12,  3.690330968548873e-14, -3.807694204364687e-16,
  3.777691126159868e-18, -3.640846023988514e-20,  3.431557803337073e-22, -3.177560164990122e-24,  2.900330604879412e-26, -2.615691756847962e-28  };
  int offset = -3;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 3;
    if (std::isnan(t)) {
      fill_n(rr+offset, 3, 0.5);
      fill_n(ww+offset, 3, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 3; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=3; ++j) {
        const int boxof = it*36+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
