"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.WRITE = exports.READ = exports.Driver = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _neo4jDriverCore = require("neo4j-driver-core");

var _sessionRx = _interopRequireDefault(require("./session-rx"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var FETCH_ALL = _neo4jDriverCore.internal.constants.FETCH_ALL;
var READ = _neo4jDriverCore.driver.READ,
    WRITE = _neo4jDriverCore.driver.WRITE;
/**
 * A driver maintains one or more {@link Session}s with a remote
 * Neo4j instance. Through the {@link Session}s you can send queries
 * and retrieve results from the database.
 *
 * Drivers are reasonably expensive to create - you should strive to keep one
 * driver instance around per Neo4j Instance you connect to.
 *
 * @access public
 */

exports.WRITE = WRITE;
exports.READ = READ;

var Driver = /*#__PURE__*/function (_CoreDriver) {
  (0, _inherits2["default"])(Driver, _CoreDriver);

  var _super = _createSuper(Driver);

  function Driver() {
    (0, _classCallCheck2["default"])(this, Driver);
    return _super.apply(this, arguments);
  }

  (0, _createClass2["default"])(Driver, [{
    key: "rxSession",
    value:
    /**
     * Acquire a reactive session to communicate with the database. The session will
     * borrow connections from the underlying connection pool as required and
     * should be considered lightweight and disposable.
     *
     * This comes with some responsibility - make sure you always call
     * {@link close} when you are done using a session, and likewise,
     * make sure you don't close your session before you are done using it. Once
     * it is closed, the underlying connection will be released to the connection
     * pool and made available for others to use.
     *
     * @public
     * @param {Object} param
     * @param {string} param.defaultAccessMode=WRITE - The access mode of this session, allowed values are {@link READ} and {@link WRITE}.
     * @param {string|string[]} param.bookmarks - The initial reference or references to some previous transactions. Value is optional and
     * absence indicates that the bookmarks do not exist or are unknown.
     * @param {string} param.database - The database this session will operate on.
     * @param {string} param.impersonatedUser - The name of the user which should be impersonated for the duration of the session.
     * @returns {RxSession} new reactive session.
     */
    function rxSession() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref$defaultAccessMod = _ref.defaultAccessMode,
          defaultAccessMode = _ref$defaultAccessMod === void 0 ? WRITE : _ref$defaultAccessMod,
          bookmarks = _ref.bookmarks,
          _ref$database = _ref.database,
          database = _ref$database === void 0 ? '' : _ref$database,
          fetchSize = _ref.fetchSize,
          impersonatedUser = _ref.impersonatedUser;

      return new _sessionRx["default"]({
        session: this._newSession({
          defaultAccessMode: defaultAccessMode,
          bookmarkOrBookmarks: bookmarks,
          database: database,
          impersonatedUser: impersonatedUser,
          reactive: true,
          fetchSize: validateFetchSizeValue(fetchSize, this._config.fetchSize)
        }),
        config: this._config
      });
    }
  }]);
  return Driver;
}(_neo4jDriverCore.Driver);
/**
 * @private
 */


exports.Driver = Driver;

function validateFetchSizeValue(rawValue, defaultWhenAbsent) {
  var fetchSize = parseInt(rawValue, 10);

  if (fetchSize > 0 || fetchSize === FETCH_ALL) {
    return fetchSize;
  } else if (fetchSize === 0 || fetchSize < 0) {
    throw new Error("The fetch size can only be a positive value or ".concat(FETCH_ALL, " for ALL. However fetchSize = ").concat(fetchSize));
  } else {
    return defaultWhenAbsent;
  }
}

var _default = Driver;
exports["default"] = _default;