import type { CancellablePromise, ExtendablePromise } from './types';
/**
 * Compare two arrays without checking for possible nested properties
 * @param a Array to compare with b
 * @param b Array to compare with a
 * @returns True if arrays are identical, false if they are different
 */
export declare const shallowArraysEqual: (a: any[], b: any[]) => boolean;
/**
 * Create a CancellablePromise from a native Promise
 * @param promise The promise object to wrap
 * @returns Return value is an object of type CancellablePromise, with 2 properties:
 * - promise: a promise that can be left pending
 * - cancel: the function to use for cancelling the returned promise
 */
export declare const createCancellablePromise: <T>(promise: ExtendablePromise<T>) => CancellablePromise;
//# sourceMappingURL=utils.d.ts.map