/* linkurious.js - A Javascript toolkit to speed up the development of graph visualization and interaction applications. - Version: 1.5.2 - Author: Linkurious SAS - License: GPLv3 */

(function(a){"use strict";if("undefined"==typeof sigma)throw new Error("sigma is not declared");var b=new sigma.utils.map;sigma.classes.graph.attach("addNode","sigma.helpers.graph.addNode",function(a){a.fixed&&b.set(a.id,this.nodesIndex.get(a.id))}),sigma.classes.graph.attachBefore("dropNode","sigma.helpers.graph.dropNode",function(a){b["delete"](a)}),sigma.classes.graph.attachBefore("clear","sigma.helpers.graph.clear",function(){b.clear(),b=new sigma.utils.map}),sigma.classes.graph.hasMethod("fixNode")||sigma.classes.graph.addMethod("fixNode",function(a){return this.nodesIndex.get(a)&&(this.nodesIndex.get(a).fixed=!0,b.set(a,this.nodesIndex.get(a))),this}),sigma.classes.graph.hasMethod("unfixNode")||sigma.classes.graph.addMethod("unfixNode",function(c){return this.nodesIndex.get(c)&&(this.nodesIndex.get(c).fixed=a,b["delete"](c)),this}),sigma.classes.graph.hasMethod("getFixedNodes")||sigma.classes.graph.addMethod("getFixedNodes",function(){var a=[];return b.forEach(function(b,c){a.push(b)}),a}),sigma.classes.graph.hasMethod("hasFixedNodes")||sigma.classes.graph.addMethod("hasFixedNodes",function(){return 0!=b.size}),sigma.classes.graph.hasMethod("dropNodes")||sigma.classes.graph.addMethod("dropNodes",function(a){if(arguments.length>1)throw new Error("Too many arguments. Use an array instead.");if("string"==typeof a||"number"==typeof a)this.dropNode(a);else{if(!Array.isArray(a))throw new TypeError('Invalid argument: "v" is not a string, a number, or an array, was '+a);var b,c;for(b=0,c=a.length;c>b;b++){if("string"!=typeof a[b]&&"number"!=typeof a[b])throw new TypeError("Invalid argument: a node id is not a string or a number, was "+a[b]);this.dropNode(a[b])}}return this}),sigma.classes.graph.hasMethod("dropEdges")||sigma.classes.graph.addMethod("dropEdges",function(a){if(arguments.length>1)throw new Error("Too many arguments. Use an array instead.");if("string"==typeof a||"number"==typeof a)this.dropEdge(a);else{if(!Array.isArray(a))throw new TypeError("Invalid argument: it is not a string, a number, or an array, was "+a);var b,c;for(b=0,c=a.length;c>b;b++){if("string"!=typeof a[b]&&"number"!=typeof a[b])throw new TypeError("Invalid argument: an edge id is not a string or a number, was "+a[b]);this.dropEdge(a[b])}}return this}),sigma.classes.graph.hasMethod("adjacentNodes")||sigma.classes.graph.addMethod("adjacentNodes",function(a,b){if(b=b||{},b.withHidden=2==arguments.length?b.withHidden:!0,"string"!=typeof a&&"number"!=typeof a)throw new TypeError("The node id is not a string or a number, was "+a);var c,d=this,e=[];return(this.allNeighborsIndex.get(a)||[]).forEach(function(f,g){b.withHidden?e.push(d.nodesIndex.get(g)):d.nodes(g).hidden||(c=0!=d.allNeighborsIndex.get(a).get(g).keyList().map(function(a){return d.edges(a)}).filter(function(a){return!a.hidden}).length,c&&e.push(d.nodesIndex.get(g)))}),e}),sigma.classes.graph.hasMethod("adjacentEdges")||sigma.classes.graph.addMethod("adjacentEdges",function(a,b){if(b=b||{},b.withHidden=2==arguments.length?b.withHidden:!0,"string"!=typeof a&&"number"!=typeof a)throw new TypeError("The node id is not a string or a number, was "+a);var c=this,d=this.allNeighborsIndex.get(a)||[],e=[];return d.forEach(function(a,f){d.get(f).forEach(function(a,d){(b.withHidden||!c.edges(d).hidden)&&e.push(c.edges(d))})}),e})}).call(this),function(a){"use strict";function b(a,b,c){var d=null,e=null,f=null;if(window.Blob?(d=new Blob([a],{type:"text/xml"}),e=window.URL.createObjectURL(d)):f="data:text/xml;charset=UTF-8,"+encodeURIComponent('<?xml version="1.0" encoding="UTF-8"?>')+encodeURIComponent(a),navigator.msSaveBlob)navigator.msSaveBlob(d,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(d,c);else{var g=document.createElement("a");g.setAttribute("href",window.Blob?e:f),g.setAttribute("download",c||"graph."+b),document.body.appendChild(g),g.click(),document.body.removeChild(g)}e&&setTimeout(function(){window.URL.revokeObjectURL(e)},0)}function c(a,b){return null===b?null:b.split(".").reduce(function(a,b){return a[b]},a)}function d(a){var b=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;a=a.replace(b,function(a,b,c,d){return b+b+c+c+d+d});var c=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(a);return c?[parseInt(c[1],16),parseInt(c[2],16),parseInt(c[3],16)]:null}function e(){var a=new Date,b=a.getDate(),c=a.getMonth()+1,d=a.getFullYear();return 10>b&&(b="0"+b),10>c&&(c="0"+c),d+"-"+c+"-"+b}function f(a){return a===+a&&a===(0|a)}function g(a,b){return"integer"===b&&"number"==typeof a?f(a)||(b="float"):"number"!=typeof a&&(b="string","boolean"==typeof a&&(b="boolean")),b}if("undefined"==typeof sigma)throw"sigma.exporters.gexf: sigma is not declared";sigma.prototype.toGEXF=function(a){a=a||{};var f,h=document.implementation.createDocument("","",null),i=new XMLSerializer,j="",k=!0,l=this.graph.nodes(),m=this.graph.edges();a.renderer&&(k=a.renderer instanceof sigma.renderers.webgl,f=k?a.renderer.camera.prefix:a.renderer.camera.readPrefix);var n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H={},I=0,J={},K=0;D=h.createElement("gexf"),D.setAttribute("xmlns","http://www.gexf.net/1.2draft"),D.setAttribute("xmlns:viz","http://www.gexf.net/1.2draft/viz"),D.setAttribute("xmlns:xsi","http://www.w3.org/2001/XMLSchema-instance"),D.setAttribute("xsi:schemaLocation","http://www.gexf.net/1.2draft http://www.gexf.net/1.2draft/gexf.xsd"),D.setAttribute("version","1.2"),A=h.createElement("meta"),A.setAttribute("lastmodifieddate",e()),a.creator&&(v=h.createElement("creator"),G=h.createTextNode(""+a.creator),v.appendChild(G),A.appendChild(v)),a.description&&(w=h.createElement("description"),G=h.createTextNode(""+a.description),w.appendChild(G),A.appendChild(w)),z=h.createElement("graph"),z.setAttribute("mode","static"),B=h.createElement("nodes");for(var L=0;L<l.length;L++){if(n=l[L],C=h.createElement("node"),C.setAttribute("id",n.id),n.label&&C.setAttribute("label",n.label),o=c(n,a.nodeAttributes),o&&(q=h.createElement("attvalues"),Object.keys(o).forEach(function(a){a in H||(H[a]={id:I,type:"integer"},I++);var b=o[a];H[a].type=g(b,H[a].type),r=h.createElement("attvalue"),r.setAttribute("for",H[a].id),r.setAttribute("value",b),q.appendChild(r)}),C.appendChild(q)),a.renderer){if(n.color){var M;M="#"===n.color[0]?d(n.color):n.color.match(/\d+/g),M.length>2&&(u=h.createElement("viz:color"),u.setAttribute("r",M[0]),u.setAttribute("g",M[1]),u.setAttribute("b",M[2]),M.length>3&&(5===M.length?u.setAttribute("a",M[3]+"."+M[4]):u.setAttribute("a",M[3])),C.appendChild(u))}E=h.createElement("viz:position"),E.setAttribute("x",n[f+"x"]),E.setAttribute("y",-parseInt(n[f+"y"],10)),C.appendChild(E),n.size&&(F=h.createElement("viz:size"),F.setAttribute("value",n[f+"size"]),C.appendChild(F))}B.appendChild(C)}s=h.createElement("attributes"),s.setAttribute("class","node"),Object.keys(H).forEach(function(a){p=h.createElement("attribute"),p.setAttribute("id",H[a].id),p.setAttribute("title",a),p.setAttribute("type",H[a].type),s.appendChild(p)}),x=h.createElement("edges");for(var L=0;L<m.length;L++){if(n=m[L],y=h.createElement("edge"),y.setAttribute("id",n.id),y.setAttribute("source",n.source),y.setAttribute("target",n.target),n.size&&y.setAttribute("weight",n.size),n.label&&y.setAttribute("label",n.label),o=c(n,a.edgeAttributes),o&&(q=h.createElement("attvalues"),Object.keys(o).forEach(function(a){a in J||(J[a]={id:K,type:"integer"},K++);var b=o[a];J[a].type=g(b,J[a].type),r=h.createElement("attvalue"),r.setAttribute("for",J[a].id),r.setAttribute("value",b),q.appendChild(r)}),y.appendChild(q)),a.renderer){if(n.color){var M;M="#"===n.color[0]?d(n.color):n.color.match(/\d+/g),M.length>2&&M.length<=5&&(u=h.createElement("viz:color"),u.setAttribute("r",M[0]),u.setAttribute("g",M[1]),u.setAttribute("b",M[2]),y.appendChild(u))}n.size&&(F=h.createElement("viz:size"),F.setAttribute("value",n.size),y.appendChild(F))}x.appendChild(y)}return t=h.createElement("attributes"),t.setAttribute("class","edge"),Object.keys(J).forEach(function(a){p=h.createElement("attribute"),p.setAttribute("id",J[a].id),p.setAttribute("title",a),p.setAttribute("type",J[a].type),t.appendChild(p)}),z.appendChild(s),z.appendChild(t),z.appendChild(B),z.appendChild(x),D.appendChild(A),D.appendChild(z),h.appendChild(D),j=i.serializeToString(h),a.download&&b(j,"gexf",a.filename),p&&p.parentNode.removeChild(p),q&&q.parentNode.removeChild(q),r&&r.parentNode.removeChild(r),u&&u.parentNode.removeChild(u),v&&v.parentNode.removeChild(v),w&&w.parentNode.removeChild(w),G&&G.parentNode.removeChild(G),E&&E.parentNode.removeChild(E),F&&F.parentNode.removeChild(F),C&&C.parentNode.removeChild(C),y&&y.parentNode.removeChild(y),s&&s.parentNode.removeChild(s),t&&t.parentNode.removeChild(t),B&&B.parentNode.removeChild(B),x&&x.parentNode.removeChild(x),z&&z.parentNode.removeChild(z),A&&A.parentNode.removeChild(A),D&&D.parentNode.removeChild(D),h=null,j}}.call(this),function(a){"use strict";function b(a,b,c){var d=null,e=null,f=null;if(window.Blob?(d=new Blob([a],{type:"text/xml"}),e=window.URL.createObjectURL(d)):f="data:text/xml;charset=UTF-8,"+encodeURIComponent('<?xml version="1.0" encoding="UTF-8"?>')+encodeURIComponent(a),navigator.msSaveBlob)navigator.msSaveBlob(d,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(d,c);else{var g=document.createElement("a");g.setAttribute("href",window.Blob?e:f),g.setAttribute("download",c||"graph."+b),document.body.appendChild(g),g.click(),document.body.removeChild(g)}e&&setTimeout(function(){window.URL.revokeObjectURL(e)},0)}function c(a,b){for(var c in a)a.hasOwnProperty(c)&&b(a[c],c)}function d(a,b){return null==b?null:b.split(".").reduce(function(a,b){return a[b]},a)}function e(a){var b=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;a=a.replace(b,function(a,b,c,d){return b+b+c+c+d+d});var c=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(a);return c?[parseInt(c[1],16),parseInt(c[2],16),parseInt(c[3],16)]:null}if("undefined"==typeof sigma)throw"sigma.exporters.graphML: sigma is not declared";sigma.prototype.toGraphML=function(f){function g(a,b){var c;c="#"===b[0]?e(b):b.match(/\d+(\.\d+)?/g),a.r=c[0],a.g=c[1],a.b=c[2],a.a&&(a.a=c[3])}function h(b,c,d,e,f){d=d||{};var g=n.createElement(c);for(var h in d)if(d.hasOwnProperty(h)){var i=d[h];i!==a&&g.setAttribute(h,i)}if(e!==a||f){"[object Object]"===Object.prototype.toString.call(e)&&(e=JSON.stringify(e));var j=document.createTextNode(e);g.appendChild(j)}return b.appendChild(g),g}function i(b,e,f){var h=d(b,f),i={id:b.id};t.forEach(function(c){var d="x"===c||"y"===c?b[m+c]:b[c];"y"===c&&d&&(d=-parseFloat(d)),d!==a&&(i[("edge"===e?"edge_":"")+c]=d,"color"===c&&g(i,d))}),c(h,function(a,b){-1===t.indexOf(b)&&-1===s.indexOf(b)&&(u[b]?u[b]["for"]!==e&&(u[b]["for"]="all"):u[b]={"for":e,type:"string"},i[b]=a)}),"edge"===e?(i.source=b.source,i.target=b.target,w.push(i)):v.push(i)}function j(a,b){var c=h(a,"data",{key:"nodegraphics"}),d=h(c,"y:ShapeNode");h(d,"y:Geometry",{x:b.x,y:b.y,width:b.size,height:b.size}),h(d,"y:Fill",{color:b.color?b.color:"#000000",transparent:!1}),h(d,"y:NodeLabel",null,b.label?b.label:""),h(d,"y:Shape",{type:b.type?b.type:"circle"})}function k(a,b){var c=h(a,"data",{key:"edgegraphics"}),d=h(c,"y:PolyLineEdge");h(d,"y:LineStyle",{type:b.edge_type?b.edge_type:"line",color:b.edge_color?b.edge_color:"#0000FF",width:b.edge_size?b.edge_size:1}),h(d,"y:EdgeLabel",null,b.edge_label?b.edge_label:"")}f=f||{};var l,m,n=document.implementation.createDocument("","",null),o=new XMLSerializer,p=!0,q=this.graph.nodes(),r=this.graph.edges();f.renderer?(p=f.renderer instanceof sigma.renderers.webgl,m=p?f.renderer.camera.prefix:f.renderer.camera.readPrefix):m="";var s=["id","source","target"],t=["size","x","y","type","color","label","fixed","hidden","active"],u={size:{"for":"all",type:"double"},x:{"for":"node",type:"double"},y:{"for":"node",type:"double"},type:{"for":"all",type:"string"},color:{"for":"all",type:"string"},r:{"for":"all",type:"int"},g:{"for":"all",type:"int"},b:{"for":"all",type:"int"},a:{"for":"all",type:"double"},label:{"for":"all",type:"string"},fixed:{"for":"node",type:"boolean"},hidden:{"for":"all",type:"boolean"},active:{"for":"all",type:"boolean"}},v=[],w=[];q.forEach(function(a){i(a,"node",f.nodesAttributes)}),r.forEach(function(a){i(a,"edge",f.edgesAttributes)});var x=h(n,"graphml",{xmlns:"http://graphml.graphdrawing.org/xmlns","xmlns:xsi":"http://www.w3.org/2001/XMLSchema-instance","xsi:schemaLocation":"http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd","xmlns:y":"http://www.yworks.com/xml/graphml","xmlns:java":"http://www.yworks.com/xml/yfiles-common/1.0/java","xmlns:sys":"http://www.yworks.com/xml/yfiles-common/markup/primitives/2.0","xmlns:x":"http://ww.yworks.com/xml/yfiles-common/markup/2.0"});c(u,function(a,b){("node"===a["for"]||"all"===a["for"])&&h(x,"key",{"attr.name":b,"attr.type":a.type,"for":"node",id:b}),("edge"===a["for"]||"all"===a["for"])&&h(x,"key",{"attr.name":b,"attr.type":a.type,"for":"edge",id:"edge_"+b})}),h(x,"key",{id:"nodegraphics","for":"node","yfiles.type":"nodegraphics","attr.type":"string"}),h(x,"key",{id:"edgegraphics","for":"edge","yfiles.type":"edgegraphics","attr.type":"string"});var y=h(x,"graph",{edgedefault:f.undirectedEdges?"undirected":"directed",id:f.graphId?f.graphId:"G","parse.nodes":q.length,"parse.edges":r.length,"parse.order":"nodesfirst"});v.forEach(function(a){var b=h(y,"node",{id:a.id});j(b,a),c(a,function(a,c){-1===s.indexOf(c)&&h(b,"data",{key:c},a,!0)})}),w.forEach(function(a){var b=h(y,"edge",{id:a.id,source:a.source,target:a.target});k(b,a),c(a,function(a,c){-1===s.indexOf(c)&&h(b,"data",{key:c},a,!0)})}),l='<?xml version="1.0" encoding="UTF-8"?>'+o.serializeToString(n),f.download&&b(l,"graphml",f.filename)}}.call(this),function(undefined){"use strict";function download(a,b,c){var d=null,e=null,f=null;if(window.Blob?(d=new Blob([a],{type:"text/json"}),e=window.URL.createObjectURL(d)):f="data:text/json;charset=UTF-8,"+encodeURIComponent(a),navigator.msSaveBlob)navigator.msSaveBlob(d,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(d,c);else{var g=document.createElement("a");g.setAttribute("href",window.Blob?e:f),g.setAttribute("download",c||"graph."+b),document.body.appendChild(g),g.click(),document.body.removeChild(g)}e&&setTimeout(function(){window.URL.revokeObjectURL(e)},0)}function deepCopy(o){var copy=Object.create(null);for(var i in o)"object"==typeof o[i]&&null!==o[i]?copy[i]=deepCopy(o[i]):"function"==typeof o[i]&&null!==o[i]?eval(" copy[i] = "+o[i].toString()):copy[i]=o[i];return copy}function startsWith(a,b){return b.slice(0,a.length)==a}function cleanup(a){for(var b in a)(startsWith("read_cam",b)||startsWith("cam",b)||startsWith("renderer",""+b))&&(a[b]=undefined);return a}if("undefined"==typeof sigma)throw"sigma.exporters.json: sigma is not declared";sigma.prototype.toJSON=function(a){a=a||{};var b={nodes:this.graph.nodes().map(deepCopy).map(cleanup),edges:this.graph.edges().map(deepCopy).map(cleanup)};if(a.pretty)var c=JSON.stringify(b,null," ");else var c=JSON.stringify(b);return a.download&&download(c,"json",a.filename),c}}.call(this),function(a){"use strict";function b(a,b,c){var d=null,e=null,f=null;if(window.Blob?(d=new Blob([a],{type:"text/xml"}),e=window.URL.createObjectURL(d)):f="data:text/csv;charset=UTF-8,"+encodeURIComponent(a),navigator.msSaveBlob)navigator.msSaveBlob(d,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(d,c);else{var g=document.createElement("a");g.setAttribute("href",window.Blob?e:f),g.setAttribute("download",c||"graph."+b),document.body.appendChild(g),g.click(),document.body.removeChild(g)}e&&setTimeout(function(){window.URL.revokeObjectURL(e)},0)}function c(b,c){return null===b||b===a?c+c:"function"==typeof b?b.toString():(b="string"==typeof b?b:JSON.stringify(b),b=b.replace(/\s+/g," "),c&&c.length?c+b.replace(c,'"'===c?"'":'"')+c:b)}function d(b,c){return null===c||c===a?null:c.split(".").reduce(function(a,b){return a[b]},b)}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.prototype.toSpreadsheet=function(a){if(a=a||{},a.separator=a.separator||",",a.textSeparator=a.textSeparator||"",a.textSeparator&&'"'!==a.textSeparator&&"'"!==a.textSeparator)throw new TypeError('Invalid argument :"textSeparator" is not single-quote or double-quote, was '+a.textSeparator);var e,f,g,h,i,j,k=[],l={},m=[],n=0,o=a.categoriesName||"categories";if(!a.what)throw new TypeError('Missing argument: "what".');if("nodes"===a.what)e=a.which?this.graph.nodes(a.which):this.graph.nodes();else{if("edges"!==a.what)throw new TypeError('Invalid argument: "what" is not "nodes" or "edges", was '+a.what);e=a.which?this.graph.edges(a.which):this.graph.edges()}l.id=n++,m.push(c("id",a.textSeparator)),"edges"===a.what&&(l.source=n++,m.push(c("source",a.textSeparator)),l.target=n++,m.push(c("target",a.textSeparator))),j=a.categories&&a.categories.length,j&&(l.categories=n++,m.push(c(o,a.textSeparator)));for(var p=0;p<e.length;p++)h=e[p],f=d(h,a.attributes)||{},Object.keys(f).forEach(function(b){b in l||(l[b]=n++,m.push(c(b,a.textSeparator)))});k.push(m);for(var p=0;p<e.length;p++)h=e[p],i=[],i.length=n,i[0]=c(h.id,a.textSeparator),"edges"===a.what&&(i[1]=c(h.source,a.textSeparator),i[2]=c(h.target,a.textSeparator)),j&&(g=d(h,a.categories),Array.isArray(g)&&(g=g.join(",")),i[l.categories]=c(g,a.textSeparator)),f=d(h,a.attributes)||{},Object.keys(f).forEach(function(b){i[l[b]]=c(f[b],a.textSeparator)}),k.push(i);var q=k.map(function(b){return b.join(a.separator)}).join("\n");return a.download&&b(q,"csv",a.filename),q}}.call(this),function(a){"use strict";function b(a){return new Blob([a],{type:"image/svg+xml;charset=utf-8"})}function c(a,c){if("undefined"!=typeof safari){var d="File download does not work in Safari. Please use a modern web browser such as Firefox, Chrome, or Internet Explorer 11.";throw alert(d),new Error(d)}var e=b(a),f=window.URL.createObjectURL(e);if(navigator.msSaveBlob)navigator.msSaveBlob(e,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(e,c);else{var g=document.createElement("a");g.setAttribute("href",f),g.setAttribute("download",c),document.body.appendChild(g),g.click(),document.body.removeChild(g)}setTimeout(function(){window.URL.revokeObjectURL(f)},0)}function d(a,b,c){var d,e,g,h,i,j={},k={},l=0,m="";c.classes&&(e=document.createElementNS(f,"style"),a.insertBefore(e,a.firstChild));var n=a.querySelectorAll('[id="'+b+'-group-nodes"] > [class="'+b+'-node"]');for(h=0,i=n.length,g=!0;i>h;h++)d=n[h].getAttribute("fill"),c.data||n[h].removeAttribute("data-node-id"),c.classes&&(d in j||(j[d]=g?b+"-node":"c-"+l++,m+="."+j[d]+"{fill: "+d+"}"),j[d]!==b+"-node"&&n[h].setAttribute("class",n[h].getAttribute("class")+" "+j[d]),n[h].removeAttribute("fill")),g=!1;var o=a.querySelectorAll('[id="'+b+'-group-edges"] > [class="'+b+'-edge"]');for(h=0,i=o.length,g=!0;i>h;h++)d=o[h].getAttribute("stroke"),c.data||o[h].removeAttribute("data-edge-id"),c.classes&&(d in k||(k[d]=g?b+"-edge":"c-"+l++,m+="."+k[d]+"{stroke: "+d+"}"),k[d]!==b+"-edge"&&o[h].setAttribute("class",o[h].getAttribute("class")+" "+k[d]),o[h].removeAttribute("stroke")),g=!1;c.classes&&e.appendChild(document.createTextNode(m))}if("undefined"==typeof sigma)throw"sigma.renderers.snapshot: sigma not in scope.";var e=(this.URL||this.webkitURL||this,{size:"1000",width:"1000",height:"1000",margin:.05,classes:!0,labels:!0,data:!1,download:!1,filename:"graph.svg"}),f="http://www.w3.org/2000/svg";sigma.prototype.toSVG=function(a){a=a||{};var b=this.settings("classPrefix"),f=a.size||a.width||e.size,g=a.size||a.height||e.size,h=a.margin||e.margin,i=document.createElement("div");i.setAttribute("width",f),i.setAttribute("height",g),i.setAttribute("style","position:absolute; top: 0px; left:0px; width: "+f+"px; height: "+g+"px;");var j=this.settings("sideMargin");this.settings("sideMargin",h);var k=this.settings("autoRescale");this.settings("autoRescale",!0);var l=this.addCamera(),m=this.addRenderer({camera:l,container:i,type:"svg",forceLabels:!!a.labels});m.resize(f,g),this.refresh(),this.killRenderer(m),this.killCamera(l),this.settings("sideMargin",j),this.settings("autoRescale",k);var n=i.querySelector("svg");if(n.removeAttribute("style"),n.setAttribute("width",f+"px"),n.setAttribute("height",g+"px"),n.setAttribute("x","0px"),n.setAttribute("y","0px"),!a.labels){var o=n.querySelector('[id="'+b+'-group-labels"]');n.removeChild(o)}var p=n.querySelector('[id="'+b+'-group-hovers"]');n.removeChild(p),a.classes=a.classes!==!1,(!a.data||a.classes)&&d(n,b,a);var q=n.outerHTML;i=null;var r='<?xml version="1.0" encoding="utf-8"?>\n';return r+='<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n',r+=q,a.download&&c(r,a.filename||e.filename),r}}.call(this),function(a){"use strict";function b(a,b,c){var d=window.URL.createObjectURL(a);if(navigator.msSaveBlob)navigator.msSaveBlob(a,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(a,c);else{var e=document.createElement("a");e.setAttribute("href",d),e.setAttribute("download",c||"graph."+b),document.body.appendChild(e),e.click(),document.body.removeChild(e)}setTimeout(function(){window.URL.revokeObjectURL(d)},0)}function c(a){for(var b=new ArrayBuffer(a.length),c=new Uint8Array(b),d=0;d!=a.length;++d)c[d]=255&a.charCodeAt(d);return b}function d(b){return null===b||b===a?"":"string"==typeof b||"number"==typeof b?b:"function"==typeof b?b.toString():JSON.stringify(b)}function e(b){return null===b||b===a?"":"string"==typeof b||"number"==typeof b?b:Array.isArray(b)?b.join(","):"function"==typeof b?b.toString():JSON.stringify(b)}function f(b,c){return null===c||c===a?null:c.split(".").reduce(function(a,b){return a[b]},b)}function g(){return this instanceof g?(this.SheetNames=[],void(this.Sheets={})):new g}function h(a,b){b&&(a+=1462);var c=Date.parse(a);return(c-new Date(Date.UTC(1899,11,30)))/864e5}function i(a,b){for(var c={},d={s:{c:1e7,r:1e7},e:{c:0,r:0}},e=0;e!=a.length;++e)for(var f=0;f!=a[e].length;++f){d.s.r>e&&(d.s.r=e),d.s.c>f&&(d.s.c=f),d.e.r<e&&(d.e.r=e),d.e.c<f&&(d.e.c=f);var g={v:a[e][f]};if(null!=g.v){var i=XLSX.utils.encode_cell({c:f,r:e});"number"==typeof g.v?g.t="n":"boolean"==typeof g.v?g.t="b":g.v instanceof Date?(g.t="n",g.z=XLSX.SSF._table[14],g.v=h(g.v)):g.t="s",c[i]=g}}return d.s.c<1e7&&(c["!ref"]=XLSX.utils.encode_range(d)),c}function j(a,b){var c,g,h,i=0,j={},k=[],l=b.nodesAttributes,m=b.nodesCategories,n=b.nodesCategoriesName||"categories",o=0,p=[];"edges"===b.what&&(l=b.edgesAttributes,m=b.edgesCategories,n=b.edgesCategoriesName||"categories"),o=m&&m.length?1:0,j.id=i++,k.push("id"),"edges"===b.what&&(j.source=i++,k.push("source"),j.target=i++,k.push("target")),o&&(i++,k.push(n));for(var q=0;q<a.length;q++)g=a[q],c=f(g,l)||{},Object.keys(c).forEach(function(a){a in j||(j[a]=i++,k.push(d(a)))});p.push(k);for(var q=0;q<a.length;q++)g=a[q],h=[],h.length=i,h[0]=d(g.id),"edges"===b.what?(h[1]=d(g.source),h[2]=d(g.target),o&&(h[3]=e(f(g,m)))):o&&(h[1]=e(f(g,m))),c=f(g,l)||{},Object.keys(c).forEach(function(a){h[j[a]]=d(c[a])}),p.push(h);return p}if("undefined"==typeof sigma)throw new Error("sigma is not declared");("undefined"==typeof dagre||"undefined"==typeof dagre.graphlib)&&console.warn("to use the xlx plugin, you have to include the XLSX library"),sigma.prototype.toXLSX=function(a){if("undefined"==typeof XLSX)throw new Error("XLSX is not declared");a=a||{};var d,e,f,h=new g;if(a.what)if("nodes"===a.what)f=a.which?this.graph.nodes(a.which):this.graph.nodes(),d=i(j(f,a));else{if("edges"!==a.what)throw new TypeError('Invalid argument: "what" is not "nodes" or "edges", was '+a.what);f=a.which?this.graph.edges(a.which):this.graph.edges(),e=i(j(f,a))}else a.what="nodes",d=i(j(this.graph.nodes(),a)),a.what="edges",e=i(j(this.graph.edges(),a));d&&(h.SheetNames.push("Nodes"),h.Sheets.Nodes=d),e&&(h.SheetNames.push("Edges"),h.Sheets.Edges=e);var k=XLSX.write(h,{bookType:"xlsx",bookSST:!1,type:"binary"}),l=new Blob([c(k)],{type:""});b(l,"xlsx",a.filename)}}.call(this),function(a){"use strict";function b(a){var b=";base64,";if(-1==a.indexOf(b)){var c=a.split(","),d=c[0].split(":")[1],e=decodeURIComponent(c[1]);return new Blob([e],{type:d})}for(var c=a.split(b),d=c[0].split(":")[1],e=window.atob(c[1]),f=e.length,g=new Uint8Array(f),h=0;f>h;++h)g[h]=e.charCodeAt(h);return new Blob([g],{type:d})}function c(a,c,d){if(d=d||"graph."+c,navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(b(a),d);else if(navigator.msSaveBlob)navigator.msSaveBlob(b(a),d);else{var e=document.createElement("a");e.setAttribute("href",a),e.setAttribute("download",d),document.body.appendChild(e),e.click(),document.body.removeChild(e)}}function d(a,b,c){var d=Math.min(c/a,c/b);return{width:a*d,height:b*d}}function e(a,b,c){var d;return d=sigma.utils.getBoundaries(a.graph,b.camera.readPrefix),d.minX/=c.zoomRatio,d.minY/=c.zoomRatio,d.maxX/=c.zoomRatio,d.maxY/=c.zoomRatio,d}function f(a,b,c){var f,g=c.margin||0,h={width:b.width,height:b.height};return c.clips||c.size?c.size&&c.size>=1&&(h=d(b.width,b.height,c.size)):(f=e(a,b,c),h={width:f.maxX-f.minX+2*f.sizeMax,height:f.maxY-f.minY+2*f.sizeMax}),h.width+=g,h.height+=g,h}function g(a,b,d){if(d=d||{},d.format&&!(d.format in i))throw Error('sigma.renderers.image: unsupported format "'+d.format+'".');var e=f(a,b,d),g=a.settings("batchEdgesDrawing");g&&a.settings("batchEdgesDrawing",!1),d.clip||this.clone(a,d,e);var h=this.draw(b,d,e);a.settings("batchEdgesDrawing",g);var j=h.toDataURL(i[d.format||"png"]);return d.download&&c(j,d.format||"png",d.filename),j}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");var h,i,j,k;h=["scene","edges","nodes","labels"],i={png:"image/png",jpg:"image/jpeg",gif:"image/gif",tiff:"image/tiff"},g.prototype.clone=function(a,b,c){b.tmpContainer=b.tmpContainer||"image-container";var d=sigma.utils.getPixelRatio(),e=a.settings("webglOversamplingRatio"),f=document.getElementById(b.tmpContainer);f||(f=document.createElement("div"),f.id=b.tmpContainer,document.body.appendChild(f)),f.setAttribute("style","width:"+Math.round(c.width/d)+"px;height:"+Math.round(c.height/d)+"px;");var g=a.addRenderer({container:document.getElementById(b.tmpContainer),type:"canvas",settings:{batchEdgesDrawing:!0,drawLabels:!!b.labels}});g.camera.ratio=b.zoomRatio>0?b.zoomRatio:1,b.size||(g.camera.ratio*=d);var i=g instanceof sigma.renderers.webgl,l=!1,m=[];j=document.createElement("canvas"),k=j.getContext("2d"),a.refresh(),h.forEach(function(a){if(g.contexts[a]&&(b.labels!==!1||"labels"!==a)){var d=g.domElements[a]||g.domElements.scene,f=g.contexts[a];l||(j.width=c.width,j.height=c.height,i&&f instanceof WebGLRenderingContext&&(j.width/=e,j.height/=e),l=!0),f instanceof WebGLRenderingContext?k.drawImage(d,0,0,d.width/e,d.height/e):k.drawImage(d,0,0),~m.indexOf(f)||m.push(f)}}),m=[],a.killRenderer(g),f.parentNode.removeChild(f)},g.prototype.draw=function(a,b,c){var e=a instanceof sigma.renderers.webgl,f=!1,g=[],i=document.createElement("canvas"),k=i.getContext("2d");return h.forEach(function(h){if(a.contexts[h]&&(b.labels!==!1||"labels"!==h)){var l=a.domElements[h]||a.domElements.scene,m=a.contexts[h];if(!~g.indexOf(m)){if(!f){var n,o;if(b.clip){var p=!b.size||b.size<1?window.innerWidth:b.size;n=l.width,o=l.height,c=d(n,o,p)}else n=j.width,o=j.height;if(i.width=c.width,i.height=c.height,!e&&!m instanceof WebGLRenderingContext){var q=s.settings("webglOversamplingRatio");i.width*=q,i.height*=q}f=!0,b.background&&(k.rect(0,0,i.width,i.height),k.fillStyle=b.background,k.fill())}k.drawImage(b.clip?l:j,0,0,i.width,i.height),g.push(m)}}}),g=[],i};var l=null;sigma.plugins.image=function(a,b,c){return sigma.plugins.killImage(),l||(l=new g(a,b,c)),l},sigma.plugins.killImage=function(){l instanceof g&&(l=null,j=null,k=null)}}.call(this),function(a){"use strict";function b(a,b){var c,d,b=b||"",e=-(1/0),f=1/0,g=1/0,h=-(1/0),i=-(1/0);for(c=0,d=a.length;d>c;c++)e=Math.max(a[c][b+"size"],e),h=Math.max(a[c][b+"x"],h),f=Math.min(a[c][b+"x"],f),i=Math.max(a[c][b+"y"],i),g=Math.min(a[c][b+"y"],g);return e=e||1,{sizeMax:e,minX:f,minY:g,maxX:h,maxY:i}}function c(a,b,c,d,e){return(e-d)*(a-b)/(c-b)+d}function d(a,b,d){return{x:c(a.x,b.minX,b.maxX,d.minX,d.maxX),y:c(a.y,b.minY,b.maxY,d.minY,d.maxY)}}function e(){if("undefined"==typeof dagre)throw new Error("dagre is not declared");if("undefined"==typeof dagre.graphlib)throw new Error("dagre.graphlib is not declared");var a,c=this;this.init=function(a,b){if(b=b||{},b.nodes&&(this.nodes=b.nodes,delete b.nodes),b.boundingBox&&(this.boundingBox=b.boundingBox,delete b.boundingBox),this.sigInst=a,this.config=sigma.utils.extend(b,f),this.easing=b.easing,this.duration=b.duration,this.easing&&(!sigma.plugins||"undefined"==typeof sigma.plugins.animate))throw new Error("sigma.plugins.animate is not declared");this.running=!1},this.start=function(){if(!this.running){this.running=!0,a=new dagre.graphlib.Graph({directed:this.config.directed,multigraph:this.config.multigraph,compound:this.config.compound}),a.setGraph(this.config);for(var d=this.nodes||this.sigInst.graph.nodes(),e=0;e<d.length;e++)d[e].fixed||a.setNode(d[e].id,{});this.boundingBox===!0&&(this.boundingBox=b(d));for(var f=this.sigInst.graph.edges(),e=0;e<f.length;e++)null!=a.node(f[e].source)&&null!=a.node(f[e].target)&&a.setEdge(f[e].source,f[e].target,{id:f[e].id});h[c.sigInst.id].dispatchEvent("start"),dagre.layout(a);var g;a.edges().map(function(b){g=c.sigInst.graph.edges(a.edge(b).id),g.points=a.edge(b).points}),this.stop()}},this.stop=function(){if(a){var e,f=a.nodes().map(function(a){return c.sigInst.graph.nodes(a)||c.sigInst.graph.nodes(Number(a))});if(this.boundingBox)var g=b(a.nodes().map(function(b){return a.node(b)}));if(this.running=!1,this.easing){for(var i=0;i<f.length;i++)this.boundingBox?(e=d(a.node(f[i].id),g,c.boundingBox),f[i].dagre_x=e.x,f[i].dagre_y=e.y):(f[i].dagre_x=a.node(f[i].id).x,f[i].dagre_y=a.node(f[i].id).y);h[c.sigInst.id].dispatchEvent("interpolate"),sigma.plugins.animate(c.sigInst,{x:"dagre_x",y:"dagre_y"},{nodes:f,easing:c.easing,onComplete:function(){for(var a=0;a<f.length;a++)f[a].dagre_x=null,f[a].dagre_y=null;h[c.sigInst.id].dispatchEvent("stop"),c.sigInst.refresh()},duration:c.duration})}else{var j;a.nodes().forEach(function(b){j=c.sigInst.graph.nodes(b),j.x=a.node(b).x,j.y=a.node(b).y}),h[c.sigInst.id].dispatchEvent("stop"),this.sigInst.refresh()}}},this.kill=function(){this.sigInst=null,this.config=null,this.easing=null}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");("undefined"==typeof dagre||"undefined"==typeof dagre.graphlib)&&console.warn("to use the dagre plugin, you have to include dagre and dagre.graphlib"),sigma.utils.pkg("sigma.layouts.dagre");var f={directed:!0,multigraph:!0,compound:!1,rankDir:"TB"},g={},h={};sigma.layouts.dagre.configure=function(a,b){if(!a)throw new Error('Missing argument: "sigInst"');if(!b)throw new Error('Missing argument: "config"');return g[a.id]||(g[a.id]=new e,h[a.id]={},sigma.classes.dispatcher.extend(h[a.id]),a.bind("kill",function(){g[a.id].kill(),g[a.id]=null,h[a.id]=null})),g[a.id].init(a,b),h[a.id]},sigma.layouts.dagre.start=function(a,b){if(!a)throw new Error('Missing argument: "sigInst"');return b&&this.configure(a,b),g[a.id].start(),h[a.id]},sigma.layouts.dagre.isRunning=function(a){if(!a)throw new Error('Missing argument: "sigInst"');return!!g[a.id]&&g[a.id].running}}.call(this),function(undefined){"use strict";function crush(a){var b,c,d,e=["x","y","dx","dy","old_dx","old_dy","mass","convergence","size","fixed"],f=["source","target","weight"],g=["node","centerX","centerY","size","nextSibling","firstChild","mass","massCenterX","massCenterY"];for(c=0,d=g.length;d>c;c++)b=new RegExp("rp\\(([^,]*), '"+g[c]+"'\\)","g"),a=a.replace(b,0===c?"$1":"$1 + "+c);for(c=0,d=e.length;d>c;c++)b=new RegExp("np\\(([^,]*), '"+e[c]+"'\\)","g"),a=a.replace(b,0===c?"$1":"$1 + "+c);for(c=0,d=f.length;d>c;c++)b=new RegExp("ep\\(([^,]*), '"+f[c]+"'\\)","g"),a=a.replace(b,0===c?"$1":"$1 + "+c);return a;
}function getWorkerFn(){var a=crush?crush(Worker.toString()):Worker.toString();return";("+a+").call(this);"}var _root=this,inWebWorker=!("document"in _root),Worker=function(a){function b(){var a,b,c={},d=arguments.length;for(a=d-1;a>=0;a--)for(b in arguments[a])c[b]=arguments[a][b];return c}function c(a){var b;for(b in a)"hasOwnProperty"in a&&!a.hasOwnProperty(b)||delete a[b];return a}function d(a,b){if(a%o.ppn!==0)throw"np: non correct ("+a+").";if(a!==parseInt(a))throw"np: non int.";if(b in p)return a+p[b];throw"ForceAtlas2.Worker - Inexistant node property given ("+b+")."}function e(a,b){if(a%o.ppe!==0)throw"ep: non correct ("+a+").";if(a!==parseInt(a))throw"ep: non int.";if(b in q)return a+q[b];throw"ForceAtlas2.Worker - Inexistant edge property given ("+b+")."}function f(a,b){if(a%o.ppr!==0)throw"rp: non correct ("+a+").";if(a!==parseInt(a))throw"rp: non int.";if(b in r)return a+r[b];throw"ForceAtlas2.Worker - Inexistant region property given ("+b+")."}function g(a,b,c){c=c||{};k=a,l=b,o.nodesLength=k.length,o.edgesLength=l.length,h(c)}function h(a){o.settings=b(a,o.settings)}function i(){var a,b,c,g,h,i,j,n,p,q,r,s,t,u,v;for(c=0;c<o.nodesLength;c+=o.ppn)k[d(c,"old_dx")]=k[d(c,"dx")],k[d(c,"old_dy")]=k[d(c,"dy")],k[d(c,"dx")]=0,k[d(c,"dy")]=0;if(o.settings.outboundAttractionDistribution){for(p=0,c=0;c<o.nodesLength;c+=o.ppn)p+=k[d(c,"mass")];p/=o.nodesLength}if(o.settings.barnesHutOptimize){var w,x,y=1/0,z=-(1/0),A=1/0,B=-(1/0);for(m=[],c=0;c<o.nodesLength;c+=o.ppn)y=Math.min(y,k[d(c,"x")]),z=Math.max(z,k[d(c,"x")]),A=Math.min(A,k[d(c,"y")]),B=Math.max(B,k[d(c,"y")]);for(m[f(0,"node")]=-1,m[f(0,"centerX")]=(y+z)/2,m[f(0,"centerY")]=(A+B)/2,m[f(0,"size")]=Math.max(z-y,B-A),m[f(0,"nextSibling")]=-1,m[f(0,"firstChild")]=-1,m[f(0,"mass")]=0,m[f(0,"massCenterX")]=0,m[f(0,"massCenterY")]=0,a=1,c=0;c<o.nodesLength;c+=o.ppn)for(b=0;;)if(m[f(b,"firstChild")]>=0)w=k[d(c,"x")]<m[f(b,"centerX")]?k[d(c,"y")]<m[f(b,"centerY")]?m[f(b,"firstChild")]:m[f(b,"firstChild")]+o.ppr:k[d(c,"y")]<m[f(b,"centerY")]?m[f(b,"firstChild")]+2*o.ppr:m[f(b,"firstChild")]+3*o.ppr,m[f(b,"massCenterX")]=(m[f(b,"massCenterX")]*m[f(b,"mass")]+k[d(c,"x")]*k[d(c,"mass")])/(m[f(b,"mass")]+k[d(c,"mass")]),m[f(b,"massCenterY")]=(m[f(b,"massCenterY")]*m[f(b,"mass")]+k[d(c,"y")]*k[d(c,"mass")])/(m[f(b,"mass")]+k[d(c,"mass")]),m[f(b,"mass")]+=k[d(c,"mass")],b=w;else{if(m[f(b,"node")]<0){m[f(b,"node")]=c;break}if(m[f(b,"firstChild")]=a*o.ppr,j=m[f(b,"size")]/2,n=m[f(b,"firstChild")],m[f(n,"node")]=-1,m[f(n,"centerX")]=m[f(b,"centerX")]-j,m[f(n,"centerY")]=m[f(b,"centerY")]-j,m[f(n,"size")]=j,m[f(n,"nextSibling")]=n+o.ppr,m[f(n,"firstChild")]=-1,m[f(n,"mass")]=0,m[f(n,"massCenterX")]=0,m[f(n,"massCenterY")]=0,n+=o.ppr,m[f(n,"node")]=-1,m[f(n,"centerX")]=m[f(b,"centerX")]-j,m[f(n,"centerY")]=m[f(b,"centerY")]+j,m[f(n,"size")]=j,m[f(n,"nextSibling")]=n+o.ppr,m[f(n,"firstChild")]=-1,m[f(n,"mass")]=0,m[f(n,"massCenterX")]=0,m[f(n,"massCenterY")]=0,n+=o.ppr,m[f(n,"node")]=-1,m[f(n,"centerX")]=m[f(b,"centerX")]+j,m[f(n,"centerY")]=m[f(b,"centerY")]-j,m[f(n,"size")]=j,m[f(n,"nextSibling")]=n+o.ppr,m[f(n,"firstChild")]=-1,m[f(n,"mass")]=0,m[f(n,"massCenterX")]=0,m[f(n,"massCenterY")]=0,n+=o.ppr,m[f(n,"node")]=-1,m[f(n,"centerX")]=m[f(b,"centerX")]+j,m[f(n,"centerY")]=m[f(b,"centerY")]+j,m[f(n,"size")]=j,m[f(n,"nextSibling")]=m[f(b,"nextSibling")],m[f(n,"firstChild")]=-1,m[f(n,"mass")]=0,m[f(n,"massCenterX")]=0,m[f(n,"massCenterY")]=0,a+=4,w=k[d(m[f(b,"node")],"x")]<m[f(b,"centerX")]?k[d(m[f(b,"node")],"y")]<m[f(b,"centerY")]?m[f(b,"firstChild")]:m[f(b,"firstChild")]+o.ppr:k[d(m[f(b,"node")],"y")]<m[f(b,"centerY")]?m[f(b,"firstChild")]+2*o.ppr:m[f(b,"firstChild")]+3*o.ppr,m[f(b,"mass")]=k[d(m[f(b,"node")],"mass")],m[f(b,"massCenterX")]=k[d(m[f(b,"node")],"x")],m[f(b,"massCenterY")]=k[d(m[f(b,"node")],"y")],m[f(w,"node")]=m[f(b,"node")],m[f(b,"node")]=-1,x=k[d(c,"x")]<m[f(b,"centerX")]?k[d(c,"y")]<m[f(b,"centerY")]?m[f(b,"firstChild")]:m[f(b,"firstChild")]+o.ppr:k[d(c,"y")]<m[f(b,"centerY")]?m[f(b,"firstChild")]+2*o.ppr:m[f(b,"firstChild")]+3*o.ppr,w!==x){m[f(x,"node")]=c;break}b=w}}if(o.settings.barnesHutOptimize)for(q=o.settings.scalingRatio,c=0;c<o.nodesLength;c+=o.ppn)for(b=0;;)if(m[f(b,"firstChild")]>=0){if(u=Math.sqrt(Math.pow(k[d(c,"x")]-m[f(b,"massCenterX")],2)+Math.pow(k[d(c,"y")]-m[f(b,"massCenterY")],2)),2*m[f(b,"size")]/u<o.settings.barnesHutTheta){if(r=k[d(c,"x")]-m[f(b,"massCenterX")],s=k[d(c,"y")]-m[f(b,"massCenterY")],o.settings.adjustSizes?u>0?(v=q*k[d(c,"mass")]*m[f(b,"mass")]/u/u,k[d(c,"dx")]+=r*v,k[d(c,"dy")]+=s*v):0>u&&(v=-q*k[d(c,"mass")]*m[f(b,"mass")]/u,k[d(c,"dx")]+=r*v,k[d(c,"dy")]+=s*v):u>0&&(v=q*k[d(c,"mass")]*m[f(b,"mass")]/u/u,k[d(c,"dx")]+=r*v,k[d(c,"dy")]+=s*v),m[f(b,"nextSibling")]<0)break;b=m[f(b,"nextSibling")];continue}b=m[f(b,"firstChild")]}else{if(m[f(b,"node")]>=0&&m[f(b,"node")]!==c&&(r=k[d(c,"x")]-k[d(m[f(b,"node")],"x")],s=k[d(c,"y")]-k[d(m[f(b,"node")],"y")],u=Math.sqrt(r*r+s*s),o.settings.adjustSizes?u>0?(v=q*k[d(c,"mass")]*k[d(m[f(b,"node")],"mass")]/u/u,k[d(c,"dx")]+=r*v,k[d(c,"dy")]+=s*v):0>u&&(v=-q*k[d(c,"mass")]*k[d(m[f(b,"node")],"mass")]/u,k[d(c,"dx")]+=r*v,k[d(c,"dy")]+=s*v):u>0&&(v=q*k[d(c,"mass")]*k[d(m[f(b,"node")],"mass")]/u/u,k[d(c,"dx")]+=r*v,k[d(c,"dy")]+=s*v)),m[f(b,"nextSibling")]<0)break;b=m[f(b,"nextSibling")]}else for(q=o.settings.scalingRatio,g=0;g<o.nodesLength;g+=o.ppn)for(h=0;g>h;h+=o.ppn)r=k[d(g,"x")]-k[d(h,"x")],s=k[d(g,"y")]-k[d(h,"y")],o.settings.adjustSizes?(u=Math.sqrt(r*r+s*s)-k[d(g,"size")]-k[d(h,"size")],u>0?(v=q*k[d(g,"mass")]*k[d(h,"mass")]/u/u,k[d(g,"dx")]+=r*v,k[d(g,"dy")]+=s*v,k[d(h,"dx")]+=r*v,k[d(h,"dy")]+=s*v):0>u&&(v=100*q*k[d(g,"mass")]*k[d(h,"mass")],k[d(g,"dx")]+=r*v,k[d(g,"dy")]+=s*v,k[d(h,"dx")]-=r*v,k[d(h,"dy")]-=s*v)):(u=Math.sqrt(r*r+s*s),u>0&&(v=q*k[d(g,"mass")]*k[d(h,"mass")]/u/u,k[d(g,"dx")]+=r*v,k[d(g,"dy")]+=s*v,k[d(h,"dx")]-=r*v,k[d(h,"dy")]-=s*v));for(n=o.settings.gravity/o.settings.scalingRatio,q=o.settings.scalingRatio,c=0;c<o.nodesLength;c+=o.ppn)v=0,r=k[d(c,"x")],s=k[d(c,"y")],u=Math.sqrt(Math.pow(r,2)+Math.pow(s,2)),o.settings.strongGravityMode?u>0&&(v=q*k[d(c,"mass")]*n):u>0&&(v=q*k[d(c,"mass")]*n/u),k[d(c,"dx")]-=r*v,k[d(c,"dy")]-=s*v;for(q=1*(o.settings.outboundAttractionDistribution?p:1),i=0;i<o.edgesLength;i+=o.ppe)g=l[e(i,"source")],h=l[e(i,"target")],j=l[e(i,"weight")],t=Math.pow(j,o.settings.edgeWeightInfluence),r=k[d(g,"x")]-k[d(h,"x")],s=k[d(g,"y")]-k[d(h,"y")],o.settings.adjustSizes?(u=Math.sqrt(Math.pow(r,2)+Math.pow(s,2)-k[d(g,"size")]-k[d(h,"size")]),o.settings.linLogMode?o.settings.outboundAttractionDistribution?u>0&&(v=-q*t*Math.log(1+u)/u/k[d(g,"mass")]):u>0&&(v=-q*t*Math.log(1+u)/u):o.settings.outboundAttractionDistribution?u>0&&(v=-q*t/k[d(g,"mass")]):u>0&&(v=-q*t)):(u=Math.sqrt(Math.pow(r,2)+Math.pow(s,2)),o.settings.linLogMode?o.settings.outboundAttractionDistribution?u>0&&(v=-q*t*Math.log(1+u)/u/k[d(g,"mass")]):u>0&&(v=-q*t*Math.log(1+u)/u):o.settings.outboundAttractionDistribution?(u=1,v=-q*t/k[d(g,"mass")]):(u=1,v=-q*t)),u>0&&(k[d(g,"dx")]+=r*v,k[d(g,"dy")]+=s*v,k[d(h,"dx")]-=r*v,k[d(h,"dy")]-=s*v);var C,D,E,F;if(o.settings.adjustSizes)for(c=0;c<o.nodesLength;c+=o.ppn)k[d(c,"fixed")]||(C=Math.sqrt(Math.pow(k[d(c,"dx")],2)+Math.pow(k[d(c,"dy")],2)),C>o.maxForce&&(k[d(c,"dx")]=k[d(c,"dx")]*o.maxForce/C,k[d(c,"dy")]=k[d(c,"dy")]*o.maxForce/C),D=k[d(c,"mass")]*Math.sqrt((k[d(c,"old_dx")]-k[d(c,"dx")])*(k[d(c,"old_dx")]-k[d(c,"dx")])+(k[d(c,"old_dy")]-k[d(c,"dy")])*(k[d(c,"old_dy")]-k[d(c,"dy")])),E=Math.sqrt((k[d(c,"old_dx")]+k[d(c,"dx")])*(k[d(c,"old_dx")]+k[d(c,"dx")])+(k[d(c,"old_dy")]+k[d(c,"dy")])*(k[d(c,"old_dy")]+k[d(c,"dy")]))/2,F=.1*Math.log(1+E)/(1+Math.sqrt(D)),k[d(c,"x")]=k[d(c,"x")]+k[d(c,"dx")]*(F/o.settings.slowDown),k[d(c,"y")]=k[d(c,"y")]+k[d(c,"dy")]*(F/o.settings.slowDown));else for(c=0;c<o.nodesLength;c+=o.ppn)k[d(c,"fixed")]||(D=k[d(c,"mass")]*Math.sqrt((k[d(c,"old_dx")]-k[d(c,"dx")])*(k[d(c,"old_dx")]-k[d(c,"dx")])+(k[d(c,"old_dy")]-k[d(c,"dy")])*(k[d(c,"old_dy")]-k[d(c,"dy")])),E=Math.sqrt((k[d(c,"old_dx")]+k[d(c,"dx")])*(k[d(c,"old_dx")]+k[d(c,"dx")])+(k[d(c,"old_dy")]+k[d(c,"dy")])*(k[d(c,"old_dy")]+k[d(c,"dy")]))/2,F=k[d(c,"convergence")]*Math.log(1+E)/(1+Math.sqrt(D)),k[d(c,"convergence")]=Math.min(1,Math.sqrt(F*(Math.pow(k[d(c,"dx")],2)+Math.pow(k[d(c,"dy")],2))/(1+Math.sqrt(D)))),k[d(c,"x")]=k[d(c,"x")]+k[d(c,"dx")]*(F/o.settings.slowDown),k[d(c,"y")]=k[d(c,"y")]+k[d(c,"dy")]*(F/o.settings.slowDown));o.iterations++}function j(a){for(var b=0;a>b;b++)i();n()}var k,l,m,n,o={ppn:10,ppe:3,ppr:9,maxForce:10,iterations:0,converged:!1,settings:{linLogMode:!1,outboundAttractionDistribution:!1,adjustSizes:!1,edgeWeightInfluence:0,scalingRatio:1,strongGravityMode:!1,gravity:1,slowDown:1,barnesHutOptimize:!1,barnesHutTheta:.5,startingIterations:1,iterationsPerRender:1}},p={x:0,y:1,dx:2,dy:3,old_dx:4,old_dy:5,mass:6,convergence:7,size:8,fixed:9},q={source:0,target:1,weight:2},r={node:0,centerX:1,centerY:2,size:3,nextSibling:4,firstChild:5,mass:6,massCenterX:7,massCenterY:8};n="undefined"!=typeof window&&window.document?function(){var a;document.createEvent?(a=document.createEvent("Event"),a.initEvent("newCoords",!0,!1)):(a=document.createEventObject(),a.eventType="newCoords"),a.eventName="newCoords",a.data={nodes:k.buffer},requestAnimationFrame(function(){document.dispatchEvent(a)})}:function(){self.postMessage({nodes:k.buffer},[k.buffer])};var s=function(a){switch(a.data.action){case"start":g(new Float32Array(a.data.nodes),new Float32Array(a.data.edges),a.data.config),j(o.settings.startingIterations);break;case"loop":k=new Float32Array(a.data.nodes),j(o.settings.iterationsPerRender);break;case"config":h(a.data.config);break;case"kill":c(o),k=null,l=null,m=null,self.removeEventListener("message",s)}};self.addEventListener("message",s)};if(inWebWorker)eval(getWorkerFn());else{if("undefined"==typeof sigma)throw"sigma is not declared";sigma.prototype.getForceAtlas2Worker=getWorkerFn}}.call(this),function(undefined){"use strict";function Supervisor(sigInst,options){var _this=this,workerFn=sigInst.getForceAtlas2Worker&&sigInst.getForceAtlas2Worker();if(options=options||{},_root.URL=_root.URL||_root.webkitURL,this.sigInst=sigInst,this.graph=this.sigInst.graph,this.ppn=10,this.ppe=3,this.config={},this.shouldUseWorker=options.worker===!1?!1:webWorkers,this.workerUrl=options.workerUrl,this.started=!1,this.running=!1,this.shouldUseWorker){if(this.workerUrl)this.worker=new Worker(this.workerUrl);else{var blob=this.makeBlob(workerFn);this.worker=new Worker(URL.createObjectURL(blob))}this.worker.postMessage=this.worker.webkitPostMessage||this.worker.postMessage}else eval(workerFn);this.msgName=this.worker?"message":"newCoords",this.listener=function(a){_this.nodesByteArray=new Float32Array(a.data.nodes),_this.running&&(_this.applyLayoutChanges(),_this.sendByteArrayToWorker(),_this.sigInst.refresh())},(this.worker||document).addEventListener(this.msgName,this.listener),this.graphToByteArrays(),sigInst.bind("kill",function(){sigInst.killForceAtlas2()})}if("undefined"==typeof sigma)throw"sigma is not declared";var _root=this,webWorkers="Worker"in _root;Supervisor.prototype.makeBlob=function(a){var b;try{b=new Blob([a],{type:"application/javascript"})}catch(c){_root.BlobBuilder=_root.BlobBuilder||_root.WebKitBlobBuilder||_root.MozBlobBuilder,b=new BlobBuilder,b.append(a),b=b.getBlob()}return b},Supervisor.prototype.graphToByteArrays=function(){var a,b,c,d=this.graph.nodes(),e=this.graph.edges(),f=d.length*this.ppn,g=e.length*this.ppe,h={};for(this.nodesByteArray=new Float32Array(f),this.edgesByteArray=new Float32Array(g),a=b=0,c=d.length;c>a;a++)h[d[a].id]=b,this.nodesByteArray[b]=d[a].x,this.nodesByteArray[b+1]=d[a].y,this.nodesByteArray[b+2]=0,this.nodesByteArray[b+3]=0,this.nodesByteArray[b+4]=0,this.nodesByteArray[b+5]=0,this.nodesByteArray[b+6]=1+this.graph.degree(d[a].id),this.nodesByteArray[b+7]=1,this.nodesByteArray[b+8]=d[a].size,this.nodesByteArray[b+9]=0,b+=this.ppn;for(a=b=0,c=e.length;c>a;a++)this.edgesByteArray[b]=h[e[a].source],this.edgesByteArray[b+1]=h[e[a].target],this.edgesByteArray[b+2]=e[a].weight||0,b+=this.ppe},Supervisor.prototype.applyLayoutChanges=function(){for(var a=this.graph.nodes(),b=0,c=0,d=this.nodesByteArray.length;d>c;c+=this.ppn)a[b].x=this.nodesByteArray[c],a[b].y=this.nodesByteArray[c+1],b++},Supervisor.prototype.sendByteArrayToWorker=function(a){var b={action:a||"loop",nodes:this.nodesByteArray.buffer},c=[this.nodesByteArray.buffer];"start"===a&&(b.config=this.config||{},b.edges=this.edgesByteArray.buffer,c.push(this.edgesByteArray.buffer)),this.shouldUseWorker?this.worker.postMessage(b,c):_root.postMessage(b,"*")},Supervisor.prototype.start=function(){if(!this.running){this.running=!0;var a,b;for(a in this.sigInst.cameras)b=this.sigInst.cameras[a],b.edgequadtree._enabled=!1;this.started?this.sendByteArrayToWorker():(this.sendByteArrayToWorker("start"),this.started=!0)}},Supervisor.prototype.stop=function(){if(this.running){var a,b,c;for(a in this.sigInst.cameras)b=this.sigInst.cameras[a],b.edgequadtree._enabled=!0,c=sigma.utils.getBoundaries(this.graph,b.readPrefix),b.settings("drawEdges")&&b.settings("enableEdgeHovering")&&b.edgequadtree.index(this.sigInst.graph,{prefix:b.readPrefix,bounds:{x:c.minX,y:c.minY,width:c.maxX-c.minX,height:c.maxY-c.minY}});this.running=!1}},Supervisor.prototype.killWorker=function(){this.worker?this.worker.terminate():(_root.postMessage({action:"kill"},"*"),document.removeEventListener(this.msgName,this.listener))},Supervisor.prototype.configure=function(a){if(this.config=a,this.started){var b={action:"config",config:this.config};this.shouldUseWorker?this.worker.postMessage(b):_root.postMessage(b,"*")}},sigma.prototype.startForceAtlas2=function(a){return this.supervisor||(this.supervisor=new Supervisor(this,a)),a&&this.supervisor.configure(a),this.supervisor.start(),this},sigma.prototype.stopForceAtlas2=function(){return this.supervisor?(this.supervisor.stop(),this):this},sigma.prototype.killForceAtlas2=function(){return this.supervisor?(this.supervisor.stop(),this.supervisor.killWorker(),this.supervisor=null,this):this},sigma.prototype.configForceAtlas2=function(a){return this.supervisor||(this.supervisor=new Supervisor(this,a)),this.supervisor.configure(a),this},sigma.prototype.isForceAtlas2Running=function(a){return!!this.supervisor&&this.supervisor.running}}.call(this),function(undefined){"use strict";function crush(a){var b,c,d,e=["x","y","dx","dy","old_dx","old_dy","mass","convergence","size","fixed"],f=["source","target","weight"],g=["node","centerX","centerY","size","nextSibling","firstChild","mass","massCenterX","massCenterY"];for(c=0,d=g.length;d>c;c++)b=new RegExp("rp\\(([^,]*), '"+g[c]+"'\\)","g"),a=a.replace(b,0===c?"$1":"$1 + "+c);for(c=0,d=e.length;d>c;c++)b=new RegExp("np\\(([^,]*), '"+e[c]+"'\\)","g"),a=a.replace(b,0===c?"$1":"$1 + "+c);for(c=0,d=f.length;d>c;c++)b=new RegExp("ep\\(([^,]*), '"+f[c]+"'\\)","g"),a=a.replace(b,0===c?"$1":"$1 + "+c);return a}function getWorkerFn(){var a=crush?crush(Worker.toString()):Worker.toString();return";("+a+").call(this);"}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.layouts");var _root=this,inWebWorker=!("document"in _root),Worker=function(a){function b(){var a,b,c={},d=arguments.length;for(a=d-1;a>=0;a--)for(b in arguments[a])c[b]=arguments[a][b];return c}function c(a){var b;for(b in a)"hasOwnProperty"in a&&!a.hasOwnProperty(b)||delete a[b];return a}function d(a,b,c,d){return Math.sqrt((c-a)*(c-a)+(d-b)*(d-b))}function e(a,b,c,d,e){return(e-d)*(a-b)/(c-b)+d}function f(a){return Math.acos(a.x/Math.sqrt(a.x*a.x+a.y*a.y))}function g(a,b,c,d){return{xi:-(d-b),yi:c-a,xi_prime:d-b,yi_prime:-(c-a)}}function h(a,b){return{x:(a.xi_prime-a.xi)/b,y:(a.yi_prime-a.yi)/b}}function i(a,b,c,d,e){return{x:a+(c-a)*e,y:b+(d-b)*e}}function j(a,b){if(a%u.ppn!==0)throw new Error('Invalid argument in np: "i" is not correct ('+a+").");if(a!==parseInt(a))throw new TypeError('Invalid argument in np: "i" is not an integer.');if(b in v)return a+v[b];throw new Error("ForceLink.Worker - Inexistant node property given ("+b+").")}function k(a,b){if(a%u.ppe!==0)throw new Error('Invalid argument in ep: "i" is not correct ('+a+").");if(a!==parseInt(a))throw new TypeError('Invalid argument in ep: "i" is not an integer.');if(b in w)return a+w[b];throw new Error("ForceLink.Worker - Inexistant edge property given ("+b+").")}function l(a,b){if(a%u.ppr!==0)throw new Error('Invalid argument in rp: "i" is not correct ('+a+").");if(a!==parseInt(a))throw new TypeError('Invalid argument in rp: "i" is not an integer.');if(b in x)return a+x[b];throw new Error("ForceLink.Worker - Inexistant region property given ("+b+").")}function m(a,b,c){c=c||{};q=a,r=b,u.nodesLength=q.length,u.edgesLength=r.length,n(c)}function n(a){u.settings=b(a,u.settings)}function o(){var a,b,c,m,n,o,p,t,v,w,x,y,z,A,B,C,D,E=u.settings.minNodeDistance;for(c=0;c<u.nodesLength;c+=u.ppn)q[j(c,"old_dx")]=q[j(c,"dx")],q[j(c,"old_dy")]=q[j(c,"dy")],q[j(c,"dx")]=0,q[j(c,"dy")]=0;if(u.settings.outboundAttractionDistribution){for(v=0,c=0;c<u.nodesLength;c+=u.ppn)v+=q[j(c,"mass")];v/=u.nodesLength}if(u.settings.barnesHutOptimize){var F,G,H=1/0,I=-(1/0),J=1/0,K=-(1/0);for(s=[],c=0;c<u.nodesLength;c+=u.ppn)H=Math.min(H,q[j(c,"x")]),I=Math.max(I,q[j(c,"x")]),J=Math.min(J,q[j(c,"y")]),K=Math.max(K,q[j(c,"y")]);for(s[l(0,"node")]=-1,s[l(0,"centerX")]=(H+I)/2,s[l(0,"centerY")]=(J+K)/2,s[l(0,"size")]=Math.max(I-H,K-J),s[l(0,"nextSibling")]=-1,s[l(0,"firstChild")]=-1,s[l(0,"mass")]=0,s[l(0,"massCenterX")]=0,s[l(0,"massCenterY")]=0,a=1,c=0;c<u.nodesLength;c+=u.ppn)for(b=0;;)if(s[l(b,"firstChild")]>=0)F=q[j(c,"x")]<s[l(b,"centerX")]?q[j(c,"y")]<s[l(b,"centerY")]?s[l(b,"firstChild")]:s[l(b,"firstChild")]+u.ppr:q[j(c,"y")]<s[l(b,"centerY")]?s[l(b,"firstChild")]+2*u.ppr:s[l(b,"firstChild")]+3*u.ppr,s[l(b,"massCenterX")]=(s[l(b,"massCenterX")]*s[l(b,"mass")]+q[j(c,"x")]*q[j(c,"mass")])/(s[l(b,"mass")]+q[j(c,"mass")]),s[l(b,"massCenterY")]=(s[l(b,"massCenterY")]*s[l(b,"mass")]+q[j(c,"y")]*q[j(c,"mass")])/(s[l(b,"mass")]+q[j(c,"mass")]),s[l(b,"mass")]+=q[j(c,"mass")],b=F;else{if(s[l(b,"node")]<0){s[l(b,"node")]=c;break}if(s[l(b,"firstChild")]=a*u.ppr,p=s[l(b,"size")]/2,t=s[l(b,"firstChild")],s[l(t,"node")]=-1,s[l(t,"centerX")]=s[l(b,"centerX")]-p,s[l(t,"centerY")]=s[l(b,"centerY")]-p,s[l(t,"size")]=p,s[l(t,"nextSibling")]=t+u.ppr,s[l(t,"firstChild")]=-1,s[l(t,"mass")]=0,s[l(t,"massCenterX")]=0,s[l(t,"massCenterY")]=0,t+=u.ppr,s[l(t,"node")]=-1,s[l(t,"centerX")]=s[l(b,"centerX")]-p,s[l(t,"centerY")]=s[l(b,"centerY")]+p,s[l(t,"size")]=p,s[l(t,"nextSibling")]=t+u.ppr,s[l(t,"firstChild")]=-1,s[l(t,"mass")]=0,s[l(t,"massCenterX")]=0,s[l(t,"massCenterY")]=0,t+=u.ppr,s[l(t,"node")]=-1,s[l(t,"centerX")]=s[l(b,"centerX")]+p,s[l(t,"centerY")]=s[l(b,"centerY")]-p,s[l(t,"size")]=p,s[l(t,"nextSibling")]=t+u.ppr,s[l(t,"firstChild")]=-1,s[l(t,"mass")]=0,s[l(t,"massCenterX")]=0,s[l(t,"massCenterY")]=0,t+=u.ppr,s[l(t,"node")]=-1,s[l(t,"centerX")]=s[l(b,"centerX")]+p,s[l(t,"centerY")]=s[l(b,"centerY")]+p,s[l(t,"size")]=p,s[l(t,"nextSibling")]=s[l(b,"nextSibling")],s[l(t,"firstChild")]=-1,s[l(t,"mass")]=0,s[l(t,"massCenterX")]=0,s[l(t,"massCenterY")]=0,a+=4,F=q[j(s[l(b,"node")],"x")]<s[l(b,"centerX")]?q[j(s[l(b,"node")],"y")]<s[l(b,"centerY")]?s[l(b,"firstChild")]:s[l(b,"firstChild")]+u.ppr:q[j(s[l(b,"node")],"y")]<s[l(b,"centerY")]?s[l(b,"firstChild")]+2*u.ppr:s[l(b,"firstChild")]+3*u.ppr,s[l(b,"mass")]=q[j(s[l(b,"node")],"mass")],s[l(b,"massCenterX")]=q[j(s[l(b,"node")],"x")],s[l(b,"massCenterY")]=q[j(s[l(b,"node")],"y")],s[l(F,"node")]=s[l(b,"node")],s[l(b,"node")]=-1,G=q[j(c,"x")]<s[l(b,"centerX")]?q[j(c,"y")]<s[l(b,"centerY")]?s[l(b,"firstChild")]:s[l(b,"firstChild")]+u.ppr:q[j(c,"y")]<s[l(b,"centerY")]?s[l(b,"firstChild")]+2*u.ppr:s[l(b,"firstChild")]+3*u.ppr,F!==G){s[l(G,"node")]=c;break}b=F}}if(u.settings.barnesHutOptimize)for(w=u.settings.scalingRatio,c=0;c<u.nodesLength;c+=u.ppn)for(b=0;;)if(s[l(b,"firstChild")]>=0){if(C=Math.sqrt((q[j(c,"x")]-s[l(b,"massCenterX")])*(q[j(c,"x")]-s[l(b,"massCenterX")])+(q[j(c,"y")]-s[l(b,"massCenterY")])*(q[j(c,"y")]-s[l(b,"massCenterY")])),2*s[l(b,"size")]/C<u.settings.barnesHutTheta){if(x=q[j(c,"x")]-s[l(b,"massCenterX")],y=q[j(c,"y")]-s[l(b,"massCenterY")],u.settings.adjustSizes?C>0?(D=w*q[j(c,"mass")]*s[l(b,"mass")]/C/C,q[j(c,"dx")]+=x*D,q[j(c,"dy")]+=y*D):0>C&&(D=-w*q[j(c,"mass")]*s[l(b,"mass")]/C,q[j(c,"dx")]+=x*D,q[j(c,"dy")]+=y*D):C>0&&(D=w*q[j(c,"mass")]*s[l(b,"mass")]/C/C,q[j(c,"dx")]+=x*D,q[j(c,"dy")]+=y*D),s[l(b,"nextSibling")]<0)break;b=s[l(b,"nextSibling")];continue}b=s[l(b,"firstChild")]}else{if(s[l(b,"node")]>=0&&s[l(b,"node")]!==c&&(x=q[j(c,"x")]-q[j(s[l(b,"node")],"x")],y=q[j(c,"y")]-q[j(s[l(b,"node")],"y")],C=Math.sqrt(x*x+y*y),u.settings.adjustSizes?C>0?(D=w*q[j(c,"mass")]*q[j(s[l(b,"node")],"mass")]/C/C,q[j(c,"dx")]+=x*D,q[j(c,"dy")]+=y*D):0>C&&(D=-w*q[j(c,"mass")]*q[j(s[l(b,"node")],"mass")]/C,q[j(c,"dx")]+=x*D,q[j(c,"dy")]+=y*D):C>0&&(D=w*q[j(c,"mass")]*q[j(s[l(b,"node")],"mass")]/C/C,q[j(c,"dx")]+=x*D,q[j(c,"dy")]+=y*D)),s[l(b,"nextSibling")]<0)break;b=s[l(b,"nextSibling")]}else for(w=u.settings.scalingRatio,m=0;m<u.nodesLength;m+=u.ppn)for(n=0;m>n;n+=u.ppn)x=q[j(m,"x")]-q[j(n,"x")],y=q[j(m,"y")]-q[j(n,"y")],u.settings.adjustSizes?(C=Math.sqrt(x*x+y*y)-q[j(m,"size")]-q[j(n,"size")],C>0?(D=w*q[j(m,"mass")]*q[j(n,"mass")]/C/C,q[j(m,"dx")]+=x*D,q[j(m,"dy")]+=y*D,q[j(n,"dx")]+=x*D,q[j(n,"dy")]+=y*D):0>C&&(D=100*w*q[j(m,"mass")]*q[j(n,"mass")],q[j(m,"dx")]+=x*D,q[j(m,"dy")]+=y*D,q[j(n,"dx")]-=x*D,q[j(n,"dy")]-=y*D)):(C=Math.sqrt(x*x+y*y),C>0&&(D=w*q[j(m,"mass")]*q[j(n,"mass")]/C/C,q[j(m,"dx")]+=x*D,q[j(m,"dy")]+=y*D,q[j(n,"dx")]-=x*D,q[j(n,"dy")]-=y*D));for(t=u.settings.gravity/u.settings.scalingRatio,w=u.settings.scalingRatio,c=0;c<u.nodesLength;c+=u.ppn)D=0,x=q[j(c,"x")],y=q[j(c,"y")],C=Math.sqrt(x*x+y*y),u.settings.strongGravityMode?C>0&&(D=w*q[j(c,"mass")]*t):C>0&&(D=w*q[j(c,"mass")]*t/C),q[j(c,"dx")]-=x*D,q[j(c,"dy")]-=y*D;for(w=1*(u.settings.outboundAttractionDistribution?v:1),o=0;o<u.edgesLength;o+=u.ppe)m=r[k(o,"source")],n=r[k(o,"target")],p=r[k(o,"weight")],B=Math.pow(p,u.settings.edgeWeightInfluence),x=q[j(m,"x")]-q[j(n,"x")],y=q[j(m,"y")]-q[j(n,"y")],u.settings.adjustSizes?(C=Math.sqrt(x*x+y*y-q[j(m,"size")]-q[j(n,"size")])-E,u.settings.linLogMode?u.settings.outboundAttractionDistribution?C>0&&(D=-w*B*Math.log(1+C)/C/q[j(m,"mass")]):C>0&&(D=-w*B*Math.log(1+C)/C):u.settings.outboundAttractionDistribution?C>0&&(D=-w*B/q[j(m,"mass")]):C>0&&(D=-w*B)):(C=Math.sqrt(x*x+y*y)-E,u.settings.linLogMode?u.settings.outboundAttractionDistribution?C>0&&(D=-w*B*Math.log(1+C)/C/q[j(m,"mass")]):C>0&&(D=-w*B*Math.log(1+C)/C):u.settings.outboundAttractionDistribution?(C=1,D=-w*B/q[j(m,"mass")]):(C=1,D=-w*B)),C>0&&(q[j(m,"dx")]+=x*D,q[j(m,"dy")]+=y*D,q[j(n,"dx")]-=x*D,q[j(n,"dy")]-=y*D);var L,M,N,O,P=0;if(u.settings.adjustSizes)for(c=0;c<u.nodesLength;c+=u.ppn)q[j(c,"fixed")]||(L=Math.sqrt(q[j(c,"dx")]*q[j(c,"dx")]+q[j(c,"dy")]*q[j(c,"dy")]),L>u.maxForce&&(q[j(c,"dx")]=q[j(c,"dx")]*u.maxForce/L,q[j(c,"dy")]=q[j(c,"dy")]*u.maxForce/L),M=q[j(c,"mass")]*Math.sqrt((q[j(c,"old_dx")]-q[j(c,"dx")])*(q[j(c,"old_dx")]-q[j(c,"dx")])+(q[j(c,"old_dy")]-q[j(c,"dy")])*(q[j(c,"old_dy")]-q[j(c,"dy")])),N=Math.sqrt((q[j(c,"old_dx")]+q[j(c,"dx")])*(q[j(c,"old_dx")]+q[j(c,"dx")])+(q[j(c,"old_dy")]+q[j(c,"dy")])*(q[j(c,"old_dy")]+q[j(c,"dy")]))/2,O=.1*Math.log(1+N)/(1+Math.sqrt(M)),z=q[j(c,"x")],A=q[j(c,"y")],q[j(c,"x")]=q[j(c,"x")]+q[j(c,"dx")]*(O/u.settings.slowDown),q[j(c,"y")]=q[j(c,"y")]+q[j(c,"dy")]*(O/u.settings.slowDown),x=q[j(c,"x")],y=q[j(c,"y")],C=Math.sqrt((x-z)*(x-z)+(y-A)*(y-A)),P+=C);else for(c=0;c<u.nodesLength;c+=u.ppn)q[j(c,"fixed")]||(M=q[j(c,"mass")]*Math.sqrt((q[j(c,"old_dx")]-q[j(c,"dx")])*(q[j(c,"old_dx")]-q[j(c,"dx")])+(q[j(c,"old_dy")]-q[j(c,"dy")])*(q[j(c,"old_dy")]-q[j(c,"dy")])),N=Math.sqrt((q[j(c,"old_dx")]+q[j(c,"dx")])*(q[j(c,"old_dx")]+q[j(c,"dx")])+(q[j(c,"old_dy")]+q[j(c,"dy")])*(q[j(c,"old_dy")]+q[j(c,"dy")]))/2,O=q[j(c,"convergence")]*Math.log(1+N)/(1+Math.sqrt(M)),q[j(c,"convergence")]=Math.min(1,Math.sqrt(O*(q[j(c,"dx")]*q[j(c,"dx")]+q[j(c,"dy")]*q[j(c,"dy")])/(1+Math.sqrt(M)))),z=q[j(c,"x")],A=q[j(c,"y")],q[j(c,"x")]=q[j(c,"x")]+q[j(c,"dx")]*(O/u.settings.slowDown),q[j(c,"y")]=q[j(c,"y")]+q[j(c,"dy")]*(O/u.settings.slowDown),x=q[j(c,"x")],y=q[j(c,"y")],C=Math.sqrt((x-z)*(x-z)+(y-A)*(y-A)),P+=C);if(u.iterations++,u.settings.autoStop&&(u.converged=u.iterations>u.settings.maxIterations||P/u.nodesLength<u.settings.avgDistanceThreshold,u.converged&&u.settings.alignNodeSiblings)){var Q,R,S={},T={};for(o=0;o<u.edgesLength;o+=u.ppe)m=r[k(o,"source")],n=r[k(o,"target")],m!==n&&(S[m]=S[m]||{},S[n]=S[n]||{},S[m][n]=!0,S[n][m]=!0);Object.keys(S).forEach(function(a){a=~~a,R=Object.keys(S[a]),2==R.length&&(Q=R[0]+";"+R[1],Q in T?T[Q].push(a):(Q=R[1]+";"+R[0],T[Q]||(T[Q]=[~~R[1],~~R[0]]),T[Q].push(a)))});var U,V,W,X,Y,Z,$,_,aa,ba,ca,da,ea,fa,ga,ha=u.settings.nodeSiblingsAngleMin;Object.keys(T).forEach(function(a){if(V=T[a].shift(),W=T[a].shift(),U=T[a].filter(function(a){return!q[j(a,"fixed")]}),1!=U.length){if(Z=q[j(V,"x")],$=q[j(V,"y")],_=q[j(W,"x")],aa=q[j(W,"y")],X=Object.keys(S[V]).length,Y=Object.keys(S[W]).length,ba=e(X/(X+Y),0,1,.25,.75),da=i(Z,$,_,aa,ba),ea=g(Z,$,_,aa),ca=d(Z,$,_,aa),fa=h(ea,ca),ga=f(fa),2*ha>Math.PI)throw new Error("ForceLink.Worker - Invalid parameter: angleMin must be smaller than 2 PI.");ha>0&&(ha>ga||ga>Math.PI-ha&&ga<=Math.PI?fa={x:2*Math.cos(Math.PI-ha),y:2*Math.sin(Math.PI-ha)}:(ga>2*Math.PI-ha||ga>=Math.PI&&ga<Math.PI+ha)&&(fa={x:2*Math.cos(ha),y:2*Math.sin(ha)}));var b=0,c=1,k=1;U.length%2==1&&(k=0,b=1);for(var l=0;l<U.length;l++)q[j(U[l],"x")]=da.x+c*fa.x*k*(b||l>=2?u.settings.nodeSiblingsScale:2*u.settings.nodeSiblingsScale/3),q[j(U[l],"y")]=da.y+c*fa.y*k*(b||l>=2?u.settings.nodeSiblingsScale:2*u.settings.nodeSiblingsScale/3),c=-c,k+=(l+b)%2}})}}function p(a){for(var b=0;a>b;b++)o();t()}var q,r,s,t,u={ppn:10,ppe:3,ppr:9,maxForce:10,iterations:0,converged:!1,settings:{linLogMode:!1,outboundAttractionDistribution:!1,adjustSizes:!1,edgeWeightInfluence:0,scalingRatio:1,strongGravityMode:!1,gravity:1,slowDown:1,barnesHutOptimize:!1,barnesHutTheta:.5,startingIterations:1,iterationsPerRender:1,maxIterations:1e3,avgDistanceThreshold:.01,autoStop:!1,alignNodeSiblings:!1,nodeSiblingsScale:1,nodeSiblingsAngleMin:0,minNodeDistance:0}},v={x:0,y:1,dx:2,dy:3,old_dx:4,old_dy:5,mass:6,convergence:7,size:8,fixed:9},w={source:0,target:1,weight:2},x={node:0,centerX:1,centerY:2,size:3,nextSibling:4,firstChild:5,mass:6,massCenterX:7,massCenterY:8};t="undefined"!=typeof window&&window.document?function(){if(!u.autoStop||u.converged){var a;document.createEvent?(a=document.createEvent("Event"),a.initEvent("newCoords",!0,!1)):(a=document.createEventObject(),a.eventType="newCoords"),a.eventName="newCoords",a.data={nodes:q.buffer,converged:u.converged},requestAnimationFrame(function(){document.dispatchEvent(a)})}}:function(){(!u.autoStop||u.converged)&&self.postMessage({nodes:q.buffer,converged:u.converged},[q.buffer])};var y=function(a){switch(a.data.action){case"start":m(new Float32Array(a.data.nodes),new Float32Array(a.data.edges),a.data.config),p(u.settings.startingIterations);break;case"loop":q=new Float32Array(a.data.nodes),p(u.settings.iterationsPerRender);break;case"config":n(a.data.config);break;case"kill":c(u),q=null,r=null,s=null,self.removeEventListener("message",y)}};self.addEventListener("message",y)};if(inWebWorker)eval(getWorkerFn());else{if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.layouts.getForceLinkWorker=getWorkerFn}}.call(this),function(undefined){"use strict";function Supervisor(a,b){_root.URL=_root.URL||_root.webkitURL,b=b||{},this.sigInst=a,this.graph=this.sigInst.graph,this.ppn=10,this.ppe=3,this.config={},this.worker=null,this.shouldUseWorker=null,this.workerUrl=null,this.runOnBackground=null,this.easing=null,this.randomize=null,this.configure(b),this.started=!1,this.running=!1,this.initWorker()}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.layouts");var _root=this,webWorkers="Worker"in _root,eventEmitter={};sigma.classes.dispatcher.extend(eventEmitter),Supervisor.prototype.makeBlob=function(a){var b;try{b=new Blob([a],{type:"application/javascript"})}catch(c){_root.BlobBuilder=_root.BlobBuilder||_root.WebKitBlobBuilder||_root.MozBlobBuilder,b=new BlobBuilder,b.append(a),b=b.getBlob()}return b},Supervisor.prototype.graphToByteArrays=function(){var a,b,c,d=this.graph.nodes(),e=this.graph.edges(),f=d.length*this.ppn,g=e.length*this.ppe,h={};for(this.nodesByteArray=new Float32Array(f),this.edgesByteArray=new Float32Array(g),a=b=0,c=d.length;c>a;a++)h[d[a].id]=b,this.nodesByteArray[b]=this.randomize(d[a].x),this.nodesByteArray[b+1]=this.randomize(d[a].y),this.nodesByteArray[b+2]=0,this.nodesByteArray[b+3]=0,this.nodesByteArray[b+4]=0,this.nodesByteArray[b+5]=0,this.nodesByteArray[b+6]=1+this.graph.degree(d[a].id),this.nodesByteArray[b+7]=1,this.nodesByteArray[b+8]=d[a].size,this.nodesByteArray[b+9]=d[a].fixed||0,b+=this.ppn;for(a=b=0,c=e.length;c>a;a++)this.edgesByteArray[b]=h[e[a].source],this.edgesByteArray[b+1]=h[e[a].target],this.edgesByteArray[b+2]=e[a].weight||0,b+=this.ppe},Supervisor.prototype.applyLayoutChanges=function(a){for(var b=this.graph.nodes(),c=0,d=0,e=this.nodesByteArray.length;e>d;d+=this.ppn)b[c].fixed||(a?(b[c].fa2_x=this.nodesByteArray[d],b[c].fa2_y=this.nodesByteArray[d+1]):(b[c].x=this.nodesByteArray[d],b[c].y=this.nodesByteArray[d+1])),c++},Supervisor.prototype.sendByteArrayToWorker=function(a){var b={action:a||"loop",nodes:this.nodesByteArray.buffer},c=[this.nodesByteArray.buffer];"start"===a&&(b.config=this.config||{},b.edges=this.edgesByteArray.buffer,c.push(this.edgesByteArray.buffer)),this.shouldUseWorker?this.worker.postMessage(b,c):_root.postMessage(b,"*")},Supervisor.prototype.start=function(){this.running||(this.running=!0,this.started?this.sendByteArrayToWorker():(this.sendByteArrayToWorker("start"),this.started=!0,eventEmitter.dispatchEvent("start")))},Supervisor.prototype.stop=function(){this.running&&(this.running=!1,eventEmitter.dispatchEvent("stop"))},Supervisor.prototype.initWorker=function(){var _this=this,workerFn=sigma.layouts.getForceLinkWorker();if(this.shouldUseWorker){if(this.workerUrl)this.worker=new Worker(this.workerUrl);else{var blob=this.makeBlob(workerFn);this.worker=new Worker(URL.createObjectURL(blob))}this.worker.postMessage=this.worker.webkitPostMessage||this.worker.postMessage}else eval(workerFn);this.msgName=this.worker?"message":"newCoords",this.listener=function(a){_this.nodesByteArray=new Float32Array(a.data.nodes),_this.running&&(_this.applyLayoutChanges(_this.runOnBackground),_this.sendByteArrayToWorker(),_this.runOnBackground||_this.sigInst.refresh({skipIndexation:!0})),a.data.converged&&(_this.running=!1),_this.running||(_this.killWorker(),_this.runOnBackground&&_this.easing?(_this.applyLayoutChanges(!0),eventEmitter.dispatchEvent("interpolate"),_this.graph.nodes().filter(function(a){return a.fixed}).forEach(function(a){a.fa2_x=a.x,a.fa2_y=a.y}),sigma.plugins.animate(_this.sigInst,{x:"fa2_x",y:"fa2_y"},{easing:_this.easing,onComplete:function(){_this.sigInst.refresh(),eventEmitter.dispatchEvent("stop")}})):(_this.applyLayoutChanges(!1),_this.sigInst.refresh(),eventEmitter.dispatchEvent("stop")))},(this.worker||document).addEventListener(this.msgName,this.listener),this.graphToByteArrays(),_this.sigInst.bind("kill",function(){sigma.layouts.killForceLink()})},Supervisor.prototype.killWorker=function(){this.worker?this.worker.terminate():(_root.postMessage({action:"kill"},"*"),document.removeEventListener(this.msgName,this.listener))},Supervisor.prototype.configure=function(a){switch(this.config=a,this.shouldUseWorker=a.worker===!1?!1:webWorkers,this.workerUrl=a.workerUrl,this.runOnBackground=a.background?!0:!1,this.easing=a.easing,
a.randomize){case"globally":this.randomize=function(b){return Math.random()*(a.randomizeFactor||1)};break;case"locally":this.randomize=function(b){return b+Math.random()*(a.randomizeFactor||1)};break;default:this.randomize=function(a){return a}}if(this.started){var b={action:"config",config:this.config};this.shouldUseWorker?this.worker.postMessage(b):_root.postMessage(b,"*")}};var supervisor=null;sigma.layouts.startForceLink=function(a,b){return supervisor?supervisor.running||(supervisor.killWorker(),supervisor.initWorker(),supervisor.started=!1):supervisor=new Supervisor(a,b),b&&supervisor.configure(b),supervisor.start(),eventEmitter},sigma.layouts.stopForceLink=function(){return supervisor?(supervisor.stop(),supervisor):void 0},sigma.layouts.killForceLink=function(){supervisor&&(supervisor.stop(),supervisor.killWorker(),supervisor=null,eventEmitter={},sigma.classes.dispatcher.extend(eventEmitter))},sigma.layouts.configForceLink=function(a,b){return supervisor?supervisor.running||(supervisor.killWorker(),supervisor.initWorker(),supervisor.started=!1):supervisor=new Supervisor(a,b),supervisor.configure(b),eventEmitter},sigma.layouts.isForceLinkRunning=function(){return!!supervisor&&supervisor.running}}.call(this),function(a){"use strict";function b(){var a=this;this.init=function(a,b){if(b=b||{},this.sigInst=a,this.config=sigma.utils.extend(b,c),this.easing=b.easing,this.duration=b.duration,!sigma.plugins||"undefined"==typeof sigma.plugins.animate)throw new Error("sigma.plugins.animate is not declared");this.running=!1},this.atomicGo=function(){if(!this.running||this.iterCount<1)return!1;var b,c,d,e,f,g,h,i,j,k=this.sigInst.graph.nodes(),l=this.sigInst.graph.edges(),m=k.length,n=l.length;this.config.area=this.config.autoArea?m*m:this.config.area,this.iterCount--,this.running=this.iterCount>0;var o=Math.sqrt(this.config.area)/10,p=Math.sqrt(this.config.area/(1+m));for(b=0;m>b;b++)for(d=k[b],d.fr||(d.fr_x=d.x,d.fr_y=d.y,d.fr={dx:0,dy:0}),c=0;m>c;c++)e=k[c],d.id!=e.id&&(g=d.fr_x-e.fr_x,h=d.fr_y-e.fr_y,i=Math.sqrt(g*g+h*h)+.01,i>0&&(j=p*p/i,d.fr.dx+=g/i*j,d.fr.dy+=h/i*j));var q,r,s;for(b=0;n>b;b++)f=l[b],q=a.sigInst.graph.nodes(f.source),r=a.sigInst.graph.nodes(f.target),g=q.fr_x-r.fr_x,h=q.fr_y-r.fr_y,i=Math.sqrt(g*g+h*h)+.01,s=i*i/p,i>0&&(q.fr.dx-=g/i*s,q.fr.dy-=h/i*s,r.fr.dx+=g/i*s,r.fr.dy+=h/i*s);var t,u,v;for(b=0;m>b;b++)d=k[b],t=Math.sqrt(d.fr_x*d.fr_x+d.fr_y*d.fr_y),u=.01*p*a.config.gravity*t,d.fr.dx-=u*d.fr_x/t,d.fr.dy-=u*d.fr_y/t,d.fr.dx*=a.config.speed,d.fr.dy*=a.config.speed,d.fixed||(g=d.fr.dx,h=d.fr.dy,i=Math.sqrt(g*g+h*h),i>0&&(v=Math.min(o*a.config.speed,i),d.fr_x+=g/i*v,d.fr_y+=h/i*v));return this.running},this.go=function(){for(this.iterCount=this.config.iterations;this.running;)this.atomicGo();this.stop()},this.start=function(){if(!this.running){var b=this.sigInst.graph.nodes();this.running=!0;for(var c=0;c<b.length;c++)b[c].fr_x=b[c].x,b[c].fr_y=b[c].y,b[c].fr={dx:0,dy:0};e[a.sigInst.id].dispatchEvent("start"),this.go()}},this.stop=function(){var b=this.sigInst.graph.nodes();if(this.running=!1,this.easing)e[a.sigInst.id].dispatchEvent("interpolate"),sigma.plugins.animate(a.sigInst,{x:"fr_x",y:"fr_y"},{easing:a.easing,onComplete:function(){a.sigInst.refresh();for(var c=0;c<b.length;c++)b[c].fr=null,b[c].fr_x=null,b[c].fr_y=null;e[a.sigInst.id].dispatchEvent("stop")},duration:a.duration});else{for(var c=0;c<b.length;c++)b[c].x=b[c].fr_x,b[c].y=b[c].fr_y;this.sigInst.refresh();for(var c=0;c<b.length;c++)b[c].fr=null,b[c].fr_x=null,b[c].fr_y=null;e[a.sigInst.id].dispatchEvent("stop")}},this.kill=function(){this.sigInst=null,this.config=null,this.easing=null}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.layouts.fruchtermanReingold");var c={autoArea:!0,area:1,gravity:10,speed:.1,iterations:1e3},d={},e={};sigma.layouts.fruchtermanReingold.configure=function(a,c){if(!a)throw new Error('Missing argument: "sigInst"');if(!c)throw new Error('Missing argument: "config"');return d[a.id]||(d[a.id]=new b,e[a.id]={},sigma.classes.dispatcher.extend(e[a.id]),a.bind("kill",function(){d[a.id].kill(),d[a.id]=null,e[a.id]=null})),d[a.id].init(a,c),e[a.id]},sigma.layouts.fruchtermanReingold.start=function(a,b){if(!a)throw new Error('Missing argument: "sigInst"');return b&&this.configure(a,b),d[a.id].start(),e[a.id]},sigma.layouts.fruchtermanReingold.isRunning=function(a){if(!a)throw new Error('Missing argument: "sigInst"');return!!d[a.id]&&d[a.id].running},sigma.layouts.fruchtermanReingold.progress=function(a){if(!a)throw new Error('Missing argument: "sigInst"');return(d[a.id].config.iterations-d[a.id].iterCount)/d[a.id].config.iterations}}.call(this),function(a){"use strict";function b(){var a=this;this.init=function(a,b){if(b=b||{},this.sigInst=a,this.config=sigma.utils.extend(b,c),this.easing=b.easing,this.duration=b.duration,b.nodes&&(this.nodes=b.nodes,delete b.nodes),!sigma.plugins||"undefined"==typeof sigma.plugins.animate)throw new Error("sigma.plugins.animate is not declared");this.running=!1},this.atomicGo=function(){if(!this.running||this.iterCount<1)return!1;var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w=this.nodes||this.sigInst.graph.nodes(),x=w.length,y=1/0,z=-(1/0),A=1/0,B=-(1/0);for(this.iterCount--,this.running=!1,b=0;x>b;b++)c=w[b],c.dn.dx=0,c.dn.dy=0,y=Math.min(y,c.dn_x-(c.dn_size*a.config.scaleNodes+a.config.nodeMargin)),z=Math.max(z,c.dn_x+(c.dn_size*a.config.scaleNodes+a.config.nodeMargin)),A=Math.min(A,c.dn_y-(c.dn_size*a.config.scaleNodes+a.config.nodeMargin)),B=Math.max(B,c.dn_y+(c.dn_size*a.config.scaleNodes+a.config.nodeMargin));for(e=z-y,f=B-A,g=(y+z)/2,h=(A+B)/2,y=g-a.config.permittedExpansion*e/2,z=g+a.config.permittedExpansion*e/2,A=h-a.config.permittedExpansion*f/2,B=h+a.config.permittedExpansion*f/2,i={},j=0;j<a.config.gridSize;j++)for(i[j]={},k=0;k<a.config.gridSize;k++)i[j][k]=[];for(b=0;x>b;b++)for(c=w[b],s=c.dn_x-(c.dn_size*a.config.scaleNodes+a.config.nodeMargin),t=c.dn_x+(c.dn_size*a.config.scaleNodes+a.config.nodeMargin),u=c.dn_y-(c.dn_size*a.config.scaleNodes+a.config.nodeMargin),v=c.dn_y+(c.dn_size*a.config.scaleNodes+a.config.nodeMargin),l=Math.floor(a.config.gridSize*(s-y)/(z-y)),m=Math.floor(a.config.gridSize*(t-y)/(z-y)),n=Math.floor(a.config.gridSize*(u-A)/(B-A)),o=Math.floor(a.config.gridSize*(v-A)/(B-A)),k=l;m>=k;k++)for(j=n;o>=j;j++)i[j][k].push(c.id);for(p={},j=0;j<a.config.gridSize;j++)for(k=0;k<a.config.gridSize;k++)i[j][k].forEach(function(b){for(p[b]||(p[b]=[]),q=Math.max(0,j-1);q<=Math.min(j+1,a.config.gridSize-1);q++)for(r=Math.max(0,k-1);r<=Math.min(k+1,a.config.gridSize-1);r++)i[q][r].forEach(function(a){a!==b&&-1===p[b].indexOf(a)&&p[b].push(a)})});for(b=0;x>b;b++)d=w[b],p[d.id].forEach(function(b){var c=a.sigInst.graph.nodes(b),g=c.dn_x-d.dn_x,h=c.dn_y-d.dn_y,i=Math.sqrt(g*g+h*h),j=i<d.dn_size*a.config.scaleNodes+a.config.nodeMargin+(c.dn_size*a.config.scaleNodes+a.config.nodeMargin);j&&(a.running=!0,i>0?(c.dn.dx+=g/i*(1+d.dn_size),c.dn.dy+=h/i*(1+d.dn_size)):(c.dn.dx+=.01*e*(.5-Math.random()),c.dn.dy+=.01*f*(.5-Math.random())))});for(b=0;x>b;b++)c=w[b],c.fixed||(c.dn_x=c.dn_x+.1*c.dn.dx*a.config.speed,c.dn_y=c.dn_y+.1*c.dn.dy*a.config.speed);return this.running&&this.iterCount<1&&(this.running=!1),this.running},this.go=function(){for(this.iterCount=this.config.maxIterations;this.running;)this.atomicGo();this.stop()},this.start=function(){if(!this.running){var b=this.sigInst.graph.nodes(),c=this.sigInst.renderers[a.config.rendererIndex].options.prefix;this.running=!0;for(var d=0;d<b.length;d++)b[d].dn_x=b[d][c+"x"],b[d].dn_y=b[d][c+"y"],b[d].dn_size=b[d][c+"size"],b[d].dn={dx:0,dy:0};e[a.sigInst.id].dispatchEvent("start"),this.go()}},this.stop=function(){var b=this.sigInst.graph.nodes();if(this.running=!1,this.easing)e[a.sigInst.id].dispatchEvent("interpolate"),sigma.plugins.animate(a.sigInst,{x:"dn_x",y:"dn_y"},{easing:a.easing,onComplete:function(){a.sigInst.refresh();for(var c=0;c<b.length;c++)b[c].dn=null,b[c].dn_x=null,b[c].dn_y=null;e[a.sigInst.id].dispatchEvent("stop")},duration:a.duration});else{for(var c=0;c<b.length;c++)b[c].x=b[c].dn_x,b[c].y=b[c].dn_y;this.sigInst.refresh();for(var c=0;c<b.length;c++)b[c].dn=null,b[c].dn_x=null,b[c].dn_y=null;e[a.sigInst.id].dispatchEvent("stop")}},this.kill=function(){this.sigInst=null,this.config=null,this.easing=null}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.layouts.noverlap");var c={speed:3,scaleNodes:1.2,nodeMargin:5,gridSize:20,permittedExpansion:1.1,rendererIndex:0,maxIterations:500},d={},e={};sigma.prototype.configNoverlap=function(a){var c=this;if(!a)throw new Error('Missing argument: "config"');return d[c.id]||(d[c.id]=new b,e[c.id]={},sigma.classes.dispatcher.extend(e[c.id]),c.bind("kill",function(){d[c.id].kill(),d[c.id]=null,e[c.id]=null})),d[c.id].init(c,a),e[c.id]},sigma.prototype.startNoverlap=function(a){var b=this;return a&&this.configNoverlap(b,a),d[b.id].start(),e[b.id]},sigma.prototype.isNoverlapRunning=function(){var a=this;return!!d[a.id]&&d[a.id].running}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.neo4j"),sigma.utils.pkg("sigma.utils"),sigma.utils.pkg("sigma.parsers"),sigma.neo4j.send=function(a,b,c,d,e,f){var g,h,i,j=sigma.utils.xhr(),f=f||-1;if(g=a,"object"==typeof a&&(g=a.url,h=a.user,i=a.password),!j)throw"XMLHttpRequest not supported, cannot load the file.";g+=b,j.open(c,g,!0),h&&i&&j.setRequestHeader("Authorization","Basic "+btoa(h+":"+i)),j.setRequestHeader("Accept","application/json"),j.setRequestHeader("Content-type","application/json; charset=utf-8"),f>0&&j.setRequestHeader("max-execution-time",f),j.onreadystatechange=function(){4===j.readyState&&e(JSON.parse(j.responseText))},j.send(d)},sigma.neo4j.cypher_parse=function(a){var b,c={nodes:[],edges:[]},d={},e={};Array.isArray(a)||(a=a.results[0].data),a.forEach(function(a){a.graph.nodes.forEach(function(a){var b={id:a.id,label:a.id,x:Math.random(),y:Math.random(),size:1,neo4j_labels:a.labels,neo4j_data:a.properties};b.id in d||(d[b.id]=b)}),a.graph.relationships.forEach(function(a){var b={id:a.id,label:a.type,source:a.startNode,target:a.endNode,neo4j_type:a.type,neo4j_data:a.properties};b.id in e||(e[b.id]=b)})});for(b in d)c.nodes.push(d[b]);for(b in e)c.edges.push(e[b]);return c},sigma.neo4j.cypher=function(a,b,c,d,e){var f,g,h="/db/data/transaction/commit",e=e||-1;f=JSON.stringify({statements:[{statement:b,resultDataContents:["graph"],includeStats:!1}]}),g=function(a){return function(b){if(b.errors.length>0)return a(null,b.errors);var d={nodes:[],edges:[]};d=sigma.neo4j.cypher_parse(b),c instanceof sigma?(c.graph.clear(),c.graph.read(d)):"object"==typeof c?(c=new sigma(c),c.graph.read(d),c.refresh()):"function"==typeof c&&(a=c,c=null),a&&a(c||d)}},sigma.neo4j.send(a,h,"POST",f,g(d),e)},sigma.neo4j.getLabels=function(a,b){sigma.neo4j.send(a,"/db/data/labels","GET",null,b)},sigma.neo4j.getTypes=function(a,b){sigma.neo4j.send(a,"/db/data/relationship/types","GET",null,b)}}.call(this),function(a){"use strict";function b(a){var b={id:a.id,label:a.label};return a.viz&&(b.viz=a.viz),a.attributes&&(b.attributes=a.attributes),b}function c(a){var b={id:a.id,type:a.type||"undirected",label:a.label||"",source:a.source,target:a.target,weight:+a.weight||1};return a.viz&&(b.viz=a.viz),a.attributes&&(b.attributes=a.attributes),b}function d(a){function d(){var a={};return l.els.meta?(a.lastmodifieddate=l.els.meta.getAttribute("lastmodifieddate"),h.nodeListEach(l.els.meta.childNodes,function(b){a[b.tagName.toLowerCase()]=b.textContent}),a):a}function e(a){var b=[];return l.els.model[a]&&h.nodeListEach(l.els.model[a],function(a){var c={id:a.getAttribute("id")||a.getAttribute("for"),type:a.getAttribute("type")||"string",title:a.getAttribute("title")||""},d=h.nodeListToArray(a.childNodes);d.length>0&&(c.defaultValue=d[0].textContent),b.push(c)}),b.length>0?b:!1}function f(a,b){var c={},d=b.getElementsByTagName("attvalue"),e=h.nodeListToHash(d,function(a){var b=h.namedNodeMapToObject(a.attributes),c=b.id||b["for"];return{key:c,value:b.value}});return a.map(function(a){c[a.id]=!(a.id in e)&&"defaultValue"in a?h.enforceType(a.type,a.defaultValue):h.enforceType(a.type,e[a.id])}),c}function g(a){var c=[];return h.nodeListEach(l.els.nodes,function(d){var e={id:d.getAttribute("id"),label:d.getAttribute("label")||""};a&&(e.attributes=f(a,d)),l.hasViz&&(e.viz=i(d)),c.push(b(e))}),c}function i(a){var b={},c=h.getFirstElementByTagNS(a,"viz","color");if(c){var d=["r","g","b","a"].map(function(a){return c.getAttribute(a)});b.color=h.getRGB(d)}var e=h.getFirstElementByTagNS(a,"viz","position");e&&(b.position={},["x","y","z"].map(function(a){b.position[a]=+e.getAttribute(a)}));var f=h.getFirstElementByTagNS(a,"viz","size");f&&(b.size=+f.getAttribute("value"));var g=h.getFirstElementByTagNS(a,"viz","shape");return g&&(b.shape=g.getAttribute("value")),b}function j(a,b){var d=[];return h.nodeListEach(l.els.edges,function(e){var g=h.namedNodeMapToObject(e.attributes);"type"in g||(g.type=b),a&&(g.attributes=f(a,e)),l.hasViz&&(g.viz=k(e)),d.push(c(g))}),d}function k(a){var b={},c=h.getFirstElementByTagNS(a,"viz","color");if(c){var d=["r","g","b","a"].map(function(a){return c.getAttribute(a)});b.color=h.getRGB(d)}var e=h.getFirstElementByTagNS(a,"viz","shape");e&&(b.shape=e.getAttribute("value"));var f=h.getFirstElementByTagNS(a,"viz","thickness");return f&&(b.thickness=+f.getAttribute("value")),b}var l={};l.els={root:a.getElementsByTagName("gexf")[0],graph:a.getElementsByTagName("graph")[0],meta:a.getElementsByTagName("meta")[0],nodes:a.getElementsByTagName("node"),edges:a.getElementsByTagName("edge"),model:h.getModelTags(a)},l.hasViz=!!h.getAttributeNS(l.els.root,"xmlns","viz"),l.version=l.els.root.getAttribute("version")||"1.0",l.mode=l.els.graph.getAttribute("mode")||"static";var m=l.els.graph.getAttribute("defaultedgetype");l.defaultEdgetype=m||"undirected";var n=e("node"),o=e("edge"),p={version:l.version,mode:l.mode,defaultEdgeType:l.defaultEdgetype,meta:d(),model:{},nodes:g(n),edges:j(o,l.defaultEdgetype)};return n&&(p.model.node=n),o&&(p.model.edge=o),p}function e(a,b){var c=function(){if(window.XMLHttpRequest)return new XMLHttpRequest;var a,b;if(window.ActiveXObject){a=["Msxml2.XMLHTTP.6.0","Msxml2.XMLHTTP.3.0","Msxml2.XMLHTTP","Microsoft.XMLHTTP"];for(b in a)try{return new ActiveXObject(a[b])}catch(c){}}return null}();if(!c)throw"XMLHttpRequest not supported, cannot load the file.";var d,e="function"==typeof b;return c.overrideMimeType?(c.overrideMimeType("text/xml"),d=function(a){return a.responseXML}):d=function(a){var b=new DOMParser;return b.parseFromString(a.responseText,"application/xml")},c.open("GET",a,e),e&&(c.onreadystatechange=function(){4===c.readyState&&b(d(c))}),c.send(),e?c:d(c)}function f(a){return d(a)}function g(a,b){return"function"==typeof b?e(a,function(a){b(d(a))}):d(e(a))}var h={getModelTags:function(a){var b,c=a.getElementsByTagName("attributes"),d={},e=c.length;for(b=0;e>b;b++)d[c[b].getAttribute("class")]=c[b].childNodes;return d},nodeListToArray:function(a){for(var b=[],c=0,d=a.length;d>c;++c)"#text"!==a[c].nodeName&&b.push(a[c]);return b},nodeListEach:function(a,b){for(var c=0,d=a.length;d>c;++c)"#text"!==a[c].nodeName&&b(a[c])},nodeListToHash:function(a,b){for(var c={},d=0;d<a.length;d++)if("#text"!==a[d].nodeName){var e=b(a[d]);c[e.key]=e.value}return c},namedNodeMapToObject:function(a){for(var b={},c=0;c<a.length;c++)b[a[c].name]=a[c].value;return b},getFirstElementByTagNS:function(a,b,c){var d=a.getElementsByTagName(b+":"+c)[0];return d||(d=a.getElementsByTagNameNS(b,c)[0]),d||(d=a.getElementsByTagName(c)[0]),d},getAttributeNS:function(b,c,d){var e=b.getAttribute(c+":"+d);return e===a&&(e=b.getAttributeNS(c,d)),e===a&&(e=b.getAttribute(d)),e},enforceType:function(a,b){switch(a){case"boolean":b="true"===b;break;case"integer":case"long":case"float":case"double":b=+b;break;case"liststring":b=b?b.split("|"):[]}return b},getRGB:function(a){return a[3]?"rgba("+a.join(",")+")":"rgb("+a.slice(0,-1).join(",")+")"}};if("undefined"!=typeof this.gexf)throw'gexf: error - a variable called "gexf" already exists in the global scope';this.gexf={parse:f,fetch:g,version:"0.1.1"},"undefined"!=typeof exports&&this.exports!==exports&&(module.exports=this.gexf)}.call(this),function(a){"use strict";function b(){return"e"+c++}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.parsers");var c=0;sigma.parsers.gexf=function(a,c,d){function e(a){for(h=a.nodes,f=0,g=h.length;g>f;f++)i=h[f],i.id=i.id,i.viz&&"object"==typeof i.viz&&(i.viz.position&&"object"==typeof i.viz.position&&(i.x=i.viz.position.x,i.y=-i.viz.position.y),i.size=i.viz.size,i.color=i.viz.color),i.attributes&&(i.attributes.latitude&&(i.lat=i.attributes.latitude),i.attributes.longitude&&(i.lng=i.attributes.longitude));for(h=a.edges,f=0,g=h.length;g>f;f++)i=h[f],i.id="string"==typeof i.id?i.id:b(),i.source=""+i.source,i.target=""+i.target,i.viz&&"object"==typeof i.viz&&(i.color=i.viz.color,i.size=i.viz.thickness),i.size=i.weight,i.direction=i.type,delete i.type;if(c instanceof sigma){for(c.graph.clear(),h=a.nodes,f=0,g=h.length;g>f;f++)c.graph.addNode(h[f]);for(h=a.edges,f=0,g=h.length;g>f;f++)c.graph.addEdge(h[f])}else"object"==typeof c?(c.graph=a,c=new sigma(c)):"function"==typeof c&&(d=c,c=null);return d?void d(c||a):a}var f,g,h,i;if("string"==typeof a)gexf.fetch(a,e);else if("object"==typeof a)return e(gexf.parse(a))}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.parsers"),sigma.utils.pkg("sigma.utils"),sigma.utils.xhr=function(){if(window.XMLHttpRequest)return new XMLHttpRequest;var a,b;if(window.ActiveXObject){a=["Msxml2.XMLHTTP.6.0","Msxml2.XMLHTTP.3.0","Msxml2.XMLHTTP","Microsoft.XMLHTTP"];for(b in a)try{return new ActiveXObject(a[b])}catch(c){}}return null},sigma.parsers.json=function(a,b,c){var d,e=sigma.utils.xhr();if(!e)throw"XMLHttpRequest not supported, cannot load the file.";e.open("GET",a,!0),e.onreadystatechange=function(){4===e.readyState&&(d=JSON.parse(e.responseText),b instanceof sigma?(b.graph.clear(),b.graph.read(d)):"object"==typeof b?(b.graph=d,b=new sigma(b)):"function"==typeof b&&(c=b,b=null),c&&c(b||d))},e.send()}}.call(this),function(){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";var a=function(a,b,c){var d=void 0!=a&&void 0!=b&&void 0!=a.x&&void 0!=a.y&&void 0!=b.x&&void 0!=b.y;if(d)return(c||0)+Math.sqrt(Math.pow(b.y-a.y,2)+Math.pow(b.x-a.x,2))};sigma.classes.graph.addMethod("astar",function(b,c,d){var e=new sigma.classes.configurable({undirected:!1,pathLengthFunction:a,heuristicLengthFunction:void 0},d||{}),f=e("pathLengthFunction"),g=e("heuristicLengthFunction")||f,h=this.nodes(b),i=this.nodes(c),j={},k=[],l=function(a,b,c,d){var e=a.id,f={pathLength:c,heuristicLength:d,node:a,nodeId:e,previousNode:b};if(void 0==j[e]||j[e].pathLenth>c){j[e]=f;var g,h;for(h=0;h<k.length&&(g=k[h],!(g.heuristicLength>d));h++);k.splice(h,0,f)}};l(h,null,0,0);var m,n=!1;m=e("undirected")?this.allNeighborsIndex:this.outNeighborsIndex;for(var o,p,q,r,s,t;k.length>0;){if(o=k.shift(),o.nodeId==c){n=!0;break}for(p=Object.keys(m[o.nodeId]),t=0;t<p.length;t++)q=this.nodes(p[t]),r=f(o.node,q,o.pathLength),s=g(q,i,r),l(q,o.node,r,s)}if(n){for(var u=[],v=i;v;)u.unshift(v),v=j[v.id].previousNode;return u}})}.call(window),function(a){"use strict";function b(){f=new sigma.utils.map,g=new sigma.utils.map}function c(){null!==h&&j&&h.dispatchEvent("activeNodes")}function d(){null!==h&&j&&h.dispatchEvent("activeEdges")}function e(a){h=this,i=a.graph,null===f&&(f=new sigma.utils.map,i.nodes().forEach(function(a){a.active&&f.set(a.id,a)})),null===g&&(g=new sigma.utils.map,i.edges().forEach(function(a){a.active&&g.set(a.id,a)})),sigma.classes.dispatcher.extend(this),a.bind("kill",function(){h.kill()})}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins");var f,g,h=null,i=null,j=!0;b(),sigma.classes.graph.attach("addNode","sigma.plugins.activeState.addNode",function(a){a.active&&(f.set(a.id,this.nodesIndex.get(a.id)),c())}),sigma.classes.graph.attach("addEdge","sigma.plugins.activeState.addEdge",function(a){a.active&&(g.set(a.id,this.edgesIndex.get(a.id)),d())}),sigma.classes.graph.attachBefore("dropNode","sigma.plugins.activeState.dropNode",function(b){this.nodesIndex.get(b)!==a&&this.nodesIndex.get(b).active&&(f["delete"](b),c())}),sigma.classes.graph.attachBefore("dropEdge","sigma.plugins.activeState.dropEdge",function(b){this.edgesIndex.get(b)!==a&&this.edgesIndex.get(b).active&&(g["delete"](b),d())}),sigma.classes.graph.attachBefore("clear","sigma.plugins.activeState.clear",b),e.prototype.kill=function(){this.unbind(),f=null,g=null,i=null,h=null},e.prototype.addNodes=function(a){var b,d=f.size;if(arguments.length||i.nodes().forEach(function(a){a.hidden||(a.active=!0,f.set(a.id,a))}),arguments.length>1)throw new TypeError("Too many arguments. Use an array instead.");if("string"==typeof a||"number"==typeof a)b=i.nodes(a),b.hidden||(b.active=!0,f.set(a,b));else if(Array.isArray(a)){var e,g;for(e=0,g=a.length;g>e;e++){if("string"!=typeof a[e]&&"number"!=typeof a[e])throw new TypeError("Invalid argument: a node id is not a string or a number, was "+a[e]);b=i.nodes(a[e]),b.hidden||(b.active=!0,f.set(a[e],b))}}return d!=f.size&&c(),this},e.prototype.addEdges=function(a){var b,c=g.size;if(arguments.length||i.edges().forEach(function(a){a.hidden||(a.active=!0,g.set(a.id,a))}),arguments.length>1)throw new TypeError("Too many arguments. Use an array instead.");if("string"==typeof a||"number"==typeof a)b=i.edges(a),b.hidden||(b.active=!0,g.set(a,b));else if(Array.isArray(a)){var e,f;for(e=0,f=a.length;f>e;e++){if("string"!=typeof a[e]&&"number"!=typeof a[e])throw new TypeError("Invalid argument: an edge id is not a string or a number, was "+a[e]);b=i.edges(a[e]),b.hidden||(b.active=!0,g.set(a[e],b))}}return c!=g.size&&d(),this},e.prototype.dropNodes=function(a){var b=f.size;if(arguments.length||i.nodes().forEach(function(a){a.active=!1,f["delete"](a.id)}),arguments.length>1)throw new TypeError("Too many arguments. Use an array instead.");if("string"==typeof a||"number"==typeof a)i.nodes(a).active=!1,f["delete"](a);else if(Array.isArray(a)){var d,e;for(d=0,e=a.length;e>d;d++){if("string"!=typeof a[d]&&"number"!=typeof a[d])throw new TypeError("Invalid argument: a node id is not a string or a number, was "+a[d]);i.nodes(a[d]).active=!1,f["delete"](a[d])}}return b!=f.size&&c(),this},e.prototype.dropEdges=function(a){var b=g.size;if(arguments.length||i.edges().forEach(function(a){a.active=!1,g["delete"](a.id)}),arguments.length>1)throw new TypeError("Too many arguments. Use an array instead.");if("string"==typeof a||"number"==typeof a)i.edges(a).active=!1,g["delete"](a);else if(Array.isArray(a)){var c,e;for(c=0,e=a.length;e>c;c++){if("string"!=typeof a[c]&&"number"!=typeof a[c])throw new TypeError("Invalid argument: an edge id is not a string or a number, was "+a[c]);i.edges(a[c]).active=!1,g["delete"](a[c])}}return b!=g.size&&d(),this},e.prototype.addNeighbors=function(){if(!("adjacentNodes"in i))throw new Error("Missing method graph.adjacentNodes");var a=f.keyList();return f.forEach(function(b,c){i.adjacentNodes(c).forEach(function(b){b.hidden||a.push(b.id)})}),j=!1,this.dropNodes().dropEdges(),j=!0,this.addNodes(a),this},e.prototype.setNodesBy=function(a){var b=[];return i.nodes().forEach(function(c){a.call(i,c)&&(c.hidden||b.push(c.id))}),j=!1,this.dropNodes(),j=!0,this.addNodes(b),this},e.prototype.setEdgesBy=function(a){var b=[];return i.edges().forEach(function(c){a.call(i,c)&&(c.hidden||b.push(c.id))}),j=!1,this.dropEdges(),j=!0,this.addEdges(b),this},e.prototype.invertNodes=function(){var a=i.nodes().filter(function(a){return!a.hidden&&!a.active}).map(function(a){return a.id});return j=!1,this.dropNodes(),j=!0,a.length?this.addNodes(a):c(),this},e.prototype.invertEdges=function(){var a=i.edges().filter(function(a){return!a.hidden&&!a.active}).map(function(a){return a.id});return j=!1,this.dropEdges(),j=!0,a.length?this.addEdges(a):d(),this},e.prototype.nodes=function(){if(!f)return[];if(!sigma.forceES5)return f.valueList();var a=[];return f.forEach(function(b,c){a.push(b)}),a},e.prototype.edges=function(){if(!g)return[];if(!sigma.forceES5)return g.valueList();var a=[];return g.forEach(function(b,c){a.push(b)}),a},e.prototype.nbNodes=function(){return f?f.size:0},e.prototype.nbEdges=function(){return g?g.size:0},sigma.plugins.activeState=function(a){return h||(h=new e(a)),h},sigma.plugins.killActiveState=function(){h instanceof e&&(h.kill(),h=null)}}.call(this),function(){"use strict";function a(a){if(d[a])return d[a];var b=[0,0,0];return a.match(/^#/)?(a=(a||"").replace(/^#/,""),b=3===a.length?[parseInt(a.charAt(0)+a.charAt(0),16),parseInt(a.charAt(1)+a.charAt(1),16),parseInt(a.charAt(2)+a.charAt(2),16)]:[parseInt(a.charAt(0)+a.charAt(1),16),parseInt(a.charAt(2)+a.charAt(3),16),parseInt(a.charAt(4)+a.charAt(5),16)]):a.match(/^ *rgba? *\(/)&&(a=a.match(/^ *rgba? *\( *([0-9]*) *, *([0-9]*) *, *([0-9]*) *(,.*)?\) *$/),b=[+a[1],+a[2],+a[3]]),d[a]={r:b[0],g:b[1],b:b[2]},d[a]}function b(b,c,d){b=a(b),c=a(c);var e={r:b.r*(1-d)+c.r*d,g:b.g*(1-d)+c.g*d,b:b.b*(1-d)+c.b*d};return"rgb("+[0|e.r,0|e.g,0|e.b].join(",")+")"}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");var c=0,d={};sigma.plugins.animate=function(a,d,e){function f(){var c=(sigma.utils.dateNow()-m)/k;c>=1?(g.forEach(function(a){for(var b in d)b in d&&d[b]in a&&(a[b]=a[d[b]])}),a.refresh({skipIndexation:!0}),"function"==typeof i.onComplete&&i.onComplete(),a.dispatchEvent("animate.end")):(c=l(c),g.forEach(function(a){for(var e in d)e in d&&d[e]in a&&(e.match(/color$/)?a[e]=b(h[a.id][e],a[d[e]],c):a[e]=a[d[e]]*c+h[a.id][e]*(1-c))}),a.refresh({skipIndexation:!0}),a.animations[j]=requestAnimationFrame(f))}var g,h,i=e||{},j=++c,k=i.duration||a.settings("animationsTime"),l="string"==typeof i.easing?sigma.utils.easings[i.easing]:"function"==typeof i.easing?i.easing:sigma.utils.easings.quadraticInOut,m=sigma.utils.dateNow();g=i.nodes&&i.nodes.length?"object"==typeof i.nodes[0]?i.nodes:a.graph.nodes(i.nodes):a.graph.nodes(),h=g.reduce(function(a,b){var c;a[b.id]={};for(c in d)c in b&&(a[b.id][c]=b[c]);return a},{}),a.animations=a.animations||Object.create({}),sigma.plugins.killAnimate(a),a.dispatchEvent("animate.start"),f()},sigma.plugins.killAnimate=function(a){for(var b in a.animations||{})cancelAnimationFrame(a.animations[b])}}.call(window),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins"),sigma.plugins.colorbrewer={YlGn:{3:["#f7fcb9","#addd8e","#31a354"],4:["#ffffcc","#c2e699","#78c679","#238443"],5:["#ffffcc","#c2e699","#78c679","#31a354","#006837"],6:["#ffffcc","#d9f0a3","#addd8e","#78c679","#31a354","#006837"],7:["#ffffcc","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],8:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],9:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"]},YlGnBu:{3:["#edf8b1","#7fcdbb","#2c7fb8"],4:["#ffffcc","#a1dab4","#41b6c4","#225ea8"],5:["#ffffcc","#a1dab4","#41b6c4","#2c7fb8","#253494"],6:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#2c7fb8","#253494"],7:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],8:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],9:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"]},GnBu:{3:["#e0f3db","#a8ddb5","#43a2ca"],4:["#f0f9e8","#bae4bc","#7bccc4","#2b8cbe"],5:["#f0f9e8","#bae4bc","#7bccc4","#43a2ca","#0868ac"],6:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#43a2ca","#0868ac"],7:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],8:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],9:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"]},BuGn:{3:["#e5f5f9","#99d8c9","#2ca25f"],4:["#edf8fb","#b2e2e2","#66c2a4","#238b45"],5:["#edf8fb","#b2e2e2","#66c2a4","#2ca25f","#006d2c"],6:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#2ca25f","#006d2c"],7:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],8:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],9:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"]},PuBuGn:{3:["#ece2f0","#a6bddb","#1c9099"],4:["#f6eff7","#bdc9e1","#67a9cf","#02818a"],5:["#f6eff7","#bdc9e1","#67a9cf","#1c9099","#016c59"],6:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#1c9099","#016c59"],7:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],8:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],9:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"]},PuBu:{3:["#ece7f2","#a6bddb","#2b8cbe"],4:["#f1eef6","#bdc9e1","#74a9cf","#0570b0"],5:["#f1eef6","#bdc9e1","#74a9cf","#2b8cbe","#045a8d"],6:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#2b8cbe","#045a8d"],7:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],8:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],9:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"]},BuPu:{3:["#e0ecf4","#9ebcda","#8856a7"],4:["#edf8fb","#b3cde3","#8c96c6","#88419d"],5:["#edf8fb","#b3cde3","#8c96c6","#8856a7","#810f7c"],6:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8856a7","#810f7c"],7:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],8:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],9:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"]},RdPu:{3:["#fde0dd","#fa9fb5","#c51b8a"],4:["#feebe2","#fbb4b9","#f768a1","#ae017e"],5:["#feebe2","#fbb4b9","#f768a1","#c51b8a","#7a0177"],6:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#c51b8a","#7a0177"],7:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],8:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],9:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"]},PuRd:{3:["#e7e1ef","#c994c7","#dd1c77"],4:["#f1eef6","#d7b5d8","#df65b0","#ce1256"],5:["#f1eef6","#d7b5d8","#df65b0","#dd1c77","#980043"],6:["#f1eef6","#d4b9da","#c994c7","#df65b0","#dd1c77","#980043"],7:["#f1eef6","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],8:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],9:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"]},OrRd:{3:["#fee8c8","#fdbb84","#e34a33"],4:["#fef0d9","#fdcc8a","#fc8d59","#d7301f"],5:["#fef0d9","#fdcc8a","#fc8d59","#e34a33","#b30000"],6:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#e34a33","#b30000"],7:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],8:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],9:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"]},YlOrRd:{3:["#ffeda0","#feb24c","#f03b20"],4:["#ffffb2","#fecc5c","#fd8d3c","#e31a1c"],5:["#ffffb2","#fecc5c","#fd8d3c","#f03b20","#bd0026"],6:["#ffffb2","#fed976","#feb24c","#fd8d3c","#f03b20","#bd0026"],7:["#ffffb2","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],8:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],9:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"]},YlOrBr:{3:["#fff7bc","#fec44f","#d95f0e"],4:["#ffffd4","#fed98e","#fe9929","#cc4c02"],5:["#ffffd4","#fed98e","#fe9929","#d95f0e","#993404"],6:["#ffffd4","#fee391","#fec44f","#fe9929","#d95f0e","#993404"],7:["#ffffd4","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],
8:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],9:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"]},Purples:{3:["#efedf5","#bcbddc","#756bb1"],4:["#f2f0f7","#cbc9e2","#9e9ac8","#6a51a3"],5:["#f2f0f7","#cbc9e2","#9e9ac8","#756bb1","#54278f"],6:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#756bb1","#54278f"],7:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],8:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],9:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"]},Blues:{3:["#deebf7","#9ecae1","#3182bd"],4:["#eff3ff","#bdd7e7","#6baed6","#2171b5"],5:["#eff3ff","#bdd7e7","#6baed6","#3182bd","#08519c"],6:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#3182bd","#08519c"],7:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],8:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],9:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"]},Greens:{3:["#e5f5e0","#a1d99b","#31a354"],4:["#edf8e9","#bae4b3","#74c476","#238b45"],5:["#edf8e9","#bae4b3","#74c476","#31a354","#006d2c"],6:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#31a354","#006d2c"],7:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],8:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],9:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"]},Oranges:{3:["#fee6ce","#fdae6b","#e6550d"],4:["#feedde","#fdbe85","#fd8d3c","#d94701"],5:["#feedde","#fdbe85","#fd8d3c","#e6550d","#a63603"],6:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#e6550d","#a63603"],7:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],8:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],9:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"]},Reds:{3:["#fee0d2","#fc9272","#de2d26"],4:["#fee5d9","#fcae91","#fb6a4a","#cb181d"],5:["#fee5d9","#fcae91","#fb6a4a","#de2d26","#a50f15"],6:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#de2d26","#a50f15"],7:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],8:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],9:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"]},Greys:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]},PuOr:{3:["#f1a340","#f7f7f7","#998ec3"],4:["#e66101","#fdb863","#b2abd2","#5e3c99"],5:["#e66101","#fdb863","#f7f7f7","#b2abd2","#5e3c99"],6:["#b35806","#f1a340","#fee0b6","#d8daeb","#998ec3","#542788"],7:["#b35806","#f1a340","#fee0b6","#f7f7f7","#d8daeb","#998ec3","#542788"],8:["#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788"],9:["#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788"],10:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],11:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"]},BrBG:{3:["#d8b365","#f5f5f5","#5ab4ac"],4:["#a6611a","#dfc27d","#80cdc1","#018571"],5:["#a6611a","#dfc27d","#f5f5f5","#80cdc1","#018571"],6:["#8c510a","#d8b365","#f6e8c3","#c7eae5","#5ab4ac","#01665e"],7:["#8c510a","#d8b365","#f6e8c3","#f5f5f5","#c7eae5","#5ab4ac","#01665e"],8:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e"],9:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e"],10:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],11:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"]},PRGn:{3:["#af8dc3","#f7f7f7","#7fbf7b"],4:["#7b3294","#c2a5cf","#a6dba0","#008837"],5:["#7b3294","#c2a5cf","#f7f7f7","#a6dba0","#008837"],6:["#762a83","#af8dc3","#e7d4e8","#d9f0d3","#7fbf7b","#1b7837"],7:["#762a83","#af8dc3","#e7d4e8","#f7f7f7","#d9f0d3","#7fbf7b","#1b7837"],8:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837"],9:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837"],10:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],11:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"]},PiYG:{3:["#e9a3c9","#f7f7f7","#a1d76a"],4:["#d01c8b","#f1b6da","#b8e186","#4dac26"],5:["#d01c8b","#f1b6da","#f7f7f7","#b8e186","#4dac26"],6:["#c51b7d","#e9a3c9","#fde0ef","#e6f5d0","#a1d76a","#4d9221"],7:["#c51b7d","#e9a3c9","#fde0ef","#f7f7f7","#e6f5d0","#a1d76a","#4d9221"],8:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221"],9:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221"],10:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],11:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"]},RdBu:{3:["#ef8a62","#f7f7f7","#67a9cf"],4:["#ca0020","#f4a582","#92c5de","#0571b0"],5:["#ca0020","#f4a582","#f7f7f7","#92c5de","#0571b0"],6:["#b2182b","#ef8a62","#fddbc7","#d1e5f0","#67a9cf","#2166ac"],7:["#b2182b","#ef8a62","#fddbc7","#f7f7f7","#d1e5f0","#67a9cf","#2166ac"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"]},RdGy:{3:["#ef8a62","#ffffff","#999999"],4:["#ca0020","#f4a582","#bababa","#404040"],5:["#ca0020","#f4a582","#ffffff","#bababa","#404040"],6:["#b2182b","#ef8a62","#fddbc7","#e0e0e0","#999999","#4d4d4d"],7:["#b2182b","#ef8a62","#fddbc7","#ffffff","#e0e0e0","#999999","#4d4d4d"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"]},RdYlBu:{3:["#fc8d59","#ffffbf","#91bfdb"],4:["#d7191c","#fdae61","#abd9e9","#2c7bb6"],5:["#d7191c","#fdae61","#ffffbf","#abd9e9","#2c7bb6"],6:["#d73027","#fc8d59","#fee090","#e0f3f8","#91bfdb","#4575b4"],7:["#d73027","#fc8d59","#fee090","#ffffbf","#e0f3f8","#91bfdb","#4575b4"],8:["#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4"],9:["#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"]},Spectral:{3:["#fc8d59","#ffffbf","#99d594"],4:["#d7191c","#fdae61","#abdda4","#2b83ba"],5:["#d7191c","#fdae61","#ffffbf","#abdda4","#2b83ba"],6:["#d53e4f","#fc8d59","#fee08b","#e6f598","#99d594","#3288bd"],7:["#d53e4f","#fc8d59","#fee08b","#ffffbf","#e6f598","#99d594","#3288bd"],8:["#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd"],9:["#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd"],10:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],11:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"]},RdYlGn:{3:["#fc8d59","#ffffbf","#91cf60"],4:["#d7191c","#fdae61","#a6d96a","#1a9641"],5:["#d7191c","#fdae61","#ffffbf","#a6d96a","#1a9641"],6:["#d73027","#fc8d59","#fee08b","#d9ef8b","#91cf60","#1a9850"],7:["#d73027","#fc8d59","#fee08b","#ffffbf","#d9ef8b","#91cf60","#1a9850"],8:["#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850"],9:["#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"]},Accent:{3:["#7fc97f","#beaed4","#fdc086"],4:["#7fc97f","#beaed4","#fdc086","#ffff99"],5:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0"],6:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f"],7:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17"],8:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"]},Dark2:{3:["#1b9e77","#d95f02","#7570b3"],4:["#1b9e77","#d95f02","#7570b3","#e7298a"],5:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e"],6:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02"],7:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d"],8:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"]},Paired:{3:["#a6cee3","#1f78b4","#b2df8a"],4:["#a6cee3","#1f78b4","#b2df8a","#33a02c"],5:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99"],6:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c"],7:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f"],8:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00"],9:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6"],10:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a"],11:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99"],12:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"]},Pastel1:{3:["#fbb4ae","#b3cde3","#ccebc5"],4:["#fbb4ae","#b3cde3","#ccebc5","#decbe4"],5:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6"],6:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc"],7:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd"],8:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec"],9:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},Pastel2:{3:["#b3e2cd","#fdcdac","#cbd5e8"],4:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4"],5:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9"],6:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae"],7:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc"],8:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"]},Set1:{3:["#e41a1c","#377eb8","#4daf4a"],4:["#e41a1c","#377eb8","#4daf4a","#984ea3"],5:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00"],6:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33"],7:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628"],8:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf"],9:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"]},Set2:{3:["#66c2a5","#fc8d62","#8da0cb"],4:["#66c2a5","#fc8d62","#8da0cb","#e78ac3"],5:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854"],6:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f"],7:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494"],8:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"]},Set3:{3:["#8dd3c7","#ffffb3","#bebada"],4:["#8dd3c7","#ffffb3","#bebada","#fb8072"],5:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3"],6:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462"],7:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69"],8:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5"],9:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9"],10:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd"],11:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5"],12:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"]}}}.call(this),function(undefined){"use strict";function strToObjectRef(a,b){return b.split(".").reduce(function(a,b){return a[b]},a)}function emptyObject(a){var b;for(b in a)"hasOwnProperty"in a&&!a.hasOwnProperty(b)||delete a[b];return a}function deepCopy(o){var copy=Object.create(null);for(var i in o)"object"==typeof o[i]&&null!==o[i]?copy[i]=deepCopy(o[i]):"function"==typeof o[i]&&null!==o[i]?eval(" copy[i] = "+o[i].toString()):copy[i]=o[i];return copy}function baseHistogram(a,b){var c,d,e,f,g={};return a.length?(c=a.map(function(a){return parseFloat(a)}).sort(function(a,b){return a-b}),d=c[0],e=c[c.length-1],e-d!==0?c.forEach(function(a){f=Math.floor(b*Math.abs(a-d)/Math.abs(e-d)),f-=f==b?1:0,g[a]=f}):c.forEach(function(a){g[a]=0}),g):g}function histogram(a,b){var c,d=[],e=0;if(a&&a[b]){Object.keys(a[b]).forEach(function(c){var e=a[b][c];d[e]=d[e]||[],d[e].push(+c)}),c=1!==d.length?d.length:7;for(var f=0;c>f;f++)d[f]&&(e=e>d[f].length?e:d[f].length);for(var f=0;c>f;f++)d[f]===undefined&&(d[f]=[]),d[f]={bin:f,values:d[f],ratio:d[f].length/e},d[f].values.length&&(d[f].min=Math.min.apply(null,d[f].values),d[f].max=Math.max.apply(null,d[f].values))}return d}function resolveHistogram(a,b,c){for(var d,e=b.get(c),f=a.length,g=0,h=0;f>h;h++)a[h].items=[];Object.keys(e).forEach(function(b){for(var f=0;f<e[b].items.length;f++){d=e[b].items[f],b=strToObjectRef(d,c);for(var g=0;g<a.length;g++)!1 in a[g]||!1 in a[g]||a[g].min<=b&&b<=a[g].max&&a[g].items.push(d)}});for(var h=0;f>h;h++)a[h].items&&(g=g>a[h].items.length?g:a[h].items.length);for(var h=0;f>h;h++)a[h].itemsRatio=a[h].items.length/g;return a}function download(a,b,c){var d=null,e=null,f=null;if(window.Blob?(d=new Blob([a],{type:"text/json"}),e=window.URL.createObjectURL(d)):f="data:text/json;charset=UTF-8,"+encodeURIComponent(a),navigator.msSaveBlob)navigator.msSaveBlob(d,c);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(d,c);else{var g=document.createElement("a");g.setAttribute("href",window.Blob?e:f),g.setAttribute("download",c||"graph."+b),document.body.appendChild(g),g.click(),document.body.removeChild(g)}e&&setTimeout(function(){window.URL.revokeObjectURL(e)},0)}function Vision(a,b,c,d){var e=this;if(this.visualVars=null,this.mappings=null,this.palette=d,this.idx=Object.create(null),this.histograms=Object.create(null),this.deprecated=Object.create(null),this.sigmaSettings=Object.create(null),this.dataTypes=Object.create(null),this.originalVisualVariable=Object.create(null),"nodes"===b)this.visualVars=["color","size","label","type","icon","image"],this.mappings=c.nodes,this.dataset=function(){return a.graph.nodes()};else{if("edges"!==b)throw new Error('Invalid argument: "datasetName" is not "nodes" or "edges", was '+b);this.visualVars=["color","size","label","type"],this.mappings=c.edges,this.dataset=function(){return a.graph.edges()}}return this.update=function(a){function b(b,d){c.idx[a][b]===undefined&&(c.idx[a][b]={key:b,items:[],styles:Object.create(null)}),c.idx[a][b].items.push(d),(h||h===undefined)&&(h="number"==typeof b)}var c=this;if(a===undefined)throw new Error('Missing argument: "key".');if("string"!=typeof a)throw new Error('Invalid argument: "key" is not a string, was '+a);var d,f,g,h=undefined,i=!0;f=function(a,b){return strToObjectRef(a,b)},g=function(a,b){return strToObjectRef(a,b)},this.idx[a]={},this.dataset().forEach(function(c){d=f(c,a),d!==undefined&&(i&&(i=Array.isArray(d)?i:!1),i?1===d.length?b(d[0],c):d.forEach(function(a){b(a,c)}):b(d,c))}),this.dataTypes[a]={sequential:h,array:i},this.deprecated[a]=!1;var j=0;for(d in this.idx[a])j=j<this.idx[a][d].items.length?this.idx[a][d].items.length:j;Object.keys(this.idx[a]).forEach(function(b){c.idx[a][b].ratio=parseFloat(c.idx[a][b].items.length/j)});var k,l,m,n,o,p,q,r=0;q=Object.keys(e.mappings).filter(function(b){return e.mappings[b]&&e.mappings[b].by!==undefined&&e.mappings[b].by.toString()==a}),q.forEach(function(b){switch(b){case"color":if(l=e.mappings.color.scheme,"string"!=typeof l)throw new Error('color.scheme "'+l+'" is not a string.');h&&(p=e.mappings.color.bins||7,c.histograms.color=c.histograms.color||{},c.histograms.color[a]=baseHistogram(Object.keys(c.idx[a]),p));break;case"label":if(k=e.mappings.label.format||function(a){return"string"==typeof a?a:a.label},"function"!=typeof k)throw new Error('label.format "'+k+'" is not a function.');break;case"size":if(h===undefined)break;if(!h)throw new Error('One value of the property "'+a+'" is not a number.');c.histograms.size=c.histograms.size||{},c.histograms.size[a]=baseHistogram(Object.keys(c.idx[a]),e.mappings.size.bins||7);break;case"type":if(m=e.mappings.type.scheme,"string"!=typeof m)throw new Error('type.scheme "'+m+'" is not a string.');break;case"icon":if(n=e.mappings.icon.scheme,"string"!=typeof n)throw new Error('icon.scheme "'+n+'" is not a string.');break;case"image":if(o=e.mappings.image.scheme,"string"!=typeof o)throw new Error('type.scheme "'+o+'" is not a string.')}}),Object.keys(this.idx[a]).forEach(function(b){q.forEach(function(d){switch(d){case"color":h?c.idx[a][b].styles.color=function(){var d=c.histograms.color[a][b];return g(e.palette,l)[p][d]}:c.idx[a][b].styles.color=function(){if(g(e.palette,l)===undefined)throw new Error("Wrong or undefined color scheme.");if(e.mappings.color.set>0){var a=g(e.palette,l)[e.mappings.color.set][r];return r=(r+1)%e.mappings.color.set,a}return g(e.palette,l)[b]};break;case"label":c.idx[a][b].styles.label=function(b){return k(f(b,a))};break;case"size":c.idx[a][b].styles.size=function(){return 1+c.histograms.size[a][b]};break;case"type":c.idx[a][b].styles.type=function(){if(g(e.palette,m)===undefined)throw new Error("Wrong or undefined type scheme.");return g(e.palette,m)[b]};break;case"icon":c.idx[a][b].styles.icon=function(){if(g(e.palette,n)===undefined)throw new Error("Wrong or undefined icon scheme.");return g(e.palette,n)[b]};break;case"image":c.idx[a][b].styles.image=function(){if(g(e.palette,o)===undefined)throw new Error("Wrong or undefined image scheme.");return g(e.palette,o)[b]}}})})},this.get=function(a){if(a===undefined)throw new TypeError('Missing argument: "key".');if("string"!=typeof a)throw new TypeError('Invalid argument: "key" is not a string, was '+a);return this.deprecated[a]&&this.update(a),this.idx[a]===undefined&&this.update(a),this.idx[a]},this.applyStyle=function(c,d){if(d===undefined)throw new TypeError('Missing argument: "key"');if("string"!=typeof d)throw new TypeError('Invalid argument: "key" is not a string, was '+d);if(-1==this.visualVars.indexOf(c))throw new Error('Unknown style "'+c+'"');var e=this,f=this.get(d);if("color"===c&&e.dataTypes[d].array&&(this.dataset().forEach(function(a){delete a.colors}),Object.keys(f).forEach(function(a){var b=f[a];b.items.forEach(function(a){a.colors=[]})})),Object.keys(f).forEach(function(a){var b=f[a];b.items.forEach(function(a){if(a!==undefined&&b.styles!==undefined&&"function"==typeof b.styles[c]){e.originalVisualVariable[a.id]||(e.originalVisualVariable[a.id]={}),c in e.originalVisualVariable[a.id]||Object.defineProperty(e.originalVisualVariable[a.id],c,{enumerable:!0,value:a[c]});var f=b.styles[c](a);"color"===c&&e.dataTypes[d].array?f!==undefined&&(a.color=f,a.colors.push(f)):f!==undefined&&(a[c]=f)}else if("function"==typeof b.styles[c])throw new TypeError(b.styles+"."+c+"is not a function, was "+b.styles[c])})}),"size"===c)if("nodes"===b){if(this.mappings.size.min>this.mappings.size.max)throw new RangeError("nodes.size.min must be lower or equal than nodes.size.max");this.mappings.size.min&&(this.sigmaSettings.minNodeSize||(this.sigmaSettings.minNodeSize=a.settings("minNodeSize")),a.settings("minNodeSize",this.mappings.size.min)),this.mappings.size.max&&(this.sigmaSettings.maxNodeSize||(this.sigmaSettings.maxNodeSize=a.settings("maxNodeSize")),a.settings("maxNodeSize",this.mappings.size.max))}else if("edges"===b){if(this.mappings.size.min>this.mappings.size.max)throw new RangeError("edges.size.min must be lower or equal than edges.size.max");this.mappings.size.min&&(this.sigmaSettings.minEdgeSize||(this.sigmaSettings.minEdgeSize=a.settings("minEdgeSize")),a.settings("minEdgeSize",this.mappings.size.min)),this.mappings.size.max&&(this.sigmaSettings.maxEdgeSize||(this.sigmaSettings.maxEdgeSize=a.settings("maxEdgeSize")),a.settings("maxEdgeSize",this.mappings.size.max))}},this.resetStyle=function(c,d){if(d===undefined)throw new TypeError('Missing argument: "key"');if("string"!=typeof d)throw new TypeError('Invalid argument: "key" is not a string, was '+d);if(-1==this.visualVars.indexOf(c))throw new Error('Unknown style "'+c+'".');if(this.idx[d]!==undefined){var e=this,f=this.get(d);"color"===c&&e.dataTypes[d].array&&Object.keys(f).forEach(function(a){var b=f[a];b.items.forEach(function(a){delete a.colors})}),Object.keys(f).forEach(function(a){var b=f[a];b.items.forEach(function(a){a!==undefined&&a[c]!==undefined&&(e.originalVisualVariable[a.id]===undefined||e.originalVisualVariable[a.id][c]===undefined?"edges"===e.key&&"size"===c?a.size=1:delete a[c]:a[c]=e.originalVisualVariable[a.id][c])})}),"size"===c&&("nodes"===b?(this.sigmaSettings.minNodeSize&&a.settings("minNodeSize",this.sigmaSettings.minNodeSize),this.sigmaSettings.maxNodeSize&&a.settings("maxNodeSize",this.sigmaSettings.maxNodeSize)):"edges"===b&&(this.sigmaSettings.minEdgeSize&&a.settings("minEdgeSize",this.sigmaSettings.minEdgeSize),this.sigmaSettings.maxEdgeSize&&a.settings("maxEdgeSize",this.sigmaSettings.maxEdgeSize)))}},this.clear=function(){this.visualVars.length=0,emptyObject(this.idx),emptyObject(this.histograms),emptyObject(this.deprecated),emptyObject(this.sigmaSettings),emptyObject(this.dataTypes),emptyObject(this.originalVisualVariable)},this}function design(a,b){function c(b,c,d){d?b[d]&&b[d].by&&(c.applyStyle(d,b[d].by),b[d].active=!0):Object.keys(b).forEach(function(a){b[a].active=!1,b[a]&&b[a].by&&(c.applyStyle(a,b[a].by),b[a].active=!0)}),a&&a.refresh({skipIndexation:!0})}function d(b,c,d){d?b[d]&&b[d].active&&(c.resetStyle(d,b[d].by),b[d].active=!1):Object.keys(b).forEach(function(a){b[a].active&&(c.resetStyle(a,b[a].by),b[a].active=!1)}),a&&a.refresh({skipIndexation:!0})}this.palette=(b||{}).palette||{},this.styles=sigma.utils.extend((b||{}).styles||{},{nodes:{},edges:{}});var e=this,f=new Vision(a,"nodes",this.styles,this.palette),g=new Vision(a,"edges",this.styles,this.palette);a.bind("kill",function(){sigma.plugins.killDesign(a)}),this.setStyles=function(a){return this.styles=sigma.utils.extend(a||{},{nodes:{},edges:{}}),f.mappings=this.styles.nodes,g.mappings=this.styles.edges,this.deprecate(),this},this.nodesBy=function(a,b){return this.styles=sigma.utils.extend(this.styles||{},{nodes:{},edges:{}}),this.styles.nodes[a]=b,f.mappings=this.styles.nodes,b.by&&this.deprecate("nodes",b.by),this},this.edgesBy=function(a,b){return this.styles=sigma.utils.extend(this.styles||{},{nodes:{},edges:{}}),this.styles.edges[a]=b,g.mappings=this.styles.edges,b.by&&this.deprecate("edges",b.by),this},this.setPalette=function(a){return this.palette=a,f.palette=this.palette,g.palette=this.palette,this.deprecate(),this},this.nodes=function(a){return f.get(a)},this.edges=function(a){return g.get(a)},this.inspect=function(){return{nodes:deepCopy(f),edges:deepCopy(g)}},this.apply=function(a,b){if(this.styles){if(!a)return c(this.styles.nodes,f,b),c(this.styles.edges,g,b),this;switch(a){case"nodes":c(this.styles.nodes,f,b);break;case"edges":c(this.styles.edges,g,b);break;default:throw new Error('Invalid argument: "target" is not "nodes" or "edges", was '+a)}return this}},this.reset=function(a,b){if(this.styles){if(!a)return d(this.styles.nodes,f,b),d(this.styles.edges,g,b),this;switch(a){case"nodes":d(this.styles.nodes,f,b);break;case"edges":d(this.styles.edges,g,b);break;default:throw new Error('Invalid argument: "target" is not "nodes" or "edges", was '+a)}return this}},this.deprecate=function(a,b){if(a){if("nodes"!==a&&"edges"!==a)throw new Error('Invalid argument: "target" is not "nodes" or "edges", was '+a);b?"nodes"===a?f.deprecated[b]=!0:"edges"===a&&(g.deprecated[b]=!0):"nodes"===a?Object.keys(f.deprecated).forEach(function(a){f.deprecated[a]=!0}):"edges"===a&&Object.keys(g.deprecated).forEach(function(a){g.deprecated[a]=!0})}else Object.keys(f.deprecated).forEach(function(a){f.deprecated[a]=!0}),Object.keys(g.deprecated).forEach(function(a){g.deprecated[a]=!0});return this},this.deletePropertyStylesFrom=function(a,b,c){if(null==b)throw new TypeError('Missing argument: "id".');if("nodes"!==a&&"edges"!==a)throw new Error('Invalid argument: "target" is not "nodes" or "edges", was '+a);if(null==c)throw new TypeError('Missing argument: "key".');var d,e,h,i;d="nodes"===a?f.get(c):g.get(c);for(var j=Object.keys(d),k=0;k<j.length;k++){e=d[j[k]],h=Object.keys(e.styles);for(var l=0;l<e.items.length;l++)if(i=e.items[l],i.id===b){for(var m=0;m<h.length;m++)"label"!==h[m]&&"size"!==h[m]?delete i[h[m]]:"size"===h[m]&&(i.size=1);return this.deprecate(a,c),this}}return this},this.clear=function(){return this.reset(),this.styles={nodes:{},edges:{}},this.palette={},f.clear(),g.clear(),f=new Vision(a,"nodes",this.styles,this.palette),g=new Vision(a,"edges",this.styles,this.palette),a&&a.refresh({skipIndexation:!0}),this},this.kill=function(){delete this.styles,delete this.palette,f.clear(),g.clear()},this.toJSON=function(a){a=a||{};var b={styles:this.styles,palette:this.palette};if(a.pretty)var c=JSON.stringify(b,null," ");else var c=JSON.stringify(b);return a.download&&download(c,"json",a.filename),c},this.utils={},this.utils.isSequential=function(a,b){if(!a)throw new TypeError('Missing argument: "target"');var c;switch(a){case"nodes":c=f;break;case"edges":c=g;break;default:throw new Error('Invalid argument: "target" is not "nodes" or "edges", was '+a)}if(b===undefined)throw new TypeError('Missing argument: "property"');if("string"!=typeof b)throw new TypeError('Invalid argument: "property" is not a string, was '+b);if(!(b in c.dataTypes)||c.dataTypes[b].sequential===undefined){var d,e=!1,h=!0;c.dataset().forEach(function(a){d=strToObjectRef(a,b),d!==undefined&&(e=!0,h="number"==typeof d?h:!1)}),e?c.dataTypes[b]={sequential:h}:c.dataTypes[b]&&(c.dataTypes[b].sequential=undefined)}return(c.dataTypes[b]||{}).sequential},this.utils.histogram=function(a,b,c){if(!a)throw new TypeError('Missing argument: "target"');var d;switch(a){case"nodes":d=f;break;case"edges":d=g;break;default:throw new Error('Invalid argument: "target" is not "nodes" or "edges", was '+a)}if(-1==d.visualVars.indexOf(b))throw new Error('Unknown visual variable "'+b+'".');if(c===undefined)throw new TypeError('Missing argument: "property".');if("string"!=typeof c)throw new TypeError('Invalid argument: "property" is not a string, was'+c);var h=e.utils.isSequential(a,c);if(!h)throw new Error('The property "'+c+'" is not sequential.');var i=histogram(d.histograms[b],c);if(i=resolveHistogram(i,d,c),"color"===b){if(!e.styles[a].color)throw new Error('Missing key "color" in '+a+" palette.");var j=i.length,k=strToObjectRef(e.palette,e.styles[a].color.scheme);if(!k)throw new Error('Color scheme "'+e.styles[a].color.scheme+'" not in '+a+" palette.");if(h)for(var l=0;j>l;l++){if(!k[j])throw new Error('Missing key "'+j+'" in '+a+' palette " of color scheme '+e.styles[a].color.scheme+'".');i[l][b]=k[j][l]}}return i}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins");var _instance={};sigma.plugins.design=function(a,b){return _instance[a.id]||(_instance[a.id]=new design(a,b)),_instance[a.id]},sigma.plugins.killDesign=function(a){_instance[a.id]instanceof design&&_instance[a.id].kill(),delete _instance[a.id]}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw new Error("sigma not in scope.");sigma.utils.pkg("sigma.settings");var b={legendWidth:130,legendFontFamily:"Arial",legendFontSize:10,legendFontColor:"black",legendTitleFontFamily:"Arial",legendTitleFontSize:15,legendTitleFontColor:"black",legendTitleMaxLength:"30",legendTitleTextAlign:"left",legendShapeColor:"grey",legendBackgroundColor:"white",legendBorderColor:"black",legendBorderRadius:10,legendBorderWidth:1,legendInnerMargin:10,legendOuterMargin:5};sigma.settings=sigma.utils.extend(sigma.settings||{},b)}.call(this),function(a){"use strict";function b(a){var b=this,c=a.settings,e=window.devicePixelRatio||1;this._sigmaInstance=a,this._designPlugin=sigma.plugins.design(a),this._visualSettings={pixelRatio:e,legendWidth:c("legendWidth"),legendFontFamily:c("legendFontFamily"),legendFontSize:c("legendFontSize"),legendFontColor:c("legendFontColor"),legendTitleFontFamily:c("legendTitleFontFamily"),legendTitleFontSize:c("legendTitleFontSize"),legendTitleFontColor:c("legendTitleFontColor"),legendShapeColor:c("legendShapeColor"),legendBackgroundColor:c("legendBackgroundColor"),legendBorderColor:c("legendBorderColor"),legendBorderWidth:c("legendBorderWidth"),legendInnerMargin:c("legendInnerMargin"),legendOuterMargin:c("legendOuterMargin"),legendTitleMaxLength:c("legendTitleMaxLength"),legendTitleTextAlign:c("legendTitleTextAlign"),legendBorderRadius:c("legendBorderRadius")},h(this._visualSettings,function(a,c){"number"==typeof a&&(b._visualSettings[c]=a*e)}),k(this._visualSettings);var f=a.renderers[0];this._canvas=document.createElement("canvas"),this._canvas.style.position="absolute",this._canvas.style.pointerEvents="none",this._renderer=f,f.container.appendChild(this._canvas),window.addEventListener("resize",function(){d(b._canvas,f.container.offsetWidth,f.container.offsetHeight,e),m(b)}),this.textWidgetCounter=1,this.enoughSpace=!0,this.placement="bottom",this.visible=!0,this.widgets={},this.boundingBox={x:0,y:0,w:0,h:0},this.externalCSS=[],this.addWidget("node","size"),this.addWidget("node","color"),this.addWidget("node","icon"),this.addWidget("node","type"),this.addWidget("edge","size"),this.addWidget("edge","color"),this.addWidget("edge","type");var g=function(){f.container.offsetWidth?(d(this._canvas,f.container.offsetWidth,f.container.offsetHeight,e),this.draw()):setTimeout(g,200)}.bind(this);g()}function c(a,b,c,d,e,f){this._canvas=a,this._sigmaInstance=b,this._designPlugin=c,this._legendPlugin=d,this.visualVar=f,this.elementType=e,this.x=0,this.y=0,this.text="",this.unit=null,this.img=new Image,this.pinned=!1}function d(a,b,c,d){a.setAttribute("width",b*d),a.setAttribute("height",c*d),a.style.width=b+"px",a.style.height=c+"px"}function e(a,b){return null==b?null:b.split(".").reduce(function(a,b){return a[b]},a)}function f(a){var b=";base64,";if(-1==a.indexOf(b)){var c=a.split(","),d=c[0].split(":")[1],e=decodeURIComponent(c[1]);return new Blob([e],{type:d})}for(var c=a.split(b),d=c[0].split(":")[1],e=window.atob(c[1]),f=e.length,g=new Uint8Array(f),h=0;f>h;++h)g[h]=e.charCodeAt(h);return new Blob([g],{type:d})}function g(a,b,c){var d=null,e=null,g=null;if(window.Blob?(d=c?f(a):new Blob([a],{type:"text/xml"}),e=window.URL.createObjectURL(d)):g="data:text/xml;charset=UTF-8,"+encodeURIComponent('<?xml version="1.0" encoding="UTF-8"?>')+encodeURIComponent(a),
navigator.msSaveBlob)navigator.msSaveBlob(d,b);else if(navigator.msSaveOrOpenBlob)navigator.msSaveOrOpenBlob(d,b);else{var h=document.createElement("a");h.setAttribute("href",window.Blob?e:g),h.setAttribute("download",b),document.body.appendChild(h),h.click(),document.body.removeChild(h)}e&&setTimeout(function(){window.URL.revokeObjectURL(e)},0)}function h(b,c){for(var d in b)b.hasOwnProperty(d)&&b[d]!==a&&c(b[d],d)}function i(b,c,d,e,f){d=d||{};var g=document.createElement(c);for(var h in d)if(d.hasOwnProperty(h)){var i=d[h];i!==a&&g.setAttribute(h,i)}if(e!==a||f){"[object Object]"===Object.prototype.toString.call(e)&&(e=JSON.stringify(e));var j=document.createTextNode(e);g.appendChild(j)}return b.appendChild(g),g}function j(a,b){if(!a.svg)return void b();var c="";c+='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="'+a.svg.width+'px" height="'+a.svg.height+'px">',c+=a.svg.innerHTML+"</svg>";var d="data:image/svg+xml;base64,"+btoa(unescape(encodeURIComponent(c)));a.img.src!==d?(a.img.onload=b,a.img.src=d):b()}function k(a){a.totalWidgetWidth=a.legendWidth+2*(a.legendBorderWidth+a.legendOuterMargin)}function l(a,b){var c=0,d=Object.keys(a.widgets).length;h(a.widgets,function(a,e){x(a,function(){++c,b&&c===d&&b()})})}function m(a){var b=a._visualSettings,c=a.placement,d="top"===c||"bottom"===c,e=a._canvas.height,f=a._canvas.width,g=r(a.widgets,"text"),i=r(a.widgets,"node"),j=r(a.widgets,"edge"),k=[g,i,j],l=d?s(a.widgets)+2*b.legendOuterMargin:e,m=Math.floor(f/b.totalWidgetWidth),p=n(d?m:1,2*b.legendOuterMargin),q=0,t=!0,u=!1;if(0!==p.length){for(;t&&!u;)t=!1,q=0,h(k,function(a){var c,e,f=[];if(!t&&!u)for(a.forEach(function(a){f.push(a)});;){c=l-(p[q]?p[q].height:0),e=o(f,c),e.forEach(function(a){p[q].widgets.push(f[a]),p[q].height+=f[a].svg.height});for(var g=e.length-1;g>=0;--g)f.splice(e[g],1);if(!(f.length>0))break;if(d){if(q===m-1){p=n(m,2*b.legendOuterMargin),l+=30,t=!0;break}++q}else{if(p.length===m){u=!0;break}p.push({widgets:[],height:2*b.legendOuterMargin}),++q}}});if(u)a.boundingBox={x:0,y:0,w:0,h:0};else{"right"===c&&p.reverse();for(var w=0;w<p.length;++w)for(var x="bottom"===c?l-p[w].height:0,y=0;y<p[w].widgets.length;++y)p[w].widgets[y].x=b.totalWidgetWidth*w+("right"===c?f-p.length*b.totalWidgetWidth:b.legendOuterMargin),"bottom"===c?p[w].widgets[y].y=e-l+x+2*b.legendOuterMargin:p[w].widgets[y].y=x+b.legendOuterMargin,x+=p[w].widgets[y].svg.height;var z=p.reduce(function(a,c){return a+(c.height>2*b.legendOuterMargin?1:0)},0),A=z*(b.totalWidgetWidth+b.legendOuterMargin)+b.legendOuterMargin,B=p.reduce(function(a,b){return a>b.height?a:b.height},0);a.boundingBox={w:A,h:B,x:"right"===a.placement?f-A:0,y:"bottom"===a.placement?e-B:0}}v(a),a.enoughSpace=!u}}function n(a,b){for(var c=[],d=0;a>d;++d)c.push({widgets:[],height:b});return c}function o(a,b){var c={indexes:[],height:0},d=p(a.length,0);return d.forEach(function(d){var e=q(a,d);e>c.height&&b>=e&&(c.indexes=d,c.height=e)}),c.indexes}function p(a,b){if(b===a)return[];var c=[[b]],d=p(a,b+1);return d.forEach(function(a){c.push([b].concat(a))}),c=c.concat(d)}function q(a,b){var c=0;return b.forEach(function(b){c+=a[b].svg.height}),c}function r(a,b){var c=[];return h(a,function(a){a.svg&&!a.pinned&&a.elementType===b&&c.push(a)}),c}function s(a){var b=0;return h(a,function(a){a.svg&&a.svg.height>b&&(b=a.svg.height)}),b}function t(a,b){return a+"_"+b}function u(a){var b=a._canvas.getContext("2d");b.clearRect(0,0,a._canvas.width,a._canvas.height)}function v(a){u(a),h(a.widgets,function(b){w(a,b)&&B(b)})}function w(b,c){return b.visible&&(b.enoughSpace||c.pinned)&&b.widgets[c.id]!==a&&null!==c.svg}function x(a,b){var c=a._legendPlugin._visualSettings;if("size"===a.visualVar)a.svg=G(c,a._sigmaInstance.graph,a._designPlugin,a.elementType,a.unit);else if("text"!==a.elementType)a.svg=H(c,a._sigmaInstance.graph,a._designPlugin,a.elementType,a.visualVar,a.unit);else{var d=z(c,a.text,c.legendWidth-2*c.legendInnerMargin),e=c.legendFontSize+1,f=d.length*e+2*c.legendInnerMargin,g=c.legendInnerMargin+e;a.svg=document.createElement("svg"),L(a.svg,c,f);for(var h=0;h<d.length;++h)J(c,a.svg,d[h],c.legendInnerMargin,g),g+=e;a.svg.width=c.totalWidgetWidth,a.svg.height=f+2*(c.legendBorderWidth+c.legendOuterMargin)}j(a,b)}function y(a){x(a,function(){m(a._legendPlugin)})}function z(a,b,c){for(var d=!1,e=V(" ",a.legendFontFamily,a.legendFontSize,d),f=b.split(" "),g=[{width:-e,words:[]}],h=0,i=[],j=0;j<f.length;++j){var k=V(f[j]+" ",a.legendFontFamily,a.legendFontSize,d);g[h].width+k<=c?(g[h].words.push(f[j]+" "),g[h].width+=k):(g.push({width:k-e,words:[f[j]+" "]}),h++)}for(j=0;j<g.length;++j){for(var l="",m=0;m<g[j].words.length;++m)l+=g[j].words[m];i.push(l)}return i}function A(a){var b=a.split(".");return b.length>2&&"categories"===b[b.length-2]||b.length>=1&&"categories"===b[1]?"Category":T(b[b.length-1])}function B(a){if(a.img){var b=a._canvas.getContext("2d");b.drawImage(a.img,a.x,a.y),"node"===a.elementType&&"icon"===a.visualVar&&(b.textBaseline="middle",a.svg.icons.forEach(function(c){b.fillStyle=c.color,b.font=c.fontSize+"px "+c.font,b.fillText(c.content,a.x+c.x,a.y+c.y)}))}}function C(a,b){for(var c=null,d=null,f=1;f<a.length;++f){var g=e(a[f],b);"number"==typeof g&&((!c||c>g)&&(c=g),(!d||g>d)&&(d=g))}return{min:c?c:0,max:d?d:0}}function D(a,b){for(var c=[],d=a.max-a.min,e=0;b+1>e;++e)c.push(a.min+d*(e/b));return c}function E(a,b){for(var c={},d=0;d<a.length;++d){var f=e(a[d],b);f&&"object"==typeof f?h(f,function(a){c[a]=!0}):c[f]=!0}return c}function F(a,b){var c=0;return h(a,function(a,d){b[d]&&++c}),c}function G(a,b,c,d,e){var f=a,g=document.createElement("svg"),h="node"===d?b.nodes():b.edges(),i="node"===d?c.styles.nodes:c.styles.edges,j=f.legendTitleFontSize+f.legendInnerMargin+1.5*f.legendFontSize;if(!i.size)return null;var k,l=i.size.by,m=C(h,l),n=m.min,o=m.max,p=n%1===0&&o%1===0,q=p?Math.round((n+o)/2):(n+o)/2,r=i.size.max/i.size.min,s=1.5*f.legendFontSize,t=s/r,u=(s+t)/2;if("node"===d){var v=2;k=j+2*s+10,L(g,f,k),S(f,g,A(i.size.by),e);var w=2*s+v+2*f.legendInnerMargin;J(f,g,W(o,p),w,j+f.legendFontSize),J(f,g,W(q,p),w,j+2*f.legendFontSize),J(f,g,W(n,p),w,j+3*f.legendFontSize),K(g,s+f.legendInnerMargin,j+s,s,f.legendBackgroundColor,f.legendShapeColor,v),K(g,s+f.legendInnerMargin,j+2*s-u,u,f.legendBackgroundColor,f.legendShapeColor,v),K(g,s+f.legendInnerMargin,j+2*s-t,t,f.legendBackgroundColor,f.legendShapeColor,v)}else if("edge"===d){var x=j+1.7*s,y=(f.legendWidth-2*f.legendInnerMargin)/3;k=x+f.legendFontSize,L(g,f,k),S(f,g,A(i.size.by),e),R(g,"rect",{x:f.legendInnerMargin,y:j+5,width:y,height:s/2,fill:f.legendShapeColor}),R(g,"rect",{x:f.legendInnerMargin+y,y:j+5+(s-u)/4,width:y,height:u/2,fill:f.legendShapeColor}),R(g,"rect",{x:f.legendInnerMargin+2*y,y:j+5+(s-t)/4,width:y,height:t/2,fill:f.legendShapeColor}),J(f,g,W(o,p),f.legendInnerMargin+.5*y,x,"middle"),J(f,g,W(q,p),f.legendInnerMargin+1.5*y,x,"middle"),J(f,g,W(n,p),f.legendInnerMargin+2.5*y,x,"middle")}return g.width=f.totalWidgetWidth,g.height=k+2*(f.legendBorderWidth+f.legendOuterMargin),g}function H(a,b,c,d,f,g){var i=a,j=document.createElement("svg"),k="node"===d?b.nodes():b.edges(),l="node"===d?c.styles.nodes:c.styles.edges;if(!l[f])return null;var m,n,o,p,q,r=c.palette,s=1.5*i.legendFontSize,t=i.legendTitleFontSize+i.legendInnerMargin+.8*s,u="color"===f&&l.color.bins,v="edge"===d&&"type"===f,w=u?e(r,l.color.scheme)[l.color.bins]:e(r,l[f].scheme),x=E(k,l[f].by),y=u?Object.keys(w).length:F(w,x),z=s*y+t+(v?s:0),B=i.legendWidth/3,G=t,H="edge"===d?B:1.5*i.legendFontSize+i.legendInnerMargin;return u&&(m=C(k,l.color.by),n=D(m,l.color.bins),o=m.min%1==0&&m.max%1==0),j.icons=[],L(j,i,z),S(i,j,A(l[f].by),g),"edge"===d&&"type"===f&&(p="source node to target node",q=U(p,i.legendFontFamily,i.legendFontSize,i.legendWidth-2*i.legendInnerMargin),J(i,j,p,i.legendInnerMargin,G,"left",i.legendFontColor,i.legendFontFamily,q),G+=s),h(w,function(a,b){if(u||x[b]){"color"===f?(u&&(a=w[w.length-b-1]),"edge"===d?R(j,"rect",{x:i.legendInnerMargin,y:G-s/8,width:B-2*i.legendInnerMargin,height:s/4,fill:a}):K(j,i.legendInnerMargin+i.legendFontSize/2,G,i.legendFontSize/2,a)):"icon"===f?j.icons.push({content:a.content,font:a.font,fontSize:i.legendFontSize,color:i.legendFontColor,x:i.legendInnerMargin,y:G}):"type"===f&&("edge"===d?M(i,j,a,i.legendInnerMargin,B-i.legendInnerMargin,G,i.legendFontSize/3):O(i,j,a,i.legendInnerMargin+i.legendFontSize/2,G,i.legendFontSize/2));var c=2;if(u)p=W(n[y-b-1],o)+" - "+W(n[y-parseInt(b)],o),J(i,j,p,B,G+c,"left",null,null,null,"middle");else{var e=I(T(b),i.legendWidth-i.legendInnerMargin-H,i.legendFontFamily,i.legendFontSize);J(i,j,e,H,G+c,"left",null,null,null,"middle")}G+=s}}),j.width=i.totalWidgetWidth,j.height=z+2*(i.legendBorderWidth+i.legendOuterMargin),j}function I(a,b,c,d){for(var e=V(a,c,d,!1),f=!1;e>b;){f=!0;var g=b/e,a=a.substr(0,a.length*g);e=V(a,c,d,!1)}return f&&(a+="..."),a}function J(a,b,c,d,e,f,g,h,j,k){i(b,"text",{x:d,y:e,"text-anchor":f?f:"left",fill:g?g:a.legendFontColor,"font-size":j?j:a.legendFontSize,"font-family":h?h:a.legendFontFamily,"alignment-baseline":k?k:"auto"},c)}function K(a,b,c,d,e,f,g){i(a,"circle",{cx:b,cy:c,r:d,fill:e,stroke:f,"stroke-width":g})}function L(a,b,c){R(a,"rect",{x:b.legendBorderWidth,y:b.legendBorderWidth,width:b.legendWidth,height:c,stroke:b.legendBorderColor,"stroke-width":b.legendBorderWidth,fill:b.legendBackgroundColor,rx:b.legendBorderRadius,ry:b.legendBorderRadius})}function M(a,b,c,d,e,f,g){var h=2.5*g,i=3*g,j=Math.sqrt(3)/2*h;if("arrow"===c)Q(b,d,f,e-j+1,f,a.legendShapeColor,g),P(b,[e,f,e-j,f-h/2,e-j,f+h/2],a.legendShapeColor);else if("parallel"===c)g*=.8,Q(b,d,f-g,e,f-g,a.legendShapeColor,g),Q(b,d,f+g,e,f+g,a.legendShapeColor,g);else if("curve"===c)N(b,d,f,(d+e)/2,f-i,e,f,a.legendShapeColor,g);else if("curvedArrow"===c){var k,l=e-d;k=40>l?35:60>l?33:30,N(b,d,f,(d+e)/2,f-i,e-h/2,f-g,a.legendShapeColor,g),P(b,[e,f,e-j,f-h/2,e-j,f+h/2],a.legendShapeColor,{angle:k,cx:e,cy:f})}else if("dashed"===c){var m="8 3";Q(b,d,f,e,f,a.legendShapeColor,g,m)}else if("dotted"===c){var n="2";Q(b,d,f,e,f,a.legendShapeColor,g,n)}else"tapered"===c&&P(b,[d,f+g,d,f-g,e,f],a.legendShapeColor)}function N(a,b,c,d,e,f,g,h,j){var k="M "+b+" "+c+" Q "+d+" "+e+" "+f+" "+g;i(a,"path",{d:k,stroke:h,"stroke-width":j,fill:"none"})}function O(a,b,c,d,e,f){var g,h=[];if("diamond"===c)f*=1.3,h=[d-f,e,d,e-f,d+f,e,d,e+f];else if("star"===c){f*=1.7,g=-Math.PI/2;for(var i=0;5>i;++i)h[2*i]=Math.cos(g),h[2*i+1]=Math.sin(g),g+=4*Math.PI/5}else if("equilateral"===c){f*=1.3;var j=5;g=-Math.PI/2;for(var i=0;j>i;++i)h[2*i]=Math.cos(g),h[2*i+1]=Math.sin(g),g+=2*Math.PI/j}else"square"===c&&(h=[d-f,e-f,d+f,e-f,d+f,e+f,d-f,e+f]);if("star"===c||"equilateral"===c)for(var i=0;i<h.length;i+=2)h[i]=d+h[i]*f,h[i+1]=e+h[i+1]*f;if("cross"!==c)P(b,h,a.legendShapeColor);else{f*=1.2;var k=2*window.devicePixelRatio;Q(b,d-f,e,d+f,e,a.legendShapeColor,k),Q(b,d,e-f,d,e+f,a.legendShapeColor,k)}}function P(a,b,c,d){for(var e=b[0]+","+b[1],f=2;f<b.length;f+=2)e+=" "+b[f]+","+b[f+1];var g={points:e,fill:c};d&&(g.transform="rotate("+d.angle+", "+d.cx+", "+d.cy+")"),i(a,"polygon",g)}function Q(a,b,c,d,e,f,g,h){i(a,"line",{x1:b,y1:c,x2:d,y2:e,stroke:f,"stroke-width":g,"stroke-dasharray":h})}function R(a,b,c){i(a,b,c)}function S(a,b,c,d){var e=(c.length>a.legendTitleMaxLength?c.substring(0,a.legendTitleMaxLength):c)+(d?" ("+d+")":""),f=U(e,a.legendTitleFontFamily,a.legendTitleFontSize,a.legendWidth-a.legendInnerMargin),g="middle"===a.legendTitleTextAlign?a.legendWidth/2:a.legendInnerMargin;J(a,b,e,g,a.legendFontSize+a.legendInnerMargin,a.legendTitleTextAlign,a.legendTitleFontColor,a.legendTitleFontFamily,f)}function T(a){return a.charAt(0).toUpperCase()+a.slice(1).replace(/_/g," ")}function U(a,b,c,d){for(;V(a,b,c,!1)>d;)c-=c>15?2:1;return c}function V(a,b,c,d){return d?.45*c*a.length:(X.font=c+"px "+b,X.measureText(a).width)}function W(a,b){var c=["K","M","G","T","P","E","Z","Y"];if(a>9999){for(var d=0;d<c.length&&a>999;)a/=1e3,++d;return Math.ceil(a)+c[d-1]}return b?Math.round(a).toString():10>a?(Math.round(1e3*a)/1e3).toString():100>a?(Math.round(100*a)/100).toString():1e3>a?(Math.round(10*a)/10).toString():Math.round(a).toString()}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");var X=document.createElement("canvas").getContext("2d"),Y={};sigma.plugins.legend=function(a){return Y[a.id]||(Y[a.id]=new b(a),a.bind("kill",function(){sigma.plugins.killLegend(a)})),Y[a.id]},sigma.plugins.killLegend=function(b){var c=Y[b.id];c&&(h(c.widgets,function(b,d){c.widgets[d]=a}),Y[b.id]=a)},b.prototype.draw=function(a){var b=this;l(this,function(){m(b),a&&a()})},b.prototype.setVisibility=function(a){this.visible=a,m(this)},b.prototype.setPlacement=function(a){-1!==["top","bottom","right","left"].indexOf(a)&&(this.placement=a,m(this))},b.prototype.addWidget=function(a,b,d){var e=this.widgets[t(a,b)];return e||(e=new c(this._canvas,this._sigmaInstance,this._designPlugin,this,a,b),e.id=t(a,b),this.widgets[e.id]=e),e.unit=d,y(e),e},b.prototype.getWidget=function(a,b){return this.widgets[t(a,b)]},b.prototype.addTextWidget=function(a){var b=new c(this._canvas,this._sigmaInstance,this._designPlugin,this,"text");return b.text=a,b.id="text"+this.textWidgetCounter++,this.widgets[b.id]=b,y(b),b},b.prototype.removeWidget=function(b,d){var e=b instanceof c?b.id:t(b,d);this.widgets[e]&&(this.widgets[e]=a,m(this))},b.prototype.removeAllWidgets=function(){this.widgets={},m(this)},c.prototype.unpin=function(){this.pinned=!1,m(this._legendPlugin)},c.prototype.setPosition=function(a,b){this.pinned=!0,this.x=a,this.y=b,m(this._legendPlugin)},c.prototype.setText=function(a){this.text=a,y(this)},c.prototype.setUnit=function(a){this.unit=a,y(this)},b.prototype.setExternalCSS=function(a){this.externalCSS=a},b.prototype.exportPng=function(a){var b=this.visible,c=this;c.visible=!0,c.draw(function(){var d=document.createElement("canvas"),e=d.getContext("2d"),f=c.boundingBox;d.width=f.w,d.height=f.h,e.drawImage(c._canvas,f.x,f.y,f.w,f.h,0,0,f.w,f.h),c.setVisibility(b),g(d.toDataURL(),a?a:"legend.png",!0)})},b.prototype.exportSvg=function(a){var b=this;this.draw(function(){var c=b._visualSettings,d=b.boundingBox,e="";(b.externalCSS||[]).forEach(function(a){e+='<?xml-stylesheet type="text/css" href="'+a+'" ?>\n'}),e+='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="'+d.w+'px" height="'+d.h+'px">',h(b.widgets,function(a){if(null!==a.svg){if(e+='<g transform="translate('+(a.x+-d.x)+" "+(a.y-d.y)+')">',e+=a.svg.innerHTML,"icon"===a.visualVar){var b=document.createElement("svg");a.svg.icons.forEach(function(a){J(c,b,a.content,a.x,a.y,"left",c.legendFontColor,a.font,c.legendFontSize,"central")}),e+=b.innerHTML}e+="</g>"}}),e+="</svg>",g(e,a?a:"legend.svg")})}}.call(this),function(){"use strict";function a(a,b,c){function d(a){var b=window.getComputedStyle(a),c=function(a){return parseInt(b.getPropertyValue(a).replace("px",""))||0};return{left:a.getBoundingClientRect().left+c("padding-left"),top:a.getBoundingClientRect().top+c("padding-top")}}function e(a){u=!1,n.removeEventListener("mousemove",j),n.removeEventListener("mouseup",i),t?setTimeout(function(){r=t,p.addEventListener("mousedown",h)},0):r=null}function f(a){if(0!=a.data.enter.nodes.length){var b=a.data.enter.nodes[0];t&&t.id===b.id||(t=b,u||(r=t,p.addEventListener("mousedown",h)))}}function g(a){if(0!=a.data.leave.nodes.length){var b=a.data.leave.nodes[0];t&&t.id===b.id?(t=null,r=null):t||p.removeEventListener("mousedown",h)}}function h(a){y&&3!=a.which&&(u=!0,r&&l.graph.nodes().length>0&&(x=!0,p.removeEventListener("mousedown",h),n.addEventListener("mousemove",j),n.addEventListener("mouseup",i),o.settings({mouseEnabled:!1,enableHovering:!1}),k.dispatchEvent("startdrag",{node:r,captor:a,renderer:o})))}function i(a){if(u=!1,p.addEventListener("mousedown",h),n.removeEventListener("mousemove",j),n.removeEventListener("mouseup",i),o.settings({mouseEnabled:!0,enableHovering:!0}),w){if(k.dispatchEvent("drop",{node:s,captor:a,renderer:o}),m)for(var b=m.nodes(),c=0;c<b.length;c++)b[c].alphaX=void 0,b[c].alphaY=void 0;l.refresh()}k.dispatchEvent("dragend",{node:r,captor:a,renderer:o}),w=!1,s=null}function j(a){function b(){var b,c,e,f,g,h,i,j=d(o.container),n=a.clientX-j.left,p=a.clientY-j.top,t=Math.cos(o.camera.angle),u=Math.sin(o.camera.angle),v=l.graph.nodes(),z=[];if((!m||m.nbNodes()!==v.length)&&y&&!(v.length<2)&&(i=sigma.utils.getDistance(n,p,r[q+"x"],r[q+"y"]),!(x&&i<r[q+"size"]))){x=!1;for(var A=0;y&&(f=v[A],f&&(g={x:f.x*t+f.y*u,y:f.y*t-f.x*u,renX:f[q+"x"],renY:f[q+"y"]},z.push(g)),A!=v.length-1);A++)if(A>0){if(z[0].x!=z[1].x&&z[0].y!=z[1].y)break;z.pop()}var B=z[0],C=z[1],D=C.renX-B.renX;0===D&&(D=1);var E=C.renY-B.renY;if(0===E&&(E=1),n=(n-B.renX)/D*(C.x-B.x)+B.x,p=(p-B.renY)/E*(C.y-B.y)+B.y,b=n*t-p*u,c=p*t+n*u,m&&(e=m.nodes(),h=-1<e.map(function(a){return a.id}).indexOf(r.id)))for(var A=0;A<e.length;A++)s!=r&&(e[A].alphaX=void 0,e[A].alphaY=void 0),e[A].alphaX&&e[A].alphaY||(e[A].alphaX=e[A].x-n,e[A].alphaY=e[A].y-p),e[A].x=r.x+e[A].alphaX,e[A].y=r.y+e[A].alphaY;r.x=b,r.y=c,l.refresh({skipIndexation:!0}),w=!0,s=r,k.dispatchEvent("drag",{node:s,captor:a,renderer:o})}}if(navigator.userAgent.toLowerCase().indexOf("firefox")>-1){clearTimeout(c);var c=setTimeout(b,0)}else b()}if(sigma.classes.dispatcher.extend(this),sigma.renderers.webgl&&b instanceof sigma.renderers.webgl)throw new Error("The sigma.plugins.dragNodes is not compatible with the WebGL renderer");var k=this,l=a,m=c,n=document.body,o=b,p=b.container.getElementsByClassName("sigma-mouse")[0],q=b.options.prefix,r=null,s=null,t=null,u=!1,v=!1,w=!1,x=!0,y=!0;b instanceof sigma.renderers.svg&&(p=b.container.firstChild),b.bind("hovers",f),b.bind("hovers",g),b.bind("click",e),this.enable=function(){y=!0},this.disable=function(){y=!1,r=null,s=null,t=null,u=!1,v=!1,w=!1,x=!0},this.unbindAll=function(){p.removeEventListener("mousedown",h),n.removeEventListener("mousemove",j),n.removeEventListener("mouseup",i),o.unbind("hovers",f),o.unbind("hovers",g)}}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");var b={};sigma.plugins.dragNodes=function(c,d,e){return b[c.id]||(b[c.id]=new a(c,d,e)),c.bind("kill",function(){sigma.plugins.killDragNodes(c)}),c.bind("animate.start",function(){b[c.id].disable()}),c.bind("animate.end",function(){b[c.id].enable()}),b[c.id]},sigma.plugins.killDragNodes=function(c){b[c.id]instanceof a&&(b[c.id].unbindAll(),delete b[c.id])}}.call(window),function(undefined){"use strict";function deepCopy(o){var copy=Object.create(null);for(var i in o)"object"==typeof o[i]&&null!==o[i]?copy[i]=deepCopy(o[i]):"function"==typeof o[i]&&null!==o[i]?eval(" copy[i] = "+o[i].toString()):copy[i]=o[i];return copy}function find(a){var b,c,d;if(b=this.siblingEdgesIndex[a]){if(c=this.allNeighborsIndex.get(b.source).get(b.target),1===c.size){if(d=this.edges(c.keyList()[0]),"parallel"!==d.type)throw new Error('The sibling container must be of type "parallel", was '+d.type);if(d.siblings===undefined)throw new Error('The sibling container has no "siblings" key.');if(Object.keys(d.siblings).length<2)throw new Error("The sibling container must have more than one sibling, had "+Object.keys(d.siblings).length);if(d.siblings[a]===undefined)throw new Error("Sibling container found but the edge sibling is missing.");return d}if(c.size>1){var e;if(c.forEach(function(b,c){if("parallel"===b.type&&b.siblings!==undefined){if(!Object.keys(b.siblings).length)throw new Error("Edge sibling found but its container is missing.");b.siblings[a]!==undefined&&(e=b)}}),e!==undefined)return e;throw new Error("Edge sibling found but its container is missing.")}throw new Error("Edge sibling found but its container is missing.")}return this.edgesIndex.get(a)}function get(a){if(!arguments.length||a===undefined)return this.edgesArray.slice(0);if(arguments.length>1)throw new Error("Too many arguments. Use an array instead.");if("number"==typeof a||"string"==typeof a)return find.call(this,a);if(Array.isArray(a)){var b,c,d=[];for(b=0,c=a.length;c>b;b++){if("number"!=typeof a[b]&&"string"!=typeof a[b])throw new Error("Invalid argument: an edge id is not a string or a number, was "+a[b]);d.push(find.call(this,a[b]))}return d}throw new Error('Invalid argument: "v" is not a string or an array, was '+a)}function add(a,b){if(!a.siblings){var c=deepCopy(a);a.siblings={},a.siblings[a.id]=c,delete a.color,delete a.label,a.size=1,a.type="parallel",this.siblingEdgesIndex[c.id]=c}a.siblings[b.id]=b,this.siblingEdgesIndex[b.id]=b}function drop(a,b){if(delete a.siblings[b],delete this.siblingEdgesIndex[b],1===Object.keys(a.siblings).length){var c=a.siblings[Object.keys(a.siblings)[0]];this.dropEdge(a.id),this.addEdge(c),delete this.siblingEdgesIndex[a.id],delete this.siblingEdgesIndex[c.id]}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins"),sigma.classes.graph.hasMethod("edgeSiblings")||sigma.classes.graph.addMethod("edgeSiblings",function(a){return get.call(this,a)}),sigma.classes.graph.hasMethod("addEdgeSibling")||sigma.classes.graph.addMethod("addEdgeSibling",function(a){if(0==arguments.length)throw new TypeError("Missing argument.");if(Object(a)!==a)throw new TypeError('Invalid argument: "edge" is not an object, was '+a);if("number"!=typeof a.id&&"string"!=typeof a.id)throw new TypeError('Invalid argument key: "edge.id" is not a string or a number, was '+a.id);if("number"!=typeof a.source&&"string"!=typeof a.source||!this.nodesIndex.get(a.source))throw new Error('Invalid argument key: "edge.source" is not an existing node id, was '+a.source);if("number"!=typeof a.target&&"string"!=typeof a.target||!this.nodesIndex.get(a.target))throw new Error('Invalid argument key: "edge.target" is not an existing node id, was '+a.target);if(this.edgesIndex.get(a.id))throw new Error('Invalid argument: an edge of id "'+a.id+'" already exists.');if(this.siblingEdgesIndex[a.id])throw new Error('Invalid argument: an edge sibling of id "'+a.id+'" already exists.');var b=this.allNeighborsIndex.get(a.source).get(a.target);if(b!==undefined&&b.size){var c=this.edges(b.get(b.keyList()[0]).id);add.call(this,c,a)}else this.addEdge(a);return this}),sigma.classes.graph.hasMethod("dropEdgeSibling")||sigma.classes.graph.addMethod("dropEdgeSibling",function(a){if(0==arguments.length)throw new TypeError("Missing argument.");if("number"!=typeof a&&"string"!=typeof a)throw new TypeError('Invalid argument: "id" is not a string or a number, was '+a);if(this.siblingEdgesIndex[a]){var b=find.call(this,a);drop.call(this,b,a)}else this.dropEdge(a);return this}),sigma.classes.graph.hasMethod("readWithSiblings")||sigma.classes.graph.addMethod("readWithSiblings",function(a){var b,c,d;for(c=a.nodes||[],b=0,d=c.length;d>b;b++)this.addNode(c[b]);for(c=a.edges||[],b=0,d=c.length;d>b;b++)this.addEdgeSibling(c[b]);return this}),sigma.classes.graph.addIndex("siblingEdgesIndex",{constructor:function(){this.siblingEdgesIndex=Object.create(null)}})}.call(this),function(undefined){"use strict";function deepCopy(o){var copy=Object.create(null);for(var i in o)"object"==typeof o[i]&&null!==o[i]?copy[i]=deepCopy(o[i]):"function"==typeof o[i]&&null!==o[i]?eval(" copy[i] = "+o[i].toString()):copy[i]=o[i];return copy}function cloneChain(a){for(var b=a.slice(0),c=0,d=b.length;d>c;c++)b[c]=deepCopy(b[c]);return b}function strToObjectRef(a,b){return b.split(".").reduce(function(a,b){return a[b]},a)}function Filter(s){function register(a,b,c,d){if(arguments[3]===undefined&&"object"!=typeof arguments[2]&&(d=c,c=null),d!==undefined&&"number"!=typeof d&&"string"!=typeof d)throw new TypeError('Invalid argument: "key" is not a number or a string, was '+d);if(d!==undefined&&"string"==typeof d&&!d.length)throw new TypeError('Invalid argument: "key" is an empty string.');if("string"!=typeof a)throw new TypeError('Invalid argument: "processor" is not a string, was '+a);if("undo"===d)throw new Error('Invalid argument: "key" has value "undo", which is a reserved keyword.');if(_keysIndex[d])throw new Error('Invalid argument: the filter of key "'+d+'" already exists.');d&&(_keysIndex[d]=!0),_chain.push({key:d,processor:a,predicate:b,options:c||{}})}function unregister(a){_chain=_chain.filter(function(b){return!(b.key in a)});for(var b in a)delete _keysIndex[b]}var _self=this,_s=s,_g=s.graph,_chain=[],_keysIndex=Object.create(null);this.has=function(a){return _keysIndex[a]},this.nodesBy=function(a,b,c){return register("nodes",a,b,c),this},this.edgesBy=function(a,b,c){return register("edges",a,b,c),this},this.neighborsOf=function(a,b,c){if("number"!=typeof a&&"string"!=typeof a)throw new TypeError("Invalid argument: id is not a string or a number, was "+a);if("string"==typeof a&&!a.length)throw new TypeError("Invalid argument: id is an empty string.");return register("neighbors",a,b,c),this},this.apply=function(){for(var a=0,b=_chain.length;b>a;++a)switch(_chain[a].processor){case"nodes":Processors.nodes(_g,_chain[a].predicate,_chain[a].options);break;case"edges":Processors.edges(_g,_chain[a].predicate,_chain[a].options);break;case"neighbors":Processors.neighbors(_g,_chain[a].predicate);break;case"undo":Processors.undo(_g,_chain[a].predicate);break;default:throw new Error("Unknown processor "+_chain[a].processor)}return _chain[0]&&"undo"===_chain[0].key&&_chain.shift(),_s&&_s.refresh(),this},this.undo=function(a){var b=Object.create(null),c=arguments.length;if(1===c)if("[object Array]"===Object.prototype.toString.call(a))for(var d=0,e=a.length;e>d;d++)b[a[d]]=!0;else b[a]=!0;else if(c>1)for(var d=0;c>d;d++)b[arguments[d]]=!0;else this.clear();return unregister(b),_chain.unshift({key:"undo",processor:"undo"}),this},this.clear=function(){return _chain.length=0,_keysIndex=Object.create(null),this},this.kill=function(){return this.clear(),delete _instance[_s.id],_g=null,_s=null,this},this.serialize=function(){for(var a=cloneChain(_chain),b=0,c=a.length;c>b;b++)a[b].predicate=a[b].predicate.toString().replace(/\s+/g," ").replace(/"use strict"; /,"");return a},this.load=function(chain){if(chain===undefined)throw new TypeError("Missing argument.");if(!Array.isArray(chain))throw new TypeError('Invalid argument: "chain" is not an array, was '+chain);this.clear();for(var copy=cloneChain(chain),i=0,len=copy.length;len>i;i++){if(copy[i].predicate===undefined)throw new TypeError('Missing filter key: "predicate".');if(copy[i].processor===undefined)throw new TypeError('Missing filter key: "processor".');if(copy[i].key!=undefined&&"string"!=typeof copy[i].key)throw new TypeError('Invalid filter key: "key" is not a string, was '+copy[i].key.toString());if("string"==typeof copy[i].predicate&&eval(" copy[i].predicate = "+copy[i].predicate),"function"!=typeof copy[i].predicate)throw new TypeError('Invalid filter key: "predicate" of key "'+copy[i].key+'" is not a function.');if("string"!=typeof copy[i].processor)throw new TypeError('Invalid filter key: "processor" of key "'+copy[i].key+'" is not a string.');copy[i].key&&(_keysIndex[copy[i].key]=!0)}return _chain=copy,this}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins");var _instance={};sigma.classes.graph.hasMethod("adjacentNodes")||sigma.classes.graph.addMethod("adjacentNodes",function(a,b){if(b=b||{},b.withHidden=2==arguments.length?b.withHidden:!0,"string"!=typeof a&&"number"!=typeof a)throw new TypeError("The node id is not a string or a number, was "+a);var c,d=this,e=[];return(this.allNeighborsIndex.get(a)||[]).forEach(function(f,g){b.withHidden?e.push(d.nodesIndex.get(g)):d.nodes(g).hidden||(c=0!=d.allNeighborsIndex.get(a).get(g).keyList().map(function(a){return d.edges(a)}).filter(function(a){return!a.hidden}).length,c&&e.push(d.nodesIndex.get(g)))}),e}),sigma.classes.graph.hasMethod("adjacentEdges")||sigma.classes.graph.addMethod("adjacentEdges",function(a,b){if(b=b||{},b.withHidden=2==arguments.length?b.withHidden:!0,"string"!=typeof a&&"number"!=typeof a)throw new TypeError("The node id is not a string or a number, was "+a);var c=this,d=this.allNeighborsIndex.get(a)||[],e=[];return d.forEach(function(a,f){d.get(f).forEach(function(a,d){(b.withHidden||!c.edges(d).hidden)&&e.push(c.edges(d))})}),e});var Processors={};Processors.nodes=function(a,b,c){if(a){for(var d=a.nodes(),e=d.length,f=a.edges(),g=f.length;e--;)d[e].hidden=!b.call({graph:a,get:strToObjectRef},d[e],c)||d[e].hidden;for(;g--;)(a.nodes(f[g].source).hidden||a.nodes(f[g].target).hidden)&&(f[g].hidden=!0)}},Processors.edges=function(a,b,c){if(a)for(var d=a.edges(),e=d.length;e--;)d[e].hidden=!b.call({graph:a,get:strToObjectRef},d[e],c)||d[e].hidden},Processors.neighbors=function(a,b){if(a){for(var c=a.nodes(),d=c.length,e=a.edges(),f=e.length,g=a.adjacentNodes(b),h=g.length,i={};h--;)i[g[h].id]=!0;for(;d--;)c[d].id===b||c[d].id in i||(c[d].hidden=!0);for(;f--;)(a.nodes(e[f].source).hidden||a.nodes(e[f].target).hidden)&&(e[f].hidden=!0)}},Processors.undo=function(a){if(a){for(var b=a.nodes(),c=b.length,d=a.edges(),e=d.length;c--;)b[c].hidden=!1;for(;e--;)d[e].hidden=!1}},sigma.plugins.filter=function(a){return _instance[a.id]||(_instance[a.id]=new Filter(a),a.bind("kill",function(){sigma.plugins.killFilter(a)})),_instance[a.id]},sigma.plugins.killFilter=function(a){_instance[a.id]instanceof Filter&&_instance[a.id].kill(),delete _instance[a.id]}}.call(this),function(a){"use strict";function b(){document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement?document.exitFullscreen?document.exitFullscreen():document.msExitFullscreen?document.msExitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitExitFullscreen&&document.webkitExitFullscreen():d.requestFullscreen?d.requestFullscreen():d.msRequestFullscreen?d.msRequestFullscreen():d.mozRequestFullScreen?d.mozRequestFullScreen():d.webkitRequestFullscreen&&d.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT)}function c(a){var c=a||{};d=c.container?"object"==typeof c.container?c.container:document.getElementById(c.container):this.container,e=null,c.btnId?(e=document.getElementById(c.btnId),e.removeEventListener("click",b),e.addEventListener("click",b)):b()}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins.fullScreen");var d=null,e=null;sigma.plugins.fullScreen=c}.call(this),function(a){"use strict";function b(a){return a===a&&"[object Number]"===Object.prototype.toString.call(a)}function c(a){return"object"==typeof a&&!!a}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins"),sigma.plugins.generators={},sigma.plugins.generators.random=function(a){if(!a)throw new Error("Missing argument: options");if(!c(a))throw new TypeError("Invalid argument: options is not an object, was "+a);if(!b(a.nbNodes)||a.nbNodes<1)throw new TypeError("Invalid argument: options.nbNodes is not a positive number, was "+a.nbNodes);if(!b(a.nbEdges)||a.nbEdges<1)throw new TypeError("Invalid argument: options.nbEdges is not a number, was "+a.nbEdges);var d,e=a.nbNodes,f=a.nbEdges,g={nodes:[],edges:[]};for(d=0;e>d;d++)g.nodes.push({id:"n"+d,label:"Node "+d,x:Math.random(),y:Math.random(),size:1});for(d=0;f>d;d++)g.edges.push({id:"e"+d,label:"Edge "+d,source:"n"+(Math.random()*e|0),target:"n"+(Math.random()*e|0)});return g},sigma.plugins.generators.balancedTree=function(a){if(!a)throw new Error("Missing argument: options");if(!c(a))throw new TypeError("Invalid argument: options is not an object, was "+a);if(!b(a.nbChildren)||a.nbChildren<1)throw new TypeError("Invalid argument: options.nbChildren is not a positive number, was "+a.nbChildren);if(!b(a.height)||a.height<1)throw new TypeError("Invalid argument: options.height is not a positive number, was "+a.height);var d,e,f,g,h,i=0,j=0,k=a.nbChildren,l=a.height,m={nodes:[{id:"n0",label:"Node 0",x:Math.random(),
y:Math.random(),size:1,index:0}],edges:[]},n=[];for(d=0;k>d;d++)g={id:"n"+ ++i,label:"Node "+i,x:Math.random(),y:Math.random(),size:1,index:i-1},m.nodes.push(g),n.push(g),m.edges.push({id:"e"+j++,label:"Edge "+j,source:"n0",target:"n"+i});for(f=1;l>f;f++)for(h=n,n=[],e=0;e<h.length;e++)for(d=0;k>d;d++)g={id:"n"+ ++i,label:"Node "+i,x:Math.random(),y:Math.random(),size:1,index:i-1},n.push(g),m.nodes.push(g),m.edges.push({id:"e"+j++,label:"Edge "+j,source:"n"+h[e].index,target:"n"+i});return m},sigma.plugins.generators.erdosRenyi=function(a){if(!a)throw new Error("Missing argument: options");if(!c(a))throw new TypeError("Invalid argument: options is not an object, was "+a);if(!b(a.nbNodes)||a.nbNodes<1)throw new TypeError("Invalid argument: options.nbNodes is not a positive number, was "+a.nbNodes);if(a.nbNodes<3)throw new TypeError("Invalid argument: options.nbNodes is smaller than 3, was "+a.nbNodes);if("nbEdges"in a&&"p"in a)throw new TypeError("Invalid argument: choose between options.nbEdges and options.p");var d,e,f,g={nodes:[],edges:[]},h=0,i=a.nbNodes,j=a.p;if(a.p>=0){if(!b(a.p)||a.p<0)throw new TypeError("Invalid argument: options.p is not a positive number, was "+a.p);for(e=0;i>e;e++)for(g.nodes.push({id:"n"+e,label:"Node "+e,x:Math.random(),y:Math.random(),size:1}),f=0;e>f;f++)Math.random()<j&&g.edges.push({id:"e"+h++,label:"Edge "+h,source:"n"+e,target:"n"+f})}else{if(!b(a.nbEdges)||a.nbEdges<1)throw new TypeError("Invalid argument: options.nbEdges is not a positive number, was "+a.nbEdges);var h,k=[],l=a.nbEdges;for(e=0;i>e;e++)for(g.nodes.push({id:"n"+e,label:"Node "+e,x:Math.random(),y:Math.random(),size:1}),f=e+1;i>f;f++)k.push({source:"n"+e,target:"n"+f});for(h=k.length-1,e=0;l>e;e++)d=k.splice(Math.floor(Math.random()*h),1)[0],d.id="e"+e,d.label="Edge "+e,g.edges.push(d),h--}return g},sigma.plugins.generators.barabasiAlbert=function(a){if(!a)throw new Error("Missing argument: options");if(!c(a))throw new TypeError("Invalid argument: options is not an object, was "+a);if(!b(a.nbNodes)||a.nbNodes<1)throw new TypeError("Invalid argument: options.nbNodes is not a positive number, was "+a.nbNodes);if(a.nbNodes<3)throw new TypeError("Invalid argument: options.nbNodes is smaller than 3, was "+a.nbNodes);if(!b(a.m0)||a.m0<=0)throw new TypeError("Invalid argument: options.m0 is not a positive number, was "+a.m0);if(!b(a.m)||a.m<=0)throw new TypeError("Invalid argument: options.m is not a positive number, was "+a.m);if(a.m0>=a.nbNode)throw new TypeError("Invalid argument: options.m0 is greater than options.nbNodes, was "+a.m0);if(a.m>a.m0)throw new TypeError("Invalid argument: options.m is strictly greater than options.m0, was "+a.m);var d,e,f,g,h,i,j,k,l={nodes:[],edges:[]},m={},n=[],o=0,p=a.nbNodes,q=a.m0,r=a.m;for(d=0;q>d;d++)l.nodes.push({id:"n"+d,label:"node "+d,x:Math.random(),y:Math.random(),size:1}),n[d]=0;for(d=0;q>d;d++)for(e=d+1;q>e;e++)f={id:"e"+o++,label:"Edge "+o,source:"n"+d,target:"n"+e},m[f.source+"-"+f.target]=f,l.edges.push(f),n[d]++,n[e]++;for(d=q;p>d;d++){for(l.nodes.push({id:"n"+d,label:"node "+d,x:Math.random(),y:Math.random(),size:1}),n[d]=0,g=0,e=0;d>e;e++)g+=n[e];for(h=0,i=0;r>i;i++)for(j=Math.random(),k=0,e=0;d>e;e++)if(!m[d+"-"+e]&&!m[e+"-"+d]&&(1==d?k=1:k+=n[e]/g+h/(d-i),k>=j)){h+=n[e]/g,f={id:"e"+o++,label:"Edge "+o,source:"n"+d,target:"n"+e},m[f.source+"-"+f.target]=f,l.edges.push(f),n[d]++,n[e]++;break}}return l},sigma.plugins.generators.wattsStrogatz=function(a){function d(b,c){if(b==c||k[b+"-"+c])return 0;var d=e(b,c);return d>=m?1:0===d?r:Math.pow(d/m,a.alpha)*(1-r)+r}function e(a,b){var c,d=0;for(c=0;l>c;c++)c!=a&&c!=b&&k[a+"-"+c]&&k[b+"-"+c]&&d++;return d}if(!a)throw new Error("Missing argument: options");if(!c(a))throw new TypeError("Invalid argument: options is not an object, was "+a);if(!b(a.nbNodes)||a.nbNodes<1)throw new TypeError("Invalid argument: options.nbNodes is not a positive number, was "+a.nbNodes);if(a.nbNodes<3)throw new TypeError("Invalid argument: options.nbNodes is smaller than 3, was "+a.nbNodes);if(!b(a.k)||a.k%2!=0)throw new TypeError("Invalid argument: options.k is not an even integer, was "+a.k);var f,g,h,i={nodes:[],edges:[]},j=0,k={},l=a.nbNodes,m=a.k;if("alpha"in a){if(!b(a.alpha)||a.alpha<0||a.alpha>1)throw new TypeError("Invalid argument: options.alpha is not a number between [0,1], was "+a.alpha);var n,o,p,q,r=Math.pow(10,-10),s=0,t=[],u=l*m/2;for(f=0;l>f;f++)i.nodes.push({id:"n"+f,label:"Node "+f,x:Math.random(),y:Math.random(),size:1}),h={id:"e"+j++,label:"Edge "+j,source:"n"+f,target:"n"+(f+1)%l},k[h.source+"-"+h.target]=h,i.edges.push(h),s++;for(;u>s;){for(f=0;l>f;f++)t.push(f);for(;u>s&&t.length>0;){for(f=t.splice(Math.floor(Math.random()*t.length),1)[0],n=[],o=0,g=0;l>g;g++)n[g]=d(f,g),o+=n[g];for(p=Math.random(),q=0,g=0;l>g;g++)f!=g&&(q+=n[g]/o,q>=p&&(h={id:"e"+j++,label:"Edge "+j,source:"n"+f,target:"n"+g},i.edges.push(h),s++,k[h.source+"-"+h.target]=h))}}}else{if(!b(a.beta)||a.beta<0||a.beta>1)throw new TypeError("Invalid argument: options.beta is not a number between [0,1], was "+a.beta);var v;for(m>>=1,f=0;l>f;f++)for(i.nodes.push({id:"n"+f,label:"node "+f,x:Math.random(),y:Math.random(),size:1}),g=1;m>=g;g++)h={id:"e"+j++,label:"Edge "+j,source:"n"+f,target:"n"+(f+g)%l},k[h.source+"-"+h.target]=h,i.edges.push(h);for(f=0;l>f;f++)for(g=1;m>=g;g++)if(Math.random()<=a.beta){do v=Math.floor(Math.random()*(l-1));while(v==f||k["n"+f+"-n"+v]);var w=(f+g)%l;k["n"+f+"-n"+w].target="n"+v,k["n"+f+"-n"+v]=k["n"+f+"-n"+w],delete k["n"+f+"-n"+w]}}return i},sigma.plugins.generators.path=function(a){if(!a||0>a)throw new TypeError('Invalid argument: "length" is not a positive number, was '+a);for(var b={nodes:[{id:"n0",label:"Node 0",x:Math.random(),y:Math.random(),size:1}],edges:[]},c=1;a>c;++c)b.nodes.push({id:"n"+c,label:"Node "+c,x:Math.random(),y:Math.random(),size:1}),b.edges.push({id:"e"+c,label:"Edge "+c,source:"n"+(c-1),target:"n"+c});return b},sigma.plugins.generators.grid=function(a,b){if(1>a)throw new TypeError('Invalid argument: "n" is not a positive integer, was '+a);if(1>b)throw new TypeError('Invalid argument: "m" is not a positive integer, was '+b);var c,d,e,f,g={nodes:[],edges:[]},h=0,i=[];if(i.length=a*b,1===a&&1===b)return g.nodes.push({id:"n0",label:"Node 0",x:Math.random(),y:Math.random(),size:1}),g;for(c=0;a>c;++c)for(d=0;b>d;++d)e=c+d*a,i[e]||(g.nodes.push({id:"n"+e,label:"Node "+e,x:Math.random(),y:Math.random(),size:1}),i[e]=!0),c>0&&(f=c-1+d*a,i[f]||(g.nodes.push({id:"n"+f,label:"Node "+f,x:Math.random(),y:Math.random(),size:1}),i[f]=!0),g.edges.push({id:"e"+h++,label:"Edge "+h,source:"n"+e,target:"n"+f})),d>0&&(f=c+(d-1)*a,i[f]||(g.nodes.push({id:"n"+f,label:"Node "+f,x:Math.random(),y:Math.random(),size:1}),i[f]=!0),g.edges.push({id:"e"+h++,label:"Edge "+h,source:"n"+e,target:"n"+f}));return g}}.call(this),function(a){"use strict";function b(a,b,d){function e(b){var c=Math.max(a.settings("zoomMin"),Math.min(a.settings("zoomMax"),a.camera.ratio*(b.ratio||1)));sigma.misc.animation.camera(a.camera,{x:a.camera.x+(b.x||0),y:a.camera.y+(b.y||0),ratio:c},{duration:b.duration})}function f(){e({x:-d.displacement,duration:d.duration})}function g(){e({y:-d.displacement,duration:d.duration})}function h(){e({x:d.displacement,duration:d.duration})}function i(){e({y:d.displacement,duration:d.duration})}function j(){e({ratio:1/d.zoomingRatio,duration:d.duration})}function k(){e({ratio:d.zoomingRatio,duration:d.duration})}function l(){n.domElt.addEventListener("keydown",n.keyDown),n.domElt.addEventListener("keyup",n.keyUp),n.bind("37 18+37",f),n.bind("38 18+38",g),n.bind("39 18+39",h),n.bind("40 18+40",i),n.bind("32+38 18+32+38",j),n.bind("32+40 18+32+40",k)}function m(){n.domElt.removeEventListener("keydown",n.keyDown),n.domElt.removeEventListener("keyup",n.keyUp),n.unbind()}d=sigma.utils.extend(d,c),d.zoomingRatio=d.zoomingRatio||a.settings("zoomingRatio"),d.duration=d.duration||a.settings("mouseZoomDuration"),this.domElt=b.container,this.keys={},this.currentEvents=null;var n=this;sigma.classes.dispatcher.extend(this),this.domElt.tabIndex=d.tabIndex,this.keyDown=function(a){9===a.which||18===a.which||20===a.which||n.keys[a.which]||(n.keys[a.which]=!0,n.currentEvents=Object.keys(n.keys).join("+"),n.dispatchEvent(n.currentEvents))},this.keyUp=function(a){delete n.keys[a.which],n.currentEvents=null},this.focus=function(a){return n.domElt.focus(),!0},this.blur=function(a){return n.domElt.blur(),n.keys={},n.currentEvents=null,!0},this.kill=function(){m(),n.domElt=null,n.keys={},n.currentEvents=null},l()}if("undefined"==typeof sigma)throw"sigma.plugins.keyboard: sigma is not declared";sigma.utils.pkg("sigma.plugins");var c={displacement:100,duration:200,zoomingRatio:1.7,tabIndex:-1},d={};sigma.plugins.keyboard=function(a,c,e){return d[a.id]||(d[a.id]=new b(a,c,e),a.bind("kill",function(){sigma.plugins.killKeyboard(a)})),d[a.id]},sigma.plugins.killKeyboard=function(a){d[a.id]instanceof b&&(d[a.id].kill(),delete d[a.id])}}.call(this),function(a){"use strict";function b(b,c,d){if(sigma.classes.dispatcher.extend(this),sigma.renderers.webgl&&c instanceof sigma.renderers.webgl)throw new Error("The sigma.plugins.lasso is not compatible with the WebGL renderer");this.sigmaInstance=b,this.renderer=c,this.drawingCanvas=a,this.drawingContext=a,this.drewPoints=[],this.selectedNodes=[],this.isActive=!1,this.isDrawing=!1,f=document.body,this.settings=new sigma.classes.configurable({strokeStyle:"black",lineWidth:2,fillWhileDrawing:!1,fillStyle:"rgba(200, 200, 200, 0.25)",cursor:"crosshair"},d||{})}function c(a){var b=this.drawingCanvas.getBoundingClientRect();this.isActive&&(this.isDrawing=!0,this.drewPoints=[],this.selectedNodes=[],this.sigmaInstance.refresh(),this.drewPoints.push({x:a.clientX-b.left,y:a.clientY-b.top}),this.drawingCanvas.style.cursor=this.settings("cursor"),a.stopPropagation())}function d(a){if(this.isActive&&this.isDrawing){var b=0,c=0,d=this.drawingCanvas.getBoundingClientRect();switch(a.type){case"touchmove":b=a.touches[0].clientX,c=a.touches[0].clientY;break;default:b=a.clientX,c=a.clientY}this.drewPoints.push({x:b-d.left,y:c-d.top}),this.drawingContext.lineWidth=this.settings("lineWidth"),this.drawingContext.strokeStyle=this.settings("strokeStyle"),this.drawingContext.fillStyle=this.settings("fillStyle"),this.drawingContext.lineJoin="round",this.drawingContext.lineCap="round",this.drawingContext.clearRect(0,0,this.drawingContext.canvas.width,this.drawingContext.canvas.height);var e=this.drewPoints[0],f=this.drewPoints[1],g=this.drewPoints.length,h=function(a,b){return{x:a.x+(b.x-a.x)/2,y:a.y+(b.y-a.y)/2}};this.drawingContext.beginPath(),this.drawingContext.moveTo(e.x,e.y);for(var i=1;g>i;i++){var j=h(e,f);this.drawingContext.quadraticCurveTo(e.x,e.y,j.x,j.y),e=this.drewPoints[i],f=this.drewPoints[i+1]}this.drawingContext.lineTo(e.x,e.y),this.drawingContext.stroke(),this.settings("fillWhileDrawing")&&this.drawingContext.fill(),a.stopPropagation()}}function e(a){if(this.isActive&&this.isDrawing){this.isDrawing=!1;for(var b=this.renderer.nodesOnScreen,c=b.length,d=this.renderer.options.prefix||"";c--;){var e=b[c],f=e[d+"x"],g=e[d+"y"];this.drawingContext.isPointInPath(f,g)&&!e.hidden&&this.selectedNodes.push(e)}this.dispatchEvent("selectedNodes",this.selectedNodes),this.drawingContext.clearRect(0,0,this.drawingCanvas.width,this.drawingCanvas.height),this.drawingCanvas.style.cursor=this.settings("cursor"),a.stopPropagation()}}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");var f=a,g={};b.prototype.clear=function(){return this.deactivate(),this.sigmaInstance=a,this.renderer=a,this},b.prototype.activate=function(){return this.sigmaInstance&&!this.isActive&&(this.isActive=!0,this.renderer.domElements.lasso||(this.renderer.initDOM("canvas","lasso"),this.drawingCanvas=this.renderer.domElements.lasso,this.drawingCanvas.width=this.renderer.container.offsetWidth,this.drawingCanvas.height=this.renderer.container.offsetHeight,this.renderer.container.appendChild(this.drawingCanvas),this.drawingContext=this.drawingCanvas.getContext("2d"),this.drawingCanvas.style.cursor=this.settings("cursor")),h.apply(this)),this},b.prototype.deactivate=function(){return this.sigmaInstance&&this.isActive&&(this.isActive=!1,this.isDrawing=!1,i.apply(this),this.renderer.domElements.lasso&&(this.renderer.container.removeChild(this.renderer.domElements.lasso),delete this.renderer.domElements.lasso,this.drawingCanvas.style.cursor="",this.drawingCanvas=a,this.drawingContext=a,this.drewPoints=[])),this};var h=function(){this.drawingCanvas.addEventListener("mousedown",c.bind(this)),f.addEventListener("mousemove",d.bind(this)),f.addEventListener("mouseup",e.bind(this)),this.drawingCanvas.addEventListener("touchstart",c.bind(this)),f.addEventListener("touchmove",d.bind(this)),f.addEventListener("touchcancel",e.bind(this)),f.addEventListener("touchleave",e.bind(this)),f.addEventListener("touchend",e.bind(this))},i=function(){this.drawingCanvas.removeEventListener("mousedown",c.bind(this)),f.removeEventListener("mousemove",d.bind(this)),f.removeEventListener("mouseup",e.bind(this)),this.drawingCanvas.removeEventListener("touchstart",c.bind(this)),this.drawingCanvas.removeEventListener("touchmove",d.bind(this)),f.removeEventListener("touchcancel",e.bind(this)),f.removeEventListener("touchleave",e.bind(this)),f.removeEventListener("touchend",e.bind(this))};b.prototype.getSelectedNodes=function(){return this.selectedNodes},sigma.plugins.lasso=function(a,c,d){return g[a.id]||(g[a.id]=new b(a,c,d)),a.bind("kill",function(){g[a.id]instanceof b&&(g[a.id].clear(),delete g[a.id])}),g[a.id]}}.call(this),function(a){"use strict";function b(a){var b=document.createEvent("MouseEvent");return b.initMouseEvent(a.type,a.canBubble,a.cancelable,a.view,a.detail,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,a.relatedTarget),b}function c(a){return"undefined"!=typeof a.lat&&"undefined"!=typeof a.lng&&"number"==typeof a.lat&&"number"==typeof a.lng}function d(d,h,i){function j(b){if(C){for(var c,d=C.graph.nodes(),e=0;e<d.length;e++)c=d[e],A||c.leaflet_hidden===a||(c.hidden=c.leaflet_hidden,c.leaflet_hidden=a),c.leaflet_x!==a&&c.leaflet_y!==a&&(H?(c.x=c["read_cam0:x"]||c.x,c.y=c["read_cam0:y"]||c.y,c.leaflet_x_easing=c.leaflet_x,c.leaflet_y_easing=c.leaflet_y):(c.x=c.leaflet_x,c.y=c.leaflet_y),c.leaflet_x=a,c.leaflet_y=a);H?m(d,b):(C.refresh(),b&&b())}}function k(){A&&(A.has("geo-coordinates")?A.apply():A.nodesBy(c,"geo-coordinates").apply())}function l(){K=!K}function m(a,b){sigma.plugins.animate(C,{x:"leaflet_x_easing",y:"leaflet_y_easing"},{easing:I,onComplete:function(){C.refresh();for(var c=0;c<a.length;c++)a[c].leaflet_x_easing=null,a[c].leaflet_y_easing=null;b&&b()},duration:J})}function n(a){for(var b,c,d=a.data.nodes||[a.data.node],e=0,f=d.length;f>e;e++)b=d[e],c=B.utils.sigmaPointToLatLng(b),b.lat_init=b.lat,b.lng_init=b.lng,b.lat=c.lat,b.lng=c.lng}function o(){O||(O=!0,Object.keys(f).forEach(function(a){F[a]=C.settings(a),C.settings(a,f[a])}),C.camera.ratio=1)}function p(){O&&(O=!1,Object.keys(f).forEach(function(a){C.settings(a,F[a])}))}function q(){if(!P&&"undefined"!=typeof sigma.plugins.locate&&(P=!0,C)){var a=sigma.plugins.locate(C).settings.animation;G.nodeDuration=a.node.duration,G.edgeDuration=a.edge.duration,G.centerDuration=a.center.duration,a.node.duration=0,a.edge.duration=0,a.center.duration=0}}function r(){if(P&&"undefined"!=typeof sigma.plugins.locate&&(P=!1,C)){var a=sigma.plugins.locate(C).settings.animation;a.node.duration=G.nodeDuration,a.edge.duration=G.edgeDuration,a.center.duration=G.centerDuration}}function s(){g.forEach(function(a){E.container.addEventListener(a,u,!0)})}function t(){g.forEach(function(a){E.container.removeEventListener(a,u,!0)})}function u(a){D.getContainer().dispatchEvent(b(a))}function v(){C.settings("enableCamera",!1),E.container.style.visibility="hidden"}function w(){C.settings("enableCamera",!0),E.container.style.visibility="",B.syncNodes()}function x(){D&&(D.getContainer().style.opacity=0,D.getContainer().style.visibility="hidden")}function y(){D&&(D.getContainer().style.opacity=1,D.getContainer().style.visibility="")}if(sigma.classes.dispatcher.extend(this),"undefined"==typeof L)throw new Error("leaflet is not declared");i=i||{};var z,A,B=this,C=d,D=h,E=i.renderer||C.renderers[0],F=Object.create(null),G=Object.create(null),H=!1,I=i.easing,J=i.duration,K=!1,M=!1,N=!1,O=!1,P=!1,Q={x:C.camera.x,y:C.camera.y,ratio:C.camera.ratio};if(I&&(!sigma.plugins||"undefined"==typeof sigma.plugins.animate))throw new Error("sigma.plugins.animate is not declared");this.isApplicable=function(){for(var a=C.graph.nodes(),b=0,d=a.length;d>b;b++)if(c(a[b]))return!0;return!1},this.isEnabled=function(){return M},this.enable=function(){return y(),o(),q(),Q={x:C.camera.x,y:C.camera.y,ratio:C.camera.ratio},B.bindAll(),H=!!I,B.syncNodes(function(){B.dispatchEvent("enabled")}),H=!1,M=!0,B},this.disable=function(){return x(),p(),r(),H=!!I,A&&A.undo("geo-coordinates").apply(),j(function(){B.dispatchEvent("disabled")}),H=!1,M=!1,B.unbindAll(),B},this.syncNodes=function(b,d){var f,g,h;f="string"==typeof b||"number"==typeof b||Array.isArray(b)?C.graph.nodes(b):C.graph.nodes(),"function"==typeof b&&(d=b),Array.isArray(f)||(f=[f]);for(var i=0,j=f.length;j>i;i++)g=f[i],g.leaflet_x===a&&(g.leaflet_x=g.x),g.leaflet_y===a&&(g.leaflet_y=g.y),c(g)?(e.set(g.id,C.graph.nodes(g.id)),h=B.utils.latLngToSigmaPoint(g),H?(g.x=g["read_cam0:x"]||g.x,g.y=g["read_cam0:y"]||g.y,g.leaflet_x_easing=h.x,g.leaflet_y_easing=h.y):(g.x=h.x,g.y=h.y)):(e["delete"](g.id),A||(g.leaflet_hidden===a&&(g.leaflet_hidden=!!g.hidden),g.hidden=!0));return k(),H?m(f,d):(C.refresh(),d&&d()),B},this.syncMap=function(){if(Q.ratio!==C.camera.ratio)Q.ratio<C.camera.ratio?D.zoomIn():D.zoomOut(),C.camera.ratio=1;else{var a=C.camera.x-Q.x,b=C.camera.y-Q.y;Q.x=C.camera.x,Q.y=C.camera.y,D.panBy([a,b],{animate:!1})}return B},this.fitBounds=function(a){function b(){if(c.edgeIds){Array.isArray(c.edgeIds)||(c.edgeIds=[c.edgeIds]),c.nodeIds=[];for(var a=C.graph.edges(c.edgeIds),e=0,f=a.length;f>e;e++)c.nodeIds.push(a[e].source),c.nodeIds.push(a[e].target)}c.nodeIds&&!Array.isArray(c.nodeIds)&&(c.nodeIds=[c.nodeIds]);var g=c.nodeIds?C.graph.nodes(c.nodeIds):C.graph.nodes();D.fitBounds(B.utils.geoBoundaries(g),{animate:!1}),D.getZoom()===d?(H=!!c.animate,c.onComplete?B.syncNodes(c.onComplete):B.syncNodes(),H=!1):c.onComplete&&c.onComplete(),setTimeout(function(){C.unbind("animate.end",b)},0)}var c=a||{},d=D.getZoom();return K?C.bind("animate.end",b):b(),B},this.zoomIn=function(){D.zoomIn()},this.zoomOut=function(){D.zoomOut()},this.bindDragListener=function(a){return z=z||a,z.bind("drop",n),B},this.unbindDragListener=function(){return z!==a?(z.unbind("drop",n),z=a,B):void 0},this.bindFilter=function(a){return A=a,k(),B},this.unbindFilter=function(){return A=a,B},this.resetDraggedNodesLatLng=function(){for(var b,c=C.graph.nodes(),d=0,e=c.length;e>d;d++)b=c[d],b.lat_init!==a&&b.lng_init!==a&&(b.lat=b.lat_init,b.lng=b.lng_init,b.lat_init=a,b.lng_init=a);return B},this.bindAll=function(){return N?void 0:(N=!0,s(),C.bind("coordinatesUpdated",B.syncMap),D.on("zoomstart",v).on("zoomend",w),C.bind("animate.start",l),C.bind("animate.end",l),B)},this.unbindAll=function(){return N?(N=!1,t(),C.unbind("coordinatesUpdated",B.syncMap),D.off("zoomstart",v).off("zoomend",w),C.unbind("animate.start",l),C.unbind("animate.end",l),B.unbindDragListener(),B.unbindFilter(),B):void 0},this.kill=function(){B.unbindAll(),x(),p(),M=!1,C=a,E=a,D=a,Q=a},this.utils={},this.utils.sigmaPointToLatLng=function(a){var b=D.project(D.getCenter());return D.unproject([a.x+b.x-C.camera.x,a.y+b.y-C.camera.y])},this.utils.latLngToSigmaPoint=function(a){var b=D.project(D.getCenter()),c=D.project(a);return{x:c.x-b.x+C.camera.x,y:c.y-b.y+C.camera.y}},this.utils.geoBoundaries=function(a){for(var b,d=1/0,e=1/0,f=-(1/0),g=-(1/0),h=0,i=a.length;i>h;h++)b=a[h],!b.hidden&&c(b)&&(f=Math.max(b.lat,f),d=Math.min(b.lat,d),g=Math.max(b.lng,g),e=Math.min(b.lng,e));return L.latLngBounds(L.latLng(d,e),L.latLng(f,g))}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");"undefined"==typeof L&&console.warn("Include leaflet to use the leaflet plugin for sigma."),sigma.utils.pkg("sigma.plugins.leaflet");var e=new sigma.utils.map;sigma.classes.graph.attach("addNode","sigma.plugins.leaflet.addNode",function(a){c(a)&&e.set(a.id,this.nodesIndex.get(a.id))}),sigma.classes.graph.attachBefore("dropNode","sigma.plugins.leaflet.dropNode",function(a){e["delete"](a)}),sigma.classes.graph.attachBefore("clear","sigma.plugins.leaflet.clear",function(){e.clear(),e=new sigma.utils.map}),sigma.classes.graph.hasMethod("hasLatLngCoordinates")||sigma.classes.graph.addMethod("hasLatLngCoordinates",function(b){if(b!==a){var d=this.nodesIndex.get(b);if(d)return c(d)}return 0!=e.size});var f={zoomingRatio:.999999999,doubleClickZoomingRatio:.999999999,mouseZoomDuration:0,doubleClickZoomDuration:0,autoRescale:["nodeSize","edgeSize"],zoomOnLocation:!1,mouseInertiaDuration:0,mouseInertiaRatio:1,touchInertiaDuration:0,touchInertiaRatio:1},g=["click","mouseup","mouseover","mouseout","mousemove","focus","blur"],h={};sigma.plugins.leaflet=function(b,c,e){if(!b)throw new Error('Missing argument: "sigInst"');if(!c)throw new Error('Missing argument: "leafletMap"');return h[b.id]||(h[b.id]=new d(b,c,e),b.bind("kill",function(){h[b.id].kill(),h[b.id]=a})),h[b.id]},sigma.plugins.killLeafletPlugin=function(b){if(!b)throw new Error('Missing argument: "sigInst"');h[b.id]instanceof d&&(h[b.id].kill(),h[b.id]=a)}}.call(this),function(){"use strict";function a(a){var b=a.settings("autoRescale");return b?Array.isArray(b)?-1!==b.indexOf("nodePosition"):!0:!1}function b(a,b){var c,d,e=-(1/0),f=1/0,g=1/0,h=-(1/0),i=-(1/0);for(c=0,d=a.length;d>c;c++)e=Math.max(a[c][b+"size"],e),h=Math.max(a[c][b+"x"],h),f=Math.min(a[c][b+"x"],f),i=Math.max(a[c][b+"y"],i),g=Math.min(a[c][b+"y"],g);return e=e||1,{sizeMax:e,minX:f,minY:g,maxX:h,maxY:i}}function c(c,e){function f(b){var c,d,e,f,h,i,j;if(c=.5*(b.minX+b.maxX),d=.5*(b.minY+b.maxY),a(g.s)){var k,l,m,n,o;o=g.s.camera.getRectangle(b.maxX-b.minX,b.maxY-b.minY),f=o.x2-o.x1||1,h=o.height||1,k=sigma.utils.getBoundaries(g.s.graph,g.s.camera.readPrefix),l=g.s.camera.getRectangle(k.maxX-k.minX,k.maxY-k.minY),m=l.x2-l.x1||1,n=l.height||1,i=m-g.settings.padding.left-g.settings.padding.right,j=n-g.settings.padding.top-g.settings.padding.bottom,e=Math.max(f/i,h/j)}else f=b.maxX-b.minX+2*b.sizeMax,h=b.maxY-b.minY+2*b.sizeMax,i=g.s.renderers[0].width-g.settings.padding.left-g.settings.padding.right,j=g.s.renderers[0].height-g.settings.padding.top-g.settings.padding.bottom,e=Math.max(f/i,h/j);return e=Math.max(g.s.settings("zoomMin"),Math.min(g.s.settings("zoomMax"),e)),c+=(g.settings.padding.right-g.settings.padding.left)*e*.5,d+=(g.settings.padding.bottom-g.settings.padding.top)*e*.5,{x:c,y:d,ratio:e}}var g=this;this.s=c,this.settings=sigma.utils.extend(e,d),this.settings.zoomDef=this.settings.zoomDef||this.s.settings("zoomMax"),this.s.bind("kill",function(){sigma.plugins.killLocate(g.s)}),this.nodes=function(d,e){if(arguments.length<1)throw new TypeError("Too few arguments.");if(3===arguments.length&&"object"!=typeof e)throw new TypeError('Invalid argument: "options" is not an object, was '+e);var h,i,j=sigma.utils.extend(e,g.settings.animation.node),k=(g.s.camera.ratio,a(g.s));if("string"==typeof d||"number"==typeof d){if(i=g.s.graph.nodes(d),void 0===i)throw new Error('Invalid argument: the node of id "'+d+'" does not exist.');h={x:i[g.s.camera.readPrefix+"x"],y:i[g.s.camera.readPrefix+"y"],ratio:k?g.s.settings("zoomMin"):g.settings.zoomDef}}else{if(!Array.isArray(d))throw new TypeError('Invalid argument: "v" is not a string, a number, or an array, was '+d);var l=b(d.map(function(a){return g.s.graph.nodes(a)}),g.s.camera.readPrefix);h=f(l)}return g.settings.focusOut&&k?sigma.misc.animation.camera(c.camera,{x:.5*(g.s.camera.x+h.x),y:.5*(g.s.camera.y+h.y),ratio:g.settings.zoomDef},{duration:j.duration,onComplete:function(){sigma.misc.animation.camera(g.s.camera,h,j)}}):sigma.misc.animation.camera(g.s.camera,h,j),g},this.edges=function(d,e){if(arguments.length<1)throw new TypeError("Too few arguments.");if(3===arguments.length&&"object"!=typeof e)throw new TypeError('Invalid argument: "options" is not an object, was '+e);var h,i,j,k=sigma.utils.extend(e,g.settings.animation.edge),l=(g.s.camera.ratio,a(g.s));if("string"==typeof d||"number"==typeof d){if(i=g.s.graph.edges(d),void 0===i)throw new Error('Invalid argument: the edge of id "'+d+'" does not exist.');j=b([g.s.graph.nodes(i.source),g.s.graph.nodes(i.target)],g.s.camera.readPrefix),h=f(j)}else{if(!Array.isArray(d))throw new TypeError('Invalid argument: "v" is not a string or a number, or an array, was '+d);var m,n,o=[];for(m=0,n=d.length;n>m;m++)i=g.s.graph.edges(d[m]),o.push(g.s.graph.nodes(i.source)),o.push(g.s.graph.nodes(i.target));j=b(o,g.s.camera.readPrefix),h=f(j)}return g.settings.focusOut&&l?sigma.misc.animation.camera(c.camera,{x:.5*(g.s.camera.x+h.x),y:.5*(g.s.camera.y+h.y),ratio:g.settings.zoomDef},{duration:k.duration,onComplete:function(){sigma.misc.animation.camera(g.s.camera,h,k)}}):sigma.misc.animation.camera(g.s.camera,h,k),g},this.center=function(a,b){var c=sigma.utils.extend(b,g.settings.animation.center);return g.s.graph.nodes().length?g.nodes(g.s.graph.nodes().map(function(a){return a.id}),c):sigma.misc.animation.camera(g.s.camera,{x:0,y:0,ratio:a},c),g},this.setPadding=function(a){return g.settings.padding=sigma.utils.extend(a,g.settings.padding),g},this.kill=function(){g.settings=null,g.s=null}}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins");var d={animation:{node:{duration:300},edge:{duration:300},center:{duration:300}},padding:{top:0,right:0,bottom:0,left:0},focusOut:!1,zoomDef:null},e={};sigma.plugins.locate=function(a,b){return e[a.id]||(e[a.id]=new c(a,b)),e[a.id]},sigma.plugins.killLocate=function(a){e[a.id]instanceof c&&e[a.id].kill(),delete e[a.id]}}.call(window),function(){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.classes.graph.addMethod("neighborhood",function(a){var b,c,d,e,f,g={},h={},i={nodes:[],edges:[]};if(!this.nodes(a))return i;e=this.nodes(a),f={},f.center=!0;for(b in e)f[b]=e[b];g[a]=!0,i.nodes.push(f);for(b in this.allNeighborsIndex[a]){g[b]||(g[b]=!0,i.nodes.push(this.nodesIndex[b]));for(c in this.allNeighborsIndex[a][b])h[c]||(h[c]=!0,i.edges.push(this.edgesIndex[c]))}for(b in g)if(b!==a)for(c in g)if(c!==a&&b!==c&&this.allNeighborsIndex[b][c])for(d in this.allNeighborsIndex[b][c])h[d]||(h[d]=!0,i.edges.push(this.edgesIndex[d]));return i}),sigma.utils.pkg("sigma.plugins"),sigma.plugins.neighborhoods=function(){var a=new sigma.classes.graph;this.neighborhood=function(b){return a.neighborhood(b)},this.load=function(b,c){var d=function(){if(window.XMLHttpRequest)return new XMLHttpRequest;var a,b;if(window.ActiveXObject){a=["Msxml2.XMLHTTP.6.0","Msxml2.XMLHTTP.3.0","Msxml2.XMLHTTP","Microsoft.XMLHTTP"];for(b in a)try{return new ActiveXObject(a[b])}catch(c){}}return null}();if(!d)throw"XMLHttpRequest not supported, cannot load the data.";return d.open("GET",b,!0),d.onreadystatechange=function(){4===d.readyState&&(a.clear().read(JSON.parse(d.responseText)),c&&c())},d.send(),this},this.read=function(b){a.clear().read(b)}}}.call(window),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma.plugins.poweredBy: sigma not in scope.";sigma.utils.pkg("sigma.settings");var b={poweredByHTML:"Linkurious.js",poweredByURL:"https://github.com/Linkurious/linkurious.js",poweredByPingURL:""};sigma.settings=sigma.utils.extend(sigma.settings||{},b)}.call(this),function(a){function b(a){a=a||{};var b,c=a.html||this.settings("poweredByHTML"),d=a.url||this.settings("poweredByURL"),e=a.pingURL||this.settings("poweredByPingURL");if(!document.getElementsByClassName("sigma-poweredby").length){if(b=d?['<a href="'+d+'" target="_blank" style="font-family:\'Helvetica Neue\',Arial,Helvetica,sans-serif; font-size:11px">'+c+"</a>"]:[c],e){var f=new Image;f.src=e}var g=document.createElement("div");g.setAttribute("class","sigma-poweredby"),g.innerHTML=b.join(""),g.style.position="absolute",g.style.padding="0 5px",g.style.bottom="2px",g.style.right="1px",g.style.zIndex="1000",g.style.background="rgba(255, 255, 255, 0.7)",this.container.appendChild(g)}}sigma.renderers.canvas.prototype.poweredBy=b,sigma.renderers.webgl.prototype.poweredBy=b}.call(this),function(a){"use strict";function b(a){h=32===a.which,f.removeEventListener("keydown",b,!1),f.addEventListener("keyup",c,!1)}function c(a){h=!1,f.addEventListener("keydown",b,!1),f.removeEventListener("keyup",c,!1)}function d(c,d,e){function j(){d.dropEdges(),d.nbNodes()===c.graph.nodes().length?d.dropNodes():d.addNodes(),c.refresh({skipIndexation:!0})}function k(){v++}function l(){v=0,u.container.lastChild.addEventListener("mousemove",k)}function m(){setTimeout(function(){v=0;var a=d.nodes()[0];a&&null===g&&(g=a.id)},1),u.container.lastChild.removeEventListener("mousemove",k)}function n(){d.dropEdges(),d.dropNodes(),c.refresh({skipIndexation:!0})}function o(){var a=d.nodes().map(function(a){return a.id}),b=d.edges().map(function(a){return a.id});d.dropEdges(b),d.dropNodes(a),a.length==c.graph.nodes().length?c.graph.clear():(c.graph.dropEdges(b),c.graph.dropNodes(a)),c.refresh()}function p(){d.addNeighbors(),c.refresh({skipIndexation:!0})}function q(){d.dropEdges(),d.setNodesBy(function(a){return 0===c.graph.degree(a.id)}),c.refresh({skipIndexation:!0})}function r(){d.dropEdges(),d.setNodesBy(function(a){return 1===c.graph.adjacentNodes(a.id).length}),c.refresh({skipIndexation:!0})}function s(a){var b=a.data;b.length?(d.dropEdges(),d.addNodes(b.map(function(a){return a.id})),g=d.nodes()[0].id):(d.dropNodes(),g=null)}var t=this,u=e||c.renderers[0],v=0,w=null,x=null;f=f||document.getElementsByTagName("body")[0],u.container.lastChild.addEventListener("mousedown",l),u.container.lastChild.addEventListener("mouseup",m),this.init=function(){d.nbNodes()&&(g=d.nodes()[0].id)},this.clickNodesHandler=function(b){if(!(v>1)){var e=b.data.node[0].id,f=d.nodes().map(function(a){return a.id}),j=f.indexOf(e)>-1?a:e;if(d.dropEdges(),h){var k=j===e?a:e;d.dropNodes(k),c.refresh({skipIndexation:!0})}else{f.length>1&&d.addNodes(e);var l=d.nodes()[0];null!=l?g===l.id?null!=j?(d.dropNodes(),g=null):setTimeout(function(){i||(d.dropNodes(),g=null,c.refresh({skipIndexation:!0}))},c.settings("doubleClickTimeout")):g=l.id:g=j}null!=j&&(d.addNodes(j),c.refresh({skipIndexation:!0}))}},this.doubleClickNodesHandler=function(a){i=!0,setTimeout(function(){i=!1},100+c.settings("doubleClickTimeout"))},this.clickEdgesHandler=function(b){if(!(v>1)){var e=b.data.edge[0].id,f=d.edges().map(function(a){return a.id}),i=f.indexOf(e)>-1?a:e;if(d.dropNodes(),g=null,h){var j=i===e?a:e;d.dropEdges(j),c.refresh({skipIndexation:!0})}else d.dropEdges();null!=i&&(d.addEdges(i),c.refresh({skipIndexation:!0}))}},c.bind("clickNodes",this.clickNodesHandler),c.bind("doubleClickNodes",this.doubleClickNodesHandler),c.bind("clickEdges",this.clickEdgesHandler),f.addEventListener("keydown",b,!1),this.bindKeyboard=function(a){if(!a)throw new Error('Missing argument: "keyboard"');return w=a,w.bind("32+65 18+32+65",j),w.bind("32+85 18+32+85",n),w.bind("32+46 18+32+46",o),w.bind("32+69 18+32+69",p),w.bind("32+73 18+32+73",q),w.bind("32+76 18+32+76",r),this},this.unbindKeyboard=function(){return w&&(w.unbind("32+65 18+32+65",j),w.unbind("32+85 18+32+85",n),w.unbind("32+46 18+32+46",o),w.unbind("32+69 18+32+69",p),w.unbind("32+73 18+32+73",q),w.unbind("32+76 18+32+76",r),w=null),this},this.bindLasso=function(a){if(!a)throw new Error('Missing argument: "lassoInstance"');x=a,x.bind("selectedNodes",s)},this.unbindLasso=function(){x&&x.unbind("selectedNodes",s)},this.clear=function(){c.unbind("clickNodes",t.clickNodesHandler),c.unbind("doubleClickNodes",t.doubleClickNodesHandler),
c.unbind("clickEdges",t.clickEdgesHandler),t.unbindKeyboard(),t.unbindLasso(),u.container.lastChild.removeEventListener("mousedown",l),u.container.lastChild.removeEventListener("mouseup",m),u.container.lastChild.removeEventListener("mousemove",k),u=null,w=null}}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");var e={},f=null,g=null,h=!1,i=!1;sigma.plugins.select=function(a,b,c){return e[a.id]||(e[a.id]=new d(a,b),a.bind("kill",function(){sigma.plugins.killSelect(a)})),e[a.id]},sigma.plugins.killSelect=function(a){e[a.id]instanceof d&&(e[a.id].clear(),delete e[a.id]),!e.length&&f&&(f.removeEventListener("keydown",b,!1),f.removeEventListener("keyup",c,!1),f=null)}}.call(this),function(){"use strict";function a(a,c,d){function e(a){a.preventDefault()}function f(){i&&i.parentNode&&(i.parentNode.removeChild(i),i=null)}function g(){clearTimeout(j),clearTimeout(k),j=!1,k=!1,f()}function h(a){clearTimeout(j),clearTimeout(k),j=!1,k=setTimeout(function(){p||f()},a)}var i,j,k,l=this,m=[],n=[],o=[],p=!1,q=!1;if(Array.isArray(d.stage))for(var r=0;r<d.stage.length;r++)m.push(sigma.utils.extend(d.stage[r],b.stage));else m.push(sigma.utils.extend(d.stage,b.stage));if(Array.isArray(d.node))for(var r=0;r<d.node.length;r++)n.push(sigma.utils.extend(d.node[r],b.node));else n.push(sigma.utils.extend(d.node,b.node));if(Array.isArray(d.edge))for(var r=0;r<d.edge.length;r++)o.push(sigma.utils.extend(d.edge[r],b.edge));else o.push(sigma.utils.extend(d.edge,b.edge));if(sigma.classes.dispatcher.extend(this),a.bind("kill",function(){sigma.plugins.killTooltips(a)}),this.open=function(b,d,e,g,h){if(f(),i=document.createElement("div"),d.renderer){var j,k,l,m=Object.create(null);for(l in b)m[l]=b[l];if(j=d.renderer.call(a.graph,m,d.template),k=typeof j,"undefined"===k)return;"string"===k?i.innerHTML=j:i.appendChild(j)}else i.innerHTML=d.template;var n=window.getComputedStyle(c.container).position;if("static"!==n){i.style.position="absolute";var o=c.container.getBoundingClientRect();e=~~(e-o.left),g=~~(g-o.top)}i.className=d.cssClass,"css"!==d.position&&("static"===n&&(i.style.position="absolute"),i.style.left=e+"px",i.style.top=g+"px"),i.addEventListener("mouseenter",function(){p=!0},!1),i.addEventListener("mouseleave",function(){p=!1},!1),setTimeout(function(){if(i){c.container.appendChild(i);var a=document.body.getBoundingClientRect(),b=i.getBoundingClientRect(),f=b.top-a.top,j=a.bottom-b.bottom,k=b.left-a.left,l=a.right-b.right;"top"===d.position?(i.className=d.cssClass+" top",i.style.left=e-b.width/2+"px",i.style.top=g-b.height+"px"):"bottom"===d.position?(i.className=d.cssClass+" bottom",i.style.left=e-b.width/2+"px",i.style.top=g+"px"):"left"===d.position?(i.className=d.cssClass+" left",i.style.left=e-b.width+"px",i.style.top=g-b.height/2+"px"):"right"===d.position&&(i.className=d.cssClass+" right",i.style.left=e+"px",i.style.top=g-b.height/2+"px"),d.autoadjust&&(b=i.getBoundingClientRect(),f=b.top-a.top,j=a.bottom-b.bottom,k=b.left-a.left,l=a.right-b.right,0>j?(i.className=d.cssClass,("top"===d.position||"bottom"===d.position)&&(i.className=d.cssClass+" top"),i.style.top=g-b.height+"px"):0>f&&(i.className=d.cssClass,("top"===d.position||"bottom"===d.position)&&(i.className=d.cssClass+" bottom"),i.style.top=g+"px"),0>l?(i.className=d.cssClass,("left"===d.position||"right"===d.position)&&(i.className=d.cssClass+" left"),i.style.left=e-b.width+"px"):0>k&&(i.className=d.cssClass,("left"===d.position||"right"===d.position)&&(i.className=d.cssClass+" right"),i.style.left=e+"px")),h&&h()}},0)},this.close=function(){return g(),this.dispatchEvent("hidden"),this},this.kill=function(){this.unbindEvents(),clearTimeout(j),clearTimeout(k),i=null,j=null,k=null,q=!1,m=[],n=[],o=[]},this.unbindEvents=function(){for(var b=m.concat(n).concat(o),d=0;d<b.length;d++)a.unbind(b[d].show),a.unbind(b[d].hide),("rightClickNode"===b[d].show||"rightClickEdge"===b[d].show)&&c.container.removeEventListener("contextmenu",e);a.unbind("doubleClickStage"),a.unbind("doubleClickNode"),a.unbind("doubleClickEdge")},this.bindStageEvents=function(c){a.bind(c.show,function(a){if("doubleClickStage"===c.show||!q){var b=a.data.captor.clientX,d=a.data.captor.clientY;clearTimeout(j),j=setTimeout(function(){l.open(null,c,b,d,l.dispatchEvent.bind(l,"shown",a.data))},c.delay)}}),a.bind(c.hide,function(a){var c=i;h(b.stage.hideDelay),c&&l.dispatchEvent("hidden",a.data)})},this.bindNodeEvents=function(c){a.bind(c.show,function(a){if("doubleClickNode"===c.show||!q){var b=a.data.node;if(!b&&a.data.enter&&(b=a.data.enter.nodes[0]),void 0!=b){var d=a.data.captor.clientX,e=a.data.captor.clientY;clearTimeout(j),j=setTimeout(function(){l.open(b,c,d,e,l.dispatchEvent.bind(l,"shown",a.data))},c.delay)}}}),a.bind(c.hide,function(a){if(!a.data.leave||0!=a.data.leave.nodes.length){var c=i;h(b.node.hideDelay),c&&l.dispatchEvent("hidden",a.data)}})},this.bindEdgeEvents=function(c){a.bind(c.show,function(a){if("doubleClickEdge"===c.show||!q){var b=a.data.edge;if(!b&&a.data.enter&&(b=a.data.enter.edges[0]),void 0!=b){var d=a.data.captor.clientX,e=a.data.captor.clientY;clearTimeout(j),j=setTimeout(function(){l.open(b,c,d,e,l.dispatchEvent.bind(l,"shown",a.data))},c.delay)}}}),a.bind(c.hide,function(a){if(!a.data.leave||0!=a.data.leave.edges.length){var c=i;h(b.edge.hideDelay),c&&l.dispatchEvent("hidden",a.data)}})},d.stage){for(var s=!1,r=0;r<m.length;r++){if(null!==m[r].renderer&&"function"!=typeof m[r].renderer)throw new TypeError('"options.stage.renderer" is not a function, was '+m[r].renderer);if(void 0!==m[r].position&&"top"!==m[r].position&&"bottom"!==m[r].position&&"left"!==m[r].position&&"right"!==m[r].position&&"css"!==m[r].position)throw new Error('"options.position" is not "top", "bottom", "left", "right", or "css", was '+m[r].position);"doubleClickStage"===m[r].show&&(s=!0)}for(var r=0;r<m.length;r++)this.bindStageEvents(m[r]);s||a.bind("doubleClickStage",function(a){g(),q=!0,l.dispatchEvent("hidden",a.data),setTimeout(function(){q=!1},b.doubleClickDelay)})}if(d.node){for(var t=!1,u=!1,r=0;r<n.length;r++){if(null!==n[r].renderer&&"function"!=typeof n[r].renderer)throw new TypeError('"options.node.renderer" is not a function, was '+n[r].renderer);if(void 0!==n[r].position&&"top"!==n[r].position&&"bottom"!==n[r].position&&"left"!==n[r].position&&"right"!==n[r].position&&"css"!==n[r].position)throw new Error('"options.position" is not "top", "bottom", "left", "right", or "css", was '+n[r].position);"doubleClickNode"===n[r].show?u=!0:"rightClickNode"===n[r].show&&(t=!0)}for(var r=0;r<n.length;r++)this.bindNodeEvents(n[r]);u||a.bind("doubleClickNode",function(a){g(),q=!0,l.dispatchEvent("hidden",a.data),setTimeout(function(){q=!1},b.doubleClickDelay)})}if(d.edge){for(var v=!1,w=!1,r=0;r<o.length;r++){if(null!==o[r].renderer&&"function"!=typeof o[r].renderer)throw new TypeError('"options.edge.renderer" is not a function, was '+o[r].renderer);if(void 0!==o[r].position&&"top"!==o[r].position&&"bottom"!==o[r].position&&"left"!==o[r].position&&"right"!==o[r].position&&"css"!==o[r].position)throw new Error('"options.position" is not "top", "bottom", "left", "right", or "css", was '+o[r].position);"doubleClickEdge"===o[r].show?w=!0:"rightClickEdge"===o[r].show&&(v=!0)}for(var r=0;r<o.length;r++)this.bindEdgeEvents(o[r]);w||a.bind("doubleClickEdge",function(a){g(),q=!0,l.dispatchEvent("hidden",a.data),setTimeout(function(){q=!1},b.doubleClickDelay)})}(t||v)&&c.container.addEventListener("contextmenu",e)}if("undefined"==typeof sigma)throw new Error("sigma is not declared");sigma.utils.pkg("sigma.plugins");var b={stage:{show:"rightClickStage",hide:"clickStage",cssClass:"sigma-tooltip",position:"top",autoadjust:!1,delay:0,hideDelay:0,template:"",renderer:null},node:{show:"clickNode",hide:"clickStage",cssClass:"sigma-tooltip",position:"top",autoadjust:!1,delay:0,hideDelay:0,template:"",renderer:null},edge:{show:"clickEdge",hide:"clickStage",cssClass:"sigma-tooltip",position:"top",autoadjust:!1,delay:0,hideDelay:0,template:"",renderer:null},doubleClickDelay:800},c={};sigma.plugins.tooltips=function(b,d,e){return c[b.id]||(c[b.id]=new a(b,d,e)),c[b.id]},sigma.plugins.killTooltips=function(b){c[b.id]instanceof a&&c[b.id].kill(),delete c[b.id]}}.call(window),function(){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.plugins");sigma.plugins.relativeSize=function(a,b){for(var c=a.graph.nodes(),d=0;d<c.length;d++){var e=a.graph.degree(c[d].id);c[d].size=b*Math.sqrt(e)}a.refresh()}}.call(window),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.dashed=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel");if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio"),d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.setLineDash([8,3]),d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.dotted=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel");if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio"),d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.setLineDash([2]),d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.parallel=function(a,b,c,d,e){var f,g,h=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,i=e("prefix")||"",j=a[i+"size"]||1,k=e("edgeColor"),l=e("defaultNodeColor"),m=e("defaultEdgeColor"),n=e("edgeHoverLevel"),o=b[i+"x"],p=b[i+"y"],q=c[i+"x"],r=c[i+"y"],s=sigma.utils.getDistance(o,p,q,r);if(!h)switch(k){case"source":h=b.color||l;break;case"target":h=c.color||l;break;default:h=m}if(h="edge"===e("edgeHoverColor")?a.hover_color||h:a.hover_color||e("defaultEdgeHoverColor")||h,j*=e("edgeHoverSizeRatio"),f=sigma.utils.getCircleIntersection(o,p,j,q,r,s),g=sigma.utils.getCircleIntersection(q,r,j,o,p,s),d.save(),n)switch(d.shadowOffsetX=0,n){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.strokeStyle=h,d.lineWidth=j,d.beginPath(),d.moveTo(f.xi,f.yi),d.lineTo(g.xi_prime,g.yi_prime),d.closePath(),d.stroke(),d.beginPath(),d.moveTo(f.xi_prime,f.yi_prime),d.lineTo(g.xi,g.yi),d.closePath(),d.stroke(),n&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.tapered=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),g=e("prefix")||"",j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel"),m=b[g+"x"],n=b[g+"y"],o=c[g+"x"],p=c[g+"y"],q=sigma.utils.getDistance(m,n,o,p);if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio");var r=sigma.utils.getCircleIntersection(m,n,h,o,p,q);if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.globalAlpha=.65,d.fillStyle=f,d.beginPath(),d.moveTo(o,p),d.lineTo(r.xi,r.yi),d.lineTo(r.xi_prime,r.yi_prime),d.closePath(),d.fill(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.dashed=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level;if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.setLineDash([8,3]),d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.dotted=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level;if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.setLineDash([2]),d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.parallel=function(a,b,c,d,e){var f,g,h=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,i=e("prefix")||"",j=a[i+"size"]||1,k=e("edgeColor"),l=e("defaultNodeColor"),m=e("defaultEdgeColor"),n=a.active?e("edgeActiveLevel"):a.level,o=b[i+"x"],p=b[i+"y"],q=c[i+"x"],r=c[i+"y"],s=sigma.utils.getDistance(o,p,q,r);if(!h)switch(k){case"source":h=b.color||l;break;case"target":h=c.color||l;break;default:h=m}if(f=sigma.utils.getCircleIntersection(o,p,j,q,r,s),g=sigma.utils.getCircleIntersection(q,r,j,o,p,s),d.save(),n)switch(d.shadowOffsetX=0,n){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?h||m:e("defaultEdgeActiveColor"):d.strokeStyle=h,d.lineWidth=j,d.beginPath(),d.moveTo(f.xi,f.yi),d.lineTo(g.xi_prime,g.yi_prime),d.closePath(),d.stroke(),d.beginPath(),d.moveTo(f.xi_prime,f.yi_prime),d.lineTo(g.xi,g.yi),d.closePath(),d.stroke(),n&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.tapered=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),g=e("prefix")||"",j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level,m=b[g+"x"],n=b[g+"y"],o=c[g+"x"],p=c[g+"y"],q=sigma.utils.getDistance(m,n,o,p);if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}var r=sigma.utils.getCircleIntersection(m,n,h,o,p,q);if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.fillStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.fillStyle=f,d.globalAlpha=.65,d.beginPath(),d.moveTo(o,p),d.lineTo(r.xi,r.yi),d.lineTo(r.xi_prime,r.yi_prime),d.closePath(),d.fill(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.settings");var b={edgelabelColor:"default",defaultEdgeLabelColor:"#000",defaultEdgeLabelActiveColor:"#000",defaultEdgeLabelSize:10,edgeLabelSize:"fixed",edgeLabelAlignment:"auto",edgeLabelSizePowRatio:1,edgeLabelThreshold:1,defaultEdgeHoverLabelBGColor:"#fff",edgeLabelHoverBGColor:"default",edgeLabelHoverShadow:"default",edgeLabelHoverShadowColor:"#000"};sigma.settings=sigma.utils.extend(sigma.settings||{},b),sigma.settings.drawEdgeLabels=!0}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.canvas.edges.labels"),sigma.canvas.edges.labels.curve=function(a,b,c,d,e){function f(a,b,c,d,f,g,h){var i=Math.round(sigma.utils.canvas.getTextWidth(b,e("approximateLabelWidth"),c,f)+d+1.5+c/3),j=c+4;b.save(),b.beginPath(),b.translate(g,h),b.rotate(a),b.rect(-i/2,-j-d/2,i,j),b.closePath(),b.fill(),b.restore()}if("string"==typeof a.label){var g=e("prefix")||"",h=a[g+"size"]||1;if(!(h<e("edgeLabelThreshold"))||a.hover){if(0===e("edgeLabelSizePowRatio"))throw new Error('Invalid setting: "edgeLabelSizePowRatio" is equal to 0.');var i,j,k=b[g+"size"],l=b[g+"x"],m=b[g+"y"],n=c[g+"x"],o=c[g+"y"],p=n-l,q=o-m,r=n>l?1:-1,s={},t=0,u=.5,v=a.hover?e("hoverFontStyle")||e("fontStyle"):e("fontStyle");if(b.id===c.id?(s=sigma.utils.getSelfLoopControlPoints(l,m,k),j=sigma.utils.getPointOnBezierCurve(u,l,m,n,o,s.x1,s.y1,s.x2,s.y2)):(s=sigma.utils.getQuadraticControlPoint(l,m,n,o,a.cc),j=sigma.utils.getPointOnQuadraticCurve(u,l,m,n,o,s.x,s.y)),i="fixed"===e("edgeLabelSize")?e("defaultEdgeLabelSize"):e("defaultEdgeLabelSize")*h*Math.pow(h,-1/e("edgeLabelSizePowRatio")),d.save(),a.active?d.font=[e("activeFontStyle")||e("fontStyle"),i+"px",e("activeFont")||e("font")].join(" "):d.font=[v,i+"px",e("font")].join(" "),d.textAlign="center",d.textBaseline="alphabetic","auto"===e("edgeLabelAlignment"))if(b.id===c.id)t=Math.atan2(1,1);else{var w=sigma.utils.canvas.getTextWidth(d,e("approximateLabelWidth"),i,a.label),x=sigma.utils.getDistance(b[g+"x"],b[g+"y"],c[g+"x"],c[g+"y"]);x=x-b[g+"size"]-c[g+"size"]-10,x>w&&(t=Math.atan2(q*r,p*r))}a.hover&&(d.fillStyle="edge"===e("edgeLabelHoverBGColor")?a.color||e("defaultEdgeColor"):e("defaultEdgeHoverLabelBGColor"),e("edgeLabelHoverShadow")&&(d.shadowOffsetX=0,d.shadowOffsetY=0,d.shadowBlur=8,d.shadowColor=e("edgeLabelHoverShadowColor")),f(t,d,i,h,a.label,j.x,j.y),e("edgeLabelHoverShadow")&&(d.shadowBlur=0,d.shadowColor="#000")),a.active?d.fillStyle="edge"===e("edgeActiveColor")?a.active_color||e("defaultEdgeActiveColor"):e("defaultEdgeLabelActiveColor"):d.fillStyle="edge"===e("edgeLabelColor")?a.color||e("defaultEdgeColor"):e("defaultEdgeLabelColor"),d.translate(j.x,j.y),d.rotate(t),d.fillText(a.label,0,-h/2-3),d.restore()}}}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.canvas.edges.labels"),sigma.canvas.edges.labels.curvedArrow=function(a,b,c,d,e){sigma.canvas.edges.labels.curve(a,b,c,d,e)}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.canvas.edges.labels"),sigma.canvas.edges.labels.def=function(a,b,c,d,e,f){function g(a,b,c,d,f,g,h){var i=Math.round(sigma.utils.canvas.getTextWidth(b,e("approximateLabelWidth"),c,f)+d+1.5+c/3),j=c+4;b.save(),b.beginPath(),b.translate(g,h),b.rotate(a),b.rect(-i/2,-j-d/2,i,j),b.closePath(),b.fill(),b.restore()}if("string"==typeof a.label&&b!=c){var h=e("prefix")||"",i=a[h+"size"]||1;if(!(i<e("edgeLabelThreshold"))||a.hover){if(0===e("edgeLabelSizePowRatio"))throw new Error('Invalid setting: "edgeLabelSizePowRatio" is equal to 0.');var j,k,l,m,n=0,o=a.hover?e("hoverFontStyle")||e("fontStyle"):e("fontStyle"),p=(b[h+"x"]+c[h+"x"])/2,q=(b[h+"y"]+c[h+"y"])/2;j="fixed"===e("edgeLabelSize")?e("defaultEdgeLabelSize"):e("defaultEdgeLabelSize")*i*Math.pow(i,-1/e("edgeLabelSizePowRatio"));var r=[o,j+"px",e("font")].join(" ");if(a.active&&(r=[e("activeFontStyle")||e("fontStyle"),j+"px",e("activeFont")||e("font")].join(" ")),f&&f.ctx.font!=r?(d.font=r,f.ctx.font=r):d.font=r,d.textAlign="center",d.textBaseline="alphabetic","auto"===e("edgeLabelAlignment")){var s=sigma.utils.canvas.getTextWidth(d,e("approximateLabelWidth"),j,a.label),t=sigma.utils.getDistance(b[h+"x"],b[h+"y"],c[h+"x"],c[h+"y"]);t=t-b[h+"size"]-c[h+"size"]-10,t>s&&(k=c[h+"x"]-b[h+"x"],l=c[h+"y"]-b[h+"y"],m=b[h+"x"]<c[h+"x"]?1:-1,n=Math.atan2(l*m,k*m))}a.hover&&(d.fillStyle="edge"===e("edgeLabelHoverBGColor")?a.color||e("defaultEdgeColor"):e("defaultEdgeHoverLabelBGColor"),e("edgeLabelHoverShadow")&&(d.shadowOffsetX=0,d.shadowOffsetY=0,d.shadowBlur=8,d.shadowColor=e("edgeLabelHoverShadowColor")),g(n,d,j,i,a.label,p,q),e("edgeLabelHoverShadow")&&(d.shadowBlur=0,d.shadowColor="#000")),a.active?d.fillStyle="edge"===e("edgeActiveColor")?a.active_color||e("defaultEdgeActiveColor"):e("defaultEdgeLabelActiveColor"):d.fillStyle="edge"===e("edgeLabelColor")?a.color||e("defaultEdgeColor"):e("defaultEdgeLabelColor"),d.translate(p,q),d.rotate(n),d.fillText(a.label,0,-i/2-3),d.rotate(-n),d.translate(-p,-q)}}}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.svg.edges.labels"),sigma.svg.edges.labels.curve={create:function(a,b){var c=b("prefix")||"",d=a[c+"size"],e=document.createElementNS(b("xmlns"),"text"),f="fixed"===b("labelSize")?b("defaultLabelSize"):b("labelSizeRatio")*d,g="edge"===b("edgeLabelColor")?a.color||b("defaultEdgeColor"):b("defaultEdgeLabelColor");return e.setAttributeNS(null,"data-label-target",a.id),e.setAttributeNS(null,"class",b("classPrefix")+"-label"),e.setAttributeNS(null,"font-size",f),e.setAttributeNS(null,"font-family",b("font")),e.setAttributeNS(null,"fill",g),e.innerHTML=a.label,e.textContent=a.label,e},update:function(a,b,c,d,e){var f,g=e("prefix")||"",h=a[g+"size"],i=b[g+"size"],j=(Math.round((b[g+"x"]+c[g+"x"])/2),Math.round((b[g+"y"]+c[g+"y"])/2),b[g+"x"]),k=b[g+"y"],l=c[g+"x"],m=c[g+"y"],n=l-j,o=m-k,p=0,q=l>j?1:-1,r=0,s=.5,t={};"fixed"===e("labelSize")?e("defaultLabelSize"):e("labelSizeRatio")*h;if((e("forceLabels")||!(h<e("edgeLabelThreshold")))&&"string"==typeof a.label)return b.id===c.id?(t=sigma.utils.getSelfLoopControlPoints(j,k,i),f=sigma.utils.getPointOnBezierCurve(s,j,k,l,m,t.x1,t.y1,t.x2,t.y2)):(t=sigma.utils.getQuadraticControlPoint(j,k,l,m,a.cc),f=sigma.utils.getPointOnQuadraticCurve(s,j,k,l,m,t.x,t.y)),"auto"===e("edgeLabelAlignment")&&(p=-1-h,r=b.id===c.id?45:Math.atan2(o*q,n*q)*(180/Math.PI)),d.setAttributeNS(null,"x",f.x),d.setAttributeNS(null,"y",f.y),d.setAttributeNS(null,"transform","rotate("+r+" "+f.x+" "+f.y+") translate(0 "+p+")"),d.style.display="",this}}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.svg.edges.labels"),sigma.svg.edges.labels.curvedArrow=sigma.svg.edges.labels.curve}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.svg.edges.labels"),sigma.svg.edges.labels.def={create:function(a,b){var c=b("prefix")||"",d=a[c+"size"],e=document.createElementNS(b("xmlns"),"text"),f="fixed"===b("labelSize")?b("defaultLabelSize"):b("labelSizeRatio")*d,g="edge"===b("edgeLabelColor")?a.color||b("defaultEdgeColor"):b("defaultEdgeLabelColor");return e.setAttributeNS(null,"data-label-target",a.id),e.setAttributeNS(null,"class",b("classPrefix")+"-label"),e.setAttributeNS(null,"font-size",f),e.setAttributeNS(null,"font-family",b("font")),e.setAttributeNS(null,"fill",g),e.innerHTML=a.label,e.textContent=a.label,e},update:function(a,b,c,d,e){var f,g,h,i=e("prefix")||"",j=a[i+"size"],k=Math.round((b[i+"x"]+c[i+"x"])/2),l=Math.round((b[i+"y"]+c[i+"y"])/2),m=0,n=0;"fixed"===e("labelSize")?e("defaultLabelSize"):e("labelSizeRatio")*j;if(b.id!==c.id&&(e("forceLabels")||!(j<e("edgeLabelThreshold")))&&"string"==typeof a.label)return"auto"===e("edgeLabelAlignment")&&(f=c[i+"x"]-b[i+"x"],g=c[i+"y"]-b[i+"y"],h=b[i+"x"]<c[i+"x"]?1:-1,n=Math.atan2(g*h,f*h)*(180/Math.PI),m=Math.round(-1-j)),d.setAttributeNS(null,"x",k),d.setAttributeNS(null,"y",l),d.setAttributeNS(null,"transform","rotate("+n+" "+k+" "+l+") translate(0 "+m+")"),d.style.display="",this}}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma.renderers.glyphs: sigma not in scope.";sigma.utils.pkg("sigma.settings");var b={glyphScale:.5,glyphFillColor:"white",glyphTextColor:"black",glyphStrokeColor:"black",glyphLineWidth:2,glyphFont:"Arial",glyphFontStyle:"normal",glyphFontScale:1,glyphTextThreshold:7,glyphStrokeIfText:!1,glyphThreshold:1,drawGlyphs:!0};sigma.settings=sigma.utils.extend(sigma.settings||{},b)}.call(this),function(a){"use strict";function b(a){return a*Math.PI/180}function c(a,b){return"function"==typeof a?a.call(b):a}function d(a){function d(a,b){if(a.draw&&a.x&&a.y&&a.radius>a.threshold){var c=a.x,d=a.y;switch(a.position){case"top-right":c+=a.nodeSize*A,d+=a.nodeSize*B;break;case"top-left":c+=a.nodeSize*y,d+=a.nodeSize*z;break;case"bottom-left":c+=a.nodeSize*w,d+=a.nodeSize*x;break;case"bottom-right":c+=a.nodeSize*u,d+=a.nodeSize*v}if(b.fillStyle=a.fillColor,a.strokeColor!==b.strokeStyle&&(b.strokeStyle=a.strokeColor),b.beginPath(),b.arc(c,d,a.radius,2*Math.PI,!1),b.closePath(),(!a.strokeIfText||a.radius>a.textThreshold)&&b.stroke(),b.fill(),a.radius>a.textThreshold){var e=Math.round(a.fontScale*a.radius),f=a.fontStyle+" "+e+"px "+a.font;f!==b.font&&(b.font=f),b.fillStyle=a.textColor,b.fillText(a.content,c,d)}}}a=a||{};var e=a.font||this.settings("glyphFont"),f=a.fontStyle||this.settings("glyphFontStyle"),g=a.fontScale||this.settings("glyphFontScale"),h=a.strokeColor||this.settings("glyphStrokeColor"),i=a.lineWidth||this.settings("glyphLineWidth"),j=a.fillColor||this.settings("glyphFillColor"),k=a.scale||this.settings("glyphScale"),l=a.textColor||this.settings("glyphTextColor"),m=a.textThreshold||this.settings("glyphTextThreshold"),n="strokeIfText"in a?a.strokeIfText:this.settings("glyphStrokeIfText"),o=a.threshold||this.settings("glyphThreshold"),p="draw"in a?a.draw:this.settings("drawGlyphs");if(p){this.domElements.glyphs||(this.initDOM("canvas","glyphs"),this.domElements.glyphs.width=this.container.offsetWidth,this.domElements.glyphs.height=this.container.offsetHeight,this.container.insertBefore(this.domElements.glyphs,this.domElements.mouse)),this.drawingContext=this.domElements.glyphs.getContext("2d"),this.drawingContext.textAlign="center",this.drawingContext.textBaseline="middle",this.drawingContext.lineWidth=i,this.drawingContext.strokeStyle=h;var q,r=this,s=this.nodesOnScreen||[],t=this.options.prefix||"",u=Math.cos(b(45)),v=Math.sin(b(45)),w=Math.cos(b(135)),x=Math.sin(b(135)),y=Math.cos(b(225)),z=Math.sin(b(225)),A=Math.cos(b(315)),B=Math.sin(b(315));s.forEach(function(a){a.glyphs&&a.glyphs.forEach(function(b){q=!a.hidden,q&&"draw"in b&&(q=b.draw),d({x:a[t+"x"],y:a[t+"y"],nodeSize:a[t+"size"]||0,position:b.position,radius:b.size||a[t+"size"]*k,content:(b.content||"").toString()||"",lineWidth:b.lineWidth||i,fillColor:c(b.fillColor,a)||j,textColor:c(b.textColor,a)||l,strokeColor:c(b.strokeColor,a)||h,strokeIfText:"strokeIfText"in b?b.strokeIfText:n,fontStyle:b.fontStyle||f,font:b.font||e,fontScale:b.fontScale||g,threshold:b.threshold||o,textThreshold:b.textThreshold||m,draw:q},r.drawingContext)})})}}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.renderers.canvas.prototype.glyphs=d}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw new Error("sigma not in scope.");sigma.utils.pkg("sigma.settings");var b={nodeHaloColor:"#fff",nodeHaloStroke:!1,nodeHaloStrokeColor:"#000",nodeHaloStrokeWidth:.5,nodeHaloSize:50,nodeHaloClustering:!1,nodeHaloClusteringMaxRadius:1e3,edgeHaloColor:"#fff",edgeHaloSize:10,drawHalo:!0};sigma.settings=sigma.utils.extend(sigma.settings||{},b)}.call(this),function(a){"use strict";function b(){for(var a=[],b=-1,c=arguments.length;++b<c;){var d=arguments[b];a.push(d)}var e=a[0],f=-1,g=e?e.length:0,h=[];a:for(;++f<g;)if(d=e[f],h.indexOf(d)<0){for(var b=c;--b;)if(a[b].indexOf(d)<0)continue a;h.push(d)}return h}function c(a,b,c){for(var d=0;d<a.length;d++)null!=a[d]&&(b.beginPath(),b.arc(a[d].x,a[d].y,a[d].radius,0,2*Math.PI,!0),b.closePath(),c?b.stroke():b.fill())}function d(a,b,c){if(c=c||Number.POSITIVE_INFINITY,a.length>1)for(var d,e,f,g=!0;g;){g=!1;for(var h=0;h<a.length;h++)if(null!==a[h])for(var i=h+1;i<a.length;i++)if(null!==a[i]&&(e=sigma.utils.getDistance(a[h].x,a[h].y,a[i].x,a[i].y),c>e&&e<a[h].radius+a[i].radius)){g=!0,f=[{x:a[h].x,y:a[h].y,radius:a[h].radius},{x:a[i].x,y:a[i].y,radius:a[i].radius}],a[h].points&&(f=f.concat(a[h].points)),a[i].points&&(f=f.concat(a[i].points)),d={x:0,y:0};for(var j=0;j<f.length;j++)d.x+=f[j].x,d.y+=f[j].y;d.x/=f.length,d.y/=f.length,d.radius=Math.max.apply(null,f.map(function(a){return b+sigma.utils.getDistance(d.x,d.y,a.x,a.y)})),a.push({x:d.x,y:d.y,radius:d.radius,
points:f}),a[h]=a[i]=null;break}}return a}function e(a){a=a||{},this.domElements.background||(this.initDOM("canvas","background"),this.domElements.background.width=this.container.offsetWidth,this.domElements.background.height=this.container.offsetHeight,this.container.insertBefore(this.domElements.background,this.container.firstChild));var e,f,g,h,i,j,k,l,m,n,o=this,p=o.contexts.background,q=this instanceof sigma.renderers.webgl,r=o.options.prefix,s=q?r.substr(5):r,t=a.nodeHaloClustering||o.settings("nodeHaloClustering"),u=a.nodeHaloClusteringMaxRadius||o.settings("nodeHaloClusteringMaxRadius"),v=a.nodeHaloColor||o.settings("nodeHaloColor"),w=a.nodeHaloSize||o.settings("nodeHaloSize"),x=a.nodeHaloStroke||o.settings("nodeHaloStroke"),y=a.nodeHaloStrokeColor||o.settings("nodeHaloStrokeColor"),z=a.nodeHaloStrokeWidth||o.settings("nodeHaloStrokeWidth"),A=o.settings("nodeBorderSize")||0,B=o.settings("nodeOuterBorderSize")||0,C=a.edgeHaloColor||o.settings("edgeHaloColor"),D=a.edgeHaloSize||o.settings("edgeHaloSize"),E=a.drawHalo||o.settings("drawHalo"),F=a.nodes||[],G=a.edges||[];E&&(F=q?F:b(a.nodes,o.nodesOnScreen),G=q?G:b(a.edges,o.edgesOnScreen),p.clearRect(0,0,p.canvas.width,p.canvas.height),p.save(),p.strokeStyle=C,G.forEach(function(a){e=o.graph.nodes(a.source),f=o.graph.nodes(a.target),p.lineWidth=(a[r+"size"]||1)+D,p.beginPath(),g={},h=e[s+"size"],i=e[s+"x"],j=e[s+"y"],k=f[s+"x"],l=f[s+"y"],p.moveTo(i,j),"curve"===a.type||"curvedArrow"===a.type?a.source===a.target?(g=sigma.utils.getSelfLoopControlPoints(i,j,h),p.bezierCurveTo(g.x1,g.y1,g.x2,g.y2,k,l)):(g=sigma.utils.getQuadraticControlPoint(i,j,k,l,a.cc),p.quadraticCurveTo(g.x,g.y,k,l)):(p.moveTo(i,j),p.lineTo(k,l)),p.stroke(),p.closePath()}),p.fillStyle=v,x&&(p.lineWidth=z,p.strokeStyle=y),m=A+B+w,n=F.filter(function(a){return!a.hidden}).map(function(a){return{x:a[s+"x"],y:a[s+"y"],radius:a[s+"size"]+m}}),t&&(n=d(n,m,u)),x&&c(n,p,!0),c(n,p),p.restore())}if("undefined"==typeof sigma)throw new Error("sigma not in scope.");sigma.renderers.canvas.prototype.halo=e,sigma.renderers.webgl.prototype.halo=e}.call(this),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.arrow=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=e("edgeColor"),i=e("defaultNodeColor"),j=e("defaultEdgeColor"),k=e("edgeHoverLevel"),l=a[g+"size"]||1,m=c[g+"size"],n=b[g+"x"],o=b[g+"y"],p=c[g+"x"],q=c[g+"y"];l=a.hover?e("edgeHoverSizeRatio")*l:l;var r=Math.max(2.5*l,e("minArrowSize")),s=Math.sqrt(Math.pow(p-n,2)+Math.pow(q-o,2)),t=n+(p-n)*(s-r-m)/s,u=o+(q-o)*(s-r-m)/s,v=(p-n)*r/s,w=(q-o)*r/s;if(k)switch(d.shadowOffsetX=0,k){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!f)switch(h){case"source":f=b.color||i;break;case"target":f=c.color||i;break;default:f=j}f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,d.strokeStyle=f,d.lineWidth=l,d.beginPath(),d.moveTo(n,o),d.lineTo(t,u),d.stroke(),d.fillStyle=f,d.beginPath(),d.moveTo(t+v,u+w),d.lineTo(t+.6*w,u-.6*v),d.lineTo(t-.6*w,u+.6*v),d.lineTo(t+v,u+w),d.closePath(),d.fill(),k&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.arrow&&(a.hover=!0,sigma.canvas.edges.labels.arrow(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.curve=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=e("edgeHoverSizeRatio")*(a[g+"size"]||1),i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel"),m={},n=b[g+"size"],o=b[g+"x"],p=b[g+"y"],q=c[g+"x"],r=c[g+"y"];if(m=b.id===c.id?sigma.utils.getSelfLoopControlPoints(o,p,n):sigma.utils.getQuadraticControlPoint(o,p,q,r,a.cc),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(o,p),b.id===c.id?d.bezierCurveTo(m.x1,m.y1,m.x2,m.y2,q,r):d.quadraticCurveTo(m.x,m.y,q,r),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.curve&&(a.hover=!0,sigma.canvas.edges.labels.curve(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.curvedArrow=function(a,b,c,d,e){var f,g,h,i,j,k,l=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,m=e("prefix")||"",n=e("edgeColor"),o=e("defaultNodeColor"),p=e("defaultEdgeColor"),q=e("edgeHoverLevel"),r={},s=e("edgeHoverSizeRatio")*(a[m+"size"]||1),t=c[m+"size"],u=b[m+"x"],v=b[m+"y"],w=c[m+"x"],x=c[m+"y"];if(r=b.id===c.id?sigma.utils.getSelfLoopControlPoints(u,v,t):sigma.utils.getQuadraticControlPoint(u,v,w,x,a.cc),b.id===c.id?(f=Math.sqrt(Math.pow(w-r.x1,2)+Math.pow(x-r.y1,2)),g=2.5*s,h=r.x1+(w-r.x1)*(f-g-t)/f,i=r.y1+(x-r.y1)*(f-g-t)/f,j=(w-r.x1)*g/f,k=(x-r.y1)*g/f):(f=Math.sqrt(Math.pow(w-r.x,2)+Math.pow(x-r.y,2)),g=Math.max(2.5*s,e("minArrowSize")),h=r.x+(w-r.x)*(f-g-t)/f,i=r.y+(x-r.y)*(f-g-t)/f,j=(w-r.x)*g/f,k=(x-r.y)*g/f),q)switch(d.shadowOffsetX=0,q){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!l)switch(n){case"source":l=b.color||o;break;case"target":l=c.color||o;break;default:l=p}if(l="edge"===e("edgeHoverColor")?a.hover_color||l:a.hover_color||e("defaultEdgeHoverColor")||l,d.strokeStyle=l,d.lineWidth=s,d.beginPath(),d.moveTo(u,v),b.id===c.id?d.bezierCurveTo(r.x2,r.y2,r.x1,r.y1,h,i):d.quadraticCurveTo(r.x,r.y,h,i),d.stroke(),d.fillStyle=l,d.beginPath(),d.moveTo(h+j,i+k),d.lineTo(h+.6*k,i-.6*j),d.lineTo(h-.6*k,i+.6*j),d.lineTo(h+j,i+k),d.closePath(),d.fill(),q&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.curvedArrow){a.hover=!0;var y=sigma.canvas.edges.labels.curvedArrow;(y.render||y)(a,b,c,d,e),a.hover=!1}}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.dashed=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel");if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio"),d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.setLineDash([8,3]),d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.def&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.def=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel");if(l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio"),d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.def&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.dotted=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel");if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio"),d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(d.setLineDash([2]),d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.def){a.hover=!0;var m=sigma.canvas.edges.labels.def;(m.render||m)(a,b,c,d,e),a.hover=!1}}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.parallel=function(a,b,c,d,e){var f,g,h=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,i=e("prefix")||"",j=a[i+"size"]||1,k=e("edgeColor"),l=e("defaultNodeColor"),m=e("defaultEdgeColor"),n=e("edgeHoverLevel"),o=b[i+"x"],p=b[i+"y"],q=c[i+"x"],r=c[i+"y"],s=sigma.utils.getDistance(o,p,q,r);if(!h)switch(k){case"source":h=b.color||l;break;case"target":h=c.color||l;break;default:h=m}if(h="edge"===e("edgeHoverColor")?a.hover_color||h:a.hover_color||e("defaultEdgeHoverColor")||h,j*=e("edgeHoverSizeRatio"),f=sigma.utils.getCircleIntersection(o,p,j,q,r,s),g=sigma.utils.getCircleIntersection(q,r,j,o,p,s),d.save(),n)switch(d.shadowOffsetX=0,n){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.strokeStyle=h,d.lineWidth=j,d.beginPath(),d.moveTo(f.xi,f.yi),d.lineTo(g.xi_prime,g.yi_prime),d.closePath(),d.stroke(),d.beginPath(),d.moveTo(f.xi_prime,f.yi_prime),d.lineTo(g.xi,g.yi),d.closePath(),d.stroke(),n&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.def&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edgehovers"),sigma.canvas.edgehovers.tapered=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),g=e("prefix")||"",j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=e("edgeHoverLevel"),m=b[g+"x"],n=b[g+"y"],o=c[g+"x"],p=c[g+"y"],q=sigma.utils.getDistance(m,n,o,p);if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}f="edge"===e("edgeHoverColor")?a.hover_color||f:a.hover_color||e("defaultEdgeHoverColor")||f,h*=e("edgeHoverSizeRatio");var r=sigma.utils.getCircleIntersection(m,n,h,o,p,q);if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}d.globalAlpha=.65,d.fillStyle=f,d.beginPath(),d.moveTo(o,p),d.lineTo(r.xi,r.yi),d.lineTo(r.xi_prime,r.yi_prime),d.closePath(),d.fill(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore(),sigma.canvas.edges.labels&&sigma.canvas.edges.labels.def&&(a.hover=!0,sigma.canvas.edges.labels.def(a,b,c,d,e),a.hover=!1)}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.arrow=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=e("edgeColor"),i=e("defaultNodeColor"),j=e("defaultEdgeColor"),k=a.active?e("edgeActiveLevel"):a.level,l=a[g+"size"]||1,m=c[g+"size"],n=b[g+"x"],o=b[g+"y"],p=c[g+"x"],q=c[g+"y"],r=Math.max(2.5*l,e("minArrowSize")),s=Math.sqrt(Math.pow(p-n,2)+Math.pow(q-o,2)),t=n+(p-n)*(s-r-m)/s,u=o+(q-o)*(s-r-m)/s,v=(p-n)*r/s,w=(q-o)*r/s;if(k)switch(d.shadowOffsetX=0,k){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!f)switch(h){case"source":f=b.color||i;break;case"target":f=c.color||i;break;default:f=j}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||j:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.lineWidth=l,d.beginPath(),d.moveTo(n,o),d.lineTo(t,u),d.stroke(),d.fillStyle=f,d.beginPath(),d.moveTo(t+v,u+w),d.lineTo(t+.6*w,u-.6*v),d.lineTo(t-.6*w,u+.6*v),d.lineTo(t+v,u+w),d.closePath(),d.fill(),k&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000")}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges");var a=function(a,b,c,d){if(d){var e=a*b/c;return{y:e?e:Number.POSITIVE_INFINITY}}var f=a/(b/2),e=a-f*c;return{y:e?1/e:b}};sigma.canvas.edges.autoCurve=function(b){var c,d=b.settings("autoCurveRatio"),e=b.settings("autoCurveSortByDirection"),f=b.settings("defaultEdgeType"),g=b.graph.edges(),h={key:function(a){var b=a.source+","+a.target;return this[b]?b:!e&&(b=a.target+","+a.source,this[b])?b:(e&&this[a.target+","+a.source]?this[b]={i:1,n:1}:this[b]={i:0,n:0},b)},inc:function(a){this[this.key(a)].n++}};g.forEach(function(a){h.inc(a)}),g.forEach(function(b){c=h.key(b),h[c].n>1||h[c].i>0?(b.cc||("arrow"===b.type||"tapered"===b.type||"arrow"===f||"tapered"===f?(b.cc_prev_type||(b.cc_prev_type=b.type),b.type="curvedArrow"):(b.cc_prev_type||(b.cc_prev_type=b.type),b.type="curve")),b.cc=a(d,h[c].n,h[c].i++,e)):b.cc&&(b.type=b.cc_prev_type,b.cc_prev_type=void 0,b.cc=void 0)})}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.curve=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level,m={},n=b[g+"size"],o=b[g+"x"],p=b[g+"y"],q=c[g+"x"],r=c[g+"y"];if(m=b.id===c.id?sigma.utils.getSelfLoopControlPoints(o,p,n):sigma.utils.getQuadraticControlPoint(o,p,q,r,a.cc),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(o,p),b.id===c.id?d.bezierCurveTo(m.x1,m.y1,m.x2,m.y2,q,r):d.quadraticCurveTo(m.x,m.y,q,r),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000")}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.curvedArrow=function(a,b,c,d,e){var f,g,h,i,j,k,l=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,m=e("prefix")||"",n=e("edgeColor"),o=e("defaultNodeColor"),p=e("defaultEdgeColor"),q=a.active?e("edgeActiveLevel"):a.level,r={},s=a[m+"size"]||1,t=c[m+"size"],u=b[m+"x"],v=b[m+"y"],w=c[m+"x"],x=c[m+"y"];if(r=b.id===c.id?sigma.utils.getSelfLoopControlPoints(u,v,t):sigma.utils.getQuadraticControlPoint(u,v,w,x,a.cc),b.id===c.id?(f=Math.sqrt(Math.pow(w-r.x1,2)+Math.pow(x-r.y1,2)),g=2.5*s,h=r.x1+(w-r.x1)*(f-g-t)/f,i=r.y1+(x-r.y1)*(f-g-t)/f,j=(w-r.x1)*g/f,k=(x-r.y1)*g/f):(f=Math.sqrt(Math.pow(w-r.x,2)+Math.pow(x-r.y,2)),g=Math.max(2.5*s,e("minArrowSize")),h=r.x+(w-r.x)*(f-g-t)/f,i=r.y+(x-r.y)*(f-g-t)/f,j=(w-r.x)*g/f,k=(x-r.y)*g/f),q)switch(d.shadowOffsetX=0,q){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!l)switch(n){case"source":l=b.color||o;break;case"target":l=c.color||o;break;default:l=p}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?l||p:e("defaultEdgeActiveColor"):d.strokeStyle=l,d.lineWidth=s,d.beginPath(),d.moveTo(u,v),b.id===c.id?d.bezierCurveTo(r.x2,r.y2,r.x1,r.y1,h,i):d.quadraticCurveTo(r.x,r.y,h,i),d.stroke(),d.fillStyle=l,d.beginPath(),d.moveTo(h+j,i+k),d.lineTo(h+.6*k,i-.6*j),d.lineTo(h-.6*k,i+.6*j),d.lineTo(h+j,i+k),d.closePath(),d.fill(),q&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000")}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.dashed=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level;if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.setLineDash([8,3]),d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.def=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level;if(l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000")}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.dotted=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level;if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.strokeStyle=f,d.setLineDash([2]),d.lineWidth=h,d.beginPath(),d.moveTo(b[g+"x"],b[g+"y"]),d.lineTo(c[g+"x"],c[g+"y"]),d.stroke(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.parallel=function(a,b,c,d,e){var f,g,h=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,i=e("prefix")||"",j=a[i+"size"]||1,k=e("edgeColor"),l=e("defaultNodeColor"),m=e("defaultEdgeColor"),n=a.active?e("edgeActiveLevel"):a.level,o=b[i+"x"],p=b[i+"y"],q=c[i+"x"],r=c[i+"y"],s=sigma.utils.getDistance(o,p,q,r);if(!h)switch(k){case"source":h=b.color||l;break;case"target":h=c.color||l;break;default:h=m}if(f=sigma.utils.getCircleIntersection(o,p,j,q,r,s),g=sigma.utils.getCircleIntersection(q,r,j,o,p,s),d.save(),n)switch(d.shadowOffsetX=0,n){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.strokeStyle="edge"===e("edgeActiveColor")?h||m:e("defaultEdgeActiveColor"):d.strokeStyle=h,d.lineWidth=j,d.beginPath(),d.moveTo(f.xi,f.yi),d.lineTo(g.xi_prime,g.yi_prime),d.closePath(),d.stroke(),d.beginPath(),d.moveTo(f.xi_prime,f.yi_prime),d.lineTo(g.xi,g.yi),d.closePath(),d.stroke(),n&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.edges"),sigma.canvas.edges.tapered=function(a,b,c,d,e){var f=a.active?a.active_color||e("defaultEdgeActiveColor"):a.color,g=e("prefix")||"",h=a[g+"size"]||1,i=e("edgeColor"),g=e("prefix")||"",j=e("defaultNodeColor"),k=e("defaultEdgeColor"),l=a.active?e("edgeActiveLevel"):a.level,m=b[g+"x"],n=b[g+"y"],o=c[g+"x"],p=c[g+"y"],q=sigma.utils.getDistance(m,n,o,p);if(!f)switch(i){case"source":f=b.color||j;break;case"target":f=c.color||j;break;default:f=k}var r=sigma.utils.getCircleIntersection(m,n,h,o,p,q);if(d.save(),l)switch(d.shadowOffsetX=0,l){case 1:d.shadowOffsetY=1.5,d.shadowBlur=4,d.shadowColor="rgba(0,0,0,0.36)";break;case 2:d.shadowOffsetY=3,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.39)";break;case 3:d.shadowOffsetY=6,d.shadowBlur=12,d.shadowColor="rgba(0,0,0,0.42)";break;case 4:d.shadowOffsetY=10,d.shadowBlur=20,d.shadowColor="rgba(0,0,0,0.47)";break;case 5:d.shadowOffsetY=15,d.shadowBlur=24,d.shadowColor="rgba(0,0,0,0.52)"}a.active?d.fillStyle="edge"===e("edgeActiveColor")?f||k:e("defaultEdgeActiveColor"):d.fillStyle=f,d.globalAlpha=.65,d.beginPath(),d.moveTo(o,p),d.lineTo(r.xi,r.yi),d.lineTo(r.xi_prime,r.yi_prime),d.closePath(),d.fill(),l&&(d.shadowOffsetY=0,d.shadowBlur=0,d.shadowColor="#000000"),d.restore()}}(),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.canvas.extremities"),sigma.canvas.extremities.def=function(a,b,c,d,e){(sigma.canvas.hovers[b.type]||sigma.canvas.hovers.def)(b,d,e),(sigma.canvas.hovers[c.type]||sigma.canvas.hovers.def)(c,d,e)}}.call(this),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.canvas.hovers"),sigma.canvas.hovers.def=function(a,b,c){function d(b){b.font=(h?h+" ":"")+o+"px "+(c("hoverFont")||c("font")),b.beginPath(),b.fillStyle="node"===c("labelHoverBGColor")?a.color||k:c("defaultHoverLabelBGColor"),a.label&&c("labelHoverShadow")&&(b.shadowOffsetX=0,b.shadowOffsetY=0,b.shadowBlur=8,b.shadowColor=c("labelHoverShadowColor"))}function e(a,b,d,e,f,g){var h=g>1&&f.length>1?.6*g*d:sigma.utils.canvas.getTextWidth(b,c("approximateLabelWidth"),d,f[0]),k=Math.round(e[i+"x"]),n=Math.round(e[i+"y"]),o=Math.round(h+4),p=p=(d+1)*f.length+4,q=Math.round(j+.25*d);if(e.label&&"string"==typeof e.label)switch(a){case"constrained":case"center":n=Math.round(e[i+"y"]-.5*d-2),b.rect(k-.5*o,n,o,p);break;case"left":k=Math.round(e[i+"x"]+.5*d+2),n=Math.round(e[i+"y"]-.5*d-2),o+=.5*j+.5*d,b.moveTo(k,n+q),b.arcTo(k,n,k-q,n,q),b.lineTo(k-o-l-m-q,n),b.lineTo(k-o-l-m-q,n+p),b.lineTo(k-q,n+p),b.arcTo(k,n+p,k,n+p-q,q),b.lineTo(k,n+q);break;case"top":b.rect(k-.5*o,n-q-p,o,p);break;case"bottom":b.rect(k-.5*o,n+q,o,p);break;case"inside":if(2*q>=h)break;case"right":default:k=Math.round(e[i+"x"]-.5*d-2),n=Math.round(e[i+"y"]-.5*d-2),o+=.5*j+.5*d,b.moveTo(k,n+q),b.arcTo(k,n,k+q,n,q),b.lineTo(k+o+l+m+q,n),b.lineTo(k+o+l+m+q,n+p),b.lineTo(k+q,n+p),b.arcTo(k,n+p,k,n+p-q,q),b.lineTo(k,n+q)}b.closePath(),b.fill(),b.shadowOffsetY=0,b.shadowBlur=0}function f(a,b){if(null==a)return[];if(1>=b)return[a];for(var c=a.split(" "),d=[],e=0,f=-1,h=[],i=!0,j=0;j<c.length;++j)if(i){if(c[j].length>b){for(var k=g(c[j],b),l=0;l<k.length;++l)d.push([k[l]]),++f;e=k[k.length-1].length}else d.push([c[j]]),++f,e=c[j].length+1;i=!1}else e+c[j].length<=b?(d[f].push(c[j]),e+=c[j].length+1):(i=!0,--j);for(j=0;j<d.length;++j)h.push(d[j].join(" "));return h}function g(a,b){for(var c=[],d=0;d<a.length;d+=b-1)c.push(a.substr(d,b-1)+"-");var e=c[c.length-1].length;return c[c.length-1]=c[c.length-1].substr(0,e-1)+" ",c}var h=c("hoverFontStyle")||c("fontStyle"),i=c("prefix")||"",j=a[i+"size"]||1,k=c("defaultNodeColor"),l=a.active?a.border_size||c("nodeActiveBorderSize")||c("nodeBorderSize"):a.border_size||c("nodeHoverBorderSize")||c("nodeBorderSize"),m=a.active?c("nodeActiveOuterBorderSize")||c("nodeOuterBorderSize"):c("nodeOuterBorderSize"),n=c("labelAlignment"),o="fixed"===c("labelSize")?c("defaultLabelSize"):c("labelSizeRatio")*j,p="node"===c("nodeHoverColor")?a.color||k:c("defaultNodeHoverColor"),q="default"===c("nodeHoverBorderColor")?c("defaultNodeHoverBorderColor")||c("defaultNodeBorderColor"):a.border_color||k,r=c("maxNodeLabelLineLength")||0,s=c("nodeHoverLevel"),t=f(a.label,r);if("center"!==n&&(d(b),e(n,b,o,a,t,r)),s)switch(b.shadowOffsetX=0,s){case 1:b.shadowOffsetY=1.5,b.shadowBlur=4,b.shadowColor="rgba(0,0,0,0.36)";break;case 2:b.shadowOffsetY=3,b.shadowBlur=12,b.shadowColor="rgba(0,0,0,0.39)";break;case 3:b.shadowOffsetY=6,b.shadowBlur=12,b.shadowColor="rgba(0,0,0,0.42)";break;case 4:b.shadowOffsetY=10,b.shadowBlur=20,b.shadowColor="rgba(0,0,0,0.47)";break;case 5:b.shadowOffsetY=15,b.shadowBlur=24,b.shadowColor="rgba(0,0,0,0.52)"}l>0&&(b.beginPath(),b.fillStyle="node"===c("nodeHoverBorderColor")?q:c("defaultNodeHoverBorderColor")||c("defaultNodeBorderColor"),b.arc(a[i+"x"],a[i+"y"],j+l,0,2*Math.PI,!0),b.closePath(),b.fill());var u=sigma.canvas.nodes[a.type]||sigma.canvas.nodes.def;if(u(a,b,c,{color:p}),s&&(b.shadowOffsetY=0,b.shadowBlur=0),"center"===n&&(d(b),e(n,b,o,a,t,r)),"string"==typeof a.label){b.fillStyle="node"===c("labelHoverColor")?a.color||k:c("defaultLabelHoverColor");var v,w=0,x=o/3,y=!0;switch(b.textAlign="center",n){case"bottom":x=+j+4*o/3;break;case"center":break;case"left":b.textAlign="right",w=-j-l-m-3;break;case"top":x=-j-2*o/3;break;case"constrained":v=sigma.utils.canvas.getTextWidth(a.label),v>2*(j+o/3)&&(y=!1);break;case"inside":if(v=sigma.utils.canvas.getTextWidth(a.label),2*(j+o/3)>=v)break;case"right":default:w=j+l+m+3,b.textAlign="left"}if(y)for(var z=a[i+"x"]+w,A=Math.round(a[i+"y"]+x),B=0;B<t.length;++B)b.fillText(t[B],z,A+B*(o+1))}}}.call(this),function(a){"use strict";function b(a,b){if(1>=b)return[a];for(var d=a.split(" "),e=[],f=0,g=-1,h=[],i=!0,j=0;j<d.length;++j)if(i){if(d[j].length>b){for(var k=c(d[j],b),l=0;l<k.length;++l)e.push([k[l]]),++g;f=k[k.length-1].length}else e.push([d[j]]),++g,f=d[j].length+1;i=!1}else f+d[j].length<=b?(e[g].push(d[j]),f+=d[j].length+1):(i=!0,--j);for(j=0;j<e.length;++j)h.push(e[j].join(" "));return h}function c(a,b){for(var c=[],d=0;d<a.length;d+=b-1)c.push(a.substr(d,b-1)+"-");var e=c[c.length-1].length;return c[c.length-1]=c[c.length-1].substr(0,e-1)+" ",c}if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.canvas.labels"),sigma.canvas.labels.def=function(a,c,d,e){var f,g,h,i,j=d("prefix")||"",k=a[j+"size"]||1,l=d(a.active?"activeFontStyle":"fontStyle"),m=a.active?(a.border_size||d("nodeActiveBorderSize")||d("nodeBorderSize"))+(d("nodeActiveOuterBorderSize")||d("nodeOuterBorderSize")):d("nodeBorderSize")+d("nodeOuterBorderSize"),n=d("maxNodeLabelLineLength")||0,o=!0,p=d("labelAlignment");if(!(k<=d("labelThreshold"))&&a.label&&"string"==typeof a.label){f="fixed"===d("labelSize")?d("defaultLabelSize"):d("labelSizeRatio")*k;var q=(l?l+" ":"")+f+"px "+(a.active?d("activeFont")||d("font"):d("font"));switch(e&&e.ctx.font!=q?(c.font=q,e.ctx.font=q):c.font=q,a.active?c.fillStyle="node"===d("labelActiveColor")?a.active_color||d("defaultNodeActiveColor"):d("defaultLabelActiveColor"):c.fillStyle="node"===d("labelColor")?a.color||d("defaultNodeColor"):d("defaultLabelColor"),h=0,i=f/3,c.textAlign="center",p){case"bottom":i=+k+4*f/3;break;case"center":break;case"left":c.textAlign="right",h=-k-m-3;break;case"top":i=-k-2*f/3;break;case"constrained":g=sigma.utils.canvas.getTextWidth(c,d("approximateLabelWidth"),f,a.label),g>2*(k+f/3)&&(o=!1);break;case"inside":if(g=sigma.utils.canvas.getTextWidth(c,d("approximateLabelWidth"),f,a.label),2*(k+f/3)>=g)break;case"right":default:h=k+m+3,c.textAlign="left"}if(o)for(var r=b(a.label,n),s=a[j+"x"]+h,t=Math.round(a[j+"y"]+i),u=0;u<r.length;++u)c.fillText(r[u],s,t+u*(f+1))}}}.call(this),function(){
"use strict";sigma.utils.pkg("sigma.canvas.nodes");var a=function(a,b,c,d,e){var f=a.cross&&a.cross.lineWeight||1;e.moveTo(b-d,c-f),e.lineTo(b-d,c+f),e.lineTo(b-f,c+f),e.lineTo(b-f,c+d),e.lineTo(b+f,c+d),e.lineTo(b+f,c+f),e.lineTo(b+d,c+f),e.lineTo(b+d,c-f),e.lineTo(b+f,c-f),e.lineTo(b+f,c-d),e.lineTo(b-f,c-d),e.lineTo(b-f,c-f)};sigma.canvas.nodes.cross=function(b,c,d,e){var f=e||{},g=d("prefix")||"",h=b[g+"size"]||1,i=b[g+"x"],j=b[g+"y"],k=d("defaultNodeColor"),l=d("imgCrossOrigin")||"anonymous",m=b.border_size||d("nodeBorderSize"),n=d("nodeOuterBorderSize"),o=b.border_size||d("nodeActiveBorderSize"),p=d("nodeActiveOuterBorderSize"),q=f.color||b.color||k,r="default"===d("nodeBorderColor")?d("defaultNodeBorderColor"):f.borderColor||b.border_color||k,s=b.active?d("nodeActiveLevel"):b.level;sigma.utils.canvas.setLevel(s,c),b.active?(q="node"===d("nodeActiveColor")?b.active_color||q:d("defaultNodeActiveColor")||q,p>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveOuterBorderColor")?q||k:d("defaultNodeActiveOuterBorderColor"),c.arc(i,j,h+o+p,0,2*Math.PI,!0),c.closePath(),c.fill()),o>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveBorderColor")?r:d("defaultNodeActiveBorderColor"),c.arc(i,j,h+o,0,2*Math.PI,!0),c.closePath(),c.fill())):(n>0&&(c.beginPath(),c.fillStyle="node"===d("nodeOuterBorderColor")?q||k:d("defaultNodeOuterBorderColor"),c.arc(i,j,h+m+n,0,2*Math.PI,!0),c.closePath(),c.fill()),m>0&&(c.beginPath(),c.fillStyle="node"===d("nodeBorderColor")?r:d("defaultNodeBorderColor"),c.arc(i,j,h+m,0,2*Math.PI,!0),c.closePath(),c.fill())),c.fillStyle=q,c.beginPath(),a(b,i,j,h,c),c.closePath(),c.fill(),sigma.utils.canvas.setLevel(s,c),b.image&&sigma.utils.canvas.drawImage(b,i,j,h,c,l,d("imageThreshold",a)),b.icon&&sigma.utils.canvas.drawIcon(b,i,j,h,c,d("iconThreshold"))}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.nodes");var a=function(a,b,c,d,e,f){a.beginPath(),a.strokeStyle=e,a.lineWidth=f,a.arc(b,c,d,0,2*Math.PI,!0),a.closePath(),a.stroke()};sigma.canvas.nodes.def=function(b,c,d,e){var f=e||{},g=d("prefix")||"",h=b[g+"size"]||1,i=b[g+"x"],j=b[g+"y"],k=d("defaultNodeColor"),l=d("imgCrossOrigin")||"anonymous",m=b.border_size||d("nodeBorderSize"),n=d("nodeOuterBorderSize"),o=b.border_size||d("nodeActiveBorderSize"),p=d("nodeActiveOuterBorderSize"),q=f.color||b.color||k,r="default"===d("nodeBorderColor")?d("defaultNodeBorderColor"):f.borderColor||b.border_color||b.color||k,s=b.active?d("nodeActiveLevel"):b.level;if(sigma.utils.canvas.setLevel(s,c),b.active?(q="node"===d("nodeActiveColor")?b.active_color||q:d("defaultNodeActiveColor")||q,p>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveOuterBorderColor")?q||k:d("defaultNodeActiveOuterBorderColor"),c.arc(i,j,h+o+p,0,2*Math.PI,!0),c.closePath(),c.fill()),o>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveBorderColor")?r:d("defaultNodeActiveBorderColor"),c.arc(i,j,h+o,0,2*Math.PI,!0),c.closePath(),c.fill())):(n>0&&(c.beginPath(),c.fillStyle="node"===d("nodeOuterBorderColor")?q||k:d("defaultNodeOuterBorderColor"),c.arc(i,j,h+m+n,0,2*Math.PI,!0),c.closePath(),c.fill()),m>0&&(c.beginPath(),c.fillStyle="node"===d("nodeBorderColor")?r:d("defaultNodeBorderColor"),c.arc(i,j,h+m,0,2*Math.PI,!0),c.closePath(),c.fill())),(!b.active||b.active&&"node"===d("nodeActiveColor"))&&b.colors&&b.colors.length){var t,u=b.colors.length,v=1/u,w=0;for(t=0;u>t;t++)c.fillStyle=b.colors[t],c.beginPath(),c.moveTo(i,j),c.arc(i,j,h,w,w+2*Math.PI*v,!1),c.lineTo(i,j),c.closePath(),c.fill(),w+=2*Math.PI*v;sigma.utils.canvas.resetLevel(c)}else c.fillStyle=q,c.beginPath(),c.arc(i,j,h,0,2*Math.PI,!0),c.closePath(),c.fill(),sigma.utils.canvas.resetLevel(c),!b.active&&m>0&&h>2*m&&a(c,i,j,h,r,m);b.image&&sigma.utils.canvas.drawImage(b,i,j,h,c,l,d("imageThreshold")),b.icon&&sigma.utils.canvas.drawIcon(b,i,j,h,c,d("iconThreshold"))}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.nodes");var a=function(a,b,c,d,e){e.moveTo(b-d,c),e.lineTo(b,c-d),e.lineTo(b+d,c),e.lineTo(b,c+d)};sigma.canvas.nodes.diamond=function(b,c,d,e){var f=e||{},g=d("prefix")||"",h=b[g+"size"]||1,i=b[g+"x"],j=b[g+"y"],k=d("defaultNodeColor"),l=d("imgCrossOrigin")||"anonymous",m=b.border_size||d("nodeBorderSize"),n=d("nodeOuterBorderSize"),o=b.border_size||d("nodeActiveBorderSize"),p=d("nodeActiveOuterBorderSize"),q=f.color||b.color||k,r="default"===d("nodeBorderColor")?d("defaultNodeBorderColor"):f.borderColor||b.border_color||k,s=b.active?d("nodeActiveLevel"):b.level;sigma.utils.canvas.setLevel(s,c),b.active?(q="node"===d("nodeActiveColor")?b.active_color||q:d("defaultNodeActiveColor")||q,p>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveOuterBorderColor")?q||k:d("defaultNodeActiveOuterBorderColor"),c.arc(i,j,h+o+p,0,2*Math.PI,!0),c.closePath(),c.fill()),o>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveBorderColor")?r:d("defaultNodeActiveBorderColor"),c.arc(i,j,h+o,0,2*Math.PI,!0),c.closePath(),c.fill())):(n>0&&(c.beginPath(),c.fillStyle="node"===d("nodeOuterBorderColor")?q||k:d("defaultNodeOuterBorderColor"),c.arc(i,j,h+m+n,0,2*Math.PI,!0),c.closePath(),c.fill()),m>0&&(c.beginPath(),c.fillStyle="node"===d("nodeBorderColor")?r:d("defaultNodeBorderColor"),c.arc(i,j,h+m,0,2*Math.PI,!0),c.closePath(),c.fill())),c.fillStyle=q,c.beginPath(),a(b,i,j,h,c),c.closePath(),c.fill(),s&&sigma.utils.canvas.resetLevel(c),b.image&&sigma.utils.canvas.drawImage(b,i,j,h,c,l,d("imageThreshold"),a),b.icon&&sigma.utils.canvas.drawIcon(b,i,j,h,c,d("iconThreshold"))}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.nodes");var a=function(a,b,c,d,e){var f=a.equilateral&&a.equilateral.numPoints||5,g=a.equilateral&&a.equilateral.rotate||0,h=d;g+=Math.PI/f,e.moveTo(b+h*Math.sin(g),c-h*Math.cos(g));for(var i=1;f>i;i++)e.lineTo(b+Math.sin(g+2*Math.PI*i/f)*h,c-Math.cos(g+2*Math.PI*i/f)*h)};sigma.canvas.nodes.equilateral=function(b,c,d,e){var f=e||{},g=d("prefix")||"",h=b[g+"size"]||1,i=b[g+"x"],j=b[g+"y"],k=d("defaultNodeColor"),l=d("imgCrossOrigin")||"anonymous",m=b.border_size||d("nodeBorderSize"),n=d("nodeOuterBorderSize"),o=b.border_size||d("nodeActiveBorderSize"),p=d("nodeActiveOuterBorderSize"),q=f.color||b.color||k,r="default"===d("nodeBorderColor")?d("defaultNodeBorderColor"):f.borderColor||b.border_color||k,s=b.active?d("nodeActiveLevel"):b.level;sigma.utils.canvas.setLevel(s,c),b.active?(q="node"===d("nodeActiveColor")?b.active_color||q:d("defaultNodeActiveColor")||q,p>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveOuterBorderColor")?q||k:d("defaultNodeActiveOuterBorderColor"),c.arc(i,j,h+o+p,0,2*Math.PI,!0),c.closePath(),c.fill()),o>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveBorderColor")?r:d("defaultNodeActiveBorderColor"),c.arc(i,j,h+o,0,2*Math.PI,!0),c.closePath(),c.fill())):(n>0&&(c.beginPath(),c.fillStyle="node"===d("nodeOuterBorderColor")?q||k:d("defaultNodeOuterBorderColor"),c.arc(i,j,h+m+n,0,2*Math.PI,!0),c.closePath(),c.fill()),m>0&&(c.beginPath(),c.fillStyle="node"===d("nodeBorderColor")?r:d("defaultNodeBorderColor"),c.arc(i,j,h+m,0,2*Math.PI,!0),c.closePath(),c.fill())),c.fillStyle=q,c.beginPath(),a(b,i,j,h,c),c.closePath(),c.fill(),s&&sigma.utils.canvas.resetLevel(c),b.image&&sigma.utils.canvas.drawImage(b,i,j,h,c,l,d("imageThreshold"),a),b.icon&&sigma.utils.canvas.drawIcon(b,i,j,h,c,d("iconThreshold"))}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.nodes");var a=function(a,b,c,d,e){var f=45*Math.PI/180;e.moveTo(b+d*Math.sin(f),c-d*Math.cos(f));for(var g=1;4>g;g++)e.lineTo(b+Math.sin(f+2*Math.PI*g/4)*d,c-Math.cos(f+2*Math.PI*g/4)*d)};sigma.canvas.nodes.square=function(b,c,d,e){var f=e||{},g=d("prefix")||"",h=b[g+"size"]||1,i=b[g+"x"],j=b[g+"y"],k=d("defaultNodeColor"),l=d("imgCrossOrigin")||"anonymous",m=b.border_size||d("nodeBorderSize"),n=d("nodeOuterBorderSize"),o=b.border_size||d("nodeActiveBorderSize"),p=d("nodeActiveOuterBorderSize"),q=f.color||b.color||k,r="default"===d("nodeBorderColor")?d("defaultNodeBorderColor"):f.borderColor||b.border_color||k,s=b.active?d("nodeActiveLevel"):b.level;sigma.utils.canvas.setLevel(s,c),b.active?(q="node"===d("nodeActiveColor")?b.active_color||q:d("defaultNodeActiveColor")||q,p>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveOuterBorderColor")?q||k:d("defaultNodeActiveOuterBorderColor"),c.arc(i,j,h+o+p,0,2*Math.PI,!0),c.closePath(),c.fill()),o>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveBorderColor")?r:d("defaultNodeActiveBorderColor"),c.arc(i,j,h+o,0,2*Math.PI,!0),c.closePath(),c.fill())):(n>0&&(c.beginPath(),c.fillStyle="node"===d("nodeOuterBorderColor")?q||k:d("defaultNodeOuterBorderColor"),c.arc(i,j,h+m+n,0,2*Math.PI,!0),c.closePath(),c.fill()),m>0&&(c.beginPath(),c.fillStyle="node"===d("nodeBorderColor")?r:d("defaultNodeBorderColor"),c.arc(i,j,h+m,0,2*Math.PI,!0),c.closePath(),c.fill())),c.fillStyle=q,c.beginPath(),a(b,i,j,h,c),c.closePath(),c.fill(),s&&sigma.utils.canvas.resetLevel(c),b.image&&sigma.utils.canvas.drawImage(b,i,j,h,c,l,d("imageThreshold"),a),b.icon&&sigma.utils.canvas.drawIcon(b,i,j,h,c,d("iconThreshold"))}}(),function(){"use strict";sigma.utils.pkg("sigma.canvas.nodes");var a=function(a,b,c,d,e){var f=a.star&&a.star.numPoints||5,g=a.star&&a.star.innerRatio||.5,h=d,i=d*g,j=Math.PI/f;e.moveTo(b,c-d);for(var k=0;f>k;k++)e.lineTo(b+Math.sin(j+2*Math.PI*k/f)*i,c-Math.cos(j+2*Math.PI*k/f)*i),e.lineTo(b+Math.sin(2*Math.PI*(k+1)/f)*h,c-Math.cos(2*Math.PI*(k+1)/f)*h)};sigma.canvas.nodes.star=function(b,c,d,e){var f=e||{},g=d("prefix")||"",h=b[g+"size"]||1,i=b[g+"x"],j=b[g+"y"],k=d("defaultNodeColor"),l=d("imgCrossOrigin")||"anonymous",m=b.border_size||d("nodeBorderSize"),n=d("nodeOuterBorderSize"),o=b.border_size||d("nodeActiveBorderSize"),p=d("nodeActiveOuterBorderSize"),q=f.color||b.color||k,r="default"===d("nodeBorderColor")?d("defaultNodeBorderColor"):f.borderColor||b.border_color||k,s=b.active?d("nodeActiveLevel"):b.level;sigma.utils.canvas.setLevel(s,c),b.active?(q="node"===d("nodeActiveColor")?b.active_color||q:d("defaultNodeActiveColor")||q,p>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveOuterBorderColor")?q||k:d("defaultNodeActiveOuterBorderColor"),c.arc(i,j,h+o+p,0,2*Math.PI,!0),c.closePath(),c.fill()),o>0&&(c.beginPath(),c.fillStyle="node"===d("nodeActiveBorderColor")?r:d("defaultNodeActiveBorderColor"),c.arc(i,j,h+o,0,2*Math.PI,!0),c.closePath(),c.fill())):(n>0&&(c.beginPath(),c.fillStyle="node"===d("nodeOuterBorderColor")?q||k:d("defaultNodeOuterBorderColor"),c.arc(i,j,h+m+n,0,2*Math.PI,!0),c.closePath(),c.fill()),m>0&&(c.beginPath(),c.fillStyle="node"===d("nodeBorderColor")?r:d("defaultNodeBorderColor"),c.arc(i,j,h+m,0,2*Math.PI,!0),c.closePath(),c.fill())),c.fillStyle=q,c.beginPath(),a(b,i,j,h,c),c.closePath(),c.fill(),s&&sigma.utils.canvas.resetLevel(c),b.image&&sigma.utils.canvas.drawImage(b,i,j,h,c,l,d("imageThreshold"),a),b.icon&&sigma.utils.canvas.drawIcon(b,i,j,h,c,d("iconThreshold"))}}(),function(a){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.utils.pkg("sigma.settings");var b={nodeBorderColor:"node,",nodeOuterBorderColor:"",nodeOuterBorderSize:0,defaultNodeOuterBorderColor:"#000",nodeHoverBorderSize:0,nodeHoverBorderColor:"node,",defaultNodeHoverBorderColor:"#000",nodeActiveBorderSize:0,nodeActiveBorderColor:"node,",defaultNodeActiveBorderColor:"#000",nodeActiveOuterBorderColor:"",nodeActiveOuterBorderSize:0,defaultNodeActiveOuterBorderColor:"#000",defaultLabelActiveColor:"#000",activeFont:"",activeFontStyle:"",labelActiveColor:"default",nodeActiveColor:"node",defaultNodeActiveColor:"rgb(236, 81, 72)",edgeActiveColor:"edge",defaultEdgeActiveColor:"rgb(236, 81, 72)",nodeActiveLevel:0,nodeHoverLevel:0,edgeActiveLevel:0,edgeHoverLevel:0,iconThreshold:8,imageThreshold:8,imgCrossOrigin:"anonymous"};sigma.settings=sigma.utils.extend(sigma.settings||{},b)}.call(this),function(){"use strict";sigma.utils.pkg("sigma.svg.edges"),sigma.svg.edges.tapered={create:function(a,b,c,d){var e=a.color,f=(d("prefix")||"",d("edgeColor")),g=d("defaultNodeColor"),h=d("defaultEdgeColor");if(!e)switch(f){case"source":e=b.color||g;break;case"target":e=c.color||g;break;default:e=h}var i=document.createElementNS(d("xmlns"),"polygon");return i.setAttributeNS(null,"data-edge-id",a.id),i.setAttributeNS(null,"class",d("classPrefix")+"-edge"),i.setAttributeNS(null,"fill",e),i.setAttributeNS(null,"fill-opacity",.6),i.setAttributeNS(null,"stroke-width",0),i},update:function(a,b,c,d,e){var f,g,h=e("prefix")||"",i=c[h+"x"],j=c[h+"y"],k=d[h+"x"],l=d[h+"y"],m=a[h+"size"]||1,n=sigma.utils.getDistance(i,j,k,l);if(n)return f=sigma.utils.getCircleIntersection(i,j,m,k,l,n),g=k+","+l+" "+f.xi+","+f.yi+" "+f.xi_prime+","+f.yi_prime,b.setAttributeNS(null,"points",g),b.style.display="",this}}}(),function(){"use strict";sigma.utils.pkg("sigma.webgl.edges"),sigma.webgl.edges.arrow={POINTS:9,ATTRIBUTES:11,addEdge:function(a,b,c,d,e,f,g){var h=(a[f+"size"]||1)/2,i=b[f+"x"],j=b[f+"y"],k=c[f+"x"],l=c[f+"y"],m=c[f+"size"],n=a.active?a.active_color||g("defaultEdgeActiveColor"):a.color;if(!n)switch(g("edgeColor")){case"source":n=b.color||g("defaultNodeColor");break;case"target":n=c.color||g("defaultNodeColor");break;default:n=g("defaultEdgeColor")}a.active&&(n="edge"===g("edgeActiveColor")?n||defaultEdgeColor:g("defaultEdgeActiveColor")),n=sigma.utils.floatColor(n),d[e++]=i,d[e++]=j,d[e++]=k,d[e++]=l,d[e++]=h,d[e++]=m,d[e++]=0,d[e++]=0,d[e++]=0,d[e++]=0,d[e++]=n,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=m,d[e++]=1,d[e++]=1,d[e++]=0,d[e++]=0,d[e++]=n,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=m,d[e++]=1,d[e++]=0,d[e++]=0,d[e++]=0,d[e++]=n,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=m,d[e++]=1,d[e++]=0,d[e++]=0,d[e++]=0,d[e++]=n,d[e++]=i,d[e++]=j,d[e++]=k,d[e++]=l,d[e++]=h,d[e++]=m,d[e++]=0,d[e++]=1,d[e++]=0,d[e++]=0,d[e++]=n,d[e++]=i,d[e++]=j,d[e++]=k,d[e++]=l,d[e++]=h,d[e++]=m,d[e++]=0,d[e++]=0,d[e++]=0,d[e++]=0,d[e++]=n,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=m,d[e++]=1,d[e++]=0,d[e++]=1,d[e++]=-1,d[e++]=n,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=m,d[e++]=1,d[e++]=0,d[e++]=1,d[e++]=0,d[e++]=n,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=m,d[e++]=1,d[e++]=0,d[e++]=1,d[e++]=1,d[e++]=n},render:function(a,b,c,d){var e,f=a.getAttribLocation(b,"a_pos1"),g=a.getAttribLocation(b,"a_pos2"),h=a.getAttribLocation(b,"a_thickness"),i=a.getAttribLocation(b,"a_tSize"),j=a.getAttribLocation(b,"a_delay"),k=a.getAttribLocation(b,"a_minus"),l=a.getAttribLocation(b,"a_head"),m=a.getAttribLocation(b,"a_headPosition"),n=a.getAttribLocation(b,"a_color"),o=a.getUniformLocation(b,"u_resolution"),p=a.getUniformLocation(b,"u_matrix"),q=a.getUniformLocation(b,"u_matrixHalfPi"),r=a.getUniformLocation(b,"u_matrixHalfPiMinus"),s=a.getUniformLocation(b,"u_ratio"),t=a.getUniformLocation(b,"u_nodeRatio"),u=a.getUniformLocation(b,"u_arrowHead"),v=a.getUniformLocation(b,"u_scale");e=a.createBuffer(),a.bindBuffer(a.ARRAY_BUFFER,e),a.bufferData(a.ARRAY_BUFFER,c,a.STATIC_DRAW),a.uniform2f(o,d.width,d.height),a.uniform1f(s,d.ratio/Math.pow(d.ratio,d.settings("edgesPowRatio"))),a.uniform1f(t,Math.pow(d.ratio,d.settings("nodesPowRatio"))/d.ratio),a.uniform1f(u,5),a.uniform1f(v,d.scalingRatio),a.uniformMatrix3fv(p,!1,d.matrix),a.uniformMatrix2fv(q,!1,sigma.utils.matrices.rotation(Math.PI/2,!0)),a.uniformMatrix2fv(r,!1,sigma.utils.matrices.rotation(-Math.PI/2,!0)),a.enableVertexAttribArray(f),a.enableVertexAttribArray(g),a.enableVertexAttribArray(h),a.enableVertexAttribArray(i),a.enableVertexAttribArray(j),a.enableVertexAttribArray(k),a.enableVertexAttribArray(l),a.enableVertexAttribArray(m),a.enableVertexAttribArray(n),a.vertexAttribPointer(f,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,0),a.vertexAttribPointer(g,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,8),a.vertexAttribPointer(h,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,16),a.vertexAttribPointer(i,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,20),a.vertexAttribPointer(j,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,24),a.vertexAttribPointer(k,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,28),a.vertexAttribPointer(l,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,32),a.vertexAttribPointer(m,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,36),a.vertexAttribPointer(n,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,40),a.drawArrays(a.TRIANGLES,d.start||0,d.count||c.length/this.ATTRIBUTES)},initProgram:function(a){var b,c,d;return b=sigma.utils.loadShader(a,["attribute vec2 a_pos1;","attribute vec2 a_pos2;","attribute float a_thickness;","attribute float a_tSize;","attribute float a_delay;","attribute float a_minus;","attribute float a_head;","attribute float a_headPosition;","attribute float a_color;","uniform vec2 u_resolution;","uniform float u_ratio;","uniform float u_nodeRatio;","uniform float u_arrowHead;","uniform float u_scale;","uniform mat3 u_matrix;","uniform mat2 u_matrixHalfPi;","uniform mat2 u_matrixHalfPiMinus;","varying vec4 color;","void main() {","vec2 pos = normalize(a_pos2 - a_pos1);","mat2 matrix = (1.0 - a_head) *","(","a_minus * u_matrixHalfPiMinus +","(1.0 - a_minus) * u_matrixHalfPi",") + a_head * (","a_headPosition * u_matrixHalfPiMinus * 0.6 +","(a_headPosition * a_headPosition - 1.0) * mat2(1.0)",");","pos = a_pos1 + (","(1.0 - a_head) * a_thickness * u_ratio * matrix * pos +","a_head * u_arrowHead * a_thickness * u_ratio * matrix * pos +","a_delay * pos * (","a_tSize / u_nodeRatio +","u_arrowHead * a_thickness * u_ratio",")",");","gl_Position = vec4(","((u_matrix * vec3(pos, 1)).xy /","u_resolution * 2.0 - 1.0) * vec2(1, -1),","0,","1",");","float c = a_color;","color.b = mod(c, 256.0); c = floor(c / 256.0);","color.g = mod(c, 256.0); c = floor(c / 256.0);","color.r = mod(c, 256.0); c = floor(c / 256.0); color /= 255.0;","color.a = 1.0;","}"].join("\n"),a.VERTEX_SHADER),c=sigma.utils.loadShader(a,["precision mediump float;","varying vec4 color;","void main(void) {","gl_FragColor = color;","}"].join("\n"),a.FRAGMENT_SHADER),d=sigma.utils.loadProgram(a,[b,c])}}}(),function(){"use strict";sigma.utils.pkg("sigma.webgl.edges"),sigma.webgl.edges.def={POINTS:6,ATTRIBUTES:7,addEdge:function(a,b,c,d,e,f,g){var h=(a[f+"size"]||1)/2,i=b[f+"x"],j=b[f+"y"],k=c[f+"x"],l=c[f+"y"],m=a.active?a.active_color||g("defaultEdgeActiveColor"):a.color;if(!m)switch(g("edgeColor")){case"source":m=b.color||g("defaultNodeColor");break;case"target":m=c.color||g("defaultNodeColor");break;default:m=g("defaultEdgeColor")}a.active&&(m="edge"===g("edgeActiveColor")?m||defaultEdgeColor:g("defaultEdgeActiveColor")),m=sigma.utils.floatColor(m),d[e++]=i,d[e++]=j,d[e++]=k,d[e++]=l,d[e++]=h,d[e++]=0,d[e++]=m,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=1,d[e++]=m,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=0,d[e++]=m,d[e++]=k,d[e++]=l,d[e++]=i,d[e++]=j,d[e++]=h,d[e++]=0,d[e++]=m,d[e++]=i,d[e++]=j,d[e++]=k,d[e++]=l,d[e++]=h,d[e++]=1,d[e++]=m,d[e++]=i,d[e++]=j,d[e++]=k,d[e++]=l,d[e++]=h,d[e++]=0,d[e++]=m},render:function(a,b,c,d){var e,f=a.getAttribLocation(b,"a_color"),g=a.getAttribLocation(b,"a_position1"),h=a.getAttribLocation(b,"a_position2"),i=a.getAttribLocation(b,"a_thickness"),j=a.getAttribLocation(b,"a_minus"),k=a.getUniformLocation(b,"u_resolution"),l=a.getUniformLocation(b,"u_matrix"),m=a.getUniformLocation(b,"u_matrixHalfPi"),n=a.getUniformLocation(b,"u_matrixHalfPiMinus"),o=a.getUniformLocation(b,"u_ratio"),p=a.getUniformLocation(b,"u_scale");e=a.createBuffer(),a.bindBuffer(a.ARRAY_BUFFER,e),a.bufferData(a.ARRAY_BUFFER,c,a.STATIC_DRAW),a.uniform2f(k,d.width,d.height),a.uniform1f(o,d.ratio/Math.pow(d.ratio,d.settings("edgesPowRatio"))),a.uniform1f(p,d.scalingRatio),a.uniformMatrix3fv(l,!1,d.matrix),a.uniformMatrix2fv(m,!1,sigma.utils.matrices.rotation(Math.PI/2,!0)),a.uniformMatrix2fv(n,!1,sigma.utils.matrices.rotation(-Math.PI/2,!0)),a.enableVertexAttribArray(f),a.enableVertexAttribArray(g),a.enableVertexAttribArray(h),a.enableVertexAttribArray(i),a.enableVertexAttribArray(j),a.vertexAttribPointer(g,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,0),a.vertexAttribPointer(h,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,8),a.vertexAttribPointer(i,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,16),a.vertexAttribPointer(j,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,20),a.vertexAttribPointer(f,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,24),a.drawArrays(a.TRIANGLES,d.start||0,d.count||c.length/this.ATTRIBUTES)},initProgram:function(a){var b,c,d;return b=sigma.utils.loadShader(a,["attribute vec2 a_position1;","attribute vec2 a_position2;","attribute float a_thickness;","attribute float a_minus;","attribute float a_color;","uniform vec2 u_resolution;","uniform float u_ratio;","uniform float u_scale;","uniform mat3 u_matrix;","uniform mat2 u_matrixHalfPi;","uniform mat2 u_matrixHalfPiMinus;","varying vec4 color;","void main() {","vec2 position = a_thickness * u_ratio *","normalize(a_position2 - a_position1);","mat2 matrix = a_minus * u_matrixHalfPiMinus +","(1.0 - a_minus) * u_matrixHalfPi;","position = matrix * position + a_position1;","gl_Position = vec4(","((u_matrix * vec3(position, 1)).xy /","u_resolution * 2.0 - 1.0) * vec2(1, -1),","0,","1",");","float c = a_color;","color.b = mod(c, 256.0); c = floor(c / 256.0);","color.g = mod(c, 256.0); c = floor(c / 256.0);","color.r = mod(c, 256.0); c = floor(c / 256.0); color /= 255.0;","color.a = 1.0;","}"].join("\n"),a.VERTEX_SHADER),c=sigma.utils.loadShader(a,["precision mediump float;","varying vec4 color;","void main(void) {","gl_FragColor = color;","}"].join("\n"),a.FRAGMENT_SHADER),d=sigma.utils.loadProgram(a,[b,c])}}}(),function(){"use strict";sigma.utils.pkg("sigma.webgl.edges"),sigma.webgl.edges.fast={POINTS:2,ATTRIBUTES:3,addEdge:function(a,b,c,d,e,f,g){var h=((a[f+"size"]||1)/2,b[f+"x"]),i=b[f+"y"],j=c[f+"x"],k=c[f+"y"],l=a.active?a.active_color||g("defaultEdgeActiveColor"):a.color;if(!l)switch(g("edgeColor")){case"source":l=b.color||g("defaultNodeColor");break;case"target":l=c.color||g("defaultNodeColor");break;default:l=g("defaultEdgeColor")}a.active&&(l="edge"===g("edgeActiveColor")?l||defaultEdgeColor:g("defaultEdgeActiveColor")),l=sigma.utils.floatColor(l),d[e++]=h,d[e++]=i,d[e++]=l,d[e++]=j,d[e++]=k,d[e++]=l},render:function(a,b,c,d){var e,f=a.getAttribLocation(b,"a_color"),g=a.getAttribLocation(b,"a_position"),h=a.getUniformLocation(b,"u_resolution"),i=a.getUniformLocation(b,"u_matrix");e=a.createBuffer(),a.bindBuffer(a.ARRAY_BUFFER,e),a.bufferData(a.ARRAY_BUFFER,c,a.DYNAMIC_DRAW),a.uniform2f(h,d.width,d.height),a.uniformMatrix3fv(i,!1,d.matrix),a.enableVertexAttribArray(g),a.enableVertexAttribArray(f),a.vertexAttribPointer(g,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,0),a.vertexAttribPointer(f,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,8),a.lineWidth(3),a.drawArrays(a.LINES,d.start||0,d.count||c.length/this.ATTRIBUTES)},initProgram:function(a){var b,c,d;return b=sigma.utils.loadShader(a,["attribute vec2 a_position;","attribute float a_color;","uniform vec2 u_resolution;","uniform mat3 u_matrix;","varying vec4 color;","void main() {","gl_Position = vec4(","((u_matrix * vec3(a_position, 1)).xy /","u_resolution * 2.0 - 1.0) * vec2(1, -1),","0,","1",");","float c = a_color;","color.b = mod(c, 256.0); c = floor(c / 256.0);","color.g = mod(c, 256.0); c = floor(c / 256.0);","color.r = mod(c, 256.0); c = floor(c / 256.0); color /= 255.0;","color.a = 1.0;","}"].join("\n"),a.VERTEX_SHADER),c=sigma.utils.loadShader(a,["precision mediump float;","varying vec4 color;","void main(void) {","gl_FragColor = color;","}"].join("\n"),a.FRAGMENT_SHADER),d=sigma.utils.loadProgram(a,[b,c])}}}(),function(){"use strict";sigma.utils.pkg("sigma.webgl.nodes"),sigma.webgl.nodes.def={POINTS:3,ATTRIBUTES:12,addNode:function(a,b,c,d,e){var f=this,g=a.color||e("defaultNodeColor"),h=e("imgCrossOrigin")||"anonymous";a.active&&(g="node"===e("nodeActiveColor")?a.active_color||g:e("defaultNodeActiveColor")||g);var i=sigma.utils.floatColor(g||e("defaultNodeColor"));"undefined"==typeof f.spriteSheet&&f.createSpriteSheet(e);var j=-1,k=.7,l=999,m=1,n=1,o=1,p=0;switch(a.type||"circle"){case"circle":case"disc":case"disk":o=1,l=999,k=1;break;case"square":o=0,l=4,k=.7,"undefined"!=typeof a.square&&"number"==typeof a.square.rotate&&(p=a.square.rotate);break;case"diamond":o=0,l=4,k=.7,p=45*Math.PI/180,"undefined"!=typeof a.diamond&&"number"==typeof a.diamond.rotate&&(p=a.diamond.rotate);break;case"triangle":o=0,l=3,k=.5,p=Math.PI,"undefined"!=typeof a.triangle&&"number"==typeof a.triangle.rotate&&(p=a.triangle.rotate);break;case"star":o=1,k=.7,l=5,"undefined"!=typeof a.star&&("number"==typeof a.star.numPoints&&(l=a.star.numPoints),"number"==typeof a.star.rotate&&(p=a.star.rotate));break;case"seastar":o=2,k=.5,l=5,"undefined"!=typeof a.seastar&&("number"==typeof a.seastar.numPoints&&(l=a.seastar.numPoints),"number"==typeof a.seastar.rotate&&(p=a.seastar.rotate));break;case"equilateral":o=0,l=7,k=.7,p=0,"undefined"!=typeof a.equilateral&&("number"==typeof a.equilateral.numPoints&&(l=a.equilateral.numPoints),"number"==typeof a.equilateral.rotate&&(p=a.equilateral.rotate));break;case"hexagon":o=0,l=6,k=.7,"undefined"!=typeof a.hexagon&&"number"==typeof a.hexagon.rotate&&(p=a.hexagon.rotate);break;case"polygon":o=1,l=5,k=.5,p=0,"undefined"!=typeof a.polygon&&("string"==typeof a.polygon.type&&(o="convex"==a.polygon.type?1:0),"number"==typeof a.polygon.angles&&(l=Math.round(Math.max(3,Math.min(8,a.polygon.angles)))),"number"==typeof a.polygon.scale&&(k=a.polygon.scale||(o?.5:.7)),"number"==typeof a.polygon.rotate&&(p=a.polygon.rotate));break;case"cross":o=0,l=9,k=.1,"undefined"!=typeof a.cross&&("number"==typeof a.cross.lineWeight&&(k=Math.max(.1,Math.min(.5,.1*a.cross.lineWeight))),"number"==typeof a.rotate&&(p=a.cross.rotate))}if("undefined"!=typeof a.image){var q=a.image.url||"";q.length>0&&(j=f.getImage(q,h),m=a.image.w||1,n=a.image.h||1)}if("undefined"!=typeof a.icon){var r="Arial";"string"==typeof a.icon.font&&(r=a.icon.font);var s="";"string"==typeof a.icon.content&&(s=a.icon.content);var t=.7;"number"==typeof a.icon.scale&&(t=.5*Math.abs(Math.max(.01,a.icon.scale)));var u=a.icon.color||g,v=a.color||g,w=.5,x=.5;"number"==typeof a.icon.x&&(w=a.icon.x),"number"==typeof a.icon.y&&(x=a.icon.y),j=f.getText(r,v,u,t,w,x,s)}b[c++]=a[d+"x"],b[c++]=a[d+"y"],b[c++]=a[d+"size"],b[c++]=i,b[c++]=0,b[c++]=o,b[c++]=l,b[c++]=k,b[c++]=p,b[c++]=j,b[c++]=m,b[c++]=n,b[c++]=a[d+"x"],b[c++]=a[d+"y"],b[c++]=a[d+"size"],b[c++]=i,b[c++]=2*Math.PI/3,b[c++]=o,b[c++]=l,b[c++]=k,b[c++]=p,b[c++]=j,b[c++]=m,b[c++]=n,b[c++]=a[d+"x"],b[c++]=a[d+"y"],b[c++]=a[d+"size"],b[c++]=i,b[c++]=4*Math.PI/3,b[c++]=o,b[c++]=l,b[c++]=k,b[c++]=p,b[c++]=j,b[c++]=m,b[c++]=n},render:function(a,b,c,d){var e,f=this;arguments;"undefined"==typeof f.spriteSheet&&f.createSpriteSheet();var g=a.getAttribLocation(b,"a_position"),h=a.getAttribLocation(b,"a_size"),i=a.getAttribLocation(b,"a_color"),j=a.getAttribLocation(b,"a_angle"),k=a.getAttribLocation(b,"a_image"),l=a.getAttribLocation(b,"a_shape"),m=a.getUniformLocation(b,"u_resolution"),n=a.getUniformLocation(b,"u_matrix"),o=a.getUniformLocation(b,"u_ratio"),p=a.getUniformLocation(b,"u_scale"),q=a.getUniformLocation(b,"u_sprite_dim"),r=a.getUniformLocation(b,"u_texture_dim");a.getUniformLocation(b,"u_sampler");e=a.createBuffer(),a.bindBuffer(a.ARRAY_BUFFER,e),a.bufferData(a.ARRAY_BUFFER,c,a.DYNAMIC_DRAW),a.uniform2f(m,d.width,d.height),a.uniform1f(o,1/Math.pow(d.ratio,d.settings("nodesPowRatio"))),a.uniform1f(p,d.scalingRatio),a.uniformMatrix3fv(n,!1,d.matrix),a.uniform2f(q,f.spriteSheet.spriteWidth,f.spriteSheet.spriteHeight),a.uniform2f(r,f.spriteSheet.maxWidth,f.spriteSheet.maxHeight),a.enableVertexAttribArray(g),a.enableVertexAttribArray(h),a.enableVertexAttribArray(i),a.enableVertexAttribArray(j),a.enableVertexAttribArray(l),a.enableVertexAttribArray(k),a.vertexAttribPointer(g,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,0),a.vertexAttribPointer(h,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,8),a.vertexAttribPointer(i,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,12),a.vertexAttribPointer(j,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,16),a.vertexAttribPointer(l,4,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,20),a.vertexAttribPointer(k,3,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,36),"undefined"==typeof f.texture&&(f.texture=a.createTexture(),a.activeTexture(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,f.texture),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,f.spriteSheet.canvas),a.blendFunc(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA),a.enable(a.BLEND),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.generateMipmap(a.TEXTURE_2D)),"undefined"!=typeof f.texture&&(a.activeTexture(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,f.texture),f.updateNeeded&&(f.updateNeeded=!1,a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,f.spriteSheet.canvas)),a.uniform1i(a.getUniformLocation(b,"u_sampler"),0)),a.drawArrays(a.TRIANGLES,d.start||0,d.count||c.length/this.ATTRIBUTES)},initProgram:function(a){var b,c,d;return b=sigma.utils.loadShader(a,["attribute vec2 a_position;","attribute float a_size;","attribute float a_color;","attribute float a_angle;","attribute vec4 a_shape;","attribute vec3 a_image;","uniform vec2 u_resolution;","uniform float u_ratio;","uniform float u_scale;","uniform mat3 u_matrix;","uniform vec2 u_sprite_dim;","uniform vec2 u_texture_dim;","varying vec4 shape;","varying highp vec4 v_sprite;","varying vec4 color;","varying vec2 center;","varying float radius;","varying vec3 image;","void main() {","radius = a_size * u_ratio;","vec2 position = (u_matrix * vec3(a_position, 1)).xy;","center = position * u_scale;","center = vec2(center.x, u_scale * u_resolution.y - center.y);","position = position +","2.0 * radius * vec2(cos(a_angle), sin(a_angle));","position = (position / u_resolution * 2.0 - 1.0) * vec2(1, -1);","radius = radius * u_scale;","shape = a_shape;","image = a_image;","highp vec2 sp = ","vec2(mod((a_image.s * u_sprite_dim.x), u_texture_dim.x),","floor((a_image.s * u_sprite_dim.x) / u_texture_dim.y) * u_sprite_dim.y);","sp = vec2(sp.x + (u_sprite_dim.x * 0.5),"," sp.y + (u_sprite_dim.y * 0.5));","v_sprite = vec4(","sp.x / u_texture_dim.x,","sp.y / u_texture_dim.y,","u_sprite_dim.x / u_texture_dim.x,","- u_sprite_dim.y / u_texture_dim.y",");","gl_Position = vec4(position, 0, 1);","float c = a_color;","color.b = mod(c, 256.0); c = floor(c / 256.0);","color.g = mod(c, 256.0); c = floor(c / 256.0);","color.r = mod(c, 256.0); c = floor(c / 256.0); color /= 255.0;","color.a = 1.0;","}"].join("\n"),a.VERTEX_SHADER),c=sigma.utils.loadShader(a,["#ifdef GL_ES","precision mediump float;","#endif","#define PI_2 6.283185307179586","#define MAX_ANGLES 8","varying vec4 shape;","varying highp vec4 v_sprite;","varying vec4 color;","varying vec2 center;","varying float radius;","varying vec3 image;","uniform sampler2D u_sampler;","void main(void) {","int angles = int(shape.t);","int convex = int(shape.s);","vec2 m = gl_FragCoord.xy - center;","vec2 p = m.xy/radius;","float theta = atan(p.y,p.x);","vec4 color0 = vec4(0.0, 0.0, 0.0, 0.0);","vec4 color1 = (image.s >= 0.0) ?"," texture2D(u_sampler, ","vec2(","(v_sprite.s + v_sprite.p * p.x * 0.5 * image.t),","(v_sprite.t + v_sprite.q * p.y * 0.5 * image.p)","))"," : color",";","mat2 shapeRot = mat2(cos(shape.q),sin(shape.q),-sin(shape.q),cos(shape.q));","p = p * shapeRot;","if (angles > 9) {","gl_FragColor = ","((radius - sqrt(m.x * m.x + m.y * m.y)) > 0.0)","? color1 : color0;","} else if (angles > 8){","gl_FragColor = (","(abs(p.x) > 0.0 && abs(p.x) < (1.0 - sin(shape.p)) && abs(p.y) < shape.p)","|| (abs(p.y) > 0.0 && abs(p.y) < (1.0 - sin(shape.p)) && abs(p.x) < shape.p)",") ? color1 : color0;","} else {","float scale = (convex > 0) ? shape.p * 0.5 : shape.p;","float angle = PI_2 / shape.t;","mat2 t = mat2(cos(angle),sin(angle),-sin(angle),cos(angle));","int q = 0;","for (int i=0;i<MAX_ANGLES;i++) {","if (i >= angles) break;","if (p.y < scale) q++;","p *= t;","}","gl_FragColor =","((convex > 0)","? (q > angles - (angles - 1) / 2)",": (q > angles - 1))","? color1 : color0;","}","}"].join("\n"),a.FRAGMENT_SHADER),
d=sigma.utils.loadProgram(a,[b,c])},createSpriteSheet:function(a){var b=this,c={maxWidth:a("spriteSheetResolution")||2048,maxHeight:a("spriteSheetResolution")||2048,maxSprites:a("spriteSheetMaxSprites")||256},d=c.maxWidth/Math.sqrt(c.maxSprites),e=c.maxHeight/Math.sqrt(c.maxSprites),f=document.createElement("canvas");f.width=c.maxWidth,f.height=c.maxHeight;f.getContext("2d");b.spriteSheet={canvas:f,maxWidth:c.maxWidth,maxHeight:c.maxHeight,maxSprites:c.maxSprite,spriteWidth:d,spriteHeight:e,currentIndex:1,urlToIndex:{}}},getText:function(a,b,c,d,e,f,g){var h=this,i=Math.round(d*h.spriteSheet.spriteHeight),j=e*h.spriteSheet.spriteWidth,k=f*h.spriteSheet.spriteHeight,l=a+":"+b+":"+c+":"+i+":"+g+":"+j+":"+k;if(l in h.spriteSheet.urlToIndex)return h.spriteSheet.urlToIndex[l];var m=h.spriteSheet.currentIndex;h.spriteSheet.currentIndex+=1,h.spriteSheet.urlToIndex[l]=m;var n=m*h.spriteSheet.spriteWidth%h.spriteSheet.maxWidth,o=Math.floor(m*h.spriteSheet.spriteWidth/h.spriteSheet.maxWidth)*h.spriteSheet.spriteHeight,p=h.spriteSheet.canvas.getContext("2d");return p.beginPath(),p.rect(n,o,h.spriteSheet.spriteWidth,h.spriteSheet.spriteHeight),p.fillStyle=b,p.fill(),p.beginPath(),p.fillStyle=c,p.font=""+i+"px "+a,p.textAlign="center",p.textBaseline="middle",p.fillText(g,n+j,o+k),h.updateNeeded=!0,m},getImage:function(a,b){var c=this,d=c.spriteSheet.canvas.getContext("2d");if(a.length<1)return-1;if(a in c.spriteSheet.urlToIndex)return c.spriteSheet.urlToIndex[a];var e=c.spriteSheet.currentIndex;if(e>c.spriteSheet.maxSprites)return-1;c.spriteSheet.currentIndex+=1,c.spriteSheet.urlToIndex[a]=e;var f=new Image;return f.setAttribute("crossOrigin",b),f.onload=function(){var a=e*c.spriteSheet.spriteWidth%c.spriteSheet.maxWidth,b=Math.floor(e*c.spriteSheet.spriteWidth/c.spriteSheet.maxWidth)*c.spriteSheet.spriteHeight;d.drawImage(f,0,0,f.width,f.height,a,b,c.spriteSheet.spriteWidth,c.spriteSheet.spriteHeight),c.updateNeeded=!0},f.src=a,e}}}(),function(){"use strict";sigma.utils.pkg("sigma.webgl.nodes"),sigma.webgl.nodes.fast={POINTS:1,ATTRIBUTES:4,addNode:function(a,b,c,d,e){var f=a.color||e("defaultNodeColor");a.active&&(f="node"===e("nodeActiveColor")?a.active_color||f:e("defaultNodeActiveColor")||f),f=sigma.utils.floatColor(f||e("defaultNodeColor")),b[c++]=a[d+"x"],b[c++]=a[d+"y"],b[c++]=a[d+"size"]||1,b[c++]=sigma.utils.floatColor(f||e("defaultNodeColor"))},render:function(a,b,c,d){var e,f=a.getAttribLocation(b,"a_position"),g=a.getAttribLocation(b,"a_size"),h=a.getAttribLocation(b,"a_color"),i=a.getUniformLocation(b,"u_resolution"),j=a.getUniformLocation(b,"u_matrix"),k=a.getUniformLocation(b,"u_ratio"),l=a.getUniformLocation(b,"u_scale");e=a.createBuffer(),a.bindBuffer(a.ARRAY_BUFFER,e),a.bufferData(a.ARRAY_BUFFER,c,a.DYNAMIC_DRAW),a.uniform2f(i,d.width,d.height),a.uniform1f(k,1/Math.pow(d.ratio,d.settings("nodesPowRatio"))),a.uniform1f(l,d.scalingRatio),a.uniformMatrix3fv(j,!1,d.matrix),a.enableVertexAttribArray(f),a.enableVertexAttribArray(g),a.enableVertexAttribArray(h),a.vertexAttribPointer(f,2,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,0),a.vertexAttribPointer(g,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,8),a.vertexAttribPointer(h,1,a.FLOAT,!1,this.ATTRIBUTES*Float32Array.BYTES_PER_ELEMENT,12),a.drawArrays(a.POINTS,d.start||0,d.count||c.length/this.ATTRIBUTES)},initProgram:function(a){var b,c,d;return b=sigma.utils.loadShader(a,["attribute vec2 a_position;","attribute float a_size;","attribute float a_color;","uniform vec2 u_resolution;","uniform float u_ratio;","uniform float u_scale;","uniform mat3 u_matrix;","varying vec4 color;","void main() {","gl_Position = vec4(","((u_matrix * vec3(a_position, 1)).xy /","u_resolution * 2.0 - 1.0) * vec2(1, -1),","0,","1",");","gl_PointSize = a_size * u_ratio * u_scale * 2.0;","float c = a_color;","color.b = mod(c, 256.0); c = floor(c / 256.0);","color.g = mod(c, 256.0); c = floor(c / 256.0);","color.r = mod(c, 256.0); c = floor(c / 256.0); color /= 255.0;","color.a = 1.0;","}"].join("\n"),a.VERTEX_SHADER),c=sigma.utils.loadShader(a,["precision mediump float;","varying vec4 color;","void main(void) {","gl_FragColor = color;","}"].join("\n"),a.FRAGMENT_SHADER),d=sigma.utils.loadProgram(a,[b,c])}}}(),function(){"use strict";if("undefined"==typeof sigma)throw"sigma is not declared";sigma.classes.graph.addMethod("HITS",function(a){var b={},c=1e-4,d=[],e=[],f=this.nodes(),g=(f.length,{});a||(a=!1);for(var h in f)a?(d.push(f[h]),e.push(f[h])):(this.degree(f[h].id,"out")>0&&d.push(f[h]),this.degree(f[h].id,"in")>0&&e.push(f[h])),b[f[h].id]={authority:1,hub:1};for(var i;;){i=!0;var j=0,k=0;for(var h in e){g[e[h].id]={authority:1,hub:0};var l=[];l=a?this.allNeighborsIndex.get(e[h].id).keyList():this.inNeighborsIndex.get(e[h].id).keyList();for(var m in l)m!=e[h].id&&(g[e[h].id].authority+=b[l[m]].hub);j+=g[e[h].id].authority}for(var h in d){g[d[h].id]?g[d[h].id].hub=1:g[d[h].id]={authority:0,hub:1};var l=[];l=a?this.allNeighborsIndex.get(d[h].id).keyList():this.outNeighborsIndex.get(d[h].id).keyList();for(var m in l)m!=d[h].id&&(g[d[h].id].hub+=b[l[m]].authority);k+=g[d[h].id].hub}for(var h in e)g[e[h].id].authority/=j,Math.abs((g[e[h].id].authority-b[e[h].id].authority)/b[e[h].id].authority)>=c&&(i=!1);for(var h in d)g[d[h].id].hub/=k,Math.abs((g[d[h].id].hub-b[d[h].id].hub)/b[d[h].id].hub)>=c&&(i=!1);if(b=g,g={},i)break}return b})}.call(window),function(a){"use strict";if("undefined"==typeof sigma)throw new Error("sigma not in scope.");sigma.utils.pkg("sigma.plugins");var b=function(b,c){function d(a){var b={};return a.forEach(function(a,c){b[a]=!0}),Object.keys(b)}function e(a){var b=[];for(var c in a)a.hasOwnProperty(c)&&b.push(a[c]);return b}function f(a,b){var c=a._assoc_mat[b]?Object.keys(a._assoc_mat[b]):[],d=0;return c.forEach(function(c,e){var f=a._assoc_mat[b][c]||1;b==c&&(f*=2),d+=f}),d}function g(a,b){if("undefined"==typeof a._assoc_mat[b])return[];var c=Object.keys(a._assoc_mat[b]);return c}function h(b,c,d){return b._assoc_mat[c]?b._assoc_mat[c][d]:a}function i(a){var b=0;return a.edges.forEach(function(a){b+=a.weight}),b}function j(a,b){l(a,b);var c=a.edges.map(function(a){return a.source+"_"+a.target}).indexOf(b.source+"_"+b.target);-1!=c?a.edges[c].weight=b.weight:a.edges.push(b)}function k(a){var b={};return a.forEach(function(a,c){b[a.source]=b[a.source]||{},b[a.source][a.target]=a.weight,b[a.target]=b[a.target]||{},b[a.target][a.source]=a.weight}),b}function l(a,b){a._assoc_mat[b.source]=a._assoc_mat[b.source]||{},a._assoc_mat[b.source][b.target]=b.weight,a._assoc_mat[b.target]=a._assoc_mat[b.target]||{},a._assoc_mat[b.target][b.source]=b.weight}function m(a){if(null==a||"object"!=typeof a)return a;var b=a.constructor();for(var c in a)b[c]=m(a[c]);return b}function n(a,b,c){b.nodes_to_com={},b.total_weight=0,b.internals={},b.degrees={},b.gdegrees={},b.loops={},b.total_weight=i(a),"undefined"==typeof c?a.nodes.forEach(function(c,d){b.nodes_to_com[c]=d;var e=f(a,c);if(0>e)throw new Error("A node has a negative degree. Use positive weights.");b.degrees[d]=e,b.gdegrees[c]=e,b.loops[c]=h(a,c,c)||0,b.internals[d]=b.loops[c]}):a.nodes.forEach(function(d,e){var h=c[d];b.nodes_to_com[d]=h;var i=f(a,d);b.degrees[h]=(b.degrees[h]||0)+i,b.gdegrees[d]=i;var j=0,k=g(a,d);k.forEach(function(b,e){var f=a._assoc_mat[d][b];if(0>=f)throw new Error("A node has a negative degree. Use positive weights.");c[b]==h&&(j+=b==d?f:f/2)}),b.internals[h]=(b.internals[h]||0)+j})}function o(a){var b=a.total_weight,c=0,f=d(e(a.nodes_to_com));return f.forEach(function(d,e){var f=a.internals[d]||0,g=a.degrees[d]||0;b>0&&(c=c+f/b-Math.pow(g/(2*b),2))}),c}function p(a,b,c){var d={},e=g(b,a);return e.forEach(function(e,f){if(e!=a){var g=b._assoc_mat[a][e]||1,h=c.nodes_to_com[e];d[h]=(d[h]||0)+g}}),d}function q(a,b,c,d){d.nodes_to_com[a]=+b,d.degrees[b]=(d.degrees[b]||0)+(d.gdegrees[a]||0),d.internals[b]=(d.internals[b]||0)+c+(d.loops[a]||0)}function r(a,b,c,d){d.degrees[b]=(d.degrees[b]||0)-(d.gdegrees[a]||0),d.internals[b]=(d.internals[b]||0)-c-(d.loops[a]||0),d.nodes_to_com[a]=-1}function s(a){var b=0,c=m(a),d={},e=Object.keys(a);return e.forEach(function(e){var f=a[e],g="undefined"==typeof d[f]?-1:d[f];-1==g&&(d[f]=b,g=b,b+=1),c[e]=g}),c}function t(a,b){for(var c=!0,d=0,e=o(b),f=e;c&&d!=z&&(e=f,c=!1,d+=1,a.nodes.forEach(function(d,e){var f=b.nodes_to_com[d],g=(b.gdegrees[d]||0)/(2*b.total_weight),h=p(d,a,b);r(d,f,h[f]||0,b);var i=f,j=0,k=Object.keys(h);k.forEach(function(a,c){var d=h[a]-(b.degrees[a]||0)*g;d>j&&(j=d,i=a)}),q(d,i,h[i]||0,b),i!=f&&(c=!0)}),f=o(b),!(A>f-e)););}function u(a,b){var c,f,g={nodes:[],edges:[],_assoc_mat:{}},i=e(a);return g.nodes=g.nodes.concat(d(i)),b.edges.forEach(function(b,d){f=b.weight||1;var e=a[b.source],i=a[b.target];c=h(g,e,i)||0;var k=c+f;j(g,{source:e,target:i,weight:k})}),g}function v(a,b){for(var c=m(a[0]),d=1;b+1>d;d++)Object.keys(c).forEach(function(b,e){var f=b,g=c[b];c[f]=a[d][g]});return c}function w(a,b){if(0==a.edges.length){var c={};return a.nodes.forEach(function(a,b){c[a]=a}),c}var d={};n(x,d,b);var e=o(d),f=[];t(x,d);var g=o(d),h=s(d.nodes_to_com);f.push(h),e=g;var i=u(h,x);for(n(i,d);;){if(t(i,d),g=o(d),A>g-e)break;h=s(d.nodes_to_com),f.push(h),e=g,i=u(h,i),n(i,d)}return f}var x,y,z=-1,A=1e-7,B={},C=[];x={nodes:b.nodes().map(function(a){return a.id}),edges:b.edges(),_assoc_mat:k(b.edges())},y=c;var D={};return D.run=function(a){return y=a||y,B={},C=w(x,y),this},D.countLevels=function(){return C.length-1},D.getPartitions=function(b){if(b!==a&&(0>b||b>C.length-1))throw new RangeError('Invalid argument: "level" is not between 0 and '+C.length-1+" included.");return v(C,b||C.length-1)},D.countPartitions=function(a){return 1+Math.max.apply(null,Object.keys(a).map(function(b){return a[b]}))},D.setResults=function(a){var c=this,d=a||{},e=this.getPartitions(d.level);return b.nodes().forEach(function(a){"function"==typeof d.setter?(c.setter=d.setter,c.setter.call(a,e[a.id])):"function"==typeof c.setter?c.setter.call(a,e[a.id]):a._louvain=e[a.id]}),this},D};sigma.plugins.louvain=function(a,c){var d=c||{},e=b(a,d.partitions).run();return e.setResults({level:e.countLevels(),setter:d.setter}),e}}.call(this);
//# sourceMappingURL=plugins.min.js.map