---
name: Bug Report
about: Create a report to help us improve
title: 'Bug: '
labels: bug, triage
assignees: ''
---

## Description:

*A clear and concise description of the bug you're encountering.*

### Are you intending to fix this bug?

*Please indicate "yes" or "no".*

## Component(s) Affected:

<!-- Please remove any that don't apply. -->

- UI
- API
- Neo4j
- PostgreSQL
- Data Collector (SharpHound, AzureHound)
- Other (tooling, documentation, etc.)

## Steps to Reproduce:

1. Go to [specific page or endpoint]
2. Click on [button/element/etc.]
3. Enter [input/data]
4. See error at [this point]

## Expected Behavior:

*A description of what you expected to happen.*

## Actual Behavior:

*A description of what actually happened.*

## Screenshots/Code Snippets/Sample Files:

*If applicable, add screenshots, relevant code snippets, or sample files that help illustrate the issue.*

## Environment Information:

<!-- Please use proper version numbers instead of `latest` -->

BloodHound: [BloodHound version or revision]

Collector: [SharpHound version / AzureHound version]

OS: [your OS and version]

Browser (if UI related): [browser name and version]

Node.js (if UI related: [Node.js version]

Go (if API related): [Go version]

Database (if persistence related): [Neo4j version / PostgreSQL version]

Docker (if using Docker): [docker version]

## Additional Information:

*Any additional context or information that might be helpful in understanding and diagnosing the issue.*

## Potential Solution (optional):

*If you have any ideas about what might be causing the issue or how it could be fixed, you can share them here.*

## Related Issues:

*If you've found related issues in the project's issue tracker, mention them here.*

## Contributor Checklist:

<!-- Please remove items that don't apply. -->

- [ ] I have searched the issue tracker to ensure this bug hasn't been reported before or is not already being addressed.
- [ ] I have provided clear steps to reproduce the issue.
- [ ] I have included relevant environment information details.
- [ ] I have attached necessary supporting documents.
- [ ] I have checked that any JSON files I am attempting to upload to BloodHound are valid.
