///////////////////////////////////////////////////////////////////////////////
// BOSSA
//
// Copyright (c) 2011-2018, ShumaTech
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the <organization> nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
///////////////////////////////////////////////////////////////////////////////
#ifndef _OPTION_H
#define _OPTION_H

#include <string>
#include <stdio.h>

typedef enum
{
    ArgNone,
    ArgOptional,
    ArgRequired
} ArgHas;

typedef enum
{
    ArgInt,
    ArgString
} ArgType;

typedef struct
{
    ArgHas has;
    ArgType type;
    const char* name;
    union
    {
        void* voidPtr;
        int* intPtr;
        std::string* strPtr;
    } value;
} OptArg;

typedef struct
{
    char letter;
    const char* name;
    bool* present;
    OptArg arg;
    const char* help;
} Option;

class CmdOpts
{
public:
    CmdOpts(int argc, char* argv[], int numOpts, Option* opts);
    virtual ~CmdOpts();

    void usage(FILE* out);
    int parse();

private:
    int _argc;
    char** _argv;
    int _numOpts;
    Option* _opts;

    int find(char letter);
};

#endif // _OPTION_H
