/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.filter.insn;

import eu.bibl.banalysis.filter.Filter;
import eu.bibl.banalysis.filter.InstructionFilter;
import eu.bibl.banalysis.filter.OpcodeFilter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

public class SwitchInstructionFilter
implements InstructionFilter {
    protected OpcodeFilter opcodeFilter;
    protected List<Filter<Object>> filters;

    public SwitchInstructionFilter(int opcode) {
        this(new OpcodeFilter(opcode));
    }

    public SwitchInstructionFilter(int opcode, List<Filter<Object>> filters) {
        this(new OpcodeFilter(opcode), filters);
    }

    public SwitchInstructionFilter(OpcodeFilter opcodeFilter) {
        this(opcodeFilter, new ArrayList<Filter<Object>>());
    }

    public SwitchInstructionFilter(OpcodeFilter opcodeFilter, List<Filter<Object>> filters) {
        this.opcodeFilter = opcodeFilter;
        this.filters = filters;
    }

    public SwitchInstructionFilter addFilter(Filter<Object> filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public boolean accept(AbstractInsnNode t) {
        if (!(t instanceof LookupSwitchInsnNode) && !(t instanceof TableSwitchInsnNode)) {
            return false;
        }
        if (!this.opcodeFilter.accept(t)) {
            return false;
        }
        for (Filter<Object> filter : this.filters) {
            if (filter.accept(t)) continue;
            return false;
        }
        return true;
    }
}

