/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.task.RunStatistics;
import org.jkiss.dbeaver.registry.task.TaskRunImpl;

public class TaskUtils {
    private static final Log log = Log.getLog(TaskUtils.class);
    static final String RUN_LOG_PREFIX = "run_";
    static final String RUN_LOG_EXT = "log";

    public static List<TaskRunImpl> loadRunStatistics(Path metaFile, Gson gson) {
        if (!Files.exists(metaFile, new LinkOption[0])) {
            return new ArrayList<TaskRunImpl>();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = Files.newBufferedReader(metaFile);){
                RunStatistics statistics = (RunStatistics)gson.fromJson((Reader)reader, RunStatistics.class);
                if (statistics == null) {
                    log.error((Object)"Null task run statistics returned");
                    return new ArrayList<TaskRunImpl>();
                }
                return statistics.getRuns();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading task run statistics", (Throwable)e);
            return new ArrayList<TaskRunImpl>();
        }
    }

    public static String buildRunLogFileName(String runId) {
        return RUN_LOG_PREFIX + runId + "." + RUN_LOG_EXT;
    }
}

