/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.tasks.nativetool.ExportSettingsExtension;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseBackupSettings
extends PostgreBackupRestoreSettings
implements ExportSettingsExtension<PostgreDatabaseBackupInfo> {
    private static final Log log = Log.getLog(PostgreDatabaseBackupSettings.class);
    private List<PostgreDatabaseBackupInfo> exportObjects = new ArrayList<PostgreDatabaseBackupInfo>();
    private String compression;
    private String encoding;
    private boolean showViews;
    private boolean useInserts;
    private boolean noPrivileges;
    private boolean noOwner;
    private boolean dropObjects;
    private boolean outputFolderNeedsToBeRecreated;
    private boolean createDatabase;
    private File outputFolder;

    @NotNull
    public List<PostgreDatabaseBackupInfo> getExportObjects() {
        return this.exportObjects;
    }

    public void setExportObjects(List<PostgreDatabaseBackupInfo> exportObjects) {
        this.exportObjects = exportObjects;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isShowViews() {
        return this.showViews;
    }

    public void setShowViews(boolean showViews) {
        this.showViews = showViews;
    }

    public boolean isUseInserts() {
        return this.useInserts;
    }

    public void setUseInserts(boolean useInserts) {
        this.useInserts = useInserts;
    }

    public boolean isNoPrivileges() {
        return this.noPrivileges;
    }

    public void setNoPrivileges(boolean noPrivileges) {
        this.noPrivileges = noPrivileges;
    }

    public boolean isNoOwner() {
        return this.noOwner;
    }

    public void setNoOwner(boolean noOwner) {
        this.noOwner = noOwner;
    }

    public boolean isDropObjects() {
        return this.dropObjects;
    }

    public void setDropObjects(boolean dropObjects) {
        this.dropObjects = dropObjects;
    }

    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    public void fillExportObjectsFromInput() {
        LinkedHashMap<PostgreDatabase, PostgreDatabaseBackupInfo> objMap = new LinkedHashMap<PostgreDatabase, PostgreDatabaseBackupInfo>();
        for (DBSObject object : this.getDatabaseObjects()) {
            PostgreDatabase database = null;
            PostgreSchema schema = null;
            if (object instanceof PostgreDatabase) {
                database = (PostgreDatabase)object;
            } else if (object instanceof PostgreSchema) {
                database = ((PostgreSchema)object).getDatabase();
                schema = (PostgreSchema)object;
            } else if (object instanceof PostgreTableBase) {
                database = ((PostgreTableBase)object).getDatabase();
                schema = ((PostgreTableBase)object).getSchema();
            }
            if (database == null) continue;
            PostgreDatabaseBackupInfo info = objMap.computeIfAbsent(database, db -> new PostgreDatabaseBackupInfo((PostgreDatabase)db, null, null));
            if (schema != null) {
                List<PostgreSchema> schemas = info.getSchemas();
                if (schemas == null) {
                    schemas = new ArrayList<PostgreSchema>();
                    info.setSchemas(schemas);
                }
                if (!schemas.contains(schema)) {
                    schemas.add(schema);
                }
            }
            if (!(object instanceof PostgreTableBase)) continue;
            List<PostgreTableBase> tables = info.getTables();
            if (tables == null) {
                tables = new ArrayList<PostgreTableBase>();
                info.setTables(tables);
            }
            tables.add((PostgreTableBase)object);
        }
        this.getExportObjects().addAll(objMap.values());
        this.updateDataSourceContainer();
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        List objectList;
        super.loadSettings(runnableContext, store);
        this.compression = store.getString("pg.export.compression");
        this.encoding = store.getString("pg.export.encoding");
        this.showViews = store.getBoolean("pg.export.showViews");
        this.useInserts = store.getBoolean("pg.export.useInserts");
        this.noPrivileges = store.getBoolean("pg.export.noPrivileges");
        this.noOwner = store.getBoolean("pg.export.noOwner");
        this.dropObjects = store.getBoolean("pg.export.dropObjects");
        this.createDatabase = store.getBoolean("pg.export.createDatabase");
        if (store instanceof DBPPreferenceMap && !CommonUtils.isEmpty((Collection)(objectList = (List)((DBPPreferenceMap)store).getObject("exportObjects")))) {
            for (Map object : objectList) {
                List tableNames;
                List schemaNames;
                PostgreDatabaseBackupInfo exportInfo;
                String catalogId = CommonUtils.toString(object.get("database"));
                if (CommonUtils.isEmpty((String)catalogId) || (exportInfo = this.loadDatabaseExportInfo(runnableContext, catalogId, schemaNames = (List)object.get("schemas"), tableNames = (List)object.get("tables"))) == null) continue;
                this.exportObjects.add(exportInfo);
            }
        }
    }

    private PostgreDatabaseBackupInfo loadDatabaseExportInfo(DBRRunnableContext runnableContext, String catalogId, List<String> schemaNames, List<String> tableNames) {
        PostgreDatabaseBackupInfo[] exportInfo = new PostgreDatabaseBackupInfo[1];
        try {
            runnableContext.run(true, true, monitor -> {
                try {
                    PostgreDatabase database = (PostgreDatabase)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)this.getProject(), (String)catalogId);
                    if (database == null) {
                        throw new DBException("Database " + catalogId + " not found");
                    }
                    ArrayList<PostgreSchema> schemas = null;
                    ArrayList<PostgreTableBase> tables = null;
                    if (!CommonUtils.isEmpty((Collection)schemaNames)) {
                        schemas = new ArrayList<PostgreSchema>();
                        for (String schemaName : schemaNames) {
                            PostgreSchema schema = database.getSchema(monitor, schemaName);
                            if (schema != null) {
                                schemas.add(schema);
                                continue;
                            }
                            log.debug((Object)("Schema '" + schemaName + "' not found in database '" + database.getName() + "'"));
                        }
                    }
                    if (!CommonUtils.isEmpty((Collection)tableNames) && !CommonUtils.isEmpty(schemas)) {
                        PostgreSchema schema = (PostgreSchema)schemas.get(0);
                        tables = new ArrayList<PostgreTableBase>();
                        for (String tableName : tableNames) {
                            PostgreTableBase table = (PostgreTableBase)schema.getTableCache().getObject(monitor, schema, tableName);
                            if (table != null) {
                                tables.add(table);
                                continue;
                            }
                            log.debug((Object)("Table '" + tableName + "' not found in schema '" + schema.getName() + "'"));
                        }
                    }
                    postgreDatabaseBackupInfoArray[0] = new PostgreDatabaseBackupInfo(database, schemas, tables);
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error loading objects configuration", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        return exportInfo[0];
    }

    @Override
    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        store.setValue("pg.export.compression", this.compression);
        store.setValue("pg.export.encoding", this.encoding);
        store.setValue("pg.export.showViews", this.showViews);
        store.setValue("pg.export.useInserts", this.useInserts);
        store.setValue("pg.export.noPrivileges", this.noPrivileges);
        store.setValue("pg.export.noOwner", this.noOwner);
        store.setValue("pg.export.dropObjects", this.dropObjects);
        store.setValue("pg.export.createDatabase", this.createDatabase);
        if (store instanceof DBPPreferenceMap && !CommonUtils.isEmpty(this.exportObjects)) {
            ArrayList objectList = new ArrayList();
            for (PostgreDatabaseBackupInfo object : this.exportObjects) {
                ArrayList<String> tableList;
                LinkedHashMap<String, Object> objInfo = new LinkedHashMap<String, Object>();
                objInfo.put("database", DBUtils.getObjectFullId((DBSObject)object.getDatabase()));
                if (!CommonUtils.isEmpty(object.getSchemas())) {
                    tableList = new ArrayList<String>();
                    for (PostgreSchema schema : object.getSchemas()) {
                        tableList.add(schema.getName());
                    }
                    objInfo.put("schemas", tableList);
                }
                if (!CommonUtils.isEmpty(object.getTables())) {
                    tableList = new ArrayList();
                    for (PostgreTableBase table : object.getTables()) {
                        tableList.add(table.getName());
                    }
                    objInfo.put("tables", tableList);
                }
                objectList.add(objInfo);
            }
            ((DBPPreferenceMap)store).getPropertyMap().put("exportObjects", objectList);
        }
    }

    @NotNull
    public File getOutputFile(@NotNull PostgreDatabaseBackupInfo info) {
        String outputFileName = this.resolveVars((DBSObjectContainer)info.getDatabase(), info.getSchemas(), info.getTables(), this.getOutputFilePattern());
        return new File(this.getOutputFolder(info), outputFileName);
    }

    @NotNull
    public File getOutputFolder(@NotNull PostgreDatabaseBackupInfo info) {
        if (this.outputFolder == null || this.outputFolderNeedsToBeRecreated) {
            this.outputFolder = new File(this.resolveVars((DBSObjectContainer)info.getDatabase(), info.getSchemas(), info.getTables(), this.getOutputFolderPattern()));
        }
        return this.outputFolder;
    }
}

