/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.txn;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.txn.TransactionInfoDialog;

public class TransactionLogDialog
extends TransactionInfoDialog {
    private static final String DIALOG_ID = "DBeaver.TransactionLogDialog";
    private final DBCExecutionContext context;
    private final boolean showPreviousTxn;

    private TransactionLogDialog(Shell parentShell, DBCExecutionContext context, IWorkbenchPart activeEditor, boolean showPreviousTxn) {
        super(parentShell, NLS.bind((String)CoreMessages.transaction_log_dialog_header_transaction_log, (Object)context.getDataSource().getContainer().getName(), (Object)context.getContextName()), activeEditor);
        this.context = context;
        this.showPreviousTxn = showPreviousTxn;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected DBCExecutionContext getCurrentContext() {
        return this.context;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        super.createTransactionLogPanel(composite);
        this.showPreviousCheck.setSelection(this.showPreviousTxn);
        this.updateTransactionFilter();
        return parent;
    }

    public static void showDialog(Shell shell, DBCExecutionContext executionContext) {
        TransactionLogDialog.showDialog(shell, executionContext, false);
    }

    public static void showDialog(Shell shell, DBCExecutionContext executionContext, boolean showPreviousTxn) {
        IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor == null) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.transaction_log_dialog_error_no_editor, CoreMessages.transaction_log_dialog_error_open_database);
        } else if (executionContext == null) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.transaction_log_dialog_error_not_connected, CoreMessages.transaction_log_dialog_error_connect_to_a_database);
        } else {
            TransactionLogDialog dialog = new TransactionLogDialog(shell, executionContext, (IWorkbenchPart)activeEditor, showPreviousTxn);
            dialog.setModeless(true);
            dialog.open();
        }
    }
}

