/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTaskUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.wizard.EditTaskVariablesDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskProcessorUI;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class TaskHandlerRun
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String taskId = event.getParameter("task");
        DBTTask task = null;
        if (!CommonUtils.isEmpty((String)taskId)) {
            task = NavigatorUtils.getSelectedProject().getTaskManager().getTaskById(taskId);
        } else {
            Object element;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DBTTask) {
                task = (DBTTask)element;
            }
        }
        if (task != null) {
            TaskHandlerRun.runTask(task);
        }
        return null;
    }

    public static void runTask(DBTTask task) {
        if (task.getType().supportsVariables() && !TaskHandlerRun.confirmTaskVariables(task)) {
            return;
        }
        try {
            TaskProcessorUI listener = new TaskProcessorUI(UIUtils.getDialogRunnableContext(), task);
            task.getProject().getTaskManager().runTask(task, (DBTTaskExecutionListener)listener, Collections.emptyMap());
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Task run", "Error running task '" + task.getName() + "'", (Throwable)e);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        DBTTask task;
        String taskId = CommonUtils.toString(parameters.get("task"));
        if (!CommonUtils.isEmpty((String)taskId) && (task = NavigatorUtils.getSelectedProject().getTaskManager().getTaskById(taskId)) != null) {
            DBPImage taskIcon = task.getType().getIcon();
            if (taskIcon == null) {
                taskIcon = DBIcon.TREE_TASK;
            }
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)taskIcon));
            element.setText(task.getName());
        }
    }

    private static boolean confirmTaskVariables(@NotNull DBTTask task) {
        Map properties = task.getProperties();
        if (CommonUtils.toBoolean(properties.get("promptTaskVariables"))) {
            Map variables = DBTaskUtils.getVariables((DBTTask)task);
            EditTaskVariablesDialog dialog = new EditTaskVariablesDialog(UIUtils.getActiveWorkbenchShell(), variables);
            if (dialog.open() != 0) {
                return false;
            }
            if (!variables.equals(dialog.getVariables())) {
                DBTaskUtils.setVariables((Map)properties, (Map)dialog.getVariables());
            }
        }
        return true;
    }
}

