/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSCheckConstraintContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;

public class SQLServerTable
extends SQLServerTableBase
implements DBPObjectStatistics,
DBSCheckConstraintContainer,
DBPReferentialIntegrityController {
    private static final Log log = Log.getLog(SQLServerTable.class);
    private static final String DISABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE ? NOCHECK CONSTRAINT ALL";
    private static final String ENABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE ? WITH CHECK CHECK CONSTRAINT ALL";
    private CheckConstraintCache checkConstraintCache = new CheckConstraintCache();
    private volatile transient List<SQLServerTableForeignKey> references;
    private volatile transient long totalBytes = -1L;
    private volatile transient long usedBytes = -1L;

    public SQLServerTable(SQLServerSchema schema) {
        super(schema);
    }

    public SQLServerTable(@NotNull SQLServerSchema catalog, @NotNull ResultSet dbResult, @NotNull String name) {
        super(catalog, dbResult, name);
    }

    public boolean isView() {
        return false;
    }

    @Override
    @Property(category="Statistics", viewable=false, expensive=true, order=30)
    public Long getRowCount(DBRProgressMonitor monitor) throws DBCException {
        this.readTableStats(monitor);
        return super.getRowCount(monitor);
    }

    @Property(viewable=true, category="Statistics", order=31)
    public long getTotalBytes(DBRProgressMonitor monitor) throws DBCException {
        this.readTableStats(monitor);
        return this.totalBytes;
    }

    @Property(viewable=true, category="Statistics", order=32)
    public long getUsedBytes(DBRProgressMonitor monitor) throws DBCException {
        this.readTableStats(monitor);
        return this.usedBytes;
    }

    @Nullable
    @Association
    public Collection<SQLServerTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getUniqueConstraintCache().getObjects(monitor, this.getSchema(), this);
    }

    @Nullable
    @Association
    public synchronized Collection<SQLServerTableCheckConstraint> getCheckConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.checkConstraintCache.getAllObjects(monitor, this);
    }

    public CheckConstraintCache getCheckConstraintCache() {
        return this.checkConstraintCache;
    }

    /*
     * Exception decompiling
     */
    @Association
    public List<SQLServerTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection<SQLServerTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getForeignKeyCache().getObjects(monitor, this.getSchema(), this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)this, options, (boolean)false);
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.onlyForeignKeys".equals(option) || "ddl.skipForeignKeys".equals(option) || "ddl.includeNestedObjects".equals(option);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.references = null;
        this.totalBytes = -1L;
        this.usedBytes = -1L;
        this.getSchema().resetTableStatistics();
        ((SQLServerSchema)this.getContainer()).getIndexCache().clearObjectCache(this);
        ((SQLServerSchema)this.getContainer()).getUniqueConstraintCache().clearObjectCache(this);
        ((SQLServerSchema)this.getContainer()).getForeignKeyCache().clearObjectCache(this);
        return super.refreshObject(monitor);
    }

    @Override
    boolean supportsTriggers() {
        return true;
    }

    public void setObjectDefinitionText(String source) {
    }

    public boolean hasStatistics() {
        return this.totalBytes != -1L;
    }

    public long getStatObjectSize() {
        return this.totalBytes;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readTableStats(DBRProgressMonitor monitor) throws DBCException {
        if (this.hasStatistics()) {
            return;
        }
        if (SQLServerUtils.isDriverBabelfish(((SQLServerDataSource)this.getDataSource()).getContainer().getDriver())) {
            this.setDefaultTableStats();
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table statistics");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = SQLServerUtils.prepareTableStatisticLoadStatement(session, (JDBCDataSource)this.getDataSource(), this.getDatabase(), this.getSchema().getObjectId(), (DBSTable)this, true);){
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchTableStats(dbResult);
                        } else {
                            this.setDefaultTableStats();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error reading table statistics", (Throwable)e);
        }
    }

    void fetchTableStats(JDBCResultSet dbResult) throws SQLException {
        this.rowCount = dbResult.getLong("rows");
        this.totalBytes = dbResult.getLong("totalSize") * 1024L;
        this.usedBytes = dbResult.getLong("usedSize") * 1024L;
    }

    void setDefaultTableStats() {
        this.totalBytes = 0L;
        this.usedBytes = 0L;
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) {
        return true;
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        String sql = this.getChangeReferentialIntegrityStatement(monitor, enable);
        sql = sql.replace("?", this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        try {
            JDBCUtils.executeInMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Changing referential integrity", (String)sql);
        }
        catch (SQLException e) {
            throw new DBException("Unable to change referential integrity", (Throwable)e);
        }
    }

    @NotNull
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        if (enable) {
            return ENABLE_REFERENTIAL_INTEGRITY_STATEMENT;
        }
        return DISABLE_REFERENTIAL_INTEGRITY_STATEMENT;
    }

    static class CheckConstraintCache
    extends JDBCObjectCache<SQLServerTable, SQLServerTableCheckConstraint> {
        CheckConstraintCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerTable table) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT c.* FROM " + SQLServerUtils.getSystemTableName(table.getDatabase(), "check_constraints") + " c WHERE c.parent_object_id=?");
            dbStat.setLong(1, table.getObjectId());
            return dbStat;
        }

        protected SQLServerTableCheckConstraint fetchObject(@NotNull JDBCSession session, @NotNull SQLServerTable table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerTableCheckConstraint(table, resultSet);
        }
    }
}

