/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class CustomToolTipHandler {
    private static final Log log = Log.getLog(CustomToolTipHandler.class);
    private final Control control;
    private ToolTipHandler toolTipHandler;
    private volatile String prevToolTip;
    private int toolTipDelay = 500;

    public CustomToolTipHandler(Control control) {
        this.control = control;
    }

    public int getToolTipDelay() {
        return this.toolTipDelay;
    }

    public void setToolTipDelay(int toolTipDelay) {
        this.toolTipDelay = toolTipDelay;
    }

    public void updateToolTipText(@Nullable String text) {
        if (text != null) {
            text = text.replace("&", "&&");
        }
        ToolTipHandler curHandler = this.toolTipHandler;
        if (!CommonUtils.equalObjects((Object)this.prevToolTip, (Object)text)) {
            if (curHandler != null) {
                curHandler.cancel();
            }
            this.prevToolTip = text;
            this.control.setToolTipText("");
            this.toolTipHandler = new ToolTipHandler();
            this.toolTipHandler.toolTip = text;
            this.toolTipHandler.schedule(this.toolTipDelay);
        }
    }

    private class ToolTipHandler
    extends UIJob {
        private String toolTip;

        ToolTipHandler() {
            super("ToolTip handler");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled() && !CustomToolTipHandler.this.control.isDisposed()) {
                CustomToolTipHandler.this.control.setToolTipText(this.toolTip);
            }
            CustomToolTipHandler.this.toolTipHandler = null;
            return Status.OK_STATUS;
        }
    }
}

