/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPropertiesControl;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DriverPropertiesDialogPage
extends ConnectionPageAbstract {
    private ConnectionPageAbstract hostPage;
    private ConnectionPropertiesControl propsControl;
    private PropertySourceCustom propertySource;
    private DBPConnectionConfiguration prevConnectionInfo = null;

    public DriverPropertiesDialogPage(ConnectionPageAbstract hostPage) {
        this.hostPage = hostPage;
        this.setTitle(UIConnectionMessages.dialog_setting_connection_driver_properties_title);
        this.setDescription(UIConnectionMessages.dialog_setting_connection_driver_properties_description);
    }

    public boolean isComplete() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.propsControl != null) {
            DBPDataSourceContainer activeDataSource = this.site.getActiveDataSource();
            if (this.prevConnectionInfo == activeDataSource.getConnectionConfiguration()) {
                return;
            }
            DBPConnectionConfiguration tmpConnectionInfo = new DBPConnectionConfiguration();
            DataSourceDescriptor tempDataSource = new DataSourceDescriptor(this.site.getDataSourceRegistry(), activeDataSource.getId(), activeDataSource.getDriver(), tmpConnectionInfo);
            this.hostPage.saveSettings((DBPDataSourceContainer)tempDataSource);
            tmpConnectionInfo.getProperties().putAll(activeDataSource.getConnectionConfiguration().getProperties());
            DBPDriverSubstitutionDescriptor driverSubstitution = activeDataSource.getDriverSubstitution();
            try {
                this.getSite().getRunnableContext().run(true, true, monitor -> {
                    monitor.beginTask("Loading driver properties", 1);
                    try {
                        this.propertySource = this.propsControl.makeProperties(monitor, this.getSite().getDriver(), tmpConnectionInfo, driverSubstitution);
                    }
                    finally {
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(e.getTargetException().getMessage());
            }
            catch (InterruptedException interruptedException) {}
            if (this.propertySource != null) {
                this.propsControl.loadProperties((DBPPropertySource)this.propertySource);
            }
            this.prevConnectionInfo = activeDataSource.getConnectionConfiguration();
            tempDataSource.dispose();
        }
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        if (this.propsControl != null) {
            this.propsControl.saveEditorValues();
        }
        if (this.propertySource != null) {
            Map properties = dataSource.getConnectionConfiguration().getProperties();
            properties.clear();
            for (Map.Entry entry : this.propertySource.getPropertyValues().entrySet()) {
                String propName = CommonUtils.toString(entry.getKey());
                if (propName.isEmpty()) continue;
                properties.put(propName, CommonUtils.toString(entry.getValue()));
            }
        }
    }

    public void createControl(Composite parent) {
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1);
        if (parent.getLayout() instanceof GridLayout) {
            ph.setLayoutData((Object)new GridData(1808));
        }
        this.propsControl = new ConnectionPropertiesControl(ph, 0);
        Object layoutData = this.propsControl.getTree().getLayoutData();
        if (layoutData == null) {
            layoutData = new GridData(1808);
        }
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).heightHint = 200;
        }
        Composite linksComposite = UIUtils.createComposite((Composite)ph, (int)3);
        linksComposite.setLayoutData((Object)new GridData(768));
        this.propsControl.createPropertiesToolBar(linksComposite);
        Control infoLabel = UIUtils.createInfoLabel((Composite)linksComposite, (String)UIConnectionMessages.dialog_setting_connection_driver_properties_advanced);
        GridData gd = new GridData(32);
        gd.grabExcessHorizontalSpace = true;
        infoLabel.setLayoutData((Object)gd);
        infoLabel.setToolTipText(UIConnectionMessages.dialog_setting_connection_driver_properties_advanced_tip);
        Link netConfigLink = new Link(linksComposite, 0);
        if (!CommonUtils.isEmpty((String)this.site.getDriver().getWebURL())) {
            netConfigLink.setText("<a>" + UIConnectionMessages.dialog_setting_connection_driver_properties_docs_web_reference + "</a>");
            netConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String url = DriverPropertiesDialogPage.this.site.getDriver().getPropertiesWebURL();
                    if (CommonUtils.isEmpty((String)url)) {
                        url = DriverPropertiesDialogPage.this.site.getDriver().getWebURL();
                    }
                    UIUtils.openWebBrowser((String)url);
                }
            });
        }
        netConfigLink.setLayoutData((Object)new GridData(128));
        this.setControl((Control)ph);
    }
}

